/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.auditlog;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogDestination;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogReportingComponent;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDescription;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDevelopmentStatus;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogDestination;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogReport;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditingComponent;
import org.odpi.openmetadata.repositoryservices.connectors.stores.auditlogstore.OMRSAuditLogRecord;
import org.odpi.openmetadata.repositoryservices.connectors.stores.auditlogstore.OMRSAuditLogReportingComponent;

public class OMRSAuditLog
extends AuditLog {
    private OMRSAuditLogDestination omrsDestination;
    private OMRSAuditLogReportingComponent omrsReportingComponent;

    public OMRSAuditLog(OMRSAuditLogDestination omrsDestination, int componentId, ComponentDevelopmentStatus componentDevelopmentStatus, String componentName, String componentDescription, String componentWikiURL) {
        super((AuditLogDestination)omrsDestination, componentId, componentDevelopmentStatus, componentName, componentDescription, componentWikiURL);
        this.omrsDestination = omrsDestination;
        this.omrsReportingComponent = new OMRSAuditLogReportingComponent(componentId, componentDevelopmentStatus, componentName, componentDescription, componentWikiURL);
    }

    public OMRSAuditLog(OMRSAuditLogDestination omrsDestination, OMRSAuditingComponent omrsReportingComponent) {
        super((AuditLogDestination)omrsDestination, (ComponentDescription)omrsReportingComponent);
        this.omrsDestination = omrsDestination;
        this.omrsReportingComponent = new OMRSAuditLogReportingComponent(omrsReportingComponent.getComponentId(), omrsReportingComponent.getComponentDevelopmentStatus(), omrsReportingComponent.getComponentName(), omrsReportingComponent.getComponentType(), omrsReportingComponent.getComponentWikiURL());
    }

    public OMRSAuditLog createNewAuditLog(int componentId, ComponentDevelopmentStatus componentDevelopmentStatus, String componentName, String componentDescription, String componentWikiURL) {
        OMRSAuditLog childAuditLog = new OMRSAuditLog(this.omrsDestination, componentId, componentDevelopmentStatus, componentName, componentDescription, componentWikiURL);
        this.childAuditLogs.add(childAuditLog);
        return childAuditLog;
    }

    public OMRSAuditLog createNewAuditLog(OMRSAuditingComponent reportingComponent) {
        return this.createNewAuditLog(reportingComponent.getComponentId(), reportingComponent.getComponentDevelopmentStatus(), reportingComponent.getComponentName(), reportingComponent.getComponentType(), reportingComponent.getComponentWikiURL());
    }

    public void logRecord(String actionDescription, String logMessageId, OMRSAuditLogRecordSeverity severity, String logMessage, String additionalInformation, String systemAction, String userAction) {
        this.storeLogRecord(actionDescription, logMessageId, severity, logMessage, additionalInformation, systemAction, userAction, null);
    }

    public void logException(String actionDescription, String logMessageId, OMRSAuditLogRecordSeverity severity, String logMessage, String additionalInformation, String systemAction, String userAction, Throwable caughtException) {
        this.storeLogRecord(actionDescription, logMessageId, severity, logMessage, additionalInformation, systemAction, userAction, caughtException);
    }

    private void storeLogRecord(String actionDescription, String logMessageId, OMRSAuditLogRecordSeverity severity, String logMessage, String additionalInformation, String systemAction, String userAction, Throwable caughtException) {
        OMRSAuditLogRecord logRecord = new OMRSAuditLogRecord();
        logRecord.setGUID(UUID.randomUUID().toString());
        logRecord.setTimeStamp(new Date());
        if (this.omrsDestination != null) {
            logRecord.setOriginatorProperties(this.omrsDestination.getOriginatorProperties());
            logRecord.setOriginator(this.omrsDestination.getOriginator());
        }
        logRecord.setOriginatorComponent(new AuditLogReportingComponent((ComponentDescription)this.omrsReportingComponent));
        logRecord.setReportingComponent(this.omrsReportingComponent);
        logRecord.setActionDescription(actionDescription);
        logRecord.setThreadId(Thread.currentThread().getId());
        logRecord.setThreadName(Thread.currentThread().getName());
        logRecord.setSeverityCode(severity.getOrdinal());
        logRecord.setSeverity(severity.getName());
        this.auditLogActivity.countRecord(severity.getOrdinal(), severity.getName());
        logRecord.setMessageId(logMessageId);
        logRecord.setMessageText(logMessage);
        logRecord.setSystemAction(systemAction);
        logRecord.setUserAction(userAction);
        ArrayList<String> additionalInformationArray = null;
        if (additionalInformation != null) {
            additionalInformationArray = new ArrayList<String>();
            additionalInformationArray.add(additionalInformation);
        }
        logRecord.setAdditionalInformation(additionalInformationArray);
        if (caughtException != null) {
            logRecord.setExceptionClassName(caughtException.getClass().getName());
            logRecord.setExceptionMessage(caughtException.getMessage());
            StringWriter stackTrace = new StringWriter();
            caughtException.printStackTrace(new PrintWriter(stackTrace));
            logRecord.setExceptionStackTrace(stackTrace.toString());
        }
        this.omrsDestination.addLogRecord(logRecord);
    }

    public OMRSAuditLogReport getFullReport() {
        OMRSAuditLogReport report = new OMRSAuditLogReport(super.getReport());
        if (this.omrsDestination != null) {
            report.setOriginatorProperties(this.omrsDestination.getOriginatorProperties());
            report.setDestinationsReport(this.omrsDestination.getDestinationsReport());
        }
        return report;
    }
}

