/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceElementHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class InstanceType
extends InstanceElementHeader {
    private static final long serialVersionUID = 1L;
    private TypeDefCategory typeDefCategory = TypeDefCategory.UNKNOWN_DEF;
    private String typeDefGUID = null;
    private String typeDefName = null;
    private long typeDefVersion = 0L;
    private String typeDefDescription = null;
    private String typeDefDescriptionGUID = null;
    private List<TypeDefLink> typeDefSuperTypes = null;
    private List<InstanceStatus> validStatusList = null;
    private List<String> validInstanceProperties = null;
    public static final long CURRENT_INSTANCE_TYPE_HEADER_VERSION = 1L;

    public InstanceType() {
    }

    public InstanceType(TypeDefCategory typeDefCategory, String typeDefGUID, String typeDefName, long typeDefVersion, String typeDefDescription, String typeDefDescriptionGUID, List<TypeDefLink> typeDefSuperTypes, List<InstanceStatus> validStatusList, List<String> validInstanceProperties) {
        this.typeDefCategory = typeDefCategory;
        this.typeDefGUID = typeDefGUID;
        this.typeDefName = typeDefName;
        this.typeDefVersion = typeDefVersion;
        this.typeDefDescription = typeDefDescription;
        this.typeDefDescriptionGUID = typeDefDescriptionGUID;
        this.typeDefSuperTypes = typeDefSuperTypes;
        this.validStatusList = validStatusList;
        this.validInstanceProperties = validInstanceProperties;
    }

    public InstanceType(InstanceType template) {
        super(template);
        if (template != null) {
            this.typeDefCategory = template.getTypeDefCategory();
            this.typeDefGUID = template.getTypeDefGUID();
            this.typeDefName = template.getTypeDefName();
            this.typeDefVersion = template.getTypeDefVersion();
            this.typeDefDescription = template.getTypeDefDescription();
            this.typeDefDescriptionGUID = template.getTypeDefDescriptionGUID();
            this.typeDefSuperTypes = template.getTypeDefSuperTypes();
            this.validStatusList = template.getValidStatusList();
            this.validInstanceProperties = template.getValidInstanceProperties();
        }
    }

    public TypeDefCategory getTypeDefCategory() {
        return this.typeDefCategory;
    }

    public void setTypeDefCategory(TypeDefCategory typeDefCategory) {
        this.typeDefCategory = typeDefCategory;
    }

    public String getTypeDefGUID() {
        return this.typeDefGUID;
    }

    public void setTypeDefGUID(String typeDefGUID) {
        this.typeDefGUID = typeDefGUID;
    }

    public String getTypeDefName() {
        return this.typeDefName;
    }

    public void setTypeDefName(String typeDefName) {
        this.typeDefName = typeDefName;
    }

    public long getTypeDefVersion() {
        return this.typeDefVersion;
    }

    public void setTypeDefVersion(long typeDefVersion) {
        this.typeDefVersion = typeDefVersion;
    }

    public List<TypeDefLink> getTypeDefSuperTypes() {
        if (this.typeDefSuperTypes == null) {
            return null;
        }
        if (this.typeDefSuperTypes.isEmpty()) {
            return null;
        }
        ArrayList<TypeDefLink> superTypes = new ArrayList<TypeDefLink>();
        for (TypeDefLink typeDefLink : this.typeDefSuperTypes) {
            superTypes.add(new TypeDefLink(typeDefLink));
        }
        return superTypes;
    }

    public void setTypeDefSuperTypes(List<TypeDefLink> typeDefSuperTypes) {
        this.typeDefSuperTypes = typeDefSuperTypes;
    }

    public String getTypeDefDescription() {
        return this.typeDefDescription;
    }

    public void setTypeDefDescription(String typeDefDescription) {
        this.typeDefDescription = typeDefDescription;
    }

    public String getTypeDefDescriptionGUID() {
        return this.typeDefDescriptionGUID;
    }

    public void setTypeDefDescriptionGUID(String typeDefDescriptionGUID) {
        this.typeDefDescriptionGUID = typeDefDescriptionGUID;
    }

    public List<InstanceStatus> getValidStatusList() {
        if (this.validStatusList == null) {
            return null;
        }
        if (this.validStatusList.isEmpty()) {
            return null;
        }
        return new ArrayList<InstanceStatus>(this.validStatusList);
    }

    public void setValidStatusList(List<InstanceStatus> validStatusList) {
        this.validStatusList = validStatusList;
    }

    public List<String> getValidInstanceProperties() {
        if (this.validInstanceProperties == null) {
            return null;
        }
        if (this.validInstanceProperties.isEmpty()) {
            return null;
        }
        return new ArrayList<String>(this.validInstanceProperties);
    }

    public void setValidInstanceProperties(List<String> validInstanceProperties) {
        this.validInstanceProperties = validInstanceProperties;
    }

    public String toString() {
        return "InstanceType{typeDefName='" + this.typeDefName + "', typeDefCategory=" + this.typeDefCategory + ", typeDefGUID='" + this.typeDefGUID + "', typeDefVersion=" + this.typeDefVersion + ", typeDefDescription='" + this.typeDefDescription + "', typeDefDescriptionGUID='" + this.typeDefDescriptionGUID + "', typeDefSuperTypes=" + this.getTypeDefSuperTypes() + ", validStatusList=" + this.getValidStatusList() + ", validInstanceProperties=" + this.getValidInstanceProperties() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof InstanceType)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        InstanceType that = (InstanceType)objectToCompare;
        if (this.typeDefVersion != that.typeDefVersion) {
            return false;
        }
        if (this.typeDefCategory != that.typeDefCategory) {
            return false;
        }
        if (this.typeDefGUID != null ? !this.typeDefGUID.equals(that.typeDefGUID) : that.typeDefGUID != null) {
            return false;
        }
        if (this.typeDefName != null ? !this.typeDefName.equals(that.typeDefName) : that.typeDefName != null) {
            return false;
        }
        if (this.typeDefDescription != null ? !this.typeDefDescription.equals(that.typeDefDescription) : that.typeDefDescription != null) {
            return false;
        }
        if (this.typeDefDescriptionGUID != null ? !this.typeDefDescriptionGUID.equals(that.typeDefDescriptionGUID) : that.typeDefDescriptionGUID != null) {
            return false;
        }
        if (this.typeDefSuperTypes != null ? !this.typeDefSuperTypes.equals(that.typeDefSuperTypes) : that.typeDefSuperTypes != null) {
            return false;
        }
        if (this.validStatusList != null ? !this.validStatusList.equals(that.validStatusList) : that.validStatusList != null) {
            return false;
        }
        return this.validInstanceProperties != null ? this.validInstanceProperties.equals(that.validInstanceProperties) : that.validInstanceProperties == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.typeDefCategory != null ? this.typeDefCategory.hashCode() : 0);
        result = 31 * result + (this.typeDefGUID != null ? this.typeDefGUID.hashCode() : 0);
        result = 31 * result + (this.typeDefName != null ? this.typeDefName.hashCode() : 0);
        result = 31 * result + (int)(this.typeDefVersion ^ this.typeDefVersion >>> 32);
        result = 31 * result + (this.typeDefDescription != null ? this.typeDefDescription.hashCode() : 0);
        result = 31 * result + (this.typeDefDescriptionGUID != null ? this.typeDefDescriptionGUID.hashCode() : 0);
        result = 31 * result + (this.typeDefSuperTypes != null ? this.typeDefSuperTypes.hashCode() : 0);
        result = 31 * result + (this.validStatusList != null ? this.validStatusList.hashCode() : 0);
        result = 31 * result + (this.validInstanceProperties != null ? this.validInstanceProperties.hashCode() : 0);
        return result;
    }
}

