/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.rest.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.rest.properties.OMRSAPIPagedResponse;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ClassificationListResponse
extends OMRSAPIPagedResponse {
    private static final long serialVersionUID = 1L;
    private List<Classification> classifications = null;

    public ClassificationListResponse() {
    }

    public ClassificationListResponse(ClassificationListResponse template) {
        super(template);
        if (template != null) {
            this.classifications = template.getClassifications();
        }
    }

    public List<Classification> getClassifications() {
        if (this.classifications == null) {
            return null;
        }
        if (this.classifications.isEmpty()) {
            return null;
        }
        ArrayList<Classification> clonedClassifications = new ArrayList<Classification>();
        for (Classification classification : this.classifications) {
            clonedClassifications.add(new Classification(classification));
        }
        return clonedClassifications;
    }

    public void setClassifications(List<Classification> classifications) {
        this.classifications = classifications;
    }

    @Override
    public String toString() {
        return "ClassificationListResponse{classifications=" + this.classifications + ", nextPageURL='" + this.nextPageURL + "', offset=" + this.offset + ", pageSize=" + this.pageSize + ", relatedHTTPCode=" + this.relatedHTTPCode + ", actionDescription='" + this.actionDescription + "', exceptionClassName='" + this.exceptionClassName + "', exceptionCausedBy='" + this.exceptionCausedBy + "', exceptionErrorMessage='" + this.exceptionErrorMessage + "', exceptionErrorMessageId='" + this.exceptionErrorMessageId + "', exceptionErrorMessageParameters=" + Arrays.toString(this.exceptionErrorMessageParameters) + ", exceptionSystemAction='" + this.exceptionSystemAction + "', exceptionUserAction='" + this.exceptionUserAction + "', exceptionProperties=" + this.exceptionProperties + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof ClassificationListResponse)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        ClassificationListResponse that = (ClassificationListResponse)objectToCompare;
        return Objects.equals(this.getClassifications(), that.getClassifications());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getClassifications());
    }
}

