/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.rest.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.rest.properties.OMRSAPIRequest;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ClassificationWithEntityRequest
extends OMRSAPIRequest {
    private static final long serialVersionUID = 1L;
    private Classification classification = null;
    private EntityDetail entity = null;
    private EntityProxy entityProxy = null;

    public ClassificationWithEntityRequest() {
    }

    public ClassificationWithEntityRequest(ClassificationWithEntityRequest template) {
        super(template);
        if (template != null) {
            this.classification = template.getClassification();
            this.entity = template.getEntity();
            this.entityProxy = template.getEntityProxy();
        }
    }

    public Classification getClassification() {
        return this.classification;
    }

    public void setClassification(Classification classification) {
        this.classification = classification;
    }

    public EntityDetail getEntity() {
        return this.entity;
    }

    public void setEntity(EntityDetail entity) {
        this.entity = entity;
    }

    public EntityProxy getEntityProxy() {
        return this.entityProxy;
    }

    public void setEntityProxy(EntityProxy entity) {
        this.entityProxy = entity;
    }

    public String toString() {
        return "ClassificationWithEntityRequest{classification=" + this.classification + ", entity=" + this.entity + ", entityProxy=" + this.entityProxy + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        ClassificationWithEntityRequest that = (ClassificationWithEntityRequest)objectToCompare;
        return Objects.equals(this.classification, that.classification) && Objects.equals(this.entity, that.entity);
    }

    public int hashCode() {
        return Objects.hash(this.getClassification(), this.getEntity());
    }
}

