/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLoggingComponent;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDescription;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.HistorySequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceGraph;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchClassifications;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefGallery;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSAuditCode;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.HomeEntityException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.HomeRelationshipException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidEntityException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidRelationshipException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidTypeDefException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PatchErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.StatusNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefInUseException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OMRSMetadataCollection
implements AuditLoggingComponent {
    private static final String defaultRepositoryName = "Open Metadata Repository";
    protected String metadataCollectionId;
    protected String metadataCollectionName = null;
    protected OMRSRepositoryHelper repositoryHelper = null;
    protected OMRSRepositoryValidator repositoryValidator = null;
    protected OMRSRepositoryConnector parentConnector = null;
    protected String repositoryName = "Open Metadata Repository";
    protected AuditLog auditLog = null;
    private static final Logger log = LoggerFactory.getLogger(OMRSMetadataCollection.class);

    @Deprecated
    public OMRSMetadataCollection(String metadataCollectionId) {
        this.metadataCollectionId = metadataCollectionId;
        if (metadataCollectionId == null) {
            String actionDescription = "OMRS Metadata Collection Constructor";
            throw new OMRSLogicErrorException(OMRSErrorCode.NULL_METADATA_COLLECTION_ID.getMessageDefinition(defaultRepositoryName), this.getClass().getName(), actionDescription);
        }
    }

    public OMRSMetadataCollection(OMRSRepositoryConnector parentConnector, String repositoryName, String metadataCollectionId, OMRSRepositoryHelper repositoryHelper, OMRSRepositoryValidator repositoryValidator) {
        this.metadataCollectionId = metadataCollectionId;
        if (metadataCollectionId == null) {
            String actionDescription = "OMRS Metadata Collection Constructor";
            throw new OMRSLogicErrorException(OMRSErrorCode.NULL_METADATA_COLLECTION_ID.getMessageDefinition(repositoryName), this.getClass().getName(), actionDescription);
        }
        this.repositoryHelper = repositoryHelper;
        this.repositoryValidator = repositoryValidator;
        this.parentConnector = parentConnector;
        if (parentConnector != null) {
            this.metadataCollectionName = parentConnector.getMetadataCollectionName();
        }
        this.repositoryName = repositoryName;
    }

    public void setAuditLog(AuditLog auditLog) {
        this.auditLog = auditLog;
    }

    public ComponentDescription getConnectorComponentDescription() {
        if (this.auditLog != null && this.auditLog.getReport() != null) {
            return this.auditLog.getReport().getReportingComponent();
        }
        return null;
    }

    public void validateRepositoryConnector(String methodName) throws RepositoryErrorException {
        if (this.parentConnector == null) {
            throw new RepositoryErrorException(OMRSErrorCode.NO_REPOSITORY_CONNECTOR_FOR_COLLECTION.getMessageDefinition(methodName, this.repositoryName), this.getClass().getName(), methodName);
        }
        if (this.repositoryValidator == null) {
            throw new RepositoryErrorException(OMRSErrorCode.NO_REPOSITORY_VALIDATOR_FOR_COLLECTION.getMessageDefinition(methodName, this.repositoryName), this.getClass().getName(), methodName);
        }
        if (this.repositoryHelper == null) {
            throw new RepositoryErrorException(OMRSErrorCode.NO_REPOSITORY_HELPER_FOR_COLLECTION.getMessageDefinition(methodName, this.repositoryName), this.getClass().getName(), methodName);
        }
    }

    protected void basicRequestValidation(String userId, String methodName) throws InvalidParameterException, RepositoryErrorException {
        this.validateRepositoryConnector(methodName);
        this.parentConnector.validateRepositoryIsActive(methodName);
        this.repositoryValidator.validateUserId(this.repositoryName, userId, methodName);
    }

    @Deprecated
    public String getMetadataCollectionId() throws RepositoryErrorException {
        return this.metadataCollectionId;
    }

    public String getMetadataCollectionId(String userId) throws RepositoryErrorException {
        return this.metadataCollectionId;
    }

    public abstract TypeDefGallery getAllTypes(String var1) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException;

    public abstract TypeDefGallery findTypesByName(String var1, String var2) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException;

    public abstract List<TypeDef> findTypeDefsByCategory(String var1, TypeDefCategory var2) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException;

    public abstract List<AttributeTypeDef> findAttributeTypeDefsByCategory(String var1, AttributeTypeDefCategory var2) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException;

    public abstract List<TypeDef> findTypeDefsByProperty(String var1, TypeDefProperties var2) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException;

    public abstract List<TypeDef> findTypesByExternalID(String var1, String var2, String var3, String var4) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException;

    public abstract List<TypeDef> searchForTypeDefs(String var1, String var2) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException;

    public abstract TypeDef getTypeDefByGUID(String var1, String var2) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException;

    public abstract AttributeTypeDef getAttributeTypeDefByGUID(String var1, String var2) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException;

    public abstract TypeDef getTypeDefByName(String var1, String var2) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException;

    public abstract AttributeTypeDef getAttributeTypeDefByName(String var1, String var2) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException;

    public abstract void addTypeDefGallery(String var1, TypeDefGallery var2) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefKnownException, TypeDefConflictException, InvalidTypeDefException, FunctionNotSupportedException, UserNotAuthorizedException;

    public abstract void addTypeDef(String var1, TypeDef var2) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefKnownException, TypeDefConflictException, InvalidTypeDefException, FunctionNotSupportedException, UserNotAuthorizedException;

    public abstract void addAttributeTypeDef(String var1, AttributeTypeDef var2) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefKnownException, TypeDefConflictException, InvalidTypeDefException, FunctionNotSupportedException, UserNotAuthorizedException;

    public abstract boolean verifyTypeDef(String var1, TypeDef var2) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefConflictException, InvalidTypeDefException, UserNotAuthorizedException;

    public abstract boolean verifyAttributeTypeDef(String var1, AttributeTypeDef var2) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefConflictException, InvalidTypeDefException, UserNotAuthorizedException;

    public abstract TypeDef updateTypeDef(String var1, TypeDefPatch var2) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, PatchErrorException, FunctionNotSupportedException, UserNotAuthorizedException;

    public abstract void deleteTypeDef(String var1, String var2, String var3) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, TypeDefInUseException, FunctionNotSupportedException, UserNotAuthorizedException;

    public abstract void deleteAttributeTypeDef(String var1, String var2, String var3) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, TypeDefInUseException, FunctionNotSupportedException, UserNotAuthorizedException;

    public abstract TypeDef reIdentifyTypeDef(String var1, String var2, String var3, String var4, String var5) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException;

    public abstract AttributeTypeDef reIdentifyAttributeTypeDef(String var1, String var2, String var3, String var4, String var5) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException;

    public abstract EntityDetail isEntityKnown(String var1, String var2) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException;

    public abstract EntitySummary getEntitySummary(String var1, String var2) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, UserNotAuthorizedException;

    public abstract EntityDetail getEntityDetail(String var1, String var2) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityProxyOnlyException, UserNotAuthorizedException;

    public abstract EntityDetail getEntityDetail(String var1, String var2, Date var3) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityProxyOnlyException, FunctionNotSupportedException, UserNotAuthorizedException;

    public abstract List<EntityDetail> getEntityDetailHistory(String var1, String var2, Date var3, Date var4, int var5, int var6, HistorySequencingOrder var7) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityProxyOnlyException, FunctionNotSupportedException, UserNotAuthorizedException;

    public abstract List<Relationship> getRelationshipsForEntity(String var1, String var2, String var3, int var4, List<InstanceStatus> var5, Date var6, String var7, SequencingOrder var8, int var9) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException;

    public abstract List<EntityDetail> findEntities(String var1, String var2, List<String> var3, SearchProperties var4, int var5, List<InstanceStatus> var6, SearchClassifications var7, Date var8, String var9, SequencingOrder var10, int var11) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException;

    public abstract List<EntityDetail> findEntitiesByProperty(String var1, String var2, InstanceProperties var3, MatchCriteria var4, int var5, List<InstanceStatus> var6, List<String> var7, Date var8, String var9, SequencingOrder var10, int var11) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException;

    public abstract List<EntityDetail> findEntitiesByClassification(String var1, String var2, String var3, InstanceProperties var4, MatchCriteria var5, int var6, List<InstanceStatus> var7, Date var8, String var9, SequencingOrder var10, int var11) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, ClassificationErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException;

    public abstract List<EntityDetail> findEntitiesByPropertyValue(String var1, String var2, String var3, int var4, List<InstanceStatus> var5, List<String> var6, Date var7, String var8, SequencingOrder var9, int var10) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException;

    public abstract Relationship isRelationshipKnown(String var1, String var2) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException;

    public abstract Relationship getRelationship(String var1, String var2) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, UserNotAuthorizedException;

    public abstract Relationship getRelationship(String var1, String var2, Date var3) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException;

    public abstract List<Relationship> getRelationshipHistory(String var1, String var2, Date var3, Date var4, int var5, int var6, HistorySequencingOrder var7) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException;

    public abstract List<Relationship> findRelationships(String var1, String var2, List<String> var3, SearchProperties var4, int var5, List<InstanceStatus> var6, Date var7, String var8, SequencingOrder var9, int var10) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException;

    public abstract List<Relationship> findRelationshipsByProperty(String var1, String var2, InstanceProperties var3, MatchCriteria var4, int var5, List<InstanceStatus> var6, Date var7, String var8, SequencingOrder var9, int var10) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException;

    public abstract List<Relationship> findRelationshipsByPropertyValue(String var1, String var2, String var3, int var4, List<InstanceStatus> var5, Date var6, String var7, SequencingOrder var8, int var9) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException;

    public abstract InstanceGraph getLinkingEntities(String var1, String var2, String var3, List<InstanceStatus> var4, Date var5) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException;

    public abstract InstanceGraph getEntityNeighborhood(String var1, String var2, List<String> var3, List<String> var4, List<InstanceStatus> var5, List<String> var6, Date var7, int var8) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException;

    public abstract List<EntityDetail> getRelatedEntities(String var1, String var2, List<String> var3, int var4, List<InstanceStatus> var5, List<String> var6, Date var7, String var8, SequencingOrder var9, int var10) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException;

    public abstract EntityDetail addEntity(String var1, String var2, InstanceProperties var3, List<Classification> var4, InstanceStatus var5) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, ClassificationErrorException, StatusNotSupportedException, FunctionNotSupportedException, UserNotAuthorizedException;

    public EntityDetail addExternalEntity(String userId, String entityTypeGUID, String externalSourceGUID, String externalSourceName, InstanceProperties initialProperties, List<Classification> initialClassifications, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, ClassificationErrorException, StatusNotSupportedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "addExternalEntity";
        throw new FunctionNotSupportedException(OMRSErrorCode.METHOD_NOT_IMPLEMENTED.getMessageDefinition("addExternalEntity", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "addExternalEntity");
    }

    public abstract void addEntityProxy(String var1, EntityProxy var2) throws InvalidParameterException, RepositoryErrorException, FunctionNotSupportedException, UserNotAuthorizedException;

    public abstract EntityDetail updateEntityStatus(String var1, String var2, InstanceStatus var3) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, StatusNotSupportedException, UserNotAuthorizedException, FunctionNotSupportedException;

    public abstract EntityDetail updateEntityProperties(String var1, String var2, InstanceProperties var3) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, UserNotAuthorizedException, FunctionNotSupportedException;

    public abstract EntityDetail undoEntityUpdate(String var1, String var2) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException;

    public abstract EntityDetail deleteEntity(String var1, String var2, String var3, String var4) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException;

    public abstract void purgeEntity(String var1, String var2, String var3, String var4) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityNotDeletedException, UserNotAuthorizedException, FunctionNotSupportedException;

    public abstract EntityDetail restoreEntity(String var1, String var2) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityNotDeletedException, FunctionNotSupportedException, UserNotAuthorizedException;

    public abstract EntityDetail classifyEntity(String var1, String var2, String var3, InstanceProperties var4) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException, UserNotAuthorizedException, FunctionNotSupportedException;

    public Classification classifyEntity(String userId, EntityProxy entityProxy, String classificationName, InstanceProperties classificationProperties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException, UserNotAuthorizedException, FunctionNotSupportedException {
        EntityDetail entityDetail = this.classifyEntity(userId, entityProxy.getGUID(), classificationName, classificationProperties);
        for (Classification classification : entityDetail.getClassifications()) {
            if (!classification.getName().equals(classificationName)) continue;
            return classification;
        }
        return null;
    }

    public EntityDetail classifyEntity(String userId, String entityGUID, String classificationName, String externalSourceGUID, String externalSourceName, ClassificationOrigin classificationOrigin, String classificationOriginGUID, InstanceProperties classificationProperties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "classifyEntity (detailed)";
        throw new FunctionNotSupportedException(OMRSErrorCode.METHOD_NOT_IMPLEMENTED.getMessageDefinition("classifyEntity (detailed)", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "classifyEntity (detailed)");
    }

    public Classification classifyEntity(String userId, EntityProxy entityProxy, String classificationName, String externalSourceGUID, String externalSourceName, ClassificationOrigin classificationOrigin, String classificationOriginGUID, InstanceProperties classificationProperties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException, UserNotAuthorizedException, FunctionNotSupportedException {
        EntityDetail entityDetail = this.classifyEntity(userId, entityProxy.getGUID(), classificationName, externalSourceGUID, externalSourceName, classificationOrigin, classificationOriginGUID, classificationProperties);
        for (Classification classification : entityDetail.getClassifications()) {
            if (!classification.getName().equals(classificationName)) continue;
            return classification;
        }
        return null;
    }

    public abstract EntityDetail declassifyEntity(String var1, String var2, String var3) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, UserNotAuthorizedException, FunctionNotSupportedException;

    public Classification declassifyEntity(String userId, EntityProxy entityProxy, String classificationName) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, UserNotAuthorizedException, FunctionNotSupportedException {
        this.declassifyEntity(userId, entityProxy.getGUID(), classificationName);
        return null;
    }

    public abstract EntityDetail updateEntityClassification(String var1, String var2, String var3, InstanceProperties var4) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException, UserNotAuthorizedException, FunctionNotSupportedException;

    public Classification updateEntityClassification(String userId, EntityProxy entityProxy, String classificationName, InstanceProperties properties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException, UserNotAuthorizedException, FunctionNotSupportedException {
        EntityDetail entityDetail = this.updateEntityClassification(userId, entityProxy.getGUID(), classificationName, properties);
        for (Classification classification : entityDetail.getClassifications()) {
            if (!classification.getName().equals(classificationName)) continue;
            return classification;
        }
        return null;
    }

    public abstract Relationship addRelationship(String var1, String var2, InstanceProperties var3, String var4, String var5, InstanceStatus var6) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, EntityNotKnownException, StatusNotSupportedException, UserNotAuthorizedException, FunctionNotSupportedException;

    public Relationship addExternalRelationship(String userId, String relationshipTypeGUID, String externalSourceGUID, String externalSourceName, InstanceProperties initialProperties, String entityOneGUID, String entityTwoGUID, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, EntityNotKnownException, StatusNotSupportedException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "addExternalRelationship";
        throw new FunctionNotSupportedException(OMRSErrorCode.METHOD_NOT_IMPLEMENTED.getMessageDefinition("addExternalRelationship", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "addExternalRelationship");
    }

    public abstract Relationship updateRelationshipStatus(String var1, String var2, InstanceStatus var3) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, StatusNotSupportedException, UserNotAuthorizedException, FunctionNotSupportedException;

    public abstract Relationship updateRelationshipProperties(String var1, String var2, InstanceProperties var3) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, PropertyErrorException, UserNotAuthorizedException, FunctionNotSupportedException;

    public abstract Relationship undoRelationshipUpdate(String var1, String var2) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException;

    public abstract Relationship deleteRelationship(String var1, String var2, String var3, String var4) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException;

    public abstract void purgeRelationship(String var1, String var2, String var3, String var4) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, RelationshipNotDeletedException, UserNotAuthorizedException, FunctionNotSupportedException;

    public abstract Relationship restoreRelationship(String var1, String var2) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, RelationshipNotDeletedException, FunctionNotSupportedException, UserNotAuthorizedException;

    public abstract EntityDetail reIdentifyEntity(String var1, String var2, String var3, String var4, String var5) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException;

    public abstract EntityDetail reTypeEntity(String var1, String var2, TypeDefSummary var3, TypeDefSummary var4) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, ClassificationErrorException, EntityNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException;

    public EntityDetail reHomeEntity(String userId, String entityGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId, String newHomeMetadataCollectionId, String newHomeMetadataCollectionName) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        EntityDetail updatedEntity = this.reHomeEntity(userId, entityGUID, typeDefGUID, typeDefName, homeMetadataCollectionId, newHomeMetadataCollectionId);
        if (updatedEntity != null) {
            updatedEntity.setMetadataCollectionName(newHomeMetadataCollectionName);
        }
        return updatedEntity;
    }

    @Deprecated
    public EntityDetail reHomeEntity(String userId, String entityGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId, String newHomeMetadataCollectionId) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "reHomeEntity";
        throw new RepositoryErrorException(OMRSErrorCode.METHOD_NOT_IMPLEMENTED.getMessageDefinition("reHomeEntity", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "reHomeEntity");
    }

    public abstract Relationship reIdentifyRelationship(String var1, String var2, String var3, String var4, String var5) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException;

    public abstract Relationship reTypeRelationship(String var1, String var2, TypeDefSummary var3, TypeDefSummary var4) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException;

    public Relationship reHomeRelationship(String userId, String relationshipGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId, String newHomeMetadataCollectionId, String newHomeMetadataCollectionName) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        Relationship updatedRelationship = this.reHomeRelationship(userId, relationshipGUID, typeDefGUID, typeDefName, homeMetadataCollectionId, newHomeMetadataCollectionId);
        if (updatedRelationship != null) {
            updatedRelationship.setMetadataCollectionName(newHomeMetadataCollectionName);
        }
        return updatedRelationship;
    }

    @Deprecated
    public Relationship reHomeRelationship(String userId, String relationshipGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId, String newHomeMetadataCollectionId) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "reHomeRelationship";
        throw new RepositoryErrorException(OMRSErrorCode.METHOD_NOT_IMPLEMENTED.getMessageDefinition("reHomeRelationship", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "reHomeRelationship");
    }

    public abstract void saveEntityReferenceCopy(String var1, EntityDetail var2) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, HomeEntityException, EntityConflictException, InvalidEntityException, FunctionNotSupportedException, UserNotAuthorizedException;

    public List<Classification> getHomeClassifications(String userId, String entityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "getHomeClassifications";
        throw new FunctionNotSupportedException(OMRSErrorCode.METHOD_NOT_IMPLEMENTED.getMessageDefinition("getHomeClassifications", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "getHomeClassifications");
    }

    public List<Classification> getHomeClassifications(String userId, String entityGUID, Date asOfTime) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "getHomeClassifications (with history)";
        throw new FunctionNotSupportedException(OMRSErrorCode.METHOD_NOT_IMPLEMENTED.getMessageDefinition("getHomeClassifications (with history)", this.getClass().getName(), this.repositoryName), this.getClass().getName(), "getHomeClassifications (with history)");
    }

    public void deleteEntityReferenceCopy(String userId, EntityDetail entity) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, HomeEntityException, EntityConflictException, InvalidEntityException, FunctionNotSupportedException, UserNotAuthorizedException {
        this.saveEntityReferenceCopy(userId, entity);
    }

    public void purgeEntityReferenceCopy(String userId, EntityDetail entity) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, HomeEntityException, EntityConflictException, InvalidEntityException, FunctionNotSupportedException, UserNotAuthorizedException {
        if (entity != null) {
            String typeDefGUID = null;
            String typeDefName = null;
            InstanceType type = entity.getType();
            if (type != null) {
                typeDefGUID = type.getTypeDefGUID();
                typeDefName = type.getTypeDefName();
            }
            try {
                this.purgeEntityReferenceCopy(userId, entity.getGUID(), typeDefGUID, typeDefName, entity.getMetadataCollectionId());
            }
            catch (EntityNotKnownException entityNotKnownException) {
                // empty catch block
            }
        }
    }

    public abstract void purgeEntityReferenceCopy(String var1, String var2, String var3, String var4, String var5) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, HomeEntityException, FunctionNotSupportedException, UserNotAuthorizedException;

    public abstract void refreshEntityReferenceCopy(String var1, String var2, String var3, String var4, String var5) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, HomeEntityException, FunctionNotSupportedException, UserNotAuthorizedException;

    public void saveClassificationReferenceCopy(String userId, EntityDetail entity, Classification classification) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, EntityConflictException, InvalidEntityException, PropertyErrorException, UserNotAuthorizedException, FunctionNotSupportedException {
        if (this.metadataCollectionId != null && !this.metadataCollectionId.equals(entity.getMetadataCollectionId())) {
            try {
                this.saveEntityReferenceCopy(userId, entity);
            }
            catch (HomeEntityException homeEntityException) {
                // empty catch block
            }
        }
    }

    public void saveClassificationReferenceCopy(String userId, EntityProxy entity, Classification classification) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, EntityConflictException, InvalidEntityException, PropertyErrorException, UserNotAuthorizedException, FunctionNotSupportedException {
    }

    public void purgeClassificationReferenceCopy(String userId, EntityDetail entity, Classification classification) throws InvalidParameterException, TypeErrorException, PropertyErrorException, EntityConflictException, InvalidEntityException, RepositoryErrorException, UserNotAuthorizedException, FunctionNotSupportedException {
        if (this.metadataCollectionId != null && !this.metadataCollectionId.equals(entity.getMetadataCollectionId())) {
            try {
                this.saveEntityReferenceCopy(userId, entity);
            }
            catch (HomeEntityException homeEntityException) {
                // empty catch block
            }
        }
    }

    public void purgeClassificationReferenceCopy(String userId, EntityProxy entity, Classification classification) throws InvalidParameterException, TypeErrorException, PropertyErrorException, EntityConflictException, InvalidEntityException, RepositoryErrorException, UserNotAuthorizedException, FunctionNotSupportedException {
    }

    public abstract void saveRelationshipReferenceCopy(String var1, Relationship var2) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, EntityNotKnownException, PropertyErrorException, HomeRelationshipException, RelationshipConflictException, InvalidRelationshipException, FunctionNotSupportedException, UserNotAuthorizedException;

    public void deleteRelationshipReferenceCopy(String userId, Relationship relationship) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, EntityNotKnownException, PropertyErrorException, HomeRelationshipException, RelationshipConflictException, InvalidRelationshipException, FunctionNotSupportedException, UserNotAuthorizedException {
        this.saveRelationshipReferenceCopy(userId, relationship);
    }

    public void purgeRelationshipReferenceCopy(String userId, Relationship relationship) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, EntityNotKnownException, PropertyErrorException, HomeRelationshipException, RelationshipConflictException, InvalidRelationshipException, FunctionNotSupportedException, UserNotAuthorizedException {
        if (relationship != null) {
            String typeDefGUID = null;
            String typeDefName = null;
            InstanceType type = relationship.getType();
            if (type != null) {
                typeDefGUID = type.getTypeDefGUID();
                typeDefName = type.getTypeDefName();
            }
            try {
                this.purgeRelationshipReferenceCopy(userId, relationship.getGUID(), typeDefGUID, typeDefName, relationship.getMetadataCollectionId());
            }
            catch (RelationshipNotKnownException relationshipNotKnownException) {
                // empty catch block
            }
        }
    }

    public abstract void purgeRelationshipReferenceCopy(String var1, String var2, String var3, String var4, String var5) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, HomeRelationshipException, FunctionNotSupportedException, UserNotAuthorizedException;

    public abstract void refreshRelationshipReferenceCopy(String var1, String var2, String var3, String var4, String var5) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, HomeRelationshipException, FunctionNotSupportedException, UserNotAuthorizedException;

    public void saveInstanceReferenceCopies(String userId, InstanceGraph instances) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, EntityNotKnownException, PropertyErrorException, EntityConflictException, RelationshipConflictException, InvalidEntityException, InvalidRelationshipException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "saveInstanceReferenceCopies";
        if (instances != null) {
            try {
                if (instances.getEntities() != null) {
                    for (EntityDetail entity : instances.getEntities()) {
                        if (entity == null || this.metadataCollectionId.equals(entity.getMetadataCollectionId())) continue;
                        this.saveEntityReferenceCopy(userId, entity);
                    }
                }
                if (instances.getRelationships() != null) {
                    for (Relationship relationship : instances.getRelationships()) {
                        if (relationship == null || this.metadataCollectionId.equals(relationship.getMetadataCollectionId())) continue;
                        this.saveRelationshipReferenceCopy(userId, relationship);
                    }
                }
            }
            catch (HomeEntityException exception) {
                log.error("Default saveInstanceReferenceCopies received invalid entity", (Throwable)((Object)exception));
                if (this.auditLog != null) {
                    this.auditLog.logException("saveInstanceReferenceCopies", OMRSAuditCode.INVALID_INSTANCES.getMessageDefinition(((Object)((Object)exception)).getClass().getName(), exception.getReportedErrorMessage()), (Throwable)((Object)exception));
                }
                throw new InvalidEntityException(OMRSErrorCode.INVALID_INSTANCES.getMessageDefinition(((Object)((Object)exception)).getClass().getName(), exception.getReportedErrorMessage()), this.getClass().getName(), "saveInstanceReferenceCopies");
            }
            catch (HomeRelationshipException exception) {
                log.error("Default saveInstanceReferenceCopies received invalid relationship", (Throwable)((Object)exception));
                if (this.auditLog != null) {
                    this.auditLog.logException("saveInstanceReferenceCopies", OMRSAuditCode.INVALID_INSTANCES.getMessageDefinition(((Object)((Object)exception)).getClass().getName(), exception.getReportedErrorMessage()), (Throwable)((Object)exception));
                }
                throw new InvalidRelationshipException(OMRSErrorCode.INVALID_INSTANCES.getMessageDefinition(((Object)((Object)exception)).getClass().getName(), exception.getReportedErrorMessage()), this.getClass().getName(), "saveInstanceReferenceCopies");
            }
        }
    }
}

