/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.rest.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Arrays;
import java.util.Objects;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.rest.properties.OMRSAPIResponse;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RelationshipResponse
extends OMRSAPIResponse {
    private static final long serialVersionUID = 1L;
    private Relationship relationship = null;

    public RelationshipResponse() {
    }

    public RelationshipResponse(RelationshipResponse template) {
        super(template);
        if (template != null) {
            this.relationship = template.getRelationship();
        }
    }

    public Relationship getRelationship() {
        if (this.relationship == null) {
            return null;
        }
        return new Relationship(this.relationship);
    }

    public void setRelationship(Relationship relationship) {
        this.relationship = relationship;
    }

    @Override
    public String toString() {
        return "RelationshipResponse{relationship=" + this.relationship + ", relatedHTTPCode=" + this.relatedHTTPCode + ", actionDescription='" + this.actionDescription + "', exceptionClassName='" + this.exceptionClassName + "', exceptionCausedBy='" + this.exceptionCausedBy + "', exceptionErrorMessage='" + this.exceptionErrorMessage + "', exceptionErrorMessageId='" + this.exceptionErrorMessageId + "', exceptionErrorMessageParameters=" + Arrays.toString(this.exceptionErrorMessageParameters) + ", exceptionSystemAction='" + this.exceptionSystemAction + "', exceptionUserAction='" + this.exceptionUserAction + "', exceptionProperties=" + this.exceptionProperties + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof RelationshipResponse)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        RelationshipResponse that = (RelationshipResponse)objectToCompare;
        return Objects.equals(this.getRelationship(), that.getRelationship());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getRelationship());
    }
}

