/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashMap;
import java.util.Objects;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class EntityProxy
extends EntitySummary {
    private static final long serialVersionUID = 1L;
    private InstanceProperties uniqueProperties = null;

    public EntityProxy() {
    }

    public EntityProxy(EntityProxy template) {
        super(template);
        if (template != null) {
            this.uniqueProperties = template.getUniqueProperties();
        }
    }

    public EntityProxy(EntitySummary template) {
        super(template);
        if (template instanceof EntityProxy) {
            EntityProxy entityProxy = (EntityProxy)template;
            this.uniqueProperties = entityProxy.getUniqueProperties();
        } else if (template instanceof EntityDetail) {
            InstancePropertyValue qualifiedName;
            String qualifiedNameProperty = "qualifiedName";
            EntityDetail entityDetail = (EntityDetail)template;
            if (entityDetail.getProperties() != null && (qualifiedName = entityDetail.getProperties().getPropertyValue("qualifiedName")) != null) {
                InstanceProperties properties = new InstanceProperties();
                HashMap<String, InstancePropertyValue> propertyValueMap = new HashMap<String, InstancePropertyValue>();
                propertyValueMap.put("qualifiedName", qualifiedName);
                properties.setInstanceProperties(propertyValueMap);
                properties.setEffectiveFromTime(entityDetail.getProperties().getEffectiveFromTime());
                properties.setEffectiveToTime(entityDetail.getProperties().getEffectiveToTime());
                this.uniqueProperties = properties;
            }
        }
    }

    public InstanceProperties getUniqueProperties() {
        if (this.uniqueProperties == null) {
            return null;
        }
        if (this.uniqueProperties.getInstanceProperties() == null && this.uniqueProperties.getEffectiveFromTime() == null && this.uniqueProperties.getEffectiveToTime() == null) {
            return null;
        }
        return new InstanceProperties(this.uniqueProperties);
    }

    public void setUniqueProperties(InstanceProperties uniqueAttributes) {
        this.uniqueProperties = uniqueAttributes;
    }

    @Override
    public String toString() {
        return "EntityProxy{uniqueProperties=" + this.uniqueProperties + ", classifications=" + this.getClassifications() + ", headerVersion=" + this.getHeaderVersion() + ", type=" + this.getType() + ", instanceProvenanceType=" + this.getInstanceProvenanceType() + ", metadataCollectionId='" + this.getMetadataCollectionId() + "', metadataCollectionName='" + this.getMetadataCollectionName() + "', replicatedBy='" + this.getReplicatedBy() + "', instanceLicense='" + this.getInstanceLicense() + "', status=" + this.getStatus() + ", createdBy='" + this.getCreatedBy() + "', updatedBy='" + this.getUpdatedBy() + "', maintainedBy=" + this.getMaintainedBy() + ", createTime=" + this.getCreateTime() + ", updateTime=" + this.getUpdateTime() + ", version=" + this.getVersion() + ", statusOnDelete=" + this.getStatusOnDelete() + ", mappingProperties=" + this.getMappingProperties() + ", instanceURL='" + this.getInstanceURL() + "', GUID='" + this.getGUID() + "', reIdentifiedFromGUID='" + this.getReIdentifiedFromGUID() + "'}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        EntityProxy that = (EntityProxy)objectToCompare;
        return Objects.equals(this.getUniqueProperties(), that.getUniqueProperties());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getUniqueProperties());
    }
}

