/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.omrstopic;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceGraph;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.events.OMRSEventOriginator;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEventErrorCode;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEventType;
import org.odpi.openmetadata.repositoryservices.events.OMRSRegistryEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSRegistryEventErrorCode;
import org.odpi.openmetadata.repositoryservices.events.OMRSRegistryEventType;
import org.odpi.openmetadata.repositoryservices.events.OMRSTypeDefEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSTypeDefEventErrorCode;
import org.odpi.openmetadata.repositoryservices.events.OMRSTypeDefEventType;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSAuditCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMRSTopicListenerBase
implements OMRSTopicListener {
    private static final Logger log = LoggerFactory.getLogger(OMRSTopicListenerBase.class);
    private final String NULL_EVENT = "<null>";
    protected String serviceName;
    protected AuditLog auditLog = null;

    public OMRSTopicListenerBase(String serviceName) {
        this.serviceName = serviceName;
    }

    public OMRSTopicListenerBase(String serviceName, AuditLog auditLog) {
        this.serviceName = serviceName;
        this.auditLog = auditLog;
    }

    private void logUnexpectedException(String event, Exception error, String actionDescription) {
        if (this.auditLog != null) {
            this.auditLog.logException(actionDescription, OMRSAuditCode.UNEXPECTED_EXCEPTION_FROM_SERVICE_LISTENER.getMessageDefinition(this.serviceName, error.getClass().getName(), error.getMessage()), event, (Throwable)error);
        }
    }

    protected String getInstanceTypeName(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, InstanceHeader instance, String actionDescription) {
        InstanceType instanceType;
        String instanceTypeName = null;
        if (instance != null && (instanceType = instance.getType()) != null) {
            instanceTypeName = instanceType.getTypeDefName();
        }
        if (instanceTypeName == null) {
            String unknownEventInsert = "<Unknown Value>";
            String eventSourceName = "<Unknown Value>";
            String eventMetadataCollectionId = "<Unknown Value>";
            String eventServerName = "<Unknown Value>";
            String eventServerType = "<Unknown Value>";
            String eventOrgName = "<Unknown Value>";
            String eventInstanceString = "<Unknown Value>";
            if (instance != null) {
                eventInstanceString = instance.toString();
            }
            if (sourceName != null) {
                eventSourceName = sourceName;
            }
            if (originatorMetadataCollectionId != null) {
                eventMetadataCollectionId = originatorMetadataCollectionId;
            }
            if (originatorServerName != null) {
                eventServerName = originatorServerName;
            }
            if (originatorServerType != null) {
                eventServerType = originatorServerType;
            }
            if (originatorOrganizationName != null) {
                eventOrgName = originatorOrganizationName;
            }
            this.auditLog.logMessage(actionDescription, OMRSAuditCode.BAD_EVENT_INSTANCE.getMessageDefinition(eventSourceName, eventServerName, eventServerType, eventOrgName, eventMetadataCollectionId, eventInstanceString));
        }
        return instanceTypeName;
    }

    @Override
    public void processRegistryEvent(OMRSRegistryEvent registryEvent) {
        String actionDescription = "processRegistryEvent";
        try {
            log.debug("Processing registry event: " + String.valueOf(registryEvent));
            if (registryEvent == null) {
                log.debug("Null registry event; ignoring event");
            } else {
                OMRSRegistryEventType registryEventType = registryEvent.getRegistryEventType();
                OMRSEventOriginator registryEventOriginator = registryEvent.getEventOriginator();
                if (registryEventType != null && registryEventOriginator != null) {
                    block1 : switch (registryEventType) {
                        case REGISTRATION_EVENT: {
                            this.processRegistrationEvent(this.serviceName, registryEventOriginator.getMetadataCollectionId(), registryEvent.getMetadataCollectionName(), registryEventOriginator.getServerName(), registryEventOriginator.getServerType(), registryEventOriginator.getOrganizationName(), registryEvent.getRegistrationTimestamp(), registryEvent.getRemoteConnection());
                            break;
                        }
                        case RE_REGISTRATION_EVENT: {
                            this.processReRegistrationEvent(this.serviceName, registryEventOriginator.getMetadataCollectionId(), registryEvent.getMetadataCollectionName(), registryEventOriginator.getServerName(), registryEventOriginator.getServerType(), registryEventOriginator.getOrganizationName(), registryEvent.getRegistrationTimestamp(), registryEvent.getRemoteConnection());
                            break;
                        }
                        case REFRESH_REGISTRATION_REQUEST: {
                            this.processRegistrationRefreshRequest(this.serviceName, registryEventOriginator.getServerName(), registryEventOriginator.getServerType(), registryEventOriginator.getOrganizationName());
                            break;
                        }
                        case UN_REGISTRATION_EVENT: {
                            this.processUnRegistrationEvent(this.serviceName, registryEventOriginator.getMetadataCollectionId(), registryEvent.getMetadataCollectionName(), registryEventOriginator.getServerName(), registryEventOriginator.getServerType(), registryEventOriginator.getOrganizationName());
                            break;
                        }
                        case REGISTRATION_ERROR_EVENT: {
                            OMRSRegistryEventErrorCode errorCode = registryEvent.getErrorCode();
                            if (errorCode != null) {
                                switch (errorCode) {
                                    case BAD_REMOTE_CONNECTION: {
                                        this.processBadConnectionEvent(this.serviceName, registryEventOriginator.getMetadataCollectionId(), registryEvent.getMetadataCollectionName(), registryEventOriginator.getServerName(), registryEventOriginator.getServerType(), registryEventOriginator.getOrganizationName(), registryEvent.getTargetMetadataCollectionId(), registryEvent.getTargetRemoteConnection(), registryEvent.getErrorMessage());
                                        break block1;
                                    }
                                    case CONFLICTING_COLLECTION_ID: {
                                        this.processConflictingCollectionIdEvent(this.serviceName, registryEventOriginator.getMetadataCollectionId(), registryEvent.getMetadataCollectionName(), registryEventOriginator.getServerName(), registryEventOriginator.getServerType(), registryEventOriginator.getOrganizationName(), registryEvent.getTargetMetadataCollectionId(), registryEvent.getErrorMessage());
                                        break block1;
                                    }
                                }
                                log.debug("Unknown registry event error code; ignoring event");
                                break;
                            }
                            log.debug("Null registry event error code, ignoring event");
                            break;
                        }
                        default: {
                            log.debug("Unknown registry event: " + String.valueOf(registryEvent));
                            break;
                        }
                    }
                } else {
                    log.debug("Ignored registry event: " + String.valueOf(registryEvent));
                }
            }
        }
        catch (Exception error) {
            String eventString = "<null>";
            if (registryEvent != null) {
                eventString = registryEvent.toString();
            }
            this.logUnexpectedException(eventString, error, "processRegistryEvent");
        }
    }

    @Override
    public void processTypeDefEvent(OMRSTypeDefEvent typeDefEvent) {
        String actionDescription = "processTypeDefEvent";
        try {
            log.debug("Processing typeDef event: " + String.valueOf(typeDefEvent));
            OMRSTypeDefEventType typeDefEventType = typeDefEvent.getTypeDefEventType();
            OMRSEventOriginator typeDefEventOriginator = typeDefEvent.getEventOriginator();
            if (typeDefEventType != null && typeDefEventOriginator != null) {
                block1 : switch (typeDefEventType) {
                    case NEW_TYPEDEF_EVENT: {
                        this.processNewTypeDefEvent(this.serviceName, typeDefEventOriginator.getMetadataCollectionId(), typeDefEventOriginator.getServerName(), typeDefEventOriginator.getServerType(), typeDefEventOriginator.getOrganizationName(), typeDefEvent.getTypeDef());
                        break;
                    }
                    case NEW_ATTRIBUTE_TYPEDEF_EVENT: {
                        this.processNewAttributeTypeDefEvent(this.serviceName, typeDefEventOriginator.getMetadataCollectionId(), typeDefEventOriginator.getServerName(), typeDefEventOriginator.getServerType(), typeDefEventOriginator.getOrganizationName(), typeDefEvent.getAttributeTypeDef());
                        break;
                    }
                    case UPDATED_TYPEDEF_EVENT: {
                        this.processUpdatedTypeDefEvent(this.serviceName, typeDefEventOriginator.getMetadataCollectionId(), typeDefEventOriginator.getServerName(), typeDefEventOriginator.getServerType(), typeDefEventOriginator.getOrganizationName(), typeDefEvent.getTypeDefPatch());
                        break;
                    }
                    case DELETED_TYPEDEF_EVENT: {
                        this.processDeletedTypeDefEvent(this.serviceName, typeDefEventOriginator.getMetadataCollectionId(), typeDefEventOriginator.getServerName(), typeDefEventOriginator.getServerType(), typeDefEventOriginator.getOrganizationName(), typeDefEvent.getTypeDefGUID(), typeDefEvent.getTypeDefName());
                        break;
                    }
                    case DELETED_ATTRIBUTE_TYPEDEF_EVENT: {
                        this.processDeletedAttributeTypeDefEvent(this.serviceName, typeDefEventOriginator.getMetadataCollectionId(), typeDefEventOriginator.getServerName(), typeDefEventOriginator.getServerType(), typeDefEventOriginator.getOrganizationName(), typeDefEvent.getTypeDefGUID(), typeDefEvent.getTypeDefName());
                        break;
                    }
                    case RE_IDENTIFIED_TYPEDEF_EVENT: {
                        this.processReIdentifiedTypeDefEvent(this.serviceName, typeDefEventOriginator.getMetadataCollectionId(), typeDefEventOriginator.getServerName(), typeDefEventOriginator.getServerType(), typeDefEventOriginator.getOrganizationName(), typeDefEvent.getOriginalTypeDefSummary(), typeDefEvent.getTypeDef());
                        break;
                    }
                    case RE_IDENTIFIED_ATTRIBUTE_TYPEDEF_EVENT: {
                        this.processReIdentifiedAttributeTypeDefEvent(this.serviceName, typeDefEventOriginator.getMetadataCollectionId(), typeDefEventOriginator.getServerName(), typeDefEventOriginator.getServerType(), typeDefEventOriginator.getOrganizationName(), typeDefEvent.getOriginalAttributeTypeDef(), typeDefEvent.getAttributeTypeDef());
                        break;
                    }
                    case TYPEDEF_ERROR_EVENT: {
                        OMRSTypeDefEventErrorCode errorCode = typeDefEvent.getErrorCode();
                        if (errorCode != null) {
                            switch (errorCode) {
                                case CONFLICTING_TYPEDEFS: {
                                    this.processTypeDefConflictEvent(this.serviceName, typeDefEventOriginator.getMetadataCollectionId(), typeDefEventOriginator.getServerName(), typeDefEventOriginator.getServerType(), typeDefEventOriginator.getOrganizationName(), typeDefEvent.getOriginalTypeDefSummary(), typeDefEvent.getOtherMetadataCollectionId(), typeDefEvent.getOtherTypeDefSummary(), typeDefEvent.getErrorMessage());
                                    break block1;
                                }
                                case CONFLICTING_ATTRIBUTE_TYPEDEFS: {
                                    this.processAttributeTypeDefConflictEvent(this.serviceName, typeDefEventOriginator.getMetadataCollectionId(), typeDefEventOriginator.getServerName(), typeDefEventOriginator.getServerType(), typeDefEventOriginator.getOrganizationName(), typeDefEvent.getOriginalAttributeTypeDef(), typeDefEvent.getOtherMetadataCollectionId(), typeDefEvent.getOtherAttributeTypeDef(), typeDefEvent.getErrorMessage());
                                    break block1;
                                }
                                case TYPEDEF_PATCH_MISMATCH: {
                                    this.processTypeDefPatchMismatchEvent(this.serviceName, typeDefEventOriginator.getMetadataCollectionId(), typeDefEventOriginator.getServerName(), typeDefEventOriginator.getServerType(), typeDefEventOriginator.getOrganizationName(), typeDefEvent.getTargetMetadataCollectionId(), typeDefEvent.getTargetTypeDefSummary(), typeDefEvent.getOtherTypeDef(), typeDefEvent.getErrorMessage());
                                    break block1;
                                }
                            }
                            log.debug("Unknown TypeDef event error code; ignoring event");
                            break;
                        }
                        log.debug("Ignored TypeDef event; null error code");
                        break;
                    }
                    default: {
                        log.debug("Ignored TypeDef event; unknown type");
                    }
                }
            }
        }
        catch (Exception error) {
            String eventString = "<null>";
            if (typeDefEvent != null) {
                eventString = typeDefEvent.toString();
            }
            this.logUnexpectedException(eventString, error, "processTypeDefEvent");
        }
    }

    @Override
    public void processInstanceEvent(OMRSInstanceEvent instanceEvent) {
        block46: {
            String actionDescription = "processInstanceEvent";
            try {
                OMRSInstanceEventType instanceEventType = instanceEvent.getInstanceEventType();
                OMRSEventOriginator instanceEventOriginator = instanceEvent.getEventOriginator();
                log.debug("Processing instance event: " + String.valueOf(instanceEvent));
                if (instanceEventType != null && instanceEventOriginator != null) {
                    block1 : switch (instanceEventType) {
                        case NEW_ENTITY_EVENT: {
                            this.processNewEntityEvent(this.serviceName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getEntity());
                            break;
                        }
                        case UPDATED_ENTITY_EVENT: {
                            this.processUpdatedEntityEvent(this.serviceName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getOriginalEntity(), instanceEvent.getEntity());
                            break;
                        }
                        case CLASSIFIED_ENTITY_EVENT: {
                            if (instanceEvent.getEntity() != null) {
                                this.processClassifiedEntityEvent(this.serviceName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getEntity(), instanceEvent.getClassification());
                                break;
                            }
                            if (instanceEvent.getEntityProxy() != null) {
                                this.processClassifiedEntityEvent(this.serviceName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getEntityProxy(), instanceEvent.getClassification());
                                break;
                            }
                            break block46;
                        }
                        case RECLASSIFIED_ENTITY_EVENT: {
                            if (instanceEvent.getEntity() != null) {
                                this.processReclassifiedEntityEvent(this.serviceName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getEntity(), instanceEvent.getOriginalClassification(), instanceEvent.getClassification());
                                break;
                            }
                            if (instanceEvent.getEntityProxy() != null) {
                                this.processReclassifiedEntityEvent(this.serviceName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getEntityProxy(), instanceEvent.getOriginalClassification(), instanceEvent.getClassification());
                                break;
                            }
                            break block46;
                        }
                        case DECLASSIFIED_ENTITY_EVENT: {
                            if (instanceEvent.getEntity() != null) {
                                this.processDeclassifiedEntityEvent(this.serviceName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getEntity(), instanceEvent.getOriginalClassification());
                                break;
                            }
                            if (instanceEvent.getEntityProxy() != null) {
                                this.processDeclassifiedEntityEvent(this.serviceName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getEntityProxy(), instanceEvent.getOriginalClassification());
                                break;
                            }
                            break block46;
                        }
                        case DELETED_ENTITY_EVENT: {
                            this.processDeletedEntityEvent(this.serviceName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getEntity());
                            break;
                        }
                        case PURGED_ENTITY_EVENT: {
                            this.processPurgedEntityEvent(this.serviceName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getTypeDefGUID(), instanceEvent.getTypeDefName(), instanceEvent.getInstanceGUID());
                            break;
                        }
                        case DELETE_PURGED_ENTITY_EVENT: {
                            this.processDeletePurgedEntityEvent(this.serviceName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getEntity());
                            break;
                        }
                        case UNDONE_ENTITY_EVENT: {
                            this.processUndoneEntityEvent(this.serviceName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getEntity());
                            break;
                        }
                        case RESTORED_ENTITY_EVENT: {
                            this.processRestoredEntityEvent(this.serviceName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getEntity());
                            break;
                        }
                        case REFRESH_ENTITY_REQUEST: {
                            this.processRefreshEntityRequested(this.serviceName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getTypeDefGUID(), instanceEvent.getTypeDefName(), instanceEvent.getInstanceGUID(), instanceEvent.getHomeMetadataCollectionId());
                            break;
                        }
                        case REFRESHED_ENTITY_EVENT: {
                            this.processRefreshEntityEvent(this.serviceName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getEntity());
                            break;
                        }
                        case RE_HOMED_ENTITY_EVENT: {
                            this.processReHomedEntityEvent(this.serviceName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getOriginalHomeMetadataCollectionId(), instanceEvent.getEntity());
                            break;
                        }
                        case RETYPED_ENTITY_EVENT: {
                            this.processReTypedEntityEvent(this.serviceName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getOriginalTypeDefSummary(), instanceEvent.getEntity());
                            break;
                        }
                        case RE_IDENTIFIED_ENTITY_EVENT: {
                            this.processReIdentifiedEntityEvent(this.serviceName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getOriginalInstanceGUID(), instanceEvent.getEntity());
                            break;
                        }
                        case NEW_RELATIONSHIP_EVENT: {
                            this.processNewRelationshipEvent(this.serviceName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getRelationship());
                            break;
                        }
                        case UPDATED_RELATIONSHIP_EVENT: {
                            this.processUpdatedRelationshipEvent(this.serviceName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getOriginalRelationship(), instanceEvent.getRelationship());
                            break;
                        }
                        case UNDONE_RELATIONSHIP_EVENT: {
                            this.processUndoneRelationshipEvent(this.serviceName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getRelationship());
                            break;
                        }
                        case DELETED_RELATIONSHIP_EVENT: {
                            this.processDeletedRelationshipEvent(this.serviceName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getRelationship());
                            break;
                        }
                        case PURGED_RELATIONSHIP_EVENT: {
                            this.processPurgedRelationshipEvent(this.serviceName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getTypeDefGUID(), instanceEvent.getTypeDefName(), instanceEvent.getInstanceGUID());
                            break;
                        }
                        case DELETE_PURGED_RELATIONSHIP_EVENT: {
                            this.processDeletePurgedRelationshipEvent(this.serviceName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getRelationship());
                            break;
                        }
                        case RESTORED_RELATIONSHIP_EVENT: {
                            this.processRestoredRelationshipEvent(this.serviceName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getRelationship());
                            break;
                        }
                        case REFRESH_RELATIONSHIP_REQUEST: {
                            this.processRefreshRelationshipRequest(this.serviceName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getTypeDefGUID(), instanceEvent.getTypeDefName(), instanceEvent.getInstanceGUID(), instanceEvent.getHomeMetadataCollectionId());
                            break;
                        }
                        case REFRESHED_RELATIONSHIP_EVENT: {
                            this.processRefreshRelationshipEvent(this.serviceName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getRelationship());
                            break;
                        }
                        case RE_IDENTIFIED_RELATIONSHIP_EVENT: {
                            this.processReIdentifiedRelationshipEvent(this.serviceName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getOriginalInstanceGUID(), instanceEvent.getRelationship());
                            break;
                        }
                        case RE_HOMED_RELATIONSHIP_EVENT: {
                            this.processReHomedRelationshipEvent(this.serviceName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getOriginalHomeMetadataCollectionId(), instanceEvent.getRelationship());
                            break;
                        }
                        case RETYPED_RELATIONSHIP_EVENT: {
                            this.processReTypedRelationshipEvent(this.serviceName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getOriginalTypeDefSummary(), instanceEvent.getRelationship());
                            break;
                        }
                        case BATCH_INSTANCES_EVENT: {
                            this.processInstanceBatchEvent(this.serviceName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getInstanceBatch());
                            break;
                        }
                        case INSTANCE_ERROR_EVENT: {
                            OMRSInstanceEventErrorCode errorCode = instanceEvent.getErrorCode();
                            if (errorCode != null) {
                                switch (errorCode) {
                                    case CONFLICTING_INSTANCES: {
                                        this.processConflictingInstancesEvent(this.serviceName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getTargetMetadataCollectionId(), instanceEvent.getTargetTypeDefSummary(), instanceEvent.getTargetInstanceGUID(), instanceEvent.getOtherMetadataCollectionId(), instanceEvent.getOtherOrigin(), instanceEvent.getOtherTypeDefSummary(), instanceEvent.getOtherInstanceGUID(), instanceEvent.getErrorMessage());
                                        break block1;
                                    }
                                    case CONFLICTING_TYPE: {
                                        this.processConflictingTypeEvent(this.serviceName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getTargetMetadataCollectionId(), instanceEvent.getTargetTypeDefSummary(), instanceEvent.getTargetInstanceGUID(), instanceEvent.getOtherTypeDefSummary(), instanceEvent.getErrorMessage());
                                        break block1;
                                    }
                                }
                                log.debug("Unknown instance event error code, ignoring event");
                                break;
                            }
                            log.debug("Ignored Instance event, null error code");
                            break;
                        }
                        default: {
                            log.debug("Ignored Instance event, unknown type");
                            break;
                        }
                    }
                    break block46;
                }
                log.debug("Ignored instance event, null type");
            }
            catch (Exception error) {
                String eventString = "<null>";
                if (instanceEvent != null) {
                    eventString = instanceEvent.toString();
                }
                this.logUnexpectedException(eventString, error, "processInstanceEvent");
            }
        }
    }

    protected void processRegistrationEvent(String sourceName, String metadataCollectionId, String metadataCollectionName, String originatorServerName, String originatorServerType, String originatorOrganizationName, Date registrationTimestamp, Connection remoteConnection) {
        log.debug("Processing registration event from: " + sourceName);
    }

    protected void processRegistrationRefreshRequest(String sourceName, String originatorServerName, String originatorServerType, String originatorOrganizationName) {
        log.debug("Processing registration refresh event from: " + sourceName);
    }

    protected void processReRegistrationEvent(String sourceName, String metadataCollectionId, String metadataCollectionName, String originatorServerName, String originatorServerType, String originatorOrganizationName, Date registrationTimestamp, Connection remoteConnection) {
        log.debug("Processing re-registration event from: " + sourceName);
    }

    protected void processUnRegistrationEvent(String sourceName, String metadataCollectionId, String metadataCollectionName, String originatorServerName, String originatorServerType, String originatorOrganizationName) {
        log.debug("Processing unregistration event from: " + sourceName);
    }

    protected void processConflictingCollectionIdEvent(String sourceName, String originatorMetadataCollectionId, String originatorMetadataCollectionName, String originatorServerName, String originatorServerType, String originatorOrganizationName, String conflictingMetadataCollectionId, String errorMessage) {
        log.debug("Processing conflicting collection id event from: " + sourceName);
    }

    protected void processBadConnectionEvent(String sourceName, String originatorMetadataCollectionId, String originatorMetadataCollectionName, String originatorServerName, String originatorServerType, String originatorOrganizationName, String targetMetadataCollectionId, Connection remoteConnection, String errorMessage) {
        log.debug("Processing bad connection event from: " + sourceName);
    }

    public void processNewTypeDefEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDef typeDef) {
        log.debug("Processing new TypeDef event from: " + sourceName);
    }

    public void processNewAttributeTypeDefEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, AttributeTypeDef attributeTypeDef) {
        log.debug("Processing new AttributeTypeDef event from: " + sourceName);
    }

    public void processUpdatedTypeDefEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDefPatch typeDefPatch) {
        log.debug("Processing updated TypeDef event from: " + sourceName);
    }

    public void processDeletedTypeDefEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String typeDefGUID, String typeDefName) {
        log.debug("Processing deleted TypeDef event from: " + sourceName);
    }

    public void processDeletedAttributeTypeDefEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String attributeTypeDefGUID, String attributeTypeDefName) {
        log.debug("Processing deleted AttributeTypeDef event from: " + sourceName);
    }

    public void processReIdentifiedTypeDefEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDefSummary originalTypeDefSummary, TypeDef typeDef) {
        log.debug("Processing re-identified TypeDef event from: " + sourceName);
    }

    public void processReIdentifiedAttributeTypeDefEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, AttributeTypeDef originalAttributeTypeDef, AttributeTypeDef attributeTypeDef) {
        log.debug("Processing re-identified AttributeTypeDef event from: " + sourceName);
    }

    public void processTypeDefConflictEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDefSummary originatorTypeDefSummary, String otherMetadataCollectionId, TypeDefSummary conflictingTypeDefSummary, String errorMessage) {
        log.debug("Processing TypeDef conflict event from: " + sourceName);
    }

    public void processAttributeTypeDefConflictEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, AttributeTypeDef originatorAttributeTypeDef, String otherMetadataCollectionId, AttributeTypeDef conflictingAttributeTypeDef, String errorMessage) {
        log.debug("Processing AttributeTypeDef conflict event from: " + sourceName);
    }

    public void processTypeDefPatchMismatchEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String targetMetadataCollectionId, TypeDefSummary targetTypeDefSummary, TypeDef otherTypeDef, String errorMessage) {
        log.debug("Processing TypeDefPatch mismatch event from: " + sourceName);
    }

    public void processNewEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        log.debug("Processing new Entity event from: " + sourceName);
    }

    public void processUpdatedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail oldEntity, EntityDetail newEntity) {
        log.debug("Processing updated Entity event from: " + sourceName);
    }

    public void processUndoneEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        log.debug("Processing undone Entity event from: " + sourceName);
    }

    public void processClassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification classification) {
        log.debug("Processing classified Entity event from: " + sourceName);
        this.processClassifiedEntityEvent(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity);
    }

    public void processClassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityProxy entity, Classification classification) {
        log.debug("Processing classified EntityProxy event from: " + sourceName);
    }

    @Deprecated
    public void processClassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        log.debug("Processing deprecated classified Entity event from: " + sourceName);
    }

    public void processDeclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification originalClassification) {
        log.debug("Processing declassified Entity event from: " + sourceName);
        this.processDeclassifiedEntityEvent(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity);
    }

    public void processDeclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityProxy entity, Classification originalClassification) {
        log.debug("Processing declassified EntityProxy event from: " + sourceName);
    }

    @Deprecated
    public void processDeclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        log.debug("Processing deprecated declassified Entity event from: " + sourceName);
    }

    public void processReclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity, Classification originalClassification, Classification classification) {
        log.debug("Processing reclassified Entity event from: " + sourceName);
        this.processReclassifiedEntityEvent(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity);
    }

    public void processReclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityProxy entity, Classification originalClassification, Classification classification) {
        log.debug("Processing reclassified EntityProxy event from: " + sourceName);
    }

    @Deprecated
    public void processReclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        log.debug("Processing deprecated reclassified Entity event from: " + sourceName);
    }

    public void processDeletedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        log.debug("Processing deleted Entity event from: " + sourceName);
    }

    public void processPurgedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String typeDefGUID, String typeDefName, String instanceGUID) {
        log.debug("Processing purged Entity event from: " + sourceName);
    }

    public void processDeletePurgedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        log.debug("Processing delete-purge entity event from: " + sourceName);
    }

    public void processRestoredEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        log.debug("Processing restored Entity event from: " + sourceName);
    }

    public void processReIdentifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalEntityGUID, EntityDetail entity) {
        log.debug("Processing re-identified Entity event from: " + sourceName);
    }

    public void processReTypedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDefSummary originalTypeDefSummary, EntityDetail entity) {
        log.debug("Processing re-typed Entity event from: " + sourceName);
    }

    public void processReHomedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalHomeMetadataCollectionId, EntityDetail entity) {
        log.debug("Processing re-homed Entity event from: " + sourceName);
    }

    public void processRefreshEntityRequested(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String typeDefGUID, String typeDefName, String instanceGUID, String homeMetadataCollectionId) {
        log.debug("Processing refresh Entity request event from: " + sourceName);
    }

    public void processRefreshEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        log.debug("Processing refresh Entity event from: " + sourceName);
    }

    public void processNewRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        log.debug("Processing new relationship event from: " + sourceName);
    }

    public void processUpdatedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship oldRelationship, Relationship newRelationship) {
        log.debug("Processing updated relationship event from: " + sourceName);
    }

    public void processUndoneRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        log.debug("Processing undone relationship event from: " + sourceName);
    }

    public void processDeletedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        log.debug("Processing deleted relationship event from: " + sourceName);
    }

    public void processPurgedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String typeDefGUID, String typeDefName, String instanceGUID) {
        log.debug("Processing purged relationship event from: " + sourceName);
    }

    public void processDeletePurgedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        log.debug("Processing delete-purge relationship event from: " + sourceName);
    }

    public void processRestoredRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        log.debug("Processing restored relationship event from: " + sourceName);
    }

    public void processReIdentifiedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalRelationshipGUID, Relationship relationship) {
        log.debug("Processing re-identified relationship event from: " + sourceName);
    }

    public void processReTypedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDefSummary originalTypeDefSummary, Relationship relationship) {
        log.debug("Processing re-typed relationship event from: " + sourceName);
    }

    public void processReHomedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalHomeMetadataCollection, Relationship relationship) {
        log.debug("Processing re-homed relationship event from: " + sourceName);
    }

    public void processRefreshRelationshipRequest(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String typeDefGUID, String typeDefName, String instanceGUID, String homeMetadataCollectionId) {
        log.debug("Processing refresh relationship request event from: " + sourceName);
    }

    public void processRefreshRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        log.debug("Processing refresh relationship event from: " + sourceName);
    }

    public void processInstanceBatchEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, InstanceGraph instances) {
        log.debug("Processing instance batch event from: " + sourceName);
        if (instances != null) {
            List<EntityDetail> entities = instances.getEntities();
            List<Relationship> relationships = instances.getRelationships();
            if (entities != null) {
                for (EntityDetail entity : entities) {
                    if (entity == null) continue;
                    this.processNewEntityEvent(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity);
                }
            }
            if (relationships != null) {
                for (Relationship relationship : relationships) {
                    if (relationship == null) continue;
                    this.processNewRelationshipEvent(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, relationship);
                }
            }
        }
    }

    public void processConflictingInstancesEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String targetMetadataCollectionId, TypeDefSummary targetTypeDefSummary, String targetInstanceGUID, String otherMetadataCollectionId, InstanceProvenanceType otherOrigin, TypeDefSummary otherTypeDefSummary, String otherInstanceGUID, String errorMessage) {
        log.debug("Processing conflicting instances event from: " + sourceName);
    }

    public void processConflictingTypeEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String targetMetadataCollectionId, TypeDefSummary targetTypeDefSummary, String targetInstanceGUID, TypeDefSummary otherTypeDefSummary, String errorMessage) {
        log.debug("Processing conflicting instance type event from: " + sourceName);
    }
}

