/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.stores.auditlogstore;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Arrays;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogRecord;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDescription;
import org.odpi.openmetadata.repositoryservices.connectors.stores.auditlogstore.OMRSAuditLogRecordOriginator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.auditlogstore.OMRSAuditLogReportingComponent;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class OMRSAuditLogRecord
extends AuditLogRecord {
    private OMRSAuditLogRecordOriginator originator = null;
    private OMRSAuditLogReportingComponent reportingComponent = null;

    public OMRSAuditLogRecord() {
    }

    public OMRSAuditLogRecord(OMRSAuditLogRecord template) {
        super((AuditLogRecord)template);
        if (template != null) {
            this.originator = template.getOriginator();
            this.reportingComponent = template.getReportingComponent();
        }
    }

    public OMRSAuditLogRecord(AuditLogRecord template) {
        super(template);
        if (template != null) {
            this.originator = new OMRSAuditLogRecordOriginator(template.getOriginatorProperties());
            this.reportingComponent = new OMRSAuditLogReportingComponent((ComponentDescription)template.getOriginatorComponent());
        }
    }

    public OMRSAuditLogRecordOriginator getOriginator() {
        return this.originator;
    }

    public void setOriginator(OMRSAuditLogRecordOriginator originator) {
        this.originator = originator;
    }

    public OMRSAuditLogReportingComponent getReportingComponent() {
        return this.reportingComponent;
    }

    public void setReportingComponent(OMRSAuditLogReportingComponent reportingComponent) {
        this.reportingComponent = reportingComponent;
    }

    public String toString() {
        return "OMRSAuditLogRecord{originator=" + String.valueOf(this.originator) + ", reportingComponent=" + String.valueOf(this.reportingComponent) + ", GUID='" + this.getGUID() + "', timeStamp=" + String.valueOf(this.getTimeStamp()) + ", originatorProperties=" + String.valueOf(this.getOriginatorProperties()) + ", originatorComponent=" + String.valueOf(this.getOriginatorComponent()) + ", actionDescription='" + this.getActionDescription() + "', threadId=" + this.getThreadId() + ", threadName='" + this.getThreadName() + "', severityCode=" + this.getSeverityCode() + ", severity='" + this.getSeverity() + "', messageId='" + this.getMessageId() + "', messageText='" + this.getMessageText() + "', messageParameters=" + Arrays.toString(this.getMessageParameters()) + ", additionalInformation=" + String.valueOf(this.getAdditionalInformation()) + ", systemAction='" + this.getSystemAction() + "', userAction='" + this.getUserAction() + "', exceptionClassName='" + this.getExceptionClassName() + "', exceptionMessage='" + this.getExceptionMessage() + "', exceptionStackTrace='" + this.getExceptionStackTrace() + "'}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || ((Object)((Object)this)).getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        OMRSAuditLogRecord logRecord = (OMRSAuditLogRecord)((Object)objectToCompare);
        return Objects.equals(this.originator, logRecord.originator) && Objects.equals(this.reportingComponent, logRecord.reportingComponent);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.originator, this.reportingComponent);
    }
}

