/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.stores.auditlogstore;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogRecord;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBase;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionDetails;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectorTypeDetails;
import org.odpi.openmetadata.repositoryservices.connectors.stores.auditlogstore.OMRSAuditLogRecord;
import org.odpi.openmetadata.repositoryservices.connectors.stores.auditlogstore.OMRSAuditLogStore;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OMRSAuditLogStoreConnectorBase
extends ConnectorBase
implements OMRSAuditLogStore {
    private static final Logger log = LoggerFactory.getLogger(OMRSAuditLogStoreConnectorBase.class);
    private static final ObjectWriter OBJECT_WRITER = new ObjectMapper().writer();
    private String destinationName = "<Unknown";
    private List<String> supportedSeverities = null;

    protected OMRSAuditLogStoreConnectorBase() {
    }

    @Override
    public String getDestinationName() {
        return this.destinationName;
    }

    @Override
    public List<String> getSupportedSeverities() {
        return this.supportedSeverities;
    }

    @Override
    public abstract String storeLogRecord(OMRSAuditLogRecord var1) throws InvalidParameterException, RepositoryErrorException;

    public String storeLogRecord(AuditLogRecord logRecord) throws InvalidParameterException, RepositoryErrorException {
        return this.storeLogRecord(new OMRSAuditLogRecord(logRecord));
    }

    @Override
    public OMRSAuditLogRecord getAuditLogRecord(String logRecordId) throws InvalidParameterException, FunctionNotSupportedException, RepositoryErrorException {
        String methodName = "getAuditLogRecord";
        this.throwQueryNotSupported("getAuditLogRecord");
        return null;
    }

    @Override
    public List<OMRSAuditLogRecord> getAuditLogRecordsByTimeStamp(Date startDate, Date endDate, int offset, int maximumRecords) throws InvalidParameterException, PagingErrorException, FunctionNotSupportedException, RepositoryErrorException {
        String methodName = "getAuditLogRecordsByTimeStamp";
        this.throwQueryNotSupported("getAuditLogRecordsByTimeStamp");
        return null;
    }

    @Override
    public List<OMRSAuditLogRecord> getAuditLogRecordsBySeverity(String severity, Date startDate, Date endDate, int offset, int maximumRecords) throws InvalidParameterException, PagingErrorException, FunctionNotSupportedException, RepositoryErrorException {
        String methodName = "getAuditLogRecordsBySeverity";
        this.throwQueryNotSupported("getAuditLogRecordsBySeverity");
        return null;
    }

    @Override
    public List<OMRSAuditLogRecord> getAuditLogRecordsByComponent(String component, Date startDate, Date endDate, int offset, int maximumRecords) throws InvalidParameterException, PagingErrorException, FunctionNotSupportedException, RepositoryErrorException {
        String methodName = "getAuditLogRecordsByComponent";
        this.throwQueryNotSupported("getAuditLogRecordsByComponent");
        return null;
    }

    protected void validateLogRecord(OMRSAuditLogRecord logRecord, String methodName) throws InvalidParameterException {
        String parameterName = "logRecord";
        if (logRecord == null) {
            throw new InvalidParameterException(OMRSErrorCode.NULL_LOG_RECORD.getMessageDefinition(this.destinationName), this.getClass().getName(), methodName, "logRecord");
        }
        if (logRecord.getOriginatorProperties() == null) {
            throw new InvalidParameterException(OMRSErrorCode.NULL_LOG_RECORD_ORIGINATOR.getMessageDefinition(this.destinationName), this.getClass().getName(), methodName, "logRecord");
        }
        if (logRecord.getOriginatorComponent() == null) {
            throw new InvalidParameterException(OMRSErrorCode.NULL_LOG_RECORD_REPORTING_COMPONENT.getMessageDefinition(this.destinationName), this.getClass().getName(), methodName, "logRecord");
        }
    }

    protected boolean isSupportedSeverity(OMRSAuditLogRecord logRecord) {
        if (logRecord != null) {
            String severity = logRecord.getSeverity();
            log.debug("Checking severity {} is in supportedSeverities {}", (Object)severity, this.supportedSeverities);
            if (severity != null) {
                if (this.supportedSeverities == null) {
                    return true;
                }
                if (this.supportedSeverities.isEmpty()) {
                    return true;
                }
                return this.supportedSeverities.contains(severity);
            }
        }
        return false;
    }

    protected String getJSONLogRecord(AuditLogRecord logRecord, String methodName) throws InvalidParameterException {
        String parameterName = "logRecord";
        try {
            return OBJECT_WRITER.writeValueAsString((Object)new AuditLogRecord(logRecord));
        }
        catch (Exception exc) {
            throw new InvalidParameterException(OMRSErrorCode.AUDIT_LOG_RECORD_NOT_JSON_ENABLED.getMessageDefinition(this.destinationName), this.getClass().getName(), methodName, exc, "logRecord");
        }
    }

    private void throwQueryNotSupported(String methodName) throws FunctionNotSupportedException {
        throw new FunctionNotSupportedException(OMRSErrorCode.CAN_NOT_QUERY_AUDIT_LOG_STORE.getMessageDefinition(this.destinationName), this.getClass().getName(), methodName);
    }

    public void initialize(String connectorInstanceId, ConnectionDetails connectionDetails) {
        super.initialize(connectorInstanceId, connectionDetails);
        if (connectionDetails != null) {
            Object supportedSeveritiesProperty;
            ConnectorTypeDetails connectorType;
            if (connectionDetails.getDisplayName() != null) {
                this.destinationName = connectionDetails.getDisplayName();
            } else if (connectionDetails.getConnectorType() != null && (connectorType = connectionDetails.getConnectorType()).getDisplayName() != null) {
                this.destinationName = connectorType.getDisplayName();
            }
            Map configurationProperties = connectionDetails.getConfigurationProperties();
            if (configurationProperties != null && (supportedSeveritiesProperty = configurationProperties.get("supportedSeverities")) != null && supportedSeveritiesProperty instanceof List) {
                try {
                    this.supportedSeverities = (List)supportedSeveritiesProperty;
                    if (this.supportedSeverities.isEmpty()) {
                        this.supportedSeverities = null;
                    }
                }
                catch (Exception error) {
                    log.debug("Ignored exception: {} with message {}", (Object)error.getClass().getName(), (Object)error.getMessage());
                }
            }
        }
    }
}

