/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceElementHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class InstanceGraph
extends InstanceElementHeader {
    private static final long serialVersionUID = 1L;
    public static final long CURRENT_INSTANCE_GRAPH_HEADER_VERSION = 1L;
    private List<EntityDetail> entities = null;
    private List<Relationship> relationships = null;

    public InstanceGraph() {
    }

    public InstanceGraph(List<EntityDetail> entities, List<Relationship> relationships) {
        this.entities = entities == null ? null : new ArrayList<EntityDetail>(entities);
        this.relationships = relationships == null ? null : new ArrayList<Relationship>(relationships);
    }

    public InstanceGraph(InstanceGraph templateGraph) {
        super(templateGraph);
        if (templateGraph != null) {
            this.setEntities(templateGraph.getEntities());
            this.setRelationships(templateGraph.getRelationships());
        }
    }

    public List<EntityDetail> getEntities() {
        if (this.entities == null) {
            return null;
        }
        if (this.entities.isEmpty()) {
            return null;
        }
        return new ArrayList<EntityDetail>(this.entities);
    }

    public void setEntities(List<EntityDetail> entityElementList) {
        this.entities = entityElementList;
    }

    public List<Relationship> getRelationships() {
        if (this.relationships == null) {
            return null;
        }
        if (this.relationships.isEmpty()) {
            return null;
        }
        return new ArrayList<Relationship>(this.relationships);
    }

    public void setRelationships(List<Relationship> relationshipElementList) {
        this.relationships = relationshipElementList;
    }

    public List<Relationship> returnRelationshipsForEntity(String anchorEntityGUID) {
        ArrayList<Relationship> matchingRelationships = new ArrayList<Relationship>();
        if (this.relationships != null) {
            for (Relationship relationship : this.relationships) {
                if (!relationship.relatedToEntity(anchorEntityGUID)) continue;
                matchingRelationships.add(new Relationship(relationship));
            }
        }
        if (matchingRelationships.isEmpty()) {
            return null;
        }
        return matchingRelationships;
    }

    public EntityDetail returnLinkedEntity(String anchorEntityGUID, String linkingRelationshipGUID) {
        Relationship matchingRelationship = null;
        EntityDetail linkedEntity = null;
        if (this.relationships != null) {
            for (Relationship relationship : this.relationships) {
                if (!relationship.getGUID().equals(linkingRelationshipGUID)) continue;
                matchingRelationship = relationship;
                break;
            }
        }
        if (matchingRelationship == null) {
            return null;
        }
        String linkedEntityGUID = matchingRelationship.returnLinkedEntity(anchorEntityGUID);
        if (linkedEntityGUID == null) {
            return null;
        }
        for (EntityDetail entity : this.entities) {
            if (!entity.getGUID().equals(linkedEntityGUID)) continue;
            linkedEntity = new EntityDetail(entity);
            break;
        }
        return linkedEntity;
    }

    public int returnEntityElementCount() {
        return this.entities.size();
    }

    public int returnRelationshipElementCount() {
        return this.relationships.size();
    }

    public String toString() {
        return "InstanceGraph{entities=" + String.valueOf(this.entities) + ", relationships=" + String.valueOf(this.relationships) + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof InstanceGraph)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        InstanceGraph that = (InstanceGraph)objectToCompare;
        if (this.entities != null ? !this.entities.equals(that.entities) : that.entities != null) {
            return false;
        }
        return this.relationships != null ? this.relationships.equals(that.relationships) : that.relationships == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.entities != null ? this.entities.hashCode() : 0);
        result = 31 * result + (this.relationships != null ? this.relationships.hashCode() : 0);
        return result;
    }
}

