/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ArrayPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceElementHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.StructPropertyValue;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=ArrayPropertyValue.class, name="ArrayPropertyValue"), @JsonSubTypes.Type(value=EnumPropertyValue.class, name="EnumPropertyValue"), @JsonSubTypes.Type(value=MapPropertyValue.class, name="MapPropertyValue"), @JsonSubTypes.Type(value=PrimitivePropertyValue.class, name="PrimitivePropertyValue"), @JsonSubTypes.Type(value=StructPropertyValue.class, name="StructPropertyValue")})
public abstract class InstancePropertyValue
extends InstanceElementHeader {
    private static final long serialVersionUID = 1L;
    public static final long CURRENT_INSTANCE_PROPERTY_VALUE_HEADER_VERSION = 1L;
    private InstancePropertyCategory instancePropertyCategory = null;
    private String typeGUID = null;
    private String typeName = null;

    protected InstancePropertyValue() {
    }

    protected InstancePropertyValue(InstancePropertyCategory instancePropertyCategory) {
        this.instancePropertyCategory = instancePropertyCategory;
    }

    protected InstancePropertyValue(InstancePropertyValue template) {
        super(template);
        if (template != null) {
            this.instancePropertyCategory = template.getInstancePropertyCategory();
            this.typeGUID = template.getTypeGUID();
            this.typeName = template.getTypeName();
        }
    }

    public abstract InstancePropertyValue cloneFromSubclass();

    public abstract String valueAsString();

    public abstract Object valueAsObject();

    protected <K, V extends InstancePropertyValue> Map<K, Object> mapValuesAsObject(Map<K, V> valMap) {
        return this.convertValues(valMap, entry -> entry.getValue() == null ? null : ((InstancePropertyValue)entry.getValue()).valueAsObject());
    }

    protected <K, V extends InstancePropertyValue> Map<K, String> mapValuesAsString(Map<K, V> valMap) {
        return this.convertValues(valMap, entry -> entry.getValue() == null ? "<null>" : ((InstancePropertyValue)entry.getValue()).valueAsString());
    }

    private <K, V extends InstancePropertyValue, R> Map<K, R> convertValues(Map<K, V> valMap, Function<Map.Entry<K, V>, R> mapper) {
        return Optional.ofNullable(valMap).map(Map::entrySet).map(Collection::stream).orElseGet(Stream::empty).collect(HashMap::new, (m, e) -> m.put(e.getKey(), mapper.apply((Map.Entry)e)), HashMap::putAll);
    }

    public InstancePropertyCategory getInstancePropertyCategory() {
        return this.instancePropertyCategory;
    }

    public void setInstancePropertyCategory(InstancePropertyCategory instancePropertyCategory) {
        this.instancePropertyCategory = instancePropertyCategory;
    }

    public String getTypeGUID() {
        return this.typeGUID;
    }

    public void setTypeGUID(String typeGUID) {
        this.typeGUID = typeGUID;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String toString() {
        return "InstancePropertyValue{instancePropertyCategory=" + String.valueOf(this.instancePropertyCategory) + ", typeGUID='" + this.typeGUID + "', typeName='" + this.typeName + "'}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof InstancePropertyValue)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        InstancePropertyValue that = (InstancePropertyValue)objectToCompare;
        if (this.instancePropertyCategory != that.instancePropertyCategory) {
            return false;
        }
        if (this.typeGUID != null ? !this.typeGUID.equals(that.typeGUID) : that.typeGUID != null) {
            return false;
        }
        return this.typeName != null ? this.typeName.equals(that.typeName) : that.typeName == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.instancePropertyCategory != null ? this.instancePropertyCategory.hashCode() : 0);
        result = 31 * result + (this.typeGUID != null ? this.typeGUID.hashCode() : 0);
        result = 31 * result + (this.typeName != null ? this.typeName.hashCode() : 0);
        return result;
    }
}

