/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.events;

import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.events.OMRSEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSEventCategory;
import org.odpi.openmetadata.repositoryservices.events.OMRSTypeDefEventErrorCode;
import org.odpi.openmetadata.repositoryservices.events.OMRSTypeDefEventType;
import org.odpi.openmetadata.repositoryservices.events.beans.v1.OMRSEventV1;
import org.odpi.openmetadata.repositoryservices.events.beans.v1.OMRSEventV1TypeDefSection;

public class OMRSTypeDefEvent
extends OMRSEvent {
    private OMRSTypeDefEventType typeDefEventType = OMRSTypeDefEventType.UNKNOWN_TYPEDEF_EVENT;
    private AttributeTypeDef attributeTypeDef = null;
    private TypeDef typeDef = null;
    private String typeDefGUID = null;
    private String typeDefName = null;
    private TypeDefPatch typeDefPatch = null;
    private TypeDefSummary originalTypeDefSummary = null;
    private AttributeTypeDef originalAttributeTypeDef = null;
    private OMRSTypeDefEventErrorCode errorCode = OMRSTypeDefEventErrorCode.NOT_IN_USE;

    public OMRSTypeDefEvent(OMRSEventV1 inboundEvent) {
        super(inboundEvent);
        OMRSEventV1TypeDefSection typeDefSection = inboundEvent.getTypeDefEventSection();
        if (typeDefSection != null) {
            this.typeDefEventType = typeDefSection.getTypeDefEventType();
            this.attributeTypeDef = typeDefSection.getAttributeTypeDef();
            this.typeDef = typeDefSection.getTypeDef();
            this.typeDefGUID = typeDefSection.getTypeDefGUID();
            this.typeDefName = typeDefSection.getTypeDefName();
            this.typeDefPatch = typeDefSection.getTypeDefPatch();
            this.originalTypeDefSummary = typeDefSection.getOriginalTypeDefSummary();
            this.originalAttributeTypeDef = typeDefSection.getOriginalAttributeTypeDef();
        }
        if (this.genericErrorCode != null) {
            switch (this.genericErrorCode) {
                case CONFLICTING_TYPEDEFS: {
                    this.errorCode = OMRSTypeDefEventErrorCode.CONFLICTING_TYPEDEFS;
                    break;
                }
                case CONFLICTING_ATTRIBUTE_TYPEDEFS: {
                    this.errorCode = OMRSTypeDefEventErrorCode.CONFLICTING_ATTRIBUTE_TYPEDEFS;
                    break;
                }
                case TYPEDEF_PATCH_MISMATCH: {
                    this.errorCode = OMRSTypeDefEventErrorCode.TYPEDEF_PATCH_MISMATCH;
                    break;
                }
                default: {
                    this.errorCode = OMRSTypeDefEventErrorCode.UNKNOWN_ERROR_CODE;
                }
            }
        }
    }

    public OMRSTypeDefEvent(OMRSTypeDefEventType typeDefEventType, TypeDef typeDef) {
        super(OMRSEventCategory.TYPEDEF);
        this.typeDefEventType = typeDefEventType;
        this.typeDef = typeDef;
    }

    public OMRSTypeDefEvent(OMRSTypeDefEventType typeDefEventType, AttributeTypeDef attributeTypeDef) {
        super(OMRSEventCategory.TYPEDEF);
        this.typeDefEventType = typeDefEventType;
        this.attributeTypeDef = attributeTypeDef;
    }

    public OMRSTypeDefEvent(OMRSTypeDefEventType typeDefEventType, TypeDefPatch typeDefPatch) {
        super(OMRSEventCategory.TYPEDEF);
        this.typeDefEventType = typeDefEventType;
        this.typeDefPatch = typeDefPatch;
    }

    public OMRSTypeDefEvent(OMRSTypeDefEventType typeDefEventType, String typeDefGUID, String typeDefName) {
        super(OMRSEventCategory.TYPEDEF);
        this.typeDefEventType = typeDefEventType;
        this.typeDefGUID = typeDefGUID;
        this.typeDefName = typeDefName;
    }

    public OMRSTypeDefEvent(OMRSTypeDefEventType typeDefEventType, TypeDefSummary originalTypeDefSummary, TypeDef typeDef) {
        super(OMRSEventCategory.TYPEDEF);
        this.typeDefEventType = typeDefEventType;
        this.originalTypeDefSummary = originalTypeDefSummary;
        this.typeDef = typeDef;
    }

    public OMRSTypeDefEvent(OMRSTypeDefEventType typeDefEventType, AttributeTypeDef originalAttributeTypeDef, AttributeTypeDef attributeTypeDef) {
        super(OMRSEventCategory.TYPEDEF);
        this.typeDefEventType = typeDefEventType;
        this.originalAttributeTypeDef = originalAttributeTypeDef;
        this.attributeTypeDef = attributeTypeDef;
    }

    public OMRSTypeDefEvent(OMRSTypeDefEventErrorCode errorCode, String errorMessage, TypeDefSummary originatorTypeDefSummary, String otherMetadataCollectionId, TypeDefSummary otherTypeDefSummary) {
        super(OMRSEventCategory.TYPEDEF, errorCode.getEncoding(), errorMessage, otherMetadataCollectionId, otherTypeDefSummary);
        this.originalTypeDefSummary = originatorTypeDefSummary;
        this.typeDefEventType = OMRSTypeDefEventType.TYPEDEF_ERROR_EVENT;
    }

    public OMRSTypeDefEvent(OMRSTypeDefEventErrorCode errorCode, String errorMessage, AttributeTypeDef originatorAttributeTypeDef, String otherMetadataCollectionId, AttributeTypeDef otherAttributeTypeDef) {
        super(OMRSEventCategory.TYPEDEF, errorCode.getEncoding(), errorMessage, otherMetadataCollectionId, otherAttributeTypeDef);
        this.originalAttributeTypeDef = originatorAttributeTypeDef;
        this.typeDefEventType = OMRSTypeDefEventType.TYPEDEF_ERROR_EVENT;
    }

    public OMRSTypeDefEvent(OMRSTypeDefEventErrorCode errorCode, String errorMessage, String targetMetadataCollectionId, AttributeTypeDef targetAttributeTypeDef, AttributeTypeDef otherAttributeTypeDef) {
        super(OMRSEventCategory.TYPEDEF, errorCode.getEncoding(), errorMessage, targetMetadataCollectionId, targetAttributeTypeDef, otherAttributeTypeDef);
        this.typeDefEventType = OMRSTypeDefEventType.TYPEDEF_ERROR_EVENT;
    }

    public OMRSTypeDefEvent(OMRSTypeDefEventErrorCode errorCode, String errorMessage, String targetMetadataCollectionId, TypeDefSummary targetTypeDefSummary, TypeDef otherTypeDef) {
        super(OMRSEventCategory.TYPEDEF, errorCode.getEncoding(), errorMessage, targetMetadataCollectionId, targetTypeDefSummary, otherTypeDef);
        this.typeDefEventType = OMRSTypeDefEventType.TYPEDEF_ERROR_EVENT;
    }

    public OMRSTypeDefEventType getTypeDefEventType() {
        return this.typeDefEventType;
    }

    public TypeDef getTypeDef() {
        return this.typeDef;
    }

    public AttributeTypeDef getAttributeTypeDef() {
        return this.attributeTypeDef;
    }

    public String getTypeDefGUID() {
        return this.typeDefGUID;
    }

    public String getTypeDefName() {
        return this.typeDefName;
    }

    public TypeDefPatch getTypeDefPatch() {
        return this.typeDefPatch;
    }

    public TypeDefSummary getOriginalTypeDefSummary() {
        return this.originalTypeDefSummary;
    }

    public AttributeTypeDef getOriginalAttributeTypeDef() {
        return this.originalAttributeTypeDef;
    }

    public OMRSTypeDefEventErrorCode getErrorCode() {
        return this.errorCode;
    }

    @Override
    public OMRSEventV1 getOMRSEventV1() {
        OMRSEventV1 omrsEvent = super.getOMRSEventV1();
        OMRSEventV1TypeDefSection typeDefSection = new OMRSEventV1TypeDefSection();
        typeDefSection.setTypeDefEventType(this.typeDefEventType);
        typeDefSection.setTypeDef(this.typeDef);
        typeDefSection.setAttributeTypeDef(this.attributeTypeDef);
        typeDefSection.setTypeDefPatch(this.typeDefPatch);
        typeDefSection.setTypeDefGUID(this.typeDefGUID);
        typeDefSection.setTypeDefName(this.typeDefName);
        typeDefSection.setOriginalTypeDefSummary(this.originalTypeDefSummary);
        typeDefSection.setOriginalAttributeTypeDef(this.originalAttributeTypeDef);
        omrsEvent.setTypeDefEventSection(typeDefSection);
        return omrsEvent;
    }

    @Override
    public String toString() {
        return "OMRSTypeDefEvent{typeDefEventType=" + String.valueOf(this.typeDefEventType) + ", attributeTypeDef=" + String.valueOf(this.attributeTypeDef) + ", typeDef=" + String.valueOf(this.typeDef) + ", typeDefGUID='" + this.typeDefGUID + "', typeDefName='" + this.typeDefName + "', typeDefPatch=" + String.valueOf(this.typeDefPatch) + ", originalTypeDefSummary=" + String.valueOf(this.originalTypeDefSummary) + ", originalAttributeTypeDef=" + String.valueOf(this.originalAttributeTypeDef) + ", errorCode=" + String.valueOf(this.errorCode) + ", eventTimestamp=" + String.valueOf(this.eventTimestamp) + ", eventDirection=" + String.valueOf(this.eventDirection) + ", eventCategory=" + String.valueOf(this.eventCategory) + ", eventOriginator=" + String.valueOf(this.eventOriginator) + ", genericErrorCode=" + String.valueOf(this.genericErrorCode) + ", errorMessage='" + this.errorMessage + "', targetMetadataCollectionId='" + this.targetMetadataCollectionId + "', targetRemoteConnection=" + String.valueOf(this.targetRemoteConnection) + ", targetTypeDefSummary=" + String.valueOf(this.targetTypeDefSummary) + ", targetAttributeTypeDef=" + String.valueOf(this.targetAttributeTypeDef) + ", targetInstanceGUID='" + this.targetInstanceGUID + "', otherOrigin=" + String.valueOf(this.otherOrigin) + ", otherMetadataCollectionId='" + this.otherMetadataCollectionId + "', otherTypeDefSummary=" + String.valueOf(this.otherTypeDefSummary) + ", otherTypeDef=" + String.valueOf(this.otherTypeDef) + ", otherAttributeTypeDef=" + String.valueOf(this.otherAttributeTypeDef) + ", otherInstanceGUID='" + this.otherInstanceGUID + "'}";
    }
}

