/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.rest.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Arrays;
import java.util.Objects;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.rest.properties.OMRSAPIResponse;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ClassificationResponse
extends OMRSAPIResponse {
    private static final long serialVersionUID = 1L;
    private Classification classification = null;

    public ClassificationResponse() {
    }

    public ClassificationResponse(ClassificationResponse template) {
        super(template);
        if (template != null) {
            this.classification = template.getClassification();
        }
    }

    public Classification getClassification() {
        if (this.classification == null) {
            return null;
        }
        return new Classification(this.classification);
    }

    public void setClassification(Classification classification) {
        this.classification = classification;
    }

    @Override
    public String toString() {
        return "ClassificationResponse{classification=" + String.valueOf(this.classification) + ", relatedHTTPCode=" + this.relatedHTTPCode + ", actionDescription='" + this.actionDescription + "', exceptionClassName='" + this.exceptionClassName + "', exceptionCausedBy='" + this.exceptionCausedBy + "', exceptionErrorMessage='" + this.exceptionErrorMessage + "', exceptionErrorMessageId='" + this.exceptionErrorMessageId + "', exceptionErrorMessageParameters=" + Arrays.toString(this.exceptionErrorMessageParameters) + ", exceptionSystemAction='" + this.exceptionSystemAction + "', exceptionUserAction='" + this.exceptionUserAction + "', exceptionProperties=" + String.valueOf(this.exceptionProperties) + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof ClassificationResponse)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        ClassificationResponse that = (ClassificationResponse)objectToCompare;
        return Objects.equals(this.getClassification(), that.getClassification());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getClassification());
    }
}

