/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.archiveutilities;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveInstanceStore;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveTypeStore;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationEntityExtension;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.CollectionDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.utilities.OMRSRepositoryPropertiesUtilities;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMRSArchiveBuilder {
    private OpenMetadataArchiveProperties archiveProperties;
    private Map<String, PrimitiveDef> primitiveDefMap = new HashMap<String, PrimitiveDef>();
    private List<PrimitiveDef> primitiveDefList = new ArrayList<PrimitiveDef>();
    private Map<String, EnumDef> enumDefMap = new HashMap<String, EnumDef>();
    private List<EnumDef> enumDefList = new ArrayList<EnumDef>();
    private Map<String, CollectionDef> collectionDefMap = new HashMap<String, CollectionDef>();
    private List<CollectionDef> collectionDefList = new ArrayList<CollectionDef>();
    private Map<String, ClassificationDef> classificationDefMap = new HashMap<String, ClassificationDef>();
    private List<ClassificationDef> classificationDefList = new ArrayList<ClassificationDef>();
    private Map<String, EntityDef> entityDefMap = new HashMap<String, EntityDef>();
    private List<EntityDef> entityDefList = new ArrayList<EntityDef>();
    private Map<String, RelationshipDef> relationshipDefMap = new HashMap<String, RelationshipDef>();
    private List<RelationshipDef> relationshipDefList = new ArrayList<RelationshipDef>();
    private List<TypeDefPatch> typeDefPatchList = new ArrayList<TypeDefPatch>();
    private Map<String, EntityDetail> entityDetailMap = new HashMap<String, EntityDetail>();
    private List<EntityDetail> entityDetailList = new ArrayList<EntityDetail>();
    private Map<String, Relationship> relationshipMap = new HashMap<String, Relationship>();
    private List<Relationship> relationshipList = new ArrayList<Relationship>();
    private Map<String, ClassificationEntityExtension> classificationMap = new HashMap<String, ClassificationEntityExtension>();
    private List<ClassificationEntityExtension> classificationList = new ArrayList<ClassificationEntityExtension>();
    private Map<String, Object> guidMap = new HashMap<String, Object>();
    private Map<String, Object> nameMap = new HashMap<String, Object>();
    private Map<String, Set<String>> entityAttributeMap = new HashMap<String, Set<String>>();
    private static final Logger log = LoggerFactory.getLogger(OMRSArchiveBuilder.class);

    public OMRSArchiveBuilder(String archiveGUID, String archiveName, String archiveDescription, OpenMetadataArchiveType archiveType, String originatorName, Date creationDate, List<OpenMetadataArchive> dependsOnArchives) {
        this(archiveGUID, archiveName, archiveDescription, archiveType, null, originatorName, null, creationDate, dependsOnArchives);
    }

    public OMRSArchiveBuilder(String archiveGUID, String archiveName, String archiveDescription, OpenMetadataArchiveType archiveType, String originatorName, String originatorLicense, Date creationDate, List<OpenMetadataArchive> dependsOnArchives) {
        this(archiveGUID, archiveName, archiveDescription, archiveType, null, originatorName, originatorLicense, creationDate, dependsOnArchives);
    }

    public OMRSArchiveBuilder(String archiveGUID, String archiveName, String archiveDescription, OpenMetadataArchiveType archiveType, String archiveVersion, String originatorName, String originatorLicense, Date creationDate, List<OpenMetadataArchive> dependsOnArchives) {
        String methodName = "OMRSArchiveBuilder constructor";
        this.archiveProperties = new OpenMetadataArchiveProperties();
        this.archiveProperties.setArchiveGUID(archiveGUID);
        this.archiveProperties.setArchiveName(archiveName);
        this.archiveProperties.setArchiveDescription(archiveDescription);
        this.archiveProperties.setArchiveType(archiveType);
        this.archiveProperties.setArchiveVersion(archiveVersion);
        this.archiveProperties.setOriginatorName(originatorName);
        this.archiveProperties.setOriginatorLicense(originatorLicense);
        this.archiveProperties.setCreationDate(creationDate);
        if (dependsOnArchives == null) {
            this.archiveProperties.setDependsOnArchives(null);
        } else {
            ArrayList<String> dependsOnArchiveGUIDs = new ArrayList<String>();
            for (OpenMetadataArchive openMetadataArchive : dependsOnArchives) {
                List classifications;
                List relationships;
                OpenMetadataArchiveInstanceStore instanceStore;
                Object typeDefPatches;
                OpenMetadataArchiveTypeStore typeStore;
                if (openMetadataArchive == null) continue;
                OpenMetadataArchiveProperties dependentArchiveProperties = openMetadataArchive.getArchiveProperties();
                if (dependentArchiveProperties != null && dependentArchiveProperties.getArchiveGUID() != null) {
                    dependsOnArchiveGUIDs.add(dependentArchiveProperties.getArchiveGUID());
                }
                if ((typeStore = openMetadataArchive.getArchiveTypeStore()) != null) {
                    List typeDefs;
                    List attributeTypeDefs = typeStore.getAttributeTypeDefs();
                    if (attributeTypeDefs != null) {
                        for (AttributeTypeDef attributeTypeDef : attributeTypeDefs) {
                            if (attributeTypeDef == null) continue;
                            this.guidMap.put(attributeTypeDef.getGUID(), attributeTypeDef);
                            this.nameMap.put(attributeTypeDef.getName(), attributeTypeDef);
                            switch (attributeTypeDef.getCategory()) {
                                case PRIMITIVE: {
                                    this.primitiveDefMap.put(attributeTypeDef.getGUID(), (PrimitiveDef)attributeTypeDef);
                                    break;
                                }
                                case COLLECTION: {
                                    this.collectionDefMap.put(attributeTypeDef.getGUID(), (CollectionDef)attributeTypeDef);
                                    break;
                                }
                                case ENUM_DEF: {
                                    this.enumDefMap.put(attributeTypeDef.getGUID(), (EnumDef)attributeTypeDef);
                                }
                            }
                        }
                    }
                    if ((typeDefs = typeStore.getNewTypeDefs()) != null) {
                        AttributeTypeDef attributeTypeDef;
                        attributeTypeDef = typeDefs.iterator();
                        while (attributeTypeDef.hasNext()) {
                            TypeDef typeDef = (TypeDef)attributeTypeDef.next();
                            if (typeDef == null) continue;
                            this.addTypeToMaps(typeDef);
                        }
                    }
                    if ((typeDefPatches = typeStore.getTypeDefPatches()) != null) {
                        OMRSRepositoryPropertiesUtilities utilities = new OMRSRepositoryPropertiesUtilities();
                        Iterator iterator = typeDefPatches.iterator();
                        while (iterator.hasNext()) {
                            TypeDefPatch typeDefPatch = (TypeDefPatch)iterator.next();
                            if (typeDefPatch == null) continue;
                            TypeDef originalTypeDef = this.getTypeDefByName(typeDefPatch.getTypeDefName());
                            try {
                                TypeDef updatedTypeDef = utilities.applyPatch(openMetadataArchive.getArchiveProperties().getArchiveName(), originalTypeDef, typeDefPatch, "OMRSArchiveBuilder constructor");
                                if (updatedTypeDef == null) continue;
                                this.addTypeToMaps(updatedTypeDef);
                            }
                            catch (Throwable error) {
                                throw new OMRSLogicErrorException(OMRSErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(new String[]{error.getClass().getName(), "OMRSArchiveBuilder constructor", error.getMessage()}), this.getClass().getName(), "OMRSArchiveBuilder constructor", error);
                            }
                        }
                    }
                }
                if ((instanceStore = openMetadataArchive.getArchiveInstanceStore()) == null) continue;
                List entities = instanceStore.getEntities();
                if (entities != null) {
                    typeDefPatches = entities.iterator();
                    while (typeDefPatches.hasNext()) {
                        EntityDetail entity = (EntityDetail)typeDefPatches.next();
                        if (entity == null) continue;
                        this.guidMap.put(entity.getGUID(), entity);
                        this.entityDetailMap.put(entity.getGUID(), entity);
                        this.entityDetailList.add(entity);
                    }
                }
                if ((relationships = instanceStore.getRelationships()) != null) {
                    for (Relationship relationship : relationships) {
                        if (relationship == null) continue;
                        this.guidMap.put(relationship.getGUID(), relationship);
                        this.relationshipMap.put(relationship.getGUID(), relationship);
                        this.relationshipList.add(relationship);
                    }
                }
                if ((classifications = instanceStore.getClassifications()) == null) continue;
                for (ClassificationEntityExtension classification : classifications) {
                    if (classification == null) continue;
                    String classificationId = classification.getEntityToClassify().getGUID() + ":" + classification.getClassification().getName();
                    ClassificationEntityExtension duplicateElement = this.classificationMap.put(classificationId, classification);
                    this.classificationList.add(classification);
                }
            }
            if (!dependsOnArchiveGUIDs.isEmpty()) {
                this.archiveProperties.setDependsOnArchives(dependsOnArchiveGUIDs);
            } else {
                this.archiveProperties.setDependsOnArchives(null);
            }
        }
    }

    private void addTypeToMaps(TypeDef typeDef) {
        this.guidMap.put(typeDef.getGUID(), typeDef);
        this.nameMap.put(typeDef.getName(), typeDef);
        switch (typeDef.getCategory()) {
            case ENTITY_DEF: {
                this.entityDefMap.put(typeDef.getGUID(), (EntityDef)typeDef);
                break;
            }
            case RELATIONSHIP_DEF: {
                this.relationshipDefMap.put(typeDef.getGUID(), (RelationshipDef)typeDef);
                break;
            }
            case CLASSIFICATION_DEF: {
                this.classificationDefMap.put(typeDef.getGUID(), (ClassificationDef)typeDef);
            }
        }
    }

    public void addPrimitiveDef(PrimitiveDef primitiveDef) {
        String methodName = "addPrimitiveDef";
        if (primitiveDef != null) {
            log.debug("Adding PrimitiveDef: " + primitiveDef.toString());
            this.checkForBlanksInTypeName(primitiveDef.getName());
            PrimitiveDef duplicateElement = this.primitiveDefMap.put(primitiveDef.getName(), primitiveDef);
            if (duplicateElement != null) {
                throw new OMRSLogicErrorException(OMRSErrorCode.DUPLICATE_TYPE_IN_ARCHIVE.getMessageDefinition(new String[]{primitiveDef.getName(), AttributeTypeDefCategory.PRIMITIVE.getName(), duplicateElement.toString(), primitiveDef.toString()}), this.getClass().getName(), "addPrimitiveDef");
            }
            Object duplicateGUID = this.guidMap.put(primitiveDef.getGUID(), primitiveDef);
            if (duplicateGUID != null) {
                throw new OMRSLogicErrorException(OMRSErrorCode.DUPLICATE_GUID_IN_ARCHIVE.getMessageDefinition(new String[]{primitiveDef.getGUID(), duplicateGUID.toString(), primitiveDef.toString()}), this.getClass().getName(), "addPrimitiveDef");
            }
            Object duplicateName = this.nameMap.put(primitiveDef.getName(), primitiveDef);
            if (duplicateName != null) {
                throw new OMRSLogicErrorException(OMRSErrorCode.DUPLICATE_TYPENAME_IN_ARCHIVE.getMessageDefinition(new String[]{primitiveDef.getGUID(), duplicateName.toString(), primitiveDef.toString()}), this.getClass().getName(), "addPrimitiveDef");
            }
            this.primitiveDefList.add(primitiveDef);
        }
    }

    public PrimitiveDef getPrimitiveDef(String primitiveDefName) {
        String methodName = "getPrimitiveDef";
        log.debug("Retrieving PrimitiveDef: " + primitiveDefName);
        if (primitiveDefName != null) {
            PrimitiveDef primitiveDef = this.primitiveDefMap.get(primitiveDefName);
            if (primitiveDef == null) {
                throw new OMRSLogicErrorException(OMRSErrorCode.MISSING_TYPE_IN_ARCHIVE.getMessageDefinition(new String[]{primitiveDefName, AttributeTypeDefCategory.PRIMITIVE.getName()}), this.getClass().getName(), "getPrimitiveDef");
            }
            return primitiveDef;
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.MISSING_NAME_FOR_ARCHIVE.getMessageDefinition(new String[]{AttributeTypeDefCategory.PRIMITIVE.getName()}), this.getClass().getName(), "getPrimitiveDef");
    }

    public void addCollectionDef(CollectionDef collectionDef) {
        String methodName = "addCollectionDef";
        if (collectionDef != null) {
            log.debug("Adding CollectionDef: " + collectionDef.toString());
            this.checkForBlanksInTypeName(collectionDef.getName());
            CollectionDef duplicateElement = this.collectionDefMap.put(collectionDef.getName(), collectionDef);
            if (duplicateElement != null) {
                throw new OMRSLogicErrorException(OMRSErrorCode.DUPLICATE_TYPE_IN_ARCHIVE.getMessageDefinition(new String[]{collectionDef.getName(), AttributeTypeDefCategory.COLLECTION.getName(), duplicateElement.toString(), collectionDef.toString()}), this.getClass().getName(), "addCollectionDef");
            }
            Object duplicateGUID = this.guidMap.put(collectionDef.getGUID(), collectionDef);
            if (duplicateGUID != null) {
                throw new OMRSLogicErrorException(OMRSErrorCode.DUPLICATE_GUID_IN_ARCHIVE.getMessageDefinition(new String[]{collectionDef.getGUID(), duplicateGUID.toString(), collectionDef.toString()}), this.getClass().getName(), "addCollectionDef");
            }
            Object duplicateName = this.nameMap.put(collectionDef.getName(), collectionDef);
            if (duplicateName != null) {
                throw new OMRSLogicErrorException(OMRSErrorCode.DUPLICATE_TYPENAME_IN_ARCHIVE.getMessageDefinition(new String[]{collectionDef.getGUID(), duplicateName.toString(), collectionDef.toString()}), this.getClass().getName(), "addCollectionDef");
            }
            this.collectionDefList.add(collectionDef);
        }
    }

    CollectionDef getCollectionDef(String collectionDefName) {
        String methodName = "getCollectionDef";
        log.debug("Retrieving CollectionDef: " + collectionDefName);
        if (collectionDefName != null) {
            CollectionDef collectionDef = this.collectionDefMap.get(collectionDefName);
            if (collectionDef == null) {
                throw new OMRSLogicErrorException(OMRSErrorCode.MISSING_TYPE_IN_ARCHIVE.getMessageDefinition(new String[]{collectionDefName, AttributeTypeDefCategory.COLLECTION.getName()}), this.getClass().getName(), "getCollectionDef");
            }
            return collectionDef;
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.MISSING_NAME_FOR_ARCHIVE.getMessageDefinition(new String[]{AttributeTypeDefCategory.COLLECTION.getName()}), this.getClass().getName(), "getCollectionDef");
    }

    public void addEnumDef(EnumDef enumDef) {
        String methodName = "addEnumDef";
        if (enumDef != null) {
            log.debug("Adding EnumDef: " + enumDef.toString());
            this.checkForBlanksInTypeName(enumDef.getName());
            EnumDef duplicateElement = this.enumDefMap.put(enumDef.getName(), enumDef);
            if (duplicateElement != null) {
                throw new OMRSLogicErrorException(OMRSErrorCode.DUPLICATE_TYPE_IN_ARCHIVE.getMessageDefinition(new String[]{enumDef.getName(), AttributeTypeDefCategory.ENUM_DEF.getName(), duplicateElement.toString(), enumDef.toString()}), this.getClass().getName(), "addEnumDef");
            }
            Object duplicateGUID = this.guidMap.put(enumDef.getGUID(), enumDef);
            if (duplicateGUID != null) {
                throw new OMRSLogicErrorException(OMRSErrorCode.DUPLICATE_GUID_IN_ARCHIVE.getMessageDefinition(new String[]{enumDef.getGUID(), duplicateGUID.toString(), enumDef.toString()}), this.getClass().getName(), "addEnumDef");
            }
            Object duplicateName = this.nameMap.put(enumDef.getName(), enumDef);
            if (duplicateName != null) {
                throw new OMRSLogicErrorException(OMRSErrorCode.DUPLICATE_TYPENAME_IN_ARCHIVE.getMessageDefinition(new String[]{enumDef.getGUID(), duplicateName.toString(), enumDef.toString()}), this.getClass().getName(), "addEnumDef");
            }
            this.enumDefList.add(enumDef);
        }
    }

    EnumDef getEnumDef(String enumDefName) {
        String methodName = "getEnumDef";
        log.debug("Retrieving EnumDef: " + enumDefName);
        if (enumDefName != null) {
            EnumDef enumDef = this.enumDefMap.get(enumDefName);
            if (enumDef == null) {
                throw new OMRSLogicErrorException(OMRSErrorCode.MISSING_TYPE_IN_ARCHIVE.getMessageDefinition(new String[]{enumDefName, AttributeTypeDefCategory.ENUM_DEF.getName()}), this.getClass().getName(), "getEnumDef");
            }
            return enumDef;
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.MISSING_NAME_FOR_ARCHIVE.getMessageDefinition(new String[]{AttributeTypeDefCategory.ENUM_DEF.getName()}), this.getClass().getName(), "getEnumDef");
    }

    public void addClassificationDef(ClassificationDef classificationDef) {
        String methodName = "addClassificationDef";
        if (classificationDef != null) {
            log.debug("Adding ClassificationDef: " + classificationDef.toString());
            this.checkForBlanksInTypeName(classificationDef.getName());
            ClassificationDef duplicateElement = this.classificationDefMap.put(classificationDef.getName(), classificationDef);
            if (duplicateElement != null) {
                throw new OMRSLogicErrorException(OMRSErrorCode.DUPLICATE_TYPE_IN_ARCHIVE.getMessageDefinition(new String[]{classificationDef.getName(), TypeDefCategory.CLASSIFICATION_DEF.getName(), duplicateElement.toString(), classificationDef.toString()}), this.getClass().getName(), "addClassificationDef");
            }
            Object duplicateGUID = this.guidMap.put(classificationDef.getGUID(), classificationDef);
            if (duplicateGUID != null) {
                throw new OMRSLogicErrorException(OMRSErrorCode.DUPLICATE_GUID_IN_ARCHIVE.getMessageDefinition(new String[]{classificationDef.getGUID(), duplicateGUID.toString(), classificationDef.toString()}), this.getClass().getName(), "addClassificationDef");
            }
            Object duplicateName = this.nameMap.put(classificationDef.getName(), classificationDef);
            if (duplicateName != null) {
                throw new OMRSLogicErrorException(OMRSErrorCode.DUPLICATE_TYPENAME_IN_ARCHIVE.getMessageDefinition(new String[]{classificationDef.getName(), duplicateName.toString(), classificationDef.toString()}), this.getClass().getName(), "addClassificationDef");
            }
            if (classificationDef.getPropertiesDefinition() != null) {
                HashSet<String> attributeSet = new HashSet<String>();
                for (TypeDefAttribute typeDefAttr : classificationDef.getPropertiesDefinition()) {
                    String duplicateAttributeName = typeDefAttr.getAttributeName();
                    if (attributeSet.contains(duplicateAttributeName)) {
                        throw new OMRSLogicErrorException(OMRSErrorCode.DUPLICATE_CLASSIFICATION_ATTR_IN_ARCHIVE.getMessageDefinition(new String[]{duplicateAttributeName, classificationDef.getName()}), this.getClass().getName(), "addClassificationDef");
                    }
                    attributeSet.add(duplicateAttributeName);
                }
            }
            this.classificationDefList.add(classificationDef);
        }
    }

    public void addEntityDef(EntityDef entityDef) {
        String methodName = "addEntityDef";
        if (entityDef != null) {
            log.debug("Adding EntityDef: " + entityDef.toString());
            this.checkForBlanksInTypeName(entityDef.getName());
            EntityDef duplicateElement = this.entityDefMap.put(entityDef.getName(), entityDef);
            if (duplicateElement != null) {
                throw new OMRSLogicErrorException(OMRSErrorCode.DUPLICATE_TYPE_IN_ARCHIVE.getMessageDefinition(new String[]{entityDef.getName(), TypeDefCategory.ENTITY_DEF.getName(), duplicateElement.toString(), entityDef.toString()}), this.getClass().getName(), "addEntityDef");
            }
            Object duplicateGUID = this.guidMap.put(entityDef.getGUID(), entityDef);
            if (duplicateGUID != null) {
                throw new OMRSLogicErrorException(OMRSErrorCode.DUPLICATE_GUID_IN_ARCHIVE.getMessageDefinition(new String[]{entityDef.getGUID(), duplicateGUID.toString(), entityDef.toString()}), this.getClass().getName(), "addEntityDef");
            }
            Object duplicateName = this.nameMap.put(entityDef.getName(), entityDef);
            if (duplicateName != null) {
                throw new OMRSLogicErrorException(OMRSErrorCode.DUPLICATE_TYPENAME_IN_ARCHIVE.getMessageDefinition(new String[]{entityDef.getName(), duplicateName.toString(), entityDef.toString()}), this.getClass().getName(), "addEntityDef");
            }
            if (entityDef.getPropertiesDefinition() != null) {
                HashSet<String> attrSet = new HashSet<String>();
                for (TypeDefAttribute typeDefAttr : entityDef.getPropertiesDefinition()) {
                    String duplicateAttributeName = typeDefAttr.getAttributeName();
                    if (attrSet.contains(duplicateAttributeName)) {
                        throw new OMRSLogicErrorException(OMRSErrorCode.DUPLICATE_ENTITY_ATTR_IN_ARCHIVE.getMessageDefinition(new String[]{duplicateAttributeName, entityDef.getName()}), this.getClass().getName(), "addEntityDef");
                    }
                    attrSet.add(duplicateAttributeName);
                }
            }
            this.entityDefList.add(entityDef);
        }
    }

    public EntityDef getEntityDef(String entityDefName) {
        String methodName = "getEntityDef";
        log.debug("Retrieving EntityDef: " + entityDefName);
        if (entityDefName != null) {
            EntityDef retrievedEntityDef = this.entityDefMap.get(entityDefName);
            if (retrievedEntityDef == null) {
                throw new OMRSLogicErrorException(OMRSErrorCode.MISSING_TYPE_IN_ARCHIVE.getMessageDefinition(new String[]{entityDefName, TypeDefCategory.ENTITY_DEF.getName()}), this.getClass().getName(), "getEntityDef");
            }
            return retrievedEntityDef;
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.MISSING_NAME_FOR_ARCHIVE.getMessageDefinition(new String[]{TypeDefCategory.ENTITY_DEF.getName()}), this.getClass().getName(), "getEntityDef");
    }

    public void addRelationshipDef(RelationshipDef relationshipDef) {
        String methodName = "addRelationshipDef";
        if (relationshipDef != null) {
            log.debug("Adding RelationshipDef: " + relationshipDef.toString());
            this.checkForBlanksInTypeName(relationshipDef.getName());
            RelationshipDef duplicateElement = this.relationshipDefMap.put(relationshipDef.getName(), relationshipDef);
            if (duplicateElement != null) {
                throw new OMRSLogicErrorException(OMRSErrorCode.DUPLICATE_TYPE_IN_ARCHIVE.getMessageDefinition(new String[]{relationshipDef.getName(), TypeDefCategory.RELATIONSHIP_DEF.getName(), duplicateElement.toString(), relationshipDef.toString()}), this.getClass().getName(), "addRelationshipDef");
            }
            Object duplicateGUID = this.guidMap.put(relationshipDef.getGUID(), relationshipDef);
            if (duplicateGUID != null) {
                throw new OMRSLogicErrorException(OMRSErrorCode.DUPLICATE_GUID_IN_ARCHIVE.getMessageDefinition(new String[]{relationshipDef.getGUID(), duplicateGUID.toString(), relationshipDef.toString()}), this.getClass().getName(), "addRelationshipDef");
            }
            Object duplicateName = this.nameMap.put(relationshipDef.getName(), relationshipDef);
            if (duplicateName != null) {
                throw new OMRSLogicErrorException(OMRSErrorCode.DUPLICATE_TYPENAME_IN_ARCHIVE.getMessageDefinition(new String[]{relationshipDef.getName(), duplicateName.toString(), relationshipDef.toString()}), this.getClass().getName(), "addRelationshipDef");
            }
            this.checkRelationshipDefDuplicateAttributes(relationshipDef);
            if (relationshipDef.getPropertiesDefinition() != null) {
                HashSet<String> attributeSet = new HashSet<String>();
                for (TypeDefAttribute typeDefAttr : relationshipDef.getPropertiesDefinition()) {
                    String duplicateAttributeName = typeDefAttr.getAttributeName();
                    if (attributeSet.contains(duplicateAttributeName)) {
                        throw new OMRSLogicErrorException(OMRSErrorCode.DUPLICATE_RELATIONSHIP_ATTR_IN_ARCHIVE.getMessageDefinition(new String[]{duplicateAttributeName, relationshipDef.getName()}), this.getClass().getName(), "addRelationshipDef");
                    }
                    attributeSet.add(duplicateAttributeName);
                }
            }
            this.relationshipDefList.add(relationshipDef);
        }
    }

    private void checkRelationshipDefDuplicateAttributes(RelationshipDef relationshipDef) throws OMRSLogicErrorException {
        EntityDef entityDef2;
        Set<Object> attributeSet;
        String methodName = "checkRelationshipDefDuplicateAttributes";
        RelationshipEndDef end1 = relationshipDef.getEndDef1();
        RelationshipEndDef end2 = relationshipDef.getEndDef2();
        String end1Name = end1.getAttributeName();
        String end1Type = end1.getEntityType().getName();
        String end2Name = end2.getAttributeName();
        String end2Type = end2.getEntityType().getName();
        if (end1Name.equals(end2Name) && end1Type.equals(end2Type)) {
            if (this.entityAttributeMap.get(end1Type) == null) {
                attributeSet = new HashSet();
                attributeSet.add(end1Name);
                this.entityAttributeMap.put(end1Type, attributeSet);
            } else {
                attributeSet = this.entityAttributeMap.get(end1Type);
                if (attributeSet.contains(end2Name)) {
                    throw new OMRSLogicErrorException(OMRSErrorCode.DUPLICATE_ENDDEF2_NAME_IN_ARCHIVE.getMessageDefinition(new String[]{end1Type, end2Name, relationshipDef.getName()}), this.getClass().getName(), "checkRelationshipDefDuplicateAttributes");
                }
                attributeSet.add(end1Name);
            }
        } else {
            if (this.entityAttributeMap.get(end1Type) == null) {
                attributeSet = new HashSet<String>();
                attributeSet.add(end2Name);
                this.entityAttributeMap.put(end1Type, attributeSet);
            } else {
                attributeSet = this.entityAttributeMap.get(end1Type);
                if (attributeSet.contains(end2Name)) {
                    throw new OMRSLogicErrorException(OMRSErrorCode.DUPLICATE_ENDDEF2_NAME_IN_ARCHIVE.getMessageDefinition(new String[]{end1Type, end2Name, relationshipDef.getName()}), this.getClass().getName(), "checkRelationshipDefDuplicateAttributes");
                }
                attributeSet.add(end2Name);
            }
            if (this.entityAttributeMap.get(end2Type) == null) {
                HashSet<String> attrSet = new HashSet<String>();
                attrSet.add(end1Name);
                this.entityAttributeMap.put(end2Type, attrSet);
            } else {
                attributeSet = this.entityAttributeMap.get(end2Type);
                if (attributeSet.contains(end1Name)) {
                    throw new OMRSLogicErrorException(OMRSErrorCode.DUPLICATE_ENDDEF1_NAME_IN_ARCHIVE.getMessageDefinition(new String[]{end2Type, end1Name, relationshipDef.getName()}), this.getClass().getName(), "checkRelationshipDefDuplicateAttributes");
                }
                attributeSet.add(end1Name);
            }
        }
        EntityDef entityDef1 = this.entityDefMap.get(end1Type);
        if (entityDef1.getPropertiesDefinition() != null) {
            Set<String> attributeSet2 = this.entityAttributeMap.get(end1Type);
            for (TypeDefAttribute typeDefAttr : entityDef1.getPropertiesDefinition()) {
                String localAttributeName = typeDefAttr.getAttributeName();
                if (localAttributeName.equals(end2Name)) {
                    throw new OMRSLogicErrorException(OMRSErrorCode.DUPLICATE_ENDDEF2_NAME_IN_ARCHIVE.getMessageDefinition(new String[]{end1Type, end2Name, relationshipDef.getName()}), this.getClass().getName(), "checkRelationshipDefDuplicateAttributes");
                }
                attributeSet2.add(end2Name);
            }
        }
        if ((entityDef2 = this.entityDefMap.get(end2Type)).getPropertiesDefinition() != null) {
            Set<String> attributeSet3 = this.entityAttributeMap.get(end2Type);
            for (TypeDefAttribute typeDefAttr : entityDef2.getPropertiesDefinition()) {
                String localAttributeName = typeDefAttr.getAttributeName();
                if (localAttributeName.equals(end1Name)) {
                    throw new OMRSLogicErrorException(OMRSErrorCode.DUPLICATE_ENDDEF1_NAME_IN_ARCHIVE.getMessageDefinition(new String[]{end2Type, end1Name, relationshipDef.getName()}), this.getClass().getName(), "checkRelationshipDefDuplicateAttributes");
                }
                attributeSet3.add(end1Name);
            }
        }
    }

    public TypeDefPatch getPatchForType(String typeName) {
        TypeDef typeDef = this.getTypeDefByName(typeName);
        if (typeDef != null) {
            long latestVersion = typeDef.getVersion();
            String latestVersionName = typeDef.getVersionName();
            if (!this.typeDefPatchList.isEmpty()) {
                for (TypeDefPatch typeDefPatch : this.typeDefPatchList) {
                    if (typeDefPatch == null || !typeName.equals(typeDefPatch.getTypeDefName()) || typeDefPatch.getUpdateToVersion() <= latestVersion) continue;
                    latestVersion = typeDefPatch.getUpdateToVersion();
                    latestVersionName = typeDefPatch.getNewVersionName();
                }
            }
            TypeDefPatch patch = new TypeDefPatch();
            patch.setHeaderVersion(1L);
            patch.setTypeDefGUID(typeDef.getGUID());
            patch.setTypeDefName(typeDef.getName());
            patch.setApplyToVersion(latestVersion);
            patch.setUpdateToVersion(latestVersion + 1L);
            patch.setNewVersionName(latestVersionName);
            return patch;
        }
        return null;
    }

    public void addTypeDefPatch(TypeDefPatch typeDefPatch) {
        if (typeDefPatch != null) {
            log.debug("Adding TypeDefPatch: " + typeDefPatch.toString());
            this.checkForBlanksInTypeName(typeDefPatch.getTypeDefName());
            this.typeDefPatchList.add(typeDefPatch);
        }
    }

    public TypeDef getTypeDefByName(String typeName) {
        Object namedObject = this.nameMap.get(typeName);
        if (namedObject instanceof TypeDef) {
            return (TypeDef)namedObject;
        }
        return null;
    }

    public void addEntity(EntityDetail entity) {
        String methodName = "addEntity";
        if (entity != null) {
            log.debug("Adding Entity: " + entity.toString());
            EntityDetail duplicateElement = this.entityDetailMap.put(entity.getGUID(), entity);
            if (duplicateElement != null) {
                throw new OMRSLogicErrorException(OMRSErrorCode.DUPLICATE_INSTANCE_IN_ARCHIVE.getMessageDefinition(new String[]{TypeDefCategory.ENTITY_DEF.getName(), entity.getGUID(), duplicateElement.toString(), entity.toString()}), this.getClass().getName(), "addEntity");
            }
            Object duplicateGUID = this.guidMap.put(entity.getGUID(), entity);
            if (duplicateGUID != null) {
                throw new OMRSLogicErrorException(OMRSErrorCode.DUPLICATE_GUID_IN_ARCHIVE.getMessageDefinition(new String[]{entity.getGUID(), duplicateGUID.toString(), entity.toString()}), this.getClass().getName(), "addEntity");
            }
            this.entityDetailList.add(entity);
        }
    }

    public EntityDetail getEntity(String guid) {
        String methodName = "getEntity";
        EntityDetail entity = this.entityDetailMap.get(guid);
        if (entity == null) {
            throw new OMRSLogicErrorException(OMRSErrorCode.UNKNOWN_GUID.getMessageDefinition(new String[]{"getEntity", guid}), this.getClass().getName(), "getEntity");
        }
        return entity;
    }

    public void addRelationship(Relationship relationship) {
        String methodName = "addRelationship";
        if (relationship != null) {
            log.debug("Adding Relationship: " + relationship.toString());
            Relationship duplicateElement = this.relationshipMap.put(relationship.getGUID(), relationship);
            if (duplicateElement != null) {
                throw new OMRSLogicErrorException(OMRSErrorCode.DUPLICATE_INSTANCE_IN_ARCHIVE.getMessageDefinition(new String[]{TypeDefCategory.RELATIONSHIP_DEF.getName(), relationship.getGUID(), duplicateElement.toString(), relationship.toString()}), this.getClass().getName(), "addRelationship");
            }
            Object duplicateGUID = this.guidMap.put(relationship.getGUID(), relationship);
            if (duplicateGUID != null) {
                throw new OMRSLogicErrorException(OMRSErrorCode.DUPLICATE_GUID_IN_ARCHIVE.getMessageDefinition(new String[]{relationship.getGUID(), duplicateGUID.toString(), relationship.toString()}), this.getClass().getName(), "addRelationship");
            }
            this.relationshipList.add(relationship);
        }
    }

    public Relationship getRelationship(String guid) {
        String methodName = "getRelationship";
        Relationship relationship = this.relationshipMap.get(guid);
        if (relationship == null) {
            throw new OMRSLogicErrorException(OMRSErrorCode.UNKNOWN_GUID.getMessageDefinition(new String[]{"getRelationship", guid}), this.getClass().getName(), "getRelationship");
        }
        return relationship;
    }

    public void addClassification(ClassificationEntityExtension classification) {
        String methodName = "addClassification";
        if (classification != null) {
            log.debug("Adding Classification: " + classification.toString());
            String classificationId = classification.getEntityToClassify().getGUID() + ":" + classification.getClassification().getName();
            ClassificationEntityExtension duplicateElement = this.classificationMap.put(classificationId, classification);
            if (duplicateElement != null) {
                throw new OMRSLogicErrorException(OMRSErrorCode.DUPLICATE_INSTANCE_IN_ARCHIVE.getMessageDefinition(new String[]{TypeDefCategory.CLASSIFICATION_DEF.getName(), classificationId, duplicateElement.toString(), classification.toString()}), this.getClass().getName(), "addClassification");
            }
            this.classificationList.add(classification);
        }
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        log.debug("Retrieving Open Metadata Archive: " + this.archiveProperties.getArchiveName());
        OpenMetadataArchive archive = new OpenMetadataArchive();
        archive.setArchiveProperties(this.archiveProperties);
        ArrayList<Object> attributeTypeDefs = new ArrayList<Object>();
        ArrayList<Object> typeDefs = new ArrayList<Object>();
        ArrayList<TypeDefPatch> typeDefPatches = new ArrayList<TypeDefPatch>();
        if (!this.primitiveDefList.isEmpty()) {
            attributeTypeDefs.addAll(this.primitiveDefList);
        }
        if (!this.collectionDefList.isEmpty()) {
            attributeTypeDefs.addAll(this.collectionDefList);
        }
        if (!this.enumDefList.isEmpty()) {
            attributeTypeDefs.addAll(this.enumDefList);
        }
        if (!this.entityDefList.isEmpty()) {
            typeDefs.addAll(this.entityDefList);
        }
        if (!this.classificationDefList.isEmpty()) {
            typeDefs.addAll(this.classificationDefList);
        }
        if (!this.relationshipDefList.isEmpty()) {
            typeDefs.addAll(this.relationshipDefList);
        }
        if (!this.typeDefPatchList.isEmpty()) {
            typeDefPatches.addAll(this.typeDefPatchList);
        }
        if (!(typeDefs.isEmpty() && typeDefPatches.isEmpty() && attributeTypeDefs.isEmpty())) {
            OpenMetadataArchiveTypeStore typeStore = new OpenMetadataArchiveTypeStore();
            if (!attributeTypeDefs.isEmpty()) {
                typeStore.setAttributeTypeDefs(attributeTypeDefs);
            }
            if (!typeDefs.isEmpty()) {
                typeStore.setNewTypeDefs(typeDefs);
            }
            if (!typeDefPatches.isEmpty()) {
                typeStore.setTypeDefPatches(typeDefPatches);
            }
            archive.setArchiveTypeStore(typeStore);
        }
        ArrayList<EntityDetail> entities = new ArrayList<EntityDetail>();
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        ArrayList<ClassificationEntityExtension> classifications = new ArrayList<ClassificationEntityExtension>();
        if (!this.entityDetailList.isEmpty()) {
            entities.addAll(this.entityDetailList);
        }
        if (!this.relationshipList.isEmpty()) {
            relationships.addAll(this.relationshipList);
        }
        if (!this.classificationList.isEmpty()) {
            classifications.addAll(this.classificationList);
        }
        if (!entities.isEmpty() || !relationships.isEmpty()) {
            OpenMetadataArchiveInstanceStore instanceStore = new OpenMetadataArchiveInstanceStore();
            if (!entities.isEmpty()) {
                instanceStore.setEntities(entities);
            }
            if (!relationships.isEmpty()) {
                instanceStore.setRelationships(relationships);
            }
            if (!classifications.isEmpty()) {
                instanceStore.setClassifications(classifications);
            }
            archive.setArchiveInstanceStore(instanceStore);
        }
        return archive;
    }

    private void checkForBlanksInTypeName(String typeName) {
        String methodName = "checkForBlanksInTypeName";
        if (typeName.contains(" ")) {
            throw new OMRSLogicErrorException(OMRSErrorCode.BLANK_TYPENAME_IN_ARCHIVE.getMessageDefinition(new String[]{typeName}), this.getClass().getName(), "checkForBlanksInTypeName");
        }
    }

    public void logBadArchiveContent(String methodName) {
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), methodName);
    }
}

