/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.archiveutilities;

import java.util.UUID;
import org.odpi.openmetadata.adapters.repositoryservices.archiveconnector.file.FileBasedOpenMetadataArchiveStoreProvider;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.ConnectorProvider;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementOrigin;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Endpoint;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.OpenMetadataArchiveStore;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMRSArchiveWriter {
    private static final Logger log = LoggerFactory.getLogger(OMRSArchiveWriter.class);

    protected Connection getOpenMetadataArchiveFileConnection(String fileName) {
        Endpoint endpoint = new Endpoint();
        endpoint.setAddress(fileName);
        Connection connection = new Connection();
        connection.setConnectorType(this.getConnectorType(FileBasedOpenMetadataArchiveStoreProvider.class.getName()));
        connection.setEndpoint(endpoint);
        return connection;
    }

    private ConnectorType getConnectorType(String connectorProviderClassName) {
        ConnectorType connectorType = null;
        if (connectorProviderClassName != null) {
            try {
                Class<?> connectorProviderClass = Class.forName(connectorProviderClassName);
                Object potentialConnectorProvider = connectorProviderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                ConnectorProvider connectorProvider = (ConnectorProvider)potentialConnectorProvider;
                connectorType = connectorProvider.getConnectorType();
                if (connectorType == null) {
                    connectorType = new ConnectorType();
                    connectorType.setType(this.getConnectorTypeType());
                    connectorType.setGUID(UUID.randomUUID().toString());
                    connectorType.setQualifiedName(connectorProviderClassName);
                    connectorType.setDisplayName(connectorProviderClass.getSimpleName());
                    connectorType.setDescription("ConnectorType for " + connectorType.getDisplayName());
                    connectorType.setConnectorProviderClassName(connectorProviderClassName);
                }
            }
            catch (Exception classException) {
                log.error("Bad connectorProviderClassName: " + classException.getMessage());
            }
        }
        return connectorType;
    }

    private ElementType getEndpointType() {
        ElementType elementType = Endpoint.getEndpointType();
        elementType.setElementOrigin(ElementOrigin.CONFIGURATION);
        return elementType;
    }

    private ElementType getConnectorTypeType() {
        ElementType elementType = ConnectorType.getConnectorTypeType();
        elementType.setElementOrigin(ElementOrigin.CONFIGURATION);
        return elementType;
    }

    private ElementType getConnectionType() {
        ElementType elementType = Connection.getConnectionType();
        elementType.setElementOrigin(ElementOrigin.CONFIGURATION);
        return elementType;
    }

    private OpenMetadataArchiveStore getOpenMetadataArchive(Connection connection) {
        OpenMetadataArchiveStore openMetadataArchiveStore = null;
        try {
            ConnectorBroker connectorBroker = new ConnectorBroker();
            Connector connector = connectorBroker.getConnector(connection);
            openMetadataArchiveStore = (OpenMetadataArchiveStore)connector;
            log.debug("Created connector to open metadata archive store");
        }
        catch (Exception error) {
            log.error("Unexpected exception occurred: " + error.getMessage());
            log.error("Exception: " + error.toString());
        }
        return openMetadataArchiveStore;
    }

    protected void writeOpenMetadataArchive(String outputFileName, OpenMetadataArchive openMetadataArchive) {
        Connection connection = this.getOpenMetadataArchiveFileConnection(outputFileName);
        OpenMetadataArchiveStore openMetadataArchiveStore = this.getOpenMetadataArchive(connection);
        openMetadataArchiveStore.setArchiveContents(openMetadataArchive);
    }
}

