/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.archiveutilities;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.frameworks.openmetadata.types.DataType;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.OpenMetadataArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationEntityExtension;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationPropagationRule;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.CollectionDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.CollectionDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumElementDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttributeStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.utilities.OMRSRepositoryPropertiesUtilities;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OMRSArchiveHelper
extends OMRSRepositoryPropertiesUtilities {
    private final OpenMetadataArchiveBuilder archiveBuilder;
    private final String archiveGUID;
    private String archiveName;
    private final String originatorName;
    private final Date creationDate;
    private final long versionNumber;
    private final String versionName;
    private InstanceProvenanceType instanceProvenanceType = InstanceProvenanceType.CONTENT_PACK;
    private String license = null;

    public OMRSArchiveHelper(OpenMetadataArchiveBuilder archiveBuilder, String archiveGUID, String originatorName, Date creationDate, long versionNumber, String versionName) {
        this.archiveBuilder = archiveBuilder;
        this.archiveGUID = archiveGUID;
        this.originatorName = originatorName;
        this.creationDate = creationDate;
        this.versionNumber = versionNumber;
        this.versionName = versionName;
    }

    public OMRSArchiveHelper(OpenMetadataArchiveBuilder archiveBuilder, String archiveGUID, String archiveName, String originatorName, Date creationDate, long versionNumber, String versionName, InstanceProvenanceType instanceProvenanceType, String license) {
        this.archiveBuilder = archiveBuilder;
        this.archiveGUID = archiveGUID;
        this.archiveName = archiveName;
        this.originatorName = originatorName;
        this.creationDate = creationDate;
        this.versionNumber = versionNumber;
        this.versionName = versionName;
        this.instanceProvenanceType = instanceProvenanceType;
        this.license = license;
    }

    public PrimitiveDef getPrimitiveDef(PrimitiveDefCategory primitiveDefCategory) {
        PrimitiveDef primitiveDef = new PrimitiveDef(primitiveDefCategory);
        primitiveDef.setHeaderVersion(1L);
        primitiveDef.setGUID(primitiveDefCategory.getGUID());
        primitiveDef.setName(primitiveDefCategory.getName());
        primitiveDef.setVersion(this.versionNumber);
        primitiveDef.setVersionName(this.versionName);
        return primitiveDef;
    }

    public CollectionDef getArrayCollectionDef(String guid, String description, String descriptionGUID, PrimitiveDefCategory arrayType) {
        CollectionDef collectionDef = new CollectionDef(CollectionDefCategory.OM_COLLECTION_ARRAY);
        collectionDef.setHeaderVersion(1L);
        collectionDef.setGUID(guid);
        collectionDef.setName("array<" + arrayType.getName() + ">");
        collectionDef.setDescription(description);
        collectionDef.setDescriptionGUID(descriptionGUID);
        collectionDef.setVersion(this.versionNumber);
        collectionDef.setVersionName(this.versionName);
        ArrayList<PrimitiveDefCategory> argumentList = new ArrayList<PrimitiveDefCategory>();
        argumentList.add(arrayType);
        collectionDef.setArgumentTypes(argumentList);
        return collectionDef;
    }

    public CollectionDef getMapCollectionDef(String guid, String description, String descriptionGUID, PrimitiveDefCategory propertyKeyType, PrimitiveDefCategory propertyValueType) {
        CollectionDef collectionDef = new CollectionDef(CollectionDefCategory.OM_COLLECTION_MAP);
        collectionDef.setHeaderVersion(1L);
        collectionDef.setGUID(guid);
        collectionDef.setName("map<" + propertyKeyType.getName() + "," + propertyValueType.getName() + ">");
        collectionDef.setDescription(description);
        collectionDef.setDescriptionGUID(descriptionGUID);
        collectionDef.setVersion(this.versionNumber);
        collectionDef.setVersionName(this.versionName);
        ArrayList<PrimitiveDefCategory> argumentList = new ArrayList<PrimitiveDefCategory>();
        argumentList.add(propertyKeyType);
        argumentList.add(propertyValueType);
        collectionDef.setArgumentTypes(argumentList);
        return collectionDef;
    }

    public EnumDef getEmptyEnumDef(String guid, String name, String description, String descriptionGUID) {
        return this.getEmptyEnumDef(guid, name, description, descriptionGUID, null);
    }

    public EnumDef getEmptyEnumDef(String guid, String name, String description, String descriptionGUID, String descriptionWiki) {
        EnumDef enumDef = new EnumDef();
        enumDef.setHeaderVersion(1L);
        enumDef.setGUID(guid);
        enumDef.setName(name);
        enumDef.setDescription(description);
        enumDef.setDescriptionGUID(descriptionGUID);
        enumDef.setDescriptionWiki(descriptionWiki);
        enumDef.setDefaultValue(null);
        enumDef.setVersion(this.versionNumber);
        enumDef.setVersionName(this.versionName);
        return enumDef;
    }

    public EnumElementDef getEnumElementDef(int ordinal, String value, String description, String descriptionGUID) {
        EnumElementDef enumElementDef = new EnumElementDef();
        enumElementDef.setHeaderVersion(1L);
        enumElementDef.setOrdinal(ordinal);
        enumElementDef.setValue(value);
        enumElementDef.setDescription(description);
        enumElementDef.setDescriptionGUID(descriptionGUID);
        return enumElementDef;
    }

    public EntityDef getDefaultEntityDef(String guid, String name, TypeDefLink superType, String description, String descriptionGUID) {
        return this.getDefaultEntityDef(guid, name, superType, description, descriptionGUID, null);
    }

    public EntityDef getDefaultEntityDef(OpenMetadataType type, TypeDefLink superType) {
        return this.getDefaultEntityDef(type.typeGUID, type.typeName, superType, type.description, type.descriptionGUID, type.wikiURL);
    }

    public EntityDef getDefaultEntityDef(String guid, String name, TypeDefLink superType, String description, String descriptionGUID, String descriptionWiki) {
        EntityDef entityDef = new EntityDef();
        entityDef.setHeaderVersion(1L);
        entityDef.setGUID(guid);
        entityDef.setName(name);
        entityDef.setSuperType(superType);
        entityDef.setDescription(description);
        entityDef.setDescriptionGUID(descriptionGUID);
        entityDef.setDescriptionWiki(descriptionWiki);
        entityDef.setOrigin(this.archiveGUID);
        entityDef.setCreatedBy(this.originatorName);
        entityDef.setCreateTime(this.creationDate);
        entityDef.setVersion(this.versionNumber);
        entityDef.setVersionName(this.versionName);
        TypeDef superTypeDef = null;
        if (superType != null) {
            superTypeDef = this.archiveBuilder.getTypeDefByName(superType.getName());
        }
        if (superTypeDef != null) {
            entityDef.setValidInstanceStatusList(superTypeDef.getValidInstanceStatusList());
            entityDef.setInitialStatus(superTypeDef.getInitialStatus());
        } else {
            ArrayList<InstanceStatus> validInstanceStatusList = new ArrayList<InstanceStatus>();
            validInstanceStatusList.add(InstanceStatus.ACTIVE);
            validInstanceStatusList.add(InstanceStatus.DELETED);
            entityDef.setValidInstanceStatusList(validInstanceStatusList);
            entityDef.setInitialStatus(InstanceStatus.ACTIVE);
        }
        entityDef.setStatus(TypeDefStatus.ACTIVE_TYPEDEF);
        return entityDef;
    }

    public TypeDefAttribute getTypeDefAttribute(OpenMetadataProperty propertyDefinition) {
        String methodName = "getTypeDefAttribute";
        if (DataType.STRING.getName().equals(propertyDefinition.type)) {
            return this.getTypeDefAttribute(propertyDefinition.name, propertyDefinition.description, propertyDefinition.descriptionGUID, PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
        }
        if (DataType.INT.getName().equals(propertyDefinition.type)) {
            return this.getTypeDefAttribute(propertyDefinition.name, propertyDefinition.description, propertyDefinition.descriptionGUID, PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT);
        }
        if (DataType.LONG.getName().equals(propertyDefinition.type)) {
            return this.getTypeDefAttribute(propertyDefinition.name, propertyDefinition.description, propertyDefinition.descriptionGUID, PrimitiveDefCategory.OM_PRIMITIVE_TYPE_LONG);
        }
        if (DataType.SHORT.getName().equals(propertyDefinition.type)) {
            return this.getTypeDefAttribute(propertyDefinition.name, propertyDefinition.description, propertyDefinition.descriptionGUID, PrimitiveDefCategory.OM_PRIMITIVE_TYPE_SHORT);
        }
        if (DataType.DATE.getName().equals(propertyDefinition.type)) {
            return this.getTypeDefAttribute(propertyDefinition.name, propertyDefinition.description, propertyDefinition.descriptionGUID, PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE);
        }
        if (DataType.BOOLEAN.getName().equals(propertyDefinition.type)) {
            return this.getTypeDefAttribute(propertyDefinition.name, propertyDefinition.description, propertyDefinition.descriptionGUID, PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BOOLEAN);
        }
        if (DataType.CHAR.getName().equals(propertyDefinition.type)) {
            return this.getTypeDefAttribute(propertyDefinition.name, propertyDefinition.description, propertyDefinition.descriptionGUID, PrimitiveDefCategory.OM_PRIMITIVE_TYPE_CHAR);
        }
        if (DataType.BYTE.getName().equals(propertyDefinition.type)) {
            return this.getTypeDefAttribute(propertyDefinition.name, propertyDefinition.description, propertyDefinition.descriptionGUID, PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BYTE);
        }
        if (DataType.FLOAT.getName().equals(propertyDefinition.type)) {
            return this.getTypeDefAttribute(propertyDefinition.name, propertyDefinition.description, propertyDefinition.descriptionGUID, PrimitiveDefCategory.OM_PRIMITIVE_TYPE_FLOAT);
        }
        if (DataType.DOUBLE.getName().equals(propertyDefinition.type)) {
            return this.getTypeDefAttribute(propertyDefinition.name, propertyDefinition.description, propertyDefinition.descriptionGUID, PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DOUBLE);
        }
        if (DataType.BIGINTEGER.getName().equals(propertyDefinition.type)) {
            return this.getTypeDefAttribute(propertyDefinition.name, propertyDefinition.description, propertyDefinition.descriptionGUID, PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BIGINTEGER);
        }
        if (DataType.BIGDECIMAL.getName().equals(propertyDefinition.type)) {
            return this.getTypeDefAttribute(propertyDefinition.name, propertyDefinition.description, propertyDefinition.descriptionGUID, PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BIGDECIMAL);
        }
        if (DataType.OBJECT.getName().equals(propertyDefinition.type)) {
            return this.getTypeDefAttribute(propertyDefinition.name, propertyDefinition.description, propertyDefinition.descriptionGUID, PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN);
        }
        if (DataType.ARRAY_STRING.getName().equals(propertyDefinition.type)) {
            return this.getArrayStringTypeDefAttribute(propertyDefinition.name, propertyDefinition.description, propertyDefinition.descriptionGUID);
        }
        if (DataType.ARRAY_INT.getName().equals(propertyDefinition.type)) {
            return this.getArrayIntTypeDefAttribute(propertyDefinition.name, propertyDefinition.description, propertyDefinition.descriptionGUID);
        }
        if (DataType.MAP_STRING_BOOLEAN.getName().equals(propertyDefinition.type)) {
            return this.getMapStringBooleanTypeDefAttribute(propertyDefinition.name, propertyDefinition.description, propertyDefinition.descriptionGUID);
        }
        if (DataType.MAP_STRING_INT.getName().equals(propertyDefinition.type)) {
            return this.getMapStringIntTypeDefAttribute(propertyDefinition.name, propertyDefinition.description, propertyDefinition.descriptionGUID);
        }
        if (DataType.MAP_STRING_DOUBLE.getName().equals(propertyDefinition.type)) {
            return this.getMapStringDoubleTypeDefAttribute(propertyDefinition.name, propertyDefinition.description, propertyDefinition.descriptionGUID);
        }
        if (DataType.MAP_STRING_DATE.getName().equals(propertyDefinition.type)) {
            return this.getMapStringDateTypeDefAttribute(propertyDefinition.name, propertyDefinition.description, propertyDefinition.descriptionGUID);
        }
        if (DataType.MAP_STRING_STRING.getName().equals(propertyDefinition.type)) {
            return this.getMapStringStringTypeDefAttribute(propertyDefinition.name, propertyDefinition.description, propertyDefinition.descriptionGUID);
        }
        if (DataType.MAP_STRING_LONG.getName().equals(propertyDefinition.type)) {
            return this.getMapStringLongTypeDefAttribute(propertyDefinition.name, propertyDefinition.description, propertyDefinition.descriptionGUID);
        }
        if (DataType.MAP_STRING_OBJECT.getName().equals(propertyDefinition.type)) {
            return this.getMapStringObjectTypeDefAttribute(propertyDefinition.name, propertyDefinition.description, propertyDefinition.descriptionGUID);
        }
        if (DataType.MAP_STRING_ARRAY_STRING.getName().equals(propertyDefinition.type)) {
            return this.getMapStringObjectTypeDefAttribute(propertyDefinition.name, propertyDefinition.description, propertyDefinition.descriptionGUID);
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.BAD_DATA_TYPE.getMessageDefinition(new String[]{propertyDefinition.type, "getTypeDefAttribute"}), ((Object)((Object)this)).getClass().getName(), "getTypeDefAttribute");
    }

    public TypeDefAttribute getTypeDefAttribute(String attributeName, String attributeDescription, String attributeDescriptionGUID, PrimitiveDefCategory primitiveDefCategory) {
        TypeDefAttribute attribute = new TypeDefAttribute();
        attribute.setHeaderVersion(1L);
        attribute.setAttributeName(attributeName);
        attribute.setAttributeDescription(attributeDescription);
        attribute.setAttributeDescriptionGUID(attributeDescriptionGUID);
        attribute.setAttributeType((AttributeTypeDef)this.archiveBuilder.getPrimitiveDef(primitiveDefCategory.getName()));
        attribute.setAttributeCardinality(AttributeCardinality.AT_MOST_ONE);
        attribute.setValuesMinCount(0);
        attribute.setValuesMaxCount(1);
        attribute.setIndexable(true);
        attribute.setUnique(false);
        attribute.setDefaultValue(null);
        attribute.setExternalStandardMappings(null);
        attribute.setAttributeStatus(TypeDefAttributeStatus.ACTIVE_ATTRIBUTE);
        return attribute;
    }

    public TypeDefAttribute getStringTypeDefAttribute(String attributeName, String attributeDescription, String attributeDescriptionGUID) {
        TypeDefAttribute attribute = new TypeDefAttribute();
        attribute.setHeaderVersion(1L);
        attribute.setAttributeName(attributeName);
        attribute.setAttributeDescription(attributeDescription);
        attribute.setAttributeDescriptionGUID(attributeDescriptionGUID);
        attribute.setAttributeType((AttributeTypeDef)this.archiveBuilder.getPrimitiveDef(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getName()));
        attribute.setAttributeCardinality(AttributeCardinality.AT_MOST_ONE);
        attribute.setValuesMinCount(0);
        attribute.setValuesMaxCount(1);
        attribute.setIndexable(true);
        attribute.setUnique(false);
        attribute.setDefaultValue(null);
        attribute.setExternalStandardMappings(null);
        attribute.setAttributeStatus(TypeDefAttributeStatus.ACTIVE_ATTRIBUTE);
        return attribute;
    }

    public TypeDefAttribute getIntTypeDefAttribute(String attributeName, String attributeDescription, String attributeDescriptionGUID) {
        TypeDefAttribute attribute = new TypeDefAttribute();
        attribute.setHeaderVersion(1L);
        attribute.setAttributeName(attributeName);
        attribute.setAttributeDescription(attributeDescription);
        attribute.setAttributeDescriptionGUID(attributeDescriptionGUID);
        attribute.setAttributeType((AttributeTypeDef)this.archiveBuilder.getPrimitiveDef(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT.getName()));
        attribute.setAttributeCardinality(AttributeCardinality.AT_MOST_ONE);
        attribute.setValuesMinCount(0);
        attribute.setValuesMaxCount(1);
        attribute.setIndexable(true);
        attribute.setUnique(false);
        attribute.setDefaultValue(null);
        attribute.setExternalStandardMappings(null);
        attribute.setAttributeStatus(TypeDefAttributeStatus.ACTIVE_ATTRIBUTE);
        return attribute;
    }

    public TypeDefAttribute getBooleanTypeDefAttribute(String attributeName, String attributeDescription, String attributeDescriptionGUID) {
        TypeDefAttribute attribute = new TypeDefAttribute();
        attribute.setHeaderVersion(1L);
        attribute.setAttributeName(attributeName);
        attribute.setAttributeDescription(attributeDescription);
        attribute.setAttributeDescriptionGUID(attributeDescriptionGUID);
        attribute.setAttributeType((AttributeTypeDef)this.archiveBuilder.getPrimitiveDef(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BOOLEAN.getName()));
        attribute.setAttributeCardinality(AttributeCardinality.AT_MOST_ONE);
        attribute.setValuesMinCount(0);
        attribute.setValuesMaxCount(1);
        attribute.setIndexable(true);
        attribute.setUnique(false);
        attribute.setDefaultValue(null);
        attribute.setExternalStandardMappings(null);
        attribute.setAttributeStatus(TypeDefAttributeStatus.ACTIVE_ATTRIBUTE);
        return attribute;
    }

    public TypeDefAttribute getDateTypeDefAttribute(String attributeName, String attributeDescription, String attributeDescriptionGUID) {
        TypeDefAttribute attribute = new TypeDefAttribute();
        attribute.setHeaderVersion(1L);
        attribute.setAttributeName(attributeName);
        attribute.setAttributeDescription(attributeDescription);
        attribute.setAttributeDescriptionGUID(attributeDescriptionGUID);
        attribute.setAttributeType((AttributeTypeDef)this.archiveBuilder.getPrimitiveDef(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE.getName()));
        attribute.setAttributeCardinality(AttributeCardinality.AT_MOST_ONE);
        attribute.setValuesMinCount(0);
        attribute.setValuesMaxCount(1);
        attribute.setIndexable(true);
        attribute.setUnique(false);
        attribute.setDefaultValue(null);
        attribute.setExternalStandardMappings(null);
        attribute.setAttributeStatus(TypeDefAttributeStatus.ACTIVE_ATTRIBUTE);
        return attribute;
    }

    public TypeDefAttribute getLongTypeDefAttribute(String attributeName, String attributeDescription, String attributeDescriptionGUID) {
        TypeDefAttribute attribute = new TypeDefAttribute();
        attribute.setHeaderVersion(1L);
        attribute.setAttributeName(attributeName);
        attribute.setAttributeDescription(attributeDescription);
        attribute.setAttributeDescriptionGUID(attributeDescriptionGUID);
        attribute.setAttributeType((AttributeTypeDef)this.archiveBuilder.getPrimitiveDef(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_LONG.getName()));
        attribute.setAttributeCardinality(AttributeCardinality.AT_MOST_ONE);
        attribute.setValuesMinCount(0);
        attribute.setValuesMaxCount(1);
        attribute.setIndexable(true);
        attribute.setUnique(false);
        attribute.setDefaultValue(null);
        attribute.setExternalStandardMappings(null);
        attribute.setAttributeStatus(TypeDefAttributeStatus.ACTIVE_ATTRIBUTE);
        return attribute;
    }

    public TypeDefAttribute getFloatTypeDefAttribute(String attributeName, String attributeDescription, String attributeDescriptionGUID) {
        TypeDefAttribute attribute = new TypeDefAttribute();
        attribute.setHeaderVersion(1L);
        attribute.setAttributeName(attributeName);
        attribute.setAttributeDescription(attributeDescription);
        attribute.setAttributeDescriptionGUID(attributeDescriptionGUID);
        attribute.setAttributeType((AttributeTypeDef)this.archiveBuilder.getPrimitiveDef(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_FLOAT.getName()));
        attribute.setAttributeCardinality(AttributeCardinality.AT_MOST_ONE);
        attribute.setValuesMinCount(0);
        attribute.setValuesMaxCount(1);
        attribute.setIndexable(true);
        attribute.setUnique(false);
        attribute.setDefaultValue(null);
        attribute.setExternalStandardMappings(null);
        attribute.setAttributeStatus(TypeDefAttributeStatus.ACTIVE_ATTRIBUTE);
        return attribute;
    }

    public TypeDefAttribute getArrayStringTypeDefAttribute(String attributeName, String attributeDescription, String attributeDescriptionGUID) {
        TypeDefAttribute attribute = new TypeDefAttribute();
        attribute.setHeaderVersion(1L);
        attribute.setAttributeName(attributeName);
        attribute.setAttributeDescription(attributeDescription);
        attribute.setAttributeDescriptionGUID(attributeDescriptionGUID);
        attribute.setAttributeType((AttributeTypeDef)this.archiveBuilder.getCollectionDef("array<string>"));
        attribute.setAttributeCardinality(AttributeCardinality.AT_MOST_ONE);
        attribute.setValuesMinCount(0);
        attribute.setValuesMaxCount(1);
        attribute.setIndexable(true);
        attribute.setUnique(false);
        attribute.setDefaultValue(null);
        attribute.setExternalStandardMappings(null);
        attribute.setAttributeStatus(TypeDefAttributeStatus.ACTIVE_ATTRIBUTE);
        return attribute;
    }

    public TypeDefAttribute getArrayIntTypeDefAttribute(String attributeName, String attributeDescription, String attributeDescriptionGUID) {
        TypeDefAttribute attribute = new TypeDefAttribute();
        attribute.setHeaderVersion(1L);
        attribute.setAttributeName(attributeName);
        attribute.setAttributeDescription(attributeDescription);
        attribute.setAttributeDescriptionGUID(attributeDescriptionGUID);
        attribute.setAttributeType((AttributeTypeDef)this.archiveBuilder.getCollectionDef("array<int>"));
        attribute.setAttributeCardinality(AttributeCardinality.AT_MOST_ONE);
        attribute.setValuesMinCount(0);
        attribute.setValuesMaxCount(1);
        attribute.setIndexable(true);
        attribute.setUnique(false);
        attribute.setDefaultValue(null);
        attribute.setExternalStandardMappings(null);
        attribute.setAttributeStatus(TypeDefAttributeStatus.ACTIVE_ATTRIBUTE);
        return attribute;
    }

    public TypeDefAttribute getMapStringStringTypeDefAttribute(String attributeName, String attributeDescription, String attributeDescriptionGUID) {
        TypeDefAttribute attribute = new TypeDefAttribute();
        attribute.setHeaderVersion(1L);
        attribute.setAttributeName(attributeName);
        attribute.setAttributeDescription(attributeDescription);
        attribute.setAttributeDescriptionGUID(attributeDescriptionGUID);
        attribute.setAttributeType((AttributeTypeDef)this.archiveBuilder.getCollectionDef("map<string,string>"));
        attribute.setAttributeCardinality(AttributeCardinality.AT_MOST_ONE);
        attribute.setValuesMinCount(0);
        attribute.setValuesMaxCount(1);
        attribute.setIndexable(true);
        attribute.setUnique(false);
        attribute.setDefaultValue(null);
        attribute.setExternalStandardMappings(null);
        attribute.setAttributeStatus(TypeDefAttributeStatus.ACTIVE_ATTRIBUTE);
        return attribute;
    }

    public TypeDefAttribute getMapStringObjectTypeDefAttribute(String attributeName, String attributeDescription, String attributeDescriptionGUID) {
        TypeDefAttribute attribute = new TypeDefAttribute();
        attribute.setHeaderVersion(1L);
        attribute.setAttributeName(attributeName);
        attribute.setAttributeDescription(attributeDescription);
        attribute.setAttributeDescriptionGUID(attributeDescriptionGUID);
        attribute.setAttributeType((AttributeTypeDef)this.archiveBuilder.getCollectionDef("map<string,object>"));
        attribute.setAttributeCardinality(AttributeCardinality.AT_MOST_ONE);
        attribute.setValuesMinCount(0);
        attribute.setValuesMaxCount(1);
        attribute.setIndexable(true);
        attribute.setUnique(false);
        attribute.setDefaultValue(null);
        attribute.setExternalStandardMappings(null);
        attribute.setAttributeStatus(TypeDefAttributeStatus.ACTIVE_ATTRIBUTE);
        return attribute;
    }

    public TypeDefAttribute getMapStringBooleanTypeDefAttribute(String attributeName, String attributeDescription, String attributeDescriptionGUID) {
        TypeDefAttribute attribute = new TypeDefAttribute();
        attribute.setHeaderVersion(1L);
        attribute.setAttributeName(attributeName);
        attribute.setAttributeDescription(attributeDescription);
        attribute.setAttributeDescriptionGUID(attributeDescriptionGUID);
        attribute.setAttributeType((AttributeTypeDef)this.archiveBuilder.getCollectionDef("map<string,boolean>"));
        attribute.setAttributeCardinality(AttributeCardinality.AT_MOST_ONE);
        attribute.setValuesMinCount(0);
        attribute.setValuesMaxCount(1);
        attribute.setIndexable(true);
        attribute.setUnique(false);
        attribute.setDefaultValue(null);
        attribute.setExternalStandardMappings(null);
        attribute.setAttributeStatus(TypeDefAttributeStatus.ACTIVE_ATTRIBUTE);
        return attribute;
    }

    public TypeDefAttribute getMapStringLongTypeDefAttribute(String attributeName, String attributeDescription, String attributeDescriptionGUID) {
        TypeDefAttribute attribute = new TypeDefAttribute();
        attribute.setHeaderVersion(1L);
        attribute.setAttributeName(attributeName);
        attribute.setAttributeDescription(attributeDescription);
        attribute.setAttributeDescriptionGUID(attributeDescriptionGUID);
        attribute.setAttributeType((AttributeTypeDef)this.archiveBuilder.getCollectionDef("map<string,long>"));
        attribute.setAttributeCardinality(AttributeCardinality.AT_MOST_ONE);
        attribute.setValuesMinCount(0);
        attribute.setValuesMaxCount(1);
        attribute.setIndexable(true);
        attribute.setUnique(false);
        attribute.setDefaultValue(null);
        attribute.setExternalStandardMappings(null);
        attribute.setAttributeStatus(TypeDefAttributeStatus.ACTIVE_ATTRIBUTE);
        return attribute;
    }

    public TypeDefAttribute getMapStringDoubleTypeDefAttribute(String attributeName, String attributeDescription, String attributeDescriptionGUID) {
        TypeDefAttribute attribute = new TypeDefAttribute();
        attribute.setHeaderVersion(1L);
        attribute.setAttributeName(attributeName);
        attribute.setAttributeDescription(attributeDescription);
        attribute.setAttributeDescriptionGUID(attributeDescriptionGUID);
        attribute.setAttributeType((AttributeTypeDef)this.archiveBuilder.getCollectionDef("map<string,double>"));
        attribute.setAttributeCardinality(AttributeCardinality.AT_MOST_ONE);
        attribute.setValuesMinCount(0);
        attribute.setValuesMaxCount(1);
        attribute.setIndexable(true);
        attribute.setUnique(false);
        attribute.setDefaultValue(null);
        attribute.setExternalStandardMappings(null);
        attribute.setAttributeStatus(TypeDefAttributeStatus.ACTIVE_ATTRIBUTE);
        return attribute;
    }

    public TypeDefAttribute getMapStringDateTypeDefAttribute(String attributeName, String attributeDescription, String attributeDescriptionGUID) {
        TypeDefAttribute attribute = new TypeDefAttribute();
        attribute.setHeaderVersion(1L);
        attribute.setAttributeName(attributeName);
        attribute.setAttributeDescription(attributeDescription);
        attribute.setAttributeDescriptionGUID(attributeDescriptionGUID);
        attribute.setAttributeType((AttributeTypeDef)this.archiveBuilder.getCollectionDef("map<string,date>"));
        attribute.setAttributeCardinality(AttributeCardinality.AT_MOST_ONE);
        attribute.setValuesMinCount(0);
        attribute.setValuesMaxCount(1);
        attribute.setIndexable(true);
        attribute.setUnique(false);
        attribute.setDefaultValue(null);
        attribute.setExternalStandardMappings(null);
        attribute.setAttributeStatus(TypeDefAttributeStatus.ACTIVE_ATTRIBUTE);
        return attribute;
    }

    public TypeDefAttribute getMapStringIntTypeDefAttribute(String attributeName, String attributeDescription, String attributeDescriptionGUID) {
        TypeDefAttribute attribute = new TypeDefAttribute();
        attribute.setHeaderVersion(1L);
        attribute.setAttributeName(attributeName);
        attribute.setAttributeDescription(attributeDescription);
        attribute.setAttributeDescriptionGUID(attributeDescriptionGUID);
        attribute.setAttributeType((AttributeTypeDef)this.archiveBuilder.getCollectionDef("map<string,int>"));
        attribute.setAttributeCardinality(AttributeCardinality.AT_MOST_ONE);
        attribute.setValuesMinCount(0);
        attribute.setValuesMaxCount(1);
        attribute.setIndexable(true);
        attribute.setUnique(false);
        attribute.setDefaultValue(null);
        attribute.setExternalStandardMappings(null);
        attribute.setAttributeStatus(TypeDefAttributeStatus.ACTIVE_ATTRIBUTE);
        return attribute;
    }

    public TypeDefAttribute getEnumTypeDefAttribute(OpenMetadataProperty propertyDescription) {
        return this.getEnumTypeDefAttribute(propertyDescription.type, propertyDescription.name, propertyDescription.description, propertyDescription.descriptionGUID);
    }

    public TypeDefAttribute getEnumTypeDefAttribute(String enumTypeName, String attributeName, String attributeDescription, String attributeDescriptionGUID) {
        TypeDefAttribute attribute = new TypeDefAttribute();
        attribute.setHeaderVersion(1L);
        attribute.setAttributeName(attributeName);
        attribute.setAttributeDescription(attributeDescription);
        attribute.setAttributeDescriptionGUID(attributeDescriptionGUID);
        attribute.setAttributeType((AttributeTypeDef)this.archiveBuilder.getEnumDef(enumTypeName));
        attribute.setAttributeCardinality(AttributeCardinality.AT_MOST_ONE);
        attribute.setValuesMinCount(0);
        attribute.setValuesMaxCount(1);
        attribute.setIndexable(true);
        attribute.setUnique(false);
        attribute.setDefaultValue(null);
        attribute.setExternalStandardMappings(null);
        attribute.setAttributeStatus(TypeDefAttributeStatus.ACTIVE_ATTRIBUTE);
        return attribute;
    }

    public TypeDefAttribute getArrayEnumTypeDefAttribute(String enumArrayTypeName, String attributeName, String attributeDescription, String attributeDescriptionGUID) {
        TypeDefAttribute attribute = new TypeDefAttribute();
        attribute.setHeaderVersion(1L);
        attribute.setAttributeName(attributeName);
        attribute.setAttributeDescription(attributeDescription);
        attribute.setAttributeDescriptionGUID(attributeDescriptionGUID);
        attribute.setAttributeType((AttributeTypeDef)this.archiveBuilder.getCollectionDef(enumArrayTypeName));
        attribute.setAttributeCardinality(AttributeCardinality.AT_MOST_ONE);
        attribute.setValuesMinCount(0);
        attribute.setValuesMaxCount(1);
        attribute.setIndexable(true);
        attribute.setUnique(false);
        attribute.setDefaultValue(null);
        attribute.setExternalStandardMappings(null);
        attribute.setAttributeStatus(TypeDefAttributeStatus.ACTIVE_ATTRIBUTE);
        return attribute;
    }

    public RelationshipDef getBasicRelationshipDef(String guid, String name, TypeDefLink superType, String description, String descriptionGUID, ClassificationPropagationRule propagationRule) {
        RelationshipDef relationshipDef = new RelationshipDef();
        relationshipDef.setHeaderVersion(1L);
        relationshipDef.setGUID(guid);
        relationshipDef.setName(name);
        relationshipDef.setSuperType(superType);
        relationshipDef.setDescription(description);
        relationshipDef.setDescriptionGUID(descriptionGUID);
        relationshipDef.setOrigin(this.archiveGUID);
        relationshipDef.setCreatedBy(this.originatorName);
        relationshipDef.setCreateTime(this.creationDate);
        relationshipDef.setVersion(this.versionNumber);
        relationshipDef.setVersionName(this.versionName);
        TypeDef superTypeDef = null;
        if (superType != null) {
            superTypeDef = this.archiveBuilder.getTypeDefByName(superType.getName());
        }
        if (superTypeDef != null) {
            relationshipDef.setValidInstanceStatusList(superTypeDef.getValidInstanceStatusList());
            relationshipDef.setInitialStatus(superTypeDef.getInitialStatus());
        } else {
            ArrayList<InstanceStatus> validInstanceStatusList = new ArrayList<InstanceStatus>();
            validInstanceStatusList.add(InstanceStatus.ACTIVE);
            validInstanceStatusList.add(InstanceStatus.DELETED);
            relationshipDef.setValidInstanceStatusList(validInstanceStatusList);
            relationshipDef.setInitialStatus(InstanceStatus.ACTIVE);
        }
        relationshipDef.setPropagationRule(propagationRule);
        relationshipDef.setStatus(TypeDefStatus.ACTIVE_TYPEDEF);
        return relationshipDef;
    }

    public RelationshipDef getBasicRelationshipDef(OpenMetadataType type, TypeDefLink superType, ClassificationPropagationRule propagationRule) {
        return this.getBasicRelationshipDef(type.typeGUID, type.typeName, superType, type.description, type.descriptionGUID, type.wikiURL, propagationRule);
    }

    public RelationshipDef getBasicRelationshipDef(String guid, String name, TypeDefLink superType, String description, String descriptionGUID, String descriptionWiki, ClassificationPropagationRule propagationRule) {
        RelationshipDef relationshipDef = new RelationshipDef();
        relationshipDef.setHeaderVersion(1L);
        relationshipDef.setGUID(guid);
        relationshipDef.setName(name);
        relationshipDef.setSuperType(superType);
        relationshipDef.setDescription(description);
        relationshipDef.setDescriptionGUID(descriptionGUID);
        relationshipDef.setDescriptionWiki(descriptionWiki);
        relationshipDef.setOrigin(this.archiveGUID);
        relationshipDef.setCreatedBy(this.originatorName);
        relationshipDef.setCreateTime(this.creationDate);
        relationshipDef.setVersion(this.versionNumber);
        relationshipDef.setVersionName(this.versionName);
        TypeDef superTypeDef = null;
        if (superType != null) {
            superTypeDef = this.archiveBuilder.getTypeDefByName(superType.getName());
        }
        if (superTypeDef != null) {
            relationshipDef.setValidInstanceStatusList(superTypeDef.getValidInstanceStatusList());
            relationshipDef.setInitialStatus(superTypeDef.getInitialStatus());
        } else {
            ArrayList<InstanceStatus> validInstanceStatusList = new ArrayList<InstanceStatus>();
            validInstanceStatusList.add(InstanceStatus.ACTIVE);
            validInstanceStatusList.add(InstanceStatus.DELETED);
            relationshipDef.setValidInstanceStatusList(validInstanceStatusList);
            relationshipDef.setInitialStatus(InstanceStatus.ACTIVE);
        }
        relationshipDef.setPropagationRule(propagationRule);
        relationshipDef.setStatus(TypeDefStatus.ACTIVE_TYPEDEF);
        return relationshipDef;
    }

    public RelationshipEndDef getRelationshipEndDef(TypeDefLink entityType, String attributeName, String attributeDescription, String attributeDescriptionGUID, RelationshipEndCardinality attributeCardinality) {
        RelationshipEndDef relationshipEndDef = new RelationshipEndDef();
        relationshipEndDef.setHeaderVersion(1L);
        relationshipEndDef.setEntityType(entityType);
        relationshipEndDef.setAttributeName(attributeName);
        relationshipEndDef.setAttributeDescription(attributeDescription);
        relationshipEndDef.setAttributeDescriptionGUID(attributeDescriptionGUID);
        relationshipEndDef.setAttributeCardinality(attributeCardinality);
        return relationshipEndDef;
    }

    public ClassificationDef getClassificationDef(String guid, String name, TypeDefLink superType, String description, String descriptionGUID, TypeDefLink validEntityDef, boolean propagatable) {
        ArrayList<TypeDefLink> validEntityDefs = new ArrayList<TypeDefLink>();
        validEntityDefs.add(validEntityDef);
        return this.getClassificationDef(guid, name, superType, description, descriptionGUID, validEntityDefs, propagatable);
    }

    public ClassificationDef getClassificationDef(OpenMetadataType type, TypeDefLink superType, TypeDefLink validEntityDef, boolean propagatable) {
        ArrayList<TypeDefLink> validEntityDefs = new ArrayList<TypeDefLink>();
        validEntityDefs.add(validEntityDef);
        return this.getClassificationDef(type.typeGUID, type.typeName, superType, type.description, type.descriptionGUID, type.wikiURL, validEntityDefs, propagatable);
    }

    public ClassificationDef getClassificationDef(OpenMetadataType type, TypeDefLink superType, List<TypeDefLink> validEntityDefs, boolean propagatable) {
        return this.getClassificationDef(type.typeGUID, type.typeName, superType, type.description, type.descriptionGUID, type.wikiURL, validEntityDefs, propagatable);
    }

    public ClassificationDef getClassificationDef(String guid, String name, TypeDefLink superType, String description, String descriptionGUID, List<TypeDefLink> validEntityDefs, boolean propagatable) {
        return this.getClassificationDef(guid, name, superType, description, descriptionGUID, null, validEntityDefs, propagatable);
    }

    public ClassificationDef getClassificationDef(String guid, String name, TypeDefLink superType, String description, String descriptionGUID, String descriptionWiki, List<TypeDefLink> validEntityDefs, boolean propagatable) {
        ClassificationDef classificationDef = new ClassificationDef();
        classificationDef.setHeaderVersion(1L);
        classificationDef.setGUID(guid);
        classificationDef.setName(name);
        classificationDef.setSuperType(superType);
        classificationDef.setDescription(description);
        classificationDef.setDescriptionGUID(descriptionGUID);
        classificationDef.setDescriptionWiki(descriptionWiki);
        classificationDef.setOrigin(this.archiveGUID);
        classificationDef.setCreatedBy(this.originatorName);
        classificationDef.setCreateTime(this.creationDate);
        classificationDef.setVersion(this.versionNumber);
        classificationDef.setVersionName(this.versionName);
        TypeDef superTypeDef = null;
        if (superType != null) {
            superTypeDef = this.archiveBuilder.getTypeDefByName(superType.getName());
        }
        if (superTypeDef != null) {
            classificationDef.setValidInstanceStatusList(superTypeDef.getValidInstanceStatusList());
            classificationDef.setInitialStatus(superTypeDef.getInitialStatus());
        } else {
            ArrayList<InstanceStatus> validInstanceStatusList = new ArrayList<InstanceStatus>();
            validInstanceStatusList.add(InstanceStatus.ACTIVE);
            validInstanceStatusList.add(InstanceStatus.DELETED);
            classificationDef.setValidInstanceStatusList(validInstanceStatusList);
            classificationDef.setInitialStatus(InstanceStatus.ACTIVE);
        }
        classificationDef.setValidEntityDefs(validEntityDefs);
        classificationDef.setPropagatable(propagatable);
        classificationDef.setStatus(TypeDefStatus.ACTIVE_TYPEDEF);
        return classificationDef;
    }

    private List<String> getPropertiesList(List<TypeDefAttribute> definedAttributes, List<String> currentList) {
        List<String> newList = currentList;
        if (newList == null) {
            newList = new ArrayList<String>();
        }
        if (definedAttributes != null) {
            for (TypeDefAttribute attribute : definedAttributes) {
                if (attribute == null) continue;
                newList.add(attribute.getAttributeName());
            }
        }
        if (newList.isEmpty()) {
            return null;
        }
        return newList;
    }

    private InstanceProperties getUniqueProperties(String typeName, InstanceProperties allProperties) {
        InstanceProperties uniqueProperties = null;
        if (allProperties != null) {
            uniqueProperties = new InstanceProperties();
            uniqueProperties.setEffectiveFromTime(allProperties.getEffectiveFromTime());
            uniqueProperties.setEffectiveToTime(allProperties.getEffectiveToTime());
            TypeDef typeDef = this.archiveBuilder.getTypeDefByName(typeName);
            if (typeDef != null) {
                List uniquePropertyNames = this.getUniquePropertiesList(typeDef.getPropertiesDefinition(), null);
                TypeDef superType = null;
                if (typeDef.getSuperType() != null) {
                    superType = this.archiveBuilder.getTypeDefByName(typeDef.getSuperType().getName());
                }
                while (superType != null) {
                    uniquePropertyNames = this.getUniquePropertiesList(superType.getPropertiesDefinition(), uniquePropertyNames);
                    if (superType.getSuperType() != null) {
                        superType = this.archiveBuilder.getTypeDefByName(superType.getSuperType().getName());
                        continue;
                    }
                    superType = null;
                }
                if (uniquePropertyNames != null) {
                    Map allInstancePropertiesMap = allProperties.getInstanceProperties();
                    HashMap<String, InstancePropertyValue> uniqueInstancePropertiesMap = new HashMap<String, InstancePropertyValue>();
                    if (allInstancePropertiesMap != null) {
                        for (String propertyName : allInstancePropertiesMap.keySet()) {
                            if (propertyName == null || !uniquePropertyNames.contains(propertyName)) continue;
                            uniqueInstancePropertiesMap.put(propertyName, (InstancePropertyValue)allInstancePropertiesMap.get(propertyName));
                        }
                    }
                    if (!uniqueInstancePropertiesMap.isEmpty()) {
                        uniqueProperties.setInstanceProperties(uniqueInstancePropertiesMap);
                    }
                }
            }
        }
        return uniqueProperties;
    }

    private InstanceType getInstanceTypeHeader(TypeDef typeDef) {
        InstanceType instanceType = null;
        if (typeDef != null) {
            instanceType = new InstanceType();
            instanceType.setHeaderVersion(1L);
            instanceType.setTypeDefCategory(typeDef.getCategory());
            instanceType.setTypeDefGUID(typeDef.getGUID());
            instanceType.setTypeDefName(typeDef.getName());
            instanceType.setTypeDefVersion(typeDef.getVersion());
        }
        return instanceType;
    }

    private InstanceType getInstanceType(String typeDefName) {
        TypeDef typeDef = this.archiveBuilder.getTypeDefByName(typeDefName);
        return this.getInstanceTypeHeader(typeDef);
    }

    private void setInstanceAuditHeader(InstanceAuditHeader instanceAuditHeader, InstanceType type, InstanceStatus status) {
        instanceAuditHeader.setHeaderVersion(1L);
        instanceAuditHeader.setCreatedBy(this.originatorName);
        if (this.creationDate == null) {
            instanceAuditHeader.setCreateTime(new Date());
        } else {
            instanceAuditHeader.setCreateTime(this.creationDate);
        }
        instanceAuditHeader.setInstanceLicense(this.license);
        instanceAuditHeader.setInstanceProvenanceType(this.instanceProvenanceType);
        instanceAuditHeader.setMaintainedBy(null);
        instanceAuditHeader.setMetadataCollectionId(this.archiveGUID);
        instanceAuditHeader.setMetadataCollectionName(this.archiveName);
        instanceAuditHeader.setReplicatedBy(null);
        instanceAuditHeader.setStatus(InstanceStatus.ACTIVE);
        instanceAuditHeader.setStatusOnDelete(null);
        instanceAuditHeader.setType(type);
        instanceAuditHeader.setVersion(this.versionNumber);
        if (this.versionNumber == 1L) {
            instanceAuditHeader.setUpdatedBy(null);
            instanceAuditHeader.setUpdateTime(null);
        } else {
            instanceAuditHeader.setUpdatedBy(this.originatorName);
            instanceAuditHeader.setUpdateTime(new Date());
        }
        instanceAuditHeader.setStatus(status);
    }

    private void setInstanceHeader(InstanceHeader instanceHeader, String typeName, String guid, InstanceStatus status) {
        InstanceType type = this.getInstanceType(typeName);
        this.setInstanceAuditHeader((InstanceAuditHeader)instanceHeader, type, status);
        instanceHeader.setGUID(guid);
        instanceHeader.setInstanceURL(null);
    }

    public EntityDetail getEntityDetail(String typeName, String guid, InstanceProperties properties, InstanceStatus status, List<Classification> classifications) {
        EntityDetail entityDetail = new EntityDetail();
        this.setInstanceHeader((InstanceHeader)entityDetail, typeName, guid, status);
        entityDetail.setProperties(properties);
        entityDetail.setClassifications(classifications);
        return entityDetail;
    }

    public Relationship getRelationship(String typeName, String guid, InstanceProperties properties, InstanceStatus status, EntityProxy end1, EntityProxy end2) {
        Relationship relationship = new Relationship();
        this.setInstanceHeader((InstanceHeader)relationship, typeName, guid, status);
        relationship.setProperties(properties);
        relationship.setEntityOneProxy(end1);
        relationship.setEntityTwoProxy(end2);
        return relationship;
    }

    public Classification getClassification(String typeName, InstanceProperties properties, InstanceStatus status) {
        Classification classification = new Classification();
        InstanceType type = this.getInstanceType(typeName);
        classification.setName(typeName);
        this.setInstanceAuditHeader((InstanceAuditHeader)classification, type, status);
        classification.setProperties(properties);
        return classification;
    }

    public EntityProxy getEntityProxy(String typeName, String guid, InstanceProperties properties, InstanceStatus status, List<Classification> classifications) {
        EntityProxy entityProxy = new EntityProxy();
        this.setInstanceHeader((InstanceHeader)entityProxy, typeName, guid, status);
        entityProxy.setUniqueProperties(properties);
        entityProxy.setClassifications(classifications);
        return entityProxy;
    }

    public EntityProxy getEntityProxy(EntityDetail entity) {
        EntityProxy entityProxy = new EntityProxy((EntitySummary)entity);
        String typeName = entity.getType().getTypeDefName();
        entityProxy.setUniqueProperties(this.getUniqueProperties(typeName, entity.getProperties()));
        entityProxy.setClassifications(entity.getClassifications());
        return entityProxy;
    }

    public ClassificationEntityExtension getClassificationEntityExtension(EntityProxy entity, Classification classification) {
        ClassificationEntityExtension classificationEntityExtension = new ClassificationEntityExtension();
        classificationEntityExtension.setHeaderVersion(1L);
        classificationEntityExtension.setEntityToClassify(entity);
        classificationEntityExtension.setClassification(classification);
        return classificationEntityExtension;
    }

    public EnumElementDef getEnumElement(String enumTypeName, int ordinal) {
        EnumDef enumDef = this.archiveBuilder.getEnumDef(enumTypeName);
        for (EnumElementDef enumElementDef : enumDef.getElementDefs()) {
            if (enumElementDef.getOrdinal() != ordinal) continue;
            return enumElementDef;
        }
        return enumDef.getDefaultValue();
    }
}

