/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.clients;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.restclients.RESTClientConnector;
import org.odpi.openmetadata.adapters.connectors.restclients.RESTClientFactory;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLoggingComponent;
import org.odpi.openmetadata.repositoryservices.connectors.stores.cohortregistrystore.properties.MemberRegistration;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidRelationshipException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.properties.CohortDescription;
import org.odpi.openmetadata.repositoryservices.rest.properties.AttributeTypeDefResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.CohortListResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.CohortMembershipListResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.CohortMembershipResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.OMRSAPIResponse;

public class MetadataHighwayServicesClient
implements AuditLoggingComponent {
    private static final String rootServiceNameInURL = "/open-metadata/repository-services";
    private static final String userIdInURL = "/users/{0}";
    private String localServerUserId = null;
    private String localServerPassword = null;
    private String restURLRoot;
    private RESTClientConnector restClient;
    private String serverName;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    protected AuditLog auditLog = null;

    public MetadataHighwayServicesClient(String serverName, String restURLRoot) throws org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException {
        String methodName = "Constructor (no security)";
        try {
            this.invalidParameterHandler.validateOMAGServerPlatformURL(restURLRoot, "Constructor (no security)");
        }
        catch (InvalidParameterException error) {
            throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException(error.getReportedHTTPCode(), error.getReportingClassName(), error.getReportingActionDescription(), error.getReportedErrorMessage(), error.getReportedErrorMessageId(), error.getReportedErrorMessageParameters(), error.getReportedSystemAction(), error.getReportedUserAction(), ((Object)((Object)error)).getClass().getName(), error.getParameterName(), error.getRelatedProperties());
        }
        this.serverName = serverName;
        this.restURLRoot = restURLRoot;
        this.restClient = this.getRESTClientConnector(serverName, restURLRoot, null, null);
    }

    public MetadataHighwayServicesClient(String serverName, String restURLRoot, String userId, String password) throws org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException {
        String methodName = "Constructor (with security)";
        try {
            this.invalidParameterHandler.validateOMAGServerPlatformURL(restURLRoot, "Constructor (with security)");
        }
        catch (InvalidParameterException error) {
            throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException(error.getReportedHTTPCode(), error.getReportingClassName(), error.getReportingActionDescription(), error.getReportedErrorMessage(), error.getReportedErrorMessageId(), error.getReportedErrorMessageParameters(), error.getReportedSystemAction(), error.getReportedUserAction(), ((Object)((Object)error)).getClass().getName(), error.getParameterName(), error.getRelatedProperties());
        }
        this.serverName = serverName;
        this.restURLRoot = restURLRoot;
        this.restClient = this.getRESTClientConnector(serverName, restURLRoot, userId, password);
    }

    public void setAuditLog(AuditLog auditLog) {
        this.auditLog = auditLog;
    }

    public List<CohortDescription> getCohortDescriptions(String userId) throws org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "getCohortDescriptions";
        String operationSpecificURL = "/metadata-highway/cohort-descriptions";
        CohortListResponse restResult = null;
        try {
            restResult = (CohortListResponse)this.restClient.callGetRESTCall("getCohortDescriptions", CohortListResponse.class, this.restURLRoot + rootServiceNameInURL + userIdInURL + "/metadata-highway/cohort-descriptions", new Object[]{userId});
        }
        catch (Throwable error) {
            throw new RepositoryErrorException(OMRSErrorCode.REMOTE_REPOSITORY_ERROR.getMessageDefinition(new String[]{"getCohortDescriptions", this.serverName, error.getClass().getSimpleName(), error.getMessage()}), this.getClass().getName(), "getCohortDescriptions", error);
        }
        this.detectAndThrowInvalidParameterException("getCohortDescriptions", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("getCohortDescriptions", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("getCohortDescriptions", (OMRSAPIResponse)restResult);
        return restResult.getCohorts();
    }

    public MemberRegistration getLocalRegistration(String serverName, String userId, String cohortName) throws org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "getLocalRegistration";
        String operationSpecificURL = "/metadata-highway/cohorts/" + cohortName + "/local-registration";
        CohortMembershipResponse restResult = null;
        try {
            restResult = (CohortMembershipResponse)this.restClient.callGetRESTCall("getLocalRegistration", CohortMembershipResponse.class, this.restURLRoot + rootServiceNameInURL + userIdInURL + operationSpecificURL, new Object[]{userId});
        }
        catch (Throwable error) {
            throw new RepositoryErrorException(OMRSErrorCode.REMOTE_REPOSITORY_ERROR.getMessageDefinition(new String[]{"getLocalRegistration", serverName, error.getClass().getSimpleName(), error.getMessage()}), this.getClass().getName(), "getLocalRegistration", error);
        }
        this.detectAndThrowInvalidParameterException("getLocalRegistration", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("getLocalRegistration", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("getLocalRegistration", (OMRSAPIResponse)restResult);
        return restResult.getCohortMember();
    }

    public List<MemberRegistration> getRemoteRegistrations(String serverName, String userId, String cohortName) throws org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "getRemoteRegistrations";
        String operationSpecificURL = "/metadata-highway/cohorts/" + cohortName + "/remote-members";
        CohortMembershipListResponse restResult = null;
        try {
            restResult = (CohortMembershipListResponse)this.restClient.callGetRESTCall("getRemoteRegistrations", CohortMembershipListResponse.class, this.restURLRoot + rootServiceNameInURL + userIdInURL + operationSpecificURL, new Object[]{userId});
        }
        catch (Throwable error) {
            throw new RepositoryErrorException(OMRSErrorCode.REMOTE_REPOSITORY_ERROR.getMessageDefinition(new String[]{"getRemoteRegistrations", serverName, error.getClass().getSimpleName(), error.getMessage()}), this.getClass().getName(), "getRemoteRegistrations", error);
        }
        this.detectAndThrowInvalidParameterException("getRemoteRegistrations", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("getRemoteRegistrations", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("getRemoteRegistrations", (OMRSAPIResponse)restResult);
        return restResult.getCohortMembers();
    }

    private RESTClientConnector getRESTClientConnector(String serverName, String serverPlatformURLRoot, String userId, String password) throws org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException {
        String methodName = "getRESTClientConnector";
        RESTClientFactory clientFactory = this.localServerUserId != null && this.localServerPassword != null ? new RESTClientFactory(serverName, serverPlatformURLRoot, userId, password) : new RESTClientFactory(serverName, serverPlatformURLRoot);
        try {
            return clientFactory.getClientConnector();
        }
        catch (Throwable error) {
            throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException(OMRSErrorCode.NO_REST_CLIENT.getMessageDefinition(new String[]{serverName, error.getMessage()}), this.getClass().getName(), "getRESTClientConnector", error, "client");
        }
    }

    private CohortListResponse callCohortListGetRESTCall(String methodName, String operationSpecificURL, Object ... params) throws RepositoryErrorException {
        return this.callGetRESTCall(methodName, CohortListResponse.class, operationSpecificURL, params);
    }

    private AttributeTypeDefResponse callAttributeTypeDefPostRESTCall(String methodName, String operationSpecificURL, Object requestBody, Object ... params) throws RepositoryErrorException {
        return this.callPostRESTCall(methodName, AttributeTypeDefResponse.class, operationSpecificURL, requestBody, params);
    }

    private <T> T callGetRESTCall(String methodName, Class<T> returnClass, String operationSpecificURL) throws RepositoryErrorException {
        return this.callGetRESTCall(methodName, returnClass, operationSpecificURL, null);
    }

    private <T> T callGetRESTCall(String methodName, Class<T> returnClass, String operationSpecificURL, Object ... params) throws RepositoryErrorException {
        try {
            return (T)this.restClient.callGetRESTCall(methodName, returnClass, operationSpecificURL, params);
        }
        catch (Throwable error) {
            throw new RepositoryErrorException(OMRSErrorCode.CLIENT_SIDE_REST_API_ERROR.getMessageDefinition(new String[]{methodName, this.serverName, error.getMessage()}), this.getClass().getName(), methodName, error);
        }
    }

    private <T> T callPostRESTCall(String methodName, Class<T> returnClass, String operationSpecificURL, Object request, Object ... params) throws RepositoryErrorException {
        try {
            return (T)this.restClient.callPostRESTCall(methodName, returnClass, operationSpecificURL, request, params);
        }
        catch (Throwable error) {
            throw new RepositoryErrorException(OMRSErrorCode.CLIENT_SIDE_REST_API_ERROR.getMessageDefinition(new String[]{methodName, this.serverName, error.getMessage()}), this.getClass().getName(), methodName, error);
        }
    }

    private void detectAndThrowInvalidParameterException(String methodName, OMRSAPIResponse restResult) throws org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException, RepositoryErrorException {
        String exceptionClassName = org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException.class.getName();
        String propertyName = "parameterName";
        String serverName = "serverName";
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            Object nameObject;
            String parameterName = null;
            Map exceptionProperties = restResult.getExceptionProperties();
            if (exceptionProperties != null && (nameObject = exceptionProperties.get("parameterName")) != null) {
                parameterName = (String)nameObject;
            }
            if ("serverName".equals(parameterName)) {
                throw new RepositoryErrorException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionErrorMessageId(), restResult.getExceptionErrorMessageParameters(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), restResult.getExceptionCausedBy(), restResult.getExceptionProperties());
            }
            throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionErrorMessageId(), restResult.getExceptionErrorMessageParameters(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), restResult.getExceptionCausedBy(), parameterName, restResult.getExceptionProperties());
        }
    }

    private void detectAndThrowInvalidRelationshipException(String methodName, OMRSAPIResponse restResult) throws InvalidRelationshipException {
        String exceptionClassName = InvalidRelationshipException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            throw new InvalidRelationshipException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionErrorMessageId(), restResult.getExceptionErrorMessageParameters(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), restResult.getExceptionCausedBy(), restResult.getExceptionProperties());
        }
    }

    private void detectAndThrowUserNotAuthorizedException(String methodName, OMRSAPIResponse restResult) throws UserNotAuthorizedException {
        String exceptionClassName = UserNotAuthorizedException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            String userId = null;
            if (restResult.getExceptionProperties() != null) {
                userId = (String)restResult.getExceptionProperties().get("userId");
            }
            throw new UserNotAuthorizedException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionErrorMessageId(), restResult.getExceptionErrorMessageParameters(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), restResult.getExceptionCausedBy(), userId, restResult.getExceptionProperties());
        }
    }

    private void detectAndThrowRepositoryErrorException(String methodName, OMRSAPIResponse restResult) throws RepositoryErrorException {
        if (restResult == null) {
            throw new RepositoryErrorException(OMRSErrorCode.NULL_RESPONSE_FROM_API.getMessageDefinition(new String[]{methodName, this.serverName}), this.getClass().getName(), methodName);
        }
        if (restResult.getExceptionClassName() != null) {
            throw new RepositoryErrorException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionErrorMessageId(), restResult.getExceptionErrorMessageParameters(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), restResult.getExceptionCausedBy(), restResult.getExceptionProperties());
        }
    }
}

