/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.clients;

import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.restclients.RESTClientConnector;
import org.odpi.openmetadata.adapters.connectors.restclients.RESTClientFactory;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.exceptions.InvalidParameterException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLoggingComponent;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDescription;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogReport;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidRelationshipException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.rest.properties.AuditLogReportResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.OMRSAPIResponse;

public class AuditLogServicesClient
implements AuditLoggingComponent {
    private static final String rootServiceNameInURL = "/servers/{0}/open-metadata/repository-services";
    private static final String userIdInURL = "/users/{1}";
    private String localServerUserId = null;
    private String localServerPassword = null;
    private String restURLRoot;
    private RESTClientConnector restClient;
    private String serverName;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    protected AuditLog auditLog = null;

    public AuditLogServicesClient(String serverName, String restURLRoot) throws org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException {
        String methodName = "Constructor (no security)";
        try {
            this.invalidParameterHandler.validateOMAGServerPlatformURL(restURLRoot, "Constructor (no security)");
        }
        catch (InvalidParameterException error) {
            throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException(error.getReportedHTTPCode(), error.getReportingClassName(), error.getReportingActionDescription(), error.getReportedErrorMessage(), error.getReportedErrorMessageId(), error.getReportedErrorMessageParameters(), error.getReportedSystemAction(), error.getReportedUserAction(), ((Object)((Object)error)).getClass().getName(), error.getParameterName(), error.getRelatedProperties());
        }
        this.serverName = serverName;
        this.restURLRoot = restURLRoot;
        this.restClient = this.getRESTClientConnector(serverName, restURLRoot, null, null);
    }

    public AuditLogServicesClient(String serverName, String restURLRoot, String userId, String password) throws org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException {
        String methodName = "Constructor (with security)";
        try {
            this.invalidParameterHandler.validateOMAGServerPlatformURL(restURLRoot, "Constructor (with security)");
        }
        catch (InvalidParameterException error) {
            throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException(error.getReportedHTTPCode(), error.getReportingClassName(), error.getReportingActionDescription(), error.getReportedErrorMessage(), error.getReportedErrorMessageId(), error.getReportedErrorMessageParameters(), error.getReportedSystemAction(), error.getReportedUserAction(), ((Object)((Object)error)).getClass().getName(), error.getParameterName(), error.getRelatedProperties());
        }
        this.serverName = serverName;
        this.restURLRoot = restURLRoot;
        this.restClient = this.getRESTClientConnector(serverName, restURLRoot, userId, password);
    }

    public void setAuditLog(AuditLog auditLog) {
        this.auditLog = auditLog;
    }

    public ComponentDescription getConnectorComponentDescription() {
        if (this.auditLog != null && this.auditLog.getReport() != null) {
            return this.auditLog.getReport().getReportingComponent();
        }
        return null;
    }

    public OMRSAuditLogReport getAuditLogReport(String userId) throws org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        AuditLogReportResponse restResult;
        String methodName = "getAuditLogReport";
        String operationSpecificURL = "/audit-log/report";
        try {
            restResult = (AuditLogReportResponse)this.restClient.callGetRESTCall("getAuditLogReport", AuditLogReportResponse.class, this.restURLRoot + "/servers/{0}/open-metadata/repository-services/users/{1}/audit-log/report", new Object[]{this.serverName, userId});
        }
        catch (Exception error) {
            throw new RepositoryErrorException(OMRSErrorCode.REMOTE_REPOSITORY_ERROR.getMessageDefinition(new String[]{"getAuditLogReport", this.serverName, error.getClass().getSimpleName(), error.getMessage()}), this.getClass().getName(), "getAuditLogReport", (Throwable)error);
        }
        this.detectAndThrowInvalidParameterException("getAuditLogReport", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("getAuditLogReport", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("getAuditLogReport", (OMRSAPIResponse)restResult);
        return restResult.getReport();
    }

    private RESTClientConnector getRESTClientConnector(String serverName, String serverPlatformURLRoot, String userId, String password) throws org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException {
        String methodName = "getRESTClientConnector";
        RESTClientFactory clientFactory = this.localServerUserId != null && this.localServerPassword != null ? new RESTClientFactory(serverName, serverPlatformURLRoot, userId, password) : new RESTClientFactory(serverName, serverPlatformURLRoot);
        try {
            return clientFactory.getClientConnector();
        }
        catch (Exception error) {
            throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException(OMRSErrorCode.NO_REST_CLIENT.getMessageDefinition(new String[]{serverName, error.getMessage()}), this.getClass().getName(), "getRESTClientConnector", (Throwable)error, "client");
        }
    }

    private AuditLogReportResponse callAuditLogReportGetRESTCall(String methodName, String operationSpecificURL, Object ... params) throws RepositoryErrorException {
        return this.callGetRESTCall(methodName, AuditLogReportResponse.class, operationSpecificURL, params);
    }

    private <T> T callGetRESTCall(String methodName, Class<T> returnClass, String operationSpecificURL) throws RepositoryErrorException {
        return this.callGetRESTCall(methodName, returnClass, operationSpecificURL, null);
    }

    private <T> T callGetRESTCall(String methodName, Class<T> returnClass, String operationSpecificURL, Object ... params) throws RepositoryErrorException {
        try {
            return (T)this.restClient.callGetRESTCall(methodName, returnClass, operationSpecificURL, params);
        }
        catch (Exception error) {
            throw new RepositoryErrorException(OMRSErrorCode.CLIENT_SIDE_REST_API_ERROR.getMessageDefinition(new String[]{methodName, this.serverName, error.getMessage()}), this.getClass().getName(), methodName, (Throwable)error);
        }
    }

    private <T> T callPostRESTCall(String methodName, Class<T> returnClass, String operationSpecificURL, Object request, Object ... params) throws RepositoryErrorException {
        try {
            return (T)this.restClient.callPostRESTCall(methodName, returnClass, operationSpecificURL, request, params);
        }
        catch (Exception error) {
            throw new RepositoryErrorException(OMRSErrorCode.CLIENT_SIDE_REST_API_ERROR.getMessageDefinition(new String[]{methodName, this.serverName, error.getMessage()}), this.getClass().getName(), methodName, (Throwable)error);
        }
    }

    private void detectAndThrowInvalidParameterException(String methodName, OMRSAPIResponse restResult) throws org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException, RepositoryErrorException {
        String exceptionClassName = org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException.class.getName();
        String propertyName = "parameterName";
        String serverName = "serverName";
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            Object nameObject;
            String parameterName = null;
            Map exceptionProperties = restResult.getExceptionProperties();
            if (exceptionProperties != null && (nameObject = exceptionProperties.get("parameterName")) != null) {
                parameterName = (String)nameObject;
            }
            if ("serverName".equals(parameterName)) {
                throw new RepositoryErrorException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionErrorMessageId(), restResult.getExceptionErrorMessageParameters(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), restResult.getExceptionCausedBy(), restResult.getExceptionProperties());
            }
            throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionErrorMessageId(), restResult.getExceptionErrorMessageParameters(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), restResult.getExceptionCausedBy(), parameterName, restResult.getExceptionProperties());
        }
    }

    private void detectAndThrowInvalidRelationshipException(String methodName, OMRSAPIResponse restResult) throws InvalidRelationshipException {
        String exceptionClassName = InvalidRelationshipException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            throw new InvalidRelationshipException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionErrorMessageId(), restResult.getExceptionErrorMessageParameters(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), restResult.getExceptionCausedBy(), restResult.getExceptionProperties());
        }
    }

    private void detectAndThrowUserNotAuthorizedException(String methodName, OMRSAPIResponse restResult) throws UserNotAuthorizedException {
        String exceptionClassName = UserNotAuthorizedException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            String userId = null;
            if (restResult.getExceptionProperties() != null) {
                userId = (String)restResult.getExceptionProperties().get("userId");
            }
            throw new UserNotAuthorizedException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionErrorMessageId(), restResult.getExceptionErrorMessageParameters(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), restResult.getExceptionCausedBy(), userId, restResult.getExceptionProperties());
        }
    }

    private void detectAndThrowRepositoryErrorException(String methodName, OMRSAPIResponse restResult) throws RepositoryErrorException {
        if (restResult == null) {
            throw new RepositoryErrorException(OMRSErrorCode.NULL_RESPONSE_FROM_API.getMessageDefinition(new String[]{methodName, this.serverName}), this.getClass().getName(), methodName);
        }
        if (restResult.getExceptionClassName() != null) {
            throw new RepositoryErrorException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionErrorMessageId(), restResult.getExceptionErrorMessageParameters(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), restResult.getExceptionCausedBy(), restResult.getExceptionProperties());
        }
    }
}

