/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.clients;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.restclients.RESTClientConnector;
import org.odpi.openmetadata.adapters.connectors.restclients.factory.RESTClientFactory;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLoggingComponent;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDescription;
import org.odpi.openmetadata.repositoryservices.connectors.stores.cohortregistrystore.properties.MemberRegistration;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidRelationshipException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.properties.CohortDescription;
import org.odpi.openmetadata.repositoryservices.rest.properties.AttributeTypeDefResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.BooleanResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.CohortListResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.CohortMembershipListResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.CohortMembershipResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.OMRSAPIResponse;

public class MetadataHighwayServicesClient
implements AuditLoggingComponent {
    private static final String rootServiceNameInURL = "/servers/{0}/open-metadata/repository-services";
    private static final String userIdInURL = "/users/{1}";
    private final String localServerUserId;
    private final String localServerPassword;
    private final String restURLRoot;
    private final RESTClientConnector restClient;
    private final String serverName;
    private final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    protected AuditLog auditLog = null;

    public MetadataHighwayServicesClient(String serverName, String restURLRoot) throws InvalidParameterException {
        this.localServerUserId = null;
        this.localServerPassword = null;
        String methodName = "Constructor (no security)";
        try {
            this.invalidParameterHandler.validateOMAGServerPlatformURL(restURLRoot, "Constructor (no security)");
        }
        catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException error) {
            throw new InvalidParameterException(error.getReportedHTTPCode(), error.getReportingClassName(), error.getReportingActionDescription(), error.getReportedErrorMessage(), error.getReportedErrorMessageId(), error.getReportedErrorMessageParameters(), error.getReportedSystemAction(), error.getReportedUserAction(), ((Object)((Object)error)).getClass().getName(), error.getParameterName(), error.getRelatedProperties());
        }
        this.serverName = serverName;
        this.restURLRoot = restURLRoot;
        this.restClient = this.getRESTClientConnector(serverName, restURLRoot, null, null);
    }

    public MetadataHighwayServicesClient(String serverName, String restURLRoot, String userId, String password) throws InvalidParameterException {
        this.localServerUserId = null;
        this.localServerPassword = null;
        String methodName = "Constructor (with security)";
        try {
            this.invalidParameterHandler.validateOMAGServerPlatformURL(restURLRoot, "Constructor (with security)");
        }
        catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException error) {
            throw new InvalidParameterException(error.getReportedHTTPCode(), error.getReportingClassName(), error.getReportingActionDescription(), error.getReportedErrorMessage(), error.getReportedErrorMessageId(), error.getReportedErrorMessageParameters(), error.getReportedSystemAction(), error.getReportedUserAction(), ((Object)((Object)error)).getClass().getName(), error.getParameterName(), error.getRelatedProperties());
        }
        this.serverName = serverName;
        this.restURLRoot = restURLRoot;
        this.restClient = this.getRESTClientConnector(serverName, restURLRoot, userId, password);
    }

    public void setAuditLog(AuditLog auditLog) {
        this.auditLog = auditLog;
    }

    public ComponentDescription getConnectorComponentDescription() {
        if (this.auditLog != null && this.auditLog.getReport() != null) {
            return this.auditLog.getReport().getReportingComponent();
        }
        return null;
    }

    public List<CohortDescription> getCohortDescriptions(String userId) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        CohortListResponse restResult;
        String methodName = "getCohortDescriptions";
        String operationSpecificURL = "/metadata-highway/cohort-descriptions";
        try {
            restResult = (CohortListResponse)this.restClient.callGetRESTCall("getCohortDescriptions", CohortListResponse.class, this.restURLRoot + "/servers/{0}/open-metadata/repository-services/users/{1}/metadata-highway/cohort-descriptions", new Object[]{this.serverName, userId});
        }
        catch (Exception error) {
            throw new RepositoryErrorException(OMRSErrorCode.REMOTE_REPOSITORY_ERROR.getMessageDefinition(new String[]{"getCohortDescriptions", this.serverName, error.getClass().getSimpleName(), error.getMessage()}), this.getClass().getName(), "getCohortDescriptions", (Throwable)error);
        }
        this.detectAndThrowInvalidParameterException("getCohortDescriptions", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("getCohortDescriptions", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("getCohortDescriptions", (OMRSAPIResponse)restResult);
        return restResult.getCohorts();
    }

    public MemberRegistration getLocalRegistration(String userId, String cohortName) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "getLocalRegistration";
        String operationSpecificURL = "/metadata-highway/cohorts/" + cohortName + "/local-registration";
        CohortMembershipResponse restResult = null;
        try {
            restResult = (CohortMembershipResponse)this.restClient.callGetRESTCall("getLocalRegistration", CohortMembershipResponse.class, this.restURLRoot + "/servers/{0}/open-metadata/repository-services/users/{1}" + operationSpecificURL, new Object[]{this.serverName, userId});
        }
        catch (Exception error) {
            throw new RepositoryErrorException(OMRSErrorCode.REMOTE_REPOSITORY_ERROR.getMessageDefinition(new String[]{"getLocalRegistration", this.serverName, error.getClass().getSimpleName(), error.getMessage()}), this.getClass().getName(), "getLocalRegistration", (Throwable)error);
        }
        this.detectAndThrowInvalidParameterException("getLocalRegistration", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("getLocalRegistration", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("getLocalRegistration", (OMRSAPIResponse)restResult);
        return restResult.getCohortMember();
    }

    public boolean connectToCohort(String userId, String cohortName) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        BooleanResponse restResult;
        String methodName = "connectToCohort";
        String operationSpecificURL = "/metadata-highway/cohorts/" + cohortName + "/connect";
        try {
            restResult = (BooleanResponse)this.restClient.callGetRESTCall("connectToCohort", BooleanResponse.class, this.restURLRoot + "/servers/{0}/open-metadata/repository-services/users/{1}" + operationSpecificURL, new Object[]{this.serverName, userId});
        }
        catch (Exception error) {
            throw new RepositoryErrorException(OMRSErrorCode.REMOTE_REPOSITORY_ERROR.getMessageDefinition(new String[]{"connectToCohort", this.serverName, error.getClass().getSimpleName(), error.getMessage()}), this.getClass().getName(), "connectToCohort", (Throwable)error);
        }
        this.detectAndThrowInvalidParameterException("connectToCohort", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("connectToCohort", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("connectToCohort", (OMRSAPIResponse)restResult);
        return restResult.isFlag();
    }

    public List<MemberRegistration> getRemoteRegistrations(String userId, String cohortName) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "getRemoteRegistrations";
        String operationSpecificURL = "/metadata-highway/cohorts/" + cohortName + "/remote-members";
        CohortMembershipListResponse restResult = null;
        try {
            restResult = (CohortMembershipListResponse)this.restClient.callGetRESTCall("getRemoteRegistrations", CohortMembershipListResponse.class, this.restURLRoot + "/servers/{0}/open-metadata/repository-services/users/{1}" + operationSpecificURL, new Object[]{this.serverName, userId});
        }
        catch (Exception error) {
            throw new RepositoryErrorException(OMRSErrorCode.REMOTE_REPOSITORY_ERROR.getMessageDefinition(new String[]{"getRemoteRegistrations", this.serverName, error.getClass().getSimpleName(), error.getMessage()}), this.getClass().getName(), "getRemoteRegistrations", (Throwable)error);
        }
        this.detectAndThrowInvalidParameterException("getRemoteRegistrations", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("getRemoteRegistrations", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("getRemoteRegistrations", (OMRSAPIResponse)restResult);
        return restResult.getCohortMembers();
    }

    public boolean disconnectFromCohort(String userId, String cohortName) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        BooleanResponse restResult;
        String methodName = "disconnectFromCohort";
        String operationSpecificURL = "/metadata-highway/cohorts/" + cohortName + "/disconnect";
        try {
            restResult = (BooleanResponse)this.restClient.callGetRESTCall("disconnectFromCohort", BooleanResponse.class, this.restURLRoot + "/servers/{0}/open-metadata/repository-services/users/{1}" + operationSpecificURL, new Object[]{this.serverName, userId});
        }
        catch (Exception error) {
            throw new RepositoryErrorException(OMRSErrorCode.REMOTE_REPOSITORY_ERROR.getMessageDefinition(new String[]{"disconnectFromCohort", this.serverName, error.getClass().getSimpleName(), error.getMessage()}), this.getClass().getName(), "disconnectFromCohort", (Throwable)error);
        }
        this.detectAndThrowInvalidParameterException("disconnectFromCohort", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("disconnectFromCohort", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("disconnectFromCohort", (OMRSAPIResponse)restResult);
        return restResult.isFlag();
    }

    public boolean unregisterFromCohort(String userId, String cohortName) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        BooleanResponse restResult;
        String methodName = "unregisterFromCohort";
        String operationSpecificURL = "/metadata-highway/cohorts/" + cohortName + "/unregister";
        try {
            restResult = (BooleanResponse)this.restClient.callGetRESTCall("unregisterFromCohort", BooleanResponse.class, this.restURLRoot + "/servers/{0}/open-metadata/repository-services/users/{1}" + operationSpecificURL, new Object[]{this.serverName, userId});
        }
        catch (Exception error) {
            throw new RepositoryErrorException(OMRSErrorCode.REMOTE_REPOSITORY_ERROR.getMessageDefinition(new String[]{"unregisterFromCohort", this.serverName, error.getClass().getSimpleName(), error.getMessage()}), this.getClass().getName(), "unregisterFromCohort", (Throwable)error);
        }
        this.detectAndThrowInvalidParameterException("unregisterFromCohort", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("unregisterFromCohort", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("unregisterFromCohort", (OMRSAPIResponse)restResult);
        return restResult.isFlag();
    }

    private RESTClientConnector getRESTClientConnector(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        String methodName = "getRESTClientConnector";
        RESTClientFactory clientFactory = this.localServerUserId != null && this.localServerPassword != null ? new RESTClientFactory(serverName, serverPlatformURLRoot, userId, password, null, this.auditLog) : new RESTClientFactory(serverName, serverPlatformURLRoot);
        try {
            return clientFactory.getClientConnector();
        }
        catch (Exception error) {
            throw new InvalidParameterException(OMRSErrorCode.NO_REST_CLIENT.getMessageDefinition(new String[]{serverName, error.getMessage()}), this.getClass().getName(), "getRESTClientConnector", (Throwable)error, "client");
        }
    }

    private CohortListResponse callCohortListGetRESTCall(String methodName, String operationSpecificURL, Object ... params) throws RepositoryErrorException {
        return this.callGetRESTCall(methodName, CohortListResponse.class, operationSpecificURL, params);
    }

    private AttributeTypeDefResponse callAttributeTypeDefPostRESTCall(String methodName, String operationSpecificURL, Object requestBody, Object ... params) throws RepositoryErrorException {
        return this.callPostRESTCall(methodName, AttributeTypeDefResponse.class, operationSpecificURL, requestBody, params);
    }

    private <T> T callGetRESTCall(String methodName, Class<T> returnClass, String operationSpecificURL) throws RepositoryErrorException {
        return this.callGetRESTCall(methodName, returnClass, operationSpecificURL, null);
    }

    private <T> T callGetRESTCall(String methodName, Class<T> returnClass, String operationSpecificURL, Object ... params) throws RepositoryErrorException {
        try {
            return (T)this.restClient.callGetRESTCall(methodName, returnClass, operationSpecificURL, params);
        }
        catch (Exception error) {
            throw new RepositoryErrorException(OMRSErrorCode.CLIENT_SIDE_REST_API_ERROR.getMessageDefinition(new String[]{methodName, this.serverName, error.getMessage()}), this.getClass().getName(), methodName, (Throwable)error);
        }
    }

    private <T> T callPostRESTCall(String methodName, Class<T> returnClass, String operationSpecificURL, Object request, Object ... params) throws RepositoryErrorException {
        try {
            return (T)this.restClient.callPostRESTCall(methodName, returnClass, operationSpecificURL, request, params);
        }
        catch (Exception error) {
            throw new RepositoryErrorException(OMRSErrorCode.CLIENT_SIDE_REST_API_ERROR.getMessageDefinition(new String[]{methodName, this.serverName, error.getMessage()}), this.getClass().getName(), methodName, (Throwable)error);
        }
    }

    private void detectAndThrowInvalidParameterException(String methodName, OMRSAPIResponse restResult) throws InvalidParameterException, RepositoryErrorException {
        String exceptionClassName = InvalidParameterException.class.getName();
        String propertyName = "parameterName";
        String serverName = "serverName";
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            Object nameObject;
            String parameterName = null;
            Map exceptionProperties = restResult.getExceptionProperties();
            if (exceptionProperties != null && (nameObject = exceptionProperties.get("parameterName")) != null) {
                parameterName = (String)nameObject;
            }
            if ("serverName".equals(parameterName)) {
                throw new RepositoryErrorException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionErrorMessageId(), restResult.getExceptionErrorMessageParameters(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), restResult.getExceptionCausedBy(), restResult.getExceptionProperties());
            }
            throw new InvalidParameterException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionErrorMessageId(), restResult.getExceptionErrorMessageParameters(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), restResult.getExceptionCausedBy(), parameterName, restResult.getExceptionProperties());
        }
    }

    private void detectAndThrowInvalidRelationshipException(String methodName, OMRSAPIResponse restResult) throws InvalidRelationshipException {
        String exceptionClassName = InvalidRelationshipException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            throw new InvalidRelationshipException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionErrorMessageId(), restResult.getExceptionErrorMessageParameters(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), restResult.getExceptionCausedBy(), restResult.getExceptionProperties());
        }
    }

    private void detectAndThrowUserNotAuthorizedException(String methodName, OMRSAPIResponse restResult) throws UserNotAuthorizedException {
        String exceptionClassName = UserNotAuthorizedException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            String userId = null;
            if (restResult.getExceptionProperties() != null) {
                userId = (String)restResult.getExceptionProperties().get("userId");
            }
            throw new UserNotAuthorizedException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionErrorMessageId(), restResult.getExceptionErrorMessageParameters(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), restResult.getExceptionCausedBy(), userId, restResult.getExceptionProperties());
        }
    }

    private void detectAndThrowRepositoryErrorException(String methodName, OMRSAPIResponse restResult) throws RepositoryErrorException {
        if (restResult == null) {
            throw new RepositoryErrorException(OMRSErrorCode.NULL_RESPONSE_FROM_API.getMessageDefinition(new String[]{methodName, this.serverName}), this.getClass().getName(), methodName);
        }
        if (restResult.getExceptionClassName() != null) {
            throw new RepositoryErrorException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionErrorMessageId(), restResult.getExceptionErrorMessageParameters(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), restResult.getExceptionCausedBy(), restResult.getExceptionProperties());
        }
    }
}

