/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.clients;

import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.clients.MetadataCollectionServicesClient;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicRepositoryEventListener;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.rest.properties.ConnectionResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.OMRSAPIResponse;

public class EnterpriseRepositoryServicesClient
extends MetadataCollectionServicesClient {
    private OMRSTopicConnector remoteEnterpriseTopicConnector = null;
    private String callerId = null;

    public EnterpriseRepositoryServicesClient(String serverName, String restURLRoot) throws org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException {
        super(serverName, restURLRoot, "/enterprise/");
    }

    public EnterpriseRepositoryServicesClient(String repositoryName, String restURLRoot, String userId, String password) throws org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException {
        super(repositoryName, restURLRoot, "/enterprise/", userId, password);
    }

    public EnterpriseRepositoryServicesClient(String repositoryName, String restURLRoot, int maxPageSize, String callerId) throws org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException {
        super(repositoryName, restURLRoot, "/enterprise/");
        this.callerId = callerId;
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
    }

    public EnterpriseRepositoryServicesClient(String repositoryName, String restURLRoot, String userId, String password, int maxPageSize, String callerId) throws org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException {
        super(repositoryName, restURLRoot, "/enterprise/", userId, password);
        this.callerId = callerId;
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
    }

    public void registerListener(String userId, OMRSTopicRepositoryEventListener listener) throws org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "registerListener";
        String nameParameter = "listener";
        String callerIdParameter = "callerId";
        String urlTemplate = "/open-metadata/repository-services/users/{0}/enterprise/remote-topic-connection";
        try {
            this.invalidParameterHandler.validateUserId(userId, "registerListener");
            this.invalidParameterHandler.validateObject((Object)listener, "listener", "registerListener");
            this.invalidParameterHandler.validateName(this.callerId, "callerId", "registerListener");
        }
        catch (InvalidParameterException error) {
            throw new org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException(error.getReportedHTTPCode(), error.getReportingClassName(), error.getReportingActionDescription(), error.getReportedErrorMessage(), error.getReportedErrorMessageId(), error.getReportedErrorMessageParameters(), error.getReportedSystemAction(), error.getReportedUserAction(), ((Object)((Object)error)).getClass().getName(), error.getParameterName(), error.getRelatedProperties());
        }
        if (this.remoteEnterpriseTopicConnector == null) {
            try {
                ConnectionResponse restResult = (ConnectionResponse)this.restClient.callGetRESTCall("registerListener", ConnectionResponse.class, this.restURLRoot + "/open-metadata/repository-services/users/{0}/enterprise/remote-topic-connection", new Object[]{userId});
                super.detectAndThrowInvalidParameterException("registerListener", (OMRSAPIResponse)restResult);
                super.detectAndThrowUserNotAuthorizedException("registerListener", (OMRSAPIResponse)restResult);
                super.detectAndThrowRepositoryErrorException("registerListener", (OMRSAPIResponse)restResult);
                Connection topicConnection = restResult.getConnection();
                ConnectorBroker connectorBroker = new ConnectorBroker(this.auditLog);
                Connector connector = connectorBroker.getConnector(topicConnection);
                if (connector == null) {
                    throw new ConnectorCheckedException(OMRSErrorCode.NULL_CONNECTOR_RETURNED.getMessageDefinition(new String[]{topicConnection.getQualifiedName(), this.repositoryName, this.restURLRoot}), this.getClass().getName(), "registerListener");
                }
                if (!(connector instanceof OMRSTopicConnector)) {
                    throw new ConnectorCheckedException(OMRSErrorCode.WRONG_TYPE_OF_CONNECTOR.getMessageDefinition(new String[]{topicConnection.getQualifiedName(), this.repositoryName, this.restURLRoot, OMRSTopicConnector.class.getName()}), this.getClass().getName(), "registerListener");
                }
                this.remoteEnterpriseTopicConnector = (OMRSTopicConnector)connector;
                this.remoteEnterpriseTopicConnector.start();
                this.remoteEnterpriseTopicConnector.registerListener(listener, this.repositoryName);
            }
            catch (ConnectionCheckedException | ConnectorCheckedException | RepositoryErrorException error) {
                throw error;
            }
            catch (Exception error) {
                throw new RepositoryErrorException(OMRSErrorCode.REMOTE_REPOSITORY_ERROR.getMessageDefinition(new String[]{"registerListener", this.repositoryName, error.getClass().getSimpleName(), error.getMessage()}), this.getClass().getName(), "registerListener", error);
            }
        }
    }

    public void disconnectFromEnterpriseTopic() throws ConnectorCheckedException {
        if (this.remoteEnterpriseTopicConnector != null) {
            this.remoteEnterpriseTopicConnector.disconnect();
        }
    }
}

