/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.clients;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.restclients.RESTClientConnector;
import org.odpi.openmetadata.adapters.connectors.restclients.factory.RESTClientFactory;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLoggingComponent;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDescription;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.HistorySequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceGraph;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchClassifications;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefGallery;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.HomeEntityException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.HomeRelationshipException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidEntityException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidRelationshipException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidTypeDefException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PatchErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.StatusNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefInUseException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.rest.properties.AttributeTypeDefListResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.AttributeTypeDefResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.BooleanResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.ClassificationListResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.ClassificationProxyRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.ClassificationRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.ClassificationResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.ClassificationWithEntityRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.EntityCreateRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.EntityDetailResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.EntityFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.EntityHistoricalFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.EntityListResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.EntityNeighborhoodFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.EntityNeighborhoodHistoricalFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.EntityPropertyFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.EntityPropertyHistoricalFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.EntitySummaryResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.HistoryRangeRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.HistoryRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.InstanceFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.InstanceGraphRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.InstanceGraphResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.InstanceHistoricalFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.InstancePropertiesRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.MetadataCollectionIdResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.OMRSAPIFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.OMRSAPIHistoricalFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.OMRSAPIRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.OMRSAPIResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.PropertyMatchFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.PropertyMatchHistoricalFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.ProxyClassificationRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.RelatedEntitiesFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.RelatedEntitiesHistoricalFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.RelationshipCreateRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.RelationshipListResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.RelationshipResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.TypeDefChangeRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.TypeDefDeleteRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.TypeDefGalleryResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.TypeDefListResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.TypeDefReIdentifyRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.TypeDefResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.TypeDefValidationForRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.TypeLimitedFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.TypeLimitedHistoricalFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.VoidResponse;

public abstract class MetadataCollectionServicesClient
implements AuditLoggingComponent {
    private static final String rootServiceNameInURL = "/open-metadata/repository-services";
    private static final String userIdInURL = "/users/{0}";
    private final String localServerUserId;
    private final String localServerPassword;
    protected String restURLRoot;
    private final String serviceURLMarker;
    protected RESTClientConnector restClient;
    protected String repositoryName;
    protected InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    protected AuditLog auditLog = null;

    MetadataCollectionServicesClient(String repositoryName, String restURLRoot, String serviceURLMarker) throws InvalidParameterException {
        this.localServerUserId = null;
        this.localServerPassword = null;
        String methodName = "Constructor (no security)";
        try {
            this.invalidParameterHandler.validateOMAGServerPlatformURL(restURLRoot, repositoryName, "Constructor (no security)");
        }
        catch (org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException error) {
            throw new InvalidParameterException(error.getReportedHTTPCode(), error.getReportingClassName(), error.getReportingActionDescription(), error.getReportedErrorMessage(), error.getReportedErrorMessageId(), error.getReportedErrorMessageParameters(), error.getReportedSystemAction(), error.getReportedUserAction(), ((Object)((Object)error)).getClass().getName(), error.getParameterName(), error.getRelatedProperties());
        }
        this.repositoryName = repositoryName;
        this.restURLRoot = restURLRoot;
        this.serviceURLMarker = serviceURLMarker;
        this.restClient = this.getRESTClientConnector(repositoryName, restURLRoot, null, null);
        this.repositoryName = repositoryName;
    }

    MetadataCollectionServicesClient(String repositoryName, String restURLRoot, String serviceURLMarker, String userId, String password) throws InvalidParameterException {
        this.localServerUserId = null;
        this.localServerPassword = null;
        String methodName = "Constructor (with security)";
        try {
            this.invalidParameterHandler.validateOMAGServerPlatformURL(restURLRoot, repositoryName, "Constructor (with security)");
        }
        catch (org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException error) {
            throw new InvalidParameterException(error.getReportedHTTPCode(), error.getReportingClassName(), error.getReportingActionDescription(), error.getReportedErrorMessage(), error.getReportedErrorMessageId(), error.getReportedErrorMessageParameters(), error.getReportedSystemAction(), error.getReportedUserAction(), ((Object)((Object)error)).getClass().getName(), error.getParameterName(), error.getRelatedProperties());
        }
        this.repositoryName = repositoryName;
        this.restURLRoot = restURLRoot;
        this.serviceURLMarker = serviceURLMarker;
        this.restClient = this.getRESTClientConnector(repositoryName, restURLRoot, userId, password);
    }

    public void setAuditLog(AuditLog auditLog) {
        this.auditLog = auditLog;
    }

    public ComponentDescription getConnectorComponentDescription() {
        if (this.auditLog != null && this.auditLog.getReport() != null) {
            return this.auditLog.getReport().getReportingComponent();
        }
        return null;
    }

    @Deprecated
    public String getMetadataCollectionId() throws RepositoryErrorException {
        MetadataCollectionIdResponse restResult;
        String methodName = "getMetadataCollectionId";
        String operationSpecificURL = "metadata-collection-id";
        try {
            restResult = (MetadataCollectionIdResponse)this.restClient.callGetRESTCall("getMetadataCollectionId", MetadataCollectionIdResponse.class, this.restURLRoot + rootServiceNameInURL + this.serviceURLMarker + "metadata-collection-id", new Object[0]);
        }
        catch (Exception error) {
            throw new RepositoryErrorException(OMRSErrorCode.REMOTE_REPOSITORY_ERROR.getMessageDefinition(new String[]{"getMetadataCollectionId", this.repositoryName, error.getClass().getSimpleName(), error.getMessage()}), this.getClass().getName(), "getMetadataCollectionId", error);
        }
        this.detectAndThrowRepositoryErrorException("getMetadataCollectionId", (OMRSAPIResponse)restResult);
        return restResult.getMetadataCollectionId();
    }

    public String getMetadataCollectionId(String userId) throws RepositoryErrorException {
        MetadataCollectionIdResponse restResult;
        String methodName = "getMetadataCollectionId";
        String operationSpecificURL = "metadata-collection-id";
        try {
            restResult = (MetadataCollectionIdResponse)this.restClient.callGetRESTCall("getMetadataCollectionId", MetadataCollectionIdResponse.class, this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "metadata-collection-id", new Object[]{userId});
        }
        catch (Exception error) {
            throw new RepositoryErrorException(OMRSErrorCode.REMOTE_REPOSITORY_ERROR.getMessageDefinition(new String[]{"getMetadataCollectionId", this.repositoryName, error.getClass().getSimpleName(), error.getMessage()}), this.getClass().getName(), "getMetadataCollectionId", error);
        }
        this.detectAndThrowRepositoryErrorException("getMetadataCollectionId", (OMRSAPIResponse)restResult);
        if (restResult.getMetadataCollectionId() == null) {
            throw new RepositoryErrorException(OMRSErrorCode.NULL_METADATA_COLLECTION_ID_FROM_REMOTE.getMessageDefinition(new String[]{this.repositoryName}), this.getClass().getName(), "getMetadataCollectionId");
        }
        return restResult.getMetadataCollectionId();
    }

    public TypeDefGallery getAllTypes(String userId) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "getAllTypes";
        String operationSpecificURL = "types/all";
        TypeDefGalleryResponse restResult = this.callTypeDefGalleryGetRESTCall("getAllTypes", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "types/all", userId);
        this.detectAndThrowInvalidParameterException("getAllTypes", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("getAllTypes", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("getAllTypes", (OMRSAPIResponse)restResult);
        return this.getTypeDefGalleryFromRESTResult(restResult);
    }

    public TypeDefGallery findTypesByName(String userId, String name) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "findTypesByName";
        String operationSpecificURL = "types/by-name?name={1}";
        TypeDefGalleryResponse restResult = this.callTypeDefGalleryGetRESTCall("findTypesByName", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "types/by-name?name={1}", userId, name);
        this.detectAndThrowInvalidParameterException("findTypesByName", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("findTypesByName", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("findTypesByName", (OMRSAPIResponse)restResult);
        return this.getTypeDefGalleryFromRESTResult(restResult);
    }

    public List<TypeDef> findTypeDefsByCategory(String userId, TypeDefCategory category) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "findTypeDefsByCategory";
        String operationSpecificURL = "types/typedefs/by-category";
        TypeDefListResponse restResult = this.callTypeDefListPostRESTCall("findTypeDefsByCategory", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "types/typedefs/by-category", category, userId);
        this.detectAndThrowInvalidParameterException("findTypeDefsByCategory", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("findTypeDefsByCategory", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("findTypeDefsByCategory", (OMRSAPIResponse)restResult);
        return restResult.getTypeDefs();
    }

    public List<AttributeTypeDef> findAttributeTypeDefsByCategory(String userId, AttributeTypeDefCategory category) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "findAttributeTypeDefsByCategory";
        String operationSpecificURL = "types/attribute-typedefs/by-category";
        AttributeTypeDefListResponse restResult = this.callAttributeTypeDefListPostRESTCall("findAttributeTypeDefsByCategory", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "types/attribute-typedefs/by-category", category, userId);
        this.detectAndThrowInvalidParameterException("findAttributeTypeDefsByCategory", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("findAttributeTypeDefsByCategory", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("findAttributeTypeDefsByCategory", (OMRSAPIResponse)restResult);
        return restResult.getAttributeTypeDefs();
    }

    public List<TypeDef> findTypeDefsByProperty(String userId, TypeDefProperties matchCriteria) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "findTypeDefsByProperty";
        String operationSpecificURL = "types/typedefs/by-property";
        TypeDefListResponse restResult = this.callTypeDefListGetRESTCall("findTypeDefsByProperty", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "types/typedefs/by-property", userId, matchCriteria);
        this.detectAndThrowInvalidParameterException("findTypeDefsByProperty", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("findTypeDefsByProperty", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("findTypeDefsByProperty", (OMRSAPIResponse)restResult);
        return restResult.getTypeDefs();
    }

    public List<TypeDef> findTypesByExternalID(String userId, String standard, String organization, String identifier) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "findTypesByExternalID";
        String operationSpecificURL = "types/typedefs/by-external-id?standard={1}&organization={2}&identifier={3}";
        TypeDefListResponse restResult = this.callTypeDefListGetRESTCall("findTypesByExternalID", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "types/typedefs/by-external-id?standard={1}&organization={2}&identifier={3}", userId, standard, organization, identifier);
        this.detectAndThrowInvalidParameterException("findTypesByExternalID", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("findTypesByExternalID", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("findTypesByExternalID", (OMRSAPIResponse)restResult);
        return restResult.getTypeDefs();
    }

    public List<TypeDef> searchForTypeDefs(String userId, String searchCriteria) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "searchForTypeDefs";
        String operationSpecificURL = "types/typedefs/by-property-value?searchCriteria={1}";
        TypeDefListResponse restResult = this.callTypeDefListGetRESTCall("searchForTypeDefs", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "types/typedefs/by-property-value?searchCriteria={1}", userId, searchCriteria);
        this.detectAndThrowInvalidParameterException("searchForTypeDefs", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("searchForTypeDefs", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("searchForTypeDefs", (OMRSAPIResponse)restResult);
        return restResult.getTypeDefs();
    }

    public TypeDef getTypeDefByGUID(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException {
        String methodName = "getTypeDefByGUID";
        String operationSpecificURL = "types/typedef/{1}";
        TypeDefResponse restResult = this.callTypeDefGetRESTCall("getTypeDefByGUID", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "types/typedef/{1}", userId, guid);
        this.detectAndThrowInvalidParameterException("getTypeDefByGUID", (OMRSAPIResponse)restResult);
        this.detectAndThrowTypeDefNotKnownException("getTypeDefByGUID", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("getTypeDefByGUID", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("getTypeDefByGUID", (OMRSAPIResponse)restResult);
        return restResult.getTypeDef();
    }

    public AttributeTypeDef getAttributeTypeDefByGUID(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException {
        String methodName = "getAttributeTypeDefByGUID";
        String operationSpecificURL = "types/attribute-typedef/{1}";
        AttributeTypeDefResponse restResult = this.callAttributeTypeDefGetRESTCall("getAttributeTypeDefByGUID", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "types/attribute-typedef/{1}", userId, guid);
        this.detectAndThrowInvalidParameterException("getAttributeTypeDefByGUID", (OMRSAPIResponse)restResult);
        this.detectAndThrowTypeDefNotKnownException("getAttributeTypeDefByGUID", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("getAttributeTypeDefByGUID", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("getAttributeTypeDefByGUID", (OMRSAPIResponse)restResult);
        return restResult.getAttributeTypeDef();
    }

    public TypeDef getTypeDefByName(String userId, String name) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException {
        String methodName = "getTypeDefByName";
        String operationSpecificURL = "types/typedef/name/{1}";
        TypeDefResponse restResult = this.callTypeDefGetRESTCall("getTypeDefByName", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "types/typedef/name/{1}", userId, name);
        this.detectAndThrowInvalidParameterException("getTypeDefByName", (OMRSAPIResponse)restResult);
        this.detectAndThrowTypeDefNotKnownException("getTypeDefByName", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("getTypeDefByName", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("getTypeDefByName", (OMRSAPIResponse)restResult);
        return restResult.getTypeDef();
    }

    public AttributeTypeDef getAttributeTypeDefByName(String userId, String name) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException {
        String methodName = "getAttributeTypeDefByName";
        String operationSpecificURL = "types/attribute-typedef/name/{1}";
        AttributeTypeDefResponse restResult = this.callAttributeTypeDefGetRESTCall("getAttributeTypeDefByName", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "types/attribute-typedef/name/{1}", userId, name);
        this.detectAndThrowInvalidParameterException("getAttributeTypeDefByName", (OMRSAPIResponse)restResult);
        this.detectAndThrowTypeDefNotKnownException("getAttributeTypeDefByName", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("getAttributeTypeDefByName", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("getAttributeTypeDefByName", (OMRSAPIResponse)restResult);
        return restResult.getAttributeTypeDef();
    }

    public void addTypeDefGallery(String userId, TypeDefGallery newTypes) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefKnownException, TypeDefConflictException, InvalidTypeDefException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "addTypeDefGallery";
        String operationSpecificURL = "types";
        VoidResponse restResult = this.callVoidPostRESTCall("addTypeDefGallery", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "types", newTypes, userId);
        this.detectAndThrowInvalidParameterException("addTypeDefGallery", (OMRSAPIResponse)restResult);
        this.detectAndThrowTypeDefNotSupportedException("addTypeDefGallery", (OMRSAPIResponse)restResult);
        this.detectAndThrowFunctionNotSupportedException("addTypeDefGallery", (OMRSAPIResponse)restResult);
        this.detectAndThrowTypeDefKnownException("addTypeDefGallery", (OMRSAPIResponse)restResult);
        this.detectAndThrowTypeDefConflictException("addTypeDefGallery", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidTypeDefException("addTypeDefGallery", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("addTypeDefGallery", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("addTypeDefGallery", (OMRSAPIResponse)restResult);
    }

    public void addTypeDef(String userId, TypeDef newTypeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefKnownException, TypeDefConflictException, InvalidTypeDefException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "addTypeDef";
        String operationSpecificURL = "types/typedef";
        VoidResponse restResult = this.callVoidPostRESTCall("addTypeDef", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "types/typedef", newTypeDef, userId);
        this.detectAndThrowInvalidParameterException("addTypeDef", (OMRSAPIResponse)restResult);
        this.detectAndThrowTypeDefNotSupportedException("addTypeDef", (OMRSAPIResponse)restResult);
        this.detectAndThrowTypeDefKnownException("addTypeDef", (OMRSAPIResponse)restResult);
        this.detectAndThrowTypeDefConflictException("addTypeDef", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidTypeDefException("addTypeDef", (OMRSAPIResponse)restResult);
        this.detectAndThrowFunctionNotSupportedException("addTypeDef", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("addTypeDef", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("addTypeDef", (OMRSAPIResponse)restResult);
    }

    public void addAttributeTypeDef(String userId, AttributeTypeDef newAttributeTypeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefKnownException, TypeDefConflictException, InvalidTypeDefException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "addAttributeTypeDef";
        String operationSpecificURL = "types/attribute-typedef";
        VoidResponse restResult = this.callVoidPostRESTCall("addAttributeTypeDef", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "types/attribute-typedef", newAttributeTypeDef, userId);
        this.detectAndThrowInvalidParameterException("addAttributeTypeDef", (OMRSAPIResponse)restResult);
        this.detectAndThrowTypeDefNotSupportedException("addAttributeTypeDef", (OMRSAPIResponse)restResult);
        this.detectAndThrowTypeDefKnownException("addAttributeTypeDef", (OMRSAPIResponse)restResult);
        this.detectAndThrowTypeDefConflictException("addAttributeTypeDef", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidTypeDefException("addAttributeTypeDef", (OMRSAPIResponse)restResult);
        this.detectAndThrowFunctionNotSupportedException("addAttributeTypeDef", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("addAttributeTypeDef", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("addAttributeTypeDef", (OMRSAPIResponse)restResult);
    }

    public boolean verifyTypeDef(String userId, TypeDef typeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefConflictException, InvalidTypeDefException, UserNotAuthorizedException {
        String methodName = "verifyTypeDef";
        String operationSpecificURL = "types/typedef/compatibility";
        BooleanResponse restResult = this.callBooleanPostRESTCall("verifyTypeDef", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "types/typedef/compatibility", typeDef, userId);
        this.detectAndThrowInvalidParameterException("verifyTypeDef", (OMRSAPIResponse)restResult);
        this.detectAndThrowTypeDefNotSupportedException("verifyTypeDef", (OMRSAPIResponse)restResult);
        this.detectAndThrowTypeDefConflictException("verifyTypeDef", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidTypeDefException("verifyTypeDef", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("verifyTypeDef", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("verifyTypeDef", (OMRSAPIResponse)restResult);
        return restResult.isFlag();
    }

    public boolean verifyAttributeTypeDef(String userId, AttributeTypeDef attributeTypeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefConflictException, InvalidTypeDefException, UserNotAuthorizedException {
        String methodName = "verifyAttributeTypeDef";
        String operationSpecificURL = "types/attribute-typedef/compatibility";
        BooleanResponse restResult = this.callBooleanPostRESTCall("verifyAttributeTypeDef", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "types/attribute-typedef/compatibility", attributeTypeDef, userId);
        this.detectAndThrowInvalidParameterException("verifyAttributeTypeDef", (OMRSAPIResponse)restResult);
        this.detectAndThrowTypeDefNotSupportedException("verifyAttributeTypeDef", (OMRSAPIResponse)restResult);
        this.detectAndThrowTypeDefConflictException("verifyAttributeTypeDef", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidTypeDefException("verifyAttributeTypeDef", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("verifyAttributeTypeDef", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("verifyAttributeTypeDef", (OMRSAPIResponse)restResult);
        return restResult.isFlag();
    }

    public TypeDef updateTypeDef(String userId, TypeDefPatch typeDefPatch) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, PatchErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "updateTypeDef";
        String operationSpecificURL = "types/typedef/update";
        TypeDefResponse restResult = this.callTypeDefPostRESTCall("updateTypeDef", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "types/typedef/update", typeDefPatch, userId);
        this.detectAndThrowInvalidParameterException("updateTypeDef", (OMRSAPIResponse)restResult);
        this.detectAndThrowTypeDefNotKnownException("updateTypeDef", (OMRSAPIResponse)restResult);
        this.detectAndThrowPatchErrorException("updateTypeDef", (OMRSAPIResponse)restResult);
        this.detectAndThrowFunctionNotSupportedException("updateTypeDef", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("updateTypeDef", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("updateTypeDef", (OMRSAPIResponse)restResult);
        return restResult.getTypeDef();
    }

    public void deleteTypeDef(String userId, String obsoleteTypeDefGUID, String obsoleteTypeDefName) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, TypeDefInUseException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "deleteTypeDef";
        String operationSpecificURL = "types/typedef/{1}/delete";
        TypeDefDeleteRequest requestBody = new TypeDefDeleteRequest();
        requestBody.setObsoleteTypeDefName(obsoleteTypeDefName);
        VoidResponse restResult = this.callVoidPostRESTCall("deleteTypeDef", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "types/typedef/{1}/delete", requestBody, userId, obsoleteTypeDefGUID);
        this.detectAndThrowInvalidParameterException("deleteTypeDef", (OMRSAPIResponse)restResult);
        this.detectAndThrowTypeDefNotKnownException("deleteTypeDef", (OMRSAPIResponse)restResult);
        this.detectAndThrowTypeDefInUseException("deleteTypeDef", (OMRSAPIResponse)restResult);
        this.detectAndThrowFunctionNotSupportedException("deleteTypeDef", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("deleteTypeDef", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("deleteTypeDef", (OMRSAPIResponse)restResult);
    }

    public void deleteAttributeTypeDef(String userId, String obsoleteTypeDefGUID, String obsoleteTypeDefName) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, TypeDefInUseException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "deleteAttributeTypeDef";
        String operationSpecificURL = "types/attribute-typedef/{1}/delete";
        TypeDefDeleteRequest requestBody = new TypeDefDeleteRequest();
        requestBody.setObsoleteTypeDefName(obsoleteTypeDefName);
        VoidResponse restResult = this.callVoidPostRESTCall("deleteAttributeTypeDef", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "types/attribute-typedef/{1}/delete", requestBody, userId, obsoleteTypeDefGUID);
        this.detectAndThrowInvalidParameterException("deleteAttributeTypeDef", (OMRSAPIResponse)restResult);
        this.detectAndThrowTypeDefNotKnownException("deleteAttributeTypeDef", (OMRSAPIResponse)restResult);
        this.detectAndThrowTypeDefInUseException("deleteAttributeTypeDef", (OMRSAPIResponse)restResult);
        this.detectAndThrowFunctionNotSupportedException("deleteAttributeTypeDef", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("deleteAttributeTypeDef", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("deleteAttributeTypeDef", (OMRSAPIResponse)restResult);
    }

    public TypeDef reIdentifyTypeDef(String userId, String originalTypeDefGUID, String originalTypeDefName, String newTypeDefGUID, String newTypeDefName) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "reIdentifyTypeDef";
        String operationSpecificURL = "types/typedef/{1}/identifier";
        TypeDefReIdentifyRequest requestBody = new TypeDefReIdentifyRequest();
        requestBody.setOriginalTypeDefName(originalTypeDefName);
        requestBody.setNewTypeDefGUID(newTypeDefGUID);
        requestBody.setNewTypeDefName(newTypeDefName);
        TypeDefResponse restResult = this.callTypeDefPostRESTCall("reIdentifyTypeDef", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "types/typedef/{1}/identifier", requestBody, userId, originalTypeDefGUID);
        this.detectAndThrowInvalidParameterException("reIdentifyTypeDef", (OMRSAPIResponse)restResult);
        this.detectAndThrowTypeDefNotKnownException("reIdentifyTypeDef", (OMRSAPIResponse)restResult);
        this.detectAndThrowFunctionNotSupportedException("reIdentifyTypeDef", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("reIdentifyTypeDef", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("reIdentifyTypeDef", (OMRSAPIResponse)restResult);
        return restResult.getTypeDef();
    }

    public AttributeTypeDef reIdentifyAttributeTypeDef(String userId, String originalAttributeTypeDefGUID, String originalAttributeTypeDefName, String newAttributeTypeDefGUID, String newAttributeTypeDefName) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "reIdentifyAttributeTypeDef";
        String operationSpecificURL = "types/attribute-typedef/{1}/identifier";
        TypeDefReIdentifyRequest requestBody = new TypeDefReIdentifyRequest();
        requestBody.setOriginalTypeDefName(originalAttributeTypeDefName);
        requestBody.setNewTypeDefGUID(newAttributeTypeDefGUID);
        requestBody.setNewTypeDefName(newAttributeTypeDefName);
        AttributeTypeDefResponse restResult = this.callAttributeTypeDefPostRESTCall("reIdentifyAttributeTypeDef", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "types/attribute-typedef/{1}/identifier", requestBody, userId, originalAttributeTypeDefGUID);
        this.detectAndThrowInvalidParameterException("reIdentifyAttributeTypeDef", (OMRSAPIResponse)restResult);
        this.detectAndThrowFunctionNotSupportedException("reIdentifyAttributeTypeDef", (OMRSAPIResponse)restResult);
        this.detectAndThrowTypeDefNotKnownException("reIdentifyAttributeTypeDef", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("reIdentifyAttributeTypeDef", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("reIdentifyAttributeTypeDef", (OMRSAPIResponse)restResult);
        return restResult.getAttributeTypeDef();
    }

    public EntityDetail isEntityKnown(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "isEntityKnown";
        String operationSpecificURL = "instances/entity/{1}/existence";
        EntityDetailResponse restResult = this.callEntityDetailGetRESTCall("isEntityKnown", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/entity/{1}/existence", userId, guid);
        this.detectAndThrowInvalidParameterException("isEntityKnown", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("isEntityKnown", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("isEntityKnown", (OMRSAPIResponse)restResult);
        return restResult.getEntity();
    }

    public EntitySummary getEntitySummary(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, UserNotAuthorizedException {
        String methodName = "getEntitySummary";
        String operationSpecificURL = "instances/entity/{1}/summary";
        EntitySummaryResponse restResult = this.callEntitySummaryGetRESTCall("getEntitySummary", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/entity/{1}/summary", userId, guid);
        this.detectAndThrowInvalidParameterException("getEntitySummary", (OMRSAPIResponse)restResult);
        this.detectAndThrowEntityNotKnownException("getEntitySummary", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("getEntitySummary", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("getEntitySummary", (OMRSAPIResponse)restResult);
        return restResult.getEntity();
    }

    public EntityDetail getEntityDetail(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityProxyOnlyException, UserNotAuthorizedException {
        String methodName = "getEntityDetail";
        String operationSpecificURL = "instances/entity/{1}";
        EntityDetailResponse restResult = this.callEntityDetailGetRESTCall("getEntityDetail", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/entity/{1}", userId, guid);
        this.detectAndThrowInvalidParameterException("getEntityDetail", (OMRSAPIResponse)restResult);
        this.detectAndThrowEntityNotKnownException("getEntityDetail", (OMRSAPIResponse)restResult);
        this.detectAndThrowEntityProxyOnlyException("getEntityDetail", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("getEntityDetail", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("getEntityDetail", (OMRSAPIResponse)restResult);
        return restResult.getEntity();
    }

    public EntityDetail getEntityDetail(String userId, String guid, Date asOfTime) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityProxyOnlyException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getEntityDetail";
        String operationSpecificURL = "instances/entity/{1}/history";
        HistoryRequest requestBody = new HistoryRequest();
        requestBody.setAsOfTime(asOfTime);
        EntityDetailResponse restResult = this.callEntityDetailPostRESTCall("getEntityDetail", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/entity/{1}/history", requestBody, userId, guid);
        this.detectAndThrowInvalidParameterException("getEntityDetail", (OMRSAPIResponse)restResult);
        this.detectAndThrowFunctionNotSupportedException("getEntityDetail", (OMRSAPIResponse)restResult);
        this.detectAndThrowEntityNotKnownException("getEntityDetail", (OMRSAPIResponse)restResult);
        this.detectAndThrowEntityProxyOnlyException("getEntityDetail", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("getEntityDetail", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("getEntityDetail", (OMRSAPIResponse)restResult);
        return restResult.getEntity();
    }

    public List<EntityDetail> getEntityDetailHistory(String userId, String guid, Date fromTime, Date toTime, int startFromElement, int pageSize, HistorySequencingOrder sequencingOrder) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityProxyOnlyException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getEntityDetailHistory";
        String operationSpecificURL = "instances/entity/{1}/history/all";
        HistoryRangeRequest requestBody = new HistoryRangeRequest();
        requestBody.setFromTime(fromTime);
        requestBody.setToTime(toTime);
        requestBody.setOffset(startFromElement);
        requestBody.setPageSize(pageSize);
        requestBody.setSequencingOrder(sequencingOrder);
        EntityListResponse restResult = this.callEntityListPostRESTCall("getEntityDetailHistory", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/entity/{1}/history/all", requestBody, userId, guid);
        this.detectAndThrowInvalidParameterException("getEntityDetailHistory", (OMRSAPIResponse)restResult);
        this.detectAndThrowFunctionNotSupportedException("getEntityDetailHistory", (OMRSAPIResponse)restResult);
        this.detectAndThrowEntityNotKnownException("getEntityDetailHistory", (OMRSAPIResponse)restResult);
        this.detectAndThrowEntityProxyOnlyException("getEntityDetailHistory", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("getEntityDetailHistory", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("getEntityDetailHistory", (OMRSAPIResponse)restResult);
        return restResult.getEntities();
    }

    public List<Relationship> getRelationshipsForEntity(String userId, String entityGUID, String relationshipTypeGUID, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        RelationshipListResponse restResult;
        String methodName = "getRelationshipsForEntity";
        if (asOfTime == null) {
            String operationSpecificURL = "instances/entity/{1}/relationships";
            TypeLimitedFindRequest findRequestParameters = new TypeLimitedFindRequest();
            findRequestParameters.setTypeGUID(relationshipTypeGUID);
            findRequestParameters.setOffset(fromRelationshipElement);
            findRequestParameters.setLimitResultsByStatus(limitResultsByStatus);
            findRequestParameters.setSequencingOrder(sequencingOrder);
            findRequestParameters.setSequencingProperty(sequencingProperty);
            findRequestParameters.setPageSize(pageSize);
            restResult = this.callRelationshipListPostRESTCall("getRelationshipsForEntity", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/entity/{1}/relationships", findRequestParameters, userId, entityGUID);
        } else {
            String operationSpecificURL = "instances/entity/{1}/relationships/history";
            TypeLimitedHistoricalFindRequest findRequestParameters = new TypeLimitedHistoricalFindRequest();
            findRequestParameters.setTypeGUID(relationshipTypeGUID);
            findRequestParameters.setAsOfTime(asOfTime);
            findRequestParameters.setOffset(fromRelationshipElement);
            findRequestParameters.setLimitResultsByStatus(limitResultsByStatus);
            findRequestParameters.setSequencingOrder(sequencingOrder);
            findRequestParameters.setSequencingProperty(sequencingProperty);
            findRequestParameters.setPageSize(pageSize);
            restResult = this.callRelationshipListPostRESTCall("getRelationshipsForEntity", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/entity/{1}/relationships/history", findRequestParameters, userId, entityGUID);
        }
        this.detectAndThrowInvalidParameterException("getRelationshipsForEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowEntityNotKnownException("getRelationshipsForEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowFunctionNotSupportedException("getRelationshipsForEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowPropertyErrorException("getRelationshipsForEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowTypeErrorException("getRelationshipsForEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowPagingErrorException("getRelationshipsForEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("getRelationshipsForEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("getRelationshipsForEntity", (OMRSAPIResponse)restResult);
        return restResult.getRelationships();
    }

    public List<EntityDetail> findEntities(String userId, String entityTypeGUID, List<String> entitySubtypeGUIDs, SearchProperties matchProperties, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, SearchClassifications matchClassifications, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        EntityListResponse restResult;
        String methodName = "findEntities";
        if (asOfTime == null) {
            String operationSpecificURL = "instances/entities";
            EntityFindRequest findRequestParameters = new EntityFindRequest();
            findRequestParameters.setTypeGUID(entityTypeGUID);
            findRequestParameters.setSubtypeGUIDs(entitySubtypeGUIDs);
            findRequestParameters.setMatchProperties(matchProperties);
            findRequestParameters.setOffset(fromEntityElement);
            findRequestParameters.setLimitResultsByStatus(limitResultsByStatus);
            findRequestParameters.setMatchClassifications(matchClassifications);
            findRequestParameters.setSequencingOrder(sequencingOrder);
            findRequestParameters.setSequencingProperty(sequencingProperty);
            findRequestParameters.setPageSize(pageSize);
            restResult = this.callEntityListPostRESTCall("findEntities", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/entities", findRequestParameters, userId);
        } else {
            String operationSpecificURL = "instances/entities/history";
            EntityHistoricalFindRequest findRequestParameters = new EntityHistoricalFindRequest();
            findRequestParameters.setTypeGUID(entityTypeGUID);
            findRequestParameters.setSubtypeGUIDs(entitySubtypeGUIDs);
            findRequestParameters.setMatchProperties(matchProperties);
            findRequestParameters.setAsOfTime(asOfTime);
            findRequestParameters.setOffset(fromEntityElement);
            findRequestParameters.setLimitResultsByStatus(limitResultsByStatus);
            findRequestParameters.setMatchClassifications(matchClassifications);
            findRequestParameters.setSequencingOrder(sequencingOrder);
            findRequestParameters.setSequencingProperty(sequencingProperty);
            findRequestParameters.setPageSize(pageSize);
            restResult = this.callEntityListPostRESTCall("findEntities", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/entities/history", findRequestParameters, userId);
        }
        this.detectAndThrowFunctionNotSupportedException("findEntities", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidParameterException("findEntities", (OMRSAPIResponse)restResult);
        this.detectAndThrowTypeErrorException("findEntities", (OMRSAPIResponse)restResult);
        this.detectAndThrowPropertyErrorException("findEntities", (OMRSAPIResponse)restResult);
        this.detectAndThrowPagingErrorException("findEntities", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("findEntities", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("findEntities", (OMRSAPIResponse)restResult);
        return restResult.getEntities();
    }

    public List<EntityDetail> findEntitiesByProperty(String userId, String entityTypeGUID, InstanceProperties matchProperties, MatchCriteria matchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        EntityListResponse restResult;
        String methodName = "findEntitiesByProperty";
        if (asOfTime == null) {
            String operationSpecificURL = "instances/entities/by-property";
            EntityPropertyFindRequest findRequestParameters = new EntityPropertyFindRequest();
            findRequestParameters.setTypeGUID(entityTypeGUID);
            findRequestParameters.setMatchProperties(matchProperties);
            findRequestParameters.setMatchCriteria(matchCriteria);
            findRequestParameters.setOffset(fromEntityElement);
            findRequestParameters.setLimitResultsByStatus(limitResultsByStatus);
            findRequestParameters.setLimitResultsByClassification(limitResultsByClassification);
            findRequestParameters.setSequencingOrder(sequencingOrder);
            findRequestParameters.setSequencingProperty(sequencingProperty);
            findRequestParameters.setPageSize(pageSize);
            restResult = this.callEntityListPostRESTCall("findEntitiesByProperty", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/entities/by-property", findRequestParameters, userId);
        } else {
            String operationSpecificURL = "instances/entities/by-property/history";
            EntityPropertyHistoricalFindRequest findRequestParameters = new EntityPropertyHistoricalFindRequest();
            findRequestParameters.setTypeGUID(entityTypeGUID);
            findRequestParameters.setMatchProperties(matchProperties);
            findRequestParameters.setMatchCriteria(matchCriteria);
            findRequestParameters.setAsOfTime(asOfTime);
            findRequestParameters.setOffset(fromEntityElement);
            findRequestParameters.setLimitResultsByStatus(limitResultsByStatus);
            findRequestParameters.setLimitResultsByClassification(limitResultsByClassification);
            findRequestParameters.setSequencingOrder(sequencingOrder);
            findRequestParameters.setSequencingProperty(sequencingProperty);
            findRequestParameters.setPageSize(pageSize);
            restResult = this.callEntityListPostRESTCall("findEntitiesByProperty", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/entities/by-property/history", findRequestParameters, userId);
        }
        this.detectAndThrowFunctionNotSupportedException("findEntitiesByProperty", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidParameterException("findEntitiesByProperty", (OMRSAPIResponse)restResult);
        this.detectAndThrowTypeErrorException("findEntitiesByProperty", (OMRSAPIResponse)restResult);
        this.detectAndThrowPropertyErrorException("findEntitiesByProperty", (OMRSAPIResponse)restResult);
        this.detectAndThrowPagingErrorException("findEntitiesByProperty", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("findEntitiesByProperty", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("findEntitiesByProperty", (OMRSAPIResponse)restResult);
        return restResult.getEntities();
    }

    public List<EntityDetail> findEntitiesByClassification(String userId, String entityTypeGUID, String classificationName, InstanceProperties matchClassificationProperties, MatchCriteria matchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, ClassificationErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        EntityListResponse restResult;
        String methodName = "findEntitiesByClassification";
        if (asOfTime == null) {
            String operationSpecificURL = "instances/entities/by-classification/{1}";
            PropertyMatchFindRequest findRequestParameters = new PropertyMatchFindRequest();
            findRequestParameters.setTypeGUID(entityTypeGUID);
            findRequestParameters.setMatchProperties(matchClassificationProperties);
            findRequestParameters.setMatchCriteria(matchCriteria);
            findRequestParameters.setOffset(fromEntityElement);
            findRequestParameters.setLimitResultsByStatus(limitResultsByStatus);
            findRequestParameters.setSequencingOrder(sequencingOrder);
            findRequestParameters.setSequencingProperty(sequencingProperty);
            findRequestParameters.setPageSize(pageSize);
            restResult = this.callEntityListPostRESTCall("findEntitiesByClassification", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/entities/by-classification/{1}", findRequestParameters, userId, classificationName);
        } else {
            String operationSpecificURL = "instances/entities/by-classification/{1}/history";
            PropertyMatchHistoricalFindRequest findRequestParameters = new PropertyMatchHistoricalFindRequest();
            findRequestParameters.setTypeGUID(entityTypeGUID);
            findRequestParameters.setMatchProperties(matchClassificationProperties);
            findRequestParameters.setMatchCriteria(matchCriteria);
            findRequestParameters.setAsOfTime(asOfTime);
            findRequestParameters.setOffset(fromEntityElement);
            findRequestParameters.setLimitResultsByStatus(limitResultsByStatus);
            findRequestParameters.setSequencingOrder(sequencingOrder);
            findRequestParameters.setSequencingProperty(sequencingProperty);
            findRequestParameters.setPageSize(pageSize);
            restResult = this.callEntityListPostRESTCall("findEntitiesByClassification", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/entities/by-classification/{1}/history", findRequestParameters, userId, classificationName);
        }
        this.detectAndThrowFunctionNotSupportedException("findEntitiesByClassification", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidParameterException("findEntitiesByClassification", (OMRSAPIResponse)restResult);
        this.detectAndThrowTypeErrorException("findEntitiesByClassification", (OMRSAPIResponse)restResult);
        this.detectAndThrowClassificationErrorException("findEntitiesByClassification", (OMRSAPIResponse)restResult);
        this.detectAndThrowPropertyErrorException("findEntitiesByClassification", (OMRSAPIResponse)restResult);
        this.detectAndThrowPagingErrorException("findEntitiesByClassification", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("findEntitiesByClassification", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("findEntitiesByClassification", (OMRSAPIResponse)restResult);
        return restResult.getEntities();
    }

    public List<EntityDetail> findEntitiesByPropertyValue(String userId, String entityTypeGUID, String searchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        EntityListResponse restResult;
        String methodName = "findEntitiesByPropertyValue";
        if (asOfTime == null) {
            String operationSpecificURL = "instances/entities/by-property-value?searchCriteria={1}";
            EntityPropertyFindRequest findRequestParameters = new EntityPropertyFindRequest();
            findRequestParameters.setTypeGUID(entityTypeGUID);
            findRequestParameters.setOffset(fromEntityElement);
            findRequestParameters.setLimitResultsByStatus(limitResultsByStatus);
            findRequestParameters.setLimitResultsByClassification(limitResultsByClassification);
            findRequestParameters.setSequencingOrder(sequencingOrder);
            findRequestParameters.setSequencingProperty(sequencingProperty);
            findRequestParameters.setPageSize(pageSize);
            restResult = this.callEntityListPostRESTCall("findEntitiesByPropertyValue", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/entities/by-property-value?searchCriteria={1}", findRequestParameters, userId, searchCriteria);
        } else {
            String operationSpecificURL = "instances/entities/by-property-value/history?searchCriteria={1}";
            EntityPropertyHistoricalFindRequest findRequestParameters = new EntityPropertyHistoricalFindRequest();
            findRequestParameters.setTypeGUID(entityTypeGUID);
            findRequestParameters.setAsOfTime(asOfTime);
            findRequestParameters.setOffset(fromEntityElement);
            findRequestParameters.setLimitResultsByStatus(limitResultsByStatus);
            findRequestParameters.setLimitResultsByClassification(limitResultsByClassification);
            findRequestParameters.setSequencingOrder(sequencingOrder);
            findRequestParameters.setSequencingProperty(sequencingProperty);
            findRequestParameters.setPageSize(pageSize);
            restResult = this.callEntityListPostRESTCall("findEntitiesByPropertyValue", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/entities/by-property-value/history?searchCriteria={1}", findRequestParameters, userId, searchCriteria);
        }
        this.detectAndThrowFunctionNotSupportedException("findEntitiesByPropertyValue", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidParameterException("findEntitiesByPropertyValue", (OMRSAPIResponse)restResult);
        this.detectAndThrowPropertyErrorException("findEntitiesByPropertyValue", (OMRSAPIResponse)restResult);
        this.detectAndThrowTypeErrorException("findEntitiesByPropertyValue", (OMRSAPIResponse)restResult);
        this.detectAndThrowPagingErrorException("findEntitiesByPropertyValue", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("findEntitiesByPropertyValue", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("findEntitiesByPropertyValue", (OMRSAPIResponse)restResult);
        return restResult.getEntities();
    }

    public Relationship isRelationshipKnown(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "isRelationshipKnown";
        String operationSpecificURL = "instances/relationship/{1}/existence";
        RelationshipResponse restResult = this.callRelationshipGetRESTCall("isRelationshipKnown", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/relationship/{1}/existence", userId, guid);
        this.detectAndThrowInvalidParameterException("isRelationshipKnown", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("isRelationshipKnown", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("isRelationshipKnown", (OMRSAPIResponse)restResult);
        return restResult.getRelationship();
    }

    public Relationship getRelationship(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, UserNotAuthorizedException {
        String methodName = "getRelationship";
        String operationSpecificURL = "instances/relationship/{1}";
        RelationshipResponse restResult = this.callRelationshipGetRESTCall("getRelationship", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/relationship/{1}", userId, guid);
        this.detectAndThrowInvalidParameterException("getRelationship", (OMRSAPIResponse)restResult);
        this.detectAndThrowRelationshipNotKnownException("getRelationship", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("getRelationship", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("getRelationship", (OMRSAPIResponse)restResult);
        return restResult.getRelationship();
    }

    public Relationship getRelationship(String userId, String guid, Date asOfTime) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getRelationship";
        String operationSpecificURL = "instances/relationship/{1}/history";
        HistoryRequest requestBody = new HistoryRequest();
        requestBody.setAsOfTime(asOfTime);
        RelationshipResponse restResult = this.callRelationshipPostRESTCall("getRelationship", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/relationship/{1}/history", requestBody, userId, guid);
        this.detectAndThrowFunctionNotSupportedException("getRelationship", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidParameterException("getRelationship", (OMRSAPIResponse)restResult);
        this.detectAndThrowRelationshipNotKnownException("getRelationship", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("getRelationship", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("getRelationship", (OMRSAPIResponse)restResult);
        return restResult.getRelationship();
    }

    public List<Relationship> getRelationshipHistory(String userId, String guid, Date fromTime, Date toTime, int startFromElement, int pageSize, HistorySequencingOrder sequencingOrder) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getRelationshipHistory";
        String operationSpecificURL = "instances/relationship/{1}/history/all";
        HistoryRangeRequest requestBody = new HistoryRangeRequest();
        requestBody.setFromTime(fromTime);
        requestBody.setToTime(toTime);
        requestBody.setOffset(startFromElement);
        requestBody.setPageSize(pageSize);
        requestBody.setSequencingOrder(sequencingOrder);
        RelationshipListResponse restResult = this.callRelationshipListPostRESTCall("getRelationshipHistory", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/relationship/{1}/history/all", requestBody, userId, guid);
        this.detectAndThrowInvalidParameterException("getRelationshipHistory", (OMRSAPIResponse)restResult);
        this.detectAndThrowFunctionNotSupportedException("getRelationshipHistory", (OMRSAPIResponse)restResult);
        this.detectAndThrowRelationshipNotKnownException("getRelationshipHistory", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("getRelationshipHistory", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("getRelationshipHistory", (OMRSAPIResponse)restResult);
        return restResult.getRelationships();
    }

    public List<Relationship> findRelationships(String userId, String relationshipTypeGUID, List<String> relationshipSubtypeGUIDs, SearchProperties matchProperties, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        RelationshipListResponse restResult;
        String methodName = "findRelationships";
        if (asOfTime == null) {
            String operationSpecificURL = "instances/relationships";
            InstanceFindRequest findRequestParameters = new InstanceFindRequest();
            findRequestParameters.setTypeGUID(relationshipTypeGUID);
            findRequestParameters.setSubtypeGUIDs(relationshipSubtypeGUIDs);
            findRequestParameters.setMatchProperties(matchProperties);
            findRequestParameters.setOffset(fromRelationshipElement);
            findRequestParameters.setLimitResultsByStatus(limitResultsByStatus);
            findRequestParameters.setSequencingOrder(sequencingOrder);
            findRequestParameters.setSequencingProperty(sequencingProperty);
            findRequestParameters.setPageSize(pageSize);
            restResult = this.callRelationshipListPostRESTCall("findRelationships", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/relationships", findRequestParameters, userId);
        } else {
            String operationSpecificURL = "instances/relationships/history";
            InstanceHistoricalFindRequest findRequestParameters = new InstanceHistoricalFindRequest();
            findRequestParameters.setTypeGUID(relationshipTypeGUID);
            findRequestParameters.setSubtypeGUIDs(relationshipSubtypeGUIDs);
            findRequestParameters.setMatchProperties(matchProperties);
            findRequestParameters.setAsOfTime(asOfTime);
            findRequestParameters.setOffset(fromRelationshipElement);
            findRequestParameters.setLimitResultsByStatus(limitResultsByStatus);
            findRequestParameters.setSequencingOrder(sequencingOrder);
            findRequestParameters.setSequencingProperty(sequencingProperty);
            findRequestParameters.setPageSize(pageSize);
            restResult = this.callRelationshipListPostRESTCall("findRelationships", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/relationships/history", findRequestParameters, userId);
        }
        this.detectAndThrowFunctionNotSupportedException("findRelationships", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidParameterException("findRelationships", (OMRSAPIResponse)restResult);
        this.detectAndThrowTypeErrorException("findRelationships", (OMRSAPIResponse)restResult);
        this.detectAndThrowPropertyErrorException("findRelationships", (OMRSAPIResponse)restResult);
        this.detectAndThrowPagingErrorException("findRelationships", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("findRelationships", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("findRelationships", (OMRSAPIResponse)restResult);
        return restResult.getRelationships();
    }

    public List<Relationship> findRelationshipsByProperty(String userId, String relationshipTypeGUID, InstanceProperties matchProperties, MatchCriteria matchCriteria, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        RelationshipListResponse restResult;
        String methodName = "findRelationshipsByProperty";
        if (asOfTime == null) {
            String operationSpecificURL = "instances/relationships/by-property";
            PropertyMatchFindRequest findRequestParameters = new PropertyMatchFindRequest();
            findRequestParameters.setTypeGUID(relationshipTypeGUID);
            findRequestParameters.setMatchProperties(matchProperties);
            findRequestParameters.setMatchCriteria(matchCriteria);
            findRequestParameters.setOffset(fromRelationshipElement);
            findRequestParameters.setLimitResultsByStatus(limitResultsByStatus);
            findRequestParameters.setSequencingOrder(sequencingOrder);
            findRequestParameters.setSequencingProperty(sequencingProperty);
            findRequestParameters.setPageSize(pageSize);
            restResult = this.callRelationshipListPostRESTCall("findRelationshipsByProperty", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/relationships/by-property", findRequestParameters, userId);
        } else {
            String operationSpecificURL = "instances/relationships/by-property/history";
            PropertyMatchHistoricalFindRequest findRequestParameters = new PropertyMatchHistoricalFindRequest();
            findRequestParameters.setTypeGUID(relationshipTypeGUID);
            findRequestParameters.setMatchProperties(matchProperties);
            findRequestParameters.setMatchCriteria(matchCriteria);
            findRequestParameters.setAsOfTime(asOfTime);
            findRequestParameters.setOffset(fromRelationshipElement);
            findRequestParameters.setLimitResultsByStatus(limitResultsByStatus);
            findRequestParameters.setSequencingOrder(sequencingOrder);
            findRequestParameters.setSequencingProperty(sequencingProperty);
            findRequestParameters.setPageSize(pageSize);
            restResult = this.callRelationshipListPostRESTCall("findRelationshipsByProperty", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/relationships/by-property/history", findRequestParameters, userId);
        }
        this.detectAndThrowFunctionNotSupportedException("findRelationshipsByProperty", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidParameterException("findRelationshipsByProperty", (OMRSAPIResponse)restResult);
        this.detectAndThrowTypeErrorException("findRelationshipsByProperty", (OMRSAPIResponse)restResult);
        this.detectAndThrowPropertyErrorException("findRelationshipsByProperty", (OMRSAPIResponse)restResult);
        this.detectAndThrowPagingErrorException("findRelationshipsByProperty", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("findRelationshipsByProperty", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("findRelationshipsByProperty", (OMRSAPIResponse)restResult);
        return restResult.getRelationships();
    }

    public List<Relationship> findRelationshipsByPropertyValue(String userId, String relationshipTypeGUID, String searchCriteria, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        RelationshipListResponse restResult;
        String methodName = "findRelationshipsByPropertyValue";
        if (asOfTime == null) {
            String operationSpecificURL = "instances/relationships/by-property-value?searchCriteria={1}";
            TypeLimitedFindRequest findRequestParameters = new TypeLimitedFindRequest();
            findRequestParameters.setTypeGUID(relationshipTypeGUID);
            findRequestParameters.setOffset(fromRelationshipElement);
            findRequestParameters.setLimitResultsByStatus(limitResultsByStatus);
            findRequestParameters.setSequencingOrder(sequencingOrder);
            findRequestParameters.setSequencingProperty(sequencingProperty);
            findRequestParameters.setPageSize(pageSize);
            restResult = this.callRelationshipListPostRESTCall("findRelationshipsByPropertyValue", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/relationships/by-property-value?searchCriteria={1}", findRequestParameters, userId, searchCriteria);
        } else {
            String operationSpecificURL = "instances/relationships/by-property-value/history?searchCriteria={1}";
            TypeLimitedHistoricalFindRequest findRequestParameters = new TypeLimitedHistoricalFindRequest();
            findRequestParameters.setTypeGUID(relationshipTypeGUID);
            findRequestParameters.setAsOfTime(asOfTime);
            findRequestParameters.setOffset(fromRelationshipElement);
            findRequestParameters.setLimitResultsByStatus(limitResultsByStatus);
            findRequestParameters.setSequencingOrder(sequencingOrder);
            findRequestParameters.setSequencingProperty(sequencingProperty);
            findRequestParameters.setPageSize(pageSize);
            restResult = this.callRelationshipListPostRESTCall("findRelationshipsByPropertyValue", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/relationships/by-property-value/history?searchCriteria={1}", findRequestParameters, userId, searchCriteria);
        }
        this.detectAndThrowFunctionNotSupportedException("findRelationshipsByPropertyValue", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidParameterException("findRelationshipsByPropertyValue", (OMRSAPIResponse)restResult);
        this.detectAndThrowPropertyErrorException("findRelationshipsByPropertyValue", (OMRSAPIResponse)restResult);
        this.detectAndThrowTypeErrorException("findRelationshipsByPropertyValue", (OMRSAPIResponse)restResult);
        this.detectAndThrowPagingErrorException("findRelationshipsByPropertyValue", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("findRelationshipsByPropertyValue", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("findRelationshipsByPropertyValue", (OMRSAPIResponse)restResult);
        return restResult.getRelationships();
    }

    public InstanceGraph getLinkingEntities(String userId, String startEntityGUID, String endEntityGUID, List<InstanceStatus> limitResultsByStatus, Date asOfTime) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        InstanceGraphResponse restResult;
        String methodName = "getLinkingEntities";
        if (asOfTime == null) {
            String operationSpecificURL = "instances/entities/from-entity/{1}/by-linkage?endEntityGUID={2}";
            OMRSAPIFindRequest findRequestParameters = new OMRSAPIFindRequest();
            findRequestParameters.setLimitResultsByStatus(limitResultsByStatus);
            restResult = this.callInstanceGraphPostRESTCall("getLinkingEntities", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/entities/from-entity/{1}/by-linkage?endEntityGUID={2}", findRequestParameters, userId, startEntityGUID, endEntityGUID);
        } else {
            String operationSpecificURL = "instances/entities/from-entity/{1}/by-linkage/history?endEntityGUID={2}";
            OMRSAPIHistoricalFindRequest findRequestParameters = new OMRSAPIHistoricalFindRequest();
            findRequestParameters.setLimitResultsByStatus(limitResultsByStatus);
            findRequestParameters.setAsOfTime(asOfTime);
            restResult = this.callInstanceGraphPostRESTCall("getLinkingEntities", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/entities/from-entity/{1}/by-linkage/history?endEntityGUID={2}", findRequestParameters, userId, startEntityGUID, endEntityGUID);
        }
        this.detectAndThrowFunctionNotSupportedException("getLinkingEntities", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidParameterException("getLinkingEntities", (OMRSAPIResponse)restResult);
        this.detectAndThrowEntityNotKnownException("getLinkingEntities", (OMRSAPIResponse)restResult);
        this.detectAndThrowPropertyErrorException("getLinkingEntities", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("getLinkingEntities", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("getLinkingEntities", (OMRSAPIResponse)restResult);
        return this.getInstanceGraphFromRESTResult(restResult);
    }

    public InstanceGraph getEntityNeighborhood(String userId, String entityGUID, List<String> entityTypeGUIDs, List<String> relationshipTypeGUIDs, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, int level) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, EntityNotKnownException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        InstanceGraphResponse restResult;
        String methodName = "getEntityNeighborhood";
        if (asOfTime == null) {
            String operationSpecificURL = "instances/entities/from-entity/{1}/by-neighborhood?level={2}";
            EntityNeighborhoodFindRequest findRequestParameters = new EntityNeighborhoodFindRequest();
            findRequestParameters.setEntityTypeGUIDs(entityTypeGUIDs);
            findRequestParameters.setRelationshipTypeGUIDs(relationshipTypeGUIDs);
            findRequestParameters.setLimitResultsByStatus(limitResultsByStatus);
            findRequestParameters.setLimitResultsByClassification(limitResultsByClassification);
            restResult = this.callInstanceGraphPostRESTCall("getEntityNeighborhood", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/entities/from-entity/{1}/by-neighborhood?level={2}", findRequestParameters, userId, entityGUID, level);
        } else {
            String operationSpecificURL = "instances/entities/from-entity/{1}/by-neighborhood/history?level={2}";
            EntityNeighborhoodHistoricalFindRequest findRequestParameters = new EntityNeighborhoodHistoricalFindRequest();
            findRequestParameters.setEntityTypeGUIDs(entityTypeGUIDs);
            findRequestParameters.setRelationshipTypeGUIDs(relationshipTypeGUIDs);
            findRequestParameters.setAsOfTime(asOfTime);
            findRequestParameters.setLimitResultsByStatus(limitResultsByStatus);
            findRequestParameters.setLimitResultsByClassification(limitResultsByClassification);
            restResult = this.callInstanceGraphPostRESTCall("getEntityNeighborhood", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/entities/from-entity/{1}/by-neighborhood/history?level={2}", findRequestParameters, userId, entityGUID, level);
        }
        this.detectAndThrowFunctionNotSupportedException("getEntityNeighborhood", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidParameterException("getEntityNeighborhood", (OMRSAPIResponse)restResult);
        this.detectAndThrowEntityNotKnownException("getEntityNeighborhood", (OMRSAPIResponse)restResult);
        this.detectAndThrowTypeErrorException("getEntityNeighborhood", (OMRSAPIResponse)restResult);
        this.detectAndThrowPropertyErrorException("getEntityNeighborhood", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("getEntityNeighborhood", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("getEntityNeighborhood", (OMRSAPIResponse)restResult);
        return this.getInstanceGraphFromRESTResult(restResult);
    }

    public List<EntityDetail> getRelatedEntities(String userId, String startEntityGUID, List<String> entityTypeGUIDs, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, EntityNotKnownException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        EntityListResponse restResult;
        String methodName = "getRelatedEntities";
        if (asOfTime == null) {
            String operationSpecificURL = "instances/entities/from-entity/{1}/by-relationship";
            RelatedEntitiesFindRequest findRequestParameters = new RelatedEntitiesFindRequest();
            findRequestParameters.setEntityTypeGUIDs(entityTypeGUIDs);
            findRequestParameters.setOffset(fromEntityElement);
            findRequestParameters.setLimitResultsByStatus(limitResultsByStatus);
            findRequestParameters.setLimitResultsByClassification(limitResultsByClassification);
            findRequestParameters.setSequencingOrder(sequencingOrder);
            findRequestParameters.setSequencingProperty(sequencingProperty);
            findRequestParameters.setPageSize(pageSize);
            restResult = this.callEntityListPostRESTCall("getRelatedEntities", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/entities/from-entity/{1}/by-relationship", findRequestParameters, userId, startEntityGUID);
        } else {
            String operationSpecificURL = "instances/entities/from-entity/{1}/by-relationship";
            RelatedEntitiesHistoricalFindRequest findRequestParameters = new RelatedEntitiesHistoricalFindRequest();
            findRequestParameters.setEntityTypeGUIDs(entityTypeGUIDs);
            findRequestParameters.setAsOfTime(asOfTime);
            findRequestParameters.setOffset(fromEntityElement);
            findRequestParameters.setLimitResultsByStatus(limitResultsByStatus);
            findRequestParameters.setLimitResultsByClassification(limitResultsByClassification);
            findRequestParameters.setSequencingOrder(sequencingOrder);
            findRequestParameters.setSequencingProperty(sequencingProperty);
            findRequestParameters.setPageSize(pageSize);
            restResult = this.callEntityListPostRESTCall("getRelatedEntities", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/entities/from-entity/{1}/by-relationship", findRequestParameters, userId, startEntityGUID);
        }
        this.detectAndThrowFunctionNotSupportedException("getRelatedEntities", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidParameterException("getRelatedEntities", (OMRSAPIResponse)restResult);
        this.detectAndThrowTypeErrorException("getRelatedEntities", (OMRSAPIResponse)restResult);
        this.detectAndThrowEntityNotKnownException("getRelatedEntities", (OMRSAPIResponse)restResult);
        this.detectAndThrowPropertyErrorException("getRelatedEntities", (OMRSAPIResponse)restResult);
        this.detectAndThrowPagingErrorException("getRelatedEntities", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("getRelatedEntities", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("getRelatedEntities", (OMRSAPIResponse)restResult);
        return restResult.getEntities();
    }

    public EntityDetail addEntity(String userId, String entityTypeGUID, InstanceProperties initialProperties, List<Classification> initialClassifications, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, ClassificationErrorException, StatusNotSupportedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "addEntity";
        String operationSpecificURL = "instances/entity";
        EntityCreateRequest requestBody = new EntityCreateRequest();
        requestBody.setEntityTypeGUID(entityTypeGUID);
        requestBody.setInitialClassifications(initialClassifications);
        requestBody.setInitialProperties(initialProperties);
        requestBody.setInitialStatus(initialStatus);
        EntityDetailResponse restResult = this.callEntityDetailPostRESTCall("addEntity", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/entity", requestBody, userId);
        this.detectAndThrowInvalidParameterException("addEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowTypeErrorException("addEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowPropertyErrorException("addEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowClassificationErrorException("addEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowStatusNotSupportedException("addEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("addEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowFunctionNotSupportedException("addEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("addEntity", (OMRSAPIResponse)restResult);
        return restResult.getEntity();
    }

    public EntityDetail addExternalEntity(String userId, String entityTypeGUID, String externalSourceGUID, String externalSourceName, InstanceProperties initialProperties, List<Classification> initialClassifications, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, ClassificationErrorException, StatusNotSupportedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "addExternalEntity";
        String operationSpecificURL = "instances/entity/external";
        EntityCreateRequest requestBody = new EntityCreateRequest();
        requestBody.setEntityTypeGUID(entityTypeGUID);
        requestBody.setMetadataCollectionId(externalSourceGUID);
        requestBody.setMetadataCollectionName(externalSourceName);
        requestBody.setInitialClassifications(initialClassifications);
        requestBody.setInitialProperties(initialProperties);
        requestBody.setInitialStatus(initialStatus);
        EntityDetailResponse restResult = this.callEntityDetailPostRESTCall("addExternalEntity", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/entity/external", requestBody, userId);
        this.detectAndThrowInvalidParameterException("addExternalEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowTypeErrorException("addExternalEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowPropertyErrorException("addExternalEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowClassificationErrorException("addExternalEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowStatusNotSupportedException("addExternalEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("addExternalEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowFunctionNotSupportedException("addExternalEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("addExternalEntity", (OMRSAPIResponse)restResult);
        return restResult.getEntity();
    }

    public void addEntityProxy(String userId, EntityProxy entityProxy) throws InvalidParameterException, RepositoryErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "addEntityProxy";
        String operationSpecificURL = "instances/entity-proxy";
        VoidResponse restResult = this.callVoidPostRESTCall("addEntityProxy", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/entity-proxy", entityProxy, userId);
        this.detectAndThrowFunctionNotSupportedException("addEntityProxy", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidParameterException("addEntityProxy", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("addEntityProxy", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("addEntityProxy", (OMRSAPIResponse)restResult);
    }

    public EntityDetail updateEntityStatus(String userId, String entityGUID, InstanceStatus newStatus) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, StatusNotSupportedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "updateEntityStatus";
        String operationSpecificURL = "instances/entity/{1}/status";
        EntityDetailResponse restResult = this.callEntityDetailPostRESTCall("updateEntityStatus", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/entity/{1}/status", newStatus, userId, entityGUID);
        this.detectAndThrowInvalidParameterException("updateEntityStatus", (OMRSAPIResponse)restResult);
        this.detectAndThrowEntityNotKnownException("updateEntityStatus", (OMRSAPIResponse)restResult);
        this.detectAndThrowStatusNotSupportedException("updateEntityStatus", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("updateEntityStatus", (OMRSAPIResponse)restResult);
        this.detectAndThrowFunctionNotSupportedException("updateEntityStatus", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("updateEntityStatus", (OMRSAPIResponse)restResult);
        return restResult.getEntity();
    }

    public EntityDetail updateEntityProperties(String userId, String entityGUID, InstanceProperties properties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "updateEntityProperties";
        String operationSpecificURL = "instances/entity/{1}/properties";
        InstancePropertiesRequest requestBody = new InstancePropertiesRequest();
        requestBody.setInstanceProperties(properties);
        EntityDetailResponse restResult = this.callEntityDetailPostRESTCall("updateEntityProperties", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/entity/{1}/properties", requestBody, userId, entityGUID);
        this.detectAndThrowInvalidParameterException("updateEntityProperties", (OMRSAPIResponse)restResult);
        this.detectAndThrowEntityNotKnownException("updateEntityProperties", (OMRSAPIResponse)restResult);
        this.detectAndThrowPropertyErrorException("updateEntityProperties", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("updateEntityProperties", (OMRSAPIResponse)restResult);
        this.detectAndThrowFunctionNotSupportedException("updateEntityProperties", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("updateEntityProperties", (OMRSAPIResponse)restResult);
        return restResult.getEntity();
    }

    public EntityDetail undoEntityUpdate(String userId, String entityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "undoEntityUpdate";
        String operationSpecificURL = "instances/entity/{1}/previous";
        EntityDetailResponse restResult = this.callEntityDetailGetRESTCall("undoEntityUpdate", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/entity/{1}/previous", userId, entityGUID);
        this.detectAndThrowFunctionNotSupportedException("undoEntityUpdate", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidParameterException("undoEntityUpdate", (OMRSAPIResponse)restResult);
        this.detectAndThrowEntityNotKnownException("undoEntityUpdate", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("undoEntityUpdate", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("undoEntityUpdate", (OMRSAPIResponse)restResult);
        return restResult.getEntity();
    }

    public EntityDetail deleteEntity(String userId, String typeDefGUID, String typeDefName, String obsoleteEntityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "deleteEntity";
        String operationSpecificURL = "instances/entity/{1}/delete";
        TypeDefValidationForRequest requestBody = new TypeDefValidationForRequest();
        requestBody.setTypeDefGUID(typeDefGUID);
        requestBody.setTypeDefName(typeDefName);
        EntityDetailResponse restResult = this.callEntityDetailPostRESTCall("deleteEntity", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/entity/{1}/delete", requestBody, userId, obsoleteEntityGUID);
        this.detectAndThrowInvalidParameterException("deleteEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowEntityNotKnownException("deleteEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowFunctionNotSupportedException("deleteEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("deleteEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("deleteEntity", (OMRSAPIResponse)restResult);
        return restResult.getEntity();
    }

    public void purgeEntity(String userId, String typeDefGUID, String typeDefName, String deletedEntityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityNotDeletedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "purgeEntity";
        String operationSpecificURL = "instances/entity/{1}/purge";
        TypeDefValidationForRequest requestBody = new TypeDefValidationForRequest();
        requestBody.setTypeDefGUID(typeDefGUID);
        requestBody.setTypeDefName(typeDefName);
        VoidResponse restResult = this.callVoidPostRESTCall("purgeEntity", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/entity/{1}/purge", requestBody, userId, deletedEntityGUID);
        this.detectAndThrowInvalidParameterException("purgeEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowEntityNotKnownException("purgeEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowEntityNotDeletedException("purgeEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("purgeEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowFunctionNotSupportedException("purgeEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("purgeEntity", (OMRSAPIResponse)restResult);
    }

    public EntityDetail restoreEntity(String userId, String deletedEntityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityNotDeletedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "restoreEntity";
        String operationSpecificURL = "instances/entity/{1}/restore";
        EntityDetailResponse restResult = this.callEntityDetailGetRESTCall("restoreEntity", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/entity/{1}/restore", userId, deletedEntityGUID);
        this.detectAndThrowFunctionNotSupportedException("restoreEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidParameterException("restoreEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowEntityNotKnownException("restoreEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowEntityNotDeletedException("restoreEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("restoreEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("restoreEntity", (OMRSAPIResponse)restResult);
        return restResult.getEntity();
    }

    public EntityDetail classifyEntity(String userId, String entityGUID, String classificationName, InstanceProperties classificationProperties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "classifyEntity";
        String operationSpecificURL = "instances/entity/{1}/classification/{2}";
        InstancePropertiesRequest requestBody = new InstancePropertiesRequest();
        requestBody.setInstanceProperties(classificationProperties);
        EntityDetailResponse restResult = this.callEntityDetailPostRESTCall("classifyEntity", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/entity/{1}/classification/{2}", requestBody, userId, entityGUID, classificationName);
        this.detectAndThrowInvalidParameterException("classifyEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowEntityNotKnownException("classifyEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowClassificationErrorException("classifyEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowPropertyErrorException("classifyEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("classifyEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowFunctionNotSupportedException("classifyEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("classifyEntity", (OMRSAPIResponse)restResult);
        return restResult.getEntity();
    }

    public Classification classifyEntity(String userId, EntityProxy entityProxy, String classificationName, InstanceProperties classificationProperties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "classifyEntityProxy";
        String operationSpecificURL = "instances/entity/classification/{1}";
        ProxyClassificationRequest requestBody = new ProxyClassificationRequest();
        requestBody.setEntityProxy(entityProxy);
        requestBody.setInstanceProperties(classificationProperties);
        ClassificationResponse restResult = this.callClassificationPostRESTCall("classifyEntityProxy", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/entity/classification/{1}", requestBody, userId, classificationName);
        this.detectAndThrowInvalidParameterException("classifyEntityProxy", (OMRSAPIResponse)restResult);
        this.detectAndThrowEntityNotKnownException("classifyEntityProxy", (OMRSAPIResponse)restResult);
        this.detectAndThrowClassificationErrorException("classifyEntityProxy", (OMRSAPIResponse)restResult);
        this.detectAndThrowPropertyErrorException("classifyEntityProxy", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("classifyEntityProxy", (OMRSAPIResponse)restResult);
        this.detectAndThrowFunctionNotSupportedException("classifyEntityProxy", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("classifyEntityProxy", (OMRSAPIResponse)restResult);
        return restResult.getClassification();
    }

    public EntityDetail classifyEntity(String userId, String entityGUID, String classificationName, String externalSourceGUID, String externalSourceName, ClassificationOrigin classificationOrigin, String classificationOriginGUID, InstanceProperties classificationProperties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "classifyEntity (detailed)";
        String operationSpecificURL = "instances/entity/{1}/classification/{2}/detailed";
        ClassificationRequest requestBody = new ClassificationRequest();
        requestBody.setMetadataCollectionId(externalSourceGUID);
        requestBody.setMetadataCollectionName(externalSourceName);
        requestBody.setClassificationOrigin(classificationOrigin);
        requestBody.setClassificationOriginGUID(classificationOriginGUID);
        requestBody.setClassificationProperties(classificationProperties);
        EntityDetailResponse restResult = this.callEntityDetailPostRESTCall("classifyEntity (detailed)", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/entity/{1}/classification/{2}/detailed", requestBody, userId, entityGUID, classificationName);
        this.detectAndThrowInvalidParameterException("classifyEntity (detailed)", (OMRSAPIResponse)restResult);
        this.detectAndThrowEntityNotKnownException("classifyEntity (detailed)", (OMRSAPIResponse)restResult);
        this.detectAndThrowClassificationErrorException("classifyEntity (detailed)", (OMRSAPIResponse)restResult);
        this.detectAndThrowPropertyErrorException("classifyEntity (detailed)", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("classifyEntity (detailed)", (OMRSAPIResponse)restResult);
        this.detectAndThrowFunctionNotSupportedException("classifyEntity (detailed)", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("classifyEntity (detailed)", (OMRSAPIResponse)restResult);
        return restResult.getEntity();
    }

    public Classification classifyEntity(String userId, EntityProxy entityProxy, String classificationName, String externalSourceGUID, String externalSourceName, ClassificationOrigin classificationOrigin, String classificationOriginGUID, InstanceProperties classificationProperties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "classifyEntityProxy (detailed)";
        String operationSpecificURL = "instances/entity/classification/{1}/detailed";
        ClassificationProxyRequest requestBody = new ClassificationProxyRequest();
        requestBody.setEntityProxy(entityProxy);
        requestBody.setMetadataCollectionId(externalSourceGUID);
        requestBody.setMetadataCollectionName(externalSourceName);
        requestBody.setClassificationOrigin(classificationOrigin);
        requestBody.setClassificationOriginGUID(classificationOriginGUID);
        requestBody.setClassificationProperties(classificationProperties);
        ClassificationResponse restResult = this.callClassificationPostRESTCall("classifyEntityProxy (detailed)", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/entity/classification/{1}/detailed", requestBody, userId, classificationName);
        this.detectAndThrowInvalidParameterException("classifyEntityProxy (detailed)", (OMRSAPIResponse)restResult);
        this.detectAndThrowEntityNotKnownException("classifyEntityProxy (detailed)", (OMRSAPIResponse)restResult);
        this.detectAndThrowClassificationErrorException("classifyEntityProxy (detailed)", (OMRSAPIResponse)restResult);
        this.detectAndThrowPropertyErrorException("classifyEntityProxy (detailed)", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("classifyEntityProxy (detailed)", (OMRSAPIResponse)restResult);
        this.detectAndThrowFunctionNotSupportedException("classifyEntityProxy (detailed)", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("classifyEntityProxy (detailed)", (OMRSAPIResponse)restResult);
        return restResult.getClassification();
    }

    public EntityDetail declassifyEntity(String userId, String entityGUID, String classificationName) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "declassifyEntity";
        String operationSpecificURL = "instances/entity/{1}/classification/{2}/delete";
        OMRSAPIRequest requestBody = new OMRSAPIRequest();
        EntityDetailResponse restResult = this.callEntityDetailPostRESTCall("declassifyEntity", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/entity/{1}/classification/{2}/delete", requestBody, userId, entityGUID, classificationName);
        this.detectAndThrowInvalidParameterException("declassifyEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowEntityNotKnownException("declassifyEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowClassificationErrorException("declassifyEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("declassifyEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowFunctionNotSupportedException("declassifyEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("declassifyEntity", (OMRSAPIResponse)restResult);
        return restResult.getEntity();
    }

    public Classification declassifyEntity(String userId, EntityProxy entityProxy, String classificationName) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "declassifyEntityProxy";
        String operationSpecificURL = "instances/entity/classification/{1}/delete";
        ClassificationResponse restResult = this.callClassificationPostRESTCall("declassifyEntityProxy", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/entity/classification/{1}/delete", entityProxy, userId, classificationName);
        this.detectAndThrowInvalidParameterException("declassifyEntityProxy", (OMRSAPIResponse)restResult);
        this.detectAndThrowEntityNotKnownException("declassifyEntityProxy", (OMRSAPIResponse)restResult);
        this.detectAndThrowClassificationErrorException("declassifyEntityProxy", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("declassifyEntityProxy", (OMRSAPIResponse)restResult);
        this.detectAndThrowFunctionNotSupportedException("declassifyEntityProxy", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("declassifyEntityProxy", (OMRSAPIResponse)restResult);
        return restResult.getClassification();
    }

    public EntityDetail updateEntityClassification(String userId, String entityGUID, String classificationName, InstanceProperties properties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "updateEntityClassification";
        String operationSpecificURL = "instances/entity/{1}/classification/{2}/properties";
        InstancePropertiesRequest requestBody = new InstancePropertiesRequest();
        requestBody.setInstanceProperties(properties);
        EntityDetailResponse restResult = this.callEntityDetailPostRESTCall("updateEntityClassification", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/entity/{1}/classification/{2}/properties", requestBody, userId, entityGUID, classificationName);
        this.detectAndThrowInvalidParameterException("updateEntityClassification", (OMRSAPIResponse)restResult);
        this.detectAndThrowEntityNotKnownException("updateEntityClassification", (OMRSAPIResponse)restResult);
        this.detectAndThrowClassificationErrorException("updateEntityClassification", (OMRSAPIResponse)restResult);
        this.detectAndThrowPropertyErrorException("updateEntityClassification", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("updateEntityClassification", (OMRSAPIResponse)restResult);
        this.detectAndThrowFunctionNotSupportedException("updateEntityClassification", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("updateEntityClassification", (OMRSAPIResponse)restResult);
        return restResult.getEntity();
    }

    public Classification updateEntityClassification(String userId, EntityProxy entityProxy, String classificationName, InstanceProperties properties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "updateEntityProxyClassification";
        String operationSpecificURL = "instances/entity/classification/{1}/properties";
        ProxyClassificationRequest requestBody = new ProxyClassificationRequest();
        requestBody.setEntityProxy(entityProxy);
        requestBody.setInstanceProperties(properties);
        ClassificationResponse restResult = this.callClassificationPostRESTCall("updateEntityProxyClassification", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/entity/classification/{1}/properties", requestBody, userId, classificationName);
        this.detectAndThrowInvalidParameterException("updateEntityProxyClassification", (OMRSAPIResponse)restResult);
        this.detectAndThrowEntityNotKnownException("updateEntityProxyClassification", (OMRSAPIResponse)restResult);
        this.detectAndThrowClassificationErrorException("updateEntityProxyClassification", (OMRSAPIResponse)restResult);
        this.detectAndThrowPropertyErrorException("updateEntityProxyClassification", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("updateEntityProxyClassification", (OMRSAPIResponse)restResult);
        this.detectAndThrowFunctionNotSupportedException("updateEntityProxyClassification", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("updateEntityProxyClassification", (OMRSAPIResponse)restResult);
        return restResult.getClassification();
    }

    public Relationship addRelationship(String userId, String relationshipTypeGUID, InstanceProperties initialProperties, String entityOneGUID, String entityTwoGUID, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, EntityNotKnownException, StatusNotSupportedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "addRelationship";
        String operationSpecificURL = "instances/relationship";
        RelationshipCreateRequest request = new RelationshipCreateRequest();
        request.setRelationshipTypeGUID(relationshipTypeGUID);
        request.setInitialProperties(initialProperties);
        request.setEntityOneGUID(entityOneGUID);
        request.setEntityTwoGUID(entityTwoGUID);
        request.setInitialStatus(initialStatus);
        RelationshipResponse restResult = this.callRelationshipPostRESTCall("addRelationship", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/relationship", request, userId);
        this.detectAndThrowInvalidParameterException("addRelationship", (OMRSAPIResponse)restResult);
        this.detectAndThrowTypeErrorException("addRelationship", (OMRSAPIResponse)restResult);
        this.detectAndThrowPropertyErrorException("addRelationship", (OMRSAPIResponse)restResult);
        this.detectAndThrowEntityNotKnownException("addRelationship", (OMRSAPIResponse)restResult);
        this.detectAndThrowStatusNotSupportedException("addRelationship", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("addRelationship", (OMRSAPIResponse)restResult);
        this.detectAndThrowFunctionNotSupportedException("addRelationship", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("addRelationship", (OMRSAPIResponse)restResult);
        return restResult.getRelationship();
    }

    public Relationship addExternalRelationship(String userId, String relationshipTypeGUID, String externalSourceGUID, String externalSourceName, InstanceProperties initialProperties, String entityOneGUID, String entityTwoGUID, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, EntityNotKnownException, StatusNotSupportedException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "addExternalRelationship";
        String operationSpecificURL = "instances/relationship/external";
        RelationshipCreateRequest request = new RelationshipCreateRequest();
        request.setRelationshipTypeGUID(relationshipTypeGUID);
        request.setMetadataCollectionId(externalSourceGUID);
        request.setMetadataCollectionName(externalSourceName);
        request.setInitialProperties(initialProperties);
        request.setEntityOneGUID(entityOneGUID);
        request.setEntityTwoGUID(entityTwoGUID);
        request.setInitialStatus(initialStatus);
        RelationshipResponse restResult = this.callRelationshipPostRESTCall("addExternalRelationship", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/relationship/external", request, userId);
        this.detectAndThrowInvalidParameterException("addExternalRelationship", (OMRSAPIResponse)restResult);
        this.detectAndThrowTypeErrorException("addExternalRelationship", (OMRSAPIResponse)restResult);
        this.detectAndThrowPropertyErrorException("addExternalRelationship", (OMRSAPIResponse)restResult);
        this.detectAndThrowEntityNotKnownException("addExternalRelationship", (OMRSAPIResponse)restResult);
        this.detectAndThrowStatusNotSupportedException("addExternalRelationship", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("addExternalRelationship", (OMRSAPIResponse)restResult);
        this.detectAndThrowFunctionNotSupportedException("addExternalRelationship", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("addExternalRelationship", (OMRSAPIResponse)restResult);
        return restResult.getRelationship();
    }

    public Relationship updateRelationshipStatus(String userId, String relationshipGUID, InstanceStatus newStatus) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, StatusNotSupportedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "updateRelationshipStatus";
        String operationSpecificURL = "instances/relationship/{1}/status";
        RelationshipResponse restResult = this.callRelationshipPostRESTCall("updateRelationshipStatus", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/relationship/{1}/status", newStatus, userId, relationshipGUID);
        this.detectAndThrowInvalidParameterException("updateRelationshipStatus", (OMRSAPIResponse)restResult);
        this.detectAndThrowRelationshipNotKnownException("updateRelationshipStatus", (OMRSAPIResponse)restResult);
        this.detectAndThrowStatusNotSupportedException("updateRelationshipStatus", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("updateRelationshipStatus", (OMRSAPIResponse)restResult);
        this.detectAndThrowFunctionNotSupportedException("updateRelationshipStatus", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("updateRelationshipStatus", (OMRSAPIResponse)restResult);
        return restResult.getRelationship();
    }

    public Relationship updateRelationshipProperties(String userId, String relationshipGUID, InstanceProperties properties) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "updateRelationshipProperties";
        String operationSpecificURL = "instances/relationship/{1}/properties";
        InstancePropertiesRequest requestBody = new InstancePropertiesRequest();
        requestBody.setInstanceProperties(properties);
        RelationshipResponse restResult = this.callRelationshipPostRESTCall("updateRelationshipProperties", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/relationship/{1}/properties", requestBody, userId, relationshipGUID);
        this.detectAndThrowInvalidParameterException("updateRelationshipProperties", (OMRSAPIResponse)restResult);
        this.detectAndThrowRelationshipNotKnownException("updateRelationshipProperties", (OMRSAPIResponse)restResult);
        this.detectAndThrowPropertyErrorException("updateRelationshipProperties", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("updateRelationshipProperties", (OMRSAPIResponse)restResult);
        this.detectAndThrowFunctionNotSupportedException("updateRelationshipProperties", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("updateRelationshipProperties", (OMRSAPIResponse)restResult);
        return restResult.getRelationship();
    }

    public Relationship undoRelationshipUpdate(String userId, String relationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "undoRelationshipUpdate";
        String operationSpecificURL = "instances/relationship/{1}/previous";
        RelationshipResponse restResult = this.callRelationshipGetRESTCall("undoRelationshipUpdate", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/relationship/{1}/previous", userId, relationshipGUID);
        this.detectAndThrowFunctionNotSupportedException("undoRelationshipUpdate", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidParameterException("undoRelationshipUpdate", (OMRSAPIResponse)restResult);
        this.detectAndThrowRelationshipNotKnownException("undoRelationshipUpdate", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("undoRelationshipUpdate", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("undoRelationshipUpdate", (OMRSAPIResponse)restResult);
        return restResult.getRelationship();
    }

    public Relationship deleteRelationship(String userId, String typeDefGUID, String typeDefName, String obsoleteRelationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "deleteRelationship";
        String operationSpecificURL = "instances/relationship/{1}/delete";
        TypeDefValidationForRequest requestBody = new TypeDefValidationForRequest();
        requestBody.setTypeDefGUID(typeDefGUID);
        requestBody.setTypeDefName(typeDefName);
        RelationshipResponse restResult = this.callRelationshipPostRESTCall("deleteRelationship", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/relationship/{1}/delete", requestBody, userId, obsoleteRelationshipGUID);
        this.detectAndThrowInvalidParameterException("deleteRelationship", (OMRSAPIResponse)restResult);
        this.detectAndThrowRelationshipNotKnownException("deleteRelationship", (OMRSAPIResponse)restResult);
        this.detectAndThrowFunctionNotSupportedException("deleteRelationship", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("deleteRelationship", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("deleteRelationship", (OMRSAPIResponse)restResult);
        return restResult.getRelationship();
    }

    public void purgeRelationship(String userId, String typeDefGUID, String typeDefName, String deletedRelationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, RelationshipNotDeletedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "purgeRelationship";
        String operationSpecificURL = "instances/relationship/{1}/purge";
        TypeDefValidationForRequest requestBody = new TypeDefValidationForRequest();
        requestBody.setTypeDefGUID(typeDefGUID);
        requestBody.setTypeDefName(typeDefName);
        VoidResponse restResult = this.callVoidPostRESTCall("purgeRelationship", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/relationship/{1}/purge", requestBody, userId, deletedRelationshipGUID);
        this.detectAndThrowInvalidParameterException("purgeRelationship", (OMRSAPIResponse)restResult);
        this.detectAndThrowRelationshipNotKnownException("purgeRelationship", (OMRSAPIResponse)restResult);
        this.detectAndThrowRelationshipNotDeletedException("purgeRelationship", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("purgeRelationship", (OMRSAPIResponse)restResult);
        this.detectAndThrowFunctionNotSupportedException("purgeRelationship", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("purgeRelationship", (OMRSAPIResponse)restResult);
    }

    public Relationship restoreRelationship(String userId, String deletedRelationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, RelationshipNotDeletedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "restoreRelationship";
        String operationSpecificURL = "instances/relationship/{1}/restore";
        RelationshipResponse restResult = this.callRelationshipGetRESTCall("restoreRelationship", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/relationship/{1}/restore", userId, deletedRelationshipGUID);
        this.detectAndThrowFunctionNotSupportedException("restoreRelationship", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidParameterException("restoreRelationship", (OMRSAPIResponse)restResult);
        this.detectAndThrowRelationshipNotKnownException("restoreRelationship", (OMRSAPIResponse)restResult);
        this.detectAndThrowRelationshipNotDeletedException("restoreRelationship", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("restoreRelationship", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("restoreRelationship", (OMRSAPIResponse)restResult);
        return restResult.getRelationship();
    }

    public EntityDetail reIdentifyEntity(String userId, String typeDefGUID, String typeDefName, String entityGUID, String newEntityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "reIdentifyEntity";
        String operationSpecificURL = "instances/entity/{1}/identity?newEntityGUID={2}";
        TypeDefValidationForRequest requestBody = new TypeDefValidationForRequest();
        requestBody.setTypeDefGUID(typeDefGUID);
        requestBody.setTypeDefName(typeDefName);
        EntityDetailResponse restResult = this.callEntityDetailPostRESTCall("reIdentifyEntity", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/entity/{1}/identity?newEntityGUID={2}", requestBody, userId, entityGUID, newEntityGUID);
        this.detectAndThrowFunctionNotSupportedException("reIdentifyEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidParameterException("reIdentifyEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowEntityNotKnownException("reIdentifyEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("reIdentifyEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("reIdentifyEntity", (OMRSAPIResponse)restResult);
        return restResult.getEntity();
    }

    public EntityDetail reTypeEntity(String userId, String entityGUID, TypeDefSummary currentTypeDefSummary, TypeDefSummary newTypeDefSummary) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, ClassificationErrorException, EntityNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "reTypeEntity";
        String operationSpecificURL = "instances/entity/{1}/type";
        TypeDefChangeRequest requestBody = new TypeDefChangeRequest();
        requestBody.setCurrentTypeDef(currentTypeDefSummary);
        requestBody.setNewTypeDef(newTypeDefSummary);
        EntityDetailResponse restResult = this.callEntityDetailPostRESTCall("reTypeEntity", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/entity/{1}/type", requestBody, userId, entityGUID);
        this.detectAndThrowFunctionNotSupportedException("reTypeEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidParameterException("reTypeEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowTypeErrorException("reTypeEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowPropertyErrorException("reTypeEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowClassificationErrorException("reTypeEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowEntityNotKnownException("reTypeEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("reTypeEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("reTypeEntity", (OMRSAPIResponse)restResult);
        return restResult.getEntity();
    }

    public EntityDetail reHomeEntity(String userId, String entityGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId, String newHomeMetadataCollectionId, String newHomeMetadataCollectionName) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "reHomeEntity";
        String operationSpecificURL1 = "instances/entity/{1}/home/{2}?newHomeMetadataCollectionId={3}";
        String operationSpecificURL2 = "instances/entity/{1}/home/{2}?newHomeMetadataCollectionId={3}&newHomeMetadataCollectionName={4}";
        TypeDefValidationForRequest requestBody = new TypeDefValidationForRequest();
        requestBody.setTypeDefGUID(typeDefGUID);
        requestBody.setTypeDefName(typeDefName);
        EntityDetailResponse restResult = newHomeMetadataCollectionName == null ? this.callEntityDetailPostRESTCall("reHomeEntity", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/entity/{1}/home/{2}?newHomeMetadataCollectionId={3}", requestBody, userId, entityGUID, homeMetadataCollectionId, newHomeMetadataCollectionId) : this.callEntityDetailPostRESTCall("reHomeEntity", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/entity/{1}/home/{2}?newHomeMetadataCollectionId={3}&newHomeMetadataCollectionName={4}", requestBody, userId, entityGUID, homeMetadataCollectionId, newHomeMetadataCollectionId, newHomeMetadataCollectionName);
        this.detectAndThrowFunctionNotSupportedException("reHomeEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidParameterException("reHomeEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowEntityNotKnownException("reHomeEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("reHomeEntity", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("reHomeEntity", (OMRSAPIResponse)restResult);
        return restResult.getEntity();
    }

    public Relationship reIdentifyRelationship(String userId, String typeDefGUID, String typeDefName, String relationshipGUID, String newRelationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "reIdentifyRelationship";
        String operationSpecificURL = "instances/relationship/{1}/identity?newRelationshipGUID={2}";
        TypeDefValidationForRequest requestBody = new TypeDefValidationForRequest();
        requestBody.setTypeDefGUID(typeDefGUID);
        requestBody.setTypeDefName(typeDefName);
        RelationshipResponse restResult = this.callRelationshipPostRESTCall("reIdentifyRelationship", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/relationship/{1}/identity?newRelationshipGUID={2}", requestBody, userId, relationshipGUID, newRelationshipGUID);
        this.detectAndThrowFunctionNotSupportedException("reIdentifyRelationship", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidParameterException("reIdentifyRelationship", (OMRSAPIResponse)restResult);
        this.detectAndThrowRelationshipNotKnownException("reIdentifyRelationship", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("reIdentifyRelationship", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("reIdentifyRelationship", (OMRSAPIResponse)restResult);
        return restResult.getRelationship();
    }

    public Relationship reTypeRelationship(String userId, String relationshipGUID, TypeDefSummary currentTypeDefSummary, TypeDefSummary newTypeDefSummary) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "reTypeRelationship";
        String operationSpecificURL = "instances/relationship/{1}/type";
        TypeDefChangeRequest requestBody = new TypeDefChangeRequest();
        requestBody.setCurrentTypeDef(currentTypeDefSummary);
        requestBody.setNewTypeDef(newTypeDefSummary);
        RelationshipResponse restResult = this.callRelationshipPostRESTCall("reTypeRelationship", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/relationship/{1}/type", requestBody, userId, relationshipGUID);
        this.detectAndThrowFunctionNotSupportedException("reTypeRelationship", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidParameterException("reTypeRelationship", (OMRSAPIResponse)restResult);
        this.detectAndThrowTypeErrorException("reTypeRelationship", (OMRSAPIResponse)restResult);
        this.detectAndThrowPropertyErrorException("reTypeRelationship", (OMRSAPIResponse)restResult);
        this.detectAndThrowRelationshipNotKnownException("reTypeRelationship", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("reTypeRelationship", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("reTypeRelationship", (OMRSAPIResponse)restResult);
        return restResult.getRelationship();
    }

    public Relationship reHomeRelationship(String userId, String relationshipGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId, String newHomeMetadataCollectionId, String newHomeMetadataCollectionName) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "reHomeRelationship";
        String operationSpecificURL1 = "instances/relationship/{1}/home/{2}?newHomeMetadataCollectionId={3}";
        String operationSpecificURL2 = "instances/relationship/{1}/home/{2}?newHomeMetadataCollectionId={3}&newHomeMetadataCollectionName={4}";
        TypeDefValidationForRequest requestBody = new TypeDefValidationForRequest();
        requestBody.setTypeDefGUID(typeDefGUID);
        requestBody.setTypeDefName(typeDefName);
        RelationshipResponse restResult = newHomeMetadataCollectionName == null ? this.callRelationshipPostRESTCall("reHomeRelationship", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/relationship/{1}/home/{2}?newHomeMetadataCollectionId={3}", requestBody, userId, relationshipGUID, homeMetadataCollectionId, newHomeMetadataCollectionId) : this.callRelationshipPostRESTCall("reHomeRelationship", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/relationship/{1}/home/{2}?newHomeMetadataCollectionId={3}&newHomeMetadataCollectionName={4}", requestBody, userId, relationshipGUID, homeMetadataCollectionId, newHomeMetadataCollectionId, newHomeMetadataCollectionName);
        this.detectAndThrowFunctionNotSupportedException("reHomeRelationship", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidParameterException("reHomeRelationship", (OMRSAPIResponse)restResult);
        this.detectAndThrowRelationshipNotKnownException("reHomeRelationship", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("reHomeRelationship", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("reHomeRelationship", (OMRSAPIResponse)restResult);
        return restResult.getRelationship();
    }

    public void saveEntityReferenceCopy(String userId, EntityDetail entity) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, HomeEntityException, EntityConflictException, InvalidEntityException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "saveEntityReferenceCopy";
        String operationSpecificURL = "instances/entities/reference-copy";
        VoidResponse restResult = this.callVoidPostRESTCall("saveEntityReferenceCopy", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/entities/reference-copy", entity, userId);
        this.detectAndThrowFunctionNotSupportedException("saveEntityReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidParameterException("saveEntityReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowTypeErrorException("saveEntityReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowPropertyErrorException("saveEntityReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowHomeEntityException("saveEntityReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowEntityConflictException("saveEntityReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidEntityException("saveEntityReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("saveEntityReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("saveEntityReferenceCopy", (OMRSAPIResponse)restResult);
    }

    public List<Classification> getHomeClassifications(String userId, String entityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "getHomeClassifications";
        String operationSpecificURL = "instances/entity/{1}/home-classifications";
        ClassificationListResponse restResult = this.callClassificationListGetRESTCall("getHomeClassifications", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/entity/{1}/home-classifications", userId, entityGUID);
        this.detectAndThrowFunctionNotSupportedException("getHomeClassifications", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidParameterException("getHomeClassifications", (OMRSAPIResponse)restResult);
        this.detectAndThrowEntityNotKnownException("getHomeClassifications", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("getHomeClassifications", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("getHomeClassifications", (OMRSAPIResponse)restResult);
        return restResult.getClassifications();
    }

    public List<Classification> getHomeClassifications(String userId, String entityGUID, Date asOfTime) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "getHomeClassifications (with history)";
        String operationSpecificURL = "instances/entity/{1}/home-classifications/history";
        HistoryRequest requestBody = new HistoryRequest();
        requestBody.setAsOfTime(asOfTime);
        ClassificationListResponse restResult = this.callClassificationListPostRESTCall("getHomeClassifications (with history)", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/entity/{1}/home-classifications/history", requestBody, userId, entityGUID);
        this.detectAndThrowFunctionNotSupportedException("getHomeClassifications (with history)", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidParameterException("getHomeClassifications (with history)", (OMRSAPIResponse)restResult);
        this.detectAndThrowEntityNotKnownException("getHomeClassifications (with history)", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("getHomeClassifications (with history)", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("getHomeClassifications (with history)", (OMRSAPIResponse)restResult);
        return restResult.getClassifications();
    }

    public void deleteEntityReferenceCopy(String userId, EntityDetail entity) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, HomeEntityException, EntityConflictException, InvalidEntityException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "deleteEntityReferenceCopy";
        String operationSpecificURL = "instances/entities/reference-copy/delete";
        VoidResponse restResult = this.callVoidPostRESTCall("deleteEntityReferenceCopy", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/entities/reference-copy/delete", entity, userId);
        this.detectAndThrowFunctionNotSupportedException("deleteEntityReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidParameterException("deleteEntityReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowTypeErrorException("deleteEntityReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowPropertyErrorException("deleteEntityReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowHomeEntityException("deleteEntityReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowEntityConflictException("deleteEntityReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidEntityException("deleteEntityReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("deleteEntityReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("deleteEntityReferenceCopy", (OMRSAPIResponse)restResult);
    }

    public void purgeEntityReferenceCopy(String userId, EntityDetail entity) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, HomeEntityException, EntityConflictException, InvalidEntityException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "purgeEntityReferenceCopy";
        String operationSpecificURL = "instances/entities/reference-copy/purge";
        VoidResponse restResult = this.callVoidPostRESTCall("purgeEntityReferenceCopy", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/entities/reference-copy/purge", entity, userId);
        this.detectAndThrowFunctionNotSupportedException("purgeEntityReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidParameterException("purgeEntityReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowTypeErrorException("purgeEntityReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowPropertyErrorException("purgeEntityReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowHomeEntityException("purgeEntityReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowEntityConflictException("purgeEntityReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidEntityException("purgeEntityReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("purgeEntityReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("purgeEntityReferenceCopy", (OMRSAPIResponse)restResult);
    }

    public void purgeEntityReferenceCopy(String userId, String entityGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, HomeEntityException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "purgeEntityReferenceCopy";
        String operationSpecificURL = "instances/entities/reference-copy/{1}/purge?homeMetadataCollectionId={2}";
        TypeDefValidationForRequest requestBody = new TypeDefValidationForRequest();
        requestBody.setTypeDefGUID(typeDefGUID);
        requestBody.setTypeDefName(typeDefName);
        VoidResponse restResult = this.callVoidPostRESTCall("purgeEntityReferenceCopy", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/entities/reference-copy/{1}/purge?homeMetadataCollectionId={2}", requestBody, userId, entityGUID, homeMetadataCollectionId);
        this.detectAndThrowFunctionNotSupportedException("purgeEntityReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidParameterException("purgeEntityReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowEntityNotKnownException("purgeEntityReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowHomeEntityException("purgeEntityReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("purgeEntityReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("purgeEntityReferenceCopy", (OMRSAPIResponse)restResult);
    }

    public void refreshEntityReferenceCopy(String userId, String entityGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, HomeEntityException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "refreshEntityReferenceCopy";
        String operationSpecificURL = "instances/entities/reference-copy/{1}/refresh?homeMetadataCollectionId={2}";
        TypeDefValidationForRequest requestBody = new TypeDefValidationForRequest();
        requestBody.setTypeDefGUID(typeDefGUID);
        requestBody.setTypeDefName(typeDefName);
        VoidResponse restResult = this.callVoidPostRESTCall("refreshEntityReferenceCopy", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/entities/reference-copy/{1}/refresh?homeMetadataCollectionId={2}", requestBody, userId, entityGUID, homeMetadataCollectionId);
        this.detectAndThrowFunctionNotSupportedException("refreshEntityReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidParameterException("refreshEntityReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowEntityNotKnownException("refreshEntityReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowHomeEntityException("refreshEntityReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("refreshEntityReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("refreshEntityReferenceCopy", (OMRSAPIResponse)restResult);
    }

    public void saveClassificationReferenceCopy(String userId, EntityDetail entity, Classification classification) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, EntityConflictException, InvalidEntityException, PropertyErrorException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "saveClassificationReferenceCopy";
        String operationSpecificURL = "instances/entities/classifications/reference-copy";
        ClassificationWithEntityRequest requestBody = new ClassificationWithEntityRequest();
        requestBody.setEntity(entity);
        requestBody.setClassification(classification);
        VoidResponse restResult = this.callVoidPostRESTCall("saveClassificationReferenceCopy", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/entities/classifications/reference-copy", requestBody, userId);
        this.detectAndThrowFunctionNotSupportedException("saveClassificationReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidParameterException("saveClassificationReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowTypeErrorException("saveClassificationReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowPropertyErrorException("saveClassificationReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowEntityConflictException("saveClassificationReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidEntityException("saveClassificationReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("saveClassificationReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("saveClassificationReferenceCopy", (OMRSAPIResponse)restResult);
    }

    public void saveClassificationReferenceCopy(String userId, EntityProxy entity, Classification classification) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, EntityConflictException, InvalidEntityException, PropertyErrorException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "saveClassificationReferenceCopy(proxy)";
        String operationSpecificURL = "instances/entities/classifications/reference-copy";
        ClassificationWithEntityRequest requestBody = new ClassificationWithEntityRequest();
        requestBody.setEntityProxy(entity);
        requestBody.setClassification(classification);
        VoidResponse restResult = this.callVoidPostRESTCall("saveClassificationReferenceCopy(proxy)", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/entities/classifications/reference-copy", requestBody, userId);
        this.detectAndThrowFunctionNotSupportedException("saveClassificationReferenceCopy(proxy)", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidParameterException("saveClassificationReferenceCopy(proxy)", (OMRSAPIResponse)restResult);
        this.detectAndThrowTypeErrorException("saveClassificationReferenceCopy(proxy)", (OMRSAPIResponse)restResult);
        this.detectAndThrowPropertyErrorException("saveClassificationReferenceCopy(proxy)", (OMRSAPIResponse)restResult);
        this.detectAndThrowEntityConflictException("saveClassificationReferenceCopy(proxy)", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidEntityException("saveClassificationReferenceCopy(proxy)", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("saveClassificationReferenceCopy(proxy)", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("saveClassificationReferenceCopy(proxy)", (OMRSAPIResponse)restResult);
    }

    public void purgeClassificationReferenceCopy(String userId, EntityDetail entity, Classification classification) throws InvalidParameterException, TypeErrorException, PropertyErrorException, EntityConflictException, InvalidEntityException, RepositoryErrorException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "purgeClassificationReferenceCopy";
        String operationSpecificURL = "instances/entities/classifications/reference-copy/purge";
        ClassificationWithEntityRequest requestBody = new ClassificationWithEntityRequest();
        requestBody.setEntity(entity);
        requestBody.setClassification(classification);
        VoidResponse restResult = this.callVoidPostRESTCall("purgeClassificationReferenceCopy", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/entities/classifications/reference-copy/purge", requestBody, userId);
        this.detectAndThrowFunctionNotSupportedException("purgeClassificationReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidParameterException("purgeClassificationReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowTypeErrorException("purgeClassificationReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowPropertyErrorException("purgeClassificationReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowEntityConflictException("purgeClassificationReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidEntityException("purgeClassificationReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("purgeClassificationReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("purgeClassificationReferenceCopy", (OMRSAPIResponse)restResult);
    }

    public void purgeClassificationReferenceCopy(String userId, EntityProxy entity, Classification classification) throws InvalidParameterException, TypeErrorException, PropertyErrorException, EntityConflictException, InvalidEntityException, RepositoryErrorException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "purgeClassificationReferenceCopy";
        String operationSpecificURL = "instances/entities/classifications/reference-copy/purge";
        ClassificationWithEntityRequest requestBody = new ClassificationWithEntityRequest();
        requestBody.setEntityProxy(entity);
        requestBody.setClassification(classification);
        VoidResponse restResult = this.callVoidPostRESTCall("purgeClassificationReferenceCopy", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/entities/classifications/reference-copy/purge", requestBody, userId);
        this.detectAndThrowFunctionNotSupportedException("purgeClassificationReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidParameterException("purgeClassificationReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowTypeErrorException("purgeClassificationReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowPropertyErrorException("purgeClassificationReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowEntityConflictException("purgeClassificationReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidEntityException("purgeClassificationReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("purgeClassificationReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("purgeClassificationReferenceCopy", (OMRSAPIResponse)restResult);
    }

    public void saveRelationshipReferenceCopy(String userId, Relationship relationship) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, EntityNotKnownException, PropertyErrorException, HomeRelationshipException, RelationshipConflictException, InvalidRelationshipException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "saveRelationshipReferenceCopy";
        String operationSpecificURL = "instances/relationships/reference-copy";
        VoidResponse restResult = this.callVoidPostRESTCall("saveRelationshipReferenceCopy", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/relationships/reference-copy", relationship, userId);
        this.detectAndThrowFunctionNotSupportedException("saveRelationshipReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidParameterException("saveRelationshipReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowTypeErrorException("saveRelationshipReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowEntityNotKnownException("saveRelationshipReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowPropertyErrorException("saveRelationshipReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowHomeRelationshipException("saveRelationshipReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowRelationshipConflictException("saveRelationshipReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidRelationshipException("saveRelationshipReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("saveRelationshipReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("saveRelationshipReferenceCopy", (OMRSAPIResponse)restResult);
    }

    public void deleteRelationshipReferenceCopy(String userId, Relationship relationship) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, EntityNotKnownException, PropertyErrorException, HomeRelationshipException, RelationshipConflictException, InvalidRelationshipException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "deleteRelationshipReferenceCopy";
        String operationSpecificURL = "instances/relationships/reference-copy/delete";
        VoidResponse restResult = this.callVoidPostRESTCall("deleteRelationshipReferenceCopy", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/relationships/reference-copy/delete", relationship, userId);
        this.detectAndThrowFunctionNotSupportedException("deleteRelationshipReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidParameterException("deleteRelationshipReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowTypeErrorException("deleteRelationshipReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowEntityNotKnownException("deleteRelationshipReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowPropertyErrorException("deleteRelationshipReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowHomeRelationshipException("deleteRelationshipReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowRelationshipConflictException("deleteRelationshipReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidRelationshipException("deleteRelationshipReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("deleteRelationshipReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("deleteRelationshipReferenceCopy", (OMRSAPIResponse)restResult);
    }

    public void purgeRelationshipReferenceCopy(String userId, Relationship relationship) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, EntityNotKnownException, PropertyErrorException, HomeRelationshipException, RelationshipConflictException, InvalidRelationshipException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "purgeRelationshipReferenceCopy";
        String operationSpecificURL = "instances/relationships/reference-copy/purge";
        VoidResponse restResult = this.callVoidPostRESTCall("purgeRelationshipReferenceCopy", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/relationships/reference-copy/purge", relationship, userId);
        this.detectAndThrowFunctionNotSupportedException("purgeRelationshipReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidParameterException("purgeRelationshipReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowTypeErrorException("purgeRelationshipReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowEntityNotKnownException("purgeRelationshipReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowPropertyErrorException("purgeRelationshipReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowHomeRelationshipException("purgeRelationshipReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowRelationshipConflictException("purgeRelationshipReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidRelationshipException("purgeRelationshipReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("purgeRelationshipReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("purgeRelationshipReferenceCopy", (OMRSAPIResponse)restResult);
    }

    public void purgeRelationshipReferenceCopy(String userId, String relationshipGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, HomeRelationshipException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "purgeRelationshipReferenceCopy";
        String operationSpecificURL = "instances/relationships/reference-copy/{1}/purge?homeMetadataCollectionId={2}";
        TypeDefValidationForRequest requestBody = new TypeDefValidationForRequest();
        requestBody.setTypeDefGUID(typeDefGUID);
        requestBody.setTypeDefName(typeDefName);
        VoidResponse restResult = this.callVoidPostRESTCall("purgeRelationshipReferenceCopy", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/relationships/reference-copy/{1}/purge?homeMetadataCollectionId={2}", requestBody, userId, relationshipGUID, homeMetadataCollectionId);
        this.detectAndThrowFunctionNotSupportedException("purgeRelationshipReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidParameterException("purgeRelationshipReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowRelationshipNotKnownException("purgeRelationshipReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowHomeRelationshipException("purgeRelationshipReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("purgeRelationshipReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("purgeRelationshipReferenceCopy", (OMRSAPIResponse)restResult);
    }

    public void refreshRelationshipReferenceCopy(String userId, String relationshipGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, HomeRelationshipException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "refreshRelationshipReferenceCopy";
        String operationSpecificURL = "instances/relationships/reference-copy/{1}/refresh?homeMetadataCollectionId={2}";
        TypeDefValidationForRequest requestBody = new TypeDefValidationForRequest();
        requestBody.setTypeDefGUID(typeDefGUID);
        requestBody.setTypeDefName(typeDefName);
        VoidResponse restResult = this.callVoidPostRESTCall("refreshRelationshipReferenceCopy", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances/relationships/reference-copy/{1}/refresh?homeMetadataCollectionId={2}", requestBody, userId, relationshipGUID, homeMetadataCollectionId);
        this.detectAndThrowFunctionNotSupportedException("refreshRelationshipReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidParameterException("refreshRelationshipReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowRelationshipNotKnownException("refreshRelationshipReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowHomeRelationshipException("refreshRelationshipReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("refreshRelationshipReferenceCopy", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("refreshRelationshipReferenceCopy", (OMRSAPIResponse)restResult);
    }

    public void saveInstanceReferenceCopies(String userId, InstanceGraph instances) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, EntityNotKnownException, PropertyErrorException, EntityConflictException, RelationshipConflictException, InvalidEntityException, InvalidRelationshipException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "saveInstanceReferenceCopies";
        String operationSpecificURL = "instances";
        InstanceGraphRequest requestBody = new InstanceGraphRequest();
        if (instances != null) {
            requestBody.setEntityElementList(instances.getEntities());
            requestBody.setRelationshipElementList(instances.getRelationships());
        }
        VoidResponse restResult = this.callVoidPostRESTCall("saveInstanceReferenceCopies", this.restURLRoot + "/open-metadata/repository-services/users/{0}" + this.serviceURLMarker + "instances", requestBody, userId);
        this.detectAndThrowFunctionNotSupportedException("saveInstanceReferenceCopies", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidParameterException("saveInstanceReferenceCopies", (OMRSAPIResponse)restResult);
        this.detectAndThrowTypeErrorException("saveInstanceReferenceCopies", (OMRSAPIResponse)restResult);
        this.detectAndThrowEntityNotKnownException("saveInstanceReferenceCopies", (OMRSAPIResponse)restResult);
        this.detectAndThrowEntityConflictException("saveInstanceReferenceCopies", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidEntityException("saveInstanceReferenceCopies", (OMRSAPIResponse)restResult);
        this.detectAndThrowRelationshipConflictException("saveInstanceReferenceCopies", (OMRSAPIResponse)restResult);
        this.detectAndThrowInvalidRelationshipException("saveInstanceReferenceCopies", (OMRSAPIResponse)restResult);
        this.detectAndThrowPropertyErrorException("saveInstanceReferenceCopies", (OMRSAPIResponse)restResult);
        this.detectAndThrowUserNotAuthorizedException("saveInstanceReferenceCopies", (OMRSAPIResponse)restResult);
        this.detectAndThrowRepositoryErrorException("saveInstanceReferenceCopies", (OMRSAPIResponse)restResult);
    }

    private RESTClientConnector getRESTClientConnector(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        String methodName = "getRESTClientConnector";
        RESTClientFactory clientFactory = this.localServerUserId != null && this.localServerPassword != null ? new RESTClientFactory(serverName, serverPlatformURLRoot, userId, password, null, this.auditLog) : new RESTClientFactory(serverName, serverPlatformURLRoot);
        try {
            return clientFactory.getClientConnector();
        }
        catch (Exception error) {
            throw new InvalidParameterException(OMRSErrorCode.NO_REST_CLIENT.getMessageDefinition(new String[]{serverName, error.getMessage()}), this.getClass().getName(), "getRESTClientConnector", error, "client");
        }
    }

    private AttributeTypeDefListResponse callAttributeTypeDefListPostRESTCall(String methodName, String operationSpecificURL, Object requestBody, Object ... params) throws RepositoryErrorException {
        return this.callPostRESTCall(methodName, AttributeTypeDefListResponse.class, operationSpecificURL, requestBody, params);
    }

    private AttributeTypeDefResponse callAttributeTypeDefGetRESTCall(String methodName, String operationSpecificURL, Object ... params) throws RepositoryErrorException {
        return this.callGetRESTCall(methodName, AttributeTypeDefResponse.class, operationSpecificURL, params);
    }

    private AttributeTypeDefResponse callAttributeTypeDefPostRESTCall(String methodName, String operationSpecificURL, Object requestBody, Object ... params) throws RepositoryErrorException {
        return this.callPostRESTCall(methodName, AttributeTypeDefResponse.class, operationSpecificURL, requestBody, params);
    }

    private BooleanResponse callBooleanPostRESTCall(String methodName, String operationSpecificURL, Object requestBody, Object ... params) throws RepositoryErrorException {
        return this.callPostRESTCall(methodName, BooleanResponse.class, operationSpecificURL, requestBody, params);
    }

    private EntityDetailResponse callEntityDetailGetRESTCall(String methodName, String operationSpecificURL, Object ... params) throws RepositoryErrorException {
        return this.callGetRESTCall(methodName, EntityDetailResponse.class, operationSpecificURL, params);
    }

    private EntityDetailResponse callEntityDetailPostRESTCall(String methodName, String operationSpecificURL, Object requestBody, Object ... params) throws RepositoryErrorException {
        return this.callPostRESTCall(methodName, EntityDetailResponse.class, operationSpecificURL, requestBody, params);
    }

    private ClassificationResponse callClassificationPostRESTCall(String methodName, String operationSpecificURL, Object requestBody, Object ... params) throws RepositoryErrorException {
        return this.callPostRESTCall(methodName, ClassificationResponse.class, operationSpecificURL, requestBody, params);
    }

    private ClassificationListResponse callClassificationListGetRESTCall(String methodName, String operationSpecificURL, Object ... params) throws RepositoryErrorException {
        return this.callGetRESTCall(methodName, ClassificationListResponse.class, operationSpecificURL, params);
    }

    private ClassificationListResponse callClassificationListPostRESTCall(String methodName, String operationSpecificURL, Object requestBody, Object ... params) throws RepositoryErrorException {
        return this.callPostRESTCall(methodName, ClassificationListResponse.class, operationSpecificURL, requestBody, params);
    }

    private EntitySummaryResponse callEntitySummaryGetRESTCall(String methodName, String operationSpecificURL, Object ... params) throws RepositoryErrorException {
        return this.callGetRESTCall(methodName, EntitySummaryResponse.class, operationSpecificURL, params);
    }

    private RelationshipResponse callRelationshipGetRESTCall(String methodName, String operationSpecificURL, Object ... params) throws RepositoryErrorException {
        return this.callGetRESTCall(methodName, RelationshipResponse.class, operationSpecificURL, params);
    }

    private EntityListResponse callEntityListPostRESTCall(String methodName, String operationSpecificURL, Object requestBody, Object ... params) throws RepositoryErrorException {
        return this.callPostRESTCall(methodName, EntityListResponse.class, operationSpecificURL, requestBody, params);
    }

    private RelationshipListResponse callRelationshipListPostRESTCall(String methodName, String operationSpecificURL, Object requestBody, Object ... params) throws RepositoryErrorException {
        return this.callPostRESTCall(methodName, RelationshipListResponse.class, operationSpecificURL, requestBody, params);
    }

    private RelationshipResponse callRelationshipPostRESTCall(String methodName, String operationSpecificURL, Object requestBody, Object ... params) throws RepositoryErrorException {
        return this.callPostRESTCall(methodName, RelationshipResponse.class, operationSpecificURL, requestBody, params);
    }

    private InstanceGraphResponse callInstanceGraphPostRESTCall(String methodName, String operationSpecificURL, Object requestBody, Object ... params) throws RepositoryErrorException {
        return this.callPostRESTCall(methodName, InstanceGraphResponse.class, operationSpecificURL, requestBody, params);
    }

    private TypeDefGalleryResponse callTypeDefGalleryGetRESTCall(String methodName, String operationSpecificURL, Object ... params) throws RepositoryErrorException {
        return this.callGetRESTCall(methodName, TypeDefGalleryResponse.class, operationSpecificURL, params);
    }

    private TypeDefListResponse callTypeDefListGetRESTCall(String methodName, String operationSpecificURL, Object ... params) throws RepositoryErrorException {
        return this.callGetRESTCall(methodName, TypeDefListResponse.class, operationSpecificURL, params);
    }

    private TypeDefListResponse callTypeDefListPostRESTCall(String methodName, String operationSpecificURL, Object requestBody, Object ... params) throws RepositoryErrorException {
        return this.callPostRESTCall(methodName, TypeDefListResponse.class, operationSpecificURL, requestBody, params);
    }

    private TypeDefResponse callTypeDefGetRESTCall(String methodName, String operationSpecificURL, Object ... params) throws RepositoryErrorException {
        return this.callGetRESTCall(methodName, TypeDefResponse.class, operationSpecificURL, params);
    }

    private TypeDefResponse callTypeDefPostRESTCall(String methodName, String operationSpecificURL, Object requestBody, Object ... params) throws RepositoryErrorException {
        return this.callPostRESTCall(methodName, TypeDefResponse.class, operationSpecificURL, requestBody, params);
    }

    private VoidResponse callVoidPostRESTCall(String methodName, String operationSpecificURL, Object requestBody, Object ... params) throws RepositoryErrorException {
        return this.callPostRESTCall(methodName, VoidResponse.class, operationSpecificURL, requestBody, params);
    }

    private <T> T callGetRESTCall(String methodName, Class<T> returnClass, String operationSpecificURL) throws RepositoryErrorException {
        return this.callGetRESTCall(methodName, returnClass, operationSpecificURL, null);
    }

    private <T> T callGetRESTCall(String methodName, Class<T> returnClass, String operationSpecificURL, Object ... params) throws RepositoryErrorException {
        try {
            return (T)this.restClient.callGetRESTCall(methodName, returnClass, operationSpecificURL, params);
        }
        catch (Exception error) {
            throw new RepositoryErrorException(OMRSErrorCode.CLIENT_SIDE_REST_API_ERROR.getMessageDefinition(new String[]{methodName, this.repositoryName, error.getMessage()}), this.getClass().getName(), methodName, error);
        }
    }

    private <T> T callPostRESTCall(String methodName, Class<T> returnClass, String operationSpecificURL, Object request, Object ... params) throws RepositoryErrorException {
        try {
            return (T)this.restClient.callPostRESTCall(methodName, returnClass, operationSpecificURL, request, params);
        }
        catch (Exception error) {
            throw new RepositoryErrorException(OMRSErrorCode.CLIENT_SIDE_REST_API_ERROR.getMessageDefinition(new String[]{methodName, this.repositoryName, error.getMessage()}), this.getClass().getName(), methodName, error);
        }
    }

    private InstanceGraph getInstanceGraphFromRESTResult(InstanceGraphResponse restResult) {
        InstanceGraph instanceGraph = new InstanceGraph();
        instanceGraph.setEntities(restResult.getEntityElementList());
        instanceGraph.setRelationships(restResult.getRelationshipElementList());
        return instanceGraph;
    }

    private TypeDefGallery getTypeDefGalleryFromRESTResult(TypeDefGalleryResponse restResult) {
        TypeDefGallery typeDefGallery = new TypeDefGallery();
        typeDefGallery.setAttributeTypeDefs(restResult.getAttributeTypeDefs());
        typeDefGallery.setTypeDefs(restResult.getTypeDefs());
        return typeDefGallery;
    }

    private void detectAndThrowClassificationErrorException(String methodName, OMRSAPIResponse restResult) throws ClassificationErrorException {
        String exceptionClassName = ClassificationErrorException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            throw new ClassificationErrorException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionErrorMessageId(), restResult.getExceptionErrorMessageParameters(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), restResult.getExceptionCausedBy(), restResult.getExceptionProperties());
        }
    }

    private void detectAndThrowEntityConflictException(String methodName, OMRSAPIResponse restResult) throws EntityConflictException {
        String exceptionClassName = EntityConflictException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            throw new EntityConflictException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionErrorMessageId(), restResult.getExceptionErrorMessageParameters(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), restResult.getExceptionCausedBy(), restResult.getExceptionProperties());
        }
    }

    private void detectAndThrowEntityNotDeletedException(String methodName, OMRSAPIResponse restResult) throws EntityNotDeletedException {
        String exceptionClassName = EntityNotDeletedException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            throw new EntityNotDeletedException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionErrorMessageId(), restResult.getExceptionErrorMessageParameters(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), restResult.getExceptionCausedBy(), restResult.getExceptionProperties());
        }
    }

    private void detectAndThrowEntityNotKnownException(String methodName, OMRSAPIResponse restResult) throws EntityNotKnownException {
        String exceptionClassName = EntityNotKnownException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            throw new EntityNotKnownException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionErrorMessageId(), restResult.getExceptionErrorMessageParameters(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), restResult.getExceptionCausedBy(), restResult.getExceptionProperties());
        }
    }

    private void detectAndThrowEntityProxyOnlyException(String methodName, OMRSAPIResponse restResult) throws EntityProxyOnlyException {
        String exceptionClassName = EntityProxyOnlyException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            throw new EntityProxyOnlyException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionErrorMessageId(), restResult.getExceptionErrorMessageParameters(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), restResult.getExceptionCausedBy(), restResult.getExceptionProperties());
        }
    }

    private void detectAndThrowFunctionNotSupportedException(String methodName, OMRSAPIResponse restResult) throws FunctionNotSupportedException {
        String exceptionClassName = FunctionNotSupportedException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            throw new FunctionNotSupportedException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionErrorMessageId(), restResult.getExceptionErrorMessageParameters(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), restResult.getExceptionCausedBy(), restResult.getExceptionProperties());
        }
    }

    private void detectAndThrowHomeEntityException(String methodName, OMRSAPIResponse restResult) throws HomeEntityException {
        String exceptionClassName = HomeEntityException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            throw new HomeEntityException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionErrorMessageId(), restResult.getExceptionErrorMessageParameters(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), restResult.getExceptionCausedBy(), restResult.getExceptionProperties());
        }
    }

    private void detectAndThrowHomeRelationshipException(String methodName, OMRSAPIResponse restResult) throws HomeRelationshipException {
        String exceptionClassName = HomeRelationshipException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            throw new HomeRelationshipException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionErrorMessageId(), restResult.getExceptionErrorMessageParameters(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), restResult.getExceptionCausedBy(), restResult.getExceptionProperties());
        }
    }

    private void detectAndThrowInvalidEntityException(String methodName, OMRSAPIResponse restResult) throws InvalidEntityException {
        String exceptionClassName = InvalidEntityException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            throw new InvalidEntityException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionErrorMessageId(), restResult.getExceptionErrorMessageParameters(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), restResult.getExceptionCausedBy(), restResult.getExceptionProperties());
        }
    }

    protected void detectAndThrowInvalidParameterException(String methodName, OMRSAPIResponse restResult) throws InvalidParameterException, RepositoryErrorException {
        String exceptionClassName = InvalidParameterException.class.getName();
        String propertyName = "parameterName";
        String serverName = "serverName";
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            Object nameObject;
            String parameterName = null;
            Map exceptionProperties = restResult.getExceptionProperties();
            if (exceptionProperties != null && (nameObject = exceptionProperties.get("parameterName")) != null) {
                parameterName = (String)nameObject;
            }
            if ("serverName".equals(parameterName)) {
                throw new RepositoryErrorException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionErrorMessageId(), restResult.getExceptionErrorMessageParameters(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), restResult.getExceptionCausedBy(), restResult.getExceptionProperties());
            }
            throw new InvalidParameterException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionErrorMessageId(), restResult.getExceptionErrorMessageParameters(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), restResult.getExceptionCausedBy(), parameterName, restResult.getExceptionProperties());
        }
    }

    private void detectAndThrowInvalidRelationshipException(String methodName, OMRSAPIResponse restResult) throws InvalidRelationshipException {
        String exceptionClassName = InvalidRelationshipException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            throw new InvalidRelationshipException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionErrorMessageId(), restResult.getExceptionErrorMessageParameters(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), restResult.getExceptionCausedBy(), restResult.getExceptionProperties());
        }
    }

    private void detectAndThrowInvalidTypeDefException(String methodName, OMRSAPIResponse restResult) throws InvalidTypeDefException {
        String exceptionClassName = InvalidTypeDefException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            throw new InvalidTypeDefException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionErrorMessageId(), restResult.getExceptionErrorMessageParameters(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), restResult.getExceptionCausedBy(), restResult.getExceptionProperties());
        }
    }

    private void detectAndThrowPagingErrorException(String methodName, OMRSAPIResponse restResult) throws PagingErrorException {
        String exceptionClassName = PagingErrorException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            throw new PagingErrorException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionErrorMessageId(), restResult.getExceptionErrorMessageParameters(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), restResult.getExceptionCausedBy(), restResult.getExceptionProperties());
        }
    }

    private void detectAndThrowPatchErrorException(String methodName, OMRSAPIResponse restResult) throws PatchErrorException {
        String exceptionClassName = PatchErrorException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            throw new PatchErrorException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionErrorMessageId(), restResult.getExceptionErrorMessageParameters(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), restResult.getExceptionCausedBy(), restResult.getExceptionProperties());
        }
    }

    private void detectAndThrowPropertyErrorException(String methodName, OMRSAPIResponse restResult) throws PropertyErrorException {
        String exceptionClassName = PropertyErrorException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            throw new PropertyErrorException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionErrorMessageId(), restResult.getExceptionErrorMessageParameters(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), restResult.getExceptionCausedBy(), restResult.getExceptionProperties());
        }
    }

    private void detectAndThrowRelationshipConflictException(String methodName, OMRSAPIResponse restResult) throws RelationshipConflictException {
        String exceptionClassName = RelationshipConflictException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            throw new RelationshipConflictException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionErrorMessageId(), restResult.getExceptionErrorMessageParameters(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), restResult.getExceptionCausedBy(), restResult.getExceptionProperties());
        }
    }

    private void detectAndThrowRelationshipNotDeletedException(String methodName, OMRSAPIResponse restResult) throws RelationshipNotDeletedException {
        String exceptionClassName = RelationshipNotDeletedException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            throw new RelationshipNotDeletedException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionErrorMessageId(), restResult.getExceptionErrorMessageParameters(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), restResult.getExceptionCausedBy(), restResult.getExceptionProperties());
        }
    }

    private void detectAndThrowRelationshipNotKnownException(String methodName, OMRSAPIResponse restResult) throws RelationshipNotKnownException {
        String exceptionClassName = RelationshipNotKnownException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            throw new RelationshipNotKnownException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionErrorMessageId(), restResult.getExceptionErrorMessageParameters(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), restResult.getExceptionCausedBy(), restResult.getExceptionProperties());
        }
    }

    private void detectAndThrowStatusNotSupportedException(String methodName, OMRSAPIResponse restResult) throws StatusNotSupportedException {
        String exceptionClassName = StatusNotSupportedException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            throw new StatusNotSupportedException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionErrorMessageId(), restResult.getExceptionErrorMessageParameters(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), restResult.getExceptionCausedBy(), restResult.getExceptionProperties());
        }
    }

    private void detectAndThrowTypeDefConflictException(String methodName, OMRSAPIResponse restResult) throws TypeDefConflictException {
        String exceptionClassName = TypeDefConflictException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            throw new TypeDefConflictException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionErrorMessageId(), restResult.getExceptionErrorMessageParameters(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), restResult.getExceptionCausedBy(), restResult.getExceptionProperties());
        }
    }

    private void detectAndThrowTypeDefInUseException(String methodName, OMRSAPIResponse restResult) throws TypeDefInUseException {
        String exceptionClassName = TypeDefInUseException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            throw new TypeDefInUseException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionErrorMessageId(), restResult.getExceptionErrorMessageParameters(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), restResult.getExceptionCausedBy(), restResult.getExceptionProperties());
        }
    }

    private void detectAndThrowTypeDefKnownException(String methodName, OMRSAPIResponse restResult) throws TypeDefKnownException {
        String exceptionClassName = TypeDefKnownException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            throw new TypeDefKnownException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionErrorMessageId(), restResult.getExceptionErrorMessageParameters(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), restResult.getExceptionCausedBy(), restResult.getExceptionProperties());
        }
    }

    private void detectAndThrowTypeDefNotKnownException(String methodName, OMRSAPIResponse restResult) throws TypeDefNotKnownException {
        String exceptionClassName = TypeDefNotKnownException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            throw new TypeDefNotKnownException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionErrorMessageId(), restResult.getExceptionErrorMessageParameters(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), restResult.getExceptionCausedBy(), restResult.getExceptionProperties());
        }
    }

    private void detectAndThrowTypeDefNotSupportedException(String methodName, OMRSAPIResponse restResult) throws TypeDefNotSupportedException {
        String exceptionClassName = TypeDefNotSupportedException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            throw new TypeDefNotSupportedException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionErrorMessageId(), restResult.getExceptionErrorMessageParameters(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), restResult.getExceptionCausedBy(), restResult.getExceptionProperties());
        }
    }

    private void detectAndThrowTypeErrorException(String methodName, OMRSAPIResponse restResult) throws TypeErrorException {
        String exceptionClassName = TypeErrorException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            throw new TypeErrorException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionErrorMessageId(), restResult.getExceptionErrorMessageParameters(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), restResult.getExceptionCausedBy(), restResult.getExceptionProperties());
        }
    }

    protected void detectAndThrowUserNotAuthorizedException(String methodName, OMRSAPIResponse restResult) throws UserNotAuthorizedException {
        String exceptionClassName = UserNotAuthorizedException.class.getName();
        if (restResult != null && exceptionClassName.equals(restResult.getExceptionClassName())) {
            String userId = null;
            if (restResult.getExceptionProperties() != null) {
                userId = (String)restResult.getExceptionProperties().get("userId");
            }
            throw new UserNotAuthorizedException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionErrorMessageId(), restResult.getExceptionErrorMessageParameters(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), restResult.getExceptionCausedBy(), userId, restResult.getExceptionProperties());
        }
    }

    protected void detectAndThrowRepositoryErrorException(String methodName, OMRSAPIResponse restResult) throws RepositoryErrorException {
        if (restResult == null) {
            throw new RepositoryErrorException(OMRSErrorCode.NULL_RESPONSE_FROM_API.getMessageDefinition(new String[]{methodName, this.repositoryName}), this.getClass().getName(), methodName);
        }
        if (restResult.getExceptionClassName() != null) {
            throw new RepositoryErrorException(restResult.getRelatedHTTPCode(), this.getClass().getName(), methodName, restResult.getExceptionErrorMessage(), restResult.getExceptionErrorMessageId(), restResult.getExceptionErrorMessageParameters(), restResult.getExceptionSystemAction(), restResult.getExceptionUserAction(), restResult.getExceptionCausedBy(), restResult.getExceptionProperties());
        }
    }
}

