/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.archivemanager;

import java.util.HashMap;
import java.util.Map;
import org.odpi.openmetadata.repositoryservices.archivemanager.opentypes.OpenMetadataTypesArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveTypeStore;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;

public class OMRSArchiveAccessor {
    private final Map<String, EntityDef> entityDefs = new HashMap<String, EntityDef>();
    private final Map<String, ClassificationDef> classificationDefs = new HashMap<String, ClassificationDef>();
    private final Map<String, RelationshipDef> relationshipDefs = new HashMap<String, RelationshipDef>();
    private final Map<String, EnumDef> enumDefs = new HashMap<String, EnumDef>();
    OpenMetadataTypesArchive openMetadataTypesArchive = null;
    OpenMetadataArchiveTypeStore typeStore = null;
    private static OMRSArchiveAccessor instance = null;

    public static OMRSArchiveAccessor getInstance() {
        if (instance == null) {
            instance = new OMRSArchiveAccessor(new OpenMetadataTypesArchive());
        }
        return instance;
    }

    private OMRSArchiveAccessor(OpenMetadataTypesArchive openMetadataTypesArchive) {
        this.openMetadataTypesArchive = openMetadataTypesArchive;
        this.typeStore = this.openMetadataTypesArchive.getOpenMetadataArchive().getArchiveTypeStore();
        for (TypeDef omTypeDef : this.typeStore.getNewTypeDefs()) {
            switch (omTypeDef.getCategory()) {
                case ENTITY_DEF: {
                    this.entityDefs.put(omTypeDef.getName(), (EntityDef)omTypeDef);
                    break;
                }
                case CLASSIFICATION_DEF: {
                    this.classificationDefs.put(omTypeDef.getName(), (ClassificationDef)omTypeDef);
                    break;
                }
                case RELATIONSHIP_DEF: {
                    this.relationshipDefs.put(omTypeDef.getName(), (RelationshipDef)omTypeDef);
                }
            }
        }
        for (AttributeTypeDef omAttrTypeDef : this.typeStore.getAttributeTypeDefs()) {
            switch (omAttrTypeDef.getCategory()) {
                case ENUM_DEF: {
                    this.enumDefs.put(omAttrTypeDef.getName(), (EnumDef)omAttrTypeDef);
                    break;
                }
                case PRIMITIVE: {
                    break;
                }
            }
        }
    }

    public EntityDef getEntityDefByName(String typeName) {
        return this.entityDefs.get(typeName);
    }
}

