/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.localrepository.repositoryconnector;

import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditCode;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditingComponent;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceGraph;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryeventmapper.OMRSRepositoryEventProcessor;
import org.odpi.openmetadata.repositoryservices.eventmanagement.OMRSRepositoryEventExchangeRule;
import org.odpi.openmetadata.repositoryservices.events.OMRSEventOriginator;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEventErrorCode;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEventProcessor;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEventType;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;
import org.odpi.openmetadata.repositoryservices.localrepository.repositoryconnector.OMRSInstanceRetrievalEventProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalOMRSInstanceEventProcessor
implements OMRSInstanceEventProcessor,
OMRSInstanceRetrievalEventProcessor {
    private String localMetadataCollectionId;
    private String localServerName;
    private OMRSRepositoryConnector realLocalConnector;
    private OMRSRepositoryHelper repositoryHelper;
    private OMRSRepositoryValidator repositoryValidator;
    private OMRSRepositoryEventExchangeRule saveExchangeRule;
    private String realRepositoryName = "Local Repository";
    private OMRSMetadataCollection realMetadataCollection = null;
    private OMRSRepositoryEventProcessor outboundRepositoryEventProcessor = null;
    private static final OMRSAuditLog auditLog = new OMRSAuditLog(OMRSAuditingComponent.INSTANCE_EVENT_PROCESSOR);
    private static final Logger log = LoggerFactory.getLogger(LocalOMRSInstanceEventProcessor.class);

    LocalOMRSInstanceEventProcessor(String localMetadataCollectionId, String localServerName, OMRSRepositoryConnector realLocalConnector, OMRSRepositoryHelper repositoryHelper, OMRSRepositoryValidator repositoryValidator, OMRSRepositoryEventExchangeRule saveExchangeRule, OMRSRepositoryEventProcessor outboundRepositoryEventProcessor) {
        String methodName = "LocalOMRSInstanceEventProcessor constructor";
        this.localMetadataCollectionId = localMetadataCollectionId;
        this.localServerName = localServerName;
        this.realLocalConnector = realLocalConnector;
        this.repositoryHelper = repositoryHelper;
        this.repositoryValidator = repositoryValidator;
        this.saveExchangeRule = saveExchangeRule;
        this.outboundRepositoryEventProcessor = outboundRepositoryEventProcessor;
        if (realLocalConnector != null) {
            try {
                this.realMetadataCollection = realLocalConnector.getMetadataCollection();
            }
            catch (Throwable error) {
                this.realMetadataCollection = null;
            }
        }
        this.verifyEventProcessor("LocalOMRSInstanceEventProcessor constructor");
        ConnectionProperties connection = this.realLocalConnector.getConnection();
        if (connection != null) {
            this.realRepositoryName = connection.getConnectionName();
        }
    }

    public void sendInstanceEvent(String cohortName, OMRSInstanceEvent instanceEvent) {
        OMRSInstanceEventType instanceEventType = instanceEvent.getInstanceEventType();
        OMRSEventOriginator instanceEventOriginator = instanceEvent.getEventOriginator();
        if (instanceEventType != null && instanceEventOriginator != null) {
            block0 : switch (instanceEventType) {
                case NEW_ENTITY_EVENT: {
                    this.processNewEntityEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getEntity());
                    break;
                }
                case UPDATED_ENTITY_EVENT: {
                    this.processUpdatedEntityEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getOriginalEntity(), instanceEvent.getEntity());
                    break;
                }
                case CLASSIFIED_ENTITY_EVENT: {
                    this.processClassifiedEntityEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getEntity());
                    break;
                }
                case RECLASSIFIED_ENTITY_EVENT: {
                    this.processReclassifiedEntityEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getEntity());
                    break;
                }
                case DECLASSIFIED_ENTITY_EVENT: {
                    this.processDeclassifiedEntityEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getEntity());
                    break;
                }
                case DELETED_ENTITY_EVENT: {
                    this.processDeletedEntityEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getEntity());
                    break;
                }
                case PURGED_ENTITY_EVENT: {
                    this.processPurgedEntityEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getTypeDefGUID(), instanceEvent.getTypeDefName(), instanceEvent.getInstanceGUID());
                    break;
                }
                case UNDONE_ENTITY_EVENT: {
                    this.processUndoneEntityEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getEntity());
                    break;
                }
                case RESTORED_ENTITY_EVENT: {
                    this.processRestoredEntityEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getEntity());
                    break;
                }
                case REFRESH_ENTITY_REQUEST: {
                    this.processRefreshEntityRequested(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getTypeDefGUID(), instanceEvent.getTypeDefName(), instanceEvent.getInstanceGUID(), instanceEvent.getHomeMetadataCollectionId());
                    break;
                }
                case REFRESHED_ENTITY_EVENT: {
                    this.processRefreshEntityEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getEntity());
                    break;
                }
                case RE_HOMED_ENTITY_EVENT: {
                    this.processReHomedEntityEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getOriginalHomeMetadataCollectionId(), instanceEvent.getEntity());
                    break;
                }
                case RETYPED_ENTITY_EVENT: {
                    this.processReTypedEntityEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getOriginalTypeDefSummary(), instanceEvent.getEntity());
                    break;
                }
                case RE_IDENTIFIED_ENTITY_EVENT: {
                    this.processReIdentifiedEntityEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getOriginalInstanceGUID(), instanceEvent.getEntity());
                    break;
                }
                case NEW_RELATIONSHIP_EVENT: {
                    this.processNewRelationshipEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getRelationship());
                    break;
                }
                case UPDATED_RELATIONSHIP_EVENT: {
                    this.processUpdatedRelationshipEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getOriginalRelationship(), instanceEvent.getRelationship());
                    break;
                }
                case UNDONE_RELATIONSHIP_EVENT: {
                    this.processUndoneRelationshipEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getRelationship());
                    break;
                }
                case DELETED_RELATIONSHIP_EVENT: {
                    this.processDeletedRelationshipEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getRelationship());
                    break;
                }
                case PURGED_RELATIONSHIP_EVENT: {
                    this.processPurgedEntityEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getTypeDefGUID(), instanceEvent.getTypeDefName(), instanceEvent.getInstanceGUID());
                    break;
                }
                case RESTORED_RELATIONSHIP_EVENT: {
                    this.processRestoredRelationshipEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getRelationship());
                    break;
                }
                case REFRESH_RELATIONSHIP_REQUEST: {
                    this.processRefreshRelationshipRequest(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getTypeDefGUID(), instanceEvent.getTypeDefName(), instanceEvent.getInstanceGUID(), instanceEvent.getHomeMetadataCollectionId());
                    break;
                }
                case REFRESHED_RELATIONSHIP_EVENT: {
                    this.processRefreshRelationshipEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getRelationship());
                    break;
                }
                case RE_IDENTIFIED_RELATIONSHIP_EVENT: {
                    this.processReIdentifiedRelationshipEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getOriginalInstanceGUID(), instanceEvent.getRelationship());
                    break;
                }
                case RE_HOMED_RELATIONSHIP_EVENT: {
                    this.processReHomedRelationshipEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getOriginalHomeMetadataCollectionId(), instanceEvent.getRelationship());
                    break;
                }
                case RETYPED_RELATIONSHIP_EVENT: {
                    this.processReTypedRelationshipEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getOriginalTypeDefSummary(), instanceEvent.getRelationship());
                    break;
                }
                case INSTANCE_ERROR_EVENT: {
                    OMRSInstanceEventErrorCode errorCode = instanceEvent.getErrorCode();
                    if (errorCode != null) {
                        switch (errorCode) {
                            case CONFLICTING_INSTANCES: {
                                this.processConflictingInstancesEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getTargetMetadataCollectionId(), instanceEvent.getTargetTypeDefSummary(), instanceEvent.getTargetInstanceGUID(), instanceEvent.getOtherMetadataCollectionId(), instanceEvent.getOtherOrigin(), instanceEvent.getOtherTypeDefSummary(), instanceEvent.getOtherInstanceGUID(), instanceEvent.getErrorMessage());
                                break block0;
                            }
                            case CONFLICTING_TYPE: {
                                this.processConflictingTypeEvent(cohortName, instanceEventOriginator.getMetadataCollectionId(), instanceEventOriginator.getServerName(), instanceEventOriginator.getServerType(), instanceEventOriginator.getOrganizationName(), instanceEvent.getTargetMetadataCollectionId(), instanceEvent.getTargetTypeDefSummary(), instanceEvent.getTargetInstanceGUID(), instanceEvent.getOtherTypeDefSummary(), instanceEvent.getErrorMessage());
                                break block0;
                            }
                        }
                        log.debug("Unknown instance event error code, ignoring event");
                        break;
                    }
                    log.debug("Ignored Instance event, null error code");
                    break;
                }
                default: {
                    log.debug("Ignored Instance event, unknown type");
                    break;
                }
            }
        } else {
            log.debug("Ignored instance event, null type");
        }
    }

    public void processNewEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processNewEntityEvent";
        String entityParameterName = "entity";
        this.updateReferenceEntity(sourceName, "processNewEntityEvent", "entity", originatorMetadataCollectionId, originatorServerName, entity);
    }

    public void processUpdatedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail oldEntity, EntityDetail newEntity) {
        String methodName = "processUpdatedEntityEvent";
        String entityParameterName = "entity";
        this.updateReferenceEntity(sourceName, "processUpdatedEntityEvent", "entity", originatorMetadataCollectionId, originatorServerName, newEntity);
    }

    public void processUndoneEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processUndoneEntityEvent";
        String entityParameterName = "entity";
        this.updateReferenceEntity(sourceName, "processUndoneEntityEvent", "entity", originatorMetadataCollectionId, originatorServerName, entity);
    }

    public void processClassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processClassifiedEntityEvent";
        String entityParameterName = "entity";
        this.updateReferenceEntity(sourceName, "processClassifiedEntityEvent", "entity", originatorMetadataCollectionId, originatorServerName, entity);
    }

    public void processDeclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processDeclassifiedEntityEvent";
        String entityParameterName = "entity";
        this.updateReferenceEntity(sourceName, "processDeclassifiedEntityEvent", "entity", originatorMetadataCollectionId, originatorServerName, entity);
    }

    public void processReclassifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processReclassifiedEntityEvent";
        String entityParameterName = "entity";
        this.updateReferenceEntity(sourceName, "processReclassifiedEntityEvent", "entity", originatorMetadataCollectionId, originatorServerName, entity);
    }

    public void processDeletedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processDeletedEntityEvent";
        String entityParameterName = "entity";
        this.updateReferenceEntity(sourceName, "processDeletedEntityEvent", "entity", originatorMetadataCollectionId, originatorServerName, entity);
    }

    public void processPurgedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String typeDefGUID, String typeDefName, String instanceGUID) {
        String methodName = "processPurgedEntityEvent";
        this.purgeReferenceInstance(sourceName, "processPurgedEntityEvent", originatorMetadataCollectionId, originatorServerName, typeDefGUID, typeDefName, instanceGUID);
    }

    public void processRestoredEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processRestoredEntityEvent";
        String entityParameterName = "entity";
        this.updateReferenceEntity(sourceName, "processRestoredEntityEvent", "entity", originatorMetadataCollectionId, originatorServerName, entity);
    }

    public void processReIdentifiedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalEntityGUID, EntityDetail entity) {
        String methodName = "processReIdentifiedEntityEvent";
        String entityParameterName = "entity";
        this.updateReferenceEntity(sourceName, "processReIdentifiedEntityEvent", "entity", originatorMetadataCollectionId, originatorServerName, entity);
    }

    public void processReTypedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDefSummary originalTypeDefSummary, EntityDetail entity) {
        String methodName = "processReTypedEntityEvent";
        String entityParameterName = "entity";
        this.updateReferenceEntity(sourceName, "processReTypedEntityEvent", "entity", originatorMetadataCollectionId, originatorServerName, entity);
    }

    public void processReHomedEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalHomeMetadataCollectionId, EntityDetail entity) {
        String methodName = "processReHomedEntityEvent";
        String entityParameterName = "entity";
        this.updateReferenceEntity(sourceName, "processReHomedEntityEvent", "entity", originatorMetadataCollectionId, originatorServerName, entity);
    }

    public void processRefreshEntityRequested(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String typeDefGUID, String typeDefName, String instanceGUID, String homeMetadataCollectionId) {
        String methodName = "processRefreshEntityRequested";
        try {
            this.verifyEventProcessor("processRefreshEntityRequested");
            this.realMetadataCollection.refreshEntityReferenceCopy(sourceName, instanceGUID, typeDefGUID, typeDefName, originatorMetadataCollectionId);
        }
        catch (Throwable error) {
            OMRSAuditCode auditCode = OMRSAuditCode.UNEXPECTED_EXCEPTION_FROM_EVENT;
            auditLog.logRecord("processRefreshEntityRequested", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{"processRefreshEntityRequested", originatorServerName, originatorMetadataCollectionId, error.getMessage()}), null, auditCode.getSystemAction(), auditCode.getUserAction());
        }
    }

    public void processRefreshEntityEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, EntityDetail entity) {
        String methodName = "processReHomedEntityEvent";
        String entityParameterName = "entity";
        this.updateReferenceEntity(sourceName, "processReHomedEntityEvent", "entity", originatorMetadataCollectionId, originatorServerName, entity);
    }

    public void processNewRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processNewRelationshipEvent";
        String entityParameterName = "relationship";
        this.updateReferenceRelationship(sourceName, "processNewRelationshipEvent", "relationship", originatorMetadataCollectionId, originatorServerName, relationship);
    }

    public void processUpdatedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship oldRelationship, Relationship newRelationship) {
        String methodName = "processUpdatedRelationshipEvent";
        String entityParameterName = "relationship";
        this.updateReferenceRelationship(sourceName, "processUpdatedRelationshipEvent", "relationship", originatorMetadataCollectionId, originatorServerName, newRelationship);
    }

    public void processUndoneRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processUndoneRelationshipEvent";
        String entityParameterName = "relationship";
        this.updateReferenceRelationship(sourceName, "processUndoneRelationshipEvent", "relationship", originatorMetadataCollectionId, originatorServerName, relationship);
    }

    public void processDeletedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processDeletedRelationshipEvent";
        String entityParameterName = "relationship";
        this.updateReferenceRelationship(sourceName, "processDeletedRelationshipEvent", "relationship", originatorMetadataCollectionId, originatorServerName, relationship);
    }

    public void processPurgedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String typeDefGUID, String typeDefName, String instanceGUID) {
        String methodName = "processPurgedRelationshipEvent";
        this.purgeReferenceInstance(sourceName, "processPurgedRelationshipEvent", originatorMetadataCollectionId, originatorServerName, typeDefGUID, typeDefName, instanceGUID);
    }

    public void processRestoredRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processRestoredRelationshipEvent";
        String entityParameterName = "relationship";
        this.updateReferenceRelationship(sourceName, "processRestoredRelationshipEvent", "relationship", originatorMetadataCollectionId, originatorServerName, relationship);
    }

    public void processReIdentifiedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalRelationshipGUID, Relationship relationship) {
        String methodName = "processReIdentifiedRelationshipEvent";
        String entityParameterName = "relationship";
        this.updateReferenceRelationship(sourceName, "processReIdentifiedRelationshipEvent", "relationship", originatorMetadataCollectionId, originatorServerName, relationship);
    }

    public void processReTypedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDefSummary originalTypeDefSummary, Relationship relationship) {
        String methodName = "processReTypedRelationshipEvent";
        String entityParameterName = "relationship";
        this.updateReferenceRelationship(sourceName, "processReTypedRelationshipEvent", "relationship", originatorMetadataCollectionId, originatorServerName, relationship);
    }

    public void processReHomedRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String originalHomeMetadataCollection, Relationship relationship) {
        String methodName = "processReHomedRelationshipEvent";
        String entityParameterName = "relationship";
        this.updateReferenceRelationship(sourceName, "processReHomedRelationshipEvent", "relationship", originatorMetadataCollectionId, originatorServerName, relationship);
    }

    public void processRefreshRelationshipRequest(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String typeDefGUID, String typeDefName, String instanceGUID, String homeMetadataCollectionId) {
        String methodName = "processRefreshRelationshipRequest";
        try {
            this.verifyEventProcessor("processRefreshRelationshipRequest");
            this.realMetadataCollection.refreshRelationshipReferenceCopy(sourceName, instanceGUID, typeDefGUID, typeDefName, originatorMetadataCollectionId);
        }
        catch (Throwable error) {
            OMRSAuditCode auditCode = OMRSAuditCode.UNEXPECTED_EXCEPTION_FROM_EVENT;
            auditLog.logRecord("processRefreshRelationshipRequest", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{"processRefreshRelationshipRequest", originatorServerName, originatorMetadataCollectionId, error.getMessage()}), null, auditCode.getSystemAction(), auditCode.getUserAction());
        }
    }

    public void processRefreshRelationshipEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, Relationship relationship) {
        String methodName = "processRefreshRelationshipEvent";
        String relationshipParameterName = "relationship";
        this.updateReferenceRelationship(sourceName, "processRefreshRelationshipEvent", "relationship", originatorMetadataCollectionId, originatorServerName, relationship);
    }

    public void processInstanceBatchEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, InstanceGraph instances) {
        String methodName = "processInstanceBatchEvent";
        try {
            this.verifyEventProcessor("processInstanceBatchEvent");
            this.realMetadataCollection.saveInstanceReferenceCopies(sourceName, instances);
        }
        catch (Throwable error) {
            OMRSAuditCode auditCode = OMRSAuditCode.UNEXPECTED_EXCEPTION_FROM_EVENT;
            auditLog.logRecord("processInstanceBatchEvent", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{"processInstanceBatchEvent", originatorServerName, originatorMetadataCollectionId, error.getMessage()}), null, auditCode.getSystemAction(), auditCode.getUserAction());
        }
    }

    public void processConflictingInstancesEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String targetMetadataCollectionId, TypeDefSummary targetTypeDefSummary, String targetInstanceGUID, String otherMetadataCollectionId, InstanceProvenanceType otherOrigin, TypeDefSummary otherTypeDefSummary, String otherInstanceGUID, String errorMessage) {
    }

    public void processConflictingTypeEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String targetMetadataCollectionId, TypeDefSummary targetTypeDefSummary, String targetInstanceGUID, TypeDefSummary otherTypeDefSummary, String errorMessage) {
    }

    public void refreshRetrievedEntity(String sourceName, String metadataCollectionId, String processedEntityGUID, InstanceType processedEntityType) {
        try {
            if (this.realMetadataCollection.isEntityKnown(sourceName, processedEntityGUID) == null && processedEntityType != null) {
                this.realMetadataCollection.refreshEntityReferenceCopy(this.localServerName, processedEntityGUID, processedEntityType.getTypeDefGUID(), processedEntityType.getTypeDefName(), metadataCollectionId);
            }
        }
        catch (Throwable error) {
            String methodName = "processRetrievedEntity";
            OMRSAuditCode auditCode = OMRSAuditCode.UNEXPECTED_EXCEPTION_FROM_EVENT;
            auditLog.logRecord("processRetrievedEntity", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{"processRetrievedEntity", sourceName, metadataCollectionId, error.getMessage()}), null, auditCode.getSystemAction(), auditCode.getUserAction());
        }
    }

    @Override
    public void processRetrievedEntitySummary(String sourceName, String metadataCollectionId, EntitySummary processedEntity) {
        if (this.verifyEventToLearn(sourceName, (InstanceHeader)processedEntity)) {
            this.refreshRetrievedEntity(sourceName, metadataCollectionId, processedEntity.getGUID(), processedEntity.getType());
        }
    }

    @Override
    public void processRetrievedEntityDetail(String sourceName, String metadataCollectionId, EntityDetail processedEntity) {
        if (this.verifyEventToLearn(sourceName, (InstanceHeader)processedEntity)) {
            this.refreshRetrievedEntity(sourceName, metadataCollectionId, processedEntity.getGUID(), processedEntity.getType());
        }
    }

    @Override
    public void processRetrievedRelationship(String sourceName, String metadataCollectionId, Relationship processedRelationship) {
        if (this.verifyEventToLearn(sourceName, (InstanceHeader)processedRelationship)) {
            try {
                InstanceType type;
                if (this.realMetadataCollection.isRelationshipKnown(sourceName, processedRelationship.getGUID()) == null && (type = processedRelationship.getType()) != null) {
                    this.realMetadataCollection.refreshRelationshipReferenceCopy(this.localServerName, processedRelationship.getGUID(), type.getTypeDefGUID(), type.getTypeDefName(), metadataCollectionId);
                }
            }
            catch (Throwable error) {
                String methodName = "processRetrievedRelationship";
                OMRSAuditCode auditCode = OMRSAuditCode.UNEXPECTED_EXCEPTION_FROM_EVENT;
                auditLog.logRecord("processRetrievedRelationship", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{"processRetrievedRelationship", sourceName, metadataCollectionId, error.getMessage()}), null, auditCode.getSystemAction(), auditCode.getUserAction());
            }
        }
    }

    private void updateReferenceEntity(String sourceName, String methodName, String entityParameterName, String originatorMetadataCollectionId, String originatorServerName, EntityDetail entity) {
        try {
            this.verifyEventProcessor(methodName);
            this.repositoryValidator.validateReferenceInstanceHeader(this.realRepositoryName, this.localMetadataCollectionId, entityParameterName, (InstanceHeader)entity, methodName);
            if (this.verifyEventToSave(sourceName, (InstanceHeader)entity)) {
                this.realMetadataCollection.saveEntityReferenceCopy(sourceName, entity);
            }
        }
        catch (Throwable error) {
            OMRSAuditCode auditCode = OMRSAuditCode.UNEXPECTED_EXCEPTION_FROM_EVENT;
            auditLog.logRecord(methodName, auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{methodName, originatorServerName, originatorMetadataCollectionId, error.getMessage()}), null, auditCode.getSystemAction(), auditCode.getUserAction());
        }
    }

    private void updateReferenceRelationship(String sourceName, String methodName, String relationshipParameterName, String originatorMetadataCollectionId, String originatorServerName, Relationship relationship) {
        try {
            this.verifyEventProcessor(methodName);
            this.repositoryValidator.validateReferenceInstanceHeader(this.realRepositoryName, this.localMetadataCollectionId, relationshipParameterName, (InstanceHeader)relationship, methodName);
            if (this.verifyEventToSave(sourceName, (InstanceHeader)relationship)) {
                this.realMetadataCollection.saveRelationshipReferenceCopy(sourceName, relationship);
            }
        }
        catch (Throwable error) {
            OMRSAuditCode auditCode = OMRSAuditCode.UNEXPECTED_EXCEPTION_FROM_EVENT;
            auditLog.logRecord(methodName, auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{methodName, originatorServerName, originatorMetadataCollectionId, error.getMessage()}), null, auditCode.getSystemAction(), auditCode.getUserAction());
        }
    }

    private void purgeReferenceInstance(String sourceName, String methodName, String originatorMetadataCollectionId, String originatorServerName, String typeDefGUID, String typeDefName, String instanceGUID) {
        try {
            this.verifyEventProcessor(methodName);
            this.realMetadataCollection.purgeEntityReferenceCopy(sourceName, instanceGUID, typeDefGUID, typeDefName, originatorMetadataCollectionId);
        }
        catch (Throwable error) {
            OMRSAuditCode auditCode = OMRSAuditCode.UNEXPECTED_EXCEPTION_FROM_EVENT;
            auditLog.logRecord(methodName, auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{methodName, originatorServerName, originatorMetadataCollectionId, error.getMessage()}), null, auditCode.getSystemAction(), auditCode.getUserAction());
        }
    }

    private void verifyEventProcessor(String methodName) {
        if (this.localMetadataCollectionId == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_LOCAL_METADATA_COLLECTION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[0]);
            throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (this.realLocalConnector == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NO_LOCAL_REPOSITORY;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[0]);
            throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (this.realMetadataCollection == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_LOCAL_METADATA_COLLECTION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[0]);
            throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (this.repositoryHelper == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_REPOSITORY_HELPER;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[0]);
            throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (this.repositoryValidator == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_REPOSITORY_VALIDATOR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[0]);
            throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (this.saveExchangeRule == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_EXCHANGE_RULE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
            throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (this.realMetadataCollection == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_METADATA_COLLECTION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{this.realRepositoryName});
            throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    private boolean verifyEventToSave(String source, InstanceHeader instance) {
        InstanceType instanceType = instance.getType();
        return this.saveExchangeRule.processInstanceEvent(instance) && this.repositoryValidator.isActiveType(source, instanceType.getTypeDefGUID(), instanceType.getTypeDefName());
    }

    private boolean verifyEventToLearn(String source, InstanceHeader instance) {
        InstanceType instanceType = instance.getType();
        return this.saveExchangeRule.learnInstanceEvent(instance) && this.repositoryValidator.isActiveType(source, instanceType.getTypeDefGUID(), instanceType.getTypeDefName());
    }
}

