/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.localrepository.repositoryconnector;

import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryeventmapper.OMRSRepositoryEventMapperConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryeventmapper.OMRSRepositoryEventProcessor;
import org.odpi.openmetadata.repositoryservices.eventmanagement.OMRSRepositoryEventExchangeRule;
import org.odpi.openmetadata.repositoryservices.eventmanagement.OMRSRepositoryEventManager;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEventProcessor;
import org.odpi.openmetadata.repositoryservices.events.OMRSTypeDefEventProcessor;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.localrepository.OMRSLocalRepository;
import org.odpi.openmetadata.repositoryservices.localrepository.repositoryconnector.LocalOMRSInstanceEventProcessor;
import org.odpi.openmetadata.repositoryservices.localrepository.repositoryconnector.LocalOMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.localrepository.repositoryconnector.OMRSInstanceRetrievalEventProcessor;
import org.odpi.openmetadata.repositoryservices.localrepository.repositorycontentmanager.OMRSRepositoryContentHelper;
import org.odpi.openmetadata.repositoryservices.localrepository.repositorycontentmanager.OMRSRepositoryContentManager;
import org.odpi.openmetadata.repositoryservices.localrepository.repositorycontentmanager.OMRSRepositoryContentValidator;
import org.odpi.openmetadata.repositoryservices.localrepository.repositorycontentmanager.OMRSTypeDefManager;

public class LocalOMRSRepositoryConnector
extends OMRSRepositoryConnector
implements OMRSLocalRepository {
    private static final String repositoryEventMapperName = "LocalRepositoryEventMapper";
    private static final String repositoryName = "LocalRepository";
    private OMRSTypeDefManager typeDefManager;
    private OMRSTypeDefEventProcessor incomingTypeDefEventProcessor;
    private OMRSInstanceEventProcessor incomingInstanceEventProcessor = null;
    private OMRSInstanceRetrievalEventProcessor instanceRetrievalEventProcessor = null;
    private OMRSRepositoryEventProcessor outboundRepositoryEventProcessor = null;
    private OMRSRepositoryEventManager outboundRepositoryEventManager;
    private OMRSRepositoryEventExchangeRule saveExchangeRule;
    private OMRSRepositoryConnector realLocalConnector;
    private OMRSRepositoryEventMapperConnector realEventMapper;

    protected LocalOMRSRepositoryConnector(OMRSRepositoryConnector realLocalConnector, OMRSRepositoryEventMapperConnector realEventMapper, OMRSRepositoryEventManager outboundRepositoryEventManager, OMRSRepositoryContentManager repositoryContentManager, OMRSRepositoryEventExchangeRule saveExchangeRule) {
        this.realLocalConnector = realLocalConnector;
        this.realEventMapper = realEventMapper;
        this.outboundRepositoryEventManager = outboundRepositoryEventManager;
        this.saveExchangeRule = saveExchangeRule;
        this.typeDefManager = repositoryContentManager;
        this.incomingTypeDefEventProcessor = repositoryContentManager;
        if (repositoryContentManager != null) {
            repositoryContentManager.setupEventProcessor(this, realLocalConnector, saveExchangeRule, outboundRepositoryEventManager);
        }
        if (realEventMapper != null) {
            realEventMapper.initialize(repositoryEventMapperName, realLocalConnector);
            realEventMapper.setRepositoryEventProcessor((OMRSRepositoryEventProcessor)outboundRepositoryEventManager);
        } else {
            this.outboundRepositoryEventProcessor = outboundRepositoryEventManager;
        }
    }

    public void start() throws ConnectorCheckedException {
        super.start();
        if (this.realLocalConnector != null) {
            this.realLocalConnector.start();
        }
        if (this.realEventMapper != null) {
            this.realEventMapper.start();
        }
    }

    public void disconnect() throws ConnectorCheckedException {
        super.disconnect();
        if (this.realLocalConnector != null) {
            this.realLocalConnector.disconnect();
        }
        if (this.realEventMapper != null) {
            this.realEventMapper.disconnect();
        }
    }

    public void setRepositoryHelper(OMRSRepositoryContentHelper repositoryHelper) {
        super.setRepositoryHelper((OMRSRepositoryHelper)repositoryHelper);
        if (this.realLocalConnector != null) {
            this.realLocalConnector.setRepositoryHelper((OMRSRepositoryHelper)repositoryHelper);
        }
        if (this.realEventMapper != null) {
            this.realEventMapper.setRepositoryHelper((OMRSRepositoryHelper)repositoryHelper);
        }
    }

    public void setRepositoryValidator(OMRSRepositoryContentValidator repositoryValidator) {
        super.setRepositoryValidator((OMRSRepositoryValidator)repositoryValidator);
        if (this.realLocalConnector != null) {
            this.realLocalConnector.setRepositoryValidator((OMRSRepositoryValidator)repositoryValidator);
        }
        if (this.realEventMapper != null) {
            this.realEventMapper.setRepositoryValidator((OMRSRepositoryValidator)repositoryValidator);
        }
    }

    public void setMaxPageSize(int maxPageSize) {
        super.setMaxPageSize(maxPageSize);
        if (this.realLocalConnector != null) {
            this.realLocalConnector.setMaxPageSize(maxPageSize);
        }
    }

    public void setServerName(String serverName) {
        super.setServerName(serverName);
        if (this.realLocalConnector != null) {
            this.realLocalConnector.setServerName(serverName);
        }
        if (this.realEventMapper != null) {
            this.realEventMapper.setServerName(serverName);
        }
    }

    public void setServerType(String serverType) {
        super.setServerType(serverType);
        if (this.realLocalConnector != null) {
            this.realLocalConnector.setServerType(serverType);
        }
        if (this.realEventMapper != null) {
            this.realEventMapper.setServerType(serverType);
        }
    }

    public void setOrganizationName(String organizationName) {
        super.setOrganizationName(organizationName);
        if (this.realLocalConnector != null) {
            this.realLocalConnector.setOrganizationName(organizationName);
        }
        if (this.realEventMapper != null) {
            this.realEventMapper.setOrganizationName(organizationName);
        }
    }

    public void setServerUserId(String localServerUserId) {
        super.setServerUserId(localServerUserId);
        if (this.realLocalConnector != null) {
            this.realLocalConnector.setServerUserId(localServerUserId);
        }
        if (this.realEventMapper != null) {
            this.realEventMapper.setServerUserId(localServerUserId);
        }
    }

    public void setMetadataCollectionId(String metadataCollectionId) {
        String methodName = "setMetadataCollectionId";
        super.setMetadataCollectionId(metadataCollectionId);
        if (this.realLocalConnector != null) {
            this.realLocalConnector.setMetadataCollectionId(metadataCollectionId);
        }
        if (this.realEventMapper != null) {
            this.realEventMapper.setMetadataCollectionId(metadataCollectionId);
        }
        LocalOMRSInstanceEventProcessor localOMRSInstanceEventProcessor = new LocalOMRSInstanceEventProcessor(metadataCollectionId, this.serverName, this.realLocalConnector, this.repositoryHelper, this.repositoryValidator, this.saveExchangeRule, this.outboundRepositoryEventProcessor);
        this.incomingInstanceEventProcessor = localOMRSInstanceEventProcessor;
        this.instanceRetrievalEventProcessor = localOMRSInstanceEventProcessor;
        try {
            this.metadataCollection = new LocalOMRSMetadataCollection(this, this.serverName, this.repositoryHelper, this.repositoryValidator, metadataCollectionId, this.getLocalServerName(), this.getLocalServerType(), this.getOrganizationName(), this.realLocalConnector.getMetadataCollection(), this.outboundRepositoryEventProcessor, this.typeDefManager);
        }
        catch (Throwable error) {
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_METADATA_COLLECTION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{this.realLocalConnector.getRepositoryName()});
            throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "setMetadataCollectionId", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
        }
    }

    public OMRSMetadataCollection getMetadataCollection() throws RepositoryErrorException {
        String methodName = "getMetadataCollection";
        if (this.metadataCollection == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_METADATA_COLLECTION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{repositoryName});
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getMetadataCollection", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return this.metadataCollection;
    }

    @Override
    public String getMetadataCollectionId() {
        return this.metadataCollectionId;
    }

    @Override
    public Connection getLocalRepositoryRemoteConnection() {
        return new Connection(this.connectionBean);
    }

    @Override
    public OMRSRepositoryEventManager getOutboundRepositoryEventManager() {
        return this.outboundRepositoryEventManager;
    }

    @Override
    public OMRSTypeDefEventProcessor getIncomingTypeDefEventProcessor() {
        return this.incomingTypeDefEventProcessor;
    }

    @Override
    public OMRSInstanceEventProcessor getIncomingInstanceEventProcessor() {
        return this.incomingInstanceEventProcessor;
    }

    public OMRSInstanceRetrievalEventProcessor getIncomingInstanceRetrievealEventProcessor() {
        return this.instanceRetrievalEventProcessor;
    }

    @Override
    public String getLocalServerName() {
        return this.serverName;
    }

    @Override
    public String getLocalServerType() {
        return this.serverType;
    }

    @Override
    public String getOrganizationName() {
        return this.organizationName;
    }
}

