/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.archivemanager;

import java.util.HashMap;
import java.util.Map;
import org.odpi.openmetadata.repositoryservices.archivemanager.opentypes.OpenMetadataTypesArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveTypeStore;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;

public class OMRSArchiveAccessor {
    private final Map<String, EntityDef> entityDefs = new HashMap<String, EntityDef>();
    private final Map<String, ClassificationDef> classificationDefs = new HashMap<String, ClassificationDef>();
    private final Map<String, RelationshipDef> relationshipDefs = new HashMap<String, RelationshipDef>();
    private final Map<String, EnumDef> enumDefs = new HashMap<String, EnumDef>();
    private OpenMetadataArchive openMetadataArchive;
    private OpenMetadataArchiveTypeStore typeStore;
    private static OMRSArchiveAccessor instance = null;

    public static OMRSArchiveAccessor getInstance() {
        if (instance == null) {
            instance = new OMRSArchiveAccessor(new OpenMetadataTypesArchive().getOpenMetadataArchive());
        }
        return instance;
    }

    public OMRSArchiveAccessor(OpenMetadataArchive openMetadataArchive) {
        this.openMetadataArchive = openMetadataArchive;
        this.typeStore = this.openMetadataArchive.getArchiveTypeStore();
        for (TypeDef typeDef : this.typeStore.getNewTypeDefs()) {
            switch (typeDef.getCategory()) {
                case ENTITY_DEF: {
                    this.entityDefs.put(typeDef.getName(), (EntityDef)typeDef);
                    break;
                }
                case CLASSIFICATION_DEF: {
                    this.classificationDefs.put(typeDef.getName(), (ClassificationDef)typeDef);
                    break;
                }
                case RELATIONSHIP_DEF: {
                    this.relationshipDefs.put(typeDef.getName(), (RelationshipDef)typeDef);
                }
            }
        }
        for (AttributeTypeDef attributeTypeDef : this.typeStore.getAttributeTypeDefs()) {
            switch (attributeTypeDef.getCategory()) {
                case ENUM_DEF: {
                    this.enumDefs.put(attributeTypeDef.getName(), (EnumDef)attributeTypeDef);
                    break;
                }
                case PRIMITIVE: {
                    break;
                }
            }
        }
    }

    public EntityDef getEntityDefByName(String typeName) {
        return this.entityDefs.get(typeName);
    }

    public RelationshipDef getRelationshipDefByName(String typeName) {
        return this.relationshipDefs.get(typeName);
    }

    public ClassificationDef getClassificationDefByName(String typeName) {
        return this.classificationDefs.get(typeName);
    }

    public EnumDef getEnumDefByName(String typeName) {
        return this.enumDefs.get(typeName);
    }
}

