/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.archivemanager;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.repositoryservices.archivemanager.opentypes.OpenMetadataTypesArchive;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditCode;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditingComponent;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.OpenMetadataArchiveStoreConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveInstanceStore;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveTypeStore;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEventProcessor;
import org.odpi.openmetadata.repositoryservices.events.OMRSTypeDefEventProcessor;
import org.odpi.openmetadata.repositoryservices.localrepository.repositorycontentmanager.OMRSRepositoryContentManager;

public class OMRSArchiveManager {
    private List<OpenMetadataArchiveStoreConnector> openMetadataArchiveStores = new ArrayList<OpenMetadataArchiveStoreConnector>();
    private OMRSRepositoryContentManager repositoryContentManager = null;
    private OMRSInstanceEventProcessor localInstanceEventProcessor = null;
    private static final OMRSAuditLog auditLog = new OMRSAuditLog(OMRSAuditingComponent.ARCHIVE_MANAGER);

    public OMRSArchiveManager(List<OpenMetadataArchiveStoreConnector> startUpOpenMetadataArchives) {
        if (startUpOpenMetadataArchives != null) {
            this.openMetadataArchiveStores = new ArrayList<OpenMetadataArchiveStoreConnector>(startUpOpenMetadataArchives);
        }
    }

    public void close() {
        for (OpenMetadataArchiveStoreConnector archiveStore : this.openMetadataArchiveStores) {
            if (archiveStore == null) continue;
            try {
                archiveStore.disconnect();
            }
            catch (Throwable throwable) {}
        }
    }

    public void setLocalRepository(OMRSRepositoryContentManager repositoryContentManager, OMRSInstanceEventProcessor instanceProcessor) {
        this.repositoryContentManager = repositoryContentManager;
        this.localInstanceEventProcessor = instanceProcessor;
        this.processOpenMetadataTypes();
        for (OpenMetadataArchiveStoreConnector archiveStore : this.openMetadataArchiveStores) {
            this.processOpenMetadataArchiveStore(archiveStore, repositoryContentManager, instanceProcessor);
        }
    }

    public void addOpenMetadataArchive(OpenMetadataArchiveStoreConnector archiveStore) {
        this.processOpenMetadataArchiveStore(archiveStore, this.repositoryContentManager, this.localInstanceEventProcessor);
        this.openMetadataArchiveStores.add(archiveStore);
    }

    private void processOpenMetadataTypes() {
        OpenMetadataTypesArchive openMetadataTypesArchive = new OpenMetadataTypesArchive();
        OpenMetadataArchive openMetadataTypes = openMetadataTypesArchive.getOpenMetadataArchive();
        this.repositoryContentManager.setOpenMetadataTypesOriginGUID(openMetadataTypesArchive.getArchiveGUID());
        this.processOpenMetadataArchive(openMetadataTypes, this.repositoryContentManager, this.localInstanceEventProcessor);
    }

    private void processOpenMetadataArchiveStore(OpenMetadataArchiveStoreConnector archiveStore, OMRSTypeDefEventProcessor typeDefProcessor, OMRSInstanceEventProcessor instanceProcessor) {
        if (archiveStore != null) {
            OpenMetadataArchive archiveContent = archiveStore.getArchiveContents();
            if (archiveContent == null) {
                String actionDescription = "Process Open Metadata Archive";
                OMRSAuditCode auditCode = OMRSAuditCode.EMPTY_ARCHIVE;
                auditLog.logRecord("Process Open Metadata Archive", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
            } else {
                this.processOpenMetadataArchive(archiveContent, typeDefProcessor, instanceProcessor);
            }
        }
    }

    private void processOpenMetadataArchive(OpenMetadataArchive archiveContent, OMRSTypeDefEventProcessor typeDefProcessor, OMRSInstanceEventProcessor instanceProcessor) {
        String actionDescription = "Process Open Metadata Archive";
        OpenMetadataArchiveProperties archiveProperties = archiveContent.getArchiveProperties();
        if (archiveProperties != null) {
            OMRSAuditCode auditCode = OMRSAuditCode.PROCESSING_ARCHIVE;
            auditLog.logRecord("Process Open Metadata Archive", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{archiveProperties.getArchiveName()}), null, auditCode.getSystemAction(), auditCode.getUserAction());
            OpenMetadataArchiveTypeStore archiveTypeStore = archiveContent.getArchiveTypeStore();
            OpenMetadataArchiveInstanceStore archiveInstanceStore = archiveContent.getArchiveInstanceStore();
            int typeCount = 0;
            int instanceCount = 0;
            if (archiveTypeStore != null) {
                typeCount = this.processTypeDefStore(archiveProperties, archiveTypeStore, typeDefProcessor);
            }
            if (archiveInstanceStore != null) {
                instanceCount = this.processInstanceStore(archiveProperties, archiveInstanceStore, instanceProcessor);
            }
            auditCode = OMRSAuditCode.COMPLETED_ARCHIVE;
            auditLog.logRecord("Process Open Metadata Archive", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{Integer.toString(typeCount), Integer.toString(instanceCount), archiveProperties.getArchiveName()}), null, auditCode.getSystemAction(), auditCode.getUserAction());
        } else {
            OMRSAuditCode auditCode = OMRSAuditCode.NULL_PROPERTIES_IN_ARCHIVE;
            auditLog.logRecord("Process Open Metadata Archive", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
        }
    }

    private int processTypeDefStore(OpenMetadataArchiveProperties archiveProperties, OpenMetadataArchiveTypeStore archiveTypeStore, OMRSTypeDefEventProcessor typeDefProcessor) {
        List typeDefPatches = archiveTypeStore.getTypeDefPatches();
        List newAttributeTypeDefs = archiveTypeStore.getAttributeTypeDefs();
        List newTypeDefs = archiveTypeStore.getNewTypeDefs();
        int typeCount = 0;
        if (typeDefProcessor != null) {
            String sourceName = OMRSAuditingComponent.ARCHIVE_MANAGER.getComponentName();
            String originatorMetadataCollectionId = archiveProperties.getArchiveGUID();
            String originatorServerName = archiveProperties.getArchiveName();
            String originatorServerType = null;
            String originatorName = archiveProperties.getOriginatorName();
            String originatorOrganizationName = archiveProperties.getOriginatorOrganization();
            if (originatorName == null) {
                originatorName = sourceName;
            }
            if (archiveProperties.getArchiveType() != null) {
                originatorServerType = archiveProperties.getArchiveType().getName();
            }
            if (typeDefPatches != null) {
                for (TypeDefPatch typeDefPatch : typeDefPatches) {
                    if (typeDefPatch == null) continue;
                    typeDefProcessor.processUpdatedTypeDefEvent(originatorName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, typeDefPatch);
                    ++typeCount;
                }
            }
            if (newAttributeTypeDefs != null) {
                for (AttributeTypeDef newAttributeTypeDef : newAttributeTypeDefs) {
                    if (newAttributeTypeDef == null) continue;
                    typeDefProcessor.processNewAttributeTypeDefEvent(originatorName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, newAttributeTypeDef);
                    ++typeCount;
                }
            }
            if (newTypeDefs != null) {
                for (TypeDef newTypeDef : newTypeDefs) {
                    if (newTypeDef == null) continue;
                    typeDefProcessor.processNewTypeDefEvent(originatorName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, newTypeDef);
                    ++typeCount;
                }
            }
        }
        return typeCount;
    }

    private int processInstanceStore(OpenMetadataArchiveProperties archiveProperties, OpenMetadataArchiveInstanceStore archiveInstanceStore, OMRSInstanceEventProcessor instanceProcessor) {
        List entities = archiveInstanceStore.getEntities();
        List relationships = archiveInstanceStore.getRelationships();
        int instanceCount = 0;
        if (instanceProcessor != null) {
            String sourceName = OMRSAuditingComponent.ARCHIVE_MANAGER.getComponentName();
            String originatorMetadataCollectionId = archiveProperties.getArchiveGUID();
            String originatorServerName = archiveProperties.getArchiveName();
            String originatorServerType = null;
            String originatorOrganizationName = archiveProperties.getOriginatorName();
            if (archiveProperties.getArchiveType() != null) {
                originatorServerType = archiveProperties.getArchiveType().getName();
            }
            if (entities != null) {
                for (EntityDetail entity : entities) {
                    if (entity == null) continue;
                    instanceProcessor.processNewEntityEvent(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, entity);
                    ++instanceCount;
                }
            }
            if (relationships != null) {
                for (Relationship relationship : relationships) {
                    if (relationship == null) continue;
                    instanceProcessor.processNewRelationshipEvent(sourceName, originatorMetadataCollectionId, originatorServerName, originatorServerType, originatorOrganizationName, relationship);
                    ++instanceCount;
                }
            }
        }
        return instanceCount;
    }
}

