/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.enterprise.connectormanager;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.enterprise.connectormanager.OMRSConnectionConsumer;
import org.odpi.openmetadata.repositoryservices.enterprise.connectormanager.OMRSConnectorConsumer;
import org.odpi.openmetadata.repositoryservices.enterprise.connectormanager.OMRSConnectorManager;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSRuntimeException;
import org.odpi.openmetadata.repositoryservices.localrepository.repositoryconnector.LocalOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.localrepository.repositorycontentmanager.OMRSRepositoryContentHelper;
import org.odpi.openmetadata.repositoryservices.localrepository.repositorycontentmanager.OMRSRepositoryContentManager;
import org.odpi.openmetadata.repositoryservices.localrepository.repositorycontentmanager.OMRSRepositoryContentValidator;

public class OMRSEnterpriseConnectorManager
implements OMRSConnectionConsumer,
OMRSConnectorManager {
    private boolean enterpriseAccessEnabled;
    private int maxPageSize;
    private String localMetadataCollectionId = null;
    private LocalOMRSRepositoryConnector localRepositoryConnector = null;
    private OMRSRepositoryContentManager repositoryContentManager;
    private List<RegisteredConnector> registeredRemoteConnectors = new ArrayList<RegisteredConnector>();
    private List<RegisteredConnectorConsumer> registeredConnectorConsumers = new ArrayList<RegisteredConnectorConsumer>();

    public OMRSEnterpriseConnectorManager(boolean enterpriseAccessEnabled, int maxPageSize, OMRSRepositoryContentManager repositoryContentManager) {
        this.enterpriseAccessEnabled = enterpriseAccessEnabled;
        this.maxPageSize = maxPageSize;
        this.repositoryContentManager = repositoryContentManager;
    }

    public void disconnect() {
        for (RegisteredConnectorConsumer registeredConnectorConsumer : this.registeredConnectorConsumers) {
            registeredConnectorConsumer.getConnectorConsumer().disconnectAllConnectors();
        }
    }

    public void setLocalConnector(String localMetadataCollectionId, LocalOMRSRepositoryConnector localRepositoryConnector) {
        this.localRepositoryConnector = localRepositoryConnector;
        this.localMetadataCollectionId = localMetadataCollectionId;
        for (RegisteredConnectorConsumer registeredConnectorConsumer : this.registeredConnectorConsumers) {
            registeredConnectorConsumer.getConnectorConsumer().setLocalConnector(localMetadataCollectionId, localRepositoryConnector);
        }
    }

    @Override
    public synchronized void addRemoteConnection(String cohortName, String remoteServerName, String remoteServerType, String owningOrganizationName, String metadataCollectionId, Connection remoteConnection) throws ConnectionCheckedException, ConnectorCheckedException {
        OMRSRepositoryConnector remoteConnector = this.getOMRSRepositoryConnector(remoteConnection, remoteServerName, remoteServerType, owningOrganizationName, metadataCollectionId);
        if (remoteConnector != null) {
            OMRSMetadataCollection metadataCollection;
            try {
                metadataCollection = remoteConnector.getMetadataCollection();
            }
            catch (Throwable error) {
                metadataCollection = null;
            }
            remoteConnector.disconnect();
            if (metadataCollection == null) {
                String methodName = "addRemoteConnection()";
                OMRSErrorCode errorCode = OMRSErrorCode.NULL_COHORT_METADATA_COLLECTION;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{cohortName, metadataCollectionId});
                throw new ConnectorCheckedException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "addRemoteConnection()", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
        }
        this.registeredRemoteConnectors.add(new RegisteredConnector(cohortName, remoteServerName, remoteServerType, owningOrganizationName, metadataCollectionId, remoteConnection));
        if (this.enterpriseAccessEnabled) {
            for (RegisteredConnectorConsumer registeredConnectorConsumer : this.registeredConnectorConsumers) {
                registeredConnectorConsumer.getConnectorConsumer().addRemoteConnector(metadataCollectionId, this.getOMRSRepositoryConnector(remoteConnection, remoteServerName, remoteServerType, owningOrganizationName, metadataCollectionId));
            }
        }
    }

    @Override
    public synchronized void removeRemoteConnection(String cohortName, String metadataCollectionId) {
        Iterator<RegisteredConnector> iterator = this.registeredRemoteConnectors.iterator();
        int repositoryRegistrationCount = 0;
        while (iterator.hasNext()) {
            RegisteredConnector registeredRemoteConnector = iterator.next();
            if (!registeredRemoteConnector.getMetadataCollectionId().equals(metadataCollectionId)) continue;
            if (registeredRemoteConnector.getSource().equals(cohortName)) {
                iterator.remove();
                continue;
            }
            ++repositoryRegistrationCount;
        }
        if (this.enterpriseAccessEnabled && repositoryRegistrationCount == 0) {
            for (RegisteredConnectorConsumer registeredConnectorConsumer : this.registeredConnectorConsumers) {
                registeredConnectorConsumer.getConnectorConsumer().removeRemoteConnector(metadataCollectionId);
            }
        }
    }

    @Override
    public synchronized void removeCohort(String cohortName) {
        ArrayList<String> metadataCollectionIds = new ArrayList<String>();
        for (RegisteredConnector registeredRemoteConnector : this.registeredRemoteConnectors) {
            if (!registeredRemoteConnector.getSource().equals(cohortName)) continue;
            metadataCollectionIds.add(registeredRemoteConnector.getMetadataCollectionId());
        }
        for (String metadataCollectionId : metadataCollectionIds) {
            this.removeRemoteConnection(cohortName, metadataCollectionId);
        }
    }

    @Override
    public synchronized String registerConnectorConsumer(OMRSConnectorConsumer connectorConsumer) {
        RegisteredConnectorConsumer registeredConnectorConsumer = new RegisteredConnectorConsumer(connectorConsumer);
        String connectorConsumerId = registeredConnectorConsumer.getConnectorConsumerId();
        this.registeredConnectorConsumers.add(registeredConnectorConsumer);
        if (this.localRepositoryConnector != null) {
            connectorConsumer.setLocalConnector(this.localMetadataCollectionId, this.localRepositoryConnector);
        }
        if (this.enterpriseAccessEnabled) {
            for (RegisteredConnector registeredConnector : this.registeredRemoteConnectors) {
                connectorConsumer.addRemoteConnector(registeredConnector.getMetadataCollectionId(), this.getOMRSRepositoryConnector(registeredConnector.getConnection(), registeredConnector.getServerName(), registeredConnector.getServerType(), registeredConnector.getOwningOrganizationName(), registeredConnector.getMetadataCollectionId()));
            }
        }
        return connectorConsumerId;
    }

    @Override
    public synchronized void unregisterConnectorConsumer(String connectorConsumerId) {
        Iterator<RegisteredConnectorConsumer> iterator = this.registeredConnectorConsumers.iterator();
        while (iterator.hasNext()) {
            RegisteredConnectorConsumer registeredConnectorConsumer = iterator.next();
            if (!registeredConnectorConsumer.getConnectorConsumerId().equals(connectorConsumerId)) continue;
            iterator.remove();
            break;
        }
    }

    private OMRSRepositoryConnector getOMRSRepositoryConnector(Connection connection, String serverName, String serverType, String owningOrganizationName, String metadataCollectionId) {
        String methodName = "getOMRSRepositoryConnector()";
        try {
            ConnectorBroker connectorBroker = new ConnectorBroker();
            Connector connector = connectorBroker.getConnector(connection);
            OMRSRepositoryConnector repositoryConnector = (OMRSRepositoryConnector)connector;
            repositoryConnector.setServerName(serverName);
            repositoryConnector.setServerType(serverType);
            repositoryConnector.setOrganizationName(owningOrganizationName);
            repositoryConnector.setMaxPageSize(this.maxPageSize);
            repositoryConnector.setRepositoryValidator((OMRSRepositoryValidator)new OMRSRepositoryContentValidator(this.repositoryContentManager));
            repositoryConnector.setRepositoryHelper((OMRSRepositoryHelper)new OMRSRepositoryContentHelper(this.repositoryContentManager));
            repositoryConnector.setMetadataCollectionId(metadataCollectionId);
            repositoryConnector.start();
            return repositoryConnector;
        }
        catch (Throwable error) {
            String connectionName = connection.getQualifiedName();
            OMRSErrorCode errorCode = OMRSErrorCode.INVALID_OMRS_CONNECTION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{connectionName});
            throw new OMRSRuntimeException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
        }
    }

    private class RegisteredConnectorConsumer {
        private String connectorConsumerId;
        private OMRSConnectorConsumer connectorConsumer;

        public RegisteredConnectorConsumer(String connectorConsumerId, OMRSConnectorConsumer connectorConsumer) {
            this.connectorConsumerId = connectorConsumerId;
            this.connectorConsumer = connectorConsumer;
        }

        public RegisteredConnectorConsumer(OMRSConnectorConsumer connectorConsumer) {
            this.connectorConsumer = connectorConsumer;
            this.connectorConsumerId = UUID.randomUUID().toString();
        }

        public String getConnectorConsumerId() {
            return this.connectorConsumerId;
        }

        public OMRSConnectorConsumer getConnectorConsumer() {
            return this.connectorConsumer;
        }
    }

    private class RegisteredConnector {
        private String source;
        private String serverName;
        private String serverType;
        private String owningOrganizationName;
        private String metadataCollectionId;
        private Connection connection;

        public RegisteredConnector(String source, String serverName, String serverType, String owningOrganizationName, String metadataCollectionId, Connection connection) {
            this.source = source;
            this.serverName = serverName;
            this.serverType = serverType;
            this.owningOrganizationName = owningOrganizationName;
            this.metadataCollectionId = metadataCollectionId;
            this.connection = connection;
        }

        public String getSource() {
            return this.source;
        }

        public String getServerName() {
            return this.serverName;
        }

        public String getServerType() {
            return this.serverType;
        }

        public String getOwningOrganizationName() {
            return this.owningOrganizationName;
        }

        public String getMetadataCollectionId() {
            return this.metadataCollectionId;
        }

        public Connection getConnection() {
            return this.connection;
        }
    }
}

