/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector;

import java.util.UUID;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnectorProviderBase;
import org.odpi.openmetadata.repositoryservices.enterprise.connectormanager.OMRSConnectorManager;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.EnterpriseOMRSConnectorProperties;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.EnterpriseOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.localrepository.repositorycontentmanager.OMRSRepositoryContentHelper;
import org.odpi.openmetadata.repositoryservices.localrepository.repositorycontentmanager.OMRSRepositoryContentManager;
import org.odpi.openmetadata.repositoryservices.localrepository.repositorycontentmanager.OMRSRepositoryContentValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnterpriseOMRSConnectorProvider
extends OMRSRepositoryConnectorProviderBase {
    private final int hashCode = UUID.randomUUID().hashCode();
    private static final Logger log = LoggerFactory.getLogger(EnterpriseOMRSConnectorProvider.class);
    private static OMRSConnectorManager connectorManager = null;
    private static OMRSRepositoryContentManager repositoryContentManager = null;
    private static String localServerName = null;
    private static String localServerType = null;
    private static String owningOrganizationName = null;
    private static String enterpriseMetadataCollectionId = null;
    private static String enterpriseMetadataCollectionName = null;

    public static synchronized void initialize(OMRSConnectorManager connectorManager, OMRSRepositoryContentManager repositoryContentManager, String localServerName, String localServerType, String owningOrganizationName, String enterpriseMetadataCollectionId, String enterpriseMetadataCollectionName) {
        EnterpriseOMRSConnectorProvider.connectorManager = connectorManager;
        EnterpriseOMRSConnectorProvider.repositoryContentManager = repositoryContentManager;
        EnterpriseOMRSConnectorProvider.localServerName = localServerName;
        EnterpriseOMRSConnectorProvider.localServerType = localServerType;
        EnterpriseOMRSConnectorProvider.owningOrganizationName = owningOrganizationName;
        EnterpriseOMRSConnectorProvider.enterpriseMetadataCollectionId = enterpriseMetadataCollectionId;
        EnterpriseOMRSConnectorProvider.enterpriseMetadataCollectionName = enterpriseMetadataCollectionName;
    }

    public EnterpriseOMRSConnectorProvider() {
        Class<EnterpriseOMRSRepositoryConnector> connectorClass = EnterpriseOMRSRepositoryConnector.class;
        super.setConnectorClassName(connectorClass.getName());
    }

    public Connector getConnector(ConnectionProperties connection) throws ConnectionCheckedException, ConnectorCheckedException {
        String methodName = "getConnector()";
        if (log.isDebugEnabled()) {
            log.debug(methodName + " called");
        }
        if (connectorManager == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.COHORT_NOT_CONNECTED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[0]);
            throw new ConnectorCheckedException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        EnterpriseOMRSRepositoryConnector connector = new EnterpriseOMRSRepositoryConnector(connectorManager);
        connector.initialize(this.getNewConnectorGUID(), connection);
        connector.setServerName(localServerName);
        connector.setServerType(localServerType);
        connector.setRepositoryName(enterpriseMetadataCollectionName);
        connector.setOrganizationName(owningOrganizationName);
        connector.setRepositoryHelper(new OMRSRepositoryContentHelper(repositoryContentManager));
        connector.setRepositoryValidator(new OMRSRepositoryContentValidator(repositoryContentManager));
        connector.setMetadataCollectionId(enterpriseMetadataCollectionId);
        connector.initializeConnectedAssetProperties(new EnterpriseOMRSConnectorProperties(connector, connectorManager, enterpriseMetadataCollectionId, enterpriseMetadataCollectionName));
        if (log.isDebugEnabled()) {
            log.debug(methodName + " returns: " + connector.getConnectorInstanceId() + ", " + connection.getConnectionName());
        }
        return connector;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

