/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.localrepository.repositorycontentmanager;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ArrayPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.StructPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefGallery;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidTypeDefException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PatchErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.StatusNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.localrepository.repositorycontentmanager.OMRSRepositoryContentHelper;
import org.odpi.openmetadata.repositoryservices.localrepository.repositorycontentmanager.OMRSRepositoryContentManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMRSRepositoryContentValidator
implements OMRSRepositoryValidator {
    private static OMRSRepositoryContentManager defaultRepositoryContentManager = null;
    private OMRSRepositoryContentManager repositoryContentManager;
    private static final Logger log = LoggerFactory.getLogger(OMRSRepositoryContentValidator.class);

    @Deprecated
    public OMRSRepositoryContentValidator() {
        this.repositoryContentManager = defaultRepositoryContentManager;
    }

    public OMRSRepositoryContentValidator(OMRSRepositoryContentManager repositoryContentManager) {
        String methodName = "OMRSRepositoryContentValidator";
        this.repositoryContentManager = repositoryContentManager;
        this.validateRepositoryContentManager("OMRSRepositoryContentValidator");
    }

    public static synchronized void setRepositoryContentManager(OMRSRepositoryContentManager repositoryContentManager) {
        OMRSRepositoryContentHelper.setRepositoryContentManager(repositoryContentManager);
    }

    public void validateEnterpriseTypeDefs(String sourceName, List<TypeDef> typeDefs, String methodName) throws RepositoryErrorException {
        this.validateRepositoryContentManager(methodName);
        this.repositoryContentManager.validateEnterpriseTypeDefs(sourceName, typeDefs, methodName);
    }

    public void validateEnterpriseAttributeTypeDefs(String sourceName, List<AttributeTypeDef> attributeTypeDefs, String methodName) throws RepositoryErrorException {
        this.validateRepositoryContentManager(methodName);
        this.repositoryContentManager.validateEnterpriseAttributeTypeDefs(sourceName, attributeTypeDefs, methodName);
    }

    public boolean isActiveType(String sourceName, String typeGUID, String typeName) {
        String methodName = "isActiveType";
        this.validateRepositoryContentManager("isActiveType");
        return this.repositoryContentManager.isActiveType(sourceName, typeGUID, typeName);
    }

    public boolean isActiveTypeId(String sourceName, String typeGUID) {
        String methodName = "isActiveTypeId";
        this.validateRepositoryContentManager("isActiveTypeId");
        return this.repositoryContentManager.isActiveTypeId(sourceName, typeGUID);
    }

    public boolean isOpenType(String sourceName, String typeGUID, String typeName) {
        String methodName = "isOpenType";
        this.validateRepositoryContentManager("isOpenType");
        return this.repositoryContentManager.isOpenType(sourceName, typeGUID, typeName);
    }

    public boolean isOpenTypeId(String sourceName, String typeGUID) {
        String methodName = "isOpenTypeId";
        this.validateRepositoryContentManager("isOpenTypeId");
        return this.repositoryContentManager.isOpenTypeId(sourceName, typeGUID);
    }

    public boolean isKnownType(String sourceName, String typeGUID, String typeName) {
        String methodName = "isKnownType";
        this.validateRepositoryContentManager("isKnownType");
        return this.repositoryContentManager.isKnownType(sourceName, typeGUID, typeName);
    }

    public boolean isKnownTypeId(String sourceName, String typeGUID) {
        String methodName = "isKnownTypeId";
        this.validateRepositoryContentManager("isKnownTypeId");
        return this.repositoryContentManager.isKnownTypeId(sourceName, typeGUID);
    }

    public boolean validTypeId(String sourceName, String typeGUID, String typeName) {
        String methodName = "validTypeId";
        this.validateRepositoryContentManager("validTypeId");
        return this.repositoryContentManager.validTypeId(sourceName, typeGUID, typeName);
    }

    public boolean validTypeDefId(String sourceName, String typeDefGUID, String typeDefName, TypeDefCategory category) {
        String methodName = "validTypeDefId";
        this.validateRepositoryContentManager("validTypeDefId");
        return this.repositoryContentManager.validTypeDefId(sourceName, typeDefGUID, typeDefName, category);
    }

    public boolean validAttributeTypeDefId(String sourceName, String attributeTypeDefGUID, String attributeTypeDefName, AttributeTypeDefCategory category) {
        String methodName = "validAttributeTypeDefId";
        this.validateRepositoryContentManager("validAttributeTypeDefId");
        return this.repositoryContentManager.validAttributeTypeDefId(sourceName, attributeTypeDefGUID, attributeTypeDefName, category);
    }

    public boolean validTypeDefId(String sourceName, String typeDefGUID, String typeDefName, long typeDefVersion, TypeDefCategory category) {
        String methodName = "validTypeDefId";
        this.validateRepositoryContentManager("validTypeDefId");
        return this.repositoryContentManager.validTypeDefId(sourceName, typeDefGUID, typeDefName, typeDefVersion, category);
    }

    public boolean validAttributeTypeDefId(String sourceName, String attributeTypeDefGUID, String attributeTypeDefName, long attributeTypeDefVersion, AttributeTypeDefCategory category) {
        String methodName = "validAttributeTypeDefId";
        this.validateRepositoryContentManager("validAttributeTypeDefId");
        return this.repositoryContentManager.validAttributeTypeDefId(sourceName, attributeTypeDefGUID, attributeTypeDefName, attributeTypeDefVersion, category);
    }

    public boolean validTypeDef(String sourceName, TypeDef typeDef) {
        String methodName = "validTypeDef";
        this.validateRepositoryContentManager("validTypeDef");
        return this.repositoryContentManager.validTypeDef(sourceName, typeDef);
    }

    public boolean validAttributeTypeDef(String sourceName, AttributeTypeDef attributeTypeDef) {
        String methodName = "validAttributeTypeDef";
        this.validateRepositoryContentManager("validAttributeTypeDef");
        return this.repositoryContentManager.validAttributeTypeDef(sourceName, attributeTypeDef);
    }

    public boolean validTypeDefSummary(String sourceName, TypeDefSummary typeDefSummary) {
        String methodName = "validTypeDefSummary";
        this.validateRepositoryContentManager("validTypeDefSummary");
        return this.repositoryContentManager.validTypeDefSummary(sourceName, typeDefSummary);
    }

    public boolean validEntity(String sourceName, EntitySummary entity) {
        if (entity == null) {
            log.error("Null entity from " + sourceName);
            return false;
        }
        InstanceType instanceType = entity.getType();
        if (instanceType == null) {
            log.error("Null instance type in entity from " + sourceName);
            return false;
        }
        if (!this.validInstanceId(sourceName, instanceType.getTypeDefGUID(), instanceType.getTypeDefName(), instanceType.getTypeDefCategory(), entity.getGUID())) {
            log.error("Null entity guid from " + sourceName);
            return false;
        }
        return true;
    }

    public boolean validEntity(String sourceName, EntityProxy entity) {
        return this.validEntity(sourceName, (EntitySummary)entity);
    }

    public boolean validEntity(String sourceName, EntityDetail entity) {
        return this.validEntity(sourceName, (EntitySummary)entity);
    }

    public boolean validRelationship(String sourceName, Relationship relationship) {
        if (relationship == null) {
            log.error("Null relationship from " + sourceName);
            return false;
        }
        InstanceType instanceType = relationship.getType();
        if (instanceType == null) {
            log.error("Null instance type in relationship from " + sourceName);
            return false;
        }
        if (!this.validInstanceId(sourceName, instanceType.getTypeDefGUID(), instanceType.getTypeDefName(), instanceType.getTypeDefCategory(), relationship.getGUID())) {
            log.error("Null relationship guid from " + sourceName);
            return false;
        }
        String homeMetadataCollectionId = relationship.getMetadataCollectionId();
        if (homeMetadataCollectionId == null) {
            log.error("Null home metadata collection id for relationship " + relationship.getGUID() + " from " + sourceName);
            return false;
        }
        return true;
    }

    public boolean validInstanceId(String sourceName, String typeDefGUID, String typeDefName, TypeDefCategory category, String instanceGUID) {
        if (instanceGUID == null) {
            log.error("Null instance guid from " + sourceName);
            return false;
        }
        return this.validTypeDefId(sourceName, typeDefGUID, typeDefName, category);
    }

    public void validateUserId(String sourceName, String userId, String methodName) throws UserNotAuthorizedException {
        if ("".equals(userId)) {
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_USER_ID;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"userId", methodName, sourceName});
            throw new UserNotAuthorizedException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public void validateTypeDefIds(String sourceName, String guidParameterName, String nameParameterName, String guid, String name, String methodName) throws InvalidParameterException {
        if (guid == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_TYPEDEF_IDENTIFIER;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{guidParameterName, methodName, sourceName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (name == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NO_TYPEDEF_NAME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{nameParameterName, methodName, sourceName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public void validateAttributeTypeDefIds(String sourceName, String guidParameterName, String nameParameterName, String guid, String name, String methodName) throws InvalidParameterException {
        if (guid == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_ATTRIBUTE_TYPEDEF_IDENTIFIER;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{guidParameterName, methodName, sourceName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (name == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NO_ATTRIBUTE_TYPEDEF_NAME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{nameParameterName, methodName, sourceName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public void validateTypeGUID(String sourceName, String guidParameterName, String guid, String methodName) throws InvalidParameterException, TypeErrorException {
        if (guid == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_TYPEDEF_IDENTIFIER;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{guidParameterName, methodName, sourceName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        this.validateOptionalTypeGUID(sourceName, guidParameterName, guid, methodName);
    }

    public void validateOptionalTypeGUID(String sourceName, String guidParameterName, String guid, String methodName) throws TypeErrorException {
        if (guid != null && !this.isKnownTypeId(sourceName, guid)) {
            OMRSErrorCode errorCode = OMRSErrorCode.TYPEDEF_ID_NOT_KNOWN;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{guid, guidParameterName, methodName, sourceName});
            throw new TypeErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public void validateTypeDefPatch(String sourceName, TypeDefPatch patch, String methodName) throws InvalidParameterException, PatchErrorException {
        if (patch == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_TYPEDEF_PATCH;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName, sourceName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public void validateInstanceTypeGUID(String sourceName, String guidParameterName, String guid, String methodName) throws TypeErrorException {
        if (guid == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.BAD_TYPEDEF_ID_FOR_INSTANCE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{guidParameterName, methodName, sourceName});
            throw new TypeErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public void validateTypeName(String sourceName, String nameParameterName, String name, String methodName) throws InvalidParameterException {
        if (name == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NO_TYPEDEF_NAME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{nameParameterName, methodName, sourceName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public void validateTypeDefCategory(String sourceName, String nameParameterName, TypeDefCategory category, String methodName) throws InvalidParameterException {
        if (category == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NO_TYPEDEF_CATEGORY;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{nameParameterName, methodName, sourceName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public void validateAttributeTypeDefCategory(String sourceName, String nameParameterName, AttributeTypeDefCategory category, String methodName) throws InvalidParameterException {
        if (category == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NO_ATTRIBUTE_TYPEDEF_CATEGORY;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{nameParameterName, methodName, sourceName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public void validateTypeDef(String sourceName, String parameterName, TypeDef typeDef, String methodName) throws InvalidParameterException, InvalidTypeDefException {
        if (typeDef == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_TYPEDEF;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{parameterName, methodName, sourceName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        this.validateTypeDefIds(sourceName, parameterName + ".getGUID", parameterName + ".getName", typeDef.getGUID(), typeDef.getName(), methodName);
        this.validateTypeDefCategory(sourceName, parameterName + ".getCategory", typeDef.getCategory(), methodName);
    }

    public void validateKnownTypeDef(String sourceName, String parameterName, TypeDef typeDef, String methodName) throws TypeDefNotKnownException {
        String thisMethodName = "validateKnownTypeDef";
        this.validateRepositoryContentManager("validateKnownTypeDef");
        if (!this.repositoryContentManager.isKnownType(sourceName, typeDef.getGUID(), typeDef.getName())) {
            OMRSErrorCode errorCode = OMRSErrorCode.TYPEDEF_NOT_KNOWN;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{typeDef.getName(), typeDef.getGUID(), parameterName, methodName, sourceName});
            throw new TypeDefNotKnownException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public void validateUnknownTypeDef(String sourceName, String parameterName, TypeDef typeDef, String methodName) throws TypeDefKnownException, TypeDefConflictException {
        String thisMethodName = "validateUnknownTypeDef";
        this.validateRepositoryContentManager("validateUnknownTypeDef");
        if (this.repositoryContentManager.isKnownType(sourceName, typeDef.getGUID(), typeDef.getName())) {
            OMRSErrorCode errorCode = OMRSErrorCode.TYPEDEF_ALREADY_DEFINED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{typeDef.getName(), typeDef.getGUID(), sourceName});
            throw new TypeDefKnownException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public void validateUnknownAttributeTypeDef(String sourceName, String parameterName, AttributeTypeDef attributeTypeDef, String methodName) throws TypeDefKnownException, TypeDefConflictException {
        String thisMethodName = "validateUnknownTypeDef";
        this.validateRepositoryContentManager("validateUnknownTypeDef");
        if (this.repositoryContentManager.isKnownType(sourceName, attributeTypeDef.getGUID(), attributeTypeDef.getName())) {
            OMRSErrorCode errorCode = OMRSErrorCode.ATTRIBUTE_TYPEDEF_ALREADY_DEFINED;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{attributeTypeDef.getName(), attributeTypeDef.getGUID(), sourceName});
            throw new TypeDefKnownException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public void validateTypeDefForInstance(String sourceName, String parameterName, TypeDef typeDef, String methodName) throws TypeErrorException, RepositoryErrorException {
        if (typeDef == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_TYPEDEF;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{parameterName, methodName, sourceName});
            throw new TypeErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        try {
            this.validateTypeDefIds(sourceName, parameterName + ".getGUID", parameterName + ".getName", typeDef.getGUID(), typeDef.getName(), methodName);
            this.validateTypeDefCategory(sourceName, parameterName + ".getCategory", typeDef.getCategory(), methodName);
        }
        catch (Throwable error) {
            OMRSErrorCode errorCode = OMRSErrorCode.BAD_TYPEDEF;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{parameterName, methodName, sourceName});
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public void validateTypeForInstanceDelete(String sourceName, String typeDefGUID, String typeDefName, InstanceHeader instance, String methodName) throws InvalidParameterException, RepositoryErrorException {
        this.validateInstanceType(sourceName, instance);
        if (!typeDefGUID.equals(instance.getType().getTypeDefGUID()) || !typeDefName.equals(instance.getType().getTypeDefName())) {
            OMRSErrorCode errorCode = OMRSErrorCode.BAD_TYPEDEF_IDS_FOR_DELETE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{typeDefName, typeDefGUID, methodName, instance.getGUID(), sourceName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public void validateAttributeTypeDef(String sourceName, String parameterName, AttributeTypeDef attributeTypeDef, String methodName) throws InvalidParameterException, InvalidTypeDefException {
        if (attributeTypeDef == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_ATTRIBUTE_TYPEDEF;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{parameterName, methodName, sourceName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        this.validateAttributeTypeDefIds(sourceName, parameterName + ".getGUID", parameterName + ".getName", attributeTypeDef.getGUID(), attributeTypeDef.getName(), methodName);
        this.validateAttributeTypeDefCategory(sourceName, parameterName + ".getCategory", attributeTypeDef.getCategory(), methodName);
    }

    public void validateTypeDefGallery(String sourceName, String parameterName, TypeDefGallery gallery, String methodName) throws InvalidParameterException {
        if (gallery == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_TYPEDEF_GALLERY;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{parameterName, methodName, sourceName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public void validateExternalId(String sourceName, String standard, String organization, String identifier, String methodName) throws InvalidParameterException {
        if (standard == null && organization == null && identifier == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NO_EXTERNAL_ID;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName, sourceName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public void validateGUID(String sourceName, String guidParameterName, String guid, String methodName) throws InvalidParameterException {
        if (guid == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NO_GUID;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{guidParameterName, methodName, sourceName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public void validateHomeMetadataGUID(String sourceName, String guidParameterName, String guid, String methodName) throws InvalidParameterException {
        if (guid == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_HOME_METADATA_COLLECTION_ID;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{guidParameterName, methodName, sourceName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public void validateHomeMetadataGUID(String sourceName, InstanceHeader instance, String methodName) throws RepositoryErrorException {
        String thisMethodName = "validateHomeMetadataGUID";
        if (instance == null) {
            this.throwValidatorLogicError(sourceName, methodName, "validateHomeMetadataGUID");
        }
        if (instance.getMetadataCollectionId() == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_INSTANCE_METADATA_COLLECTION_ID;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{instance.getGUID(), sourceName, methodName, instance.toString()});
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public void validateAsOfTime(String sourceName, String parameterName, Date asOfTime, String methodName) throws InvalidParameterException {
        Date now;
        if (asOfTime != null && asOfTime.after(now = new Date())) {
            OMRSErrorCode errorCode = OMRSErrorCode.REPOSITORY_NOT_CRYSTAL_BALL;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{asOfTime.toString(), parameterName, methodName, sourceName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public void validateAsOfTimeNotNull(String sourceName, String parameterName, Date asOfTime, String methodName) throws InvalidParameterException {
        if (asOfTime == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_AS_OF_TIME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName, parameterName, sourceName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        this.validateAsOfTime(sourceName, parameterName, asOfTime, methodName);
    }

    public void validatePageSize(String sourceName, String parameterName, int pageSize, String methodName) throws PagingErrorException {
        if (pageSize < 0) {
            OMRSErrorCode errorCode = OMRSErrorCode.NEGATIVE_PAGE_SIZE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{Integer.toString(pageSize), parameterName, methodName, sourceName});
            throw new PagingErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public void validateClassificationName(String sourceName, String parameterName, String classificationName, String methodName) throws InvalidParameterException {
        if (classificationName == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_CLASSIFICATION_NAME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{parameterName, methodName, sourceName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public void validateClassificationProperties(String sourceName, String classificationName, String propertiesParameterName, InstanceProperties classificationProperties, String methodName) throws PropertyErrorException, TypeErrorException {
        this.validateRepositoryContentManager(methodName);
        TypeDef classificationTypeDef = this.repositoryContentManager.getTypeDefByName(sourceName, classificationName);
        if (classificationTypeDef != null) {
            this.validatePropertiesForType(sourceName, propertiesParameterName, classificationTypeDef, classificationProperties, methodName);
        } else {
            String thisMethodName = "validateClassificationProperties";
            this.throwValidatorLogicError(sourceName, methodName, "validateClassificationProperties");
        }
    }

    public void validateClassification(String sourceName, String classificationParameterName, String classificationName, String entityTypeName, String methodName) throws InvalidParameterException, ClassificationErrorException {
        this.validateRepositoryContentManager(methodName);
        this.validateClassificationName(sourceName, classificationParameterName, classificationName, methodName);
        if (entityTypeName != null && !this.repositoryContentManager.isValidClassificationForEntity(sourceName, classificationName, entityTypeName, methodName)) {
            OMRSErrorCode errorCode = OMRSErrorCode.INVALID_CLASSIFICATION_FOR_ENTITY;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{sourceName, classificationName, entityTypeName});
            throw new ClassificationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public void validateClassificationList(String sourceName, String parameterName, List<Classification> classifications, String entityTypeName, String methodName) throws InvalidParameterException, ClassificationErrorException, PropertyErrorException, TypeErrorException {
        this.validateRepositoryContentManager(methodName);
        if (classifications != null) {
            for (Classification classification : classifications) {
                if (classification != null) {
                    this.validateClassification(sourceName, parameterName, classification.getName(), entityTypeName, methodName);
                    this.validatePropertiesForType(sourceName, parameterName, this.repositoryContentManager.getTypeDefByName(sourceName, classification.getName()), classification.getProperties(), methodName);
                    continue;
                }
                OMRSErrorCode errorCode = OMRSErrorCode.NULL_CLASSIFICATION_NAME;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{parameterName, methodName, sourceName});
                throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
        }
    }

    public void validateMatchCriteria(String sourceName, String parameterName, TypeDefProperties matchCriteria, String methodName) throws InvalidParameterException {
        if (matchCriteria == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NO_MATCH_CRITERIA;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{parameterName, methodName, sourceName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public void validateMatchCriteria(String sourceName, String matchCriteriaParameterName, String matchPropertiesParameterName, MatchCriteria matchCriteria, InstanceProperties matchProperties, String methodName) throws InvalidParameterException {
        if (matchCriteria == null && matchProperties == null) {
            return;
        }
        if (matchCriteria == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NO_MATCH_CRITERIA;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{matchCriteriaParameterName, methodName, sourceName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (matchProperties == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NO_MATCH_CRITERIA;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{matchPropertiesParameterName, methodName, sourceName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public void validateSearchCriteria(String sourceName, String parameterName, String searchCriteria, String methodName) throws InvalidParameterException {
        if (searchCriteria == null || "".equals(searchCriteria)) {
            OMRSErrorCode errorCode = OMRSErrorCode.NO_SEARCH_CRITERIA;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{parameterName, methodName, sourceName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public void validatePropertiesForType(String sourceName, String parameterName, TypeDef typeDef, InstanceProperties properties, String methodName) throws PropertyErrorException {
        List<TypeDefAttribute> typeDefAttributes;
        String thisMethodName = "validatePropertiesForType";
        if (properties == null) {
            return;
        }
        if (typeDef == null) {
            this.throwValidatorLogicError(sourceName, methodName, "validatePropertiesForType");
        }
        String typeDefCategoryName = null;
        String typeDefName = typeDef.getName();
        if (typeDef.getCategory() != null) {
            typeDefCategoryName = typeDef.getCategory().getName();
        }
        if ((typeDefAttributes = this.repositoryContentManager.getAllPropertiesForTypeDef(sourceName, typeDef, methodName)) == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NO_PROPERTIES_FOR_TYPE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{typeDefCategoryName, typeDefName, sourceName});
            throw new PropertyErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        Iterator propertyList = properties.getPropertyNames();
        while (propertyList.hasNext()) {
            String propertyName = propertyList.next().toString();
            if (propertyName == null) {
                OMRSErrorCode errorCode = OMRSErrorCode.NULL_PROPERTY_NAME_FOR_INSTANCE;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{parameterName, methodName, sourceName});
                throw new PropertyErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            AttributeTypeDefCategory propertyDefinitionType = null;
            boolean recognizedProperty = false;
            for (TypeDefAttribute typeDefAttribute : typeDefAttributes) {
                if (typeDefAttribute == null || !propertyName.equals(typeDefAttribute.getAttributeName())) continue;
                recognizedProperty = true;
                AttributeTypeDef attributeTypeDef = typeDefAttribute.getAttributeType();
                if (attributeTypeDef == null) {
                    propertyDefinitionType = AttributeTypeDefCategory.PRIMITIVE;
                    continue;
                }
                propertyDefinitionType = attributeTypeDef.getCategory();
            }
            if (!recognizedProperty) {
                OMRSErrorCode errorCode = OMRSErrorCode.BAD_PROPERTY_FOR_TYPE;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{propertyName, typeDefCategoryName, typeDefName, sourceName});
                throw new PropertyErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            InstancePropertyValue propertyValue = properties.getPropertyValue(propertyName);
            if (propertyValue == null) {
                OMRSErrorCode errorCode = OMRSErrorCode.NULL_PROPERTY_VALUE_FOR_INSTANCE;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{parameterName, methodName, sourceName});
                throw new PropertyErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            InstancePropertyCategory propertyType = propertyValue.getInstancePropertyCategory();
            if (propertyType == null) {
                OMRSErrorCode errorCode = OMRSErrorCode.NULL_PROPERTY_TYPE_FOR_INSTANCE;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{parameterName, methodName, sourceName});
                throw new PropertyErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            boolean validPropertyType = false;
            String validPropertyTypeName = propertyType.getName();
            switch (propertyType) {
                case PRIMITIVE: {
                    if (propertyDefinitionType != AttributeTypeDefCategory.PRIMITIVE) break;
                    validPropertyType = true;
                    break;
                }
                case ENUM: {
                    if (propertyDefinitionType != AttributeTypeDefCategory.ENUM_DEF) break;
                    validPropertyType = true;
                    break;
                }
                case MAP: {
                    if (propertyDefinitionType != AttributeTypeDefCategory.COLLECTION) break;
                    validPropertyType = true;
                    break;
                }
                case ARRAY: {
                    if (propertyDefinitionType != AttributeTypeDefCategory.COLLECTION) break;
                    validPropertyType = true;
                    break;
                }
                case STRUCT: {
                    if (propertyDefinitionType != AttributeTypeDefCategory.COLLECTION) break;
                    validPropertyType = true;
                }
            }
            if (validPropertyType) continue;
            OMRSErrorCode errorCode = OMRSErrorCode.BAD_PROPERTY_TYPE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{propertyName, propertyType.getName(), typeDefCategoryName, typeDefName, validPropertyTypeName, sourceName});
            throw new PropertyErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public void validatePropertiesForType(String sourceName, String parameterName, TypeDefSummary typeDefSummary, InstanceProperties properties, String methodName) throws PropertyErrorException, TypeErrorException {
        this.validateRepositoryContentManager(methodName);
        if (typeDefSummary == null) {
            String thisMethodName = "validatePropertiesForType";
            this.throwValidatorLogicError(sourceName, methodName, "validatePropertiesForType");
        }
        TypeDef typeDef = this.repositoryContentManager.getTypeDef(sourceName, parameterName, parameterName, typeDefSummary.getGUID(), typeDefSummary.getName(), methodName);
        this.validatePropertiesForType(sourceName, parameterName, typeDef, properties, methodName);
    }

    public void validateNewPropertiesForType(String sourceName, String parameterName, TypeDef typeDef, InstanceProperties properties, String methodName) throws PropertyErrorException {
        if (properties == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NO_NEW_PROPERTIES;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{parameterName, methodName, sourceName});
            throw new PropertyErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        this.validatePropertiesForType(sourceName, parameterName, typeDef, properties, methodName);
    }

    public boolean verifyInstanceType(String instanceTypeGUID, InstanceHeader instance) {
        if (instance != null) {
            if (instanceTypeGUID == null) {
                return true;
            }
            InstanceType entityType = instance.getType();
            if (entityType != null && instanceTypeGUID.equals(entityType.getTypeDefGUID())) {
                return true;
            }
        }
        return false;
    }

    public void validateEntityFromStore(String sourceName, String guid, EntitySummary entity, String methodName) throws RepositoryErrorException, EntityNotKnownException {
        if (entity == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.ENTITY_NOT_KNOWN;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{guid, methodName, sourceName});
            throw new EntityNotKnownException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (!this.validEntity(sourceName, entity)) {
            OMRSErrorCode errorCode = OMRSErrorCode.INVALID_ENTITY_FROM_STORE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{guid, sourceName, methodName, entity.toString()});
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public void validateEntityFromStore(String sourceName, String guid, EntityDetail entity, String methodName) throws RepositoryErrorException, EntityNotKnownException {
        if (entity == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.ENTITY_NOT_KNOWN;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{guid, methodName, sourceName});
            throw new EntityNotKnownException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (!this.validEntity(sourceName, entity)) {
            OMRSErrorCode errorCode = OMRSErrorCode.INVALID_ENTITY_FROM_STORE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{guid, sourceName, methodName, entity.toString()});
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public void validateRelationshipFromStore(String sourceName, String guid, Relationship relationship, String methodName) throws RepositoryErrorException, RelationshipNotKnownException {
        if (relationship == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.RELATIONSHIP_NOT_KNOWN;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{guid, methodName, sourceName});
            throw new RelationshipNotKnownException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (!this.validRelationship(sourceName, relationship)) {
            OMRSErrorCode errorCode = OMRSErrorCode.INVALID_RELATIONSHIP_FROM_STORE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{guid, sourceName, methodName, relationship.toString()});
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public void validateInstanceType(String sourceName, InstanceHeader instance) throws RepositoryErrorException {
        String methodName = "validateInstanceType";
        if (instance != null) {
            InstanceType instanceType = instance.getType();
            if (instanceType != null) {
                if (this.isActiveType(sourceName, instanceType.getTypeDefGUID(), instanceType.getTypeDefName())) {
                    return;
                }
                OMRSErrorCode errorCode = OMRSErrorCode.INACTIVE_INSTANCE_TYPE;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"validateInstanceType", sourceName, instance.getGUID(), instanceType.getTypeDefName(), instanceType.getTypeDefGUID()});
                throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "validateInstanceType", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_INSTANCE_TYPE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"validateInstanceType", sourceName});
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "validateInstanceType", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        String thisMethodName = "validateInstanceType";
        this.throwValidatorLogicError(sourceName, "validateInstanceType", "validateInstanceType");
    }

    public void validateType(String sourceName, String typeParameterName, TypeDefSummary typeDefSummary, TypeDefCategory category, String methodName) throws TypeErrorException, InvalidParameterException {
        if (!this.isActiveType(sourceName, typeDefSummary.getGUID(), typeDefSummary.getName())) {
            OMRSErrorCode errorCode = OMRSErrorCode.TYPEDEF_NOT_KNOWN;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{typeDefSummary.getName(), typeDefSummary.getGUID(), typeParameterName, methodName, sourceName});
            throw new TypeErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public void validateInstanceType(String sourceName, InstanceHeader instance, String typeGUIDParameterName, String typeNameParameterName, String expectedTypeGUID, String expectedTypeName) throws RepositoryErrorException, TypeErrorException, InvalidParameterException {
        String methodName = "validateInstanceType";
        this.validateInstanceType(sourceName, instance);
        if (expectedTypeGUID == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_TYPEDEF_IDENTIFIER;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{typeGUIDParameterName, "validateInstanceType", sourceName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "validateInstanceType", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (expectedTypeName == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_TYPEDEF_NAME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{typeNameParameterName, "validateInstanceType", sourceName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "validateInstanceType", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public boolean verifyInstanceHasRightStatus(List<InstanceStatus> validStatuses, InstanceHeader instance) {
        if (instance != null && validStatuses != null) {
            for (InstanceStatus status : validStatuses) {
                if (status != instance.getStatus()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public void validateInstanceStatus(String sourceName, String instanceStatusParameterName, InstanceStatus instanceStatus, TypeDef typeDef, String methodName) throws StatusNotSupportedException {
        if (instanceStatus == InstanceStatus.DELETED) {
            OMRSErrorCode errorCode = OMRSErrorCode.BAD_DELETE_INSTANCE_STATUS;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{instanceStatus.getName(), instanceStatusParameterName, methodName, sourceName, typeDef.getName()});
            throw new StatusNotSupportedException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (instanceStatus != null) {
            if (typeDef != null) {
                List validStatuses = typeDef.getValidInstanceStatusList();
                for (InstanceStatus validStatus : validStatuses) {
                    if (instanceStatus != validStatus) continue;
                    return;
                }
                OMRSErrorCode errorCode = OMRSErrorCode.BAD_INSTANCE_STATUS;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{instanceStatus.getName(), instanceStatusParameterName, methodName, sourceName, typeDef.getName()});
                throw new StatusNotSupportedException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_TYPEDEF;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"typeDef", methodName, sourceName});
            throw new StatusNotSupportedException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public void validateNewStatus(String sourceName, String instanceStatusParameterName, InstanceStatus instanceStatus, TypeDef typeDef, String methodName) throws StatusNotSupportedException, InvalidParameterException {
        if (instanceStatus == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_INSTANCE_STATUS;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{instanceStatusParameterName, methodName, sourceName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        this.validateInstanceStatus(sourceName, instanceStatusParameterName, instanceStatus, typeDef, methodName);
    }

    public void validateInstanceStatusForDelete(String sourceName, InstanceHeader instance, String methodName) throws InvalidParameterException {
        if (instance != null) {
            if (instance.getStatus() == InstanceStatus.DELETED) {
                OMRSErrorCode errorCode = OMRSErrorCode.INSTANCE_ALREADY_DELETED;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName, sourceName, instance.getGUID()});
                throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
        } else {
            String thisMethodName = "validateInstanceStatusForDelete";
            this.throwValidatorLogicError(sourceName, methodName, "validateInstanceStatusForDelete");
        }
    }

    public void validateEntityIsNotDeleted(String sourceName, InstanceHeader instance, String methodName) throws EntityNotKnownException {
        if (instance != null) {
            if (instance.getStatus() == InstanceStatus.DELETED) {
                OMRSErrorCode errorCode = OMRSErrorCode.ENTITY_NOT_KNOWN;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{instance.getGUID(), methodName, sourceName});
                throw new EntityNotKnownException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
        } else {
            String thisMethodName = "validateEntityIsNotDeleted";
            this.throwValidatorLogicError(sourceName, methodName, "validateEntityIsNotDeleted");
        }
    }

    public void validateEntityIsDeleted(String sourceName, InstanceHeader instance, String methodName) throws EntityNotDeletedException {
        if (instance != null) {
            if (instance.getStatus() != InstanceStatus.DELETED) {
                OMRSErrorCode errorCode = OMRSErrorCode.INSTANCE_NOT_DELETED;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName, sourceName, instance.getGUID()});
                throw new EntityNotDeletedException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
        } else {
            String thisMethodName = "validateEntityIsDeleted";
            this.throwValidatorLogicError(sourceName, methodName, "validateEntityIsDeleted");
        }
    }

    public void validateRelationshipIsNotDeleted(String sourceName, InstanceHeader instance, String methodName) throws RelationshipNotKnownException {
        if (instance != null) {
            if (instance.getStatus() == InstanceStatus.DELETED) {
                OMRSErrorCode errorCode = OMRSErrorCode.RELATIONSHIP_NOT_KNOWN;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{instance.getGUID(), methodName, sourceName});
                throw new RelationshipNotKnownException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
        } else {
            String thisMethodName = "validateRelationshipIsNotDeleted";
            this.throwValidatorLogicError(sourceName, methodName, "validateRelationshipIsNotDeleted");
        }
    }

    public void validateRelationshipIsDeleted(String sourceName, InstanceHeader instance, String methodName) throws RelationshipNotDeletedException {
        if (instance != null) {
            if (instance.getStatus() != InstanceStatus.DELETED) {
                OMRSErrorCode errorCode = OMRSErrorCode.INSTANCE_NOT_DELETED;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName, sourceName, instance.getGUID()});
                throw new RelationshipNotDeletedException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
        } else {
            String thisMethodName = "validateRelationshipIsDeleted";
            this.throwValidatorLogicError(sourceName, methodName, "validateRelationshipIsDeleted");
        }
    }

    public void validateRelationshipEnds(String sourceName, EntityProxy entityOneProxy, EntityProxy entityTwoProxy, TypeDef typeDef, String methodName) throws InvalidParameterException {
        String thisMethodName = "validateRelationshipEnds";
        if (entityOneProxy != null && entityTwoProxy != null && typeDef != null) {
            try {
                RelationshipDef relationshipDef = (RelationshipDef)typeDef;
                RelationshipEndDef entityOneEndDef = null;
                RelationshipEndDef entityTwoEndDef = null;
                TypeDefLink entityOneTypeDef = null;
                TypeDefLink entityTwoTypeDef = null;
                String entityOneTypeDefGUID = null;
                String entityOneTypeDefName = null;
                String entityTwoTypeDefGUID = null;
                String entityTwoTypeDefName = null;
                InstanceType entityOneType = null;
                InstanceType entityTwoType = null;
                String entityOneTypeGUID = null;
                String entityOneTypeName = null;
                String entityTwoTypeGUID = null;
                String entityTwoTypeName = null;
                if (relationshipDef != null) {
                    entityOneEndDef = relationshipDef.getEndDef1();
                    entityTwoEndDef = relationshipDef.getEndDef2();
                }
                if (entityOneEndDef != null && entityTwoEndDef != null) {
                    entityOneTypeDef = entityOneEndDef.getEntityType();
                    entityTwoTypeDef = entityTwoEndDef.getEntityType();
                }
                if (entityOneTypeDef != null && entityTwoTypeDef != null) {
                    entityOneTypeDefGUID = entityOneTypeDef.getGUID();
                    entityOneTypeDefName = entityOneTypeDef.getName();
                    entityTwoTypeDefGUID = entityTwoTypeDef.getGUID();
                    entityTwoTypeDefName = entityTwoTypeDef.getName();
                }
                if (entityOneProxy != null && entityTwoProxy != null) {
                    entityOneType = entityOneProxy.getType();
                    entityTwoType = entityTwoProxy.getType();
                }
                if (entityOneType != null && entityTwoType != null) {
                    entityOneTypeGUID = entityOneType.getTypeDefGUID();
                    entityOneTypeName = entityOneType.getTypeDefName();
                    entityTwoTypeGUID = entityTwoType.getTypeDefGUID();
                    entityTwoTypeName = entityTwoType.getTypeDefName();
                }
                if (entityOneTypeDefGUID != null && entityOneTypeDefName != null && entityTwoTypeDefGUID != null && entityTwoTypeDefName != null && entityOneTypeGUID != null && entityOneTypeName != null && entityTwoTypeGUID != null && entityTwoTypeName != null && entityOneTypeDefGUID.equals(entityOneTypeGUID) && entityTwoTypeDefGUID.equals(entityTwoTypeGUID) && entityOneTypeDefName.equals(entityOneTypeName) && entityTwoTypeDefName.equals(entityTwoTypeName)) {
                    return;
                }
                OMRSErrorCode errorCode = OMRSErrorCode.INVALID_RELATIONSHIP_ENDS;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName, sourceName, typeDef.toString(), entityOneProxy.toString(), entityTwoProxy.toString()});
                throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            catch (InvalidParameterException error) {
                throw error;
            }
            catch (Throwable error) {
                this.throwValidatorLogicError(sourceName, methodName, "validateRelationshipEnds");
            }
        } else {
            this.throwValidatorLogicError(sourceName, methodName, "validateRelationshipEnds");
        }
    }

    public boolean verifyEntityIsClassified(List<String> requiredClassifications, EntitySummary entity) {
        if (requiredClassifications != null) {
            List entityClassifications = entity.getClassifications();
            if (entityClassifications != null) {
                for (String requiredClassification : requiredClassifications) {
                    if (requiredClassification == null) continue;
                    for (Classification entityClassification : entityClassifications) {
                        if (entityClassification == null || !requiredClassification.equals(entityClassification.getName())) continue;
                        return true;
                    }
                }
            }
        } else {
            return true;
        }
        return false;
    }

    public int countMatchingPropertyValues(InstanceProperties matchProperties, InstanceProperties instanceProperties) {
        int matchingProperties = 0;
        if (matchProperties != null && instanceProperties != null) {
            Iterator matchPropertyNames = matchProperties.getPropertyNames();
            while (matchPropertyNames.hasNext()) {
                String matchPropertyName = (String)matchPropertyNames.next();
                if (matchPropertyName == null) continue;
                InstancePropertyValue matchPropertyValue = matchProperties.getPropertyValue(matchPropertyName);
                Iterator instancePropertyNames = instanceProperties.getPropertyNames();
                while (instancePropertyNames.hasNext()) {
                    String instancePropertyName = (String)instancePropertyNames.next();
                    if (instancePropertyName == null) continue;
                    InstancePropertyValue instancePropertyValue = instanceProperties.getPropertyValue(instancePropertyName);
                    if (!instancePropertyName.equals(matchPropertyName) || !instancePropertyValue.equals((Object)matchPropertyValue)) continue;
                    ++matchingProperties;
                }
            }
        }
        return matchingProperties;
    }

    private boolean checkStringPropertyValue(Map<String, InstancePropertyValue> propertyMap, String propertyName, String expectedValue) {
        boolean result = false;
        InstancePropertyValue instancePropertyValue = propertyMap.get(propertyName);
        if (instancePropertyValue != null && instancePropertyValue.getInstancePropertyCategory() == InstancePropertyCategory.PRIMITIVE) {
            try {
                PrimitivePropertyValue primitivePropertyValue = (PrimitivePropertyValue)instancePropertyValue;
                String matchValue = (String)primitivePropertyValue.getPrimitiveValue();
                if (matchValue != null && matchValue.equals(expectedValue)) {
                    result = true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result;
    }

    private boolean checkDatePropertyValue(Map<String, InstancePropertyValue> propertyMap, String propertyName, Date expectedValue) {
        boolean result = false;
        InstancePropertyValue instancePropertyValue = propertyMap.get(propertyName);
        if (instancePropertyValue != null && instancePropertyValue.getInstancePropertyCategory() == InstancePropertyCategory.PRIMITIVE) {
            try {
                PrimitivePropertyValue primitivePropertyValue = (PrimitivePropertyValue)instancePropertyValue;
                Date matchValue = (Date)primitivePropertyValue.getPrimitiveValue();
                if (matchValue != null && matchValue.equals(expectedValue)) {
                    result = true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result;
    }

    public int countMatchingPropertyValues(InstanceProperties matchProperties, InstanceAuditHeader instanceHeader, String metadataCollectionId) {
        Map propertyMap;
        String metadataCollectionIdPropertyName = "metadataCollectionId";
        String typeNamePropertyName = "typeName";
        String typeGUIDPropertyName = "typeGUID";
        String createdByPropertyName = "createdBy";
        String updatedByPropertyName = "updatedBy";
        String createTimePropertyName = "createTime";
        String updateTimePropertyName = "updateTime";
        int matchingProperties = 0;
        if (matchProperties != null && instanceHeader != null && (propertyMap = matchProperties.getInstanceProperties()) != null) {
            if (this.checkStringPropertyValue(propertyMap, "metadataCollectionId", metadataCollectionId)) {
                ++matchingProperties;
            }
            if (this.checkStringPropertyValue(propertyMap, "typeName", instanceHeader.getType().getTypeDefName())) {
                ++matchingProperties;
            }
            if (this.checkStringPropertyValue(propertyMap, "typeGUID", instanceHeader.getType().getTypeDefGUID())) {
                ++matchingProperties;
            }
            if (this.checkStringPropertyValue(propertyMap, "createdBy", instanceHeader.getCreatedBy())) {
                ++matchingProperties;
            }
            if (this.checkStringPropertyValue(propertyMap, "updatedBy", instanceHeader.getUpdatedBy())) {
                ++matchingProperties;
            }
            if (this.checkDatePropertyValue(propertyMap, "createTime", instanceHeader.getCreateTime())) {
                ++matchingProperties;
            }
            if (this.checkDatePropertyValue(propertyMap, "updateTime", instanceHeader.getUpdateTime())) {
                ++matchingProperties;
            }
        }
        return matchingProperties;
    }

    public boolean verifyMatchingInstancePropertyValues(InstanceProperties matchProperties, String metadataCollectionId, InstanceAuditHeader instanceHeader, InstanceProperties instanceProperties, MatchCriteria matchCriteria) {
        if (matchProperties != null) {
            int matchingProperties = this.countMatchingPropertyValues(matchProperties, instanceProperties) + this.countMatchingPropertyValues(matchProperties, instanceHeader, metadataCollectionId);
            switch (matchCriteria) {
                case ALL: {
                    if (matchingProperties != matchProperties.getPropertyCount()) break;
                    return true;
                }
                case ANY: {
                    if (matchingProperties <= 0) break;
                    return true;
                }
                case NONE: {
                    if (matchingProperties != 0) break;
                    return true;
                }
            }
        } else {
            return true;
        }
        return false;
    }

    public void validateReferenceInstanceHeader(String sourceName, String localMetadataCollectionId, String instanceParameterName, InstanceHeader instance, String methodName) throws InvalidParameterException, RepositoryErrorException {
        if (instance == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_REFERENCE_INSTANCE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{sourceName, methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        this.validateInstanceType(sourceName, instance);
        this.validateHomeMetadataGUID(sourceName, instanceParameterName, instance.getMetadataCollectionId(), methodName);
        if (localMetadataCollectionId.equals(instance.getMetadataCollectionId())) {
            OMRSErrorCode errorCode = OMRSErrorCode.LOCAL_REFERENCE_INSTANCE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{sourceName, methodName, instanceParameterName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public void validateEntityProxy(String sourceName, String localMetadataCollectionId, String proxyParameterName, EntityProxy entityProxy, String methodName) throws InvalidParameterException {
        if (entityProxy == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_ENTITY_PROXY;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{sourceName, proxyParameterName, methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        this.validateHomeMetadataGUID(sourceName, proxyParameterName, entityProxy.getMetadataCollectionId(), methodName);
        if (localMetadataCollectionId.equals(entityProxy.getMetadataCollectionId())) {
            OMRSErrorCode errorCode = OMRSErrorCode.LOCAL_ENTITY_PROXY;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{sourceName, proxyParameterName, methodName});
            throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean verifyInstancePropertiesMatchSearchCriteria(String sourceName, InstanceProperties properties, String searchCriteria, String methodName) throws RepositoryErrorException {
        if (properties == null) {
            return false;
        }
        Iterator propertyNames = properties.getPropertyNames();
        try {
            block9: while (propertyNames.hasNext()) {
                InstancePropertyValue propertyValue = properties.getPropertyValue((String)propertyNames.next());
                switch (propertyValue.getInstancePropertyCategory()) {
                    case PRIMITIVE: {
                        PrimitivePropertyValue primitivePropertyValue = (PrimitivePropertyValue)propertyValue;
                        if (primitivePropertyValue.getPrimitiveDefCategory() != PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING) break;
                        String stringProperty = (String)primitivePropertyValue.getPrimitiveValue();
                        if (stringProperty == null || !stringProperty.matches(searchCriteria)) continue block9;
                        return true;
                    }
                    case ENUM: {
                        EnumPropertyValue enumPropertyValue = (EnumPropertyValue)propertyValue;
                        String enumValue = enumPropertyValue.getSymbolicName();
                        if (enumValue == null || !enumValue.matches(searchCriteria)) break;
                        return true;
                    }
                    case STRUCT: {
                        StructPropertyValue structPropertyValue = (StructPropertyValue)propertyValue;
                        if (!this.verifyInstancePropertiesMatchSearchCriteria(sourceName, structPropertyValue.getAttributes(), searchCriteria, methodName)) break;
                        return true;
                    }
                    case ARRAY: {
                        ArrayPropertyValue arrayPropertyValue = (ArrayPropertyValue)propertyValue;
                        if (!this.verifyInstancePropertiesMatchSearchCriteria(sourceName, arrayPropertyValue.getArrayValues(), searchCriteria, methodName)) break;
                        return true;
                    }
                    case MAP: {
                        MapPropertyValue mapPropertyValue = (MapPropertyValue)propertyValue;
                        if (!this.verifyInstancePropertiesMatchSearchCriteria(sourceName, mapPropertyValue.getMapValues(), searchCriteria, methodName)) break;
                        return true;
                    }
                }
            }
            return false;
        }
        catch (Throwable error) {
            OMRSErrorCode errorCode = OMRSErrorCode.BAD_PROPERTY_FOR_INSTANCE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{sourceName, methodName});
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
        }
    }

    private void validateRepositoryContentManager(String methodName) {
        if (this.repositoryContentManager == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.LOCAL_REPOSITORY_CONFIGURATION_ERROR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[0]);
            throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    private void throwValidatorLogicError(String sourceName, String originatingMethodName, String localMethodName) {
        OMRSErrorCode errorCode = OMRSErrorCode.VALIDATION_LOGIC_ERROR;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{sourceName, localMethodName, originatingMethodName});
        throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), localMethodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public boolean isATypeOf(String sourceName, InstanceAuditHeader instance, String typeName, String localMethodName) {
        InstanceType instanceType;
        String methodName = "isATypeOf";
        if (typeName == null) {
            this.throwValidatorLogicError(sourceName, "isATypeOf", localMethodName);
        }
        if (instance == null) {
            this.throwValidatorLogicError(sourceName, "isATypeOf", localMethodName);
        }
        if ((instanceType = instance.getType()) != null) {
            String entityTypeName = instanceType.getTypeDefName();
            if (typeName.equals(entityTypeName)) {
                return true;
            }
            List superTypes = instanceType.getTypeDefSuperTypes();
            if (superTypes != null) {
                for (TypeDefLink typeDefLink : superTypes) {
                    if (typeDefLink == null || !typeName.equals(typeDefLink.getName())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void validateAtMostOneEntityResult(List<EntityDetail> findResults, String typeName, String serviceName, String methodName) throws RepositoryErrorException {
        if (findResults != null && findResults.size() > 1) {
            OMRSErrorCode errorCode = OMRSErrorCode.MULTIPLE_ENTITIES_FOUND;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{typeName, serviceName, methodName, findResults.toString()});
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public void validateAtMostOneRelationshipResult(List<Relationship> findResults, String typeName, String serviceName, String methodName) throws RepositoryErrorException {
        if (findResults != null && findResults.size() > 1) {
            OMRSErrorCode errorCode = OMRSErrorCode.MULTIPLE_RELATIONSHIPS_FOUND;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{typeName, serviceName, methodName, findResults.toString()});
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }
}

