/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.rest.server;

import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceGraph;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefGallery;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.HomeEntityException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.HomeRelationshipException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidEntityException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidRelationshipException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidTypeDefException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PatchErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.StatusNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefInUseException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.localrepository.repositoryconnector.LocalOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.rest.properties.AttributeTypeDefListResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.AttributeTypeDefResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.BooleanResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.EntityCreateRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.EntityDetailResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.EntityListResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.EntityNeighborhoodFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.EntityNeighborhoodHistoricalFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.EntityPropertyFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.EntityPropertyHistoricalFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.EntitySummaryResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.InstanceGraphRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.InstanceGraphResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.InstancePropertiesRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.MetadataCollectionIdResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.OMRSAPIFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.OMRSAPIHistoricalFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.OMRSAPIResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.PropertyMatchFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.PropertyMatchHistoricalFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.RelatedEntitiesFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.RelatedEntitiesHistoricalFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.RelationshipCreateRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.RelationshipListResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.RelationshipResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.TypeDefChangeRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.TypeDefGalleryResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.TypeDefListResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.TypeDefReIdentifyRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.TypeDefResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.TypeDefValidationForRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.TypeLimitedFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.TypeLimitedHistoricalFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.VoidResponse;

public class OMRSRepositoryRESTServices {
    private static OMRSMetadataCollection localMetadataCollection = null;
    private static String localServerURL = null;

    public static void setLocalRepository(LocalOMRSRepositoryConnector localRepositoryConnector, String localServerURL) {
        try {
            localMetadataCollection = localRepositoryConnector.getMetadataCollection();
        }
        catch (Throwable error) {
            localMetadataCollection = null;
        }
        OMRSRepositoryRESTServices.localServerURL = localServerURL;
    }

    public static String getEntityURL(String ... guid) {
        String urlTemplate = "/instances/entity/{0}";
        MessageFormat mf = new MessageFormat("/instances/entity/{0}");
        return localServerURL + mf.format(guid);
    }

    public static String getRelationshipURL(String ... guid) {
        String urlTemplate = "/instances/relationship/{0}";
        MessageFormat mf = new MessageFormat("/instances/relationship/{0}");
        return localServerURL + mf.format(guid);
    }

    public MetadataCollectionIdResponse getMetadataCollectionId() {
        String methodName = "getMetadataCollectionId";
        MetadataCollectionIdResponse response = new MetadataCollectionIdResponse();
        try {
            this.validateLocalRepository("getMetadataCollectionId");
            response.setMetadataCollectionId(localMetadataCollection.getMetadataCollectionId());
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public TypeDefGalleryResponse getAllTypes(String userId) {
        String methodName = "getAllTypes";
        TypeDefGalleryResponse response = new TypeDefGalleryResponse();
        try {
            this.validateLocalRepository("getAllTypes");
            TypeDefGallery typeDefGallery = localMetadataCollection.getAllTypes(userId);
            if (typeDefGallery != null) {
                response.setAttributeTypeDefs(typeDefGallery.getAttributeTypeDefs());
                response.setTypeDefs((List)typeDefGallery.getTypeDefs());
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public TypeDefGalleryResponse findTypesByName(String userId, String name) {
        String methodName = "findTypesByName";
        TypeDefGalleryResponse response = new TypeDefGalleryResponse();
        try {
            this.validateLocalRepository("findTypesByName");
            TypeDefGallery typeDefGallery = localMetadataCollection.findTypesByName(userId, name);
            if (typeDefGallery != null) {
                response.setAttributeTypeDefs(typeDefGallery.getAttributeTypeDefs());
                response.setTypeDefs((List)typeDefGallery.getTypeDefs());
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public TypeDefListResponse findTypeDefsByCategory(String userId, TypeDefCategory category) {
        String methodName = "findTypeDefsByCategory";
        TypeDefListResponse response = new TypeDefListResponse();
        try {
            this.validateLocalRepository("findTypeDefsByCategory");
            response.setTypeDefs(localMetadataCollection.findTypeDefsByCategory(userId, category));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public AttributeTypeDefListResponse findAttributeTypeDefsByCategory(String userId, AttributeTypeDefCategory category) {
        String methodName = "findAttributeTypeDefsByCategory";
        AttributeTypeDefListResponse response = new AttributeTypeDefListResponse();
        try {
            this.validateLocalRepository("findAttributeTypeDefsByCategory");
            response.setAttributeTypeDefs(localMetadataCollection.findAttributeTypeDefsByCategory(userId, category));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public TypeDefListResponse findTypeDefsByProperty(String userId, TypeDefProperties matchCriteria) {
        String methodName = "findTypeDefsByProperty";
        TypeDefListResponse response = new TypeDefListResponse();
        try {
            this.validateLocalRepository("findTypeDefsByProperty");
            response.setTypeDefs(localMetadataCollection.findTypeDefsByProperty(userId, matchCriteria));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public TypeDefListResponse findTypesByExternalID(String userId, String standard, String organization, String identifier) {
        String methodName = "findTypesByExternalID";
        TypeDefListResponse response = new TypeDefListResponse();
        try {
            this.validateLocalRepository("findTypesByExternalID");
            List typeDefs = localMetadataCollection.findTypesByExternalID(userId, standard, organization, identifier);
            response.setTypeDefs(typeDefs);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public TypeDefListResponse searchForTypeDefs(String userId, String searchCriteria) {
        String methodName = "searchForTypeDefs";
        TypeDefListResponse response = new TypeDefListResponse();
        try {
            this.validateLocalRepository("searchForTypeDefs");
            response.setTypeDefs(localMetadataCollection.searchForTypeDefs(userId, searchCriteria));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public TypeDefResponse getTypeDefByGUID(String userId, String guid) {
        String methodName = "getTypeDefByGUID";
        TypeDefResponse response = new TypeDefResponse();
        try {
            this.validateLocalRepository("getTypeDefByGUID");
            response.setTypeDef(localMetadataCollection.getTypeDefByGUID(userId, guid));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefNotKnownException error) {
            this.captureTypeDefNotKnownException(response, error);
        }
        return response;
    }

    public AttributeTypeDefResponse getAttributeTypeDefByGUID(String userId, String guid) {
        String methodName = "getAttributeTypeDefByGUID";
        AttributeTypeDefResponse response = new AttributeTypeDefResponse();
        try {
            this.validateLocalRepository("getAttributeTypeDefByGUID");
            response.setAttributeTypeDef(localMetadataCollection.getAttributeTypeDefByGUID(userId, guid));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefNotKnownException error) {
            this.captureTypeDefNotKnown((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public TypeDefResponse getTypeDefByName(String userId, String name) {
        String methodName = "getTypeDefByName";
        TypeDefResponse response = new TypeDefResponse();
        try {
            this.validateLocalRepository("getTypeDefByName");
            response.setTypeDef(localMetadataCollection.getTypeDefByName(userId, name));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefNotKnownException error) {
            this.captureTypeDefNotKnownException(response, error);
        }
        return response;
    }

    public AttributeTypeDefResponse getAttributeTypeDefByName(String userId, String name) {
        String methodName = "getAttributeTypeDefByName";
        AttributeTypeDefResponse response = new AttributeTypeDefResponse();
        try {
            this.validateLocalRepository("getAttributeTypeDefByName");
            response.setAttributeTypeDef(localMetadataCollection.getAttributeTypeDefByName(userId, name));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefNotKnownException error) {
            this.captureTypeDefNotKnown((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public VoidResponse addTypeDefGallery(String userId, TypeDefGallery newTypes) {
        String methodName = "addTypeDefGallery";
        VoidResponse response = new VoidResponse();
        try {
            this.validateLocalRepository("addTypeDefGallery");
            localMetadataCollection.addTypeDefGallery(userId, newTypes);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefNotSupportedException error) {
            this.captureTypeDefNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefKnownException error) {
            this.captureTypeDefKnownException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefConflictException error) {
            this.captureTypeDefConflictException((OMRSAPIResponse)response, error);
        }
        catch (InvalidTypeDefException error) {
            this.captureInvalidTypeDefException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public VoidResponse addTypeDef(String userId, TypeDef newTypeDef) {
        String methodName = "addTypeDef";
        VoidResponse response = new VoidResponse();
        try {
            this.validateLocalRepository("addTypeDef");
            localMetadataCollection.addTypeDef(userId, newTypeDef);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefNotSupportedException error) {
            this.captureTypeDefNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefKnownException error) {
            this.captureTypeDefKnownException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefConflictException error) {
            this.captureTypeDefConflictException((OMRSAPIResponse)response, error);
        }
        catch (InvalidTypeDefException error) {
            this.captureInvalidTypeDefException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public VoidResponse addAttributeTypeDef(String userId, AttributeTypeDef newAttributeTypeDef) {
        String methodName = "addAttributeTypeDef";
        VoidResponse response = new VoidResponse();
        try {
            this.validateLocalRepository("addAttributeTypeDef");
            localMetadataCollection.addAttributeTypeDef(userId, newAttributeTypeDef);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefNotSupportedException error) {
            this.captureTypeDefNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefKnownException error) {
            this.captureTypeDefKnownException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefConflictException error) {
            this.captureTypeDefConflictException((OMRSAPIResponse)response, error);
        }
        catch (InvalidTypeDefException error) {
            this.captureInvalidTypeDefException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public BooleanResponse verifyTypeDef(String userId, TypeDef typeDef) {
        String methodName = "verifyTypeDef";
        BooleanResponse response = new BooleanResponse();
        try {
            this.validateLocalRepository("verifyTypeDef");
            response.setFlag(localMetadataCollection.verifyTypeDef(userId, typeDef));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefNotSupportedException error) {
            this.captureTypeDefNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefConflictException error) {
            this.captureTypeDefConflictException((OMRSAPIResponse)response, error);
        }
        catch (InvalidTypeDefException error) {
            this.captureInvalidTypeDefException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public BooleanResponse verifyAttributeTypeDef(String userId, AttributeTypeDef attributeTypeDef) {
        String methodName = "verifyAttributeTypeDef";
        BooleanResponse response = new BooleanResponse();
        try {
            this.validateLocalRepository("verifyAttributeTypeDef");
            response.setFlag(localMetadataCollection.verifyAttributeTypeDef(userId, attributeTypeDef));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefNotSupportedException error) {
            this.captureTypeDefNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefConflictException error) {
            this.captureTypeDefConflictException((OMRSAPIResponse)response, error);
        }
        catch (InvalidTypeDefException error) {
            this.captureInvalidTypeDefException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public TypeDefResponse updateTypeDef(String userId, TypeDefPatch typeDefPatch) {
        String methodName = "updateTypeDef";
        TypeDefResponse response = new TypeDefResponse();
        try {
            this.validateLocalRepository("updateTypeDef");
            response.setTypeDef(localMetadataCollection.updateTypeDef(userId, typeDefPatch));
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefNotKnownException error) {
            this.captureTypeDefNotKnownException(response, error);
        }
        catch (PatchErrorException error) {
            response.setRelatedHTTPCode(error.getReportedHTTPCode());
            response.setExceptionClassName(PatchErrorException.class.getName());
            response.setExceptionErrorMessage(error.getErrorMessage());
            response.setExceptionSystemAction(error.getReportedSystemAction());
            response.setExceptionUserAction(error.getReportedUserAction());
        }
        return response;
    }

    public VoidResponse deleteTypeDef(String userId, String obsoleteTypeDefGUID, String obsoleteTypeDefName) {
        String methodName = "deleteTypeDef";
        VoidResponse response = new VoidResponse();
        try {
            this.validateLocalRepository("deleteTypeDef");
            localMetadataCollection.deleteTypeDef(userId, obsoleteTypeDefGUID, obsoleteTypeDefName);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefNotKnownException error) {
            this.captureTypeDefNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefInUseException error) {
            this.captureTypeDefInUseException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public VoidResponse deleteAttributeTypeDef(String userId, String obsoleteTypeDefGUID, String obsoleteTypeDefName) {
        String methodName = "deleteAttributeTypeDef";
        VoidResponse response = new VoidResponse();
        try {
            this.validateLocalRepository("deleteAttributeTypeDef");
            localMetadataCollection.deleteAttributeTypeDef(userId, obsoleteTypeDefGUID, obsoleteTypeDefName);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefNotKnownException error) {
            this.captureTypeDefNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefInUseException error) {
            this.captureTypeDefInUseException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public TypeDefResponse reIdentifyTypeDef(String userId, String originalTypeDefGUID, TypeDefReIdentifyRequest requestParameters) {
        String methodName = "reIdentifyTypeDef";
        String originalTypeDefName = null;
        String newTypeDefGUID = null;
        String newTypeDefName = null;
        TypeDefResponse response = new TypeDefResponse();
        if (requestParameters != null) {
            originalTypeDefName = requestParameters.getOriginalTypeDefName();
            newTypeDefGUID = requestParameters.getNewTypeDefGUID();
            newTypeDefName = requestParameters.getNewTypeDefName();
        }
        try {
            this.validateLocalRepository("reIdentifyTypeDef");
            response.setTypeDef(localMetadataCollection.reIdentifyTypeDef(userId, originalTypeDefGUID, originalTypeDefName, newTypeDefGUID, newTypeDefName));
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefNotKnownException error) {
            this.captureTypeDefNotKnownException(response, error);
        }
        return response;
    }

    public AttributeTypeDefResponse reIdentifyAttributeTypeDef(String userId, String originalAttributeTypeDefGUID, TypeDefReIdentifyRequest requestParameters) {
        String methodName = "reIdentifyAttributeTypeDef";
        String originalAttributeTypeDefName = null;
        String newAttributeTypeDefGUID = null;
        String newAttributeTypeDefName = null;
        AttributeTypeDefResponse response = new AttributeTypeDefResponse();
        if (requestParameters != null) {
            originalAttributeTypeDefName = requestParameters.getOriginalTypeDefName();
            newAttributeTypeDefGUID = requestParameters.getNewTypeDefGUID();
            newAttributeTypeDefName = requestParameters.getNewTypeDefName();
        }
        try {
            this.validateLocalRepository("reIdentifyAttributeTypeDef");
            response.setAttributeTypeDef(localMetadataCollection.reIdentifyAttributeTypeDef(userId, originalAttributeTypeDefGUID, originalAttributeTypeDefName, newAttributeTypeDefGUID, newAttributeTypeDefName));
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefNotKnownException error) {
            this.captureTypeDefNotKnown((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public EntityDetailResponse isEntityKnown(String userId, String guid) {
        String methodName = "isEntityKnown";
        EntityDetailResponse response = new EntityDetailResponse();
        try {
            this.validateLocalRepository("isEntityKnown");
            response.setEntity(localMetadataCollection.isEntityKnown(userId, guid));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public EntitySummaryResponse getEntitySummary(String userId, String guid) {
        String methodName = "getEntitySummary";
        EntitySummaryResponse response = new EntitySummaryResponse();
        try {
            this.validateLocalRepository("getEntitySummary");
            response.setEntity(localMetadataCollection.getEntitySummary(userId, guid));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public EntityDetailResponse getEntityDetail(String guid) {
        return this.getEntityDetail(null, guid);
    }

    public EntityDetailResponse getEntityDetail(String userId, String guid) {
        String methodName = "getEntityDetail";
        EntityDetailResponse response = new EntityDetailResponse();
        try {
            this.validateLocalRepository("getEntityDetail");
            response.setEntity(localMetadataCollection.getEntityDetail(userId, guid));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (EntityProxyOnlyException error) {
            this.captureEntityProxyOnlyException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public EntityDetailResponse getEntityDetail(String userId, String guid, Date asOfTime) {
        String methodName = "getEntityDetail";
        EntityDetailResponse response = new EntityDetailResponse();
        try {
            this.validateLocalRepository("getEntityDetail");
            response.setEntity(localMetadataCollection.getEntityDetail(userId, guid, asOfTime));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (EntityProxyOnlyException error) {
            this.captureEntityProxyOnlyException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public RelationshipListResponse getRelationshipsForEntity(String userId, String entityGUID, TypeLimitedFindRequest findRequestParameters) {
        String methodName = "getRelationshipsForEntity";
        String relationshipTypeGUID = null;
        int fromRelationshipElement = 0;
        List limitResultsByStatus = null;
        String sequencingProperty = null;
        SequencingOrder sequencingOrder = null;
        int pageSize = 0;
        RelationshipListResponse response = new RelationshipListResponse();
        if (findRequestParameters != null) {
            relationshipTypeGUID = findRequestParameters.getTypeGUID();
            fromRelationshipElement = findRequestParameters.getOffset();
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
            sequencingProperty = findRequestParameters.getSequencingProperty();
            sequencingOrder = findRequestParameters.getSequencingOrder();
            pageSize = findRequestParameters.getPageSize();
        }
        try {
            this.validateLocalRepository("getRelationshipsForEntity");
            List relationships = localMetadataCollection.getRelationshipsForEntity(userId, entityGUID, relationshipTypeGUID, fromRelationshipElement, limitResultsByStatus, null, sequencingProperty, sequencingOrder, pageSize);
            response.setRelationships(relationships);
            if (relationships != null) {
                response.setOffset(fromRelationshipElement);
                response.setPageSize(pageSize);
                if (response.getRelationships().size() == pageSize) {
                    String urlTemplate = "{0}/instances/entity/{1}/relationships";
                    TypeLimitedFindRequest nextFindRequestParameters = new TypeLimitedFindRequest(findRequestParameters);
                    nextFindRequestParameters.setOffset(fromRelationshipElement + pageSize);
                    response.setNextPageURL(this.formatNextPageURL(localServerURL + "{0}/instances/entity/{1}/relationships", nextFindRequestParameters, userId, entityGUID));
                }
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (PagingErrorException error) {
            this.capturePagingErrorException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public RelationshipListResponse getRelationshipsForEntityHistory(String userId, String entityGUID, TypeLimitedHistoricalFindRequest findRequestParameters) {
        String methodName = "getRelationshipsForEntityHistory";
        String relationshipTypeGUID = null;
        int fromRelationshipElement = 0;
        List limitResultsByStatus = null;
        Date asOfTime = null;
        String sequencingProperty = null;
        SequencingOrder sequencingOrder = null;
        int pageSize = 0;
        RelationshipListResponse response = new RelationshipListResponse();
        if (findRequestParameters != null) {
            relationshipTypeGUID = findRequestParameters.getTypeGUID();
            fromRelationshipElement = findRequestParameters.getOffset();
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
            asOfTime = findRequestParameters.getAsOfTime();
            sequencingProperty = findRequestParameters.getSequencingProperty();
            sequencingOrder = findRequestParameters.getSequencingOrder();
            pageSize = findRequestParameters.getPageSize();
        }
        try {
            this.validateLocalRepository("getRelationshipsForEntityHistory");
            List relationships = localMetadataCollection.getRelationshipsForEntity(userId, entityGUID, relationshipTypeGUID, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
            response.setRelationships(relationships);
            if (relationships != null) {
                response.setOffset(fromRelationshipElement);
                response.setPageSize(pageSize);
                if (response.getRelationships().size() == pageSize) {
                    String urlTemplate = "{0}/instances/entity/{1}/relationships/history";
                    TypeLimitedHistoricalFindRequest nextFindRequestParameters = new TypeLimitedHistoricalFindRequest(findRequestParameters);
                    nextFindRequestParameters.setOffset(fromRelationshipElement + pageSize);
                    response.setNextPageURL(this.formatNextPageURL(localServerURL + "{0}/instances/entity/{1}/relationships/history", nextFindRequestParameters, userId, entityGUID));
                }
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (PagingErrorException error) {
            this.capturePagingErrorException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public EntityListResponse findEntitiesByProperty(String userId, EntityPropertyFindRequest findRequestParameters) {
        String methodName = "findEntitiesByProperty";
        String entityTypeGUID = null;
        InstanceProperties matchProperties = null;
        MatchCriteria matchCriteria = null;
        int fromEntityElement = 0;
        List limitResultsByStatus = null;
        List limitResultsByClassification = null;
        String sequencingProperty = null;
        SequencingOrder sequencingOrder = null;
        int pageSize = 0;
        EntityListResponse response = new EntityListResponse();
        if (findRequestParameters != null) {
            entityTypeGUID = findRequestParameters.getTypeGUID();
            matchProperties = findRequestParameters.getMatchProperties();
            matchCriteria = findRequestParameters.getMatchCriteria();
            fromEntityElement = findRequestParameters.getOffset();
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
            limitResultsByClassification = findRequestParameters.getLimitResultsByClassification();
            sequencingProperty = findRequestParameters.getSequencingProperty();
            sequencingOrder = findRequestParameters.getSequencingOrder();
            pageSize = findRequestParameters.getPageSize();
        }
        try {
            this.validateLocalRepository("findEntitiesByProperty");
            List entities = localMetadataCollection.findEntitiesByProperty(userId, entityTypeGUID, matchProperties, matchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, null, sequencingProperty, sequencingOrder, pageSize);
            response.setEntities(entities);
            if (entities != null) {
                response.setOffset(fromEntityElement);
                response.setPageSize(pageSize);
                if (entities.size() == pageSize) {
                    String urlTemplate = "{0}/instances/entities/by-property";
                    EntityPropertyFindRequest nextFindRequestParameters = new EntityPropertyFindRequest(findRequestParameters);
                    nextFindRequestParameters.setOffset(fromEntityElement + pageSize);
                    response.setNextPageURL(this.formatNextPageURL(localServerURL + "{0}/instances/entities/by-property", nextFindRequestParameters, userId));
                }
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (PagingErrorException error) {
            this.capturePagingErrorException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public EntityListResponse findEntitiesByPropertyHistory(String userId, EntityPropertyHistoricalFindRequest findRequestParameters) {
        String methodName = "findEntitiesByPropertyHistory";
        String entityTypeGUID = null;
        InstanceProperties matchProperties = null;
        MatchCriteria matchCriteria = null;
        int fromEntityElement = 0;
        List limitResultsByStatus = null;
        List limitResultsByClassification = null;
        Date asOfTime = null;
        String sequencingProperty = null;
        SequencingOrder sequencingOrder = null;
        int pageSize = 0;
        EntityListResponse response = new EntityListResponse();
        if (findRequestParameters != null) {
            entityTypeGUID = findRequestParameters.getTypeGUID();
            matchProperties = findRequestParameters.getMatchProperties();
            matchCriteria = findRequestParameters.getMatchCriteria();
            fromEntityElement = findRequestParameters.getOffset();
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
            limitResultsByClassification = findRequestParameters.getLimitResultsByClassification();
            asOfTime = findRequestParameters.getAsOfTime();
            sequencingProperty = findRequestParameters.getSequencingProperty();
            sequencingOrder = findRequestParameters.getSequencingOrder();
            pageSize = findRequestParameters.getPageSize();
        }
        try {
            this.validateLocalRepository("findEntitiesByPropertyHistory");
            List entities = localMetadataCollection.findEntitiesByProperty(userId, entityTypeGUID, matchProperties, matchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
            response.setEntities(entities);
            if (entities != null) {
                response.setOffset(fromEntityElement);
                response.setPageSize(pageSize);
                if (entities.size() == pageSize) {
                    String urlTemplate = "{0}/instances/entities/by-property";
                    EntityPropertyFindRequest nextFindRequestParameters = new EntityPropertyFindRequest((EntityPropertyFindRequest)findRequestParameters);
                    nextFindRequestParameters.setOffset(fromEntityElement + pageSize);
                    response.setNextPageURL(this.formatNextPageURL(localServerURL + "{0}/instances/entities/by-property", nextFindRequestParameters, userId));
                }
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (PagingErrorException error) {
            this.capturePagingErrorException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public EntityListResponse findEntitiesByClassification(String userId, String classificationName, PropertyMatchFindRequest findRequestParameters) {
        String methodName = "findEntitiesByClassification";
        String entityTypeGUID = null;
        InstanceProperties matchClassificationProperties = null;
        MatchCriteria matchCriteria = null;
        int fromEntityElement = 0;
        List limitResultsByStatus = null;
        String sequencingProperty = null;
        SequencingOrder sequencingOrder = null;
        int pageSize = 0;
        EntityListResponse response = new EntityListResponse();
        if (findRequestParameters != null) {
            entityTypeGUID = findRequestParameters.getTypeGUID();
            matchClassificationProperties = findRequestParameters.getMatchProperties();
            matchCriteria = findRequestParameters.getMatchCriteria();
            fromEntityElement = findRequestParameters.getOffset();
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
            sequencingProperty = findRequestParameters.getSequencingProperty();
            sequencingOrder = findRequestParameters.getSequencingOrder();
            pageSize = findRequestParameters.getPageSize();
        }
        try {
            this.validateLocalRepository("findEntitiesByClassification");
            List entities = localMetadataCollection.findEntitiesByClassification(userId, entityTypeGUID, classificationName, matchClassificationProperties, matchCriteria, fromEntityElement, limitResultsByStatus, null, sequencingProperty, sequencingOrder, pageSize);
            response.setEntities(entities);
            if (entities != null) {
                response.setOffset(fromEntityElement);
                response.setPageSize(pageSize);
                if (entities.size() == pageSize) {
                    String urlTemplate = "{0}/instances/entities/by-classification/{1}";
                    PropertyMatchFindRequest nextFindRequestParameters = new PropertyMatchFindRequest(findRequestParameters);
                    nextFindRequestParameters.setOffset(fromEntityElement + pageSize);
                    response.setNextPageURL(this.formatNextPageURL(localServerURL + "{0}/instances/entities/by-classification/{1}", nextFindRequestParameters, userId, classificationName));
                }
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (PagingErrorException error) {
            this.capturePagingErrorException((OMRSAPIResponse)response, error);
        }
        catch (ClassificationErrorException error) {
            this.captureClassificationErrorException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public EntityListResponse findEntitiesByClassificationHistory(String userId, String classificationName, PropertyMatchHistoricalFindRequest findRequestParameters) {
        String methodName = "findEntitiesByClassificationHistory";
        String entityTypeGUID = null;
        InstanceProperties matchClassificationProperties = null;
        MatchCriteria matchCriteria = null;
        int fromEntityElement = 0;
        List limitResultsByStatus = null;
        Date asOfTime = null;
        String sequencingProperty = null;
        SequencingOrder sequencingOrder = null;
        int pageSize = 0;
        EntityListResponse response = new EntityListResponse();
        if (findRequestParameters != null) {
            entityTypeGUID = findRequestParameters.getTypeGUID();
            matchClassificationProperties = findRequestParameters.getMatchProperties();
            matchCriteria = findRequestParameters.getMatchCriteria();
            fromEntityElement = findRequestParameters.getOffset();
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
            asOfTime = findRequestParameters.getAsOfTime();
            sequencingProperty = findRequestParameters.getSequencingProperty();
            sequencingOrder = findRequestParameters.getSequencingOrder();
            pageSize = findRequestParameters.getPageSize();
        }
        try {
            this.validateLocalRepository("findEntitiesByClassificationHistory");
            List entities = localMetadataCollection.findEntitiesByClassification(userId, entityTypeGUID, classificationName, matchClassificationProperties, matchCriteria, fromEntityElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
            response.setEntities(entities);
            if (entities != null) {
                response.setOffset(fromEntityElement);
                response.setPageSize(pageSize);
                if (entities.size() == pageSize) {
                    String urlTemplate = "{0}/instances/entities/by-classification/{1}/history";
                    PropertyMatchHistoricalFindRequest nextFindRequestParameters = new PropertyMatchHistoricalFindRequest(findRequestParameters);
                    nextFindRequestParameters.setOffset(fromEntityElement + pageSize);
                    response.setNextPageURL(this.formatNextPageURL(localServerURL + "{0}/instances/entities/by-classification/{1}/history", nextFindRequestParameters, userId, classificationName));
                }
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (PagingErrorException error) {
            this.capturePagingErrorException((OMRSAPIResponse)response, error);
        }
        catch (ClassificationErrorException error) {
            this.captureClassificationErrorException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public EntityListResponse findEntitiesByPropertyValue(String userId, String searchCriteria, EntityPropertyFindRequest findRequestParameters) {
        String methodName = "findEntitiesByPropertyValue";
        String entityTypeGUID = null;
        int fromEntityElement = 0;
        List limitResultsByStatus = null;
        List limitResultsByClassification = null;
        String sequencingProperty = null;
        SequencingOrder sequencingOrder = null;
        int pageSize = 0;
        EntityListResponse response = new EntityListResponse();
        if (findRequestParameters != null) {
            entityTypeGUID = findRequestParameters.getTypeGUID();
            fromEntityElement = findRequestParameters.getOffset();
            limitResultsByClassification = findRequestParameters.getLimitResultsByClassification();
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
            sequencingProperty = findRequestParameters.getSequencingProperty();
            sequencingOrder = findRequestParameters.getSequencingOrder();
            pageSize = findRequestParameters.getPageSize();
        }
        try {
            this.validateLocalRepository("findEntitiesByPropertyValue");
            List entities = localMetadataCollection.findEntitiesByPropertyValue(userId, entityTypeGUID, searchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, null, sequencingProperty, sequencingOrder, pageSize);
            response.setEntities(entities);
            if (entities != null) {
                response.setOffset(fromEntityElement);
                response.setPageSize(pageSize);
                if (entities.size() == pageSize) {
                    String urlTemplate = "{0}/instances/entities/by-property-value?&searchCriteria={1}";
                    EntityPropertyFindRequest nextFindRequestParameters = new EntityPropertyFindRequest(findRequestParameters);
                    nextFindRequestParameters.setOffset(fromEntityElement + pageSize);
                    response.setNextPageURL(this.formatNextPageURL(localServerURL + "{0}/instances/entities/by-property-value?&searchCriteria={1}", nextFindRequestParameters, userId, searchCriteria));
                }
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (PagingErrorException error) {
            this.capturePagingErrorException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public EntityListResponse findEntitiesByPropertyValueHistory(String userId, String searchCriteria, EntityPropertyHistoricalFindRequest findRequestParameters) {
        String methodName = "findEntitiesByPropertyValueHistory";
        String entityTypeGUID = null;
        int fromEntityElement = 0;
        List limitResultsByStatus = null;
        List limitResultsByClassification = null;
        Date asOfTime = null;
        String sequencingProperty = null;
        SequencingOrder sequencingOrder = null;
        int pageSize = 0;
        EntityListResponse response = new EntityListResponse();
        if (findRequestParameters != null) {
            entityTypeGUID = findRequestParameters.getTypeGUID();
            fromEntityElement = findRequestParameters.getOffset();
            limitResultsByClassification = findRequestParameters.getLimitResultsByClassification();
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
            asOfTime = findRequestParameters.getAsOfTime();
            sequencingProperty = findRequestParameters.getSequencingProperty();
            sequencingOrder = findRequestParameters.getSequencingOrder();
            pageSize = findRequestParameters.getPageSize();
        }
        try {
            this.validateLocalRepository("findEntitiesByPropertyValueHistory");
            List entities = localMetadataCollection.findEntitiesByPropertyValue(userId, entityTypeGUID, searchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
            response.setEntities(entities);
            if (entities != null) {
                response.setOffset(fromEntityElement);
                response.setPageSize(pageSize);
                if (entities.size() == pageSize) {
                    String urlTemplate = "{0}/instances/entities/by-property-value?&searchCriteria={1}/history";
                    EntityPropertyHistoricalFindRequest nextFindRequestParameters = new EntityPropertyHistoricalFindRequest(findRequestParameters);
                    nextFindRequestParameters.setOffset(fromEntityElement + pageSize);
                    response.setNextPageURL(this.formatNextPageURL(localServerURL + "{0}/instances/entities/by-property-value?&searchCriteria={1}/history", nextFindRequestParameters, userId, searchCriteria));
                }
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (PagingErrorException error) {
            this.capturePagingErrorException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public RelationshipResponse isRelationshipKnown(String userId, String guid) {
        String methodName = "isRelationshipKnown";
        RelationshipResponse response = new RelationshipResponse();
        try {
            this.validateLocalRepository("isRelationshipKnown");
            response.setRelationship(localMetadataCollection.isRelationshipKnown(userId, guid));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public RelationshipResponse getRelationship(String guid) {
        return this.getRelationship(null, guid);
    }

    public RelationshipResponse getRelationship(String userId, String guid) {
        String methodName = "getRelationship";
        RelationshipResponse response = new RelationshipResponse();
        try {
            this.validateLocalRepository("getRelationship");
            response.setRelationship(localMetadataCollection.getRelationship(userId, guid));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (RelationshipNotKnownException error) {
            this.captureRelationshipNotKnownException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public RelationshipResponse getRelationship(String userId, String guid, Date asOfTime) {
        String methodName = "getRelationship";
        RelationshipResponse response = new RelationshipResponse();
        try {
            this.validateLocalRepository("getRelationship");
            response.setRelationship(localMetadataCollection.getRelationship(userId, guid, asOfTime));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (RelationshipNotKnownException error) {
            this.captureRelationshipNotKnownException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public RelationshipListResponse findRelationshipsByProperty(String userId, PropertyMatchFindRequest findRequestParameters) {
        String methodName = "findRelationshipsByProperty";
        String relationshipTypeGUID = null;
        InstanceProperties matchProperties = null;
        MatchCriteria matchCriteria = null;
        int fromRelationshipElement = 0;
        List limitResultsByStatus = null;
        String sequencingProperty = null;
        SequencingOrder sequencingOrder = null;
        int pageSize = 0;
        RelationshipListResponse response = new RelationshipListResponse();
        if (findRequestParameters != null) {
            relationshipTypeGUID = findRequestParameters.getTypeGUID();
            matchProperties = findRequestParameters.getMatchProperties();
            matchCriteria = findRequestParameters.getMatchCriteria();
            fromRelationshipElement = findRequestParameters.getOffset();
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
            sequencingProperty = findRequestParameters.getSequencingProperty();
            sequencingOrder = findRequestParameters.getSequencingOrder();
            pageSize = findRequestParameters.getPageSize();
        }
        try {
            this.validateLocalRepository("findRelationshipsByProperty");
            List relationships = localMetadataCollection.findRelationshipsByProperty(userId, relationshipTypeGUID, matchProperties, matchCriteria, fromRelationshipElement, limitResultsByStatus, null, sequencingProperty, sequencingOrder, pageSize);
            response.setRelationships(relationships);
            if (relationships != null) {
                response.setOffset(fromRelationshipElement);
                response.setPageSize(pageSize);
                if (response.getRelationships().size() == pageSize) {
                    String urlTemplate = "{0}/instances/relationships/by-property";
                    PropertyMatchFindRequest nextFindRequestParameters = new PropertyMatchFindRequest(findRequestParameters);
                    nextFindRequestParameters.setOffset(fromRelationshipElement + pageSize);
                    response.setNextPageURL(this.formatNextPageURL(localServerURL + "{0}/instances/relationships/by-property", nextFindRequestParameters, userId));
                }
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (PagingErrorException error) {
            this.capturePagingErrorException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public RelationshipListResponse findRelationshipsByPropertyHistory(String userId, PropertyMatchHistoricalFindRequest findRequestParameters) {
        String methodName = "findRelationshipsByPropertyHistory";
        String relationshipTypeGUID = null;
        InstanceProperties matchProperties = null;
        MatchCriteria matchCriteria = null;
        int fromRelationshipElement = 0;
        List limitResultsByStatus = null;
        Date asOfTime = null;
        String sequencingProperty = null;
        SequencingOrder sequencingOrder = null;
        int pageSize = 0;
        RelationshipListResponse response = new RelationshipListResponse();
        if (findRequestParameters != null) {
            relationshipTypeGUID = findRequestParameters.getTypeGUID();
            matchProperties = findRequestParameters.getMatchProperties();
            matchCriteria = findRequestParameters.getMatchCriteria();
            fromRelationshipElement = findRequestParameters.getOffset();
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
            asOfTime = findRequestParameters.getAsOfTime();
            sequencingProperty = findRequestParameters.getSequencingProperty();
            sequencingOrder = findRequestParameters.getSequencingOrder();
            pageSize = findRequestParameters.getPageSize();
        }
        try {
            this.validateLocalRepository("findRelationshipsByPropertyHistory");
            List relationships = localMetadataCollection.findRelationshipsByProperty(userId, relationshipTypeGUID, matchProperties, matchCriteria, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
            response.setRelationships(relationships);
            if (relationships != null) {
                response.setOffset(fromRelationshipElement);
                response.setPageSize(pageSize);
                if (response.getRelationships().size() == pageSize) {
                    String urlTemplate = "{0}/instances/relationships/by-property/history";
                    PropertyMatchHistoricalFindRequest nextFindRequestParameters = new PropertyMatchHistoricalFindRequest(findRequestParameters);
                    nextFindRequestParameters.setOffset(fromRelationshipElement + pageSize);
                    response.setNextPageURL(this.formatNextPageURL(localServerURL + "{0}/instances/relationships/by-property/history", nextFindRequestParameters, userId));
                }
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (PagingErrorException error) {
            this.capturePagingErrorException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public RelationshipListResponse findRelationshipsByPropertyValue(String userId, String searchCriteria, TypeLimitedFindRequest findRequestParameters) {
        String methodName = "findRelationshipsByPropertyValue";
        String relationshipTypeGUID = null;
        int fromRelationshipElement = 0;
        List limitResultsByStatus = null;
        String sequencingProperty = null;
        SequencingOrder sequencingOrder = null;
        int pageSize = 0;
        RelationshipListResponse response = new RelationshipListResponse();
        if (findRequestParameters != null) {
            relationshipTypeGUID = findRequestParameters.getTypeGUID();
            fromRelationshipElement = findRequestParameters.getOffset();
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
            sequencingProperty = findRequestParameters.getSequencingProperty();
            sequencingOrder = findRequestParameters.getSequencingOrder();
            pageSize = findRequestParameters.getPageSize();
        }
        try {
            this.validateLocalRepository("findRelationshipsByPropertyValue");
            List relationships = localMetadataCollection.findRelationshipsByPropertyValue(userId, relationshipTypeGUID, searchCriteria, fromRelationshipElement, limitResultsByStatus, null, sequencingProperty, sequencingOrder, pageSize);
            response.setRelationships(relationships);
            if (relationships != null) {
                response.setOffset(fromRelationshipElement);
                response.setPageSize(pageSize);
                if (response.getRelationships().size() == pageSize) {
                    String urlTemplate = "{0}/instances/relationships/by-property-value?searchCriteria={1}";
                    TypeLimitedFindRequest nextFindRequestParameters = new TypeLimitedFindRequest(findRequestParameters);
                    nextFindRequestParameters.setOffset(fromRelationshipElement + pageSize);
                    response.setNextPageURL(this.formatNextPageURL(localServerURL + "{0}/instances/relationships/by-property-value?searchCriteria={1}", nextFindRequestParameters, userId, searchCriteria));
                }
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (PagingErrorException error) {
            this.capturePagingErrorException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public RelationshipListResponse findRelationshipsByPropertyValueHistory(String userId, String searchCriteria, TypeLimitedHistoricalFindRequest findRequestParameters) {
        String methodName = "findRelationshipsByPropertyValueHistory";
        String relationshipTypeGUID = null;
        int fromRelationshipElement = 0;
        List limitResultsByStatus = null;
        Date asOfTime = null;
        String sequencingProperty = null;
        SequencingOrder sequencingOrder = null;
        int pageSize = 0;
        RelationshipListResponse response = new RelationshipListResponse();
        if (findRequestParameters != null) {
            relationshipTypeGUID = findRequestParameters.getTypeGUID();
            fromRelationshipElement = findRequestParameters.getOffset();
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
            asOfTime = findRequestParameters.getAsOfTime();
            sequencingProperty = findRequestParameters.getSequencingProperty();
            sequencingOrder = findRequestParameters.getSequencingOrder();
            pageSize = findRequestParameters.getPageSize();
        }
        try {
            this.validateLocalRepository("findRelationshipsByPropertyValueHistory");
            List relationships = localMetadataCollection.findRelationshipsByPropertyValue(userId, relationshipTypeGUID, searchCriteria, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
            response.setRelationships(relationships);
            if (relationships != null) {
                response.setOffset(fromRelationshipElement);
                response.setPageSize(pageSize);
                if (response.getRelationships().size() == pageSize) {
                    String urlTemplate = "{0}/instances/relationships/by-property-value/history?searchCriteria={1}";
                    TypeLimitedHistoricalFindRequest nextFindRequestParameters = new TypeLimitedHistoricalFindRequest(findRequestParameters);
                    nextFindRequestParameters.setOffset(fromRelationshipElement + pageSize);
                    response.setNextPageURL(this.formatNextPageURL(localServerURL + "{0}/instances/relationships/by-property-value/history?searchCriteria={1}", nextFindRequestParameters, userId, searchCriteria));
                }
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (PagingErrorException error) {
            this.capturePagingErrorException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public InstanceGraphResponse getLinkingEntities(String userId, String startEntityGUID, String endEntityGUID, OMRSAPIFindRequest findRequestParameters) {
        String methodName = "getLinkingEntities";
        List limitResultsByStatus = null;
        InstanceGraphResponse response = new InstanceGraphResponse();
        if (findRequestParameters != null) {
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
        }
        try {
            this.validateLocalRepository("getLinkingEntities");
            InstanceGraph instanceGraph = localMetadataCollection.getLinkingEntities(userId, startEntityGUID, endEntityGUID, limitResultsByStatus, null);
            if (instanceGraph != null) {
                response.setEntityElementList(instanceGraph.getEntities());
                response.setRelationshipElementList(instanceGraph.getRelationships());
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public InstanceGraphResponse getLinkingEntitiesHistory(String userId, String startEntityGUID, String endEntityGUID, OMRSAPIHistoricalFindRequest findRequestParameters) {
        String methodName = "getLinkingEntitiesHistory";
        List limitResultsByStatus = null;
        Date asOfTime = null;
        InstanceGraphResponse response = new InstanceGraphResponse();
        if (findRequestParameters != null) {
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
            asOfTime = findRequestParameters.getAsOfTime();
        }
        try {
            this.validateLocalRepository("getLinkingEntitiesHistory");
            InstanceGraph instanceGraph = localMetadataCollection.getLinkingEntities(userId, startEntityGUID, endEntityGUID, limitResultsByStatus, asOfTime);
            if (instanceGraph != null) {
                response.setEntityElementList(instanceGraph.getEntities());
                response.setRelationshipElementList(instanceGraph.getRelationships());
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public InstanceGraphResponse getEntityNeighborhood(String userId, String entityGUID, int level, EntityNeighborhoodFindRequest findRequestParameters) {
        String methodName = "getEntityNeighborhood";
        List entityTypeGUIDs = null;
        List relationshipTypeGUIDs = null;
        List limitResultsByStatus = null;
        List limitResultsByClassification = null;
        InstanceGraphResponse response = new InstanceGraphResponse();
        if (findRequestParameters != null) {
            entityTypeGUIDs = findRequestParameters.getEntityTypeGUIDs();
            relationshipTypeGUIDs = findRequestParameters.getRelationshipTypeGUIDs();
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
            limitResultsByClassification = findRequestParameters.getLimitResultsByClassification();
        }
        try {
            this.validateLocalRepository("getEntityNeighborhood");
            InstanceGraph instanceGraph = localMetadataCollection.getEntityNeighborhood(userId, entityGUID, entityTypeGUIDs, relationshipTypeGUIDs, limitResultsByStatus, limitResultsByClassification, null, level);
            if (instanceGraph != null) {
                response.setEntityElementList(instanceGraph.getEntities());
                response.setRelationshipElementList(instanceGraph.getRelationships());
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public InstanceGraphResponse getEntityNeighborhoodHistory(String userId, String entityGUID, int level, EntityNeighborhoodHistoricalFindRequest findRequestParameters) {
        String methodName = "getEntityNeighborhoodHistory";
        List entityTypeGUIDs = null;
        List relationshipTypeGUIDs = null;
        List limitResultsByStatus = null;
        List limitResultsByClassification = null;
        Date asOfTime = null;
        InstanceGraphResponse response = new InstanceGraphResponse();
        if (findRequestParameters != null) {
            entityTypeGUIDs = findRequestParameters.getEntityTypeGUIDs();
            relationshipTypeGUIDs = findRequestParameters.getRelationshipTypeGUIDs();
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
            asOfTime = findRequestParameters.getAsOfTime();
            limitResultsByClassification = findRequestParameters.getLimitResultsByClassification();
        }
        try {
            this.validateLocalRepository("getEntityNeighborhoodHistory");
            InstanceGraph instanceGraph = localMetadataCollection.getEntityNeighborhood(userId, entityGUID, entityTypeGUIDs, relationshipTypeGUIDs, limitResultsByStatus, limitResultsByClassification, asOfTime, level);
            if (instanceGraph != null) {
                response.setEntityElementList(instanceGraph.getEntities());
                response.setRelationshipElementList(instanceGraph.getRelationships());
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public EntityListResponse getRelatedEntities(String userId, String startEntityGUID, RelatedEntitiesFindRequest findRequestParameters) {
        String methodName = "getRelatedEntities";
        List entityTypeGUIDs = null;
        int fromEntityElement = 0;
        List limitResultsByStatus = null;
        List limitResultsByClassification = null;
        String sequencingProperty = null;
        SequencingOrder sequencingOrder = null;
        int pageSize = 0;
        EntityListResponse response = new EntityListResponse();
        if (findRequestParameters != null) {
            entityTypeGUIDs = findRequestParameters.getEntityTypeGUIDs();
            fromEntityElement = findRequestParameters.getOffset();
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
            limitResultsByClassification = findRequestParameters.getLimitResultsByClassification();
            sequencingProperty = findRequestParameters.getSequencingProperty();
            sequencingOrder = findRequestParameters.getSequencingOrder();
            pageSize = findRequestParameters.getPageSize();
        }
        try {
            this.validateLocalRepository("getRelatedEntities");
            List entities = localMetadataCollection.getRelatedEntities(userId, startEntityGUID, entityTypeGUIDs, fromEntityElement, limitResultsByStatus, limitResultsByClassification, null, sequencingProperty, sequencingOrder, pageSize);
            response.setEntities(entities);
            if (entities != null) {
                response.setOffset(fromEntityElement);
                response.setPageSize(pageSize);
                if (entities.size() == pageSize) {
                    String urlTemplate = "{0}/instances/entities/from-entity/{1}/by-relationship";
                    RelatedEntitiesFindRequest nextFindRequestParameters = new RelatedEntitiesFindRequest(findRequestParameters);
                    nextFindRequestParameters.setOffset(fromEntityElement + pageSize);
                    response.setNextPageURL(this.formatNextPageURL(localServerURL + "{0}/instances/entities/from-entity/{1}/by-relationship", nextFindRequestParameters, userId, startEntityGUID));
                }
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (PagingErrorException error) {
            this.capturePagingErrorException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public EntityListResponse getRelatedEntitiesHistory(String userId, String startEntityGUID, RelatedEntitiesHistoricalFindRequest findRequestParameters) {
        String methodName = "getRelatedEntitiesHistory";
        List entityTypeGUIDs = null;
        int fromEntityElement = 0;
        List limitResultsByStatus = null;
        List limitResultsByClassification = null;
        Date asOfTime = null;
        String sequencingProperty = null;
        SequencingOrder sequencingOrder = null;
        int pageSize = 0;
        EntityListResponse response = new EntityListResponse();
        if (findRequestParameters != null) {
            entityTypeGUIDs = findRequestParameters.getEntityTypeGUIDs();
            fromEntityElement = findRequestParameters.getOffset();
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
            limitResultsByClassification = findRequestParameters.getLimitResultsByClassification();
            asOfTime = findRequestParameters.getAsOfTime();
            sequencingProperty = findRequestParameters.getSequencingProperty();
            sequencingOrder = findRequestParameters.getSequencingOrder();
            pageSize = findRequestParameters.getPageSize();
        }
        try {
            this.validateLocalRepository("getRelatedEntitiesHistory");
            List entities = localMetadataCollection.getRelatedEntities(userId, startEntityGUID, entityTypeGUIDs, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
            response.setEntities(entities);
            if (entities != null) {
                response.setOffset(fromEntityElement);
                response.setPageSize(pageSize);
                if (entities.size() == pageSize) {
                    String urlTemplate = "{0}/instances/entities/from-entity/{1}/by-relationship/history";
                    RelatedEntitiesHistoricalFindRequest nextFindRequestParameters = new RelatedEntitiesHistoricalFindRequest(findRequestParameters);
                    nextFindRequestParameters.setOffset(fromEntityElement + pageSize);
                    response.setNextPageURL(this.formatNextPageURL(localServerURL + "{0}/instances/entities/from-entity/{1}/by-relationship/history", nextFindRequestParameters, userId, startEntityGUID));
                }
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (PagingErrorException error) {
            this.capturePagingErrorException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public EntityDetailResponse addEntity(String userId, EntityCreateRequest requestBody) {
        String methodName = "addEntity";
        String entityTypeGUID = null;
        InstanceProperties initialProperties = null;
        List initialClassifications = null;
        InstanceStatus initialStatus = null;
        EntityDetailResponse response = new EntityDetailResponse();
        if (requestBody != null) {
            entityTypeGUID = requestBody.getEntityTypeGUID();
            initialProperties = requestBody.getInitialProperties();
            initialClassifications = requestBody.getInitialClassifications();
            initialStatus = requestBody.getInitialStatus();
        }
        try {
            this.validateLocalRepository("addEntity");
            response.setEntity(localMetadataCollection.addEntity(userId, entityTypeGUID, initialProperties, initialClassifications, initialStatus));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (StatusNotSupportedException error) {
            this.captureStatusNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (ClassificationErrorException error) {
            this.captureClassificationErrorException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public VoidResponse addEntityProxy(String userId, EntityProxy entityProxy) {
        String methodName = "addEntityProxy";
        VoidResponse response = new VoidResponse();
        try {
            this.validateLocalRepository("addEntityProxy");
            localMetadataCollection.addEntityProxy(userId, entityProxy);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public EntityDetailResponse updateEntityStatus(String userId, String entityGUID, InstanceStatus newStatus) {
        String methodName = "updateEntityStatus";
        EntityDetailResponse response = new EntityDetailResponse();
        try {
            this.validateLocalRepository("updateEntityStatus");
            response.setEntity(localMetadataCollection.updateEntityStatus(userId, entityGUID, newStatus));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (StatusNotSupportedException error) {
            this.captureStatusNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public EntityDetailResponse updateEntityProperties(String userId, String entityGUID, InstancePropertiesRequest propertiesRequestBody) {
        String methodName = "updateEntityProperties";
        EntityDetailResponse response = new EntityDetailResponse();
        try {
            this.validateLocalRepository("updateEntityProperties");
            response.setEntity(localMetadataCollection.updateEntityProperties(userId, entityGUID, propertiesRequestBody.getInstanceProperties()));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public EntityDetailResponse undoEntityUpdate(String userId, String entityGUID) {
        String methodName = "undoEntityUpdate";
        EntityDetailResponse response = new EntityDetailResponse();
        try {
            this.validateLocalRepository("undoEntityUpdate");
            response.setEntity(localMetadataCollection.undoEntityUpdate(userId, entityGUID));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public EntityDetailResponse deleteEntity(String userId, String obsoleteEntityGUID, TypeDefValidationForRequest typeDefValidationForRequest) {
        String methodName = "deleteEntity";
        String typeDefGUID = null;
        String typeDefName = null;
        EntityDetailResponse response = new EntityDetailResponse();
        if (typeDefValidationForRequest != null) {
            typeDefGUID = typeDefValidationForRequest.getTypeDefGUID();
            typeDefName = typeDefValidationForRequest.getTypeDefName();
        }
        try {
            this.validateLocalRepository("deleteEntity");
            response.setEntity(localMetadataCollection.deleteEntity(userId, typeDefGUID, typeDefName, obsoleteEntityGUID));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public VoidResponse purgeEntity(String userId, String deletedEntityGUID, TypeDefValidationForRequest typeDefValidationForRequest) {
        String methodName = "purgeEntity";
        String typeDefGUID = null;
        String typeDefName = null;
        VoidResponse response = new VoidResponse();
        if (typeDefValidationForRequest != null) {
            typeDefGUID = typeDefValidationForRequest.getTypeDefGUID();
            typeDefName = typeDefValidationForRequest.getTypeDefName();
        }
        try {
            this.validateLocalRepository("purgeEntity");
            localMetadataCollection.purgeEntity(userId, typeDefGUID, typeDefName, deletedEntityGUID);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotDeletedException error) {
            this.captureEntityNotDeletedException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public EntityDetailResponse restoreEntity(String userId, String deletedEntityGUID) {
        String methodName = "restoreEntity";
        EntityDetailResponse response = new EntityDetailResponse();
        try {
            this.validateLocalRepository("restoreEntity");
            response.setEntity(localMetadataCollection.restoreEntity(userId, deletedEntityGUID));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotDeletedException error) {
            this.captureEntityNotDeletedException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public EntityDetailResponse classifyEntity(String userId, String entityGUID, String classificationName, InstancePropertiesRequest propertiesRequestBody) {
        String methodName = "classifyEntity";
        EntityDetailResponse response = new EntityDetailResponse();
        try {
            this.validateLocalRepository("classifyEntity");
            response.setEntity(localMetadataCollection.classifyEntity(userId, entityGUID, classificationName, propertiesRequestBody.getInstanceProperties()));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (ClassificationErrorException error) {
            this.captureClassificationErrorException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public EntityDetailResponse declassifyEntity(String userId, String entityGUID, String classificationName) {
        String methodName = "declassifyEntity";
        EntityDetailResponse response = new EntityDetailResponse();
        try {
            this.validateLocalRepository("declassifyEntity");
            response.setEntity(localMetadataCollection.declassifyEntity(userId, entityGUID, classificationName));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (ClassificationErrorException error) {
            this.captureClassificationErrorException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public EntityDetailResponse updateEntityClassification(String userId, String entityGUID, String classificationName, InstancePropertiesRequest propertiesRequestBody) {
        String methodName = "updateEntityClassification";
        EntityDetailResponse response = new EntityDetailResponse();
        try {
            this.validateLocalRepository("updateEntityClassification");
            response.setEntity(localMetadataCollection.updateEntityClassification(userId, entityGUID, classificationName, propertiesRequestBody.getInstanceProperties()));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (ClassificationErrorException error) {
            this.captureClassificationErrorException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public RelationshipResponse addRelationship(String userId, RelationshipCreateRequest createRequestParameters) {
        String methodName = "addRelationship";
        String relationshipTypeGUID = null;
        InstanceProperties initialProperties = null;
        String entityOneGUID = null;
        String entityTwoGUID = null;
        InstanceStatus initialStatus = null;
        RelationshipResponse response = new RelationshipResponse();
        if (createRequestParameters != null) {
            relationshipTypeGUID = createRequestParameters.getRelationshipTypeGUID();
            initialProperties = createRequestParameters.getInitialProperties();
            entityOneGUID = createRequestParameters.getEntityOneGUID();
            entityTwoGUID = createRequestParameters.getEntityTwoGUID();
            initialStatus = createRequestParameters.getInitialStatus();
        }
        try {
            this.validateLocalRepository("addRelationship");
            response.setRelationship(localMetadataCollection.addRelationship(userId, relationshipTypeGUID, initialProperties, entityOneGUID, entityTwoGUID, initialStatus));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (StatusNotSupportedException error) {
            this.captureStatusNotSupportedException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public RelationshipResponse updateRelationshipStatus(String userId, String relationshipGUID, InstanceStatus newStatus) {
        String methodName = "updateRelationshipStatus";
        RelationshipResponse response = new RelationshipResponse();
        try {
            this.validateLocalRepository("updateRelationshipStatus");
            response.setRelationship(localMetadataCollection.updateRelationshipStatus(userId, relationshipGUID, newStatus));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (RelationshipNotKnownException error) {
            this.captureRelationshipNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (StatusNotSupportedException error) {
            this.captureStatusNotSupportedException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public RelationshipResponse updateRelationshipProperties(String userId, String relationshipGUID, InstancePropertiesRequest propertiesRequestBody) {
        String methodName = "updateRelationshipProperties";
        RelationshipResponse response = new RelationshipResponse();
        try {
            this.validateLocalRepository("updateRelationshipProperties");
            response.setRelationship(localMetadataCollection.updateRelationshipProperties(userId, relationshipGUID, propertiesRequestBody.getInstanceProperties()));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (RelationshipNotKnownException error) {
            this.captureRelationshipNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public RelationshipResponse undoRelationshipUpdate(String userId, String relationshipGUID) {
        String methodName = "undoRelationshipUpdate";
        RelationshipResponse response = new RelationshipResponse();
        try {
            this.validateLocalRepository("undoRelationshipUpdate");
            response.setRelationship(localMetadataCollection.undoRelationshipUpdate(userId, relationshipGUID));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (RelationshipNotKnownException error) {
            this.captureRelationshipNotKnownException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public RelationshipResponse deleteRelationship(String userId, String obsoleteRelationshipGUID, TypeDefValidationForRequest typeDefValidationForRequest) {
        String methodName = "deleteRelationship";
        String typeDefGUID = null;
        String typeDefName = null;
        RelationshipResponse response = new RelationshipResponse();
        if (typeDefValidationForRequest != null) {
            typeDefGUID = typeDefValidationForRequest.getTypeDefGUID();
            typeDefName = typeDefValidationForRequest.getTypeDefName();
        }
        try {
            this.validateLocalRepository("deleteRelationship");
            response.setRelationship(localMetadataCollection.deleteRelationship(userId, typeDefGUID, typeDefName, obsoleteRelationshipGUID));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (RelationshipNotKnownException error) {
            this.captureRelationshipNotKnownException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public VoidResponse purgeRelationship(String userId, String deletedRelationshipGUID, TypeDefValidationForRequest typeDefValidationForRequest) {
        String methodName = "purgeRelationship";
        String typeDefGUID = null;
        String typeDefName = null;
        VoidResponse response = new VoidResponse();
        if (typeDefValidationForRequest != null) {
            typeDefGUID = typeDefValidationForRequest.getTypeDefGUID();
            typeDefName = typeDefValidationForRequest.getTypeDefName();
        }
        try {
            this.validateLocalRepository("purgeRelationship");
            localMetadataCollection.purgeRelationship(userId, typeDefGUID, typeDefName, deletedRelationshipGUID);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (RelationshipNotDeletedException error) {
            this.captureRelationshipNotDeletedException((OMRSAPIResponse)response, error);
        }
        catch (RelationshipNotKnownException error) {
            this.captureRelationshipNotKnownException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public RelationshipResponse restoreRelationship(String userId, String deletedRelationshipGUID) {
        String methodName = "restoreRelationship";
        RelationshipResponse response = new RelationshipResponse();
        try {
            this.validateLocalRepository("restoreRelationship");
            response.setRelationship(localMetadataCollection.restoreRelationship(userId, deletedRelationshipGUID));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (RelationshipNotKnownException error) {
            this.captureRelationshipNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (RelationshipNotDeletedException error) {
            this.captureRelationshipNotDeletedException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public EntityDetailResponse reIdentifyEntity(String userId, String entityGUID, String newEntityGUID, TypeDefValidationForRequest typeDefValidationForRequest) {
        String methodName = "reIdentifyEntity";
        String typeDefGUID = null;
        String typeDefName = null;
        EntityDetailResponse response = new EntityDetailResponse();
        if (typeDefValidationForRequest != null) {
            typeDefGUID = typeDefValidationForRequest.getTypeDefGUID();
            typeDefName = typeDefValidationForRequest.getTypeDefName();
        }
        try {
            this.validateLocalRepository("reIdentifyEntity");
            response.setEntity(localMetadataCollection.reIdentifyEntity(userId, typeDefGUID, typeDefName, entityGUID, newEntityGUID));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public EntityDetailResponse reTypeEntity(String userId, String entityGUID, TypeDefChangeRequest typeDefChangeRequest) {
        String methodName = "reTypeEntity";
        TypeDefSummary currentTypeDefSummary = null;
        TypeDefSummary newTypeDefSummary = null;
        EntityDetailResponse response = new EntityDetailResponse();
        if (typeDefChangeRequest != null) {
            currentTypeDefSummary = typeDefChangeRequest.getCurrentTypeDef();
            newTypeDefSummary = typeDefChangeRequest.getNewTypeDef();
        }
        try {
            this.validateLocalRepository("reTypeEntity");
            response.setEntity(localMetadataCollection.reTypeEntity(userId, entityGUID, currentTypeDefSummary, newTypeDefSummary));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (ClassificationErrorException error) {
            this.captureClassificationErrorException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public EntityDetailResponse reHomeEntity(String userId, String entityGUID, String homeMetadataCollectionId, String newHomeMetadataCollectionId, TypeDefValidationForRequest typeDefValidationForRequest) {
        String methodName = "reHomeEntity";
        String typeDefGUID = null;
        String typeDefName = null;
        EntityDetailResponse response = new EntityDetailResponse();
        if (typeDefValidationForRequest != null) {
            typeDefGUID = typeDefValidationForRequest.getTypeDefGUID();
            typeDefName = typeDefValidationForRequest.getTypeDefName();
        }
        try {
            this.validateLocalRepository("reHomeEntity");
            response.setEntity(localMetadataCollection.reHomeEntity(userId, entityGUID, typeDefGUID, typeDefName, homeMetadataCollectionId, newHomeMetadataCollectionId));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public RelationshipResponse reIdentifyRelationship(String userId, String relationshipGUID, String newRelationshipGUID, TypeDefValidationForRequest typeDefValidationForRequest) {
        String methodName = "reIdentifyRelationship";
        String typeDefGUID = null;
        String typeDefName = null;
        RelationshipResponse response = new RelationshipResponse();
        if (typeDefValidationForRequest != null) {
            typeDefGUID = typeDefValidationForRequest.getTypeDefGUID();
            typeDefName = typeDefValidationForRequest.getTypeDefName();
        }
        try {
            this.validateLocalRepository("reIdentifyRelationship");
            response.setRelationship(localMetadataCollection.reIdentifyRelationship(userId, typeDefGUID, typeDefName, relationshipGUID, newRelationshipGUID));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (RelationshipNotKnownException error) {
            this.captureRelationshipNotKnownException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public RelationshipResponse reTypeRelationship(String userId, String relationshipGUID, TypeDefChangeRequest typeDefChangeRequest) {
        String methodName = "reTypeRelationship";
        TypeDefSummary currentTypeDefSummary = null;
        TypeDefSummary newTypeDefSummary = null;
        RelationshipResponse response = new RelationshipResponse();
        if (typeDefChangeRequest != null) {
            currentTypeDefSummary = typeDefChangeRequest.getCurrentTypeDef();
            newTypeDefSummary = typeDefChangeRequest.getNewTypeDef();
        }
        try {
            this.validateLocalRepository("reTypeRelationship");
            response.setRelationship(localMetadataCollection.reTypeRelationship(userId, relationshipGUID, currentTypeDefSummary, newTypeDefSummary));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (RelationshipNotKnownException error) {
            this.captureRelationshipNotKnownException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public RelationshipResponse reHomeRelationship(String userId, String relationshipGUID, String homeMetadataCollectionId, String newHomeMetadataCollectionId, TypeDefValidationForRequest typeDefValidationForRequest) {
        String methodName = "reHomeRelationship";
        String typeDefGUID = null;
        String typeDefName = null;
        RelationshipResponse response = new RelationshipResponse();
        if (typeDefValidationForRequest != null) {
            typeDefGUID = typeDefValidationForRequest.getTypeDefGUID();
            typeDefName = typeDefValidationForRequest.getTypeDefName();
        }
        try {
            this.validateLocalRepository("reHomeRelationship");
            response.setRelationship(localMetadataCollection.reHomeRelationship(userId, relationshipGUID, typeDefGUID, typeDefName, homeMetadataCollectionId, newHomeMetadataCollectionId));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (RelationshipNotKnownException error) {
            this.captureRelationshipNotKnownException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public VoidResponse saveEntityReferenceCopy(String userId, EntityDetail entity) {
        String methodName = "saveEntityReferenceCopy";
        VoidResponse response = new VoidResponse();
        try {
            this.validateLocalRepository("saveEntityReferenceCopy");
            localMetadataCollection.saveEntityReferenceCopy(userId, entity);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeDefErrorException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (HomeEntityException error) {
            this.captureHomeEntityException((OMRSAPIResponse)response, error);
        }
        catch (EntityConflictException error) {
            this.captureEntityConflictException((OMRSAPIResponse)response, error);
        }
        catch (InvalidEntityException error) {
            this.captureInvalidEntityException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public VoidResponse purgeEntityReferenceCopy(String userId, String entityGUID, String homeMetadataCollectionId, TypeDefValidationForRequest typeDefValidationForRequest) {
        String methodName = "purgeEntityReferenceCopy";
        String typeDefGUID = null;
        String typeDefName = null;
        VoidResponse response = new VoidResponse();
        if (typeDefValidationForRequest != null) {
            typeDefGUID = typeDefValidationForRequest.getTypeDefGUID();
            typeDefName = typeDefValidationForRequest.getTypeDefName();
        }
        try {
            this.validateLocalRepository("purgeEntityReferenceCopy");
            localMetadataCollection.purgeEntityReferenceCopy(userId, entityGUID, typeDefGUID, typeDefName, homeMetadataCollectionId);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (HomeEntityException error) {
            this.captureHomeEntityException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public VoidResponse refreshEntityReferenceCopy(String userId, String entityGUID, String homeMetadataCollectionId, TypeDefValidationForRequest typeDefValidationForRequest) {
        String methodName = "refreshEntityReferenceCopy";
        String typeDefGUID = null;
        String typeDefName = null;
        VoidResponse response = new VoidResponse();
        if (typeDefValidationForRequest != null) {
            typeDefGUID = typeDefValidationForRequest.getTypeDefGUID();
            typeDefName = typeDefValidationForRequest.getTypeDefName();
        }
        try {
            this.validateLocalRepository("refreshEntityReferenceCopy");
            localMetadataCollection.refreshEntityReferenceCopy(userId, entityGUID, typeDefGUID, typeDefName, homeMetadataCollectionId);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (HomeEntityException error) {
            this.captureHomeEntityException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public VoidResponse saveRelationshipReferenceCopy(String userId, Relationship relationship) {
        String methodName = "saveRelationshipReferenceCopy";
        VoidResponse response = new VoidResponse();
        try {
            this.validateLocalRepository("saveRelationshipReferenceCopy");
            localMetadataCollection.saveRelationshipReferenceCopy(userId, relationship);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (InvalidRelationshipException error) {
            this.captureInvalidRelationshipException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (HomeRelationshipException error) {
            this.captureHomeRelationshipException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeDefErrorException((OMRSAPIResponse)response, error);
        }
        catch (RelationshipConflictException error) {
            this.captureRelationshipConflictException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public VoidResponse purgeRelationshipReferenceCopy(String userId, String relationshipGUID, String homeMetadataCollectionId, TypeDefValidationForRequest typeDefValidationForRequest) {
        String methodName = "purgeRelationshipReferenceCopy";
        String typeDefGUID = null;
        String typeDefName = null;
        VoidResponse response = new VoidResponse();
        if (typeDefValidationForRequest != null) {
            typeDefGUID = typeDefValidationForRequest.getTypeDefGUID();
            typeDefName = typeDefValidationForRequest.getTypeDefName();
        }
        try {
            this.validateLocalRepository("purgeRelationshipReferenceCopy");
            localMetadataCollection.purgeRelationshipReferenceCopy(userId, relationshipGUID, typeDefGUID, typeDefName, homeMetadataCollectionId);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (RelationshipNotKnownException error) {
            this.captureRelationshipNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (HomeRelationshipException error) {
            this.captureHomeRelationshipException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public VoidResponse refreshRelationshipReferenceCopy(String userId, String relationshipGUID, String homeMetadataCollectionId, TypeDefValidationForRequest typeDefValidationForRequest) {
        String methodName = "refreshRelationshipReferenceCopy";
        String typeDefGUID = null;
        String typeDefName = null;
        VoidResponse response = new VoidResponse();
        if (typeDefValidationForRequest != null) {
            typeDefGUID = typeDefValidationForRequest.getTypeDefGUID();
            typeDefName = typeDefValidationForRequest.getTypeDefName();
        }
        try {
            this.validateLocalRepository("refreshRelationshipReferenceCopy");
            localMetadataCollection.refreshRelationshipReferenceCopy(userId, relationshipGUID, typeDefGUID, typeDefName, homeMetadataCollectionId);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (RelationshipNotKnownException error) {
            this.captureRelationshipNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (HomeRelationshipException error) {
            this.captureHomeRelationshipException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    public VoidResponse saveInstanceReferenceCopies(String userId, InstanceGraphRequest instances) {
        String methodName = "saveInstanceReferenceCopies";
        InstanceGraph instanceGraph = new InstanceGraph();
        VoidResponse response = new VoidResponse();
        if (instances != null) {
            instanceGraph.setEntities(instances.getEntityElementList());
            instanceGraph.setRelationships(instances.getRelationshipElementList());
        }
        try {
            this.validateLocalRepository("saveInstanceReferenceCopies");
            localMetadataCollection.saveInstanceReferenceCopies(userId, instanceGraph);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (InvalidEntityException error) {
            this.captureInvalidEntityException((OMRSAPIResponse)response, error);
        }
        catch (InvalidRelationshipException error) {
            this.captureInvalidRelationshipException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeDefErrorException((OMRSAPIResponse)response, error);
        }
        catch (EntityConflictException error) {
            this.captureEntityConflictException((OMRSAPIResponse)response, error);
        }
        catch (RelationshipConflictException error) {
            this.captureRelationshipConflictException((OMRSAPIResponse)response, error);
        }
        return response;
    }

    private void validateLocalRepository(String methodName) throws RepositoryErrorException {
        if (localMetadataCollection == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NO_LOCAL_REPOSITORY;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    private void captureUserNotAuthorizedException(OMRSAPIResponse response, UserNotAuthorizedException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)((Object)error), ((Object)((Object)error)).getClass().getName());
    }

    private void captureFunctionNotSupportedException(OMRSAPIResponse response, FunctionNotSupportedException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)((Object)error), ((Object)((Object)error)).getClass().getName());
    }

    private void captureRepositoryErrorException(OMRSAPIResponse response, RepositoryErrorException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)((Object)error), ((Object)((Object)error)).getClass().getName());
    }

    private void captureInvalidParameterException(OMRSAPIResponse response, InvalidParameterException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)((Object)error), ((Object)((Object)error)).getClass().getName());
    }

    private void captureInvalidTypeDefException(OMRSAPIResponse response, InvalidTypeDefException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)((Object)error), ((Object)((Object)error)).getClass().getName());
    }

    private void captureTypeDefConflictException(OMRSAPIResponse response, TypeDefConflictException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)((Object)error), ((Object)((Object)error)).getClass().getName());
    }

    private void captureTypeDefNotSupportedException(OMRSAPIResponse response, TypeDefNotSupportedException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)((Object)error), ((Object)((Object)error)).getClass().getName());
    }

    private void captureHomeRelationshipException(OMRSAPIResponse response, HomeRelationshipException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)((Object)error), ((Object)((Object)error)).getClass().getName());
    }

    private void captureRelationshipNotKnownException(OMRSAPIResponse response, RelationshipNotKnownException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)((Object)error), ((Object)((Object)error)).getClass().getName());
    }

    private void captureInvalidRelationshipException(OMRSAPIResponse response, InvalidRelationshipException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)((Object)error), ((Object)((Object)error)).getClass().getName());
    }

    private void captureRelationshipConflictException(OMRSAPIResponse response, RelationshipConflictException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)((Object)error), ((Object)((Object)error)).getClass().getName());
    }

    private void captureTypeDefErrorException(OMRSAPIResponse response, TypeErrorException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)((Object)error), ((Object)((Object)error)).getClass().getName());
    }

    private void capturePropertyErrorException(OMRSAPIResponse response, PropertyErrorException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)((Object)error), ((Object)((Object)error)).getClass().getName());
    }

    private void captureEntityNotKnownException(OMRSAPIResponse response, EntityNotKnownException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)((Object)error), ((Object)((Object)error)).getClass().getName());
    }

    private void captureHomeEntityException(OMRSAPIResponse response, HomeEntityException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)((Object)error), ((Object)((Object)error)).getClass().getName());
    }

    private void captureTypeDefNotKnownException(TypeDefResponse response, TypeDefNotKnownException error) {
        this.captureCheckedException((OMRSAPIResponse)response, (OMRSCheckedExceptionBase)((Object)error), ((Object)((Object)error)).getClass().getName());
    }

    private void captureTypeDefNotKnown(OMRSAPIResponse response, TypeDefNotKnownException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)((Object)error), ((Object)((Object)error)).getClass().getName());
    }

    private void captureTypeDefKnownException(OMRSAPIResponse response, TypeDefKnownException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)((Object)error), ((Object)((Object)error)).getClass().getName());
    }

    private void captureTypeDefInUseException(OMRSAPIResponse response, TypeDefInUseException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)((Object)error), ((Object)((Object)error)).getClass().getName());
    }

    private void captureTypeDefNotKnownException(OMRSAPIResponse response, TypeDefNotKnownException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)((Object)error), ((Object)((Object)error)).getClass().getName());
    }

    private void captureEntityProxyOnlyException(OMRSAPIResponse response, EntityProxyOnlyException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)((Object)error), ((Object)((Object)error)).getClass().getName());
    }

    private void captureClassificationErrorException(OMRSAPIResponse response, ClassificationErrorException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)((Object)error), ((Object)((Object)error)).getClass().getName());
    }

    private void capturePagingErrorException(OMRSAPIResponse response, PagingErrorException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)((Object)error), ((Object)((Object)error)).getClass().getName());
    }

    private void captureTypeErrorException(OMRSAPIResponse response, TypeErrorException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)((Object)error), ((Object)((Object)error)).getClass().getName());
    }

    private void captureStatusNotSupportedException(OMRSAPIResponse response, StatusNotSupportedException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)((Object)error), ((Object)((Object)error)).getClass().getName());
    }

    private void captureEntityNotDeletedException(OMRSAPIResponse response, EntityNotDeletedException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)((Object)error), ((Object)((Object)error)).getClass().getName());
    }

    private void captureRelationshipNotDeletedException(OMRSAPIResponse response, RelationshipNotDeletedException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)((Object)error), ((Object)((Object)error)).getClass().getName());
    }

    private void captureInvalidEntityException(OMRSAPIResponse response, InvalidEntityException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)((Object)error), ((Object)((Object)error)).getClass().getName());
    }

    private void captureEntityConflictException(OMRSAPIResponse response, EntityConflictException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)((Object)error), ((Object)((Object)error)).getClass().getName());
    }

    private void captureCheckedException(OMRSAPIResponse response, OMRSCheckedExceptionBase error, String exceptionClassName) {
        response.setRelatedHTTPCode(error.getReportedHTTPCode());
        response.setExceptionClassName(exceptionClassName);
        response.setExceptionErrorMessage(error.getErrorMessage());
        response.setExceptionSystemAction(error.getReportedSystemAction());
        response.setExceptionUserAction(error.getReportedUserAction());
    }

    private String formatNextPageURL(String urlTemplate, Object request, Object ... parameters) {
        MessageFormat mf = new MessageFormat(urlTemplate);
        return mf.format(parameters) + "{" + request + "}";
    }
}

