/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.archivemanager;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveInstanceStore;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveTypeStore;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationEntityExtension;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.CollectionDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMRSArchiveBuilder {
    private OpenMetadataArchiveProperties archiveProperties;
    private Map<String, PrimitiveDef> primitiveDefMap = new HashMap<String, PrimitiveDef>();
    private List<PrimitiveDef> primitiveDefList = new ArrayList<PrimitiveDef>();
    private Map<String, EnumDef> enumDefMap = new HashMap<String, EnumDef>();
    private List<EnumDef> enumDefList = new ArrayList<EnumDef>();
    private Map<String, CollectionDef> collectionDefMap = new HashMap<String, CollectionDef>();
    private List<CollectionDef> collectionDefList = new ArrayList<CollectionDef>();
    private Map<String, ClassificationDef> classificationDefMap = new HashMap<String, ClassificationDef>();
    private List<ClassificationDef> classificationDefList = new ArrayList<ClassificationDef>();
    private Map<String, EntityDef> entityDefMap = new HashMap<String, EntityDef>();
    private List<EntityDef> entityDefList = new ArrayList<EntityDef>();
    private Map<String, RelationshipDef> relationshipDefMap = new HashMap<String, RelationshipDef>();
    private List<RelationshipDef> relationshipDefList = new ArrayList<RelationshipDef>();
    private Map<String, TypeDefPatch> typeDefPatchMap = new HashMap<String, TypeDefPatch>();
    private List<TypeDefPatch> typeDefPatchList = new ArrayList<TypeDefPatch>();
    private Map<String, EntityDetail> entityDetailMap = new HashMap<String, EntityDetail>();
    private List<EntityDetail> entityDetailList = new ArrayList<EntityDetail>();
    private Map<String, Relationship> relationshipMap = new HashMap<String, Relationship>();
    private List<Relationship> relationshipList = new ArrayList<Relationship>();
    private Map<String, ClassificationEntityExtension> classificationMap = new HashMap<String, ClassificationEntityExtension>();
    private List<ClassificationEntityExtension> classificationList = new ArrayList<ClassificationEntityExtension>();
    private Map<String, Object> guidMap = new HashMap<String, Object>();
    private Map<String, Object> nameMap = new HashMap<String, Object>();
    private Map<String, Set<String>> entityAttributeMap = new HashMap<String, Set<String>>();
    private static final Logger log = LoggerFactory.getLogger(OMRSArchiveBuilder.class);

    public OMRSArchiveBuilder(String archiveGUID, String archiveName, String archiveDescription, OpenMetadataArchiveType archiveType, String originatorName, Date creationDate, List<String> dependsOnArchives) {
        this.archiveProperties = new OpenMetadataArchiveProperties();
        this.archiveProperties.setArchiveGUID(archiveGUID);
        this.archiveProperties.setArchiveName(archiveName);
        this.archiveProperties.setArchiveDescription(archiveDescription);
        this.archiveProperties.setArchiveType(archiveType);
        this.archiveProperties.setOriginatorName(originatorName);
        this.archiveProperties.setCreationDate(creationDate);
        this.archiveProperties.setDependsOnArchives(dependsOnArchives);
    }

    public OMRSArchiveBuilder(String archiveGUID, String archiveName, String archiveDescription, OpenMetadataArchiveType archiveType, String originatorName, String originatorLicense, Date creationDate, List<String> dependsOnArchives) {
        this(archiveGUID, archiveName, archiveDescription, archiveType, originatorName, creationDate, dependsOnArchives);
        this.archiveProperties.setOriginatorLicense(originatorLicense);
    }

    public void addPrimitiveDef(PrimitiveDef primitiveDef) {
        String methodName = "addPrimitiveDef";
        if (primitiveDef != null) {
            log.debug("Adding PrimitiveDef: " + primitiveDef.toString());
            this.checkForBlanksInTypeName(primitiveDef.getName());
            PrimitiveDef duplicateElement = this.primitiveDefMap.put(primitiveDef.getName(), primitiveDef);
            if (duplicateElement != null) {
                OMRSErrorCode errorCode = OMRSErrorCode.DUPLICATE_TYPE_IN_ARCHIVE;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{primitiveDef.getName(), AttributeTypeDefCategory.PRIMITIVE.getName(), duplicateElement.toString(), primitiveDef.toString()});
                throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "addPrimitiveDef", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            Object duplicateGUID = this.guidMap.put(primitiveDef.getGUID(), primitiveDef);
            if (duplicateGUID != null) {
                OMRSErrorCode errorCode = OMRSErrorCode.DUPLICATE_GUID_IN_ARCHIVE;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{primitiveDef.getGUID(), duplicateGUID.toString(), primitiveDef.toString()});
                throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "addPrimitiveDef", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            Object duplicateName = this.nameMap.put(primitiveDef.getName(), primitiveDef);
            if (duplicateName != null) {
                OMRSErrorCode errorCode = OMRSErrorCode.DUPLICATE_TYPENAME_IN_ARCHIVE;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{primitiveDef.getGUID(), duplicateName.toString(), primitiveDef.toString()});
                throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "addPrimitiveDef", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            this.primitiveDefList.add(primitiveDef);
        }
    }

    public PrimitiveDef getPrimitiveDef(String primitiveDefName) {
        String methodName = "getPrimitiveDef";
        log.debug("Retrieving PrimitiveDef: " + primitiveDefName);
        if (primitiveDefName != null) {
            PrimitiveDef primitiveDef = this.primitiveDefMap.get(primitiveDefName);
            if (primitiveDef == null) {
                OMRSErrorCode errorCode = OMRSErrorCode.MISSING_TYPE_IN_ARCHIVE;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{primitiveDefName, AttributeTypeDefCategory.PRIMITIVE.getName()});
                throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getPrimitiveDef", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            return primitiveDef;
        }
        OMRSErrorCode errorCode = OMRSErrorCode.MISSING_NAME_FOR_ARCHIVE;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{AttributeTypeDefCategory.PRIMITIVE.getName()});
        throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getPrimitiveDef", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public void addCollectionDef(CollectionDef collectionDef) {
        String methodName = "addCollectionDef";
        if (collectionDef != null) {
            log.debug("Adding CollectionDef: " + collectionDef.toString());
            this.checkForBlanksInTypeName(collectionDef.getName());
            CollectionDef duplicateElement = this.collectionDefMap.put(collectionDef.getName(), collectionDef);
            if (duplicateElement != null) {
                OMRSErrorCode errorCode = OMRSErrorCode.DUPLICATE_TYPE_IN_ARCHIVE;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{collectionDef.getName(), AttributeTypeDefCategory.COLLECTION.getName(), duplicateElement.toString(), collectionDef.toString()});
                throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "addCollectionDef", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            Object duplicateGUID = this.guidMap.put(collectionDef.getGUID(), collectionDef);
            if (duplicateGUID != null) {
                OMRSErrorCode errorCode = OMRSErrorCode.DUPLICATE_GUID_IN_ARCHIVE;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{collectionDef.getGUID(), duplicateGUID.toString(), collectionDef.toString()});
                throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "addCollectionDef", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            Object duplicateName = this.nameMap.put(collectionDef.getName(), collectionDef);
            if (duplicateName != null) {
                OMRSErrorCode errorCode = OMRSErrorCode.DUPLICATE_TYPENAME_IN_ARCHIVE;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{collectionDef.getGUID(), duplicateName.toString(), collectionDef.toString()});
                throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "addCollectionDef", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            this.collectionDefList.add(collectionDef);
        }
    }

    public CollectionDef getCollectionDef(String collectionDefName) {
        String methodName = "getCollectionDef";
        log.debug("Retrieving CollectionDef: " + collectionDefName);
        if (collectionDefName != null) {
            CollectionDef collectionDef = this.collectionDefMap.get(collectionDefName);
            if (collectionDef == null) {
                OMRSErrorCode errorCode = OMRSErrorCode.MISSING_TYPE_IN_ARCHIVE;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{collectionDefName, AttributeTypeDefCategory.COLLECTION.getName()});
                throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getCollectionDef", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            return collectionDef;
        }
        OMRSErrorCode errorCode = OMRSErrorCode.MISSING_NAME_FOR_ARCHIVE;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{AttributeTypeDefCategory.COLLECTION.getName()});
        throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getCollectionDef", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public void addEnumDef(EnumDef enumDef) {
        String methodName = "addEnumDef";
        if (enumDef != null) {
            log.debug("Adding EnumDef: " + enumDef.toString());
            this.checkForBlanksInTypeName(enumDef.getName());
            EnumDef duplicateElement = this.enumDefMap.put(enumDef.getName(), enumDef);
            if (duplicateElement != null) {
                OMRSErrorCode errorCode = OMRSErrorCode.DUPLICATE_TYPE_IN_ARCHIVE;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{enumDef.getName(), AttributeTypeDefCategory.ENUM_DEF.getName(), duplicateElement.toString(), enumDef.toString()});
                throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "addEnumDef", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            Object duplicateGUID = this.guidMap.put(enumDef.getGUID(), enumDef);
            if (duplicateGUID != null) {
                OMRSErrorCode errorCode = OMRSErrorCode.DUPLICATE_GUID_IN_ARCHIVE;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{enumDef.getGUID(), duplicateGUID.toString(), enumDef.toString()});
                throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "addEnumDef", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            Object duplicateName = this.nameMap.put(enumDef.getName(), enumDef);
            if (duplicateName != null) {
                OMRSErrorCode errorCode = OMRSErrorCode.DUPLICATE_TYPENAME_IN_ARCHIVE;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{enumDef.getGUID(), duplicateName.toString(), enumDef.toString()});
                throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "addEnumDef", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            this.enumDefList.add(enumDef);
        }
    }

    public EnumDef getEnumDef(String enumDefName) {
        String methodName = "getEnumDef";
        log.debug("Retrieving EnumDef: " + enumDefName);
        if (enumDefName != null) {
            EnumDef enumDef = this.enumDefMap.get(enumDefName);
            if (enumDef == null) {
                OMRSErrorCode errorCode = OMRSErrorCode.MISSING_TYPE_IN_ARCHIVE;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{enumDefName, AttributeTypeDefCategory.ENUM_DEF.getName()});
                throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getEnumDef", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            return enumDef;
        }
        OMRSErrorCode errorCode = OMRSErrorCode.MISSING_NAME_FOR_ARCHIVE;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{AttributeTypeDefCategory.ENUM_DEF.getName()});
        throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getEnumDef", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public void addClassificationDef(ClassificationDef classificationDef) {
        String methodName = "addClassificationDef";
        if (classificationDef != null) {
            log.debug("Adding ClassificationDef: " + classificationDef.toString());
            this.checkForBlanksInTypeName(classificationDef.getName());
            ClassificationDef duplicateElement = this.classificationDefMap.put(classificationDef.getName(), classificationDef);
            if (duplicateElement != null) {
                OMRSErrorCode errorCode = OMRSErrorCode.DUPLICATE_TYPE_IN_ARCHIVE;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{classificationDef.getName(), TypeDefCategory.CLASSIFICATION_DEF.getName(), duplicateElement.toString(), classificationDef.toString()});
                throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "addClassificationDef", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            Object duplicateGUID = this.guidMap.put(classificationDef.getGUID(), classificationDef);
            if (duplicateGUID != null) {
                OMRSErrorCode errorCode = OMRSErrorCode.DUPLICATE_GUID_IN_ARCHIVE;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{classificationDef.getGUID(), duplicateGUID.toString(), classificationDef.toString()});
                throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "addClassificationDef", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            Object duplicateName = this.nameMap.put(classificationDef.getName(), classificationDef);
            if (duplicateName != null) {
                OMRSErrorCode errorCode = OMRSErrorCode.DUPLICATE_TYPENAME_IN_ARCHIVE;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{classificationDef.getName(), duplicateName.toString(), classificationDef.toString()});
                throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "addClassificationDef", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            if (classificationDef.getPropertiesDefinition() != null) {
                HashSet<String> attributeSet = new HashSet<String>();
                for (TypeDefAttribute typeDefAttr : classificationDef.getPropertiesDefinition()) {
                    String duplicateAttributeName = typeDefAttr.getAttributeName();
                    if (attributeSet.contains(duplicateAttributeName)) {
                        OMRSErrorCode errorCode = OMRSErrorCode.DUPLICATE_CLASSIFICATION_ATTR_IN_ARCHIVE;
                        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{duplicateAttributeName, classificationDef.getName()});
                        throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "addClassificationDef", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                    }
                    attributeSet.add(duplicateAttributeName);
                }
            }
            this.classificationDefList.add(classificationDef);
        }
    }

    public void addEntityDef(EntityDef entityDef) {
        String methodName = "addEntityDef";
        if (entityDef != null) {
            log.debug("Adding EntityDef: " + entityDef.toString());
            this.checkForBlanksInTypeName(entityDef.getName());
            EntityDef duplicateElement = this.entityDefMap.put(entityDef.getName(), entityDef);
            if (duplicateElement != null) {
                OMRSErrorCode errorCode = OMRSErrorCode.DUPLICATE_TYPE_IN_ARCHIVE;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{entityDef.getName(), TypeDefCategory.ENTITY_DEF.getName(), duplicateElement.toString(), entityDef.toString()});
                throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "addEntityDef", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            Object duplicateGUID = this.guidMap.put(entityDef.getGUID(), entityDef);
            if (duplicateGUID != null) {
                OMRSErrorCode errorCode = OMRSErrorCode.DUPLICATE_GUID_IN_ARCHIVE;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{entityDef.getGUID(), duplicateGUID.toString(), entityDef.toString()});
                throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "addEntityDef", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            Object duplicateName = this.nameMap.put(entityDef.getName(), entityDef);
            if (duplicateName != null) {
                OMRSErrorCode errorCode = OMRSErrorCode.DUPLICATE_TYPENAME_IN_ARCHIVE;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{entityDef.getName(), duplicateName.toString(), entityDef.toString()});
                throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "addEntityDef", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            if (entityDef.getPropertiesDefinition() != null) {
                HashSet<String> attrSet = new HashSet<String>();
                for (TypeDefAttribute typeDefAttr : entityDef.getPropertiesDefinition()) {
                    String duplicateAttributeName = typeDefAttr.getAttributeName();
                    if (attrSet.contains(duplicateAttributeName)) {
                        OMRSErrorCode errorCode = OMRSErrorCode.DUPLICATE_ENTITY_ATTR_IN_ARCHIVE;
                        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{duplicateAttributeName, entityDef.getName()});
                        throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "addEntityDef", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                    }
                    attrSet.add(duplicateAttributeName);
                }
            }
            this.entityDefList.add(entityDef);
        }
    }

    public EntityDef getEntityDef(String entityDefName) {
        String methodName = "getEntityDef";
        log.debug("Retrieving EntityDef: " + entityDefName);
        if (entityDefName != null) {
            EntityDef retrievedEntityDef = this.entityDefMap.get(entityDefName);
            if (retrievedEntityDef == null) {
                OMRSErrorCode errorCode = OMRSErrorCode.MISSING_TYPE_IN_ARCHIVE;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{entityDefName, TypeDefCategory.ENTITY_DEF.getName()});
                throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getEntityDef", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            return retrievedEntityDef;
        }
        OMRSErrorCode errorCode = OMRSErrorCode.MISSING_NAME_FOR_ARCHIVE;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{TypeDefCategory.ENTITY_DEF.getName()});
        throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getEntityDef", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public void addRelationshipDef(RelationshipDef relationshipDef) {
        String methodName = "addRelationshipDef";
        if (relationshipDef != null) {
            log.debug("Adding RelationshipDef: " + relationshipDef.toString());
            this.checkForBlanksInTypeName(relationshipDef.getName());
            RelationshipDef duplicateElement = this.relationshipDefMap.put(relationshipDef.getName(), relationshipDef);
            if (duplicateElement != null) {
                OMRSErrorCode errorCode = OMRSErrorCode.DUPLICATE_TYPE_IN_ARCHIVE;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{relationshipDef.getName(), TypeDefCategory.RELATIONSHIP_DEF.getName(), duplicateElement.toString(), relationshipDef.toString()});
                throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "addRelationshipDef", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            Object duplicateGUID = this.guidMap.put(relationshipDef.getGUID(), relationshipDef);
            if (duplicateGUID != null) {
                OMRSErrorCode errorCode = OMRSErrorCode.DUPLICATE_GUID_IN_ARCHIVE;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{relationshipDef.getGUID(), duplicateGUID.toString(), relationshipDef.toString()});
                throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "addRelationshipDef", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            Object duplicateName = this.nameMap.put(relationshipDef.getName(), relationshipDef);
            if (duplicateName != null) {
                OMRSErrorCode errorCode = OMRSErrorCode.DUPLICATE_TYPENAME_IN_ARCHIVE;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{relationshipDef.getName(), duplicateName.toString(), relationshipDef.toString()});
                throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "addRelationshipDef", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            this.checkRelationshipDefDuplicateAttributes(relationshipDef);
            if (relationshipDef.getPropertiesDefinition() != null) {
                HashSet<String> attributeSet = new HashSet<String>();
                for (TypeDefAttribute typeDefAttr : relationshipDef.getPropertiesDefinition()) {
                    String duplicateAttributeName = typeDefAttr.getAttributeName();
                    if (attributeSet.contains(duplicateAttributeName)) {
                        OMRSErrorCode errorCode = OMRSErrorCode.DUPLICATE_RELATIONSHIP_ATTR_IN_ARCHIVE;
                        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{duplicateAttributeName, relationshipDef.getName()});
                        throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "addRelationshipDef", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                    }
                    attributeSet.add(duplicateAttributeName);
                }
            }
            this.relationshipDefList.add(relationshipDef);
        }
    }

    private void checkRelationshipDefDuplicateAttributes(RelationshipDef relationshipDef) throws OMRSLogicErrorException {
        EntityDef entityDef2;
        Set<Object> attributeSet;
        String methodName = "checkRelationshipDefDuplicateAttributes";
        RelationshipEndDef end1 = relationshipDef.getEndDef1();
        RelationshipEndDef end2 = relationshipDef.getEndDef2();
        String end1Name = end1.getAttributeName();
        String end1Type = end1.getEntityType().getName();
        String end2Name = end2.getAttributeName();
        String end2Type = end2.getEntityType().getName();
        if (end1Name.equals(end2Name) && end1Type.equals(end2Type)) {
            if (this.entityAttributeMap.get(end1Type) == null) {
                attributeSet = new HashSet();
                attributeSet.add(end1Name);
                this.entityAttributeMap.put(end1Type, attributeSet);
            } else {
                attributeSet = this.entityAttributeMap.get(end1Type);
                if (attributeSet.contains(end2Name)) {
                    OMRSErrorCode errorCode = OMRSErrorCode.DUPLICATE_ENDDEF2_NAME_IN_ARCHIVE;
                    String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{end1Type, end2Name, relationshipDef.getName()});
                    throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "checkRelationshipDefDuplicateAttributes", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                }
                attributeSet.add(end1Name);
            }
        } else {
            if (this.entityAttributeMap.get(end1Type) == null) {
                attributeSet = new HashSet<String>();
                attributeSet.add(end2Name);
                this.entityAttributeMap.put(end1Type, attributeSet);
            } else {
                attributeSet = this.entityAttributeMap.get(end1Type);
                if (attributeSet.contains(end2Name)) {
                    OMRSErrorCode errorCode = OMRSErrorCode.DUPLICATE_ENDDEF2_NAME_IN_ARCHIVE;
                    String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{end1Type, end2Name, relationshipDef.getName()});
                    throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "checkRelationshipDefDuplicateAttributes", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                }
                attributeSet.add(end2Name);
            }
            if (this.entityAttributeMap.get(end2Type) == null) {
                HashSet<String> attrSet = new HashSet<String>();
                attrSet.add(end1Name);
                this.entityAttributeMap.put(end2Type, attrSet);
            } else {
                attributeSet = this.entityAttributeMap.get(end2Type);
                if (attributeSet.contains(end1Name)) {
                    OMRSErrorCode errorCode = OMRSErrorCode.DUPLICATE_ENDDEF1_NAME_IN_ARCHIVE;
                    String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{end2Type, end1Name, relationshipDef.getName()});
                    throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "checkRelationshipDefDuplicateAttributes", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                }
                attributeSet.add(end1Name);
            }
        }
        EntityDef entityDef1 = this.entityDefMap.get(end1Type);
        if (entityDef1.getPropertiesDefinition() != null) {
            Set<String> attributeSet2 = this.entityAttributeMap.get(end1Type);
            for (TypeDefAttribute typeDefAttr : entityDef1.getPropertiesDefinition()) {
                String localAttributeName = typeDefAttr.getAttributeName();
                if (localAttributeName.equals(end2Name)) {
                    OMRSErrorCode errorCode = OMRSErrorCode.DUPLICATE_ENDDEF2_NAME_IN_ARCHIVE;
                    String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{end1Type, end2Name, relationshipDef.getName()});
                    throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "checkRelationshipDefDuplicateAttributes", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                }
                attributeSet2.add(end2Name);
            }
        }
        if ((entityDef2 = this.entityDefMap.get(end2Type)).getPropertiesDefinition() != null) {
            Set<String> attributeSet3 = this.entityAttributeMap.get(end2Type);
            for (TypeDefAttribute typeDefAttr : entityDef2.getPropertiesDefinition()) {
                String localAttributeName = typeDefAttr.getAttributeName();
                if (localAttributeName.equals(end1Name)) {
                    OMRSErrorCode errorCode = OMRSErrorCode.DUPLICATE_ENDDEF1_NAME_IN_ARCHIVE;
                    String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{end2Type, end1Name, relationshipDef.getName()});
                    throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "checkRelationshipDefDuplicateAttributes", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                }
                attributeSet3.add(end1Name);
            }
        }
    }

    public void addEntity(EntityDetail entity) {
        String methodName = "addEntity";
        if (entity != null) {
            log.debug("Adding Entity: " + entity.toString());
            EntityDetail duplicateElement = this.entityDetailMap.put(entity.getGUID(), entity);
            if (duplicateElement != null) {
                OMRSErrorCode errorCode = OMRSErrorCode.DUPLICATE_INSTANCE_IN_ARCHIVE;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{TypeDefCategory.ENTITY_DEF.getName(), entity.getGUID(), duplicateElement.toString(), entity.toString()});
                throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "addEntity", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            Object duplicateGUID = this.guidMap.put(entity.getGUID(), entity);
            if (duplicateGUID != null) {
                OMRSErrorCode errorCode = OMRSErrorCode.DUPLICATE_GUID_IN_ARCHIVE;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{entity.getGUID(), duplicateGUID.toString(), entity.toString()});
                throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "addEntity", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            this.entityDetailList.add(entity);
        }
    }

    public void addRelationship(Relationship relationship) {
        String methodName = "addRelationship";
        if (relationship != null) {
            log.debug("Adding Relationship: " + relationship.toString());
            Relationship duplicateElement = this.relationshipMap.put(relationship.getGUID(), relationship);
            if (duplicateElement != null) {
                OMRSErrorCode errorCode = OMRSErrorCode.DUPLICATE_INSTANCE_IN_ARCHIVE;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{TypeDefCategory.ENTITY_DEF.getName(), relationship.getGUID(), duplicateElement.toString(), relationship.toString()});
                throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "addRelationship", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            Object duplicateGUID = this.guidMap.put(relationship.getGUID(), relationship);
            if (duplicateGUID != null) {
                OMRSErrorCode errorCode = OMRSErrorCode.DUPLICATE_GUID_IN_ARCHIVE;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{relationship.getGUID(), duplicateGUID.toString(), relationship.toString()});
                throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "addRelationship", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            this.relationshipList.add(relationship);
        }
    }

    public void addClassification(ClassificationEntityExtension classification) {
        String methodName = "addClassification";
        if (classification != null) {
            log.debug("Adding Classification: " + classification.toString());
            String classificationId = classification.getEntityToClassify().getGUID() + ":" + classification.getClassification().getName();
            ClassificationEntityExtension duplicateElement = this.classificationMap.put(classificationId, classification);
            if (duplicateElement != null) {
                OMRSErrorCode errorCode = OMRSErrorCode.DUPLICATE_INSTANCE_IN_ARCHIVE;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{TypeDefCategory.CLASSIFICATION_DEF.getName(), classificationId, duplicateElement.toString(), classification.toString()});
                throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "addClassification", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            this.classificationList.add(classification);
        }
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        log.debug("Retrieving Open Metadata Archive: " + this.archiveProperties.getArchiveName());
        OpenMetadataArchive archive = new OpenMetadataArchive();
        archive.setArchiveProperties(this.archiveProperties);
        ArrayList<Object> attributeTypeDefs = new ArrayList<Object>();
        ArrayList<Object> typeDefs = new ArrayList<Object>();
        ArrayList<TypeDefPatch> typeDefPatches = new ArrayList<TypeDefPatch>();
        if (!this.primitiveDefList.isEmpty()) {
            attributeTypeDefs.addAll(this.primitiveDefList);
        }
        if (!this.collectionDefList.isEmpty()) {
            attributeTypeDefs.addAll(this.collectionDefList);
        }
        if (!this.enumDefList.isEmpty()) {
            attributeTypeDefs.addAll(this.enumDefList);
        }
        if (!this.entityDefList.isEmpty()) {
            typeDefs.addAll(this.entityDefList);
        }
        if (!this.classificationDefList.isEmpty()) {
            typeDefs.addAll(this.classificationDefList);
        }
        if (!this.relationshipDefList.isEmpty()) {
            typeDefs.addAll(this.relationshipDefList);
        }
        if (!this.typeDefPatchList.isEmpty()) {
            typeDefPatches.addAll(this.typeDefPatchList);
        }
        if (!(typeDefs.isEmpty() && typeDefPatches.isEmpty() && attributeTypeDefs.isEmpty())) {
            OpenMetadataArchiveTypeStore typeStore = new OpenMetadataArchiveTypeStore();
            if (!attributeTypeDefs.isEmpty()) {
                typeStore.setAttributeTypeDefs(attributeTypeDefs);
            }
            if (!typeDefs.isEmpty()) {
                typeStore.setNewTypeDefs(typeDefs);
            }
            if (!typeDefPatches.isEmpty()) {
                typeStore.setTypeDefPatches(typeDefPatches);
            }
            archive.setArchiveTypeStore(typeStore);
        }
        ArrayList<EntityDetail> entities = new ArrayList<EntityDetail>();
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        if (!this.entityDetailList.isEmpty()) {
            entities.addAll(this.entityDetailList);
        }
        if (!this.relationshipList.isEmpty()) {
            relationships.addAll(this.relationshipList);
        }
        if (!entities.isEmpty() || !relationships.isEmpty()) {
            OpenMetadataArchiveInstanceStore instanceStore = new OpenMetadataArchiveInstanceStore();
            if (!entities.isEmpty()) {
                instanceStore.setEntities(entities);
            }
            if (!relationships.isEmpty()) {
                instanceStore.setRelationships(relationships);
            }
            archive.setArchiveInstanceStore(instanceStore);
        }
        return archive;
    }

    private void checkForBlanksInTypeName(String typeName) {
        String methodName = "checkForBlanksInTypeName";
        if (typeName.contains(" ")) {
            OMRSErrorCode errorCode = OMRSErrorCode.BLANK_TYPENAME_IN_ARCHIVE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{typeName});
            throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "checkForBlanksInTypeName", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }
}

