/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.archivemanager;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.repositoryservices.archivemanager.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationPropagationRule;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.CollectionDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.CollectionDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumElementDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;

public class OMRSArchiveHelper {
    private OMRSArchiveBuilder archiveBuilder;
    private String archiveGUID;
    private String originatorName;
    private Date creationDate;
    private long versionNumber;
    private String versionName;

    public OMRSArchiveHelper(OMRSArchiveBuilder archiveBuilder, String archiveGUID, String originatorName, Date creationDate, long versionNumber, String versionName) {
        this.archiveBuilder = archiveBuilder;
        this.archiveGUID = archiveGUID;
        this.originatorName = originatorName;
        this.creationDate = creationDate;
        this.versionNumber = versionNumber;
        this.versionName = versionName;
    }

    public PrimitiveDef getPrimitiveDef(PrimitiveDefCategory primitiveDefCategory) {
        PrimitiveDef primitiveDef = new PrimitiveDef(primitiveDefCategory);
        primitiveDef.setGUID(primitiveDefCategory.getGUID());
        primitiveDef.setName(primitiveDefCategory.getName());
        primitiveDef.setVersion(this.versionNumber);
        primitiveDef.setVersionName(this.versionName);
        return primitiveDef;
    }

    public CollectionDef getArrayCollectionDef(String guid, String description, String descriptionGUID, PrimitiveDefCategory arrayType) {
        CollectionDef collectionDef = new CollectionDef(CollectionDefCategory.OM_COLLECTION_ARRAY);
        collectionDef.setGUID(guid);
        collectionDef.setName("array<" + arrayType.getName() + ">");
        collectionDef.setDescription(description);
        collectionDef.setDescriptionGUID(descriptionGUID);
        collectionDef.setVersion(this.versionNumber);
        collectionDef.setVersionName(this.versionName);
        ArrayList<PrimitiveDefCategory> argumentList = new ArrayList<PrimitiveDefCategory>();
        argumentList.add(arrayType);
        collectionDef.setArgumentTypes(argumentList);
        return collectionDef;
    }

    public CollectionDef getMapCollectionDef(String guid, String description, String descriptionGUID, PrimitiveDefCategory propertyKeyType, PrimitiveDefCategory propertyValueType) {
        CollectionDef collectionDef = new CollectionDef(CollectionDefCategory.OM_COLLECTION_MAP);
        collectionDef.setGUID(guid);
        collectionDef.setName("map<" + propertyKeyType.getName() + "," + propertyValueType.getName() + ">");
        collectionDef.setDescription(description);
        collectionDef.setDescriptionGUID(descriptionGUID);
        collectionDef.setVersion(this.versionNumber);
        collectionDef.setVersionName(this.versionName);
        ArrayList<PrimitiveDefCategory> argumentList = new ArrayList<PrimitiveDefCategory>();
        argumentList.add(propertyKeyType);
        argumentList.add(propertyValueType);
        collectionDef.setArgumentTypes(argumentList);
        return collectionDef;
    }

    public EnumDef getEmptyEnumDef(String guid, String name, String description, String descriptionGUID) {
        EnumDef enumDef = new EnumDef();
        enumDef.setGUID(guid);
        enumDef.setName(name);
        enumDef.setDescription(description);
        enumDef.setDescriptionGUID(descriptionGUID);
        enumDef.setDefaultValue(null);
        enumDef.setVersion(this.versionNumber);
        enumDef.setVersionName(this.versionName);
        return enumDef;
    }

    public EnumElementDef getEnumElementDef(int ordinal, String value, String description, String descriptionGUID) {
        EnumElementDef enumElementDef = new EnumElementDef();
        enumElementDef.setOrdinal(ordinal);
        enumElementDef.setValue(value);
        enumElementDef.setDescription(description);
        enumElementDef.setDescriptionGUID(descriptionGUID);
        return enumElementDef;
    }

    public EntityDef getDefaultEntityDef(String guid, String name, TypeDefLink superType, String description, String descriptionGUID) {
        EntityDef entityDef = new EntityDef();
        entityDef.setGUID(guid);
        entityDef.setName(name);
        entityDef.setSuperType(superType);
        entityDef.setDescription(description);
        entityDef.setDescriptionGUID(descriptionGUID);
        entityDef.setOrigin(this.archiveGUID);
        entityDef.setCreatedBy(this.originatorName);
        entityDef.setCreateTime(this.creationDate);
        entityDef.setVersion(this.versionNumber);
        entityDef.setVersionName(this.versionName);
        ArrayList<InstanceStatus> validInstanceStatusList = new ArrayList<InstanceStatus>();
        validInstanceStatusList.add(InstanceStatus.ACTIVE);
        validInstanceStatusList.add(InstanceStatus.DELETED);
        entityDef.setValidInstanceStatusList(validInstanceStatusList);
        entityDef.setInitialStatus(InstanceStatus.ACTIVE);
        return entityDef;
    }

    public TypeDefAttribute getStringTypeDefAttribute(String attributeName, String attributeDescription, String attributeDescriptionGUID) {
        TypeDefAttribute attribute = new TypeDefAttribute();
        attribute.setAttributeName(attributeName);
        attribute.setAttributeDescription(attributeDescription);
        attribute.setAttributeDescriptionGUID(attributeDescriptionGUID);
        attribute.setAttributeType((AttributeTypeDef)this.archiveBuilder.getPrimitiveDef(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getName()));
        attribute.setAttributeCardinality(AttributeCardinality.AT_MOST_ONE);
        attribute.setValuesMinCount(0);
        attribute.setValuesMaxCount(1);
        attribute.setIndexable(true);
        attribute.setUnique(false);
        attribute.setDefaultValue(null);
        attribute.setExternalStandardMappings(null);
        return attribute;
    }

    public TypeDefAttribute getIntTypeDefAttribute(String attributeName, String attributeDescription, String attributeDescriptionGUID) {
        TypeDefAttribute attribute = new TypeDefAttribute();
        attribute.setAttributeName(attributeName);
        attribute.setAttributeDescription(attributeDescription);
        attribute.setAttributeDescriptionGUID(attributeDescriptionGUID);
        attribute.setAttributeType((AttributeTypeDef)this.archiveBuilder.getPrimitiveDef(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT.getName()));
        attribute.setAttributeCardinality(AttributeCardinality.AT_MOST_ONE);
        attribute.setValuesMinCount(0);
        attribute.setValuesMaxCount(1);
        attribute.setIndexable(true);
        attribute.setUnique(false);
        attribute.setDefaultValue(null);
        attribute.setExternalStandardMappings(null);
        return attribute;
    }

    public TypeDefAttribute getBooleanTypeDefAttribute(String attributeName, String attributeDescription, String attributeDescriptionGUID) {
        TypeDefAttribute attribute = new TypeDefAttribute();
        attribute.setAttributeName(attributeName);
        attribute.setAttributeDescription(attributeDescription);
        attribute.setAttributeDescriptionGUID(attributeDescriptionGUID);
        attribute.setAttributeType((AttributeTypeDef)this.archiveBuilder.getPrimitiveDef(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BOOLEAN.getName()));
        attribute.setAttributeCardinality(AttributeCardinality.AT_MOST_ONE);
        attribute.setValuesMinCount(0);
        attribute.setValuesMaxCount(1);
        attribute.setIndexable(true);
        attribute.setUnique(false);
        attribute.setDefaultValue(null);
        attribute.setExternalStandardMappings(null);
        return attribute;
    }

    public TypeDefAttribute getDateTypeDefAttribute(String attributeName, String attributeDescription, String attributeDescriptionGUID) {
        TypeDefAttribute attribute = new TypeDefAttribute();
        attribute.setAttributeName(attributeName);
        attribute.setAttributeDescription(attributeDescription);
        attribute.setAttributeDescriptionGUID(attributeDescriptionGUID);
        attribute.setAttributeType((AttributeTypeDef)this.archiveBuilder.getPrimitiveDef(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE.getName()));
        attribute.setAttributeCardinality(AttributeCardinality.AT_MOST_ONE);
        attribute.setValuesMinCount(0);
        attribute.setValuesMaxCount(1);
        attribute.setIndexable(true);
        attribute.setUnique(false);
        attribute.setDefaultValue(null);
        attribute.setExternalStandardMappings(null);
        return attribute;
    }

    public TypeDefAttribute getLongTypeDefAttribute(String attributeName, String attributeDescription, String attributeDescriptionGUID) {
        TypeDefAttribute attribute = new TypeDefAttribute();
        attribute.setAttributeName(attributeName);
        attribute.setAttributeDescription(attributeDescription);
        attribute.setAttributeDescriptionGUID(attributeDescriptionGUID);
        attribute.setAttributeType((AttributeTypeDef)this.archiveBuilder.getPrimitiveDef(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_LONG.getName()));
        attribute.setAttributeCardinality(AttributeCardinality.AT_MOST_ONE);
        attribute.setValuesMinCount(0);
        attribute.setValuesMaxCount(1);
        attribute.setIndexable(true);
        attribute.setUnique(false);
        attribute.setDefaultValue(null);
        attribute.setExternalStandardMappings(null);
        return attribute;
    }

    public TypeDefAttribute getFloatTypeDefAttribute(String attributeName, String attributeDescription, String attributeDescriptionGUID) {
        TypeDefAttribute attribute = new TypeDefAttribute();
        attribute.setAttributeName(attributeName);
        attribute.setAttributeDescription(attributeDescription);
        attribute.setAttributeDescriptionGUID(attributeDescriptionGUID);
        attribute.setAttributeType((AttributeTypeDef)this.archiveBuilder.getPrimitiveDef(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_FLOAT.getName()));
        attribute.setAttributeCardinality(AttributeCardinality.AT_MOST_ONE);
        attribute.setValuesMinCount(0);
        attribute.setValuesMaxCount(1);
        attribute.setIndexable(true);
        attribute.setUnique(false);
        attribute.setDefaultValue(null);
        attribute.setExternalStandardMappings(null);
        return attribute;
    }

    public TypeDefAttribute getArrayStringTypeDefAttribute(String attributeName, String attributeDescription, String attributeDescriptionGUID) {
        TypeDefAttribute attribute = new TypeDefAttribute();
        attribute.setAttributeName(attributeName);
        attribute.setAttributeDescription(attributeDescription);
        attribute.setAttributeDescriptionGUID(attributeDescriptionGUID);
        attribute.setAttributeType((AttributeTypeDef)this.archiveBuilder.getCollectionDef("array<string>"));
        attribute.setAttributeCardinality(AttributeCardinality.AT_MOST_ONE);
        attribute.setValuesMinCount(0);
        attribute.setValuesMaxCount(1);
        attribute.setIndexable(true);
        attribute.setUnique(false);
        attribute.setDefaultValue(null);
        attribute.setExternalStandardMappings(null);
        return attribute;
    }

    public TypeDefAttribute getArrayIntTypeDefAttribute(String attributeName, String attributeDescription, String attributeDescriptionGUID) {
        TypeDefAttribute attribute = new TypeDefAttribute();
        attribute.setAttributeName(attributeName);
        attribute.setAttributeDescription(attributeDescription);
        attribute.setAttributeDescriptionGUID(attributeDescriptionGUID);
        attribute.setAttributeType((AttributeTypeDef)this.archiveBuilder.getCollectionDef("array<int>"));
        attribute.setAttributeCardinality(AttributeCardinality.AT_MOST_ONE);
        attribute.setValuesMinCount(0);
        attribute.setValuesMaxCount(1);
        attribute.setIndexable(true);
        attribute.setUnique(false);
        attribute.setDefaultValue(null);
        attribute.setExternalStandardMappings(null);
        return attribute;
    }

    public TypeDefAttribute getMapStringStringTypeDefAttribute(String attributeName, String attributeDescription, String attributeDescriptionGUID) {
        TypeDefAttribute attribute = new TypeDefAttribute();
        attribute.setAttributeName(attributeName);
        attribute.setAttributeDescription(attributeDescription);
        attribute.setAttributeDescriptionGUID(attributeDescriptionGUID);
        attribute.setAttributeType((AttributeTypeDef)this.archiveBuilder.getCollectionDef("map<string,string>"));
        attribute.setAttributeCardinality(AttributeCardinality.AT_MOST_ONE);
        attribute.setValuesMinCount(0);
        attribute.setValuesMaxCount(1);
        attribute.setIndexable(true);
        attribute.setUnique(false);
        attribute.setDefaultValue(null);
        attribute.setExternalStandardMappings(null);
        return attribute;
    }

    public TypeDefAttribute getMapStringBooleanTypeDefAttribute(String attributeName, String attributeDescription, String attributeDescriptionGUID) {
        TypeDefAttribute attribute = new TypeDefAttribute();
        attribute.setAttributeName(attributeName);
        attribute.setAttributeDescription(attributeDescription);
        attribute.setAttributeDescriptionGUID(attributeDescriptionGUID);
        attribute.setAttributeType((AttributeTypeDef)this.archiveBuilder.getCollectionDef("map<string,boolean>"));
        attribute.setAttributeCardinality(AttributeCardinality.AT_MOST_ONE);
        attribute.setValuesMinCount(0);
        attribute.setValuesMaxCount(1);
        attribute.setIndexable(true);
        attribute.setUnique(false);
        attribute.setDefaultValue(null);
        attribute.setExternalStandardMappings(null);
        return attribute;
    }

    public TypeDefAttribute getMapStringLongTypeDefAttribute(String attributeName, String attributeDescription, String attributeDescriptionGUID) {
        TypeDefAttribute attribute = new TypeDefAttribute();
        attribute.setAttributeName(attributeName);
        attribute.setAttributeDescription(attributeDescription);
        attribute.setAttributeDescriptionGUID(attributeDescriptionGUID);
        attribute.setAttributeType((AttributeTypeDef)this.archiveBuilder.getCollectionDef("map<string,long>"));
        attribute.setAttributeCardinality(AttributeCardinality.AT_MOST_ONE);
        attribute.setValuesMinCount(0);
        attribute.setValuesMaxCount(1);
        attribute.setIndexable(true);
        attribute.setUnique(false);
        attribute.setDefaultValue(null);
        attribute.setExternalStandardMappings(null);
        return attribute;
    }

    public TypeDefAttribute getMapStringIntTypeDefAttribute(String attributeName, String attributeDescription, String attributeDescriptionGUID) {
        TypeDefAttribute attribute = new TypeDefAttribute();
        attribute.setAttributeName(attributeName);
        attribute.setAttributeDescription(attributeDescription);
        attribute.setAttributeDescriptionGUID(attributeDescriptionGUID);
        attribute.setAttributeType((AttributeTypeDef)this.archiveBuilder.getCollectionDef("map<string,int>"));
        attribute.setAttributeCardinality(AttributeCardinality.AT_MOST_ONE);
        attribute.setValuesMinCount(0);
        attribute.setValuesMaxCount(1);
        attribute.setIndexable(true);
        attribute.setUnique(false);
        attribute.setDefaultValue(null);
        attribute.setExternalStandardMappings(null);
        return attribute;
    }

    public TypeDefAttribute getEnumTypeDefAttribute(String enumTypeName, String attributeName, String attributeDescription, String attributeDescriptionGUID) {
        TypeDefAttribute attribute = new TypeDefAttribute();
        attribute.setAttributeName(attributeName);
        attribute.setAttributeDescription(attributeDescription);
        attribute.setAttributeDescriptionGUID(attributeDescriptionGUID);
        attribute.setAttributeType((AttributeTypeDef)this.archiveBuilder.getEnumDef(enumTypeName));
        attribute.setAttributeCardinality(AttributeCardinality.AT_MOST_ONE);
        attribute.setValuesMinCount(0);
        attribute.setValuesMaxCount(1);
        attribute.setIndexable(true);
        attribute.setUnique(false);
        attribute.setDefaultValue(null);
        attribute.setExternalStandardMappings(null);
        return attribute;
    }

    public TypeDefAttribute getArrayEnumTypeDefAttribute(String enumArrayTypeName, String attributeName, String attributeDescription, String attributeDescriptionGUID) {
        TypeDefAttribute attribute = new TypeDefAttribute();
        attribute.setAttributeName(attributeName);
        attribute.setAttributeDescription(attributeDescription);
        attribute.setAttributeDescriptionGUID(attributeDescriptionGUID);
        attribute.setAttributeType((AttributeTypeDef)this.archiveBuilder.getCollectionDef(enumArrayTypeName));
        attribute.setAttributeCardinality(AttributeCardinality.AT_MOST_ONE);
        attribute.setValuesMinCount(0);
        attribute.setValuesMaxCount(1);
        attribute.setIndexable(true);
        attribute.setUnique(false);
        attribute.setDefaultValue(null);
        attribute.setExternalStandardMappings(null);
        return attribute;
    }

    public RelationshipDef getBasicRelationshipDef(String guid, String name, TypeDefLink superType, String description, String descriptionGUID, ClassificationPropagationRule propagationRule) {
        RelationshipDef relationshipDef = new RelationshipDef();
        relationshipDef.setGUID(guid);
        relationshipDef.setName(name);
        relationshipDef.setSuperType(superType);
        relationshipDef.setDescription(description);
        relationshipDef.setDescriptionGUID(descriptionGUID);
        relationshipDef.setOrigin(this.archiveGUID);
        relationshipDef.setCreatedBy(this.originatorName);
        relationshipDef.setCreateTime(this.creationDate);
        relationshipDef.setVersion(this.versionNumber);
        relationshipDef.setVersionName(this.versionName);
        ArrayList<InstanceStatus> validInstanceStatusList = new ArrayList<InstanceStatus>();
        validInstanceStatusList.add(InstanceStatus.ACTIVE);
        validInstanceStatusList.add(InstanceStatus.DELETED);
        relationshipDef.setValidInstanceStatusList(validInstanceStatusList);
        relationshipDef.setInitialStatus(InstanceStatus.ACTIVE);
        relationshipDef.setPropagationRule(propagationRule);
        return relationshipDef;
    }

    public RelationshipEndDef getRelationshipEndDef(TypeDefLink entityType, String attributeName, String attributeDescription, String attributeDescriptionGUID, RelationshipEndCardinality attributeCardinality) {
        RelationshipEndDef relationshipEndDef = new RelationshipEndDef();
        relationshipEndDef.setEntityType(entityType);
        relationshipEndDef.setAttributeName(attributeName);
        relationshipEndDef.setAttributeDescription(attributeDescription);
        relationshipEndDef.setAttributeDescriptionGUID(attributeDescriptionGUID);
        relationshipEndDef.setAttributeCardinality(attributeCardinality);
        return relationshipEndDef;
    }

    public ClassificationDef getClassificationDef(String guid, String name, TypeDefLink superType, String description, String descriptionGUID, TypeDefLink validEntityDef, boolean propagatable) {
        ClassificationDef classificationDef = new ClassificationDef();
        classificationDef.setGUID(guid);
        classificationDef.setName(name);
        classificationDef.setSuperType(superType);
        classificationDef.setDescription(description);
        classificationDef.setDescriptionGUID(descriptionGUID);
        classificationDef.setOrigin(this.archiveGUID);
        classificationDef.setCreatedBy(this.originatorName);
        classificationDef.setCreateTime(this.creationDate);
        classificationDef.setVersion(this.versionNumber);
        classificationDef.setVersionName(this.versionName);
        ArrayList<InstanceStatus> validInstanceStatusList = new ArrayList<InstanceStatus>();
        validInstanceStatusList.add(InstanceStatus.ACTIVE);
        validInstanceStatusList.add(InstanceStatus.DELETED);
        classificationDef.setValidInstanceStatusList(validInstanceStatusList);
        classificationDef.setInitialStatus(InstanceStatus.ACTIVE);
        ArrayList<TypeDefLink> validEntityDefs = new ArrayList<TypeDefLink>();
        validEntityDefs.add(validEntityDef);
        classificationDef.setValidEntityDefs(validEntityDefs);
        classificationDef.setPropagatable(propagatable);
        return classificationDef;
    }
}

