/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollectionBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceGraph;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefGallery;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.EnterpriseOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidTypeDefException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.StatusNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EnterpriseOMRSMetadataCollection
extends OMRSMetadataCollectionBase {
    private static final Logger log = LoggerFactory.getLogger(EnterpriseOMRSMetadataCollection.class);
    private EnterpriseOMRSRepositoryConnector enterpriseParentConnector;

    public EnterpriseOMRSMetadataCollection(EnterpriseOMRSRepositoryConnector enterpriseParentConnector, String repositoryName, OMRSRepositoryHelper repositoryHelper, OMRSRepositoryValidator repositoryValidator, String metadataCollectionId) {
        super((OMRSRepositoryConnector)enterpriseParentConnector, repositoryName, repositoryHelper, repositoryValidator, metadataCollectionId, false);
        this.enterpriseParentConnector = enterpriseParentConnector;
    }

    public TypeDefGallery getAllTypes(String userId) throws RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "getAllTypes";
        this.validateRepositoryConnector("getAllTypes");
        this.parentConnector.validateRepositoryIsActive("getAllTypes");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "getAllTypes");
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("getAllTypes");
        Map<String, TypeDef> combinedTypeDefResults = new HashMap<String, TypeDef>();
        Map<String, AttributeTypeDef> combinedAttributeTypeDefResults = new HashMap<String, AttributeTypeDef>();
        UserNotAuthorizedException userNotAuthorizedException = null;
        RepositoryErrorException repositoryErrorException = null;
        Throwable anotherException = null;
        for (OMRSRepositoryConnector cohortConnector : cohortConnectors) {
            if (cohortConnector == null) continue;
            OMRSMetadataCollection metadataCollection = cohortConnector.getMetadataCollection();
            this.validateMetadataCollection(metadataCollection, "getAllTypes");
            try {
                TypeDefGallery results = metadataCollection.getAllTypes(userId);
                if (results == null) continue;
                combinedAttributeTypeDefResults = this.addUniqueAttributeTypeDefs(combinedAttributeTypeDefResults, results.getAttributeTypeDefs(), cohortConnector.getServerName(), cohortConnector.getMetadataCollectionId(), "getAllTypes");
                combinedTypeDefResults = this.addUniqueTypeDefs(combinedTypeDefResults, results.getTypeDefs(), cohortConnector.getServerName(), cohortConnector.getMetadataCollectionId(), "getAllTypes");
            }
            catch (RepositoryErrorException error) {
                repositoryErrorException = error;
            }
            catch (UserNotAuthorizedException error) {
                userNotAuthorizedException = error;
            }
            catch (Throwable error) {
                anotherException = error;
            }
        }
        return this.validatedTypeDefGalleryResults(this.repositoryName, combinedTypeDefResults, combinedAttributeTypeDefResults, userNotAuthorizedException, repositoryErrorException, anotherException, "getAllTypes");
    }

    public TypeDefGallery findTypesByName(String userId, String name) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "findTypesByName";
        String nameParameterName = "name";
        this.validateRepositoryConnector("findTypesByName");
        this.parentConnector.validateRepositoryIsActive("findTypesByName");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "findTypesByName");
        this.repositoryValidator.validateTypeName(this.repositoryName, "name", name, "findTypesByName");
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("findTypesByName");
        Map<String, TypeDef> combinedTypeDefResults = new HashMap<String, TypeDef>();
        Map<String, AttributeTypeDef> combinedAttributeTypeDefResults = new HashMap<String, AttributeTypeDef>();
        UserNotAuthorizedException userNotAuthorizedException = null;
        RepositoryErrorException repositoryErrorException = null;
        Throwable anotherException = null;
        for (OMRSRepositoryConnector cohortConnector : cohortConnectors) {
            if (cohortConnector == null) continue;
            OMRSMetadataCollection metadataCollection = cohortConnector.getMetadataCollection();
            this.validateMetadataCollection(metadataCollection, "findTypesByName");
            try {
                TypeDefGallery results = metadataCollection.findTypesByName(userId, name);
                if (results == null) continue;
                combinedAttributeTypeDefResults = this.addUniqueAttributeTypeDefs(combinedAttributeTypeDefResults, results.getAttributeTypeDefs(), cohortConnector.getServerName(), cohortConnector.getMetadataCollectionId(), "findTypesByName");
                combinedTypeDefResults = this.addUniqueTypeDefs(combinedTypeDefResults, results.getTypeDefs(), cohortConnector.getServerName(), cohortConnector.getMetadataCollectionId(), "findTypesByName");
            }
            catch (RepositoryErrorException error) {
                repositoryErrorException = error;
            }
            catch (UserNotAuthorizedException error) {
                userNotAuthorizedException = error;
            }
            catch (Throwable error) {
                anotherException = error;
            }
        }
        return this.validatedTypeDefGalleryResults(this.repositoryName, combinedTypeDefResults, combinedAttributeTypeDefResults, userNotAuthorizedException, repositoryErrorException, anotherException, "findTypesByName");
    }

    public List<TypeDef> findTypeDefsByCategory(String userId, TypeDefCategory category) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "findTypeDefsByCategory";
        String categoryParameterName = "category";
        this.validateRepositoryConnector("findTypeDefsByCategory");
        this.parentConnector.validateRepositoryIsActive("findTypeDefsByCategory");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "findTypeDefsByCategory");
        this.repositoryValidator.validateTypeDefCategory(this.repositoryName, "category", category, "findTypeDefsByCategory");
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("findTypeDefsByCategory");
        Map<String, TypeDef> combinedResults = new HashMap<String, TypeDef>();
        UserNotAuthorizedException userNotAuthorizedException = null;
        RepositoryErrorException repositoryErrorException = null;
        Throwable anotherException = null;
        for (OMRSRepositoryConnector cohortConnector : cohortConnectors) {
            if (cohortConnector == null) continue;
            OMRSMetadataCollection metadataCollection = cohortConnector.getMetadataCollection();
            this.validateMetadataCollection(metadataCollection, "findTypeDefsByCategory");
            try {
                List results = metadataCollection.findTypeDefsByCategory(userId, category);
                combinedResults = this.addUniqueTypeDefs(combinedResults, results, cohortConnector.getServerName(), cohortConnector.getMetadataCollectionId(), "findTypeDefsByCategory");
            }
            catch (RepositoryErrorException error) {
                repositoryErrorException = error;
            }
            catch (UserNotAuthorizedException error) {
                userNotAuthorizedException = error;
            }
            catch (Throwable error) {
                anotherException = error;
            }
        }
        return this.validatedTypeDefListResults(this.repositoryName, combinedResults, userNotAuthorizedException, repositoryErrorException, anotherException, "findTypeDefsByCategory");
    }

    public List<AttributeTypeDef> findAttributeTypeDefsByCategory(String userId, AttributeTypeDefCategory category) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "findAttributeTypeDefsByCategory";
        String categoryParameterName = "category";
        this.validateRepositoryConnector("findAttributeTypeDefsByCategory");
        this.parentConnector.validateRepositoryIsActive("findAttributeTypeDefsByCategory");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "findAttributeTypeDefsByCategory");
        this.repositoryValidator.validateAttributeTypeDefCategory(this.repositoryName, "category", category, "findAttributeTypeDefsByCategory");
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("findAttributeTypeDefsByCategory");
        Map<String, AttributeTypeDef> combinedResults = new HashMap<String, AttributeTypeDef>();
        UserNotAuthorizedException userNotAuthorizedException = null;
        RepositoryErrorException repositoryErrorException = null;
        Throwable anotherException = null;
        for (OMRSRepositoryConnector cohortConnector : cohortConnectors) {
            if (cohortConnector == null) continue;
            OMRSMetadataCollection metadataCollection = cohortConnector.getMetadataCollection();
            this.validateMetadataCollection(metadataCollection, "findAttributeTypeDefsByCategory");
            try {
                List results = metadataCollection.findAttributeTypeDefsByCategory(userId, category);
                combinedResults = this.addUniqueAttributeTypeDefs(combinedResults, results, cohortConnector.getServerName(), cohortConnector.getMetadataCollectionId(), "findAttributeTypeDefsByCategory");
            }
            catch (RepositoryErrorException error) {
                repositoryErrorException = error;
            }
            catch (UserNotAuthorizedException error) {
                userNotAuthorizedException = error;
            }
            catch (Throwable error) {
                anotherException = error;
            }
        }
        return this.validatedAttributeTypeDefListResults(this.repositoryName, combinedResults, userNotAuthorizedException, repositoryErrorException, anotherException, "findAttributeTypeDefsByCategory");
    }

    public List<TypeDef> findTypeDefsByProperty(String userId, TypeDefProperties matchCriteria) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "findTypeDefsByProperty";
        String matchCriteriaParameterName = "matchCriteria";
        this.validateRepositoryConnector("findTypeDefsByProperty");
        this.parentConnector.validateRepositoryIsActive("findTypeDefsByProperty");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "findTypeDefsByProperty");
        this.repositoryValidator.validateMatchCriteria(this.repositoryName, "matchCriteria", matchCriteria, "findTypeDefsByProperty");
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("findTypeDefsByProperty");
        Map<String, TypeDef> combinedResults = new HashMap<String, TypeDef>();
        UserNotAuthorizedException userNotAuthorizedException = null;
        RepositoryErrorException repositoryErrorException = null;
        Throwable anotherException = null;
        for (OMRSRepositoryConnector cohortConnector : cohortConnectors) {
            if (cohortConnector == null) continue;
            OMRSMetadataCollection metadataCollection = cohortConnector.getMetadataCollection();
            this.validateMetadataCollection(metadataCollection, "findTypeDefsByProperty");
            try {
                List results = metadataCollection.findTypeDefsByProperty(userId, matchCriteria);
                combinedResults = this.addUniqueTypeDefs(combinedResults, results, cohortConnector.getServerName(), cohortConnector.getMetadataCollectionId(), "findTypeDefsByProperty");
            }
            catch (RepositoryErrorException error) {
                repositoryErrorException = error;
            }
            catch (UserNotAuthorizedException error) {
                userNotAuthorizedException = error;
            }
            catch (Throwable error) {
                anotherException = error;
            }
        }
        return this.validatedTypeDefListResults(this.repositoryName, combinedResults, userNotAuthorizedException, repositoryErrorException, anotherException, "findTypeDefsByProperty");
    }

    public List<TypeDef> findTypesByExternalID(String userId, String standard, String organization, String identifier) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "findTypesByExternalID";
        this.validateRepositoryConnector("findTypesByExternalID");
        this.parentConnector.validateRepositoryIsActive("findTypesByExternalID");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "findTypesByExternalID");
        this.repositoryValidator.validateExternalId(this.repositoryName, standard, organization, identifier, "findTypesByExternalID");
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("findTypesByExternalID");
        Map<String, TypeDef> combinedResults = new HashMap<String, TypeDef>();
        UserNotAuthorizedException userNotAuthorizedException = null;
        RepositoryErrorException repositoryErrorException = null;
        Throwable anotherException = null;
        for (OMRSRepositoryConnector cohortConnector : cohortConnectors) {
            if (cohortConnector == null) continue;
            OMRSMetadataCollection metadataCollection = cohortConnector.getMetadataCollection();
            this.validateMetadataCollection(metadataCollection, "findTypesByExternalID");
            try {
                List results = metadataCollection.findTypesByExternalID(userId, standard, organization, identifier);
                combinedResults = this.addUniqueTypeDefs(combinedResults, results, cohortConnector.getServerName(), cohortConnector.getMetadataCollectionId(), "findTypesByExternalID");
            }
            catch (RepositoryErrorException error) {
                repositoryErrorException = error;
            }
            catch (UserNotAuthorizedException error) {
                userNotAuthorizedException = error;
            }
            catch (Throwable error) {
                anotherException = error;
            }
        }
        return this.validatedTypeDefListResults(this.repositoryName, combinedResults, userNotAuthorizedException, repositoryErrorException, anotherException, "findTypesByExternalID");
    }

    public List<TypeDef> searchForTypeDefs(String userId, String searchCriteria) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "searchForTypeDefs";
        String searchCriteriaParameterName = "searchCriteria";
        this.validateRepositoryConnector("searchForTypeDefs");
        this.parentConnector.validateRepositoryIsActive("searchForTypeDefs");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "searchForTypeDefs");
        this.repositoryValidator.validateSearchCriteria(this.repositoryName, "searchCriteria", searchCriteria, "searchForTypeDefs");
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("searchForTypeDefs");
        Map<String, TypeDef> combinedResults = new HashMap<String, TypeDef>();
        UserNotAuthorizedException userNotAuthorizedException = null;
        RepositoryErrorException repositoryErrorException = null;
        Throwable anotherException = null;
        for (OMRSRepositoryConnector cohortConnector : cohortConnectors) {
            if (cohortConnector == null) continue;
            OMRSMetadataCollection metadataCollection = cohortConnector.getMetadataCollection();
            this.validateMetadataCollection(metadataCollection, "searchForTypeDefs");
            try {
                List results = metadataCollection.searchForTypeDefs(userId, searchCriteria);
                combinedResults = this.addUniqueTypeDefs(combinedResults, results, cohortConnector.getServerName(), cohortConnector.getMetadataCollectionId(), "searchForTypeDefs");
            }
            catch (RepositoryErrorException error) {
                repositoryErrorException = error;
            }
            catch (UserNotAuthorizedException error) {
                userNotAuthorizedException = error;
            }
            catch (Throwable error) {
                anotherException = error;
            }
        }
        return this.validatedTypeDefListResults(this.repositoryName, combinedResults, userNotAuthorizedException, repositoryErrorException, anotherException, "searchForTypeDefs");
    }

    public TypeDef getTypeDefByGUID(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException {
        String methodName = "getTypeDefByGUID";
        String guidParameterName = "guid";
        this.validateRepositoryConnector("getTypeDefByGUID");
        this.parentConnector.validateRepositoryIsActive("getTypeDefByGUID");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "getTypeDefByGUID");
        this.repositoryValidator.validateGUID(this.repositoryName, "guid", guid, "getTypeDefByGUID");
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("getTypeDefByGUID");
        TypeDefNotKnownException typeDefNotKnownException = null;
        UserNotAuthorizedException userNotAuthorizedException = null;
        RepositoryErrorException repositoryErrorException = null;
        Throwable anotherException = null;
        for (OMRSRepositoryConnector cohortConnector : cohortConnectors) {
            if (cohortConnector == null) continue;
            OMRSMetadataCollection metadataCollection = cohortConnector.getMetadataCollection();
            this.validateMetadataCollection(metadataCollection, "getTypeDefByGUID");
            try {
                return metadataCollection.getTypeDefByGUID(userId, guid);
            }
            catch (TypeDefNotKnownException error) {
                typeDefNotKnownException = error;
            }
            catch (RepositoryErrorException error) {
                repositoryErrorException = error;
            }
            catch (UserNotAuthorizedException error) {
                userNotAuthorizedException = error;
            }
            catch (Throwable error) {
                anotherException = error;
            }
        }
        this.throwCapturedRepositoryErrorException(repositoryErrorException);
        this.throwCapturedUserNotAuthorizedException(userNotAuthorizedException);
        this.throwCapturedThrowableException(anotherException, "getTypeDefByGUID");
        this.throwCapturedTypeDefNotKnownException(typeDefNotKnownException);
        return null;
    }

    public AttributeTypeDef getAttributeTypeDefByGUID(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException {
        String methodName = "getAttributeTypeDefByGUID";
        String guidParameterName = "guid";
        this.validateRepositoryConnector("getAttributeTypeDefByGUID");
        this.parentConnector.validateRepositoryIsActive("getAttributeTypeDefByGUID");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "getAttributeTypeDefByGUID");
        this.repositoryValidator.validateGUID(this.repositoryName, "guid", guid, "getAttributeTypeDefByGUID");
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("getAttributeTypeDefByGUID");
        TypeDefNotKnownException typeDefNotKnownException = null;
        UserNotAuthorizedException userNotAuthorizedException = null;
        RepositoryErrorException repositoryErrorException = null;
        Throwable anotherException = null;
        for (OMRSRepositoryConnector cohortConnector : cohortConnectors) {
            if (cohortConnector == null) continue;
            OMRSMetadataCollection metadataCollection = cohortConnector.getMetadataCollection();
            this.validateMetadataCollection(metadataCollection, "getAttributeTypeDefByGUID");
            try {
                return metadataCollection.getAttributeTypeDefByGUID(userId, guid);
            }
            catch (TypeDefNotKnownException error) {
                typeDefNotKnownException = error;
            }
            catch (RepositoryErrorException error) {
                repositoryErrorException = error;
            }
            catch (UserNotAuthorizedException error) {
                userNotAuthorizedException = error;
            }
            catch (Throwable error) {
                anotherException = error;
            }
        }
        this.throwCapturedRepositoryErrorException(repositoryErrorException);
        this.throwCapturedUserNotAuthorizedException(userNotAuthorizedException);
        this.throwCapturedThrowableException(anotherException, "getAttributeTypeDefByGUID");
        if (typeDefNotKnownException != null) {
            throw typeDefNotKnownException;
        }
        return null;
    }

    public TypeDef getTypeDefByName(String userId, String name) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException {
        String methodName = "getTypeDefByName";
        String nameParameterName = "name";
        this.validateRepositoryConnector("getTypeDefByName");
        this.parentConnector.validateRepositoryIsActive("getTypeDefByName");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "getTypeDefByName");
        this.repositoryValidator.validateTypeName(this.repositoryName, "name", name, "getTypeDefByName");
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("getTypeDefByName");
        TypeDefNotKnownException typeDefNotKnownException = null;
        UserNotAuthorizedException userNotAuthorizedException = null;
        RepositoryErrorException repositoryErrorException = null;
        Throwable anotherException = null;
        for (OMRSRepositoryConnector cohortConnector : cohortConnectors) {
            if (cohortConnector == null) continue;
            OMRSMetadataCollection metadataCollection = cohortConnector.getMetadataCollection();
            this.validateMetadataCollection(metadataCollection, "getTypeDefByName");
            try {
                return metadataCollection.getTypeDefByName(userId, name);
            }
            catch (TypeDefNotKnownException error) {
                typeDefNotKnownException = error;
            }
            catch (RepositoryErrorException error) {
                repositoryErrorException = error;
            }
            catch (UserNotAuthorizedException error) {
                userNotAuthorizedException = error;
            }
            catch (Throwable error) {
                anotherException = error;
            }
        }
        this.throwCapturedRepositoryErrorException(repositoryErrorException);
        this.throwCapturedUserNotAuthorizedException(userNotAuthorizedException);
        this.throwCapturedThrowableException(anotherException, "getTypeDefByName");
        this.throwCapturedTypeDefNotKnownException(typeDefNotKnownException);
        return null;
    }

    public AttributeTypeDef getAttributeTypeDefByName(String userId, String name) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException {
        String methodName = "getAttributeTypeDefByName";
        String nameParameterName = "name";
        this.validateRepositoryConnector("getAttributeTypeDefByName");
        this.parentConnector.validateRepositoryIsActive("getAttributeTypeDefByName");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "getAttributeTypeDefByName");
        this.repositoryValidator.validateTypeName(this.repositoryName, "name", name, "getAttributeTypeDefByName");
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("getAttributeTypeDefByName");
        TypeDefNotKnownException typeDefNotKnownException = null;
        UserNotAuthorizedException userNotAuthorizedException = null;
        RepositoryErrorException repositoryErrorException = null;
        Throwable anotherException = null;
        for (OMRSRepositoryConnector cohortConnector : cohortConnectors) {
            if (cohortConnector == null) continue;
            OMRSMetadataCollection metadataCollection = cohortConnector.getMetadataCollection();
            this.validateMetadataCollection(metadataCollection, "getAttributeTypeDefByName");
            try {
                return metadataCollection.getAttributeTypeDefByName(userId, name);
            }
            catch (TypeDefNotKnownException error) {
                typeDefNotKnownException = error;
            }
            catch (RepositoryErrorException error) {
                repositoryErrorException = error;
            }
            catch (UserNotAuthorizedException error) {
                userNotAuthorizedException = error;
            }
            catch (Throwable error) {
                anotherException = error;
            }
        }
        this.throwCapturedRepositoryErrorException(repositoryErrorException);
        this.throwCapturedUserNotAuthorizedException(userNotAuthorizedException);
        this.throwCapturedThrowableException(anotherException, "getAttributeTypeDefByName");
        this.throwCapturedTypeDefNotKnownException(typeDefNotKnownException);
        return null;
    }

    public void addTypeDefGallery(String userId, TypeDefGallery newTypes) throws FunctionNotSupportedException {
        String methodName = "addTypeDefGallery";
        this.throwNotEnterpriseFunction("addTypeDefGallery");
    }

    public void addTypeDef(String userId, TypeDef newTypeDef) throws FunctionNotSupportedException {
        String methodName = "addTypeDef";
        this.throwNotEnterpriseFunction("addTypeDef");
    }

    public void addAttributeTypeDef(String userId, AttributeTypeDef newAttributeTypeDef) throws FunctionNotSupportedException {
        String methodName = "addAttributeTypeDef";
        this.throwNotEnterpriseFunction("addAttributeTypeDef");
    }

    public boolean verifyTypeDef(String userId, TypeDef typeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefConflictException, InvalidTypeDefException, UserNotAuthorizedException {
        String methodName = "verifyTypeDef";
        String typeDefParameterName = "typeDef";
        this.validateRepositoryConnector("verifyTypeDef");
        this.parentConnector.validateRepositoryIsActive("verifyTypeDef");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "verifyTypeDef");
        this.repositoryValidator.validateTypeDef(this.repositoryName, "typeDef", typeDef, "verifyTypeDef");
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("verifyTypeDef");
        TypeDefNotSupportedException typeDefNotSupportedException = null;
        UserNotAuthorizedException userNotAuthorizedException = null;
        RepositoryErrorException repositoryErrorException = null;
        Throwable anotherException = null;
        for (OMRSRepositoryConnector cohortConnector : cohortConnectors) {
            if (cohortConnector == null) continue;
            OMRSMetadataCollection metadataCollection = cohortConnector.getMetadataCollection();
            this.validateMetadataCollection(metadataCollection, "verifyTypeDef");
            try {
                return metadataCollection.verifyTypeDef(userId, typeDef);
            }
            catch (TypeDefNotSupportedException error) {
                typeDefNotSupportedException = error;
            }
            catch (RepositoryErrorException error) {
                repositoryErrorException = error;
            }
            catch (UserNotAuthorizedException error) {
                userNotAuthorizedException = error;
            }
            catch (Throwable error) {
                anotherException = error;
            }
        }
        this.throwCapturedRepositoryErrorException(repositoryErrorException);
        this.throwCapturedUserNotAuthorizedException(userNotAuthorizedException);
        this.throwCapturedThrowableException(anotherException, "verifyTypeDef");
        this.throwCapturedTypeDefNotSupportedException(typeDefNotSupportedException);
        return false;
    }

    public boolean verifyAttributeTypeDef(String userId, AttributeTypeDef attributeTypeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefConflictException, InvalidTypeDefException, UserNotAuthorizedException {
        String methodName = "verifyAttributeTypeDef";
        String typeDefParameterName = "attributeTypeDef";
        this.validateRepositoryConnector("verifyAttributeTypeDef");
        this.parentConnector.validateRepositoryIsActive("verifyAttributeTypeDef");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "verifyAttributeTypeDef");
        this.repositoryValidator.validateAttributeTypeDef(this.repositoryName, "attributeTypeDef", attributeTypeDef, "verifyAttributeTypeDef");
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("verifyAttributeTypeDef");
        TypeDefNotSupportedException typeDefNotSupportedException = null;
        UserNotAuthorizedException userNotAuthorizedException = null;
        RepositoryErrorException repositoryErrorException = null;
        Throwable anotherException = null;
        for (OMRSRepositoryConnector cohortConnector : cohortConnectors) {
            if (cohortConnector == null) continue;
            OMRSMetadataCollection metadataCollection = cohortConnector.getMetadataCollection();
            this.validateMetadataCollection(metadataCollection, "verifyAttributeTypeDef");
            try {
                return metadataCollection.verifyAttributeTypeDef(userId, attributeTypeDef);
            }
            catch (TypeDefNotSupportedException error) {
                typeDefNotSupportedException = error;
            }
            catch (RepositoryErrorException error) {
                repositoryErrorException = error;
            }
            catch (UserNotAuthorizedException error) {
                userNotAuthorizedException = error;
            }
            catch (Throwable error) {
                anotherException = error;
            }
        }
        this.throwCapturedRepositoryErrorException(repositoryErrorException);
        this.throwCapturedUserNotAuthorizedException(userNotAuthorizedException);
        this.throwCapturedThrowableException(anotherException, "verifyAttributeTypeDef");
        this.throwCapturedTypeDefNotSupportedException(typeDefNotSupportedException);
        return false;
    }

    public TypeDef updateTypeDef(String userId, TypeDefPatch typeDefPatch) throws FunctionNotSupportedException {
        String methodName = "updateTypeDef";
        this.throwNotEnterpriseFunction("updateTypeDef");
        return null;
    }

    public void deleteTypeDef(String userId, String obsoleteTypeDefGUID, String obsoleteTypeDefName) throws FunctionNotSupportedException {
        String methodName = "deleteTypeDef";
        this.throwNotEnterpriseFunction("deleteTypeDef");
    }

    public void deleteAttributeTypeDef(String userId, String obsoleteTypeDefGUID, String obsoleteTypeDefName) throws FunctionNotSupportedException {
        String methodName = "deleteAttributeTypeDef";
        this.throwNotEnterpriseFunction("deleteAttributeTypeDef");
    }

    public TypeDef reIdentifyTypeDef(String userId, String originalTypeDefGUID, String originalTypeDefName, String newTypeDefGUID, String newTypeDefName) throws FunctionNotSupportedException {
        String methodName = "reIdentifyTypeDef";
        this.throwNotEnterpriseFunction("reIdentifyTypeDef");
        return null;
    }

    public AttributeTypeDef reIdentifyAttributeTypeDef(String userId, String originalAttributeTypeDefGUID, String originalAttributeTypeDefName, String newAttributeTypeDefGUID, String newAttributeTypeDefName) throws FunctionNotSupportedException {
        String methodName = "reIdentifyAttributeTypeDef";
        this.throwNotEnterpriseFunction("reIdentifyAttributeTypeDef");
        return null;
    }

    public EntityDetail isEntityKnown(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "isEntityKnown";
        super.getInstanceParameterValidation(userId, guid, "isEntityKnown");
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("isEntityKnown");
        UserNotAuthorizedException userNotAuthorizedException = null;
        RepositoryErrorException repositoryErrorException = null;
        Throwable anotherException = null;
        for (OMRSRepositoryConnector cohortConnector : cohortConnectors) {
            if (cohortConnector == null) continue;
            OMRSMetadataCollection metadataCollection = cohortConnector.getMetadataCollection();
            this.validateMetadataCollection(metadataCollection, "isEntityKnown");
            try {
                EntityDetail entity = metadataCollection.isEntityKnown(userId, guid);
                if (entity == null) continue;
                return this.enterpriseParentConnector.processRetrievedEntityDetail(cohortConnector.getMetadataCollectionId(), entity);
            }
            catch (RepositoryErrorException error) {
                repositoryErrorException = error;
            }
            catch (UserNotAuthorizedException error) {
                userNotAuthorizedException = error;
            }
            catch (Throwable error) {
                anotherException = error;
            }
        }
        this.throwCapturedRepositoryErrorException(repositoryErrorException);
        this.throwCapturedUserNotAuthorizedException(userNotAuthorizedException);
        this.throwCapturedThrowableException(anotherException, "isEntityKnown");
        return null;
    }

    public EntitySummary getEntitySummary(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, UserNotAuthorizedException {
        String methodName = "getEntitySummary";
        super.getInstanceParameterValidation(userId, guid, "getEntitySummary");
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("getEntitySummary");
        EntityNotKnownException entityNotKnownException = null;
        UserNotAuthorizedException userNotAuthorizedException = null;
        RepositoryErrorException repositoryErrorException = null;
        Throwable anotherException = null;
        for (OMRSRepositoryConnector cohortConnector : cohortConnectors) {
            if (cohortConnector == null) continue;
            OMRSMetadataCollection metadataCollection = cohortConnector.getMetadataCollection();
            this.validateMetadataCollection(metadataCollection, "getEntitySummary");
            try {
                EntitySummary entity = metadataCollection.getEntitySummary(userId, guid);
                this.repositoryValidator.validateEntityFromStore(this.repositoryName, guid, entity, "getEntitySummary");
                return this.enterpriseParentConnector.processRetrievedEntitySummary(cohortConnector.getMetadataCollectionId(), entity);
            }
            catch (EntityNotKnownException error) {
                entityNotKnownException = error;
            }
            catch (RepositoryErrorException error) {
                repositoryErrorException = error;
            }
            catch (UserNotAuthorizedException error) {
                userNotAuthorizedException = error;
            }
            catch (Throwable error) {
                anotherException = error;
            }
        }
        this.throwCapturedRepositoryErrorException(repositoryErrorException);
        this.throwCapturedUserNotAuthorizedException(userNotAuthorizedException);
        this.throwCapturedThrowableException(anotherException, "getEntitySummary");
        this.throwCapturedEntityNotKnownException(entityNotKnownException);
        return null;
    }

    public EntityDetail getEntityDetail(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityProxyOnlyException, UserNotAuthorizedException {
        String methodName = "getEntityDetail";
        super.getInstanceParameterValidation(userId, guid, "getEntityDetail");
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("getEntityDetail");
        EntityNotKnownException entityNotKnownException = null;
        EntityProxyOnlyException entityProxyOnlyException = null;
        UserNotAuthorizedException userNotAuthorizedException = null;
        RepositoryErrorException repositoryErrorException = null;
        Throwable anotherException = null;
        for (OMRSRepositoryConnector cohortConnector : cohortConnectors) {
            if (cohortConnector == null) continue;
            OMRSMetadataCollection metadataCollection = cohortConnector.getMetadataCollection();
            this.validateMetadataCollection(metadataCollection, "getEntityDetail");
            try {
                EntityDetail entity = metadataCollection.getEntityDetail(userId, guid);
                this.repositoryValidator.validateEntityFromStore(this.repositoryName, guid, entity, "getEntityDetail");
                return this.enterpriseParentConnector.processRetrievedEntityDetail(cohortConnector.getMetadataCollectionId(), entity);
            }
            catch (EntityNotKnownException error) {
                entityNotKnownException = error;
            }
            catch (EntityProxyOnlyException error) {
                entityProxyOnlyException = error;
            }
            catch (RepositoryErrorException error) {
                repositoryErrorException = error;
            }
            catch (UserNotAuthorizedException error) {
                userNotAuthorizedException = error;
            }
            catch (Throwable error) {
                anotherException = error;
            }
        }
        this.throwCapturedRepositoryErrorException(repositoryErrorException);
        this.throwCapturedUserNotAuthorizedException(userNotAuthorizedException);
        this.throwCapturedThrowableException(anotherException, "getEntityDetail");
        this.throwCapturedEntityNotKnownException(entityNotKnownException);
        this.throwCapturedEntityProxyOnlyException(entityProxyOnlyException);
        return null;
    }

    public EntityDetail getEntityDetail(String userId, String guid, Date asOfTime) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityProxyOnlyException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getEntityDetail";
        super.getInstanceParameterValidation(userId, guid, asOfTime, "getEntityDetail");
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("getEntityDetail");
        EntityNotKnownException entityNotKnownException = null;
        EntityProxyOnlyException entityProxyOnlyException = null;
        FunctionNotSupportedException functionNotSupportedException = null;
        UserNotAuthorizedException userNotAuthorizedException = null;
        RepositoryErrorException repositoryErrorException = null;
        Throwable anotherException = null;
        for (OMRSRepositoryConnector cohortConnector : cohortConnectors) {
            if (cohortConnector == null) continue;
            OMRSMetadataCollection metadataCollection = cohortConnector.getMetadataCollection();
            this.validateMetadataCollection(metadataCollection, "getEntityDetail");
            try {
                EntityDetail entity = metadataCollection.getEntityDetail(userId, guid, asOfTime);
                this.repositoryValidator.validateEntityFromStore(this.repositoryName, guid, entity, "getEntityDetail");
                return this.enterpriseParentConnector.processRetrievedEntityDetail(cohortConnector.getMetadataCollectionId(), entity);
            }
            catch (EntityNotKnownException error) {
                entityNotKnownException = error;
            }
            catch (EntityProxyOnlyException error) {
                entityProxyOnlyException = error;
            }
            catch (RepositoryErrorException error) {
                repositoryErrorException = error;
            }
            catch (UserNotAuthorizedException error) {
                userNotAuthorizedException = error;
            }
            catch (FunctionNotSupportedException error) {
                functionNotSupportedException = error;
            }
            catch (Throwable error) {
                anotherException = error;
            }
        }
        this.throwCapturedRepositoryErrorException(repositoryErrorException);
        this.throwCapturedUserNotAuthorizedException(userNotAuthorizedException);
        this.throwCapturedThrowableException(anotherException, "getEntityDetail");
        this.throwCapturedEntityNotKnownException(entityNotKnownException);
        this.throwCapturedEntityProxyOnlyException(entityProxyOnlyException);
        this.throwCapturedFunctionNotSupportedException(functionNotSupportedException);
        return null;
    }

    public List<Relationship> getRelationshipsForEntity(String userId, String entityGUID, String relationshipTypeGUID, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getRelationshipsForEntity";
        super.getRelationshipsForEntityParameterValidation(userId, entityGUID, relationshipTypeGUID, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("getRelationshipsForEntity");
        Map<String, Relationship> combinedResults = new HashMap<String, Relationship>();
        InvalidParameterException invalidParameterException = null;
        EntityNotKnownException entityNotKnownException = null;
        FunctionNotSupportedException functionNotSupportedException = null;
        PropertyErrorException propertyErrorException = null;
        UserNotAuthorizedException userNotAuthorizedException = null;
        RepositoryErrorException repositoryErrorException = null;
        Throwable anotherException = null;
        for (OMRSRepositoryConnector cohortConnector : cohortConnectors) {
            if (cohortConnector == null) continue;
            OMRSMetadataCollection metadataCollection = cohortConnector.getMetadataCollection();
            this.validateMetadataCollection(metadataCollection, "getRelationshipsForEntity");
            try {
                List results = metadataCollection.getRelationshipsForEntity(userId, entityGUID, relationshipTypeGUID, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
                combinedResults = this.addUniqueRelationships(combinedResults, results, cohortConnector.getServerName(), cohortConnector.getMetadataCollectionId(), "getRelationshipsForEntity");
            }
            catch (InvalidParameterException error) {
                invalidParameterException = error;
            }
            catch (EntityNotKnownException error) {
                entityNotKnownException = error;
            }
            catch (FunctionNotSupportedException error) {
                functionNotSupportedException = error;
            }
            catch (PropertyErrorException error) {
                propertyErrorException = error;
            }
            catch (RepositoryErrorException error) {
                repositoryErrorException = error;
            }
            catch (UserNotAuthorizedException error) {
                userNotAuthorizedException = error;
            }
            catch (Throwable error) {
                anotherException = error;
            }
        }
        if (combinedResults.isEmpty()) {
            this.throwCapturedRepositoryErrorException(repositoryErrorException);
            this.throwCapturedUserNotAuthorizedException(userNotAuthorizedException);
            this.throwCapturedThrowableException(anotherException, "getRelationshipsForEntity");
            this.throwCapturedPropertyErrorException(propertyErrorException);
            this.throwCapturedInvalidParameterException(invalidParameterException);
            this.throwCapturedFunctionNotSupportedException(functionNotSupportedException);
            this.throwCapturedEntityNotKnownException(entityNotKnownException);
            return null;
        }
        return this.validatedRelationshipResults(this.repositoryName, combinedResults, sequencingProperty, sequencingOrder, pageSize, "getRelationshipsForEntity");
    }

    public List<EntityDetail> findEntitiesByProperty(String userId, String entityTypeGUID, InstanceProperties matchProperties, MatchCriteria matchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "findEntitiesByProperty";
        super.findEntitiesByPropertyParameterValidation(userId, entityTypeGUID, matchProperties, matchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("findEntitiesByProperty");
        Map<String, EntityDetail> combinedResults = new HashMap<String, EntityDetail>();
        InvalidParameterException invalidParameterException = null;
        FunctionNotSupportedException functionNotSupportedException = null;
        TypeErrorException typeErrorException = null;
        PropertyErrorException propertyErrorException = null;
        UserNotAuthorizedException userNotAuthorizedException = null;
        RepositoryErrorException repositoryErrorException = null;
        Throwable anotherException = null;
        for (OMRSRepositoryConnector cohortConnector : cohortConnectors) {
            if (cohortConnector == null) continue;
            OMRSMetadataCollection metadataCollection = cohortConnector.getMetadataCollection();
            this.validateMetadataCollection(metadataCollection, "findEntitiesByProperty");
            try {
                List results = metadataCollection.findEntitiesByProperty(userId, entityTypeGUID, matchProperties, matchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
                combinedResults = this.addUniqueEntities(combinedResults, results, cohortConnector.getServerName(), cohortConnector.getMetadataCollectionId(), "findEntitiesByProperty");
            }
            catch (InvalidParameterException error) {
                invalidParameterException = error;
            }
            catch (FunctionNotSupportedException error) {
                functionNotSupportedException = error;
            }
            catch (TypeErrorException error) {
                typeErrorException = error;
            }
            catch (PropertyErrorException error) {
                propertyErrorException = error;
            }
            catch (RepositoryErrorException error) {
                repositoryErrorException = error;
            }
            catch (UserNotAuthorizedException error) {
                userNotAuthorizedException = error;
            }
            catch (Throwable error) {
                anotherException = error;
            }
        }
        if (combinedResults.isEmpty()) {
            this.throwCapturedRepositoryErrorException(repositoryErrorException);
            this.throwCapturedUserNotAuthorizedException(userNotAuthorizedException);
            this.throwCapturedThrowableException(anotherException, "findEntitiesByProperty");
            this.throwCapturedTypeErrorException(typeErrorException);
            this.throwCapturedPropertyErrorException(propertyErrorException);
            this.throwCapturedInvalidParameterException(invalidParameterException);
            this.throwCapturedFunctionNotSupportedException(functionNotSupportedException);
            return null;
        }
        return this.validatedEntityListResults(this.repositoryName, combinedResults, sequencingProperty, sequencingOrder, pageSize, "findEntitiesByProperty");
    }

    public List<EntityDetail> findEntitiesByClassification(String userId, String entityTypeGUID, String classificationName, InstanceProperties matchClassificationProperties, MatchCriteria matchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, ClassificationErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "findEntitiesByClassification";
        super.findEntitiesByClassificationParameterValidation(userId, entityTypeGUID, classificationName, matchClassificationProperties, matchCriteria, fromEntityElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("findEntitiesByClassification");
        Map<String, EntityDetail> combinedResults = new HashMap<String, EntityDetail>();
        InvalidParameterException invalidParameterException = null;
        FunctionNotSupportedException functionNotSupportedException = null;
        TypeErrorException typeErrorException = null;
        PropertyErrorException propertyErrorException = null;
        UserNotAuthorizedException userNotAuthorizedException = null;
        RepositoryErrorException repositoryErrorException = null;
        Throwable anotherException = null;
        for (OMRSRepositoryConnector cohortConnector : cohortConnectors) {
            if (cohortConnector == null) continue;
            OMRSMetadataCollection metadataCollection = cohortConnector.getMetadataCollection();
            this.validateMetadataCollection(metadataCollection, "findEntitiesByClassification");
            try {
                List results = metadataCollection.findEntitiesByClassification(userId, entityTypeGUID, classificationName, matchClassificationProperties, matchCriteria, fromEntityElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
                combinedResults = this.addUniqueEntities(combinedResults, results, cohortConnector.getServerName(), cohortConnector.getMetadataCollectionId(), "findEntitiesByClassification");
            }
            catch (InvalidParameterException error) {
                invalidParameterException = error;
            }
            catch (FunctionNotSupportedException error) {
                functionNotSupportedException = error;
            }
            catch (TypeErrorException error) {
                typeErrorException = error;
            }
            catch (PropertyErrorException error) {
                propertyErrorException = error;
            }
            catch (RepositoryErrorException error) {
                repositoryErrorException = error;
            }
            catch (UserNotAuthorizedException error) {
                userNotAuthorizedException = error;
            }
            catch (Throwable error) {
                anotherException = error;
            }
        }
        if (combinedResults.isEmpty()) {
            this.throwCapturedRepositoryErrorException(repositoryErrorException);
            this.throwCapturedUserNotAuthorizedException(userNotAuthorizedException);
            this.throwCapturedThrowableException(anotherException, "findEntitiesByClassification");
            this.throwCapturedTypeErrorException(typeErrorException);
            this.throwCapturedPropertyErrorException(propertyErrorException);
            this.throwCapturedInvalidParameterException(invalidParameterException);
            this.throwCapturedFunctionNotSupportedException(functionNotSupportedException);
            return null;
        }
        return this.validatedEntityListResults(this.repositoryName, combinedResults, sequencingProperty, sequencingOrder, pageSize, "findEntitiesByClassification");
    }

    public List<EntityDetail> findEntitiesByPropertyValue(String userId, String entityTypeGUID, String searchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "findEntitiesByPropertyValue";
        super.findEntitiesByPropertyValueParameterValidation(userId, entityTypeGUID, searchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("findEntitiesByPropertyValue");
        Map<String, EntityDetail> combinedResults = new HashMap<String, EntityDetail>();
        InvalidParameterException invalidParameterException = null;
        FunctionNotSupportedException functionNotSupportedException = null;
        TypeErrorException typeErrorException = null;
        PropertyErrorException propertyErrorException = null;
        UserNotAuthorizedException userNotAuthorizedException = null;
        RepositoryErrorException repositoryErrorException = null;
        Throwable anotherException = null;
        for (OMRSRepositoryConnector cohortConnector : cohortConnectors) {
            if (cohortConnector == null) continue;
            OMRSMetadataCollection metadataCollection = cohortConnector.getMetadataCollection();
            this.validateMetadataCollection(metadataCollection, "findEntitiesByPropertyValue");
            try {
                List results = metadataCollection.findEntitiesByPropertyValue(userId, entityTypeGUID, searchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
                combinedResults = this.addUniqueEntities(combinedResults, results, cohortConnector.getServerName(), cohortConnector.getMetadataCollectionId(), "findEntitiesByPropertyValue");
            }
            catch (InvalidParameterException error) {
                invalidParameterException = error;
            }
            catch (FunctionNotSupportedException error) {
                functionNotSupportedException = error;
            }
            catch (TypeErrorException error) {
                typeErrorException = error;
            }
            catch (PropertyErrorException error) {
                propertyErrorException = error;
            }
            catch (RepositoryErrorException error) {
                repositoryErrorException = error;
            }
            catch (UserNotAuthorizedException error) {
                userNotAuthorizedException = error;
            }
            catch (Throwable error) {
                anotherException = error;
            }
        }
        if (combinedResults.isEmpty()) {
            this.throwCapturedRepositoryErrorException(repositoryErrorException);
            this.throwCapturedUserNotAuthorizedException(userNotAuthorizedException);
            this.throwCapturedThrowableException(anotherException, "findEntitiesByPropertyValue");
            this.throwCapturedTypeErrorException(typeErrorException);
            this.throwCapturedPropertyErrorException(propertyErrorException);
            this.throwCapturedInvalidParameterException(invalidParameterException);
            this.throwCapturedFunctionNotSupportedException(functionNotSupportedException);
            return null;
        }
        return this.validatedEntityListResults(this.repositoryName, combinedResults, sequencingProperty, sequencingOrder, pageSize, "findEntitiesByPropertyValue");
    }

    public Relationship isRelationshipKnown(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "isRelationshipKnown";
        super.getInstanceParameterValidation(userId, guid, "isRelationshipKnown");
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("isRelationshipKnown");
        UserNotAuthorizedException userNotAuthorizedException = null;
        RepositoryErrorException repositoryErrorException = null;
        Throwable anotherException = null;
        for (OMRSRepositoryConnector cohortConnector : cohortConnectors) {
            if (cohortConnector == null) continue;
            OMRSMetadataCollection metadataCollection = cohortConnector.getMetadataCollection();
            this.validateMetadataCollection(metadataCollection, "isRelationshipKnown");
            try {
                Relationship relationship = metadataCollection.isRelationshipKnown(userId, guid);
                this.repositoryValidator.validateRelationshipFromStore(this.repositoryName, guid, relationship, "isRelationshipKnown");
                if (relationship == null) continue;
                return this.enterpriseParentConnector.processRetrievedRelationship(cohortConnector.getMetadataCollectionId(), relationship);
            }
            catch (RepositoryErrorException error) {
                repositoryErrorException = error;
            }
            catch (UserNotAuthorizedException error) {
                userNotAuthorizedException = error;
            }
            catch (Throwable error) {
                anotherException = error;
            }
        }
        this.throwCapturedRepositoryErrorException(repositoryErrorException);
        this.throwCapturedUserNotAuthorizedException(userNotAuthorizedException);
        this.throwCapturedThrowableException(anotherException, "isRelationshipKnown");
        return null;
    }

    public Relationship getRelationship(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, UserNotAuthorizedException {
        String methodName = "getRelationship";
        super.getInstanceParameterValidation(userId, guid, "getRelationship");
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("getRelationship");
        RelationshipNotKnownException relationshipNotKnownException = null;
        UserNotAuthorizedException userNotAuthorizedException = null;
        RepositoryErrorException repositoryErrorException = null;
        Throwable anotherException = null;
        for (OMRSRepositoryConnector cohortConnector : cohortConnectors) {
            if (cohortConnector == null) continue;
            OMRSMetadataCollection metadataCollection = cohortConnector.getMetadataCollection();
            this.validateMetadataCollection(metadataCollection, "getRelationship");
            try {
                Relationship relationship = metadataCollection.getRelationship(userId, guid);
                this.repositoryValidator.validateRelationshipFromStore(this.repositoryName, guid, relationship, "getRelationship");
                return relationship;
            }
            catch (RelationshipNotKnownException error) {
                relationshipNotKnownException = error;
            }
            catch (RepositoryErrorException error) {
                repositoryErrorException = error;
            }
            catch (UserNotAuthorizedException error) {
                userNotAuthorizedException = error;
            }
            catch (Throwable error) {
                anotherException = error;
            }
        }
        this.throwCapturedRepositoryErrorException(repositoryErrorException);
        this.throwCapturedUserNotAuthorizedException(userNotAuthorizedException);
        this.throwCapturedThrowableException(anotherException, "getRelationship");
        this.throwCapturedRelationshipNotKnownException(relationshipNotKnownException);
        return null;
    }

    public Relationship getRelationship(String userId, String guid, Date asOfTime) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getRelationship";
        super.getInstanceParameterValidation(userId, guid, asOfTime, "getRelationship");
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("getRelationship");
        RelationshipNotKnownException relationshipNotKnownException = null;
        FunctionNotSupportedException functionNotSupportedException = null;
        UserNotAuthorizedException userNotAuthorizedException = null;
        RepositoryErrorException repositoryErrorException = null;
        Throwable anotherException = null;
        for (OMRSRepositoryConnector cohortConnector : cohortConnectors) {
            if (cohortConnector == null) continue;
            OMRSMetadataCollection metadataCollection = cohortConnector.getMetadataCollection();
            this.validateMetadataCollection(metadataCollection, "getRelationship");
            try {
                Relationship relationship = metadataCollection.getRelationship(userId, guid, asOfTime);
                this.repositoryValidator.validateRelationshipFromStore(this.repositoryName, guid, relationship, "getRelationship");
                return this.enterpriseParentConnector.processRetrievedRelationship(cohortConnector.getMetadataCollectionId(), relationship);
            }
            catch (RelationshipNotKnownException error) {
                relationshipNotKnownException = error;
            }
            catch (RepositoryErrorException error) {
                repositoryErrorException = error;
            }
            catch (UserNotAuthorizedException error) {
                userNotAuthorizedException = error;
            }
            catch (FunctionNotSupportedException error) {
                functionNotSupportedException = error;
            }
            catch (Throwable error) {
                anotherException = error;
            }
        }
        this.throwCapturedRepositoryErrorException(repositoryErrorException);
        this.throwCapturedUserNotAuthorizedException(userNotAuthorizedException);
        this.throwCapturedThrowableException(anotherException, "getRelationship");
        this.throwCapturedRelationshipNotKnownException(relationshipNotKnownException);
        this.throwCapturedFunctionNotSupportedException(functionNotSupportedException);
        return null;
    }

    public List<Relationship> findRelationshipsByProperty(String userId, String relationshipTypeGUID, InstanceProperties matchProperties, MatchCriteria matchCriteria, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "findRelationshipsByProperty";
        super.findRelationshipsByPropertyParameterValidation(userId, relationshipTypeGUID, matchProperties, matchCriteria, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("findRelationshipsByProperty");
        Map<String, Relationship> combinedResults = new HashMap<String, Relationship>();
        InvalidParameterException invalidParameterException = null;
        FunctionNotSupportedException functionNotSupportedException = null;
        PropertyErrorException propertyErrorException = null;
        TypeErrorException typeErrorException = null;
        UserNotAuthorizedException userNotAuthorizedException = null;
        RepositoryErrorException repositoryErrorException = null;
        Throwable anotherException = null;
        for (OMRSRepositoryConnector cohortConnector : cohortConnectors) {
            if (cohortConnector == null) continue;
            OMRSMetadataCollection metadataCollection = cohortConnector.getMetadataCollection();
            this.validateMetadataCollection(metadataCollection, "findRelationshipsByProperty");
            try {
                List results = metadataCollection.findRelationshipsByProperty(userId, relationshipTypeGUID, matchProperties, matchCriteria, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
                combinedResults = this.addUniqueRelationships(combinedResults, results, cohortConnector.getServerName(), cohortConnector.getMetadataCollectionId(), "findRelationshipsByProperty");
            }
            catch (InvalidParameterException error) {
                invalidParameterException = error;
            }
            catch (FunctionNotSupportedException error) {
                functionNotSupportedException = error;
            }
            catch (PropertyErrorException error) {
                propertyErrorException = error;
            }
            catch (TypeErrorException error) {
                typeErrorException = error;
            }
            catch (RepositoryErrorException error) {
                repositoryErrorException = error;
            }
            catch (UserNotAuthorizedException error) {
                userNotAuthorizedException = error;
            }
            catch (Throwable error) {
                anotherException = error;
            }
        }
        if (combinedResults.isEmpty()) {
            this.throwCapturedRepositoryErrorException(repositoryErrorException);
            this.throwCapturedUserNotAuthorizedException(userNotAuthorizedException);
            this.throwCapturedThrowableException(anotherException, "findRelationshipsByProperty");
            this.throwCapturedPropertyErrorException(propertyErrorException);
            this.throwCapturedInvalidParameterException(invalidParameterException);
            this.throwCapturedFunctionNotSupportedException(functionNotSupportedException);
            this.throwCapturedTypeErrorException(typeErrorException);
            return null;
        }
        return this.validatedRelationshipResults(this.repositoryName, combinedResults, sequencingProperty, sequencingOrder, pageSize, "findRelationshipsByProperty");
    }

    public List<Relationship> findRelationshipsByPropertyValue(String userId, String relationshipTypeGUID, String searchCriteria, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "findRelationshipsByPropertyValue";
        this.findRelationshipsByPropertyValueParameterValidation(userId, relationshipTypeGUID, searchCriteria, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("findRelationshipsByPropertyValue");
        Map<String, Relationship> combinedResults = new HashMap<String, Relationship>();
        InvalidParameterException invalidParameterException = null;
        FunctionNotSupportedException functionNotSupportedException = null;
        PropertyErrorException propertyErrorException = null;
        TypeErrorException typeErrorException = null;
        UserNotAuthorizedException userNotAuthorizedException = null;
        RepositoryErrorException repositoryErrorException = null;
        Throwable anotherException = null;
        for (OMRSRepositoryConnector cohortConnector : cohortConnectors) {
            if (cohortConnector == null) continue;
            OMRSMetadataCollection metadataCollection = cohortConnector.getMetadataCollection();
            this.validateMetadataCollection(metadataCollection, "findRelationshipsByPropertyValue");
            try {
                List results = metadataCollection.findRelationshipsByPropertyValue(userId, relationshipTypeGUID, searchCriteria, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
                combinedResults = this.addUniqueRelationships(combinedResults, results, cohortConnector.getServerName(), cohortConnector.getMetadataCollectionId(), "findRelationshipsByPropertyValue");
            }
            catch (InvalidParameterException error) {
                invalidParameterException = error;
            }
            catch (FunctionNotSupportedException error) {
                functionNotSupportedException = error;
            }
            catch (PropertyErrorException error) {
                propertyErrorException = error;
            }
            catch (TypeErrorException error) {
                typeErrorException = error;
            }
            catch (RepositoryErrorException error) {
                repositoryErrorException = error;
            }
            catch (UserNotAuthorizedException error) {
                userNotAuthorizedException = error;
            }
            catch (Throwable error) {
                anotherException = error;
            }
        }
        if (combinedResults.isEmpty()) {
            this.throwCapturedRepositoryErrorException(repositoryErrorException);
            this.throwCapturedUserNotAuthorizedException(userNotAuthorizedException);
            this.throwCapturedThrowableException(anotherException, "findRelationshipsByPropertyValue");
            this.throwCapturedTypeErrorException(typeErrorException);
            this.throwCapturedPropertyErrorException(propertyErrorException);
            this.throwCapturedInvalidParameterException(invalidParameterException);
            this.throwCapturedFunctionNotSupportedException(functionNotSupportedException);
            return null;
        }
        return this.validatedRelationshipResults(this.repositoryName, combinedResults, sequencingProperty, sequencingOrder, pageSize, "findRelationshipsByPropertyValue");
    }

    public InstanceGraph getLinkingEntities(String userId, String startEntityGUID, String endEntityGUID, List<InstanceStatus> limitResultsByStatus, Date asOfTime) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getLinkingEntities";
        super.getLinkingEntitiesParameterValidation(userId, startEntityGUID, endEntityGUID, limitResultsByStatus, asOfTime);
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("getLinkingEntities");
        Map<String, EntityDetail> combinedEntityResults = new HashMap<String, EntityDetail>();
        Map<String, Relationship> combinedRelationshipResults = new HashMap<String, Relationship>();
        EntityNotKnownException entityNotKnownException = null;
        FunctionNotSupportedException functionNotSupportedException = null;
        PropertyErrorException propertyErrorException = null;
        UserNotAuthorizedException userNotAuthorizedException = null;
        RepositoryErrorException repositoryErrorException = null;
        Throwable anotherException = null;
        for (OMRSRepositoryConnector cohortConnector : cohortConnectors) {
            if (cohortConnector == null) continue;
            OMRSMetadataCollection metadataCollection = cohortConnector.getMetadataCollection();
            this.validateMetadataCollection(metadataCollection, "getLinkingEntities");
            try {
                InstanceGraph results = metadataCollection.getLinkingEntities(userId, startEntityGUID, endEntityGUID, limitResultsByStatus, asOfTime);
                if (results == null) continue;
                combinedRelationshipResults = this.addUniqueRelationships(combinedRelationshipResults, results.getRelationships(), cohortConnector.getServerName(), cohortConnector.getMetadataCollectionId(), "getLinkingEntities");
                combinedEntityResults = this.addUniqueEntities(combinedEntityResults, results.getEntities(), cohortConnector.getServerName(), cohortConnector.getMetadataCollectionId(), "getLinkingEntities");
            }
            catch (RepositoryErrorException error) {
                repositoryErrorException = error;
            }
            catch (PropertyErrorException error) {
                propertyErrorException = error;
            }
            catch (EntityNotKnownException error) {
                entityNotKnownException = error;
            }
            catch (FunctionNotSupportedException error) {
                functionNotSupportedException = error;
            }
            catch (UserNotAuthorizedException error) {
                userNotAuthorizedException = error;
            }
            catch (Throwable error) {
                anotherException = error;
            }
        }
        return this.validatedInstanceGraphResults(this.repositoryName, combinedEntityResults, combinedRelationshipResults, userNotAuthorizedException, propertyErrorException, functionNotSupportedException, entityNotKnownException, repositoryErrorException, anotherException, "getLinkingEntities");
    }

    public InstanceGraph getEntityNeighborhood(String userId, String entityGUID, List<String> entityTypeGUIDs, List<String> relationshipTypeGUIDs, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, int level) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getEntityNeighborhood";
        super.getEntityNeighborhoodParameterValidation(userId, entityGUID, entityTypeGUIDs, relationshipTypeGUIDs, limitResultsByStatus, limitResultsByClassification, asOfTime, level);
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("getEntityNeighborhood");
        Map<String, EntityDetail> combinedEntityResults = new HashMap<String, EntityDetail>();
        Map<String, Relationship> combinedRelationshipResults = new HashMap<String, Relationship>();
        EntityNotKnownException entityNotKnownException = null;
        FunctionNotSupportedException functionNotSupportedException = null;
        PropertyErrorException propertyErrorException = null;
        UserNotAuthorizedException userNotAuthorizedException = null;
        RepositoryErrorException repositoryErrorException = null;
        Throwable anotherException = null;
        for (OMRSRepositoryConnector cohortConnector : cohortConnectors) {
            if (cohortConnector == null) continue;
            OMRSMetadataCollection metadataCollection = cohortConnector.getMetadataCollection();
            this.validateMetadataCollection(metadataCollection, "getEntityNeighborhood");
            try {
                InstanceGraph results = metadataCollection.getEntityNeighborhood(userId, entityGUID, entityTypeGUIDs, relationshipTypeGUIDs, limitResultsByStatus, limitResultsByClassification, asOfTime, level);
                if (results == null) continue;
                combinedRelationshipResults = this.addUniqueRelationships(combinedRelationshipResults, results.getRelationships(), cohortConnector.getServerName(), cohortConnector.getMetadataCollectionId(), "getEntityNeighborhood");
                combinedEntityResults = this.addUniqueEntities(combinedEntityResults, results.getEntities(), cohortConnector.getServerName(), cohortConnector.getMetadataCollectionId(), "getEntityNeighborhood");
            }
            catch (RepositoryErrorException error) {
                repositoryErrorException = error;
            }
            catch (PropertyErrorException error) {
                propertyErrorException = error;
            }
            catch (EntityNotKnownException error) {
                entityNotKnownException = error;
            }
            catch (FunctionNotSupportedException error) {
                functionNotSupportedException = error;
            }
            catch (UserNotAuthorizedException error) {
                userNotAuthorizedException = error;
            }
            catch (Throwable error) {
                anotherException = error;
            }
        }
        return this.validatedInstanceGraphResults(this.repositoryName, combinedEntityResults, combinedRelationshipResults, userNotAuthorizedException, propertyErrorException, functionNotSupportedException, entityNotKnownException, repositoryErrorException, anotherException, "getEntityNeighborhood");
    }

    public List<EntityDetail> getRelatedEntities(String userId, String startEntityGUID, List<String> entityTypeGUIDs, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getRelatedEntities";
        String entityGUIDParameterName = "startEntityGUID";
        String typeGUIDParameterName = "instanceTypes";
        String asOfTimeParameter = "asOfTime";
        String pageSizeParameter = "pageSize";
        this.validateRepositoryConnector("getRelatedEntities");
        this.parentConnector.validateRepositoryIsActive("getRelatedEntities");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "getRelatedEntities");
        this.repositoryValidator.validateGUID(this.repositoryName, "startEntityGUID", startEntityGUID, "getRelatedEntities");
        this.repositoryValidator.validateAsOfTime(this.repositoryName, "asOfTime", asOfTime, "getRelatedEntities");
        this.repositoryValidator.validatePageSize(this.repositoryName, "pageSize", pageSize, "getRelatedEntities");
        if (entityTypeGUIDs != null) {
            for (String guid : entityTypeGUIDs) {
                this.repositoryValidator.validateTypeGUID(this.repositoryName, "instanceTypes", guid, "getRelatedEntities");
            }
        }
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("getRelatedEntities");
        Map<String, EntityDetail> combinedResults = new HashMap<String, EntityDetail>();
        InvalidParameterException invalidParameterException = null;
        EntityNotKnownException entityNotKnownException = null;
        FunctionNotSupportedException functionNotSupportedException = null;
        TypeErrorException typeErrorException = null;
        PropertyErrorException propertyErrorException = null;
        UserNotAuthorizedException userNotAuthorizedException = null;
        RepositoryErrorException repositoryErrorException = null;
        Throwable anotherException = null;
        for (OMRSRepositoryConnector cohortConnector : cohortConnectors) {
            if (cohortConnector == null) continue;
            OMRSMetadataCollection metadataCollection = cohortConnector.getMetadataCollection();
            this.validateMetadataCollection(metadataCollection, "getRelatedEntities");
            try {
                List results = metadataCollection.getRelatedEntities(userId, startEntityGUID, entityTypeGUIDs, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
                combinedResults = this.addUniqueEntities(combinedResults, results, cohortConnector.getServerName(), cohortConnector.getMetadataCollectionId(), "getRelatedEntities");
            }
            catch (InvalidParameterException error) {
                invalidParameterException = error;
            }
            catch (EntityNotKnownException error) {
                entityNotKnownException = error;
            }
            catch (FunctionNotSupportedException error) {
                functionNotSupportedException = error;
            }
            catch (TypeErrorException error) {
                typeErrorException = error;
            }
            catch (PropertyErrorException error) {
                propertyErrorException = error;
            }
            catch (RepositoryErrorException error) {
                repositoryErrorException = error;
            }
            catch (UserNotAuthorizedException error) {
                userNotAuthorizedException = error;
            }
            catch (Throwable error) {
                anotherException = error;
            }
        }
        if (combinedResults.isEmpty()) {
            this.throwCapturedRepositoryErrorException(repositoryErrorException);
            this.throwCapturedUserNotAuthorizedException(userNotAuthorizedException);
            this.throwCapturedThrowableException(anotherException, "getRelatedEntities");
            this.throwCapturedTypeErrorException(typeErrorException);
            this.throwCapturedPropertyErrorException(propertyErrorException);
            this.throwCapturedInvalidParameterException(invalidParameterException);
            this.throwCapturedFunctionNotSupportedException(functionNotSupportedException);
            this.throwCapturedEntityNotKnownException(entityNotKnownException);
            return null;
        }
        return this.validatedEntityListResults(this.repositoryName, combinedResults, sequencingProperty, sequencingOrder, pageSize, "getRelatedEntities");
    }

    public EntityDetail addEntity(String userId, String entityTypeGUID, InstanceProperties initialProperties, List<Classification> initialClassifications, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, ClassificationErrorException, StatusNotSupportedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "addEntity";
        super.addEntityParameterValidation(userId, entityTypeGUID, initialProperties, initialClassifications, initialStatus);
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("addEntity");
        InvalidParameterException invalidParameterException = null;
        TypeErrorException typeErrorException = null;
        PropertyErrorException propertyErrorException = null;
        ClassificationErrorException classificationErrorException = null;
        StatusNotSupportedException statusNotSupportedException = null;
        UserNotAuthorizedException userNotAuthorizedException = null;
        RepositoryErrorException repositoryErrorException = null;
        FunctionNotSupportedException functionNotSupportedException = null;
        Throwable anotherException = null;
        for (OMRSRepositoryConnector cohortConnector : cohortConnectors) {
            if (cohortConnector == null) continue;
            OMRSMetadataCollection metadataCollection = cohortConnector.getMetadataCollection();
            this.validateMetadataCollection(metadataCollection, "addEntity");
            try {
                return metadataCollection.addEntity(userId, entityTypeGUID, initialProperties, initialClassifications, initialStatus);
            }
            catch (InvalidParameterException error) {
                invalidParameterException = error;
            }
            catch (ClassificationErrorException error) {
                classificationErrorException = error;
            }
            catch (TypeErrorException error) {
                typeErrorException = error;
            }
            catch (StatusNotSupportedException error) {
                statusNotSupportedException = error;
            }
            catch (PropertyErrorException error) {
                propertyErrorException = error;
            }
            catch (RepositoryErrorException error) {
                repositoryErrorException = error;
            }
            catch (UserNotAuthorizedException error) {
                userNotAuthorizedException = error;
            }
            catch (Throwable error) {
                anotherException = error;
            }
        }
        this.throwCapturedRepositoryErrorException(repositoryErrorException);
        this.throwCapturedUserNotAuthorizedException(userNotAuthorizedException);
        this.throwCapturedThrowableException(anotherException, "addEntity");
        this.throwCapturedTypeErrorException(typeErrorException);
        this.throwCapturedClassificationErrorException(classificationErrorException);
        this.throwCapturedPropertyErrorException(propertyErrorException);
        this.throwCapturedStatusNotSupportedException(statusNotSupportedException);
        this.throwCapturedInvalidParameterException(invalidParameterException);
        this.throwCapturedFunctionNotSupportedException(functionNotSupportedException);
        return null;
    }

    public void addEntityProxy(String userId, EntityProxy entityProxy) throws FunctionNotSupportedException {
        String methodName = "addEntityProxy";
        this.throwNotEnterpriseFunction("addEntityProxy");
    }

    public EntityDetail updateEntityStatus(String userId, String entityGUID, InstanceStatus newStatus) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, StatusNotSupportedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "updateEntityStatus";
        super.updateInstanceStatusParameterValidation(userId, entityGUID, newStatus, "updateEntityStatus");
        EntitySummary entity = this.getEntitySummary(userId, entityGUID);
        this.repositoryValidator.validateEntityFromStore(this.repositoryName, entityGUID, entity, "updateEntityStatus");
        OMRSRepositoryConnector homeRepositoryConnector = this.enterpriseParentConnector.getHomeConnector((InstanceHeader)entity, "updateEntityStatus");
        if (homeRepositoryConnector == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NO_HOME_FOR_INSTANCE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"updateEntityStatus", entityGUID, entity.getMetadataCollectionId()});
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "updateEntityStatus", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return homeRepositoryConnector.getMetadataCollection().updateEntityStatus(userId, entityGUID, newStatus);
    }

    public EntityDetail updateEntityProperties(String userId, String entityGUID, InstanceProperties properties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "updateEntityProperties";
        this.updateInstancePropertiesPropertyValidation(userId, entityGUID, properties, "updateEntityProperties");
        EntitySummary entity = this.getEntitySummary(userId, entityGUID);
        this.repositoryValidator.validateEntityFromStore(this.repositoryName, entityGUID, entity, "updateEntityProperties");
        OMRSRepositoryConnector homeRepositoryConnector = this.enterpriseParentConnector.getHomeConnector((InstanceHeader)entity, "updateEntityProperties");
        if (homeRepositoryConnector == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NO_HOME_FOR_INSTANCE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"updateEntityProperties", entityGUID, entity.getMetadataCollectionId()});
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "updateEntityProperties", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return homeRepositoryConnector.getMetadataCollection().updateEntityProperties(userId, entityGUID, properties);
    }

    public EntityDetail undoEntityUpdate(String userId, String entityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "undoEntityUpdate";
        super.manageInstanceParameterValidation(userId, entityGUID, "undoEntityUpdate");
        EntitySummary entity = this.getEntitySummary(userId, entityGUID);
        this.repositoryValidator.validateEntityFromStore(this.repositoryName, entityGUID, entity, "undoEntityUpdate");
        OMRSRepositoryConnector homeRepositoryConnector = this.enterpriseParentConnector.getHomeConnector((InstanceHeader)entity, "undoEntityUpdate");
        if (homeRepositoryConnector == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NO_HOME_FOR_INSTANCE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"undoEntityUpdate", entityGUID, entity.getMetadataCollectionId()});
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "undoEntityUpdate", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return homeRepositoryConnector.getMetadataCollection().undoEntityUpdate(userId, entityGUID);
    }

    public EntityDetail deleteEntity(String userId, String typeDefGUID, String typeDefName, String obsoleteEntityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "deleteEntity";
        super.removeInstanceParameterValidation(userId, typeDefGUID, typeDefName, obsoleteEntityGUID, "deleteEntity");
        EntitySummary entity = this.getEntitySummary(userId, obsoleteEntityGUID);
        this.repositoryValidator.validateEntityFromStore(this.repositoryName, obsoleteEntityGUID, entity, "deleteEntity");
        OMRSRepositoryConnector homeRepositoryConnector = this.enterpriseParentConnector.getHomeConnector((InstanceHeader)entity, "deleteEntity");
        if (homeRepositoryConnector == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NO_HOME_FOR_INSTANCE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"deleteEntity", obsoleteEntityGUID, entity.getMetadataCollectionId()});
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "deleteEntity", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return homeRepositoryConnector.getMetadataCollection().deleteEntity(userId, typeDefGUID, typeDefName, obsoleteEntityGUID);
    }

    public void purgeEntity(String userId, String typeDefGUID, String typeDefName, String deletedEntityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityNotDeletedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "purgeEntity";
        this.removeInstanceParameterValidation(userId, typeDefGUID, typeDefName, deletedEntityGUID, "purgeEntity");
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("purgeEntity");
        InvalidParameterException invalidParameterException = null;
        EntityNotKnownException entityNotKnownException = null;
        EntityNotDeletedException entityNotDeletedException = null;
        UserNotAuthorizedException userNotAuthorizedException = null;
        RepositoryErrorException repositoryErrorException = null;
        FunctionNotSupportedException functionNotSupportedException = null;
        Throwable anotherException = null;
        for (OMRSRepositoryConnector cohortConnector : cohortConnectors) {
            if (cohortConnector == null) continue;
            OMRSMetadataCollection metadataCollection = cohortConnector.getMetadataCollection();
            this.validateMetadataCollection(metadataCollection, "purgeEntity");
            try {
                metadataCollection.purgeEntity(userId, typeDefGUID, typeDefName, deletedEntityGUID);
                return;
            }
            catch (InvalidParameterException error) {
                invalidParameterException = error;
            }
            catch (EntityNotKnownException error) {
                entityNotKnownException = error;
            }
            catch (EntityNotDeletedException error) {
                entityNotDeletedException = error;
            }
            catch (RepositoryErrorException error) {
                repositoryErrorException = error;
            }
            catch (FunctionNotSupportedException error) {
                functionNotSupportedException = error;
            }
            catch (UserNotAuthorizedException error) {
                userNotAuthorizedException = error;
            }
            catch (Throwable error) {
                anotherException = error;
            }
        }
        this.throwCapturedEntityNotDeletedException(entityNotDeletedException);
        this.throwCapturedRepositoryErrorException(repositoryErrorException);
        this.throwCapturedUserNotAuthorizedException(userNotAuthorizedException);
        this.throwCapturedThrowableException(anotherException, "purgeEntity");
        this.throwCapturedEntityNotKnownException(entityNotKnownException);
        this.throwCapturedFunctionNotSupportedException(functionNotSupportedException);
        this.throwCapturedInvalidParameterException(invalidParameterException);
    }

    public EntityDetail restoreEntity(String userId, String deletedEntityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityNotDeletedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "restoreEntity";
        super.manageInstanceParameterValidation(userId, deletedEntityGUID, "restoreEntity");
        EntityDetail entity = this.isEntityKnown(userId, deletedEntityGUID);
        this.repositoryValidator.validateEntityFromStore(this.repositoryName, deletedEntityGUID, entity, "restoreEntity");
        this.repositoryValidator.validateEntityIsDeleted(this.repositoryName, (InstanceHeader)entity, "restoreEntity");
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("restoreEntity");
        InvalidParameterException invalidParameterException = null;
        EntityNotKnownException entityNotKnownException = null;
        EntityNotDeletedException entityNotDeletedException = null;
        UserNotAuthorizedException userNotAuthorizedException = null;
        RepositoryErrorException repositoryErrorException = null;
        FunctionNotSupportedException functionNotSupportedException = null;
        Throwable anotherException = null;
        for (OMRSRepositoryConnector cohortConnector : cohortConnectors) {
            if (cohortConnector == null) continue;
            OMRSMetadataCollection metadataCollection = cohortConnector.getMetadataCollection();
            this.validateMetadataCollection(metadataCollection, "restoreEntity");
            try {
                return metadataCollection.restoreEntity(userId, deletedEntityGUID);
            }
            catch (InvalidParameterException error) {
                invalidParameterException = error;
            }
            catch (FunctionNotSupportedException error) {
                functionNotSupportedException = error;
            }
            catch (EntityNotKnownException error) {
                entityNotKnownException = error;
            }
            catch (EntityNotDeletedException error) {
                entityNotDeletedException = error;
            }
            catch (RepositoryErrorException error) {
                repositoryErrorException = error;
            }
            catch (UserNotAuthorizedException error) {
                userNotAuthorizedException = error;
            }
            catch (Throwable error) {
                anotherException = error;
            }
        }
        this.throwCapturedEntityNotDeletedException(entityNotDeletedException);
        this.throwCapturedRepositoryErrorException(repositoryErrorException);
        this.throwCapturedUserNotAuthorizedException(userNotAuthorizedException);
        this.throwCapturedThrowableException(anotherException, "restoreEntity");
        this.throwCapturedEntityNotKnownException(entityNotKnownException);
        this.throwCapturedInvalidParameterException(invalidParameterException);
        this.throwCapturedFunctionNotSupportedException(functionNotSupportedException);
        return null;
    }

    public EntityDetail classifyEntity(String userId, String entityGUID, String classificationName, InstanceProperties classificationProperties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "classifyEntity";
        this.classifyEntityParameterValidation(userId, entityGUID, classificationName, classificationProperties);
        EntitySummary entity = this.getEntitySummary(userId, entityGUID);
        this.repositoryValidator.validateEntityFromStore(this.repositoryName, entityGUID, entity, "classifyEntity");
        OMRSRepositoryConnector homeRepositoryConnector = this.enterpriseParentConnector.getHomeConnector((InstanceHeader)entity, "classifyEntity");
        if (homeRepositoryConnector == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NO_HOME_FOR_INSTANCE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"classifyEntity", entityGUID, entity.getMetadataCollectionId()});
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "classifyEntity", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return homeRepositoryConnector.getMetadataCollection().classifyEntity(userId, entityGUID, classificationName, classificationProperties);
    }

    public EntityDetail declassifyEntity(String userId, String entityGUID, String classificationName) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "declassifyEntity";
        super.declassifyEntityParameterValidation(userId, entityGUID, classificationName);
        EntitySummary entity = this.getEntitySummary(userId, entityGUID);
        this.repositoryValidator.validateEntityFromStore(this.repositoryName, entityGUID, entity, "declassifyEntity");
        OMRSRepositoryConnector homeRepositoryConnector = this.enterpriseParentConnector.getHomeConnector((InstanceHeader)entity, "declassifyEntity");
        if (homeRepositoryConnector == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NO_HOME_FOR_INSTANCE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"declassifyEntity", entityGUID, entity.getMetadataCollectionId()});
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "declassifyEntity", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return homeRepositoryConnector.getMetadataCollection().declassifyEntity(userId, entityGUID, classificationName);
    }

    public EntityDetail updateEntityClassification(String userId, String entityGUID, String classificationName, InstanceProperties properties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "updateEntityClassification";
        super.updateEntityClassificationParameterValidation(userId, entityGUID, classificationName, properties);
        EntitySummary entity = this.getEntitySummary(userId, entityGUID);
        this.repositoryValidator.validateEntityFromStore(this.repositoryName, entityGUID, entity, "updateEntityClassification");
        OMRSRepositoryConnector homeRepositoryConnector = this.enterpriseParentConnector.getHomeConnector((InstanceHeader)entity, "updateEntityClassification");
        if (homeRepositoryConnector == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NO_HOME_FOR_INSTANCE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"updateEntityClassification", entityGUID, entity.getMetadataCollectionId()});
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "updateEntityClassification", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return homeRepositoryConnector.getMetadataCollection().updateEntityClassification(userId, entityGUID, classificationName, properties);
    }

    private boolean ensureEntityEndKnown(String userId, String entityGUID, EntityProxy entityProxy, OMRSMetadataCollection metadataCollection) {
        try {
            metadataCollection.getEntitySummary(userId, entityGUID);
            return true;
        }
        catch (EntityNotKnownException error) {
            try {
                metadataCollection.addEntityProxy(userId, entityProxy);
                return true;
            }
            catch (Throwable proxyError) {
                log.debug("Error from adding proxy: " + proxyError.getMessage());
            }
        }
        catch (Throwable error) {
            log.debug("Error from querying entity: " + error.getMessage());
        }
        return false;
    }

    public Relationship addRelationship(String userId, String relationshipTypeGUID, InstanceProperties initialProperties, String entityOneGUID, String entityTwoGUID, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, EntityNotKnownException, StatusNotSupportedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "addRelationship";
        super.addRelationshipParameterValidation(userId, relationshipTypeGUID, initialProperties, entityOneGUID, entityTwoGUID, initialStatus);
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("addRelationship");
        InvalidParameterException invalidParameterException = null;
        EntityNotKnownException entityNotKnownException = null;
        TypeErrorException typeErrorException = null;
        PropertyErrorException propertyErrorException = null;
        StatusNotSupportedException statusNotSupportedException = null;
        UserNotAuthorizedException userNotAuthorizedException = null;
        RepositoryErrorException repositoryErrorException = null;
        FunctionNotSupportedException functionNotSupportedException = null;
        Throwable anotherException = null;
        EntityProxy entityOneProxy = new EntityProxy(this.getEntitySummary(userId, entityOneGUID));
        EntityProxy entityTwoProxy = new EntityProxy(this.getEntitySummary(userId, entityTwoGUID));
        if (entityOneProxy == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.ENTITY_NOT_KNOWN;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{entityOneGUID, "addRelationship", this.repositoryName});
            throw new EntityNotKnownException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "addRelationship", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        if (entityTwoProxy == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.ENTITY_NOT_KNOWN;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{entityTwoGUID, "addRelationship", this.repositoryName});
            throw new EntityNotKnownException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "addRelationship", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (OMRSRepositoryConnector cohortConnector : cohortConnectors) {
            OMRSMetadataCollection metadataCollection = cohortConnector.getMetadataCollection();
            try {
                if (!this.ensureEntityEndKnown(userId, entityOneGUID, entityOneProxy, metadataCollection) || !this.ensureEntityEndKnown(userId, entityTwoGUID, entityTwoProxy, metadataCollection)) continue;
                return metadataCollection.addRelationship(userId, relationshipTypeGUID, initialProperties, entityOneGUID, entityTwoGUID, initialStatus);
            }
            catch (TypeErrorException error) {
                typeErrorException = error;
            }
            catch (InvalidParameterException error) {
                invalidParameterException = error;
            }
            catch (EntityNotKnownException error) {
                entityNotKnownException = error;
            }
            catch (StatusNotSupportedException error) {
                statusNotSupportedException = error;
            }
            catch (PropertyErrorException error) {
                propertyErrorException = error;
            }
            catch (RepositoryErrorException error) {
                repositoryErrorException = error;
            }
            catch (UserNotAuthorizedException error) {
                userNotAuthorizedException = error;
            }
            catch (Throwable error) {
                anotherException = error;
            }
        }
        this.throwCapturedEntityNotKnownException(entityNotKnownException);
        this.throwCapturedInvalidParameterException(invalidParameterException);
        this.throwCapturedRepositoryErrorException(repositoryErrorException);
        this.throwCapturedStatusNotSupportedException(statusNotSupportedException);
        this.throwCapturedTypeErrorException(typeErrorException);
        this.throwCapturedPropertyErrorException(propertyErrorException);
        this.throwCapturedUserNotAuthorizedException(userNotAuthorizedException);
        this.throwCapturedFunctionNotSupportedException(functionNotSupportedException);
        this.throwCapturedThrowableException(anotherException, "addRelationship");
        return null;
    }

    public Relationship updateRelationshipStatus(String userId, String relationshipGUID, InstanceStatus newStatus) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, StatusNotSupportedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "updateRelationshipStatus";
        super.updateInstanceStatusParameterValidation(userId, relationshipGUID, newStatus, "updateRelationshipStatus");
        Relationship relationship = this.getRelationship(userId, relationshipGUID);
        this.repositoryValidator.validateInstanceType(this.repositoryName, (InstanceHeader)relationship);
        OMRSRepositoryConnector homeRepositoryConnector = this.enterpriseParentConnector.getHomeConnector((InstanceHeader)relationship, "updateRelationshipStatus");
        if (homeRepositoryConnector == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NO_HOME_FOR_INSTANCE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"updateRelationshipStatus", relationshipGUID, relationship.getMetadataCollectionId()});
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "updateRelationshipStatus", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return homeRepositoryConnector.getMetadataCollection().updateRelationshipStatus(userId, relationshipGUID, newStatus);
    }

    public Relationship updateRelationshipProperties(String userId, String relationshipGUID, InstanceProperties properties) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "updateRelationshipProperties";
        super.updateInstancePropertiesPropertyValidation(userId, relationshipGUID, properties, "updateRelationshipProperties");
        Relationship relationship = this.getRelationship(userId, relationshipGUID);
        this.repositoryValidator.validateInstanceType(this.repositoryName, (InstanceHeader)relationship);
        OMRSRepositoryConnector homeRepositoryConnector = this.enterpriseParentConnector.getHomeConnector((InstanceHeader)relationship, "updateRelationshipProperties");
        if (homeRepositoryConnector == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NO_HOME_FOR_INSTANCE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"updateRelationshipProperties", relationshipGUID, relationship.getMetadataCollectionId()});
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "updateRelationshipProperties", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return homeRepositoryConnector.getMetadataCollection().updateRelationshipProperties(userId, relationshipGUID, properties);
    }

    public Relationship undoRelationshipUpdate(String userId, String relationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "undoRelationshipUpdate";
        super.manageInstanceParameterValidation(userId, relationshipGUID, "undoRelationshipUpdate");
        Relationship relationship = this.getRelationship(userId, relationshipGUID);
        this.repositoryValidator.validateInstanceType(this.repositoryName, (InstanceHeader)relationship);
        OMRSRepositoryConnector homeRepositoryConnector = this.enterpriseParentConnector.getHomeConnector((InstanceHeader)relationship, "undoRelationshipUpdate");
        if (homeRepositoryConnector == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NO_HOME_FOR_INSTANCE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"undoRelationshipUpdate", relationshipGUID, relationship.getMetadataCollectionId()});
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "undoRelationshipUpdate", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return homeRepositoryConnector.getMetadataCollection().undoRelationshipUpdate(userId, relationshipGUID);
    }

    public Relationship deleteRelationship(String userId, String typeDefGUID, String typeDefName, String obsoleteRelationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "deleteRelationship";
        this.removeInstanceParameterValidation(userId, typeDefGUID, typeDefName, obsoleteRelationshipGUID, "deleteRelationship");
        Relationship relationship = this.getRelationship(userId, obsoleteRelationshipGUID);
        this.repositoryValidator.validateTypeForInstanceDelete(this.repositoryName, typeDefGUID, typeDefName, (InstanceHeader)relationship, "deleteRelationship");
        OMRSRepositoryConnector homeRepositoryConnector = this.enterpriseParentConnector.getHomeConnector((InstanceHeader)relationship, "deleteRelationship");
        if (homeRepositoryConnector == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NO_HOME_FOR_INSTANCE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"deleteRelationship", obsoleteRelationshipGUID, relationship.getMetadataCollectionId()});
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "deleteRelationship", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return homeRepositoryConnector.getMetadataCollection().deleteRelationship(userId, typeDefGUID, typeDefName, obsoleteRelationshipGUID);
    }

    public void purgeRelationship(String userId, String typeDefGUID, String typeDefName, String deletedRelationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, RelationshipNotDeletedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "purgeRelationship";
        this.removeInstanceParameterValidation(userId, typeDefGUID, typeDefName, deletedRelationshipGUID, "purgeRelationship");
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("purgeRelationship");
        InvalidParameterException invalidParameterException = null;
        RelationshipNotKnownException relationshipNotKnownException = null;
        RelationshipNotDeletedException relationshipNotDeletedException = null;
        UserNotAuthorizedException userNotAuthorizedException = null;
        FunctionNotSupportedException functionNotSupportedException = null;
        RepositoryErrorException repositoryErrorException = null;
        Throwable anotherException = null;
        for (OMRSRepositoryConnector cohortConnector : cohortConnectors) {
            if (cohortConnector == null) continue;
            OMRSMetadataCollection metadataCollection = cohortConnector.getMetadataCollection();
            this.validateMetadataCollection(metadataCollection, "purgeRelationship");
            try {
                metadataCollection.purgeRelationship(userId, typeDefGUID, typeDefName, deletedRelationshipGUID);
                return;
            }
            catch (InvalidParameterException error) {
                invalidParameterException = error;
            }
            catch (RelationshipNotKnownException error) {
                relationshipNotKnownException = error;
            }
            catch (RelationshipNotDeletedException error) {
                relationshipNotDeletedException = error;
            }
            catch (RepositoryErrorException error) {
                repositoryErrorException = error;
            }
            catch (FunctionNotSupportedException error) {
                functionNotSupportedException = error;
            }
            catch (UserNotAuthorizedException error) {
                userNotAuthorizedException = error;
            }
            catch (Throwable error) {
                anotherException = error;
            }
        }
        this.throwCapturedRelationshipNotDeletedException(relationshipNotDeletedException);
        this.throwCapturedRepositoryErrorException(repositoryErrorException);
        this.throwCapturedUserNotAuthorizedException(userNotAuthorizedException);
        this.throwCapturedThrowableException(anotherException, "purgeRelationship");
        this.throwCapturedRelationshipNotKnownException(relationshipNotKnownException);
        this.throwCapturedFunctionNotSupportedException(functionNotSupportedException);
        this.throwCapturedInvalidParameterException(invalidParameterException);
    }

    public Relationship restoreRelationship(String userId, String deletedRelationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, RelationshipNotDeletedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "restoreRelationship";
        this.manageInstanceParameterValidation(userId, deletedRelationshipGUID, "restoreRelationship");
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("restoreRelationship");
        InvalidParameterException invalidParameterException = null;
        RelationshipNotKnownException relationshipNotKnownException = null;
        RelationshipNotDeletedException relationshipNotDeletedException = null;
        UserNotAuthorizedException userNotAuthorizedException = null;
        RepositoryErrorException repositoryErrorException = null;
        FunctionNotSupportedException functionNotSupportedException = null;
        Throwable anotherException = null;
        for (OMRSRepositoryConnector cohortConnector : cohortConnectors) {
            if (cohortConnector == null) continue;
            OMRSMetadataCollection metadataCollection = cohortConnector.getMetadataCollection();
            this.validateMetadataCollection(metadataCollection, "restoreRelationship");
            try {
                return metadataCollection.restoreRelationship(userId, deletedRelationshipGUID);
            }
            catch (InvalidParameterException error) {
                invalidParameterException = error;
            }
            catch (FunctionNotSupportedException error) {
                functionNotSupportedException = error;
            }
            catch (RelationshipNotKnownException error) {
                relationshipNotKnownException = error;
            }
            catch (RelationshipNotDeletedException error) {
                relationshipNotDeletedException = error;
            }
            catch (RepositoryErrorException error) {
                repositoryErrorException = error;
            }
            catch (UserNotAuthorizedException error) {
                userNotAuthorizedException = error;
            }
            catch (Throwable error) {
                anotherException = error;
            }
        }
        this.throwCapturedRelationshipNotDeletedException(relationshipNotDeletedException);
        this.throwCapturedRepositoryErrorException(repositoryErrorException);
        this.throwCapturedUserNotAuthorizedException(userNotAuthorizedException);
        this.throwCapturedThrowableException(anotherException, "restoreRelationship");
        this.throwCapturedRelationshipNotKnownException(relationshipNotKnownException);
        this.throwCapturedInvalidParameterException(invalidParameterException);
        this.throwCapturedFunctionNotSupportedException(functionNotSupportedException);
        return null;
    }

    public EntityDetail reIdentifyEntity(String userId, String typeDefGUID, String typeDefName, String entityGUID, String newEntityGUID) throws FunctionNotSupportedException {
        String methodName = "reIdentifyEntity()";
        this.throwNotEnterpriseFunction("reIdentifyEntity()");
        return null;
    }

    public EntityDetail reTypeEntity(String userId, String entityGUID, TypeDefSummary currentTypeDefSummary, TypeDefSummary newTypeDefSummary) throws FunctionNotSupportedException {
        String methodName = "reTypeEntity()";
        this.throwNotEnterpriseFunction("reTypeEntity()");
        return null;
    }

    public EntityDetail reHomeEntity(String userId, String entityGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId, String newHomeMetadataCollectionId, String newHomeMetadataCollectionName) throws FunctionNotSupportedException {
        String methodName = "reHomeEntity()";
        this.throwNotEnterpriseFunction("reHomeEntity()");
        return null;
    }

    public Relationship reIdentifyRelationship(String userId, String typeDefGUID, String typeDefName, String relationshipGUID, String newRelationshipGUID) throws FunctionNotSupportedException {
        String methodName = "reIdentifyRelationship()";
        this.throwNotEnterpriseFunction("reIdentifyRelationship()");
        return null;
    }

    public Relationship reTypeRelationship(String userId, String relationshipGUID, TypeDefSummary currentTypeDefSummary, TypeDefSummary newTypeDefSummary) throws FunctionNotSupportedException {
        String methodName = "reTypeRelationship()";
        this.throwNotEnterpriseFunction("reTypeRelationship()");
        return null;
    }

    public Relationship reHomeRelationship(String userId, String relationshipGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId, String newHomeMetadataCollectionId, String newHomeMetadataCollectionName) throws FunctionNotSupportedException {
        String methodName = "reHomeRelationship";
        this.throwNotEnterpriseFunction("reHomeRelationship");
        return null;
    }

    public void saveEntityReferenceCopy(String userId, EntityDetail entity) throws FunctionNotSupportedException {
        String methodName = "saveEntityReferenceCopy()";
        this.throwNotEnterpriseFunction("saveEntityReferenceCopy()");
    }

    public void purgeEntityReferenceCopy(String userId, String entityGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId) throws FunctionNotSupportedException {
        String methodName = "purgeEntityReferenceCopy()";
        this.throwNotEnterpriseFunction("purgeEntityReferenceCopy()");
    }

    public void refreshEntityReferenceCopy(String userId, String entityGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId) throws FunctionNotSupportedException {
        String methodName = "refreshEntityReferenceCopy()";
        this.throwNotEnterpriseFunction("refreshEntityReferenceCopy()");
    }

    public void saveRelationshipReferenceCopy(String userId, Relationship relationship) throws FunctionNotSupportedException {
        String methodName = "saveRelationshipReferenceCopy()";
        this.throwNotEnterpriseFunction("saveRelationshipReferenceCopy()");
    }

    public void purgeRelationshipReferenceCopy(String userId, String relationshipGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId) throws FunctionNotSupportedException {
        String methodName = "purgeRelationshipReferenceCopy()";
        this.throwNotEnterpriseFunction("purgeRelationshipReferenceCopy()");
    }

    public void refreshRelationshipReferenceCopy(String userId, String relationshipGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId) throws FunctionNotSupportedException {
        String methodName = "refreshRelationshipReferenceCopy()";
        this.throwNotEnterpriseFunction("refreshRelationshipReferenceCopy()");
    }

    private Map<String, AttributeTypeDef> addUniqueAttributeTypeDefs(Map<String, AttributeTypeDef> accumulatedResults, List<AttributeTypeDef> newResults, String serverName, String metadataCollectionId, String methodName) {
        Map<String, AttributeTypeDef> combinedResults = new HashMap<String, AttributeTypeDef>(accumulatedResults);
        if (newResults != null) {
            for (AttributeTypeDef attributeTypeDef : newResults) {
                if (attributeTypeDef == null) continue;
                combinedResults = this.addUniqueAttributeTypeDef(combinedResults, attributeTypeDef, serverName, metadataCollectionId, methodName);
            }
        }
        return combinedResults;
    }

    private Map<String, AttributeTypeDef> addUniqueAttributeTypeDef(Map<String, AttributeTypeDef> accumulatedResults, AttributeTypeDef attributeTypeDef, String serverName, String metadataCollectionId, String methodName) {
        HashMap<String, AttributeTypeDef> combinedResults = new HashMap<String, AttributeTypeDef>(accumulatedResults);
        if (attributeTypeDef != null) {
            AttributeTypeDef attributeTypeDef2 = combinedResults.put(attributeTypeDef.getGUID(), attributeTypeDef);
        }
        return combinedResults;
    }

    private Map<String, TypeDef> addUniqueTypeDefs(Map<String, TypeDef> accumulatedResults, List<TypeDef> returnedTypeDefs, String serverName, String metadataCollectionId, String methodName) {
        Map<String, TypeDef> combinedResults = new HashMap<String, TypeDef>(accumulatedResults);
        if (returnedTypeDefs != null) {
            for (TypeDef returnedTypeDef : returnedTypeDefs) {
                combinedResults = this.addUniqueTypeDef(combinedResults, returnedTypeDef, serverName, metadataCollectionId, methodName);
            }
        }
        return combinedResults;
    }

    private Map<String, TypeDef> addUniqueTypeDef(Map<String, TypeDef> accumulatedResults, TypeDef typeDef, String serverName, String metadataCollectionId, String methodName) {
        HashMap<String, TypeDef> combinedResults = new HashMap<String, TypeDef>(accumulatedResults);
        if (typeDef != null) {
            TypeDef typeDef2 = combinedResults.put(typeDef.getGUID(), typeDef);
        }
        return combinedResults;
    }

    private Map<String, EntityDetail> addUniqueEntities(Map<String, EntityDetail> accumulatedResults, List<EntityDetail> results, String serverName, String metadataCollectionId, String methodName) {
        Map<String, EntityDetail> combinedResults = new HashMap<String, EntityDetail>(accumulatedResults);
        if (results != null) {
            List<EntityDetail> processedResults = this.enterpriseParentConnector.processRetrievedEntities(metadataCollectionId, results);
            for (EntityDetail returnedEntity : processedResults) {
                combinedResults = this.addUniqueEntity(combinedResults, returnedEntity, serverName, metadataCollectionId, methodName);
            }
        }
        return combinedResults;
    }

    private Map<String, EntityDetail> addUniqueEntity(Map<String, EntityDetail> accumulatedResults, EntityDetail entity, String serverName, String metadataCollectionId, String methodName) {
        HashMap<String, EntityDetail> combinedResults = new HashMap<String, EntityDetail>(accumulatedResults);
        if (entity != null) {
            EntityDetail entityDetail = combinedResults.put(entity.getGUID(), entity);
        }
        return combinedResults;
    }

    private Map<String, Relationship> addUniqueRelationships(Map<String, Relationship> accumulatedResults, List<Relationship> results, String serverName, String metadataCollectionId, String methodName) {
        Map<String, Relationship> combinedResults = new HashMap<String, Relationship>(accumulatedResults);
        if (results != null) {
            List<Relationship> processedResults = this.enterpriseParentConnector.processRetrievedRelationships(metadataCollectionId, results);
            for (Relationship returnedRelationship : processedResults) {
                combinedResults = this.addUniqueRelationship(combinedResults, returnedRelationship, serverName, metadataCollectionId, methodName);
            }
        }
        return combinedResults;
    }

    private Map<String, Relationship> addUniqueRelationship(Map<String, Relationship> accumulatedResults, Relationship relationship, String serverName, String metadataCollectionId, String methodName) {
        HashMap<String, Relationship> combinedResults = new HashMap<String, Relationship>(accumulatedResults);
        if (relationship != null) {
            Relationship relationship2 = combinedResults.put(relationship.getGUID(), relationship);
        }
        return combinedResults;
    }

    private void validateMetadataCollection(OMRSMetadataCollection cohortMetadataCollection, String methodName) throws RepositoryErrorException {
        if (cohortMetadataCollection == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_ENTERPRISE_METADATA_COLLECTION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[0]);
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    private void throwNotEnterpriseFunction(String methodName) throws FunctionNotSupportedException {
        OMRSErrorCode errorCode = OMRSErrorCode.ENTERPRISE_NOT_SUPPORTED;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
        throw new FunctionNotSupportedException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    private void throwCapturedTypeDefNotKnownException(TypeDefNotKnownException exception) throws TypeDefNotKnownException {
        if (exception != null) {
            throw exception;
        }
    }

    private void throwCapturedInvalidParameterException(InvalidParameterException exception) throws InvalidParameterException {
        if (exception != null) {
            throw exception;
        }
    }

    private void throwCapturedTypeErrorException(TypeErrorException exception) throws TypeErrorException {
        if (exception != null) {
            throw exception;
        }
    }

    private void throwCapturedStatusNotSupportedException(StatusNotSupportedException exception) throws StatusNotSupportedException {
        if (exception != null) {
            throw exception;
        }
    }

    private void throwCapturedClassificationErrorException(ClassificationErrorException exception) throws ClassificationErrorException {
        if (exception != null) {
            throw exception;
        }
    }

    private void throwCapturedPropertyErrorException(PropertyErrorException exception) throws PropertyErrorException {
        if (exception != null) {
            throw exception;
        }
    }

    private void throwCapturedEntityNotKnownException(EntityNotKnownException exception) throws EntityNotKnownException {
        if (exception != null) {
            throw exception;
        }
    }

    private void throwCapturedEntityNotDeletedException(EntityNotDeletedException exception) throws EntityNotDeletedException {
        if (exception != null) {
            throw exception;
        }
    }

    private void throwCapturedEntityProxyOnlyException(EntityProxyOnlyException exception) throws EntityProxyOnlyException {
        if (exception != null) {
            throw exception;
        }
    }

    private void throwCapturedRelationshipNotKnownException(RelationshipNotKnownException exception) throws RelationshipNotKnownException {
        if (exception != null) {
            throw exception;
        }
    }

    private void throwCapturedRelationshipNotDeletedException(RelationshipNotDeletedException exception) throws RelationshipNotDeletedException {
        if (exception != null) {
            throw exception;
        }
    }

    private void throwCapturedTypeDefNotSupportedException(TypeDefNotSupportedException exception) throws TypeDefNotSupportedException {
        if (exception != null) {
            throw exception;
        }
    }

    private void throwCapturedFunctionNotSupportedException(FunctionNotSupportedException exception) throws FunctionNotSupportedException {
        if (exception != null) {
            throw exception;
        }
    }

    private void throwCapturedUserNotAuthorizedException(UserNotAuthorizedException exception) throws UserNotAuthorizedException {
        if (exception != null) {
            throw exception;
        }
    }

    private void throwCapturedRepositoryErrorException(RepositoryErrorException exception) throws RepositoryErrorException {
        if (exception != null) {
            throw exception;
        }
    }

    private void throwCapturedThrowableException(Throwable exception, String methodName) throws RepositoryErrorException {
        if (exception != null) {
            OMRSErrorCode errorCode = OMRSErrorCode.UNEXPECTED_EXCEPTION_FROM_COHORT;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName, exception.getMessage()});
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    private TypeDefGallery validatedTypeDefGalleryResults(String repositoryName, Map<String, TypeDef> combinedTypeDefResults, Map<String, AttributeTypeDef> combinedAttributeTypeDefResults, UserNotAuthorizedException userNotAuthorizedException, RepositoryErrorException repositoryErrorException, Throwable anotherException, String methodName) throws RepositoryErrorException, UserNotAuthorizedException {
        int resultCount = combinedTypeDefResults.size() + combinedAttributeTypeDefResults.size();
        if (resultCount > 0) {
            TypeDefGallery typeDefGallery = new TypeDefGallery();
            ArrayList<AttributeTypeDef> attributeTypeDefs = new ArrayList<AttributeTypeDef>(combinedAttributeTypeDefResults.values());
            ArrayList<TypeDef> typeDefs = new ArrayList<TypeDef>(combinedTypeDefResults.values());
            this.repositoryValidator.validateEnterpriseTypeDefs(repositoryName, typeDefs, methodName);
            typeDefGallery.setAttributeTypeDefs(attributeTypeDefs);
            typeDefGallery.setTypeDefs(typeDefs);
            return typeDefGallery;
        }
        this.throwCapturedUserNotAuthorizedException(userNotAuthorizedException);
        this.throwCapturedRepositoryErrorException(repositoryErrorException);
        this.throwCapturedThrowableException(anotherException, methodName);
        return null;
    }

    private List<TypeDef> validatedTypeDefListResults(String repositoryName, Map<String, TypeDef> combinedTypeDefResults, UserNotAuthorizedException userNotAuthorizedException, RepositoryErrorException repositoryErrorException, Throwable anotherException, String methodName) throws RepositoryErrorException, UserNotAuthorizedException {
        if (!combinedTypeDefResults.isEmpty()) {
            ArrayList<TypeDef> typeDefs = new ArrayList<TypeDef>(combinedTypeDefResults.values());
            this.repositoryValidator.validateEnterpriseTypeDefs(repositoryName, typeDefs, methodName);
            return typeDefs;
        }
        this.throwCapturedUserNotAuthorizedException(userNotAuthorizedException);
        this.throwCapturedRepositoryErrorException(repositoryErrorException);
        this.throwCapturedThrowableException(anotherException, methodName);
        return null;
    }

    private List<AttributeTypeDef> validatedAttributeTypeDefListResults(String repositoryName, Map<String, AttributeTypeDef> combinedAttributeTypeDefResults, UserNotAuthorizedException userNotAuthorizedException, RepositoryErrorException repositoryErrorException, Throwable anotherException, String methodName) throws RepositoryErrorException, UserNotAuthorizedException {
        if (!combinedAttributeTypeDefResults.isEmpty()) {
            ArrayList<AttributeTypeDef> attributeTypeDefs = new ArrayList<AttributeTypeDef>(combinedAttributeTypeDefResults.values());
            this.repositoryValidator.validateEnterpriseAttributeTypeDefs(repositoryName, attributeTypeDefs, methodName);
            return attributeTypeDefs;
        }
        this.throwCapturedUserNotAuthorizedException(userNotAuthorizedException);
        this.throwCapturedRepositoryErrorException(repositoryErrorException);
        this.throwCapturedThrowableException(anotherException, methodName);
        return null;
    }

    private List<EntityDetail> validatedEntityListResults(String repositoryName, Map<String, EntityDetail> combinedResults, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize, String methodName) throws RepositoryErrorException {
        if (combinedResults.isEmpty()) {
            return null;
        }
        ArrayList<EntityDetail> actualResults = new ArrayList<EntityDetail>(combinedResults.values());
        return actualResults;
    }

    private List<Relationship> validatedRelationshipResults(String repositoryName, Map<String, Relationship> combinedResults, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize, String methodName) throws RepositoryErrorException {
        if (combinedResults.isEmpty()) {
            return null;
        }
        ArrayList<Relationship> actualResults = new ArrayList<Relationship>(combinedResults.values());
        return actualResults;
    }

    private InstanceGraph validatedInstanceGraphResults(String repositoryName, Map<String, EntityDetail> accumulatedEntityResults, Map<String, Relationship> accumulatedRelationshipResults, UserNotAuthorizedException userNotAuthorizedException, PropertyErrorException propertyErrorException, FunctionNotSupportedException functionNotSupportedException, EntityNotKnownException entityNotKnownException, RepositoryErrorException repositoryErrorException, Throwable anotherException, String methodName) throws UserNotAuthorizedException, PropertyErrorException, FunctionNotSupportedException, EntityNotKnownException, RepositoryErrorException {
        int resultCount = accumulatedEntityResults.size() + accumulatedRelationshipResults.size();
        if (resultCount > 0) {
            InstanceGraph instanceGraph = new InstanceGraph();
            ArrayList<EntityDetail> entityDetails = new ArrayList<EntityDetail>(accumulatedEntityResults.values());
            ArrayList<Relationship> relationships = new ArrayList<Relationship>(accumulatedRelationshipResults.values());
            instanceGraph.setEntities(entityDetails);
            instanceGraph.setRelationships(relationships);
            return instanceGraph;
        }
        this.throwCapturedUserNotAuthorizedException(userNotAuthorizedException);
        this.throwCapturedRepositoryErrorException(repositoryErrorException);
        this.throwCapturedPropertyErrorException(propertyErrorException);
        this.throwCapturedThrowableException(anotherException, methodName);
        this.throwCapturedFunctionNotSupportedException(functionNotSupportedException);
        this.throwCapturedEntityNotKnownException(entityNotKnownException);
        return null;
    }
}

