/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditCode;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.enterprise.connectormanager.OMRSConnectorConsumer;
import org.odpi.openmetadata.repositoryservices.enterprise.connectormanager.OMRSConnectorManager;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.EnterpriseOMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSRuntimeException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.localrepository.repositoryconnector.LocalOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.localrepository.repositoryconnector.OMRSInstanceRetrievalEventProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnterpriseOMRSRepositoryConnector
extends OMRSRepositoryConnector
implements OMRSConnectorConsumer {
    private OMRSConnectorManager connectorManager;
    private String connectorConsumerId;
    private LocalOMRSRepositoryConnector localConnector = null;
    private OMRSInstanceRetrievalEventProcessor localEventProcessor = null;
    private String localMetadataCollectionId = null;
    private List<FederatedConnector> remoteCohortConnectors = new ArrayList<FederatedConnector>();
    private String accessServiceName = null;
    private static final Logger log = LoggerFactory.getLogger(EnterpriseOMRSRepositoryConnector.class);

    public EnterpriseOMRSRepositoryConnector(OMRSConnectorManager connectorManager) {
        String methodName = "constructor";
        this.connectorManager = connectorManager;
        if (connectorManager == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.INVALID_COHORT_CONFIG;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[0]);
            throw new OMRSRuntimeException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        this.connectorConsumerId = connectorManager.registerConnectorConsumer(this);
    }

    public void setMetadataCollectionId(String metadataCollectionId) {
        this.metadataCollectionId = metadataCollectionId;
        if (metadataCollectionId != null) {
            this.metadataCollection = new EnterpriseOMRSMetadataCollection(this, this.serverName, this.repositoryHelper, this.repositoryValidator, metadataCollectionId);
        }
    }

    public String getAccessServiceName() {
        return this.accessServiceName;
    }

    public void setAccessServiceName(String accessServiceName) {
        this.accessServiceName = accessServiceName;
    }

    public void start() throws ConnectorCheckedException {
        super.start();
        if (this.auditLog != null) {
            String actionDescription = "start";
            OMRSAuditCode auditCode = OMRSAuditCode.STARTING_ENTERPRISE_CONNECTOR;
            this.auditLog.logRecord("start", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{this.accessServiceName}), null, auditCode.getSystemAction(), auditCode.getUserAction());
        }
    }

    public void disconnect() throws ConnectorCheckedException {
        super.disconnect();
        if (this.auditLog != null) {
            String actionDescription = "disconnect";
            OMRSAuditCode auditCode = OMRSAuditCode.DISCONNECTING_ENTERPRISE_CONNECTOR;
            this.auditLog.logRecord("disconnect", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{this.accessServiceName}), null, auditCode.getSystemAction(), auditCode.getUserAction());
        }
        if (this.connectorManager != null && this.connectorConsumerId != null) {
            this.connectorManager.unregisterConnectorConsumer(this.connectorConsumerId);
        }
        this.localConnector = null;
        this.remoteCohortConnectors = new ArrayList<FederatedConnector>();
    }

    protected OMRSRepositoryConnector getHomeConnector(InstanceHeader instance, String methodName) throws RepositoryErrorException {
        this.validateRepositoryIsActive(methodName);
        this.repositoryValidator.validateHomeMetadataGUID(this.repositoryName, instance, methodName);
        String instanceMetadataCollectionId = instance.getMetadataCollectionId();
        if (instanceMetadataCollectionId.equals(this.localMetadataCollectionId)) {
            return this.localConnector;
        }
        for (FederatedConnector remoteCohortConnector : this.remoteCohortConnectors) {
            if (remoteCohortConnector == null || !instanceMetadataCollectionId.equals(remoteCohortConnector.getMetadataCollectionId())) continue;
            return remoteCohortConnector.getConnector();
        }
        return null;
    }

    protected List<OMRSRepositoryConnector> getCohortConnectors(String methodName) throws RepositoryErrorException {
        this.validateRepositoryIsActive(methodName);
        ArrayList<OMRSRepositoryConnector> cohortConnectors = new ArrayList<OMRSRepositoryConnector>();
        if (this.localConnector != null) {
            cohortConnectors.add(this.localConnector);
        }
        for (FederatedConnector federatedConnector : this.remoteCohortConnectors) {
            cohortConnectors.add(federatedConnector.getConnector());
        }
        if (!cohortConnectors.isEmpty()) {
            return cohortConnectors;
        }
        OMRSErrorCode errorCode = OMRSErrorCode.NO_REPOSITORIES;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{this.accessServiceName});
        throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    EntitySummary processRetrievedEntitySummary(String sourceMetadataCollectionId, EntitySummary entity) {
        EntitySummary processedEntity = new EntitySummary(entity);
        if (processedEntity.getMetadataCollectionId() == null) {
            processedEntity.setMetadataCollectionId(this.metadataCollectionId);
        }
        if (this.localEventProcessor != null) {
            this.localEventProcessor.processRetrievedEntitySummary(this.localMetadataCollectionId, sourceMetadataCollectionId, processedEntity);
        }
        return processedEntity;
    }

    EntityDetail processRetrievedEntityDetail(String sourceMetadataCollectionId, EntityDetail entity) {
        EntityDetail processedEntity = new EntityDetail(entity);
        if (processedEntity.getMetadataCollectionId() == null) {
            processedEntity.setMetadataCollectionId(this.metadataCollectionId);
        }
        if (this.localEventProcessor != null) {
            this.localEventProcessor.processRetrievedEntityDetail(this.localMetadataCollectionId, sourceMetadataCollectionId, processedEntity);
        }
        return processedEntity;
    }

    List<EntityDetail> processRetrievedEntities(String sourceMetadataCollectionId, List<EntityDetail> entities) {
        ArrayList<EntityDetail> processedEntities = new ArrayList<EntityDetail>();
        for (EntityDetail entity : entities) {
            EntityDetail processedEntity = this.processRetrievedEntityDetail(sourceMetadataCollectionId, entity);
            if (processedEntity == null) continue;
            processedEntities.add(processedEntity);
        }
        return processedEntities;
    }

    public Relationship processRetrievedRelationship(String sourceMetadataCollectionId, Relationship relationship) {
        Relationship processedRelationship = new Relationship(relationship);
        if (processedRelationship.getMetadataCollectionId() == null) {
            processedRelationship.setMetadataCollectionId(this.metadataCollectionId);
        }
        if (this.localEventProcessor != null) {
            this.localEventProcessor.processRetrievedRelationship(this.localMetadataCollectionId, sourceMetadataCollectionId, processedRelationship);
        }
        return processedRelationship;
    }

    public List<Relationship> processRetrievedRelationships(String sourceMetadataCollectionId, List<Relationship> relationships) {
        ArrayList<Relationship> processedRelationships = new ArrayList<Relationship>();
        for (Relationship relationship : relationships) {
            Relationship processedRelationship = this.processRetrievedRelationship(sourceMetadataCollectionId, relationship);
            if (processedRelationship == null) continue;
            processedRelationships.add(processedRelationship);
        }
        return processedRelationships;
    }

    @Override
    public void setLocalConnector(String metadataCollectionId, LocalOMRSRepositoryConnector localConnector) {
        this.localMetadataCollectionId = metadataCollectionId;
        this.localConnector = localConnector;
        if (localConnector != null) {
            this.localEventProcessor = localConnector.getIncomingInstanceRetrievealEventProcessor();
        }
    }

    @Override
    public void addRemoteConnector(String metadataCollectionId, OMRSRepositoryConnector remoteConnector) {
        if (remoteConnector != null) {
            this.remoteCohortConnectors.add(new FederatedConnector(metadataCollectionId, remoteConnector));
        }
    }

    @Override
    public void removeRemoteConnector(String metadataCollectionId) {
        Iterator<FederatedConnector> iterator = this.remoteCohortConnectors.iterator();
        while (iterator.hasNext()) {
            FederatedConnector registeredConnector = iterator.next();
            if (!registeredConnector.getMetadataCollectionId().equals(metadataCollectionId)) continue;
            this.disconnectConnector(registeredConnector);
            iterator.remove();
        }
    }

    @Override
    public void disconnectAllConnectors() {
        try {
            super.disconnect();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.remoteCohortConnectors != null) {
            for (FederatedConnector remoteConnector : this.remoteCohortConnectors) {
                if (remoteConnector == null) continue;
                this.disconnectConnector(remoteConnector);
            }
        }
    }

    private void disconnectConnector(OMRSRepositoryConnector connector) {
        if (connector != null) {
            try {
                connector.disconnect();
            }
            catch (Throwable error) {
                log.error("Exception from disconnect of connector to metadata collection:" + connector.getMetadataCollectionId() + "  Error message was: " + error.getMessage());
            }
        }
    }

    private void disconnectConnector(FederatedConnector federatedConnector) {
        OMRSRepositoryConnector connector = null;
        if (federatedConnector != null) {
            connector = federatedConnector.getConnector();
        }
        if (connector != null) {
            this.disconnectConnector(connector);
        }
    }

    private class FederatedConnector {
        private String metadataCollectionId;
        private OMRSRepositoryConnector connector;

        public FederatedConnector(String metadataCollectionId, OMRSRepositoryConnector connector) {
            this.metadataCollectionId = metadataCollectionId;
            this.connector = connector;
        }

        public String getMetadataCollectionId() {
            return this.metadataCollectionId;
        }

        public OMRSRepositoryConnector getConnector() {
            return this.connector;
        }

        public OMRSMetadataCollection getMetadataCollection() {
            if (this.connector != null) {
                try {
                    return this.connector.getMetadataCollection();
                }
                catch (Throwable error) {
                    return null;
                }
            }
            return null;
        }
    }
}

