/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.eventmanagement;

import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditCode;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.eventmanagement.OMRSRepositoryEventBuilder;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSTypeDefEvent;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMRSRepositoryEventPublisher
extends OMRSRepositoryEventBuilder {
    private OMRSAuditLog auditLog;
    private static final Logger log = LoggerFactory.getLogger(OMRSRepositoryEventPublisher.class);
    private OMRSTopicConnector omrsTopicConnector;

    public OMRSRepositoryEventPublisher(String publisherName, OMRSTopicConnector topicConnector, OMRSAuditLog auditLog) {
        String actionDescription = "Initialize event publisher";
        this.auditLog = auditLog;
        if (topicConnector == null) {
            log.debug("Null topic connector");
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_TOPIC_CONNECTOR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{publisherName});
            throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), actionDescription, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        this.omrsTopicConnector = topicConnector;
        log.debug("New Event Publisher: " + publisherName);
    }

    public void sendTypeDefEvent(String sourceName, OMRSTypeDefEvent typeDefEvent) {
        String actionDescription = "Send TypeDef Event";
        log.debug("Sending typeDefEvent for cohort: " + sourceName);
        log.debug("topicConnector: " + this.omrsTopicConnector);
        log.debug("typeDefEvent: " + typeDefEvent);
        log.debug("localEventOriginator: " + typeDefEvent.getEventOriginator());
        try {
            this.omrsTopicConnector.sendTypeDefEvent(typeDefEvent);
        }
        catch (Throwable error) {
            OMRSAuditCode auditCode = OMRSAuditCode.SEND_TYPEDEF_EVENT_ERROR;
            this.auditLog.logException(actionDescription, auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{sourceName}), "typeDefEvent {" + typeDefEvent.toString() + "}", auditCode.getSystemAction(), auditCode.getUserAction(), error);
            log.debug("Exception: ", error);
        }
    }

    public void sendInstanceEvent(String sourceName, OMRSInstanceEvent instanceEvent) {
        String actionDescription = "Send Instance Event";
        log.debug("Sending instanceEvent for cohort: " + sourceName);
        log.debug("topicConnector: " + this.omrsTopicConnector);
        log.debug("instanceEvent: " + instanceEvent);
        log.debug("localEventOriginator: " + instanceEvent.getEventOriginator());
        try {
            this.omrsTopicConnector.sendInstanceEvent(instanceEvent);
        }
        catch (Throwable error) {
            OMRSAuditCode auditCode = OMRSAuditCode.SEND_INSTANCE_EVENT_ERROR;
            this.auditLog.logException(actionDescription, auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{sourceName}), "instanceEvent {" + instanceEvent.toString() + "}", auditCode.getSystemAction(), auditCode.getUserAction(), error);
            log.debug("Exception: ", error);
        }
    }
}

