/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.localrepository.repositoryconnector;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollectionBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceGraph;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefGallery;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryeventmapper.OMRSRepositoryEventProcessor;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.HomeEntityException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.HomeRelationshipException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidEntityException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidRelationshipException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidTypeDefException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PatchErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.StatusNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefInUseException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.localrepository.repositoryconnector.LocalOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.localrepository.repositorycontentmanager.OMRSTypeDefManager;

public class LocalOMRSMetadataCollection
extends OMRSMetadataCollectionBase {
    private OMRSMetadataCollection realMetadataCollection;
    private String localServerName;
    private String localServerType;
    private String localOrganizationName;
    private OMRSRepositoryEventProcessor outboundRepositoryEventProcessor;
    private OMRSTypeDefManager localTypeDefManager;

    LocalOMRSMetadataCollection(LocalOMRSRepositoryConnector parentConnector, String repositoryName, OMRSRepositoryHelper repositoryHelper, OMRSRepositoryValidator repositoryValidator, String metadataCollectionId, String localServerName, String localServerType, String localOrganizationName, OMRSMetadataCollection realMetadataCollection, OMRSRepositoryEventProcessor outboundRepositoryEventProcessor, OMRSTypeDefManager typeDefManager) {
        super((OMRSRepositoryConnector)parentConnector, repositoryName, repositoryHelper, repositoryValidator, metadataCollectionId);
        if (realMetadataCollection == null) {
            String actionDescription = "Local OMRS Metadata Collection Constructor";
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_LOCAL_METADATA_COLLECTION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[0]);
            throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "Local OMRS Metadata Collection Constructor", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        this.realMetadataCollection = realMetadataCollection;
        this.localServerName = localServerName;
        this.localServerType = localServerType;
        this.localOrganizationName = localOrganizationName;
        this.outboundRepositoryEventProcessor = outboundRepositoryEventProcessor;
        this.localTypeDefManager = typeDefManager;
    }

    public TypeDefGallery getAllTypes(String userId) throws RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "getAllTypes";
        this.validateRepositoryConnector("getAllTypes");
        this.parentConnector.validateRepositoryIsActive("getAllTypes");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "getAllTypes");
        return this.realMetadataCollection.getAllTypes(userId);
    }

    public TypeDefGallery findTypesByName(String userId, String name) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "findTypesByName";
        String nameParameterName = "name";
        this.validateRepositoryConnector("findTypesByName");
        this.parentConnector.validateRepositoryIsActive("findTypesByName");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "findTypesByName");
        this.repositoryValidator.validateTypeName(this.repositoryName, "name", name, "findTypesByName");
        return this.realMetadataCollection.findTypesByName(userId, name);
    }

    public List<TypeDef> findTypeDefsByCategory(String userId, TypeDefCategory category) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "findTypeDefsByCategory";
        String categoryParameterName = "category";
        this.validateRepositoryConnector("findTypeDefsByCategory");
        this.parentConnector.validateRepositoryIsActive("findTypeDefsByCategory");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "findTypeDefsByCategory");
        this.repositoryValidator.validateTypeDefCategory(this.repositoryName, "category", category, "findTypeDefsByCategory");
        return this.realMetadataCollection.findTypeDefsByCategory(userId, category);
    }

    public List<AttributeTypeDef> findAttributeTypeDefsByCategory(String userId, AttributeTypeDefCategory category) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "findAttributeTypeDefsByCategory";
        String categoryParameterName = "category";
        this.validateRepositoryConnector("findAttributeTypeDefsByCategory");
        this.parentConnector.validateRepositoryIsActive("findAttributeTypeDefsByCategory");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "findAttributeTypeDefsByCategory");
        this.repositoryValidator.validateAttributeTypeDefCategory(this.repositoryName, "category", category, "findAttributeTypeDefsByCategory");
        return this.realMetadataCollection.findAttributeTypeDefsByCategory(userId, category);
    }

    public List<TypeDef> findTypeDefsByProperty(String userId, TypeDefProperties matchCriteria) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "findTypeDefsByProperty";
        String matchCriteriaParameterName = "matchCriteria";
        this.validateRepositoryConnector("findTypeDefsByProperty");
        this.parentConnector.validateRepositoryIsActive("findTypeDefsByProperty");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "findTypeDefsByProperty");
        this.repositoryValidator.validateMatchCriteria(this.repositoryName, "matchCriteria", matchCriteria, "findTypeDefsByProperty");
        return this.realMetadataCollection.findTypeDefsByProperty(userId, matchCriteria);
    }

    public List<TypeDef> findTypesByExternalID(String userId, String standard, String organization, String identifier) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "findTypesByExternalID";
        this.validateRepositoryConnector("findTypesByExternalID");
        this.parentConnector.validateRepositoryIsActive("findTypesByExternalID");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "findTypesByExternalID");
        this.repositoryValidator.validateExternalId(this.repositoryName, standard, organization, identifier, "findTypesByExternalID");
        return this.realMetadataCollection.findTypesByExternalID(userId, standard, organization, identifier);
    }

    public List<TypeDef> searchForTypeDefs(String userId, String searchCriteria) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "searchForTypeDefs";
        String searchCriteriaParameterName = "searchCriteria";
        this.validateRepositoryConnector("searchForTypeDefs");
        this.parentConnector.validateRepositoryIsActive("searchForTypeDefs");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "searchForTypeDefs");
        this.repositoryValidator.validateSearchCriteria(this.repositoryName, "searchCriteria", searchCriteria, "searchForTypeDefs");
        return this.realMetadataCollection.searchForTypeDefs(userId, searchCriteria);
    }

    public TypeDef getTypeDefByGUID(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException {
        String methodName = "getTypeDefByGUID";
        String guidParameterName = "guid";
        this.validateRepositoryConnector("getTypeDefByGUID");
        this.parentConnector.validateRepositoryIsActive("getTypeDefByGUID");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "getTypeDefByGUID");
        this.repositoryValidator.validateGUID(this.repositoryName, "guid", guid, "getTypeDefByGUID");
        return this.realMetadataCollection.getTypeDefByGUID(userId, guid);
    }

    public AttributeTypeDef getAttributeTypeDefByGUID(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException {
        String methodName = "getAttributeTypeDefByGUID";
        String guidParameterName = "guid";
        this.validateRepositoryConnector("getAttributeTypeDefByGUID");
        this.parentConnector.validateRepositoryIsActive("getAttributeTypeDefByGUID");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "getAttributeTypeDefByGUID");
        this.repositoryValidator.validateGUID(this.repositoryName, "guid", guid, "getAttributeTypeDefByGUID");
        return this.realMetadataCollection.getAttributeTypeDefByGUID(userId, guid);
    }

    public TypeDef getTypeDefByName(String userId, String name) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException {
        String methodName = "getTypeDefByName";
        String nameParameterName = "name";
        this.validateRepositoryConnector("getTypeDefByName");
        this.parentConnector.validateRepositoryIsActive("getTypeDefByName");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "getTypeDefByName");
        this.repositoryValidator.validateTypeName(this.repositoryName, "name", name, "getTypeDefByName");
        return this.realMetadataCollection.getTypeDefByName(userId, name);
    }

    public AttributeTypeDef getAttributeTypeDefByName(String userId, String name) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException {
        String methodName = "getAttributeTypeDefByName";
        String nameParameterName = "name";
        this.validateRepositoryConnector("getAttributeTypeDefByName");
        this.parentConnector.validateRepositoryIsActive("getAttributeTypeDefByName");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "getAttributeTypeDefByName");
        this.repositoryValidator.validateTypeName(this.repositoryName, "name", name, "getAttributeTypeDefByName");
        return this.realMetadataCollection.getAttributeTypeDefByName(userId, name);
    }

    public void addTypeDefGallery(String userId, TypeDefGallery newTypes) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefKnownException, TypeDefConflictException, InvalidTypeDefException, FunctionNotSupportedException, UserNotAuthorizedException {
        ArrayList typeDefs;
        String methodName = "addTypeDefGallery";
        String galleryParameterName = "newTypes";
        this.validateRepositoryConnector("addTypeDefGallery");
        this.parentConnector.validateRepositoryIsActive("addTypeDefGallery");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "addTypeDefGallery");
        this.repositoryValidator.validateTypeDefGallery(this.repositoryName, "newTypes", newTypes, "addTypeDefGallery");
        List attributeTypeDefs = newTypes.getAttributeTypeDefs();
        if (attributeTypeDefs != null) {
            for (AttributeTypeDef attributeTypeDef : attributeTypeDefs) {
                this.addAttributeTypeDef(userId, attributeTypeDef);
            }
        }
        if ((typeDefs = newTypes.getTypeDefs()) != null) {
            for (TypeDef typeDef : typeDefs) {
                this.addTypeDef(userId, typeDef);
            }
        }
    }

    public void addTypeDef(String userId, TypeDef newTypeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefKnownException, TypeDefConflictException, InvalidTypeDefException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "addTypeDef";
        String typeDefParameterName = "newTypeDef";
        this.validateRepositoryConnector("addTypeDef");
        this.parentConnector.validateRepositoryIsActive("addTypeDef");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "addTypeDef");
        this.repositoryValidator.validateTypeDef(this.repositoryName, "newTypeDef", newTypeDef, "addTypeDef");
        this.repositoryValidator.validateUnknownTypeDef(this.repositoryName, "newTypeDef", newTypeDef, "addTypeDef");
        this.realMetadataCollection.addTypeDef(userId, newTypeDef);
        if (this.localTypeDefManager != null) {
            this.localTypeDefManager.addTypeDef(this.repositoryName, newTypeDef);
        }
        if (this.outboundRepositoryEventProcessor != null) {
            this.outboundRepositoryEventProcessor.processNewTypeDefEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, newTypeDef);
        }
    }

    public void addAttributeTypeDef(String userId, AttributeTypeDef newAttributeTypeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefKnownException, TypeDefConflictException, InvalidTypeDefException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "addAttributeTypeDef";
        String typeDefParameterName = "newAttributeTypeDef";
        this.validateRepositoryConnector("addAttributeTypeDef");
        this.parentConnector.validateRepositoryIsActive("addAttributeTypeDef");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "addAttributeTypeDef");
        this.repositoryValidator.validateAttributeTypeDef(this.repositoryName, "newAttributeTypeDef", newAttributeTypeDef, "addAttributeTypeDef");
        this.repositoryValidator.validateUnknownAttributeTypeDef(this.repositoryName, "newAttributeTypeDef", newAttributeTypeDef, "addAttributeTypeDef");
        this.realMetadataCollection.addAttributeTypeDef(userId, newAttributeTypeDef);
        if (this.localTypeDefManager != null) {
            this.localTypeDefManager.addAttributeTypeDef(this.repositoryName, newAttributeTypeDef);
        }
        if (this.outboundRepositoryEventProcessor != null) {
            this.outboundRepositoryEventProcessor.processNewAttributeTypeDefEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, newAttributeTypeDef);
        }
    }

    public boolean verifyTypeDef(String userId, TypeDef typeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefConflictException, InvalidTypeDefException, UserNotAuthorizedException {
        String methodName = "verifyTypeDef";
        String typeDefParameterName = "typeDef";
        this.validateRepositoryConnector("verifyTypeDef");
        this.parentConnector.validateRepositoryIsActive("verifyTypeDef");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "verifyTypeDef");
        this.repositoryValidator.validateTypeDef(this.repositoryName, "typeDef", typeDef, "verifyTypeDef");
        return this.realMetadataCollection.verifyTypeDef(userId, typeDef);
    }

    public boolean verifyAttributeTypeDef(String userId, AttributeTypeDef attributeTypeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefConflictException, InvalidTypeDefException, UserNotAuthorizedException {
        String methodName = "verifyAttributeTypeDef";
        String typeDefParameterName = "attributeTypeDef";
        this.validateRepositoryConnector("verifyAttributeTypeDef");
        this.parentConnector.validateRepositoryIsActive("verifyAttributeTypeDef");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "verifyAttributeTypeDef");
        this.repositoryValidator.validateAttributeTypeDef(this.repositoryName, "attributeTypeDef", attributeTypeDef, "verifyAttributeTypeDef");
        return this.realMetadataCollection.verifyAttributeTypeDef(userId, attributeTypeDef);
    }

    public TypeDef updateTypeDef(String userId, TypeDefPatch typeDefPatch) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, PatchErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "updateTypeDef";
        this.validateRepositoryConnector("updateTypeDef");
        this.parentConnector.validateRepositoryIsActive("updateTypeDef");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "updateTypeDef");
        this.repositoryValidator.validateTypeDefPatch(this.repositoryName, typeDefPatch, "updateTypeDef");
        TypeDef updatedTypeDef = this.realMetadataCollection.updateTypeDef(userId, typeDefPatch);
        if (this.localTypeDefManager != null) {
            this.localTypeDefManager.updateTypeDef(this.repositoryName, updatedTypeDef);
        }
        if (this.outboundRepositoryEventProcessor != null) {
            this.outboundRepositoryEventProcessor.processUpdatedTypeDefEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, typeDefPatch);
        }
        return updatedTypeDef;
    }

    public void deleteTypeDef(String userId, String obsoleteTypeDefGUID, String obsoleteTypeDefName) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, TypeDefInUseException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "deleteTypeDef";
        String guidParameterName = "obsoleteTypeDefGUID";
        String nameParameterName = "obsoleteTypeDefName";
        this.validateRepositoryConnector("deleteTypeDef");
        this.parentConnector.validateRepositoryIsActive("deleteTypeDef");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "deleteTypeDef");
        this.repositoryValidator.validateTypeDefIds(this.repositoryName, "obsoleteTypeDefGUID", "obsoleteTypeDefName", obsoleteTypeDefGUID, obsoleteTypeDefName, "deleteTypeDef");
        this.realMetadataCollection.deleteTypeDef(userId, obsoleteTypeDefGUID, obsoleteTypeDefName);
        if (this.localTypeDefManager != null) {
            this.localTypeDefManager.deleteTypeDef(this.repositoryName, obsoleteTypeDefGUID, obsoleteTypeDefName);
        }
        if (this.outboundRepositoryEventProcessor != null) {
            this.outboundRepositoryEventProcessor.processDeletedTypeDefEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, obsoleteTypeDefGUID, obsoleteTypeDefName);
        }
    }

    public void deleteAttributeTypeDef(String userId, String obsoleteTypeDefGUID, String obsoleteTypeDefName) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, TypeDefInUseException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "deleteAttributeTypeDef";
        String guidParameterName = "obsoleteTypeDefGUID";
        String nameParameterName = "obsoleteTypeDefName";
        this.validateRepositoryConnector("deleteAttributeTypeDef");
        this.parentConnector.validateRepositoryIsActive("deleteAttributeTypeDef");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "deleteAttributeTypeDef");
        this.repositoryValidator.validateAttributeTypeDefIds(this.repositoryName, "obsoleteTypeDefGUID", "obsoleteTypeDefName", obsoleteTypeDefGUID, obsoleteTypeDefName, "deleteAttributeTypeDef");
        this.realMetadataCollection.deleteAttributeTypeDef(userId, obsoleteTypeDefGUID, obsoleteTypeDefName);
        if (this.localTypeDefManager != null) {
            this.localTypeDefManager.deleteAttributeTypeDef(this.repositoryName, obsoleteTypeDefGUID, obsoleteTypeDefName);
        }
        if (this.outboundRepositoryEventProcessor != null) {
            this.outboundRepositoryEventProcessor.processDeletedAttributeTypeDefEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, obsoleteTypeDefGUID, obsoleteTypeDefName);
        }
    }

    public TypeDef reIdentifyTypeDef(String userId, String originalTypeDefGUID, String originalTypeDefName, String newTypeDefGUID, String newTypeDefName) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "reIdentifyTypeDef";
        String originalGUIDParameterName = "originalTypeDefGUID";
        String originalNameParameterName = "originalTypeDefName";
        String newGUIDParameterName = "newTypeDefGUID";
        String newNameParameterName = "newTypeDefName";
        this.validateRepositoryConnector("reIdentifyTypeDef");
        this.parentConnector.validateRepositoryIsActive("reIdentifyTypeDef");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "reIdentifyTypeDef");
        this.repositoryValidator.validateTypeDefIds(this.repositoryName, "originalTypeDefGUID", "originalTypeDefName", originalTypeDefGUID, originalTypeDefName, "reIdentifyTypeDef");
        this.repositoryValidator.validateTypeDefIds(this.repositoryName, "newTypeDefGUID", "newTypeDefName", newTypeDefGUID, newTypeDefName, "reIdentifyTypeDef");
        TypeDef originalTypeDef = this.realMetadataCollection.getTypeDefByGUID(userId, originalTypeDefGUID);
        TypeDef newTypeDef = this.realMetadataCollection.reIdentifyTypeDef(userId, originalTypeDefGUID, originalTypeDefName, newTypeDefGUID, newTypeDefName);
        if (this.localTypeDefManager != null) {
            this.localTypeDefManager.reIdentifyTypeDef(this.repositoryName, originalTypeDefGUID, originalTypeDefName, newTypeDef);
        }
        if (this.outboundRepositoryEventProcessor != null) {
            this.outboundRepositoryEventProcessor.processReIdentifiedTypeDefEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, (TypeDefSummary)originalTypeDef, newTypeDef);
        }
        return newTypeDef;
    }

    public AttributeTypeDef reIdentifyAttributeTypeDef(String userId, String originalAttributeTypeDefGUID, String originalAttributeTypeDefName, String newAttributeTypeDefGUID, String newAttributeTypeDefName) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "reIdentifyAttributeTypeDef";
        String originalGUIDParameterName = "originalAttributeTypeDefGUID";
        String originalNameParameterName = "originalAttributeTypeDefName";
        String newGUIDParameterName = "newAttributeTypeDefGUID";
        String newNameParameterName = "newAttributeTypeDefName";
        this.validateRepositoryConnector("reIdentifyAttributeTypeDef");
        this.parentConnector.validateRepositoryIsActive("reIdentifyAttributeTypeDef");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "reIdentifyAttributeTypeDef");
        this.repositoryValidator.validateTypeDefIds(this.repositoryName, "originalAttributeTypeDefGUID", "originalAttributeTypeDefName", originalAttributeTypeDefGUID, originalAttributeTypeDefName, "reIdentifyAttributeTypeDef");
        this.repositoryValidator.validateTypeDefIds(this.repositoryName, "newAttributeTypeDefGUID", "newAttributeTypeDefName", newAttributeTypeDefGUID, newAttributeTypeDefName, "reIdentifyAttributeTypeDef");
        AttributeTypeDef originalAttributeTypeDef = this.realMetadataCollection.getAttributeTypeDefByGUID(userId, originalAttributeTypeDefGUID);
        AttributeTypeDef newAttributeTypeDef = this.realMetadataCollection.reIdentifyAttributeTypeDef(userId, originalAttributeTypeDefGUID, originalAttributeTypeDefName, newAttributeTypeDefGUID, newAttributeTypeDefName);
        if (this.localTypeDefManager != null) {
            this.localTypeDefManager.reIdentifyAttributeTypeDef(this.repositoryName, originalAttributeTypeDefGUID, originalAttributeTypeDefName, newAttributeTypeDef);
        }
        if (this.outboundRepositoryEventProcessor != null) {
            this.outboundRepositoryEventProcessor.processReIdentifiedAttributeTypeDefEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, originalAttributeTypeDef, newAttributeTypeDef);
        }
        return newAttributeTypeDef;
    }

    private void setLocalProvenance(InstanceAuditHeader instance) {
        if (instance != null) {
            if (instance.getMetadataCollectionId() == null) {
                instance.setMetadataCollectionId(this.metadataCollectionId);
                instance.setInstanceProvenanceType(InstanceProvenanceType.LOCAL_COHORT);
            }
            if (instance.getMetadataCollectionName() == null && this.metadataCollectionId.equals(instance.getMetadataCollectionId())) {
                instance.setMetadataCollectionName(this.metadataCollectionName);
            }
        }
    }

    private List<EntityDetail> setLocalProvenanceInEntityList(List<EntityDetail> instanceList) {
        if (instanceList == null || instanceList.isEmpty()) {
            return null;
        }
        ArrayList<EntityDetail> resultList = new ArrayList<EntityDetail>();
        for (EntityDetail entity : instanceList) {
            if (entity == null) continue;
            this.setLocalProvenance((InstanceAuditHeader)entity);
            resultList.add(entity);
        }
        return resultList;
    }

    private List<Relationship> setLocalProvenanceInRelationshipList(List<Relationship> instanceList) {
        if (instanceList == null || instanceList.isEmpty()) {
            return null;
        }
        ArrayList<Relationship> resultList = new ArrayList<Relationship>();
        for (Relationship entity : instanceList) {
            if (entity == null) continue;
            this.setLocalProvenance((InstanceAuditHeader)entity);
            resultList.add(entity);
        }
        return resultList;
    }

    private InstanceGraph setLocalProvenanceInGraph(InstanceGraph instanceGraph) {
        InstanceGraph resultGraph = new InstanceGraph();
        resultGraph.setEntities(this.setLocalProvenanceInEntityList(instanceGraph.getEntities()));
        resultGraph.setRelationships(this.setLocalProvenanceInRelationshipList(instanceGraph.getRelationships()));
        return resultGraph;
    }

    public EntityDetail isEntityKnown(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "isEntityKnown";
        super.getInstanceParameterValidation(userId, guid, "isEntityKnown");
        EntityDetail entity = this.realMetadataCollection.isEntityKnown(userId, guid);
        this.setLocalProvenance((InstanceAuditHeader)entity);
        return entity;
    }

    public EntitySummary getEntitySummary(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, UserNotAuthorizedException {
        String methodName = "getEntitySummary";
        super.getInstanceParameterValidation(userId, guid, "getEntitySummary");
        EntitySummary entity = this.realMetadataCollection.getEntitySummary(userId, guid);
        this.setLocalProvenance((InstanceAuditHeader)entity);
        return entity;
    }

    public EntityDetail getEntityDetail(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityProxyOnlyException, UserNotAuthorizedException {
        String methodName = "getEntityDetail";
        super.getInstanceParameterValidation(userId, guid, "getEntityDetail");
        EntityDetail entity = this.realMetadataCollection.getEntityDetail(userId, guid);
        this.setLocalProvenance((InstanceAuditHeader)entity);
        return entity;
    }

    public EntityDetail getEntityDetail(String userId, String guid, Date asOfTime) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityProxyOnlyException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getEntityDetail";
        super.getInstanceParameterValidation(userId, guid, asOfTime, "getEntityDetail");
        EntityDetail entity = this.realMetadataCollection.getEntityDetail(userId, guid, asOfTime);
        this.setLocalProvenance((InstanceAuditHeader)entity);
        return entity;
    }

    public List<Relationship> getRelationshipsForEntity(String userId, String entityGUID, String relationshipTypeGUID, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        super.getRelationshipsForEntityParameterValidation(userId, entityGUID, relationshipTypeGUID, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        List resultList = this.realMetadataCollection.getRelationshipsForEntity(userId, entityGUID, relationshipTypeGUID, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        return this.setLocalProvenanceInRelationshipList(resultList);
    }

    public List<EntityDetail> findEntitiesByProperty(String userId, String entityTypeGUID, InstanceProperties matchProperties, MatchCriteria matchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        super.findEntitiesByPropertyParameterValidation(userId, entityTypeGUID, matchProperties, matchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        List resultList = this.realMetadataCollection.findEntitiesByProperty(userId, entityTypeGUID, matchProperties, matchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        return this.setLocalProvenanceInEntityList(resultList);
    }

    public List<EntityDetail> findEntitiesByClassification(String userId, String entityTypeGUID, String classificationName, InstanceProperties matchClassificationProperties, MatchCriteria matchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, ClassificationErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        super.findEntitiesByClassificationParameterValidation(userId, entityTypeGUID, classificationName, matchClassificationProperties, matchCriteria, fromEntityElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        List resultList = this.realMetadataCollection.findEntitiesByClassification(userId, entityTypeGUID, classificationName, matchClassificationProperties, matchCriteria, fromEntityElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        return this.setLocalProvenanceInEntityList(resultList);
    }

    public List<EntityDetail> findEntitiesByPropertyValue(String userId, String entityTypeGUID, String searchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        super.findEntitiesByPropertyValueParameterValidation(userId, entityTypeGUID, searchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        List resultList = this.realMetadataCollection.findEntitiesByPropertyValue(userId, entityTypeGUID, searchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        return this.setLocalProvenanceInEntityList(resultList);
    }

    public Relationship isRelationshipKnown(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "isRelationshipKnown";
        super.getInstanceParameterValidation(userId, guid, "isRelationshipKnown");
        Relationship relationship = this.realMetadataCollection.isRelationshipKnown(userId, guid);
        this.setLocalProvenance((InstanceAuditHeader)relationship);
        return relationship;
    }

    public Relationship getRelationship(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, UserNotAuthorizedException {
        String methodName = "getRelationship";
        super.getInstanceParameterValidation(userId, guid, "getRelationship");
        Relationship relationship = this.realMetadataCollection.getRelationship(userId, guid);
        this.setLocalProvenance((InstanceAuditHeader)relationship);
        return relationship;
    }

    public Relationship getRelationship(String userId, String guid, Date asOfTime) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getRelationship";
        super.getInstanceParameterValidation(userId, guid, asOfTime, "getRelationship");
        Relationship relationship = this.realMetadataCollection.getRelationship(userId, guid, asOfTime);
        this.setLocalProvenance((InstanceAuditHeader)relationship);
        return relationship;
    }

    public List<Relationship> findRelationshipsByProperty(String userId, String relationshipTypeGUID, InstanceProperties matchProperties, MatchCriteria matchCriteria, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        super.findRelationshipsByPropertyParameterValidation(userId, relationshipTypeGUID, matchProperties, matchCriteria, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        List resultList = this.realMetadataCollection.findRelationshipsByProperty(userId, relationshipTypeGUID, matchProperties, matchCriteria, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        return this.setLocalProvenanceInRelationshipList(resultList);
    }

    public List<Relationship> findRelationshipsByPropertyValue(String userId, String relationshipTypeGUID, String searchCriteria, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        super.findRelationshipsByPropertyValueParameterValidation(userId, relationshipTypeGUID, searchCriteria, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        List resultList = this.realMetadataCollection.findRelationshipsByPropertyValue(userId, relationshipTypeGUID, searchCriteria, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        return this.setLocalProvenanceInRelationshipList(resultList);
    }

    public InstanceGraph getLinkingEntities(String userId, String startEntityGUID, String endEntityGUID, List<InstanceStatus> limitResultsByStatus, Date asOfTime) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        super.getLinkingEntitiesParameterValidation(userId, startEntityGUID, endEntityGUID, limitResultsByStatus, asOfTime);
        InstanceGraph resultGraph = this.realMetadataCollection.getLinkingEntities(userId, startEntityGUID, endEntityGUID, limitResultsByStatus, asOfTime);
        return this.setLocalProvenanceInGraph(resultGraph);
    }

    public InstanceGraph getEntityNeighborhood(String userId, String entityGUID, List<String> entityTypeGUIDs, List<String> relationshipTypeGUIDs, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, int level) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getEntityNeighborhood";
        super.getEntityNeighborhoodParameterValidation(userId, entityGUID, entityTypeGUIDs, relationshipTypeGUIDs, limitResultsByStatus, limitResultsByClassification, asOfTime, level);
        this.validateRepositoryConnector("getEntityNeighborhood");
        InstanceGraph resultGraph = this.realMetadataCollection.getEntityNeighborhood(userId, entityGUID, entityTypeGUIDs, relationshipTypeGUIDs, limitResultsByStatus, limitResultsByClassification, asOfTime, level);
        return this.setLocalProvenanceInGraph(resultGraph);
    }

    public List<EntityDetail> getRelatedEntities(String userId, String startEntityGUID, List<String> entityTypeGUIDs, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getRelatedEntities";
        super.getRelatedEntitiesParameterValidation(userId, startEntityGUID, entityTypeGUIDs, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        this.validateRepositoryConnector("getRelatedEntities");
        List resultList = this.realMetadataCollection.getRelatedEntities(userId, startEntityGUID, entityTypeGUIDs, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        return this.setLocalProvenanceInEntityList(resultList);
    }

    public EntityDetail addEntity(String userId, String entityTypeGUID, InstanceProperties initialProperties, List<Classification> initialClassifications, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, ClassificationErrorException, StatusNotSupportedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "addEntity";
        String entityGUIDParameterName = "entityTypeGUID";
        String propertiesParameterName = "initialProperties";
        String classificationsParameterName = "initialClassifications";
        String initialStatusParameterName = "initialStatus";
        this.validateRepositoryConnector("addEntity");
        this.parentConnector.validateRepositoryIsActive("addEntity");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "addEntity");
        this.repositoryValidator.validateTypeGUID(this.repositoryName, "entityTypeGUID", entityTypeGUID, "addEntity");
        TypeDef typeDef = this.repositoryHelper.getTypeDef(this.repositoryName, "entityTypeGUID", entityTypeGUID, "addEntity");
        this.repositoryValidator.validateTypeDefForInstance(this.repositoryName, "entityTypeGUID", typeDef, "addEntity");
        this.repositoryValidator.validateClassificationList(this.repositoryName, "initialClassifications", initialClassifications, typeDef.getName(), "addEntity");
        this.repositoryValidator.validatePropertiesForType(this.repositoryName, "initialProperties", typeDef, initialProperties, "addEntity");
        this.repositoryValidator.validateInstanceStatus(this.repositoryName, "initialStatus", initialStatus, typeDef, "addEntity");
        EntityDetail entity = this.realMetadataCollection.addEntity(userId, entityTypeGUID, initialProperties, initialClassifications, initialStatus);
        if (entity != null) {
            this.setLocalProvenance((InstanceAuditHeader)entity);
            if (this.outboundRepositoryEventProcessor != null) {
                this.outboundRepositoryEventProcessor.processNewEntityEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, entity);
            }
        }
        return entity;
    }

    public void addEntityProxy(String userId, EntityProxy entityProxy) throws InvalidParameterException, RepositoryErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "addEntityProxy";
        String proxyParameterName = "entityProxy";
        this.validateRepositoryConnector("addEntityProxy");
        this.parentConnector.validateRepositoryIsActive("addEntityProxy");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "addEntityProxy");
        this.repositoryValidator.validateEntityProxy(this.repositoryName, this.metadataCollectionId, "entityProxy", entityProxy, "addEntityProxy");
        this.realMetadataCollection.addEntityProxy(userId, entityProxy);
    }

    public EntityDetail updateEntityStatus(String userId, String entityGUID, InstanceStatus newStatus) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, StatusNotSupportedException, FunctionNotSupportedException, UserNotAuthorizedException {
        EntityDetail currentEntity;
        String methodName = "updateEntityStatus";
        String entityGUIDParameterName = "entityGUID";
        this.validateRepositoryConnector("updateEntityStatus");
        this.parentConnector.validateRepositoryIsActive("updateEntityStatus");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "updateEntityStatus");
        this.repositoryValidator.validateGUID(this.repositoryName, "entityGUID", entityGUID, "updateEntityStatus");
        try {
            currentEntity = this.realMetadataCollection.getEntityDetail(userId, entityGUID);
        }
        catch (EntityProxyOnlyException error) {
            OMRSErrorCode errorCode = OMRSErrorCode.ENTITY_PROXY_IN_HOME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{this.repositoryName, entityGUID, "updateEntityStatus"});
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "updateEntityStatus", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), (Throwable)error);
        }
        EntityDetail newEntity = this.realMetadataCollection.updateEntityStatus(userId, entityGUID, newStatus);
        this.setLocalProvenance((InstanceAuditHeader)newEntity);
        this.notifyOfUpdatedEntity(currentEntity, newEntity);
        return newEntity;
    }

    public EntityDetail updateEntityProperties(String userId, String entityGUID, InstanceProperties properties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        EntityDetail currentEntity;
        String methodName = "updateEntityProperties";
        String entityGUIDParameterName = "entityGUID";
        this.validateRepositoryConnector("updateEntityProperties");
        this.parentConnector.validateRepositoryIsActive("updateEntityProperties");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "updateEntityProperties");
        this.repositoryValidator.validateGUID(this.repositoryName, "entityGUID", entityGUID, "updateEntityProperties");
        try {
            currentEntity = this.realMetadataCollection.getEntityDetail(userId, entityGUID);
        }
        catch (EntityProxyOnlyException error) {
            OMRSErrorCode errorCode = OMRSErrorCode.ENTITY_PROXY_IN_HOME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{this.repositoryName, entityGUID, "updateEntityProperties"});
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "updateEntityProperties", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), (Throwable)error);
        }
        EntityDetail newEntity = this.realMetadataCollection.updateEntityProperties(userId, entityGUID, properties);
        this.setLocalProvenance((InstanceAuditHeader)newEntity);
        this.notifyOfUpdatedEntity(currentEntity, newEntity);
        return newEntity;
    }

    private void notifyOfUpdatedEntity(EntityDetail oldEntity, EntityDetail newEntity) {
        if (newEntity != null && this.outboundRepositoryEventProcessor != null) {
            this.outboundRepositoryEventProcessor.processUpdatedEntityEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, oldEntity, newEntity);
        }
    }

    public EntityDetail undoEntityUpdate(String userId, String entityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "undoEntityUpdate";
        String entityGUIDParameterName = "entityGUID";
        this.validateRepositoryConnector("undoEntityUpdate");
        this.parentConnector.validateRepositoryIsActive("undoEntityUpdate");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "undoEntityUpdate");
        this.repositoryValidator.validateGUID(this.repositoryName, "entityGUID", entityGUID, "undoEntityUpdate");
        EntityDetail entity = this.realMetadataCollection.undoEntityUpdate(userId, entityGUID);
        if (entity != null) {
            this.setLocalProvenance((InstanceAuditHeader)entity);
            if (this.outboundRepositoryEventProcessor != null) {
                this.outboundRepositoryEventProcessor.processUndoneEntityEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, entity);
            }
        }
        return entity;
    }

    public EntityDetail deleteEntity(String userId, String typeDefGUID, String typeDefName, String obsoleteEntityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "deleteEntity";
        String typeDefGUIDParameterName = "typeDefGUID";
        String typeDefNameParameterName = "typeDefName";
        String entityGUIDParameterName = "obsoleteEntityGUID";
        this.validateRepositoryConnector("deleteEntity");
        this.parentConnector.validateRepositoryIsActive("deleteEntity");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "deleteEntity");
        this.repositoryValidator.validateTypeDefIds(this.repositoryName, "typeDefGUID", "typeDefName", typeDefGUID, typeDefName, "deleteEntity");
        this.repositoryValidator.validateGUID(this.repositoryName, "obsoleteEntityGUID", obsoleteEntityGUID, "deleteEntity");
        EntityDetail entity = this.realMetadataCollection.deleteEntity(userId, typeDefGUID, typeDefName, obsoleteEntityGUID);
        if (this.outboundRepositoryEventProcessor != null) {
            this.setLocalProvenance((InstanceAuditHeader)entity);
            this.outboundRepositoryEventProcessor.processDeletedEntityEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, entity);
        }
        return entity;
    }

    public void purgeEntity(String userId, String typeDefGUID, String typeDefName, String deletedEntityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityNotDeletedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "purgeEntity";
        String typeDefGUIDParameterName = "typeDefGUID";
        String typeDefNameParameterName = "typeDefName";
        String entityGUIDParameterName = "deletedEntityGUID";
        this.validateRepositoryConnector("purgeEntity");
        this.parentConnector.validateRepositoryIsActive("purgeEntity");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "purgeEntity");
        this.repositoryValidator.validateTypeDefIds(this.repositoryName, "typeDefGUID", "typeDefName", typeDefGUID, typeDefName, "purgeEntity");
        this.repositoryValidator.validateGUID(this.repositoryName, "deletedEntityGUID", deletedEntityGUID, "purgeEntity");
        this.realMetadataCollection.purgeEntity(userId, typeDefGUID, typeDefName, deletedEntityGUID);
        if (this.outboundRepositoryEventProcessor != null) {
            this.outboundRepositoryEventProcessor.processPurgedEntityEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, typeDefGUID, typeDefName, deletedEntityGUID);
        }
    }

    public EntityDetail restoreEntity(String userId, String deletedEntityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityNotDeletedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "restoreEntity";
        String entityGUIDParameterName = "deletedEntityGUID";
        this.validateRepositoryConnector("restoreEntity");
        this.parentConnector.validateRepositoryIsActive("restoreEntity");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "restoreEntity");
        this.repositoryValidator.validateGUID(this.repositoryName, "deletedEntityGUID", deletedEntityGUID, "restoreEntity");
        EntityDetail entity = this.realMetadataCollection.restoreEntity(userId, deletedEntityGUID);
        if (entity != null) {
            this.setLocalProvenance((InstanceAuditHeader)entity);
            if (this.outboundRepositoryEventProcessor != null) {
                this.outboundRepositoryEventProcessor.processRestoredEntityEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, entity);
            }
        }
        return entity;
    }

    public EntityDetail classifyEntity(String userId, String entityGUID, String classificationName, InstanceProperties classificationProperties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "classifyEntity";
        String entityGUIDParameterName = "entityGUID";
        this.validateRepositoryConnector("classifyEntity");
        this.parentConnector.validateRepositoryIsActive("classifyEntity");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "classifyEntity");
        this.repositoryValidator.validateGUID(this.repositoryName, "entityGUID", entityGUID, "classifyEntity");
        EntityDetail entity = this.realMetadataCollection.classifyEntity(userId, entityGUID, classificationName, classificationProperties);
        if (entity != null) {
            this.setLocalProvenance((InstanceAuditHeader)entity);
            if (this.outboundRepositoryEventProcessor != null) {
                this.outboundRepositoryEventProcessor.processClassifiedEntityEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, entity);
            }
        }
        return entity;
    }

    public EntityDetail declassifyEntity(String userId, String entityGUID, String classificationName) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "declassifyEntity";
        String entityGUIDParameterName = "entityGUID";
        String classificationParameterName = "classificationName";
        this.validateRepositoryConnector("declassifyEntity");
        this.parentConnector.validateRepositoryIsActive("declassifyEntity");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "declassifyEntity");
        this.repositoryValidator.validateGUID(this.repositoryName, "entityGUID", entityGUID, "declassifyEntity");
        this.repositoryValidator.validateClassificationName(this.repositoryName, "classificationName", classificationName, "declassifyEntity");
        EntityDetail entity = this.realMetadataCollection.declassifyEntity(userId, entityGUID, classificationName);
        if (entity != null) {
            this.setLocalProvenance((InstanceAuditHeader)entity);
            if (this.outboundRepositoryEventProcessor != null) {
                this.outboundRepositoryEventProcessor.processDeclassifiedEntityEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, entity);
            }
        }
        return entity;
    }

    public EntityDetail updateEntityClassification(String userId, String entityGUID, String classificationName, InstanceProperties properties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "updateEntityClassification";
        String propertiesParameterName = "properties";
        this.updateEntityClassificationParameterValidation(userId, entityGUID, classificationName, properties);
        try {
            this.repositoryValidator.validateClassificationProperties(this.repositoryName, classificationName, "properties", properties, "updateEntityClassification");
        }
        catch (PropertyErrorException error) {
            throw error;
        }
        catch (Throwable error) {
            OMRSErrorCode errorCode = OMRSErrorCode.UNKNOWN_CLASSIFICATION;
            throw new ClassificationErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "updateEntityClassification", error.getMessage(), errorCode.getSystemAction(), errorCode.getUserAction());
        }
        EntityDetail entity = this.realMetadataCollection.updateEntityClassification(userId, entityGUID, classificationName, properties);
        if (entity != null) {
            this.setLocalProvenance((InstanceAuditHeader)entity);
            if (this.outboundRepositoryEventProcessor != null) {
                this.outboundRepositoryEventProcessor.processReclassifiedEntityEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, entity);
            }
        }
        return entity;
    }

    public Relationship addRelationship(String userId, String relationshipTypeGUID, InstanceProperties initialProperties, String entityOneGUID, String entityTwoGUID, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, EntityNotKnownException, StatusNotSupportedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "addRelationship";
        String guidParameterName = "relationshipTypeGUID";
        String propertiesParameterName = "initialProperties";
        String initialStatusParameterName = "initialStatus";
        this.validateRepositoryConnector("addRelationship");
        this.parentConnector.validateRepositoryIsActive("addRelationship");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "addRelationship");
        this.repositoryValidator.validateTypeGUID(this.repositoryName, "relationshipTypeGUID", relationshipTypeGUID, "addRelationship");
        TypeDef typeDef = this.repositoryHelper.getTypeDef(this.repositoryName, "relationshipTypeGUID", relationshipTypeGUID, "addRelationship");
        this.repositoryValidator.validateTypeDefForInstance(this.repositoryName, "relationshipTypeGUID", typeDef, "addRelationship");
        this.repositoryValidator.validatePropertiesForType(this.repositoryName, "initialProperties", typeDef, initialProperties, "addRelationship");
        this.repositoryValidator.validateInstanceStatus(this.repositoryName, "initialStatus", initialStatus, typeDef, "addRelationship");
        Relationship relationship = this.realMetadataCollection.addRelationship(userId, relationshipTypeGUID, initialProperties, entityOneGUID, entityTwoGUID, initialStatus);
        if (relationship != null) {
            this.setLocalProvenance((InstanceAuditHeader)relationship);
            if (this.outboundRepositoryEventProcessor != null) {
                this.outboundRepositoryEventProcessor.processNewRelationshipEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, relationship);
            }
        }
        return relationship;
    }

    public Relationship updateRelationshipStatus(String userId, String relationshipGUID, InstanceStatus newStatus) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, StatusNotSupportedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "updateRelationshipStatus";
        String guidParameterName = "relationshipGUID";
        this.validateRepositoryConnector("updateRelationshipStatus");
        this.parentConnector.validateRepositoryIsActive("updateRelationshipStatus");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "updateRelationshipStatus");
        this.repositoryValidator.validateGUID(this.repositoryName, "relationshipGUID", relationshipGUID, "updateRelationshipStatus");
        Relationship currentRelationship = this.realMetadataCollection.getRelationship(userId, relationshipGUID);
        Relationship newRelationship = this.realMetadataCollection.updateRelationshipStatus(userId, relationshipGUID, newStatus);
        this.setLocalProvenance((InstanceAuditHeader)newRelationship);
        this.notifyOfUpdatedRelationship(currentRelationship, newRelationship);
        return newRelationship;
    }

    public Relationship updateRelationshipProperties(String userId, String relationshipGUID, InstanceProperties properties) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "updateRelationshipProperties";
        String guidParameterName = "relationshipGUID";
        this.validateRepositoryConnector("updateRelationshipProperties");
        this.parentConnector.validateRepositoryIsActive("updateRelationshipProperties");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "updateRelationshipProperties");
        this.repositoryValidator.validateGUID(this.repositoryName, "relationshipGUID", relationshipGUID, "updateRelationshipProperties");
        Relationship currentRelationship = this.realMetadataCollection.getRelationship(userId, relationshipGUID);
        Relationship newRelationship = this.realMetadataCollection.updateRelationshipProperties(userId, relationshipGUID, properties);
        this.setLocalProvenance((InstanceAuditHeader)newRelationship);
        this.notifyOfUpdatedRelationship(currentRelationship, newRelationship);
        return newRelationship;
    }

    private void notifyOfUpdatedRelationship(Relationship oldRelationship, Relationship newRelationship) {
        if (newRelationship != null && this.outboundRepositoryEventProcessor != null) {
            this.outboundRepositoryEventProcessor.processUpdatedRelationshipEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, oldRelationship, newRelationship);
        }
    }

    public Relationship undoRelationshipUpdate(String userId, String relationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "undoRelationshipUpdate";
        String guidParameterName = "relationshipGUID";
        this.validateRepositoryConnector("undoRelationshipUpdate");
        this.parentConnector.validateRepositoryIsActive("undoRelationshipUpdate");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "undoRelationshipUpdate");
        this.repositoryValidator.validateGUID(this.repositoryName, "relationshipGUID", relationshipGUID, "undoRelationshipUpdate");
        Relationship relationship = this.realMetadataCollection.undoRelationshipUpdate(userId, relationshipGUID);
        if (relationship != null) {
            this.setLocalProvenance((InstanceAuditHeader)relationship);
            if (this.outboundRepositoryEventProcessor != null) {
                this.outboundRepositoryEventProcessor.processUndoneRelationshipEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, relationship);
            }
        }
        return relationship;
    }

    public Relationship deleteRelationship(String userId, String typeDefGUID, String typeDefName, String obsoleteRelationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "deleteRelationship";
        String guidParameterName = "typeDefGUID";
        String nameParameterName = "typeDefName";
        String relationshipParameterName = "obsoleteRelationshipGUID";
        this.validateRepositoryConnector("deleteRelationship");
        this.parentConnector.validateRepositoryIsActive("deleteRelationship");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "deleteRelationship");
        this.repositoryValidator.validateGUID(this.repositoryName, "obsoleteRelationshipGUID", obsoleteRelationshipGUID, "deleteRelationship");
        this.repositoryValidator.validateTypeDefIds(this.repositoryName, "typeDefGUID", "typeDefName", typeDefGUID, typeDefName, "deleteRelationship");
        Relationship relationship = this.realMetadataCollection.deleteRelationship(userId, typeDefGUID, typeDefName, obsoleteRelationshipGUID);
        if (this.outboundRepositoryEventProcessor != null) {
            this.setLocalProvenance((InstanceAuditHeader)relationship);
            this.outboundRepositoryEventProcessor.processDeletedRelationshipEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, relationship);
        }
        return relationship;
    }

    public void purgeRelationship(String userId, String typeDefGUID, String typeDefName, String deletedRelationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, RelationshipNotDeletedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "purgeRelationship";
        String guidParameterName = "typeDefGUID";
        String nameParameterName = "typeDefName";
        String relationshipParameterName = "deletedRelationshipGUID";
        this.validateRepositoryConnector("purgeRelationship");
        this.parentConnector.validateRepositoryIsActive("purgeRelationship");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "purgeRelationship");
        this.repositoryValidator.validateGUID(this.repositoryName, "deletedRelationshipGUID", deletedRelationshipGUID, "purgeRelationship");
        this.repositoryValidator.validateTypeDefIds(this.repositoryName, "typeDefGUID", "typeDefName", typeDefGUID, typeDefName, "purgeRelationship");
        this.realMetadataCollection.purgeRelationship(userId, typeDefGUID, typeDefName, deletedRelationshipGUID);
        if (this.outboundRepositoryEventProcessor != null) {
            this.outboundRepositoryEventProcessor.processPurgedRelationshipEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, typeDefGUID, typeDefName, deletedRelationshipGUID);
        }
    }

    public Relationship restoreRelationship(String userId, String deletedRelationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, RelationshipNotDeletedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "restoreRelationship";
        String guidParameterName = "deletedRelationshipGUID";
        this.validateRepositoryConnector("restoreRelationship");
        this.parentConnector.validateRepositoryIsActive("restoreRelationship");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "restoreRelationship");
        this.repositoryValidator.validateGUID(this.repositoryName, "deletedRelationshipGUID", deletedRelationshipGUID, "restoreRelationship");
        Relationship relationship = this.realMetadataCollection.restoreRelationship(userId, deletedRelationshipGUID);
        if (relationship != null) {
            this.setLocalProvenance((InstanceAuditHeader)relationship);
            if (this.outboundRepositoryEventProcessor != null) {
                this.outboundRepositoryEventProcessor.processRestoredRelationshipEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, relationship);
            }
        }
        return relationship;
    }

    public EntityDetail reIdentifyEntity(String userId, String typeDefGUID, String typeDefName, String entityGUID, String newEntityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "reIdentifyEntity";
        String guidParameterName = "typeDefGUID";
        String nameParameterName = "typeDefName";
        String instanceParameterName = "deletedRelationshipGUID";
        this.validateRepositoryConnector("reIdentifyEntity");
        this.parentConnector.validateRepositoryIsActive("reIdentifyEntity");
        this.parentConnector.validateRepositoryIsActive("reIdentifyEntity");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "reIdentifyEntity");
        this.repositoryValidator.validateGUID(this.repositoryName, "deletedRelationshipGUID", newEntityGUID, "reIdentifyEntity");
        this.repositoryValidator.validateTypeDefIds(this.repositoryName, "typeDefGUID", "typeDefName", typeDefGUID, typeDefName, "reIdentifyEntity");
        EntityDetail entity = this.realMetadataCollection.reIdentifyEntity(userId, typeDefGUID, typeDefName, entityGUID, newEntityGUID);
        if (entity != null) {
            this.setLocalProvenance((InstanceAuditHeader)entity);
            if (this.outboundRepositoryEventProcessor != null) {
                this.outboundRepositoryEventProcessor.processReIdentifiedEntityEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, entityGUID, entity);
            }
        }
        return entity;
    }

    public EntityDetail reTypeEntity(String userId, String entityGUID, TypeDefSummary currentTypeDefSummary, TypeDefSummary newTypeDefSummary) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, ClassificationErrorException, EntityNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "reTypeEntity";
        String entityParameterName = "entityGUID";
        this.validateRepositoryConnector("reTypeEntity");
        this.parentConnector.validateRepositoryIsActive("reTypeEntity");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "reTypeEntity");
        this.repositoryValidator.validateGUID(this.repositoryName, "entityGUID", entityGUID, "reTypeEntity");
        EntityDetail entity = this.realMetadataCollection.reTypeEntity(userId, entityGUID, currentTypeDefSummary, newTypeDefSummary);
        if (entity != null) {
            this.setLocalProvenance((InstanceAuditHeader)entity);
            if (this.outboundRepositoryEventProcessor != null) {
                this.outboundRepositoryEventProcessor.processReTypedEntityEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, currentTypeDefSummary, entity);
            }
        }
        return entity;
    }

    public EntityDetail reHomeEntity(String userId, String entityGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId, String newHomeMetadataCollectionId, String newHomeMetadataCollectionName) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "reHomeEntity";
        String guidParameterName = "typeDefGUID";
        String nameParameterName = "typeDefName";
        String entityParameterName = "entityGUID";
        String homeParameterName = "homeMetadataCollectionId";
        String newHomeParameterName = "newHomeMetadataCollectionId";
        this.validateRepositoryConnector("reHomeEntity");
        this.parentConnector.validateRepositoryIsActive("reHomeEntity");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "reHomeEntity");
        this.repositoryValidator.validateGUID(this.repositoryName, "entityGUID", entityGUID, "reHomeEntity");
        this.repositoryValidator.validateTypeDefIds(this.repositoryName, "typeDefGUID", "typeDefName", typeDefGUID, typeDefName, "reHomeEntity");
        this.repositoryValidator.validateHomeMetadataGUID(this.repositoryName, "homeMetadataCollectionId", homeMetadataCollectionId, "reHomeEntity");
        this.repositoryValidator.validateHomeMetadataGUID(this.repositoryName, "newHomeMetadataCollectionId", newHomeMetadataCollectionId, "reHomeEntity");
        EntityDetail entity = this.realMetadataCollection.reHomeEntity(userId, entityGUID, typeDefGUID, typeDefName, homeMetadataCollectionId, newHomeMetadataCollectionId, newHomeMetadataCollectionName);
        if (entity != null) {
            if (entity.getMetadataCollectionId() == null) {
                entity.setMetadataCollectionId(newHomeMetadataCollectionId);
                entity.setInstanceProvenanceType(InstanceProvenanceType.LOCAL_COHORT);
            }
            if (entity.getMetadataCollectionName() == null) {
                entity.setMetadataCollectionName(newHomeMetadataCollectionName);
            }
            if (this.outboundRepositoryEventProcessor != null) {
                this.outboundRepositoryEventProcessor.processReHomedEntityEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, this.metadataCollectionId, entity);
            }
        }
        return entity;
    }

    public Relationship reIdentifyRelationship(String userId, String typeDefGUID, String typeDefName, String relationshipGUID, String newRelationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "reIdentifyRelationship";
        String guidParameterName = "typeDefGUID";
        String nameParameterName = "typeDefName";
        String relationshipParameterName = "relationshipGUID";
        String newRelationshipParameterName = "newHomeMetadataCollectionId";
        this.validateRepositoryConnector("reIdentifyRelationship");
        this.parentConnector.validateRepositoryIsActive("reIdentifyRelationship");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "reIdentifyRelationship");
        this.repositoryValidator.validateGUID(this.repositoryName, "relationshipGUID", relationshipGUID, "reIdentifyRelationship");
        this.repositoryValidator.validateTypeDefIds(this.repositoryName, "typeDefGUID", "typeDefName", typeDefGUID, typeDefName, "reIdentifyRelationship");
        this.repositoryValidator.validateGUID(this.repositoryName, "newHomeMetadataCollectionId", newRelationshipGUID, "reIdentifyRelationship");
        Relationship relationship = this.realMetadataCollection.reIdentifyRelationship(userId, typeDefGUID, typeDefName, relationshipGUID, newRelationshipGUID);
        if (relationship != null) {
            this.setLocalProvenance((InstanceAuditHeader)relationship);
            if (this.outboundRepositoryEventProcessor != null) {
                this.outboundRepositoryEventProcessor.processReIdentifiedRelationshipEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, relationshipGUID, relationship);
            }
        }
        return relationship;
    }

    public Relationship reTypeRelationship(String userId, String relationshipGUID, TypeDefSummary currentTypeDefSummary, TypeDefSummary newTypeDefSummary) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "reTypeRelationship";
        String relationshipParameterName = "relationshipGUID";
        String currentTypeDefParameterName = "currentTypeDefSummary";
        this.validateRepositoryConnector("reTypeRelationship");
        this.parentConnector.validateRepositoryIsActive("reTypeRelationship");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "reTypeRelationship");
        this.repositoryValidator.validateGUID(this.repositoryName, "relationshipGUID", relationshipGUID, "reTypeRelationship");
        this.repositoryValidator.validateType(this.repositoryName, "currentTypeDefSummary", currentTypeDefSummary, TypeDefCategory.RELATIONSHIP_DEF, "reTypeRelationship");
        this.repositoryValidator.validateType(this.repositoryName, "currentTypeDefSummary", newTypeDefSummary, TypeDefCategory.RELATIONSHIP_DEF, "reTypeRelationship");
        Relationship relationship = this.realMetadataCollection.reTypeRelationship(userId, relationshipGUID, currentTypeDefSummary, newTypeDefSummary);
        if (relationship != null) {
            this.setLocalProvenance((InstanceAuditHeader)relationship);
            if (this.outboundRepositoryEventProcessor != null) {
                this.outboundRepositoryEventProcessor.processReTypedRelationshipEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, currentTypeDefSummary, relationship);
            }
        }
        return relationship;
    }

    public Relationship reHomeRelationship(String userId, String relationshipGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId, String newHomeMetadataCollectionId, String newHomeMetadataCollectionName) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "reHomeRelationship";
        String guidParameterName = "typeDefGUID";
        String nameParameterName = "typeDefName";
        String relationshipParameterName = "relationshipGUID";
        String homeParameterName = "homeMetadataCollectionId";
        String newHomeParameterName = "newHomeMetadataCollectionId";
        this.validateRepositoryConnector("reHomeRelationship");
        this.parentConnector.validateRepositoryIsActive("reHomeRelationship");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "reHomeRelationship");
        this.repositoryValidator.validateGUID(this.repositoryName, "relationshipGUID", relationshipGUID, "reHomeRelationship");
        this.repositoryValidator.validateTypeDefIds(this.repositoryName, "typeDefGUID", "typeDefName", typeDefGUID, typeDefName, "reHomeRelationship");
        this.repositoryValidator.validateHomeMetadataGUID(this.repositoryName, "homeMetadataCollectionId", homeMetadataCollectionId, "reHomeRelationship");
        this.repositoryValidator.validateHomeMetadataGUID(this.repositoryName, "newHomeMetadataCollectionId", newHomeMetadataCollectionId, "reHomeRelationship");
        Relationship relationship = this.realMetadataCollection.reHomeRelationship(userId, relationshipGUID, typeDefGUID, typeDefName, homeMetadataCollectionId, newHomeMetadataCollectionId, newHomeMetadataCollectionName);
        if (relationship != null) {
            if (relationship.getMetadataCollectionId() == null) {
                relationship.setMetadataCollectionId(newHomeMetadataCollectionId);
                relationship.setInstanceProvenanceType(InstanceProvenanceType.LOCAL_COHORT);
            }
            if (relationship.getMetadataCollectionName() == null) {
                relationship.setMetadataCollectionName(newHomeMetadataCollectionName);
            }
            if (this.outboundRepositoryEventProcessor != null) {
                this.outboundRepositoryEventProcessor.processReHomedRelationshipEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, homeMetadataCollectionId, relationship);
            }
        }
        return relationship;
    }

    public void saveEntityReferenceCopy(String userId, EntityDetail entity) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, HomeEntityException, EntityConflictException, InvalidEntityException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "saveEntityReferenceCopy";
        this.validateRepositoryConnector("saveEntityReferenceCopy");
        this.parentConnector.validateRepositoryIsActive("saveEntityReferenceCopy");
        this.realMetadataCollection.saveEntityReferenceCopy(userId, entity);
    }

    public void purgeEntityReferenceCopy(String userId, String entityGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, HomeEntityException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "purgeEntityReferenceCopy";
        String guidParameterName = "typeDefGUID";
        String nameParameterName = "typeDefName";
        String entityParameterName = "entityGUID";
        String homeParameterName = "homeMetadataCollectionId";
        this.validateRepositoryConnector("purgeEntityReferenceCopy");
        this.parentConnector.validateRepositoryIsActive("purgeEntityReferenceCopy");
        this.repositoryValidator.validateGUID(this.repositoryName, "entityGUID", entityGUID, "purgeEntityReferenceCopy");
        this.repositoryValidator.validateTypeDefIds(this.repositoryName, "typeDefGUID", "typeDefName", typeDefGUID, typeDefName, "purgeEntityReferenceCopy");
        this.repositoryValidator.validateHomeMetadataGUID(this.repositoryName, "homeMetadataCollectionId", homeMetadataCollectionId, "purgeEntityReferenceCopy");
        this.realMetadataCollection.purgeEntityReferenceCopy(userId, entityGUID, typeDefGUID, typeDefName, homeMetadataCollectionId);
    }

    public void refreshEntityReferenceCopy(String userId, String entityGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, HomeEntityException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "refreshEntityReferenceCopy";
        String guidParameterName = "typeDefGUID";
        String nameParameterName = "typeDefName";
        String entityParameterName = "entityGUID";
        String homeParameterName = "homeMetadataCollectionId";
        this.validateRepositoryConnector("refreshEntityReferenceCopy");
        this.parentConnector.validateRepositoryIsActive("refreshEntityReferenceCopy");
        this.repositoryValidator.validateGUID(this.repositoryName, "entityGUID", entityGUID, "refreshEntityReferenceCopy");
        this.repositoryValidator.validateTypeDefIds(this.repositoryName, "typeDefGUID", "typeDefName", typeDefGUID, typeDefName, "refreshEntityReferenceCopy");
        this.repositoryValidator.validateHomeMetadataGUID(this.repositoryName, "homeMetadataCollectionId", homeMetadataCollectionId, "refreshEntityReferenceCopy");
    }

    public void saveRelationshipReferenceCopy(String userId, Relationship relationship) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, EntityNotKnownException, PropertyErrorException, HomeRelationshipException, RelationshipConflictException, InvalidRelationshipException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "saveRelationshipReferenceCopy";
        String instanceParameterName = "relationship";
        this.validateRepositoryConnector("saveRelationshipReferenceCopy");
        this.parentConnector.validateRepositoryIsActive("saveRelationshipReferenceCopy");
        this.repositoryValidator.validateReferenceInstanceHeader(this.repositoryName, this.metadataCollectionId, "relationship", (InstanceHeader)relationship, "saveRelationshipReferenceCopy");
        this.realMetadataCollection.saveRelationshipReferenceCopy(userId, relationship);
    }

    public void purgeRelationshipReferenceCopy(String userId, String relationshipGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, HomeRelationshipException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "purgeRelationshipReferenceCopy";
        String guidParameterName = "typeDefGUID";
        String nameParameterName = "typeDefName";
        String relationshipParameterName = "relationshipGUID";
        String homeParameterName = "homeMetadataCollectionId";
        this.validateRepositoryConnector("purgeRelationshipReferenceCopy");
        this.parentConnector.validateRepositoryIsActive("purgeRelationshipReferenceCopy");
        this.repositoryValidator.validateGUID(this.repositoryName, "relationshipGUID", relationshipGUID, "purgeRelationshipReferenceCopy");
        this.repositoryValidator.validateTypeDefIds(this.repositoryName, "typeDefGUID", "typeDefName", typeDefGUID, typeDefName, "purgeRelationshipReferenceCopy");
        this.repositoryValidator.validateHomeMetadataGUID(this.repositoryName, "homeMetadataCollectionId", homeMetadataCollectionId, "purgeRelationshipReferenceCopy");
        this.realMetadataCollection.purgeRelationshipReferenceCopy(userId, relationshipGUID, typeDefGUID, typeDefName, homeMetadataCollectionId);
    }

    public void refreshRelationshipReferenceCopy(String userId, String relationshipGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, HomeRelationshipException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "refreshRelationshipReferenceCopy";
        String guidParameterName = "typeDefGUID";
        String nameParameterName = "typeDefName";
        String relationshipParameterName = "relationshipGUID";
        String homeParameterName = "homeMetadataCollectionId";
        this.validateRepositoryConnector("refreshRelationshipReferenceCopy");
        this.parentConnector.validateRepositoryIsActive("refreshRelationshipReferenceCopy");
        this.repositoryValidator.validateGUID(this.repositoryName, "relationshipGUID", relationshipGUID, "refreshRelationshipReferenceCopy");
        this.repositoryValidator.validateTypeDefIds(this.repositoryName, "typeDefGUID", "typeDefName", typeDefGUID, typeDefName, "refreshRelationshipReferenceCopy");
        this.repositoryValidator.validateHomeMetadataGUID(this.repositoryName, "homeMetadataCollectionId", homeMetadataCollectionId, "refreshRelationshipReferenceCopy");
        if (this.outboundRepositoryEventProcessor == null) {
            this.realMetadataCollection.refreshRelationshipReferenceCopy(userId, relationshipGUID, typeDefGUID, typeDefName, homeMetadataCollectionId);
        } else if (homeMetadataCollectionId.equals(this.metadataCollectionId)) {
            Relationship relationship = this.realMetadataCollection.getRelationship(userId, relationshipGUID);
            this.outboundRepositoryEventProcessor.processRefreshRelationshipEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, relationship);
        } else {
            this.outboundRepositoryEventProcessor.processRefreshRelationshipRequest(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, typeDefGUID, typeDefName, relationshipGUID, homeMetadataCollectionId);
        }
    }
}

