/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.localrepository.repositorycontentmanager;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ArrayPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.MapPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.PrimitivePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ExternalStandardMapping;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefGallery;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatchAction;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PatchErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.localrepository.repositorycontentmanager.OMRSRepositoryContentManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMRSRepositoryContentHelper
implements OMRSRepositoryHelper {
    private static final Logger log = LoggerFactory.getLogger(OMRSRepositoryContentHelper.class);
    private OMRSRepositoryContentManager repositoryContentManager;

    public OMRSRepositoryContentHelper(OMRSRepositoryContentManager repositoryContentManager) {
        this.repositoryContentManager = repositoryContentManager;
    }

    public TypeDefGallery getActiveTypeDefGallery() {
        String methodName = "getActiveTypeDefGallery";
        this.validateRepositoryContentManager("getActiveTypeDefGallery");
        return this.repositoryContentManager.getActiveTypeDefGallery();
    }

    public TypeDefGallery getKnownTypeDefGallery() {
        String methodName = "getKnownTypeDefGallery";
        this.validateRepositoryContentManager("getKnownTypeDefGallery");
        return this.repositoryContentManager.getKnownTypeDefGallery();
    }

    public TypeDef getTypeDefByName(String sourceName, String typeDefName) {
        String methodName = "getTypeDefByName";
        this.validateRepositoryContentManager("getTypeDefByName");
        return this.repositoryContentManager.getTypeDefByName(sourceName, typeDefName);
    }

    public AttributeTypeDef getAttributeTypeDefByName(String sourceName, String attributeTypeDefName) {
        String methodName = "getAttributeTypeDefByName";
        this.validateRepositoryContentManager("getAttributeTypeDefByName");
        return this.repositoryContentManager.getAttributeTypeDefByName(sourceName, attributeTypeDefName);
    }

    public TypeDefGallery getActiveTypesByWildCardName(String sourceName, String typeDefName) {
        String methodName = "getActiveTypesByWildCardName";
        this.validateRepositoryContentManager("getActiveTypesByWildCardName");
        return this.repositoryContentManager.getActiveTypesByWildCardName(sourceName, typeDefName);
    }

    public TypeDef getTypeDef(String sourceName, String parameterName, String typeDefGUID, String methodName) throws TypeErrorException {
        this.validateRepositoryContentManager(methodName);
        return this.repositoryContentManager.getTypeDef(sourceName, parameterName, typeDefGUID, methodName);
    }

    public AttributeTypeDef getAttributeTypeDef(String sourceName, String attributeTypeDefGUID, String methodName) throws TypeErrorException {
        this.validateRepositoryContentManager(methodName);
        return this.repositoryContentManager.getAttributeTypeDef(sourceName, attributeTypeDefGUID, methodName);
    }

    public TypeDef getTypeDef(String sourceName, String guidParameterName, String nameParameterName, String typeDefGUID, String typeDefName, String methodName) throws TypeErrorException {
        this.validateRepositoryContentManager(methodName);
        return this.repositoryContentManager.getTypeDef(sourceName, guidParameterName, nameParameterName, typeDefGUID, typeDefName, methodName);
    }

    public AttributeTypeDef getAttributeTypeDef(String sourceName, String attributeTypeDefGUID, String attributeTypeDefName, String methodName) throws TypeErrorException {
        this.validateRepositoryContentManager(methodName);
        return this.repositoryContentManager.getAttributeTypeDef(sourceName, attributeTypeDefGUID, attributeTypeDefName, methodName);
    }

    public TypeDef applyPatch(String sourceName, TypeDef originalTypeDef, TypeDefPatch typeDefPatch) throws PatchErrorException, InvalidParameterException {
        TypeDefCategory category;
        TypeDefPatchAction patchAction;
        long newVersion;
        String methodName = "applyPatch";
        this.validateRepositoryContentManager("applyPatch");
        EntityDef clonedTypeDef = null;
        TypeDef updatedTypeDef = null;
        if (typeDefPatch != null) {
            // empty if block
        }
        if ((newVersion = typeDefPatch.getUpdateToVersion()) <= typeDefPatch.getApplyToVersion()) {
            // empty if block
        }
        if ((patchAction = typeDefPatch.getAction()) == null) {
            // empty if block
        }
        if (originalTypeDef.getVersion() != typeDefPatch.getApplyToVersion()) {
            // empty if block
        }
        if ((category = originalTypeDef.getCategory()) == null) {
            // empty if block
        }
        try {
            switch (category) {
                case ENTITY_DEF: {
                    clonedTypeDef = new EntityDef((EntityDef)originalTypeDef);
                    break;
                }
                case RELATIONSHIP_DEF: {
                    clonedTypeDef = new RelationshipDef((RelationshipDef)originalTypeDef);
                    break;
                }
                case CLASSIFICATION_DEF: {
                    clonedTypeDef = new ClassificationDef((ClassificationDef)originalTypeDef);
                }
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (clonedTypeDef != null) {
            switch (patchAction) {
                case ADD_ATTRIBUTES: {
                    updatedTypeDef = this.patchTypeDefAttributes((TypeDef)clonedTypeDef, typeDefPatch.getTypeDefAttributes());
                    break;
                }
                case ADD_OPTIONS: {
                    updatedTypeDef = this.patchTypeDefNewOptions((TypeDef)clonedTypeDef, typeDefPatch.getTypeDefOptions());
                    break;
                }
                case UPDATE_OPTIONS: {
                    updatedTypeDef = this.patchTypeDefUpdateOptions((TypeDef)clonedTypeDef, typeDefPatch.getTypeDefOptions());
                    break;
                }
                case DELETE_OPTIONS: {
                    updatedTypeDef = this.patchTypeDefDeleteOptions((TypeDef)clonedTypeDef, typeDefPatch.getTypeDefOptions());
                    break;
                }
                case ADD_EXTERNAL_STANDARDS: {
                    updatedTypeDef = this.patchTypeDefAddExternalStandards((TypeDef)clonedTypeDef, typeDefPatch.getExternalStandardMappings(), typeDefPatch.getTypeDefAttributes());
                    break;
                }
                case UPDATE_EXTERNAL_STANDARDS: {
                    updatedTypeDef = this.patchTypeDefUpdateExternalStandards((TypeDef)clonedTypeDef, typeDefPatch.getExternalStandardMappings(), typeDefPatch.getTypeDefAttributes());
                    break;
                }
                case DELETE_EXTERNAL_STANDARDS: {
                    updatedTypeDef = this.patchTypeDefDeleteExternalStandards((TypeDef)clonedTypeDef, typeDefPatch.getExternalStandardMappings(), typeDefPatch.getTypeDefAttributes());
                    break;
                }
                case UPDATE_DESCRIPTIONS: {
                    updatedTypeDef = this.patchTypeDefNewDescriptions((TypeDef)clonedTypeDef, typeDefPatch.getDescription(), typeDefPatch.getDescriptionGUID(), typeDefPatch.getTypeDefAttributes());
                }
            }
        }
        if (updatedTypeDef != null) {
            updatedTypeDef.setVersion(typeDefPatch.getUpdateToVersion());
            updatedTypeDef.setVersionName(typeDefPatch.getNewVersionName());
        }
        return updatedTypeDef;
    }

    private TypeDef patchTypeDefAttributes(TypeDef clonedTypeDef, List<TypeDefAttribute> typeDefAttributes) throws PatchErrorException {
        ArrayList<TypeDefAttribute> propertyDefinitions = clonedTypeDef.getPropertiesDefinition();
        if (propertyDefinitions == null) {
            propertyDefinitions = new ArrayList<TypeDefAttribute>();
        }
        for (TypeDefAttribute newAttribute : typeDefAttributes) {
            if (newAttribute == null) continue;
            String attributeName = newAttribute.getAttributeName();
            AttributeTypeDef attributeType = newAttribute.getAttributeType();
            if (attributeName == null || attributeType == null || propertyDefinitions.contains(newAttribute)) continue;
            propertyDefinitions.add(newAttribute);
        }
        if (propertyDefinitions.size() > 0) {
            clonedTypeDef.setPropertiesDefinition(propertyDefinitions);
        } else {
            clonedTypeDef.setPropertiesDefinition(null);
        }
        return clonedTypeDef;
    }

    private TypeDef patchTypeDefNewOptions(TypeDef clonedTypeDef, Map<String, String> typeDefOptions) throws PatchErrorException {
        return null;
    }

    private TypeDef patchTypeDefUpdateOptions(TypeDef clonedTypeDef, Map<String, String> typeDefOptions) throws PatchErrorException {
        return null;
    }

    private TypeDef patchTypeDefDeleteOptions(TypeDef clonedTypeDef, Map<String, String> typeDefOptions) throws PatchErrorException {
        return null;
    }

    private TypeDef patchTypeDefAddExternalStandards(TypeDef clonedTypeDef, List<ExternalStandardMapping> externalStandardMappings, List<TypeDefAttribute> typeDefAttributes) throws PatchErrorException {
        return null;
    }

    private TypeDef patchTypeDefUpdateExternalStandards(TypeDef clonedTypeDef, List<ExternalStandardMapping> externalStandardMappings, List<TypeDefAttribute> typeDefAttributes) throws PatchErrorException {
        return null;
    }

    private TypeDef patchTypeDefDeleteExternalStandards(TypeDef clonedTypeDef, List<ExternalStandardMapping> externalStandardMappings, List<TypeDefAttribute> typeDefAttributes) throws PatchErrorException {
        return null;
    }

    private TypeDef patchTypeDefNewDescriptions(TypeDef clonedTypeDef, String description, String descriptionGUID, List<TypeDefAttribute> typeDefAttributes) throws PatchErrorException {
        if (description != null) {
            clonedTypeDef.setDescription(description);
        }
        if (descriptionGUID != null) {
            clonedTypeDef.setDescriptionGUID(descriptionGUID);
        }
        if (typeDefAttributes != null) {
            List propertiesDefinition = clonedTypeDef.getPropertiesDefinition();
            if (propertiesDefinition == null) {
                // empty if block
            }
            for (TypeDefAttribute patchTypeDefAttribute : typeDefAttributes) {
                String patchTypeDefAttributeName;
                if (patchTypeDefAttribute == null || (patchTypeDefAttributeName = patchTypeDefAttribute.getAttributeName()) == null) continue;
                for (TypeDefAttribute existingProperty : propertiesDefinition) {
                    if (existingProperty != null && !patchTypeDefAttributeName.equals(existingProperty.getAttributeName())) continue;
                }
            }
        }
        return clonedTypeDef;
    }

    public List<TypeDefAttribute> getAllPropertiesForTypeDef(String sourceName, TypeDef typeDef, String methodName) {
        this.validateRepositoryContentManager(methodName);
        return this.repositoryContentManager.getAllPropertiesForTypeDef(sourceName, typeDef, methodName);
    }

    public boolean isTypeOf(String sourceName, String actualTypeName, String expectedTypeName) {
        String methodName = "isTypeOf";
        this.validateRepositoryContentManager("isTypeOf");
        return this.repositoryContentManager.isTypeOf(sourceName, actualTypeName, expectedTypeName);
    }

    public List<TypeDef> getMatchingActiveTypes(String sourceName, String standard, String organization, String identifier, String methodName) {
        ArrayList<TypeDef> matchingTypes = new ArrayList<TypeDef>();
        TypeDefGallery typeDefGallery = this.getActiveTypeDefGallery();
        if (typeDefGallery != null) {
            for (TypeDef activeTypeDef : typeDefGallery.getTypeDefs()) {
                List typeDefAttributes;
                ArrayList externalStandardMappings = new ArrayList();
                if (activeTypeDef.getExternalStandardMappings() != null) {
                    externalStandardMappings.addAll(activeTypeDef.getExternalStandardMappings());
                }
                if ((typeDefAttributes = activeTypeDef.getPropertiesDefinition()) != null) {
                    for (TypeDefAttribute typeDefAttribute : typeDefAttributes) {
                        if (typeDefAttribute == null || typeDefAttribute.getExternalStandardMappings() == null) continue;
                        externalStandardMappings.addAll(activeTypeDef.getExternalStandardMappings());
                    }
                }
                for (ExternalStandardMapping externalStandardMapping : externalStandardMappings) {
                    String activeTypeDefStandardName = externalStandardMapping.getStandardName();
                    String activeTypeDefStandardOrgName = externalStandardMapping.getStandardOrganization();
                    String activeTypeDefStandardIdentifier = externalStandardMapping.getStandardTypeName();
                    if (activeTypeDefStandardName != null && activeTypeDefStandardName.equals(standard)) {
                        matchingTypes.add(activeTypeDef);
                        continue;
                    }
                    if (activeTypeDefStandardOrgName != null && activeTypeDefStandardOrgName.equals(organization)) {
                        matchingTypes.add(activeTypeDef);
                        continue;
                    }
                    if (activeTypeDefStandardIdentifier == null || !activeTypeDefStandardIdentifier.equals(identifier)) continue;
                    matchingTypes.add(activeTypeDef);
                }
            }
        }
        if (matchingTypes.isEmpty()) {
            return null;
        }
        return matchingTypes;
    }

    public void registerMetadataCollection(String metadataCollectionId, String metadataCollectionName) {
        String methodName = "registerMetadataCollection";
        this.validateRepositoryContentManager("registerMetadataCollection");
        this.repositoryContentManager.registerMetadataCollection(metadataCollectionId, metadataCollectionName);
    }

    public String getMetadataCollectionName(String metadataCollectionId) {
        String methodName = "getMetadataCollectionName";
        this.validateRepositoryContentManager("getMetadataCollectionName");
        return this.repositoryContentManager.getMetadataCollectionName(metadataCollectionId);
    }

    public EntityDetail getSkeletonEntity(String sourceName, String metadataCollectionId, InstanceProvenanceType provenanceType, String userName, String typeName) throws TypeErrorException {
        String methodName = "getSkeletonEntity";
        this.validateRepositoryContentManager("getSkeletonEntity");
        EntityDetail entity = new EntityDetail();
        String guid = UUID.randomUUID().toString();
        entity.setInstanceProvenanceType(provenanceType);
        entity.setMetadataCollectionId(metadataCollectionId);
        entity.setCreateTime(new Date());
        entity.setGUID(guid);
        entity.setVersion(1L);
        entity.setType(this.repositoryContentManager.getInstanceType(sourceName, TypeDefCategory.ENTITY_DEF, typeName, "getSkeletonEntity"));
        entity.setStatus(this.repositoryContentManager.getInitialStatus(sourceName, typeName, "getSkeletonEntity"));
        entity.setCreatedBy(userName);
        entity.setInstanceURL(this.repositoryContentManager.getEntityURL(sourceName, guid));
        return entity;
    }

    public Classification getSkeletonClassification(String sourceName, String userName, String classificationTypeName, String entityTypeName) throws TypeErrorException {
        String methodName = "getSkeletonClassification";
        this.validateRepositoryContentManager("getSkeletonClassification");
        if (this.repositoryContentManager.isValidTypeCategory(sourceName, TypeDefCategory.CLASSIFICATION_DEF, classificationTypeName, "getSkeletonClassification")) {
            if (this.repositoryContentManager.isValidClassificationForEntity(sourceName, classificationTypeName, entityTypeName, "getSkeletonClassification")) {
                Classification classification = new Classification();
                classification.setName(classificationTypeName);
                classification.setCreateTime(new Date());
                classification.setCreatedBy(userName);
                classification.setVersion(1L);
                classification.setType(this.repositoryContentManager.getInstanceType(sourceName, TypeDefCategory.CLASSIFICATION_DEF, classificationTypeName, "getSkeletonClassification"));
                classification.setStatus(this.repositoryContentManager.getInitialStatus(sourceName, classificationTypeName, "getSkeletonClassification"));
                return classification;
            }
            OMRSErrorCode errorCode = OMRSErrorCode.INVALID_CLASSIFICATION_FOR_ENTITY;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{classificationTypeName, entityTypeName});
            throw new TypeErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getSkeletonClassification", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        OMRSErrorCode errorCode = OMRSErrorCode.UNKNOWN_CLASSIFICATION;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{classificationTypeName});
        throw new TypeErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getSkeletonClassification", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public Relationship getSkeletonRelationship(String sourceName, String metadataCollectionId, InstanceProvenanceType provenanceType, String userName, String typeName) throws TypeErrorException {
        String methodName = "getSkeletonRelationship";
        this.validateRepositoryContentManager("getSkeletonRelationship");
        Relationship relationship = new Relationship();
        String guid = UUID.randomUUID().toString();
        relationship.setInstanceProvenanceType(provenanceType);
        relationship.setMetadataCollectionId(metadataCollectionId);
        relationship.setCreateTime(new Date());
        relationship.setGUID(guid);
        relationship.setVersion(1L);
        relationship.setType(this.repositoryContentManager.getInstanceType(sourceName, TypeDefCategory.RELATIONSHIP_DEF, typeName, "getSkeletonRelationship"));
        relationship.setStatus(this.repositoryContentManager.getInitialStatus(sourceName, typeName, "getSkeletonRelationship"));
        relationship.setCreatedBy(userName);
        relationship.setInstanceURL(this.repositoryContentManager.getRelationshipURL(sourceName, guid));
        return relationship;
    }

    public InstanceType getNewInstanceType(String sourceName, TypeDefSummary typeDefSummary) throws TypeErrorException {
        String methodName = "getNewInstanceType";
        this.validateRepositoryContentManager("getNewInstanceType");
        return this.repositoryContentManager.getInstanceType(sourceName, typeDefSummary.getCategory(), typeDefSummary.getName(), "getNewInstanceType");
    }

    public EntityDetail getNewEntity(String sourceName, String metadataCollectionId, InstanceProvenanceType provenanceType, String userName, String typeName, InstanceProperties properties, List<Classification> classifications) throws TypeErrorException {
        EntityDetail entity = this.getSkeletonEntity(sourceName, metadataCollectionId, provenanceType, userName, typeName);
        entity.setProperties(properties);
        entity.setClassifications(classifications);
        return entity;
    }

    public Relationship getNewRelationship(String sourceName, String metadataCollectionId, InstanceProvenanceType provenanceType, String userName, String typeName, InstanceProperties properties) throws TypeErrorException {
        Relationship relationship = this.getSkeletonRelationship(sourceName, metadataCollectionId, provenanceType, userName, typeName);
        relationship.setProperties(properties);
        return relationship;
    }

    public Classification getNewClassification(String sourceName, String userName, String typeName, String entityTypeName, ClassificationOrigin classificationOrigin, String classificationOriginGUID, InstanceProperties properties) throws TypeErrorException {
        Classification classification = this.getSkeletonClassification(sourceName, userName, typeName, entityTypeName);
        classification.setClassificationOrigin(classificationOrigin);
        classification.setClassificationOriginGUID(classificationOriginGUID);
        classification.setProperties(properties);
        return classification;
    }

    public EntityDetail addClassificationToEntity(String sourceName, EntityDetail entity, Classification newClassification, String methodName) {
        EntityDetail updatedEntity = new EntityDetail(entity);
        if (newClassification != null) {
            HashMap<String, Classification> entityClassificationsMap = new HashMap<String, Classification>();
            ArrayList entityClassifications = updatedEntity.getClassifications();
            if (entityClassifications != null) {
                for (Classification existingClassification : entityClassifications) {
                    if (existingClassification == null) continue;
                    entityClassificationsMap.put(existingClassification.getName(), existingClassification);
                }
            }
            entityClassificationsMap.put(newClassification.getName(), newClassification);
            if (entityClassificationsMap.isEmpty()) {
                updatedEntity.setClassifications(null);
            } else {
                entityClassifications = new ArrayList(entityClassificationsMap.values());
                updatedEntity.setClassifications(entityClassifications);
            }
            return updatedEntity;
        }
        String thisMethodName = "addClassificationToEntity";
        OMRSErrorCode errorCode = OMRSErrorCode.NULL_CLASSIFICATION_CREATED;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{sourceName, "addClassificationToEntity", methodName});
        throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public Classification getClassificationFromEntity(String sourceName, EntityDetail entity, String classificationName, String methodName) throws ClassificationErrorException {
        String thisMethodName = "getClassificationFromEntity";
        if (entity == null || classificationName == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.VALIDATION_LOGIC_ERROR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{sourceName, "getClassificationFromEntity", methodName});
            throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        List entityClassifications = entity.getClassifications();
        if (entityClassifications != null) {
            for (Classification entityClassification : entityClassifications) {
                if (!classificationName.equals(entityClassification.getName())) continue;
                return entityClassification;
            }
        }
        OMRSErrorCode errorCode = OMRSErrorCode.ENTITY_NOT_CLASSIFIED;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName, sourceName, classificationName, entity.getGUID()});
        throw new ClassificationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public EntityDetail updateClassificationInEntity(String sourceName, String userName, EntityDetail entity, Classification newClassification, String methodName) {
        if (newClassification != null) {
            Classification updatedClassification = new Classification(newClassification);
            updatedClassification = this.incrementVersion(userName, (InstanceAuditHeader)newClassification, updatedClassification);
            return this.addClassificationToEntity(sourceName, entity, updatedClassification, methodName);
        }
        String thisMethodName = "updateClassificationInEntity";
        OMRSErrorCode errorCode = OMRSErrorCode.NULL_CLASSIFICATION_CREATED;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{sourceName, "updateClassificationInEntity", methodName});
        throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public EntityDetail deleteClassificationFromEntity(String sourceName, EntityDetail entity, String oldClassificationName, String methodName) throws ClassificationErrorException {
        EntityDetail updatedEntity = new EntityDetail(entity);
        if (oldClassificationName != null) {
            Classification oldClassification;
            HashMap<String, Classification> entityClassificationsMap = new HashMap<String, Classification>();
            ArrayList entityClassifications = updatedEntity.getClassifications();
            if (entityClassifications != null) {
                for (Classification existingClassification : entityClassifications) {
                    if (existingClassification == null) continue;
                    entityClassificationsMap.put(existingClassification.getName(), existingClassification);
                }
            }
            if ((oldClassification = (Classification)entityClassificationsMap.remove(oldClassificationName)) == null) {
                OMRSErrorCode errorCode = OMRSErrorCode.ENTITY_NOT_CLASSIFIED;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName, sourceName, oldClassificationName, entity.getGUID()});
                throw new ClassificationErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            if (entityClassificationsMap.isEmpty()) {
                updatedEntity.setClassifications(null);
            } else {
                entityClassifications = new ArrayList(entityClassificationsMap.values());
                updatedEntity.setClassifications(entityClassifications);
            }
            return updatedEntity;
        }
        String thisMethodName = "deleteClassificationFromEntity";
        OMRSErrorCode errorCode = OMRSErrorCode.NULL_CLASSIFICATION_NAME;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{sourceName, "deleteClassificationFromEntity", methodName});
        throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public InstanceProperties mergeInstanceProperties(String sourceName, InstanceProperties existingProperties, InstanceProperties newProperties) {
        InstanceProperties mergedProperties;
        if (existingProperties == null) {
            mergedProperties = newProperties;
        } else {
            mergedProperties = existingProperties;
            if (newProperties != null) {
                Iterator newPropertyNames = newProperties.getPropertyNames();
                while (newPropertyNames.hasNext()) {
                    String newPropertyName = (String)newPropertyNames.next();
                    mergedProperties.setProperty(newPropertyName, newProperties.getPropertyValue(newPropertyName));
                }
            }
        }
        return mergedProperties;
    }

    public Relationship incrementVersion(String userId, InstanceAuditHeader originalInstance, Relationship updatedInstance) {
        updatedInstance.setUpdatedBy(userId);
        updatedInstance.setUpdateTime(new Date());
        long currentVersion = originalInstance.getVersion();
        updatedInstance.setVersion(currentVersion + 1L);
        return updatedInstance;
    }

    public Classification incrementVersion(String userId, InstanceAuditHeader originalInstance, Classification updatedInstance) {
        updatedInstance.setUpdatedBy(userId);
        updatedInstance.setUpdateTime(new Date());
        long currentVersion = originalInstance.getVersion();
        updatedInstance.setVersion(currentVersion + 1L);
        return updatedInstance;
    }

    public EntityDetail incrementVersion(String userId, InstanceAuditHeader originalInstance, EntityDetail updatedInstance) {
        updatedInstance.setUpdatedBy(userId);
        updatedInstance.setUpdateTime(new Date());
        long currentVersion = originalInstance.getVersion();
        updatedInstance.setVersion(currentVersion + 1L);
        return updatedInstance;
    }

    public EntityProxy getNewEntityProxy(String sourceName, EntityDetail entity) throws RepositoryErrorException {
        InstanceType type;
        String methodName = "getNewEntityProxy";
        String parameterName = "entity";
        this.validateRepositoryContentManager("getNewEntityProxy");
        if (entity != null && (type = entity.getType()) != null) {
            try {
                TypeDef typeDef = this.repositoryContentManager.getTypeDef(sourceName, "entity", "entity", type.getTypeDefGUID(), type.getTypeDefName(), "getNewEntityProxy");
                EntityProxy entityProxy = new EntityProxy((EntitySummary)entity);
                InstanceProperties entityProperties = entity.getProperties();
                if (entityProperties != null) {
                    List<TypeDefAttribute> propertiesDefinition = this.repositoryContentManager.getAllPropertiesForTypeDef(sourceName, typeDef, "getNewEntityProxy");
                    InstanceProperties uniqueAttributes = new InstanceProperties();
                    if (propertiesDefinition != null) {
                        for (TypeDefAttribute typeDefAttribute : propertiesDefinition) {
                            InstancePropertyValue propertyValue;
                            if (typeDefAttribute == null) continue;
                            String propertyName = typeDefAttribute.getAttributeName();
                            if (!typeDefAttribute.isUnique() || propertyName == null || (propertyValue = entityProperties.getPropertyValue(propertyName)) == null) continue;
                            uniqueAttributes.setProperty(propertyName, propertyValue);
                        }
                    }
                    if (uniqueAttributes.getPropertyCount() > 0) {
                        entityProxy.setUniqueProperties(uniqueAttributes);
                    }
                }
                return entityProxy;
            }
            catch (TypeErrorException error) {
                OMRSErrorCode errorCode = OMRSErrorCode.REPOSITORY_LOGIC_ERROR;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{sourceName, "getNewEntityProxy", error.getErrorMessage()});
                throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getNewEntityProxy", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
        }
        return null;
    }

    public EntityProxy getNewEntityProxy(String sourceName, String metadataCollectionId, InstanceProvenanceType provenanceType, String userName, String typeName, InstanceProperties properties, List<Classification> classifications) throws TypeErrorException {
        EntityProxy entity = this.getSkeletonEntityProxy(sourceName, metadataCollectionId, provenanceType, userName, typeName);
        entity.setUniqueProperties(properties);
        entity.setClassifications(classifications);
        return entity;
    }

    public EntityProxy getSkeletonEntityProxy(String sourceName, String metadataCollectionId, InstanceProvenanceType provenanceType, String userName, String typeName) throws TypeErrorException {
        String methodName = "getSkeletonEntityProxy";
        this.validateRepositoryContentManager("getSkeletonEntityProxy");
        EntityProxy entity = new EntityProxy();
        String guid = UUID.randomUUID().toString();
        entity.setInstanceProvenanceType(provenanceType);
        entity.setMetadataCollectionId(metadataCollectionId);
        entity.setCreateTime(new Date());
        entity.setGUID(guid);
        entity.setVersion(1L);
        entity.setType(this.repositoryContentManager.getInstanceType(sourceName, TypeDefCategory.ENTITY_DEF, typeName, "getSkeletonEntityProxy"));
        entity.setStatus(this.repositoryContentManager.getInitialStatus(sourceName, typeName, "getSkeletonEntityProxy"));
        entity.setCreatedBy(userName);
        entity.setInstanceURL(this.repositoryContentManager.getEntityURL(sourceName, guid));
        return entity;
    }

    public boolean relatedEntity(String sourceName, String entityGUID, Relationship relationship) {
        if (relationship != null) {
            EntityProxy entityOneProxy = relationship.getEntityOneProxy();
            EntityProxy entityTwoProxy = relationship.getEntityTwoProxy();
            if (entityOneProxy != null && entityGUID.equals(entityOneProxy.getGUID())) {
                return true;
            }
            if (entityTwoProxy != null && entityGUID.equals(entityTwoProxy.getGUID())) {
                return true;
            }
        }
        return false;
    }

    private void removeProperty(String propertyName, InstanceProperties properties) {
        Map instancePropertyValueMap;
        if (properties != null && (instancePropertyValueMap = properties.getInstanceProperties()) != null) {
            instancePropertyValueMap.remove(propertyName);
            properties.setInstanceProperties(instancePropertyValueMap);
        }
    }

    public String getStringProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        InstancePropertyValue instancePropertyValue;
        String thisMethodName = "getStringProperty";
        if (properties != null && (instancePropertyValue = properties.getPropertyValue(propertyName)) != null) {
            try {
                PrimitivePropertyValue primitivePropertyValue;
                if (instancePropertyValue.getInstancePropertyCategory() == InstancePropertyCategory.PRIMITIVE && (primitivePropertyValue = (PrimitivePropertyValue)instancePropertyValue).getPrimitiveDefCategory() == PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING && primitivePropertyValue.getPrimitiveValue() != null) {
                    String retrievedProperty = primitivePropertyValue.getPrimitiveValue().toString();
                    log.debug("Retrieved " + propertyName + " property: " + retrievedProperty);
                    return retrievedProperty;
                }
            }
            catch (Throwable error) {
                this.throwHelperLogicError(sourceName, methodName, "getStringProperty");
            }
        }
        log.debug("No " + propertyName + " property");
        return null;
    }

    public String removeStringProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        String retrievedProperty = null;
        if (properties != null && (retrievedProperty = this.getStringProperty(sourceName, propertyName, properties, methodName)) != null) {
            this.removeProperty(propertyName, properties);
            log.debug("Properties left: " + properties.toString());
        }
        log.debug("Retrieved " + propertyName + " property: " + retrievedProperty);
        return retrievedProperty;
    }

    public InstanceProperties getMapProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        InstancePropertyValue instancePropertyValue;
        String thisMethodName = "getMapProperty";
        if (properties != null && (instancePropertyValue = properties.getPropertyValue(propertyName)) != null) {
            try {
                if (instancePropertyValue.getInstancePropertyCategory() == InstancePropertyCategory.MAP) {
                    MapPropertyValue mapPropertyValue = (MapPropertyValue)instancePropertyValue;
                    log.debug("Retrieved map property " + propertyName);
                    return mapPropertyValue.getMapValues();
                }
            }
            catch (Throwable error) {
                this.throwHelperLogicError(sourceName, methodName, "getMapProperty");
            }
        }
        log.debug("Map property " + propertyName + " not present");
        return null;
    }

    public List<String> getStringArrayProperty(String sourceName, String propertyName, InstanceProperties properties, String callingMethodName) {
        InstancePropertyValue instancePropertyValue;
        String thisMethodName = "getStringArrayProperty";
        if (properties != null && (instancePropertyValue = properties.getPropertyValue(propertyName)) != null) {
            log.debug("getStringArrayPropertyretrieved array property " + propertyName + " for " + callingMethodName);
            try {
                ArrayPropertyValue arrayPropertyValue;
                if (instancePropertyValue.getInstancePropertyCategory() == InstancePropertyCategory.ARRAY && (arrayPropertyValue = (ArrayPropertyValue)instancePropertyValue) != null && arrayPropertyValue.getArrayCount() > 0) {
                    log.debug("getStringArrayProperty found that array property " + propertyName + " has " + arrayPropertyValue.getArrayCount() + " elements.");
                    return this.getInstancePropertiesAsArray(arrayPropertyValue.getArrayValues(), callingMethodName);
                }
            }
            catch (Throwable error) {
                this.throwHelperLogicError(sourceName, callingMethodName, "getStringArrayProperty");
            }
        }
        log.debug(propertyName + " not present in " + properties);
        return null;
    }

    public List<String> removeStringArrayProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        List<String> retrievedProperty = null;
        if (properties != null && (retrievedProperty = this.getStringArrayProperty(sourceName, propertyName, properties, methodName)) != null) {
            this.removeProperty(propertyName, properties);
            log.debug("Properties left: " + properties.toString());
        }
        log.debug("Retrieved " + propertyName + " property: " + retrievedProperty);
        return retrievedProperty;
    }

    public List<String> getInstancePropertiesAsArray(InstanceProperties instanceProperties, String callingMethodName) {
        String thisMethodName = "getInstancePropertiesAsArray";
        if (instanceProperties != null) {
            Map instancePropertyValues = instanceProperties.getInstanceProperties();
            ArrayList<String> resultingArray = new ArrayList<String>();
            for (String arrayOrdinalName : instancePropertyValues.keySet()) {
                if (arrayOrdinalName != null) {
                    log.debug("getInstancePropertiesAsArray processing array element: " + arrayOrdinalName);
                    int arrayOrdinalNumber = Integer.decode(arrayOrdinalName);
                    InstancePropertyValue actualPropertyValue = instanceProperties.getPropertyValue(arrayOrdinalName);
                    if (actualPropertyValue != null) {
                        if (actualPropertyValue.getInstancePropertyCategory() == InstancePropertyCategory.PRIMITIVE) {
                            PrimitivePropertyValue primitivePropertyValue = (PrimitivePropertyValue)actualPropertyValue;
                            resultingArray.add(arrayOrdinalNumber, primitivePropertyValue.getPrimitiveValue().toString());
                            continue;
                        }
                        log.error("getInstancePropertiesAsArray skipping collection value: " + actualPropertyValue + " from method " + callingMethodName);
                        continue;
                    }
                    log.error("getInstancePropertiesAsArray skipping null value from method " + callingMethodName);
                    continue;
                }
                log.error("getInstancePropertiesAsArray skipping null ordinal from method " + callingMethodName);
            }
            log.debug("getInstancePropertiesAsArray returning array: " + resultingArray + " to method " + callingMethodName);
            return resultingArray;
        }
        log.debug("getInstancePropertiesAsArray has no property values to extract for method " + callingMethodName);
        return null;
    }

    public Map<String, String> getStringMapFromProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        Map<String, Object> mapFromProperty = this.getMapFromProperty(sourceName, propertyName, properties, methodName);
        if (mapFromProperty != null) {
            HashMap<String, String> stringMapFromProperty = new HashMap<String, String>();
            for (String mapPropertyName : mapFromProperty.keySet()) {
                Object actualPropertyValue = mapFromProperty.get(mapPropertyName);
                if (actualPropertyValue == null) continue;
                stringMapFromProperty.put(mapPropertyName, actualPropertyValue.toString());
            }
            if (!stringMapFromProperty.isEmpty()) {
                return stringMapFromProperty;
            }
        }
        return null;
    }

    public Map<String, String> removeStringMapFromProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        Map<String, String> retrievedProperty = null;
        if (properties != null && (retrievedProperty = this.getStringMapFromProperty(sourceName, propertyName, properties, methodName)) != null) {
            this.removeProperty(propertyName, properties);
            log.debug("Properties left: " + properties.toString());
        }
        log.debug("Retrieved " + propertyName + " property: " + retrievedProperty);
        return retrievedProperty;
    }

    public Map<String, Object> getMapFromProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        InstancePropertyValue instancePropertyValue;
        String thisMethodName = "getMapFromProperty";
        if (properties != null && (instancePropertyValue = properties.getPropertyValue(propertyName)) != null) {
            try {
                if (instancePropertyValue.getInstancePropertyCategory() == InstancePropertyCategory.MAP) {
                    MapPropertyValue mapInstancePropertyValue = (MapPropertyValue)instancePropertyValue;
                    log.debug("Retrieved map property " + propertyName);
                    return this.getInstancePropertiesAsMap(mapInstancePropertyValue.getMapValues());
                }
            }
            catch (Throwable error) {
                this.throwHelperLogicError(sourceName, methodName, "getMapFromProperty");
            }
        }
        log.debug("Map property " + propertyName + " not present");
        return null;
    }

    public Map<String, Object> getInstancePropertiesAsMap(InstanceProperties instanceProperties) {
        if (instanceProperties != null) {
            Map instancePropertyValues = instanceProperties.getInstanceProperties();
            HashMap<String, Object> resultingMap = new HashMap<String, Object>();
            for (String mapPropertyName : instancePropertyValues.keySet()) {
                InstancePropertyValue actualPropertyValue = instanceProperties.getPropertyValue(mapPropertyName);
                if (actualPropertyValue == null) continue;
                if (actualPropertyValue.getInstancePropertyCategory() == InstancePropertyCategory.PRIMITIVE) {
                    PrimitivePropertyValue primitivePropertyValue = (PrimitivePropertyValue)actualPropertyValue;
                    resultingMap.put(mapPropertyName, primitivePropertyValue.getPrimitiveValue());
                    continue;
                }
                if (actualPropertyValue.getInstancePropertyCategory() == InstancePropertyCategory.ENUM) {
                    EnumPropertyValue enumPropertyValue = (EnumPropertyValue)actualPropertyValue;
                    resultingMap.put(mapPropertyName, enumPropertyValue.getSymbolicName());
                    continue;
                }
                resultingMap.put(mapPropertyName, actualPropertyValue);
            }
            log.debug("Returning map: " + resultingMap);
            return resultingMap;
        }
        log.debug("No Properties present");
        return null;
    }

    public int getIntProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        InstancePropertyValue instancePropertyValue;
        String thisMethodName = "getIntProperty";
        if (properties != null && (instancePropertyValue = properties.getPropertyValue(propertyName)) != null) {
            try {
                PrimitivePropertyValue primitivePropertyValue;
                if (instancePropertyValue.getInstancePropertyCategory() == InstancePropertyCategory.PRIMITIVE && (primitivePropertyValue = (PrimitivePropertyValue)instancePropertyValue).getPrimitiveDefCategory() == PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT) {
                    log.debug("Retrieved integer property " + propertyName);
                    if (primitivePropertyValue.getPrimitiveValue() != null) {
                        return Integer.valueOf(primitivePropertyValue.getPrimitiveValue().toString());
                    }
                }
            }
            catch (Throwable error) {
                this.throwHelperLogicError(sourceName, methodName, "getIntProperty");
            }
        }
        log.debug("Integer property " + propertyName + " not present");
        return 0;
    }

    public int removeIntProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        int retrievedProperty = 0;
        if (properties != null) {
            retrievedProperty = this.getIntProperty(sourceName, propertyName, properties, methodName);
            this.removeProperty(propertyName, properties);
            log.debug("Properties left: " + properties.toString());
        }
        log.debug("Retrieved " + propertyName + " property: " + retrievedProperty);
        return retrievedProperty;
    }

    public Date getDateProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        InstancePropertyValue instancePropertyValue;
        String thisMethodName = "getDateProperty";
        if (properties != null && (instancePropertyValue = properties.getPropertyValue(propertyName)) != null) {
            try {
                PrimitivePropertyValue primitivePropertyValue;
                if (instancePropertyValue.getInstancePropertyCategory() == InstancePropertyCategory.PRIMITIVE && (primitivePropertyValue = (PrimitivePropertyValue)instancePropertyValue).getPrimitiveDefCategory() == PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE) {
                    log.debug("Retrieved date property " + propertyName);
                    if (primitivePropertyValue.getPrimitiveValue() != null) {
                        return (Date)primitivePropertyValue.getPrimitiveValue();
                    }
                }
            }
            catch (Throwable error) {
                this.throwHelperLogicError(sourceName, methodName, "getDateProperty");
            }
        }
        log.debug("Date property " + propertyName + " not present");
        return null;
    }

    public Date removeDateProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        Date retrievedProperty = null;
        if (properties != null) {
            retrievedProperty = this.getDateProperty(sourceName, propertyName, properties, methodName);
            this.removeProperty(propertyName, properties);
            log.debug("Properties left: " + properties.toString());
        }
        log.debug("Retrieved " + propertyName + " property: " + retrievedProperty);
        return retrievedProperty;
    }

    public boolean getBooleanProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        InstancePropertyValue instancePropertyValue;
        String thisMethodName = "getBooleanProperty";
        if (properties != null && (instancePropertyValue = properties.getPropertyValue(propertyName)) != null) {
            try {
                PrimitivePropertyValue primitivePropertyValue;
                if (instancePropertyValue.getInstancePropertyCategory() == InstancePropertyCategory.PRIMITIVE && (primitivePropertyValue = (PrimitivePropertyValue)instancePropertyValue).getPrimitiveDefCategory() == PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BOOLEAN) {
                    log.debug("Retrieved boolean property " + propertyName);
                    if (primitivePropertyValue.getPrimitiveValue() != null) {
                        return Boolean.valueOf(primitivePropertyValue.getPrimitiveValue().toString());
                    }
                }
            }
            catch (Throwable error) {
                this.throwHelperLogicError(sourceName, methodName, "getBooleanProperty");
            }
        }
        log.debug("Boolean property " + propertyName + " not present");
        return false;
    }

    public boolean removeBooleanProperty(String sourceName, String propertyName, InstanceProperties properties, String methodName) {
        boolean retrievedProperty = false;
        if (properties != null) {
            retrievedProperty = this.getBooleanProperty(sourceName, propertyName, properties, methodName);
            this.removeProperty(propertyName, properties);
            log.debug("Properties left: " + properties.toString());
        }
        log.debug("Retrieved " + propertyName + " property: " + retrievedProperty);
        return retrievedProperty;
    }

    public InstanceProperties addStringPropertyToInstance(String sourceName, InstanceProperties properties, String propertyName, String propertyValue, String methodName) {
        if (propertyValue != null) {
            InstanceProperties resultingProperties;
            log.debug("Adding property " + propertyName + " for " + methodName);
            if (properties == null) {
                log.debug("First property");
                resultingProperties = new InstanceProperties();
            } else {
                resultingProperties = properties;
            }
            PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
            primitivePropertyValue.setPrimitiveValue((Object)propertyValue);
            primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getName());
            primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getGUID());
            resultingProperties.setProperty(propertyName, (InstancePropertyValue)primitivePropertyValue);
            return resultingProperties;
        }
        log.debug("Null property");
        return properties;
    }

    public InstanceProperties addIntPropertyToInstance(String sourceName, InstanceProperties properties, String propertyName, int propertyValue, String methodName) {
        InstanceProperties resultingProperties;
        log.debug("Adding property " + propertyName + " for " + methodName);
        if (properties == null) {
            log.debug("First property");
            resultingProperties = new InstanceProperties();
        } else {
            resultingProperties = properties;
        }
        PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
        primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT);
        primitivePropertyValue.setPrimitiveValue((Object)propertyValue);
        primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT.getName());
        primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT.getGUID());
        resultingProperties.setProperty(propertyName, (InstancePropertyValue)primitivePropertyValue);
        return resultingProperties;
    }

    public InstanceProperties addLongPropertyToInstance(String sourceName, InstanceProperties properties, String propertyName, long propertyValue, String methodName) {
        InstanceProperties resultingProperties;
        log.debug("Adding property " + propertyName + " for " + methodName);
        if (properties == null) {
            log.debug("First property");
            resultingProperties = new InstanceProperties();
        } else {
            resultingProperties = properties;
        }
        PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
        primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_LONG);
        primitivePropertyValue.setPrimitiveValue((Object)propertyValue);
        resultingProperties.setProperty(propertyName, (InstancePropertyValue)primitivePropertyValue);
        return resultingProperties;
    }

    public InstanceProperties addFloatPropertyToInstance(String sourceName, InstanceProperties properties, String propertyName, float propertyValue, String methodName) {
        InstanceProperties resultingProperties;
        log.debug("Adding property " + propertyName + " for " + methodName);
        if (properties == null) {
            log.debug("First property");
            resultingProperties = new InstanceProperties();
        } else {
            resultingProperties = properties;
        }
        PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
        primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_FLOAT);
        primitivePropertyValue.setPrimitiveValue((Object)Float.valueOf(propertyValue));
        resultingProperties.setProperty(propertyName, (InstancePropertyValue)primitivePropertyValue);
        return resultingProperties;
    }

    public InstanceProperties addDatePropertyToInstance(String sourceName, InstanceProperties properties, String propertyName, Date propertyValue, String methodName) {
        InstanceProperties resultingProperties;
        log.debug("Adding property " + propertyName + " for " + methodName);
        if (properties == null) {
            log.debug("First property");
            resultingProperties = new InstanceProperties();
        } else {
            resultingProperties = properties;
        }
        PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
        primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE);
        primitivePropertyValue.setPrimitiveValue((Object)propertyValue);
        resultingProperties.setProperty(propertyName, (InstancePropertyValue)primitivePropertyValue);
        return resultingProperties;
    }

    public InstanceProperties addBooleanPropertyToInstance(String sourceName, InstanceProperties properties, String propertyName, boolean propertyValue, String methodName) {
        InstanceProperties resultingProperties;
        log.debug("Adding property " + propertyName + " for " + methodName);
        if (properties == null) {
            log.debug("First property");
            resultingProperties = new InstanceProperties();
        } else {
            resultingProperties = properties;
        }
        PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
        primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BOOLEAN);
        primitivePropertyValue.setPrimitiveValue((Object)propertyValue);
        primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BOOLEAN.getName());
        primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BOOLEAN.getGUID());
        resultingProperties.setProperty(propertyName, (InstancePropertyValue)primitivePropertyValue);
        return resultingProperties;
    }

    public InstanceProperties addEnumPropertyToInstance(String sourceName, InstanceProperties properties, String propertyName, int ordinal, String symbolicName, String description, String methodName) {
        InstanceProperties resultingProperties;
        log.debug("Adding property " + propertyName + " for " + methodName);
        if (properties == null) {
            log.debug("First property");
            resultingProperties = new InstanceProperties();
        } else {
            resultingProperties = properties;
        }
        EnumPropertyValue enumPropertyValue = new EnumPropertyValue();
        enumPropertyValue.setOrdinal(ordinal);
        enumPropertyValue.setSymbolicName(symbolicName);
        enumPropertyValue.setDescription(description);
        resultingProperties.setProperty(propertyName, (InstancePropertyValue)enumPropertyValue);
        return resultingProperties;
    }

    public InstanceProperties addMapPropertyToInstance(String sourceName, InstanceProperties properties, String propertyName, Map<String, String> mapValues, String methodName) {
        if (mapValues != null) {
            log.debug("Adding property " + propertyName + " for " + methodName);
            if (mapValues != null && !mapValues.isEmpty()) {
                InstanceProperties resultingProperties = properties == null ? new InstanceProperties() : properties;
                InstanceProperties mapInstanceProperties = this.addPropertyMapToInstance(sourceName, null, propertyName, mapValues, methodName);
                if (mapInstanceProperties != null) {
                    MapPropertyValue mapPropertyValue = new MapPropertyValue();
                    mapPropertyValue.setMapValues(mapInstanceProperties);
                    resultingProperties.setProperty(propertyName, (InstancePropertyValue)mapPropertyValue);
                    log.debug("Returning instanceProperty: " + resultingProperties.toString());
                    return resultingProperties;
                }
            }
        }
        log.debug("Null property");
        return properties;
    }

    public InstanceProperties addPropertyMapToInstance(String sourceName, InstanceProperties properties, String propertyName, Map<String, String> mapValues, String methodName) {
        if (mapValues != null && !mapValues.isEmpty()) {
            log.debug("Adding property " + propertyName + " for " + methodName);
            InstanceProperties resultingProperties = properties == null ? new InstanceProperties() : properties;
            int propertyCount = 0;
            for (String mapPropertyName : mapValues.keySet()) {
                PrimitivePropertyValue primitivePropertyValue;
                String mapPropertyValue = mapValues.get(mapPropertyName);
                if (mapPropertyValue instanceof String) {
                    primitivePropertyValue = new PrimitivePropertyValue();
                    primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
                    primitivePropertyValue.setPrimitiveValue((Object)mapPropertyValue);
                    primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getName());
                    primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getGUID());
                    resultingProperties.setProperty(mapPropertyName, (InstancePropertyValue)primitivePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Integer) {
                    primitivePropertyValue = new PrimitivePropertyValue();
                    primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT);
                    primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT.getName());
                    primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT.getGUID());
                    primitivePropertyValue.setPrimitiveValue((Object)mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, (InstancePropertyValue)primitivePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Long) {
                    primitivePropertyValue = new PrimitivePropertyValue();
                    primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_LONG);
                    primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_LONG.getName());
                    primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_LONG.getGUID());
                    primitivePropertyValue.setPrimitiveValue((Object)mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, (InstancePropertyValue)primitivePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Short) {
                    primitivePropertyValue = new PrimitivePropertyValue();
                    primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_SHORT);
                    primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_SHORT.getName());
                    primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_SHORT.getGUID());
                    primitivePropertyValue.setPrimitiveValue((Object)mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, (InstancePropertyValue)primitivePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Date) {
                    primitivePropertyValue = new PrimitivePropertyValue();
                    primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE);
                    primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE.getName());
                    primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE.getGUID());
                    primitivePropertyValue.setPrimitiveValue((Object)mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, (InstancePropertyValue)primitivePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Character) {
                    primitivePropertyValue = new PrimitivePropertyValue();
                    primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_CHAR);
                    primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_CHAR.getName());
                    primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_CHAR.getGUID());
                    primitivePropertyValue.setPrimitiveValue((Object)mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, (InstancePropertyValue)primitivePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Byte) {
                    primitivePropertyValue = new PrimitivePropertyValue();
                    primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BYTE);
                    primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BYTE.getName());
                    primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BYTE.getGUID());
                    primitivePropertyValue.setPrimitiveValue((Object)mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, (InstancePropertyValue)primitivePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Boolean) {
                    primitivePropertyValue = new PrimitivePropertyValue();
                    primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BOOLEAN);
                    primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BOOLEAN.getName());
                    primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BOOLEAN.getGUID());
                    primitivePropertyValue.setPrimitiveValue((Object)mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, (InstancePropertyValue)primitivePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Float) {
                    primitivePropertyValue = new PrimitivePropertyValue();
                    primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_FLOAT);
                    primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_FLOAT.getName());
                    primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_FLOAT.getGUID());
                    primitivePropertyValue.setPrimitiveValue((Object)mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, (InstancePropertyValue)primitivePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof BigDecimal) {
                    primitivePropertyValue = new PrimitivePropertyValue();
                    primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BIGDECIMAL);
                    primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BIGDECIMAL.getName());
                    primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BIGDECIMAL.getGUID());
                    primitivePropertyValue.setPrimitiveValue((Object)mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, (InstancePropertyValue)primitivePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof BigInteger) {
                    primitivePropertyValue = new PrimitivePropertyValue();
                    primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BIGINTEGER);
                    primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BIGINTEGER.getName());
                    primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BIGINTEGER.getGUID());
                    primitivePropertyValue.setPrimitiveValue((Object)mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, (InstancePropertyValue)primitivePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Double) {
                    primitivePropertyValue = new PrimitivePropertyValue();
                    primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DOUBLE);
                    primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DOUBLE.getName());
                    primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DOUBLE.getGUID());
                    primitivePropertyValue.setPrimitiveValue((Object)mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, (InstancePropertyValue)primitivePropertyValue);
                    ++propertyCount;
                    continue;
                }
                primitivePropertyValue = new PrimitivePropertyValue();
                primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN);
                primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN.getName());
                primitivePropertyValue.setTypeGUID(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN.getGUID());
                primitivePropertyValue.setPrimitiveValue((Object)mapPropertyValue);
                resultingProperties.setProperty(mapPropertyName, (InstancePropertyValue)primitivePropertyValue);
                ++propertyCount;
            }
            if (propertyCount > 0) {
                log.debug("Returning instanceProperty: " + resultingProperties.toString());
                return resultingProperties;
            }
        }
        log.debug("Null property");
        return properties;
    }

    public String getTypeName(InstanceAuditHeader instance) throws RepositoryErrorException, InvalidParameterException {
        String methodName = "getTypeName";
        if (instance != null) {
            InstanceType type = instance.getType();
            if (type != null && type.getTypeDefName() != null) {
                return type.getTypeDefName();
            }
            this.throwRepositoryContentError("getTypeName", instance);
        }
        this.throwParameterError("getTypeName");
        return null;
    }

    public String getEnd1EntityGUID(Relationship relationship) {
        EntityProxy entityProxy;
        if (relationship != null && (entityProxy = relationship.getEntityOneProxy()) != null && entityProxy.getGUID() != null) {
            return entityProxy.getGUID();
        }
        return null;
    }

    public String getEnd2EntityGUID(Relationship relationship) {
        EntityProxy entityProxy;
        if (relationship != null && (entityProxy = relationship.getEntityTwoProxy()) != null && entityProxy.getGUID() != null) {
            return entityProxy.getGUID();
        }
        return null;
    }

    public List<EntityDetail> formatEntityResults(List<EntityDetail> fullResults, int fromElement, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws PagingErrorException, PropertyErrorException {
        if (fullResults == null) {
            return null;
        }
        if (fullResults.isEmpty()) {
            return null;
        }
        int fullResultsSize = fullResults.size();
        List<EntityDetail> sortedResults = fullResults;
        if (pageSize == 0 || pageSize > sortedResults.size()) {
            return sortedResults;
        }
        int toIndex = this.getToIndex(fromElement, pageSize, fullResultsSize);
        return new ArrayList<EntityDetail>(fullResults.subList(fromElement, toIndex));
    }

    public List<Relationship> formatRelationshipResults(List<Relationship> fullResults, int fromElement, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws PagingErrorException, PropertyErrorException {
        if (fullResults == null) {
            return null;
        }
        if (fullResults.isEmpty()) {
            return null;
        }
        int fullResultsSize = fullResults.size();
        if (fromElement > fullResultsSize) {
            return null;
        }
        List<Relationship> sortedResults = fullResults;
        if (pageSize == 0 || pageSize > sortedResults.size()) {
            return sortedResults;
        }
        int toIndex = this.getToIndex(fromElement, pageSize, fullResultsSize);
        return new ArrayList<Relationship>(fullResults.subList(fromElement, toIndex));
    }

    private int getToIndex(int fromIndex, int pageSize, int totalSize) {
        int toIndex = 0;
        toIndex = totalSize < fromIndex + pageSize ? totalSize : fromIndex + pageSize;
        return toIndex;
    }

    private void throwHelperLogicError(String sourceName, String originatingMethodName, String localMethodName) {
        OMRSErrorCode errorCode = OMRSErrorCode.HELPER_LOGIC_ERROR;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{sourceName, localMethodName, originatingMethodName});
        throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), localMethodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    private void throwParameterError(String methodName) throws InvalidParameterException {
        OMRSErrorCode errorCode = OMRSErrorCode.NULL_PARAMETER;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
        throw new InvalidParameterException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    private void throwRepositoryContentError(String methodName, InstanceAuditHeader instance) throws RepositoryErrorException {
        OMRSErrorCode errorCode = OMRSErrorCode.INVALID_INSTANCE;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName, instance.toString()});
        throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    private void validateRepositoryContentManager(String methodName) {
        if (this.repositoryContentManager == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.LOCAL_REPOSITORY_CONFIGURATION_ERROR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[0]);
            throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }
}

