/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.metadatahighway.cohortregistry;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditCode;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.cohortregistrystore.OMRSCohortRegistryStore;
import org.odpi.openmetadata.repositoryservices.connectors.stores.cohortregistrystore.properties.MemberRegistration;
import org.odpi.openmetadata.repositoryservices.enterprise.connectormanager.OMRSConnectionConsumer;
import org.odpi.openmetadata.repositoryservices.events.OMRSRegistryEventProcessor;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSConfigErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMRSCohortRegistry
extends OMRSRegistryEventProcessor {
    private String cohortName = null;
    private String localMetadataCollectionId = null;
    private String localMetadataCollectionName = null;
    private Connection localRepositoryRemoteConnection = null;
    private String localServerName = null;
    private String localServerType = null;
    private String localOrganizationName = null;
    private OMRSCohortRegistryStore registryStore = null;
    private OMRSRegistryEventProcessor outboundRegistryEventProcessor = null;
    private OMRSConnectionConsumer connectionConsumer = null;
    private OMRSAuditLog auditLog;
    private static final Logger log = LoggerFactory.getLogger(OMRSCohortRegistry.class);

    public OMRSCohortRegistry(OMRSAuditLog auditLog) {
        this.auditLog = auditLog;
    }

    private void validateLocalMetadataCollectionId(String configuredLocalMetadataCollectionId) {
        String storedLocalMetadataCollectionId;
        String methodName = "validateLocalMetadataCollectionId()";
        if (this.registryStore == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_REGISTRY_STORE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{this.cohortName});
            throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        MemberRegistration localRegistration = this.registryStore.retrieveLocalRegistration();
        if (localRegistration != null && (storedLocalMetadataCollectionId = localRegistration.getMetadataCollectionId()) != null && !storedLocalMetadataCollectionId.equals(configuredLocalMetadataCollectionId)) {
            if (configuredLocalMetadataCollectionId == null) {
                this.unRegisterLocalRepositoryWithCohort(localRegistration);
                this.registryStore.removeLocalRegistration();
            } else {
                OMRSErrorCode errorCode = OMRSErrorCode.INVALID_LOCAL_METADATA_COLLECTION_ID;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{this.cohortName, this.localServerName, storedLocalMetadataCollectionId, configuredLocalMetadataCollectionId});
                throw new OMRSConfigErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
        }
    }

    public void initialize(String cohortName, String localMetadataCollectionId, String localMetadataCollectionName, Connection localRepositoryRemoteConnection, String localServerName, String localServerType, String localOrganizationName, OMRSRegistryEventProcessor registryEventProcessor, OMRSCohortRegistryStore cohortRegistryStore, OMRSConnectionConsumer connectionConsumer) {
        String actionDescription = "Initialize cohort registry";
        if (cohortRegistryStore == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_REGISTRY_STORE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{cohortName});
            throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), actionDescription, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        this.registryStore = cohortRegistryStore;
        this.localServerName = localServerName;
        this.localServerType = localServerType;
        this.localOrganizationName = localOrganizationName;
        this.cohortName = cohortName;
        this.outboundRegistryEventProcessor = registryEventProcessor;
        this.validateLocalMetadataCollectionId(localMetadataCollectionId);
        this.localMetadataCollectionId = localMetadataCollectionId;
        this.localMetadataCollectionName = localMetadataCollectionName;
        this.connectionConsumer = connectionConsumer;
        this.localRepositoryRemoteConnection = localRepositoryRemoteConnection;
    }

    public void connectToCohort() {
        List remoteRegistrations;
        if (this.registryStore == null) {
            String methodName = "connectToCohort";
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_REGISTRY_STORE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[0]);
            throw new OMRSRuntimeException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        MemberRegistration localRegistration = this.registryStore.retrieveLocalRegistration();
        if (localRegistration == null) {
            localRegistration = new MemberRegistration();
        }
        localRegistration.setMetadataCollectionId(this.localMetadataCollectionId);
        localRegistration.setMetadataCollectionName(this.localMetadataCollectionName);
        localRegistration.setServerName(this.localServerName);
        localRegistration.setServerType(this.localServerType);
        localRegistration.setOrganizationName(this.localOrganizationName);
        localRegistration.setRepositoryConnection(this.localRepositoryRemoteConnection);
        if (this.localMetadataCollectionId == null) {
            this.requestReRegistrationFromCohort(localRegistration);
        } else if (localRegistration.getRegistrationTime() == null) {
            localRegistration.setRegistrationTime(new Date());
            if (this.registerLocalRepositoryWithCohort(localRegistration)) {
                this.registryStore.saveLocalRegistration(localRegistration);
            }
        } else {
            this.registryStore.saveLocalRegistration(localRegistration);
            if (this.connectionConsumer != null) {
                this.requestReRegistrationFromCohort(localRegistration);
            }
        }
        if (this.connectionConsumer != null && (remoteRegistrations = this.registryStore.retrieveRemoteRegistrations()) != null) {
            for (MemberRegistration remoteMember : remoteRegistrations) {
                if (remoteMember == null) continue;
                this.registerRemoteConnectionWithConsumer(remoteMember.getMetadataCollectionId(), remoteMember.getMetadataCollectionName(), remoteMember.getServerName(), remoteMember.getServerType(), remoteMember.getOrganizationName(), remoteMember.getRepositoryConnection());
            }
        }
    }

    public void disconnectFromCohort(boolean permanent) {
        String actionDescription = "Disconnect from Cohort";
        if (this.registryStore != null) {
            if (permanent) {
                MemberRegistration localRegistration = this.registryStore.retrieveLocalRegistration();
                OMRSAuditCode auditCode = OMRSAuditCode.COHORT_PERMANENTLY_DISCONNECTING;
                this.auditLog.logRecord("Disconnect from Cohort", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{this.cohortName}), null, auditCode.getSystemAction(), auditCode.getUserAction());
                if (localRegistration != null) {
                    this.unRegisterLocalRepositoryWithCohort(localRegistration);
                }
                this.registryStore.clearAllRegistrations();
                if (this.connectionConsumer != null) {
                    this.connectionConsumer.removeCohort(this.cohortName);
                }
            } else {
                OMRSAuditCode auditCode = OMRSAuditCode.COHORT_DISCONNECTING;
                this.auditLog.logRecord("Disconnect from Cohort", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{this.cohortName}), null, auditCode.getSystemAction(), auditCode.getUserAction());
            }
            this.registryStore.close();
        }
    }

    private boolean registerLocalRepositoryWithCohort(MemberRegistration localRegistration) {
        String actionDescription = "Registering with cohort";
        OMRSAuditCode auditCode = OMRSAuditCode.REGISTERED_WITH_COHORT;
        this.auditLog.logRecord("Registering with cohort", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{this.cohortName, this.localMetadataCollectionId}), null, auditCode.getSystemAction(), auditCode.getUserAction());
        return this.outboundRegistryEventProcessor.processRegistrationEvent(this.cohortName, localRegistration.getMetadataCollectionId(), localRegistration.getMetadataCollectionName(), localRegistration.getServerName(), localRegistration.getServerType(), localRegistration.getOrganizationName(), localRegistration.getRegistrationTime(), localRegistration.getRepositoryConnection());
    }

    private void requestReRegistrationFromCohort(MemberRegistration localRegistration) {
        String actionDescription = "Re-registering with cohort";
        OMRSAuditCode auditCode = OMRSAuditCode.RE_REGISTERED_WITH_COHORT;
        this.auditLog.logRecord("Re-registering with cohort", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{this.cohortName}), null, auditCode.getSystemAction(), auditCode.getUserAction());
        this.outboundRegistryEventProcessor.processRegistrationRefreshRequest(this.cohortName, localRegistration.getServerName(), localRegistration.getServerType(), localRegistration.getOrganizationName());
    }

    private void unRegisterLocalRepositoryWithCohort(MemberRegistration localRegistration) {
        String actionDescription = "Unregistering from cohort";
        OMRSAuditCode auditCode = OMRSAuditCode.UNREGISTERING_FROM_COHORT;
        this.auditLog.logRecord("Unregistering from cohort", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{this.cohortName, localRegistration.getMetadataCollectionId()}), null, auditCode.getSystemAction(), auditCode.getUserAction());
        this.outboundRegistryEventProcessor.processUnRegistrationEvent(this.cohortName, localRegistration.getMetadataCollectionId(), localRegistration.getMetadataCollectionName(), localRegistration.getServerName(), localRegistration.getServerType(), localRegistration.getOrganizationName());
    }

    private void registerRemoteConnectionWithConsumer(String remoteMetadataCollectionId, String remoteMetadataCollectionName, String remoteServerName, String remoteServerType, String owningOrganizationName, Connection remoteRepositoryConnection) {
        block5: {
            String actionDescription = "Receiving registration request";
            OMRSAuditCode auditCode = OMRSAuditCode.OUTGOING_BAD_CONNECTION;
            if (this.connectionConsumer != null) {
                try {
                    this.connectionConsumer.addRemoteConnection(this.cohortName, remoteServerName, remoteServerType, owningOrganizationName, remoteMetadataCollectionId, remoteMetadataCollectionName, remoteRepositoryConnection);
                }
                catch (OCFCheckedExceptionBase error) {
                    this.auditLog.logRecord("Receiving registration request", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{this.cohortName, remoteRepositoryConnection.getQualifiedName(), remoteServerName, remoteMetadataCollectionId}), error.getErrorMessage(), auditCode.getSystemAction(), auditCode.getUserAction());
                    if (this.outboundRegistryEventProcessor != null) {
                        this.outboundRegistryEventProcessor.processBadConnectionEvent(this.cohortName, this.localMetadataCollectionId, this.localMetadataCollectionName, this.localServerName, this.localServerType, this.localOrganizationName, remoteMetadataCollectionId, remoteRepositoryConnection, error.getErrorMessage());
                    }
                }
                catch (Throwable error) {
                    String formattedLogMessage = auditCode.getFormattedLogMessage(new String[]{this.cohortName, remoteRepositoryConnection.getQualifiedName(), remoteServerName, remoteMetadataCollectionId});
                    this.auditLog.logRecord("Receiving registration request", auditCode.getLogMessageId(), auditCode.getSeverity(), formattedLogMessage, error.toString(), auditCode.getSystemAction(), auditCode.getUserAction());
                    if (this.outboundRegistryEventProcessor == null) break block5;
                    this.outboundRegistryEventProcessor.processBadConnectionEvent(this.cohortName, this.localMetadataCollectionId, this.localMetadataCollectionName, this.localServerName, this.localServerType, this.localOrganizationName, remoteMetadataCollectionId, remoteRepositoryConnection, auditCode.getLogMessageId() + formattedLogMessage);
                }
            }
        }
    }

    private void unRegisterRemoteConnectionWithConsumer(String remoteMetadataCollectionId) {
        if (this.connectionConsumer != null) {
            this.connectionConsumer.removeRemoteConnection(this.cohortName, remoteMetadataCollectionId);
        }
    }

    public boolean processRegistrationEvent(String sourceName, String originatorMetadataCollectionId, String originatorMetadataCollectionName, String originatorServerName, String originatorServerType, String originatorOrganizationName, Date registrationTimestamp, Connection remoteConnection) {
        String actionDescription = "Receiving Registration event";
        if (this.registryStore != null) {
            MemberRegistration remoteRegistration = new MemberRegistration();
            remoteRegistration.setMetadataCollectionId(originatorMetadataCollectionId);
            remoteRegistration.setMetadataCollectionName(originatorMetadataCollectionName);
            remoteRegistration.setServerName(originatorServerName);
            remoteRegistration.setServerType(originatorServerType);
            remoteRegistration.setOrganizationName(originatorOrganizationName);
            remoteRegistration.setRegistrationTime(registrationTimestamp);
            remoteRegistration.setRepositoryConnection(remoteConnection);
            this.registryStore.saveRemoteRegistration(remoteRegistration);
            if (remoteConnection != null) {
                this.registerRemoteConnectionWithConsumer(originatorMetadataCollectionId, originatorMetadataCollectionName, originatorServerName, originatorServerType, originatorOrganizationName, remoteConnection);
            }
            OMRSAuditCode auditCode = OMRSAuditCode.NEW_MEMBER_IN_COHORT;
            this.auditLog.logRecord("Receiving Registration event", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{this.cohortName, originatorServerName, originatorMetadataCollectionId}), null, auditCode.getSystemAction(), auditCode.getUserAction());
            return true;
        }
        return false;
    }

    public boolean processRegistrationRefreshRequest(String sourceName, String originatorServerName, String originatorServerType, String originatorOrganizationName) {
        String actionDescription = "Receiving Registration Refresh event";
        if (this.registryStore != null) {
            MemberRegistration localRegistration = this.registryStore.retrieveLocalRegistration();
            if (localRegistration != null) {
                OMRSAuditCode auditCode = OMRSAuditCode.REFRESHING_REGISTRATION_WITH_COHORT;
                this.auditLog.logRecord("Receiving Registration Refresh event", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{this.cohortName, this.localMetadataCollectionId, originatorServerName}), null, auditCode.getSystemAction(), auditCode.getUserAction());
                return this.outboundRegistryEventProcessor.processReRegistrationEvent(this.cohortName, localRegistration.getMetadataCollectionId(), localRegistration.getMetadataCollectionName(), localRegistration.getServerName(), localRegistration.getServerType(), localRegistration.getOrganizationName(), localRegistration.getRegistrationTime(), localRegistration.getRepositoryConnection());
            }
            return true;
        }
        OMRSAuditCode auditCode = OMRSAuditCode.MISSING_MEMBER_REGISTRATION;
        this.auditLog.logRecord("Receiving Registration Refresh event", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{originatorServerName, this.cohortName}), null, auditCode.getSystemAction(), auditCode.getUserAction());
        return false;
    }

    public boolean processReRegistrationEvent(String sourceName, String originatorMetadataCollectionId, String originatorMetadataCollectionName, String originatorServerName, String originatorServerType, String originatorOrganizationName, Date registrationTimestamp, Connection remoteConnection) {
        String actionDescription = "Receiving ReRegistration event";
        if (this.registryStore != null) {
            MemberRegistration remoteRegistration = new MemberRegistration();
            remoteRegistration.setMetadataCollectionId(originatorMetadataCollectionId);
            remoteRegistration.setMetadataCollectionName(originatorMetadataCollectionName);
            remoteRegistration.setServerName(originatorServerName);
            remoteRegistration.setServerType(originatorServerType);
            remoteRegistration.setOrganizationName(originatorOrganizationName);
            remoteRegistration.setRegistrationTime(registrationTimestamp);
            remoteRegistration.setRepositoryConnection(remoteConnection);
            this.registryStore.saveRemoteRegistration(remoteRegistration);
            if (remoteConnection != null) {
                this.registerRemoteConnectionWithConsumer(originatorMetadataCollectionId, originatorMetadataCollectionName, originatorServerName, originatorServerType, originatorOrganizationName, remoteConnection);
            }
            OMRSAuditCode auditCode = OMRSAuditCode.REFRESHED_MEMBER_IN_COHORT;
            this.auditLog.logRecord("Receiving ReRegistration event", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{this.cohortName, originatorServerName, originatorMetadataCollectionId}), null, auditCode.getSystemAction(), auditCode.getUserAction());
            return true;
        }
        OMRSAuditCode auditCode = OMRSAuditCode.MISSING_MEMBER_REGISTRATION;
        this.auditLog.logRecord("Receiving ReRegistration event", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{originatorServerName, this.cohortName}), null, auditCode.getSystemAction(), auditCode.getUserAction());
        return false;
    }

    public boolean processUnRegistrationEvent(String sourceName, String originatorMetadataCollectionId, String originatorMetadataCollectionName, String originatorServerName, String originatorServerType, String originatorOrganizationName) {
        String actionDescription = "Receiving unregistration event";
        if (this.registryStore != null) {
            this.registryStore.removeRemoteRegistration(originatorMetadataCollectionId);
            this.unRegisterRemoteConnectionWithConsumer(originatorMetadataCollectionId);
            OMRSAuditCode auditCode = OMRSAuditCode.MEMBER_LEFT_COHORT;
            this.auditLog.logRecord("Receiving unregistration event", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{originatorServerName, originatorMetadataCollectionId, this.cohortName}), null, auditCode.getSystemAction(), auditCode.getUserAction());
            return true;
        }
        OMRSAuditCode auditCode = OMRSAuditCode.MISSING_MEMBER_REGISTRATION;
        this.auditLog.logRecord("Receiving unregistration event", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{originatorServerName, this.cohortName}), null, auditCode.getSystemAction(), auditCode.getUserAction());
        return false;
    }

    public void processConflictingCollectionIdEvent(String sourceName, String originatorMetadataCollectionId, String originatorMetadataCollectionName, String originatorServerName, String originatorServerType, String originatorOrganizationName, String conflictingMetadataCollectionId, String errorMessage) {
        if (conflictingMetadataCollectionId != null) {
            String actionDescription = "Receiving Conflicting Metadata Collection Id event";
            if (conflictingMetadataCollectionId.equals(this.localMetadataCollectionId)) {
                OMRSAuditCode auditCode = OMRSAuditCode.INCOMING_CONFLICTING_LOCAL_METADATA_COLLECTION_ID;
                this.auditLog.logRecord("Receiving Conflicting Metadata Collection Id event", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{this.cohortName, originatorServerName, originatorMetadataCollectionId, conflictingMetadataCollectionId}), null, auditCode.getSystemAction(), auditCode.getUserAction());
            } else {
                OMRSAuditCode auditCode = OMRSAuditCode.INCOMING_CONFLICTING_METADATA_COLLECTION_ID;
                this.auditLog.logRecord("Receiving Conflicting Metadata Collection Id event", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{this.cohortName, conflictingMetadataCollectionId}), null, auditCode.getSystemAction(), auditCode.getUserAction());
            }
        }
    }

    public void processBadConnectionEvent(String sourceName, String originatorMetadataCollectionId, String originatorMetadataCollectionName, String originatorServerName, String originatorServerType, String originatorOrganizationName, String targetMetadataCollectionId, Connection remoteRepositoryConnection, String errorMessage) {
        if (targetMetadataCollectionId != null && targetMetadataCollectionId.equals(this.localMetadataCollectionId)) {
            String actionDescription = "Receiving Bad Connection event";
            OMRSAuditCode auditCode = OMRSAuditCode.INCOMING_BAD_CONNECTION;
            this.auditLog.logRecord("Receiving Bad Connection event", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{this.cohortName, originatorServerName, originatorMetadataCollectionId, remoteRepositoryConnection.getQualifiedName()}), remoteRepositoryConnection.toString(), auditCode.getSystemAction(), auditCode.getUserAction());
        }
    }

    public String toString() {
        return "OMRSCohortRegistry{cohortName='" + this.cohortName + '\'' + ", localMetadataCollectionId='" + this.localMetadataCollectionId + '\'' + ", localMetadataCollectionName='" + this.localMetadataCollectionName + '\'' + ", localRepositoryRemoteConnection=" + this.localRepositoryRemoteConnection + ", localServerName='" + this.localServerName + '\'' + ", localServerType='" + this.localServerType + '\'' + ", localOrganizationName='" + this.localOrganizationName + '\'' + ", registryStore=" + this.registryStore + ", outboundRegistryEventProcessor=" + this.outboundRegistryEventProcessor + ", connectionConsumer=" + this.connectionConsumer + '}';
    }
}

