/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.rest.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceGraph;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefGallery;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.HomeEntityException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.HomeRelationshipException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidEntityException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidRelationshipException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidTypeDefException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PatchErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.StatusNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefInUseException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.localrepository.repositoryconnector.LocalOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.rest.properties.AttributeTypeDefListResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.AttributeTypeDefResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.BooleanResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.EntityCreateRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.EntityDetailResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.EntityListResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.EntityNeighborhoodFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.EntityNeighborhoodHistoricalFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.EntityPropertyFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.EntityPropertyHistoricalFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.EntitySummaryResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.InstanceGraphRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.InstanceGraphResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.InstancePropertiesRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.MetadataCollectionIdResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.OMRSAPIFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.OMRSAPIHistoricalFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.OMRSAPIResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.PropertyMatchFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.PropertyMatchHistoricalFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.RelatedEntitiesFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.RelatedEntitiesHistoricalFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.RelationshipCreateRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.RelationshipListResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.RelationshipResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.TypeDefChangeRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.TypeDefGalleryResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.TypeDefListResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.TypeDefReIdentifyRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.TypeDefResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.TypeDefValidationForRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.TypeLimitedFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.TypeLimitedHistoricalFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.VoidResponse;
import org.odpi.openmetadata.repositoryservices.rest.services.OMRSRepositoryServicesInstance;
import org.odpi.openmetadata.repositoryservices.rest.services.OMRSRepositoryServicesInstanceMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMRSRepositoryRESTServices {
    private static final Logger log = LoggerFactory.getLogger(OMRSRepositoryRESTServices.class);
    private static OMRSRepositoryServicesInstanceMap servicesInstanceMap = new OMRSRepositoryServicesInstanceMap();

    public static void setLocalRepository(String localServerName, LocalOMRSRepositoryConnector localRepositoryConnector, String localServerURL) {
        OMRSRepositoryServicesInstance instance = new OMRSRepositoryServicesInstance(localRepositoryConnector, localServerURL);
        servicesInstanceMap.setNewInstance(localServerName, instance);
    }

    public static String getEntityURL(String localServerName, String ... guid) {
        OMRSRepositoryServicesInstance localServerInstance;
        if (localServerName != null && (localServerInstance = servicesInstanceMap.getInstance(localServerName)) != null) {
            String localServerURL = localServerInstance.getLocalServerURL();
            String urlTemplate = "/instances/entity/{0}";
            MessageFormat mf = new MessageFormat("/instances/entity/{0}");
            return localServerURL + mf.format(guid);
        }
        return null;
    }

    public static String getRelationshipURL(String localServerName, String ... guid) {
        OMRSRepositoryServicesInstance localServerInstance;
        if (localServerName != null && (localServerInstance = servicesInstanceMap.getInstance(localServerName)) != null) {
            String localServerURL = localServerInstance.getLocalServerURL();
            String urlTemplate = "/instances/relationship/{0}";
            MessageFormat mf = new MessageFormat("/instances/relationship/{0}");
            return localServerURL + mf.format(guid);
        }
        return null;
    }

    public MetadataCollectionIdResponse getMetadataCollectionId(String serverName) {
        String methodName = "getMetadataCollectionId";
        log.debug("Calling method: getMetadataCollectionId");
        MetadataCollectionIdResponse response = new MetadataCollectionIdResponse();
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "getMetadataCollectionId");
            response.setMetadataCollectionId(localMetadataCollection.getMetadataCollectionId());
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: getMetadataCollectionId with response: " + response.toString());
        return response;
    }

    public TypeDefGalleryResponse getAllTypes(String serverName, String userId) {
        String methodName = "getAllTypes";
        log.debug("Calling method: getAllTypes");
        TypeDefGalleryResponse response = new TypeDefGalleryResponse();
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "getAllTypes");
            TypeDefGallery typeDefGallery = localMetadataCollection.getAllTypes(userId);
            if (typeDefGallery != null) {
                response.setAttributeTypeDefs(typeDefGallery.getAttributeTypeDefs());
                response.setTypeDefs((List)typeDefGallery.getTypeDefs());
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: getAllTypes with response: " + response.toString());
        return response;
    }

    public TypeDefGalleryResponse findTypesByName(String serverName, String userId, String name) {
        String methodName = "findTypesByName";
        log.debug("Calling method: findTypesByName");
        TypeDefGalleryResponse response = new TypeDefGalleryResponse();
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "findTypesByName");
            TypeDefGallery typeDefGallery = localMetadataCollection.findTypesByName(userId, name);
            if (typeDefGallery != null) {
                response.setAttributeTypeDefs(typeDefGallery.getAttributeTypeDefs());
                response.setTypeDefs((List)typeDefGallery.getTypeDefs());
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: findTypesByName with response: " + response.toString());
        return response;
    }

    public TypeDefListResponse findTypeDefsByCategory(String serverName, String userId, TypeDefCategory category) {
        String methodName = "findTypeDefsByCategory";
        log.debug("Calling method: findTypeDefsByCategory");
        TypeDefListResponse response = new TypeDefListResponse();
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "findTypeDefsByCategory");
            response.setTypeDefs(localMetadataCollection.findTypeDefsByCategory(userId, category));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: findTypeDefsByCategory with response: " + response.toString());
        return response;
    }

    public AttributeTypeDefListResponse findAttributeTypeDefsByCategory(String serverName, String userId, AttributeTypeDefCategory category) {
        String methodName = "findAttributeTypeDefsByCategory";
        log.debug("Calling method: findAttributeTypeDefsByCategory");
        AttributeTypeDefListResponse response = new AttributeTypeDefListResponse();
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "findAttributeTypeDefsByCategory");
            response.setAttributeTypeDefs(localMetadataCollection.findAttributeTypeDefsByCategory(userId, category));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: findAttributeTypeDefsByCategory with response: " + response.toString());
        return response;
    }

    public TypeDefListResponse findTypeDefsByProperty(String serverName, String userId, TypeDefProperties matchCriteria) {
        String methodName = "findTypeDefsByProperty";
        log.debug("Calling method: findTypeDefsByProperty");
        TypeDefListResponse response = new TypeDefListResponse();
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "findTypeDefsByProperty");
            response.setTypeDefs(localMetadataCollection.findTypeDefsByProperty(userId, matchCriteria));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: findTypeDefsByProperty with response: " + response.toString());
        return response;
    }

    public TypeDefListResponse findTypesByExternalID(String serverName, String userId, String standard, String organization, String identifier) {
        String methodName = "findTypesByExternalID";
        log.debug("Calling method: findTypesByExternalID");
        TypeDefListResponse response = new TypeDefListResponse();
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "findTypesByExternalID");
            List typeDefs = localMetadataCollection.findTypesByExternalID(userId, standard, organization, identifier);
            response.setTypeDefs(typeDefs);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: findTypesByExternalID with response: " + response.toString());
        return response;
    }

    public TypeDefListResponse searchForTypeDefs(String serverName, String userId, String searchCriteria) {
        String methodName = "searchForTypeDefs";
        log.debug("Calling method: searchForTypeDefs");
        TypeDefListResponse response = new TypeDefListResponse();
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "searchForTypeDefs");
            response.setTypeDefs(localMetadataCollection.searchForTypeDefs(userId, searchCriteria));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: searchForTypeDefs with response: " + response.toString());
        return response;
    }

    public TypeDefResponse getTypeDefByGUID(String serverName, String userId, String guid) {
        String methodName = "getTypeDefByGUID";
        log.debug("Calling method: getTypeDefByGUID");
        TypeDefResponse response = new TypeDefResponse();
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "getTypeDefByGUID");
            response.setTypeDef(localMetadataCollection.getTypeDefByGUID(userId, guid));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefNotKnownException error) {
            this.captureTypeDefNotKnownException(response, error);
        }
        log.debug("Returning from method: getTypeDefByGUID with response: " + response.toString());
        return response;
    }

    public AttributeTypeDefResponse getAttributeTypeDefByGUID(String serverName, String userId, String guid) {
        String methodName = "getAttributeTypeDefByGUID";
        log.debug("Calling method: getAttributeTypeDefByGUID");
        AttributeTypeDefResponse response = new AttributeTypeDefResponse();
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "getAttributeTypeDefByGUID");
            response.setAttributeTypeDef(localMetadataCollection.getAttributeTypeDefByGUID(userId, guid));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefNotKnownException error) {
            this.captureTypeDefNotKnown((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: getAttributeTypeDefByGUID with response: " + response.toString());
        return response;
    }

    public TypeDefResponse getTypeDefByName(String serverName, String userId, String name) {
        String methodName = "getTypeDefByName";
        log.debug("Calling method: getTypeDefByName");
        TypeDefResponse response = new TypeDefResponse();
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "getTypeDefByName");
            response.setTypeDef(localMetadataCollection.getTypeDefByName(userId, name));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefNotKnownException error) {
            this.captureTypeDefNotKnownException(response, error);
        }
        log.debug("Returning from method: getTypeDefByName with response: " + response.toString());
        return response;
    }

    public AttributeTypeDefResponse getAttributeTypeDefByName(String serverName, String userId, String name) {
        String methodName = "getAttributeTypeDefByName";
        log.debug("Calling method: getAttributeTypeDefByName");
        AttributeTypeDefResponse response = new AttributeTypeDefResponse();
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "getAttributeTypeDefByName");
            response.setAttributeTypeDef(localMetadataCollection.getAttributeTypeDefByName(userId, name));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefNotKnownException error) {
            this.captureTypeDefNotKnown((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: getAttributeTypeDefByName with response: " + response.toString());
        return response;
    }

    public VoidResponse addTypeDefGallery(String serverName, String userId, TypeDefGallery newTypes) {
        String methodName = "addTypeDefGallery";
        log.debug("Calling method: addTypeDefGallery");
        VoidResponse response = new VoidResponse();
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "addTypeDefGallery");
            localMetadataCollection.addTypeDefGallery(userId, newTypes);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefNotSupportedException error) {
            this.captureTypeDefNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefKnownException error) {
            this.captureTypeDefKnownException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefConflictException error) {
            this.captureTypeDefConflictException((OMRSAPIResponse)response, error);
        }
        catch (InvalidTypeDefException error) {
            this.captureInvalidTypeDefException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: addTypeDefGallery with response: " + response.toString());
        return response;
    }

    public VoidResponse addTypeDef(String serverName, String userId, TypeDef newTypeDef) {
        String methodName = "addTypeDef";
        log.debug("Calling method: addTypeDef");
        VoidResponse response = new VoidResponse();
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "addTypeDef");
            localMetadataCollection.addTypeDef(userId, newTypeDef);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefNotSupportedException error) {
            this.captureTypeDefNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefKnownException error) {
            this.captureTypeDefKnownException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefConflictException error) {
            this.captureTypeDefConflictException((OMRSAPIResponse)response, error);
        }
        catch (InvalidTypeDefException error) {
            this.captureInvalidTypeDefException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: addTypeDef with response: " + response.toString());
        return response;
    }

    public VoidResponse addAttributeTypeDef(String serverName, String userId, AttributeTypeDef newAttributeTypeDef) {
        String methodName = "addAttributeTypeDef";
        log.debug("Calling method: addAttributeTypeDef");
        VoidResponse response = new VoidResponse();
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "addAttributeTypeDef");
            localMetadataCollection.addAttributeTypeDef(userId, newAttributeTypeDef);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefNotSupportedException error) {
            this.captureTypeDefNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefKnownException error) {
            this.captureTypeDefKnownException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefConflictException error) {
            this.captureTypeDefConflictException((OMRSAPIResponse)response, error);
        }
        catch (InvalidTypeDefException error) {
            this.captureInvalidTypeDefException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: addAttributeTypeDef with response: " + response.toString());
        return response;
    }

    public BooleanResponse verifyTypeDef(String serverName, String userId, TypeDef typeDef) {
        String methodName = "verifyTypeDef";
        log.debug("Calling method: verifyTypeDef");
        BooleanResponse response = new BooleanResponse();
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "verifyTypeDef");
            response.setFlag(localMetadataCollection.verifyTypeDef(userId, typeDef));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefNotSupportedException error) {
            this.captureTypeDefNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefConflictException error) {
            this.captureTypeDefConflictException((OMRSAPIResponse)response, error);
        }
        catch (InvalidTypeDefException error) {
            this.captureInvalidTypeDefException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: verifyTypeDef with response: " + response.toString());
        return response;
    }

    public BooleanResponse verifyAttributeTypeDef(String serverName, String userId, AttributeTypeDef attributeTypeDef) {
        String methodName = "verifyAttributeTypeDef";
        log.debug("Calling method: verifyAttributeTypeDef");
        BooleanResponse response = new BooleanResponse();
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "verifyAttributeTypeDef");
            response.setFlag(localMetadataCollection.verifyAttributeTypeDef(userId, attributeTypeDef));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefNotSupportedException error) {
            this.captureTypeDefNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefConflictException error) {
            this.captureTypeDefConflictException((OMRSAPIResponse)response, error);
        }
        catch (InvalidTypeDefException error) {
            this.captureInvalidTypeDefException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: verifyAttributeTypeDef with response: " + response.toString());
        return response;
    }

    public TypeDefResponse updateTypeDef(String serverName, String userId, TypeDefPatch typeDefPatch) {
        String methodName = "updateTypeDef";
        log.debug("Calling method: updateTypeDef");
        TypeDefResponse response = new TypeDefResponse();
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "updateTypeDef");
            response.setTypeDef(localMetadataCollection.updateTypeDef(userId, typeDefPatch));
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefNotKnownException error) {
            this.captureTypeDefNotKnownException(response, error);
        }
        catch (PatchErrorException error) {
            response.setRelatedHTTPCode(error.getReportedHTTPCode());
            response.setExceptionClassName(PatchErrorException.class.getName());
            response.setExceptionErrorMessage(error.getErrorMessage());
            response.setExceptionSystemAction(error.getReportedSystemAction());
            response.setExceptionUserAction(error.getReportedUserAction());
        }
        log.debug("Returning from method: updateTypeDef with response: " + response.toString());
        return response;
    }

    public VoidResponse deleteTypeDef(String serverName, String userId, String obsoleteTypeDefGUID, String obsoleteTypeDefName) {
        String methodName = "deleteTypeDef";
        log.debug("Calling method: deleteTypeDef");
        VoidResponse response = new VoidResponse();
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "deleteTypeDef");
            localMetadataCollection.deleteTypeDef(userId, obsoleteTypeDefGUID, obsoleteTypeDefName);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefNotKnownException error) {
            this.captureTypeDefNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefInUseException error) {
            this.captureTypeDefInUseException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: deleteTypeDef with response: " + response.toString());
        return response;
    }

    public VoidResponse deleteAttributeTypeDef(String serverName, String userId, String obsoleteTypeDefGUID, String obsoleteTypeDefName) {
        String methodName = "deleteAttributeTypeDef";
        log.debug("Calling method: deleteAttributeTypeDef");
        VoidResponse response = new VoidResponse();
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "deleteAttributeTypeDef");
            localMetadataCollection.deleteAttributeTypeDef(userId, obsoleteTypeDefGUID, obsoleteTypeDefName);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefNotKnownException error) {
            this.captureTypeDefNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefInUseException error) {
            this.captureTypeDefInUseException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: deleteAttributeTypeDef with response: " + response.toString());
        return response;
    }

    public TypeDefResponse reIdentifyTypeDef(String serverName, String userId, String originalTypeDefGUID, TypeDefReIdentifyRequest requestParameters) {
        String methodName = "reIdentifyTypeDef";
        log.debug("Calling method: reIdentifyTypeDef");
        String originalTypeDefName = null;
        String newTypeDefGUID = null;
        String newTypeDefName = null;
        TypeDefResponse response = new TypeDefResponse();
        if (requestParameters != null) {
            originalTypeDefName = requestParameters.getOriginalTypeDefName();
            newTypeDefGUID = requestParameters.getNewTypeDefGUID();
            newTypeDefName = requestParameters.getNewTypeDefName();
        }
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "reIdentifyTypeDef");
            response.setTypeDef(localMetadataCollection.reIdentifyTypeDef(userId, originalTypeDefGUID, originalTypeDefName, newTypeDefGUID, newTypeDefName));
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefNotKnownException error) {
            this.captureTypeDefNotKnownException(response, error);
        }
        log.debug("Returning from method: reIdentifyTypeDef with response: " + response.toString());
        return response;
    }

    public AttributeTypeDefResponse reIdentifyAttributeTypeDef(String serverName, String userId, String originalAttributeTypeDefGUID, TypeDefReIdentifyRequest requestParameters) {
        String methodName = "reIdentifyAttributeTypeDef";
        log.debug("Calling method: reIdentifyAttributeTypeDef");
        String originalAttributeTypeDefName = null;
        String newAttributeTypeDefGUID = null;
        String newAttributeTypeDefName = null;
        AttributeTypeDefResponse response = new AttributeTypeDefResponse();
        if (requestParameters != null) {
            originalAttributeTypeDefName = requestParameters.getOriginalTypeDefName();
            newAttributeTypeDefGUID = requestParameters.getNewTypeDefGUID();
            newAttributeTypeDefName = requestParameters.getNewTypeDefName();
        }
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "reIdentifyAttributeTypeDef");
            response.setAttributeTypeDef(localMetadataCollection.reIdentifyAttributeTypeDef(userId, originalAttributeTypeDefGUID, originalAttributeTypeDefName, newAttributeTypeDefGUID, newAttributeTypeDefName));
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeDefNotKnownException error) {
            this.captureTypeDefNotKnown((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: reIdentifyAttributeTypeDef with response: " + response.toString());
        return response;
    }

    public EntityDetailResponse isEntityKnown(String serverName, String userId, String guid) {
        String methodName = "isEntityKnown";
        log.debug("Calling method: isEntityKnown");
        EntityDetailResponse response = new EntityDetailResponse();
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "isEntityKnown");
            response.setEntity(localMetadataCollection.isEntityKnown(userId, guid));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: isEntityKnown with response: " + response.toString());
        return response;
    }

    public EntitySummaryResponse getEntitySummary(String serverName, String userId, String guid) {
        String methodName = "getEntitySummary";
        log.debug("Calling method: getEntitySummary");
        EntitySummaryResponse response = new EntitySummaryResponse();
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "getEntitySummary");
            response.setEntity(localMetadataCollection.getEntitySummary(userId, guid));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: getEntitySummary with response: " + response.toString());
        return response;
    }

    public EntityDetailResponse getEntityDetail(String serverName, String guid) {
        return this.getEntityDetail(serverName, null, guid);
    }

    public EntityDetailResponse getEntityDetail(String serverName, String userId, String guid) {
        String methodName = "getEntityDetail";
        log.debug("Calling method: getEntityDetail");
        EntityDetailResponse response = new EntityDetailResponse();
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "getEntityDetail");
            response.setEntity(localMetadataCollection.getEntityDetail(userId, guid));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (EntityProxyOnlyException error) {
            this.captureEntityProxyOnlyException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: getEntityDetail with response: " + response.toString());
        return response;
    }

    public EntityDetailResponse getEntityDetail(String serverName, String userId, String guid, Date asOfTime) {
        String methodName = "getEntityDetail";
        log.debug("Calling method: getEntityDetail");
        EntityDetailResponse response = new EntityDetailResponse();
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "getEntityDetail");
            response.setEntity(localMetadataCollection.getEntityDetail(userId, guid, asOfTime));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (EntityProxyOnlyException error) {
            this.captureEntityProxyOnlyException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: getEntityDetail with response: " + response.toString());
        return response;
    }

    public RelationshipListResponse getRelationshipsForEntity(String serverName, String userId, String entityGUID, TypeLimitedFindRequest findRequestParameters) {
        String methodName = "getRelationshipsForEntity";
        log.debug("Calling method: getRelationshipsForEntity");
        String relationshipTypeGUID = null;
        int fromRelationshipElement = 0;
        List limitResultsByStatus = null;
        String sequencingProperty = null;
        SequencingOrder sequencingOrder = null;
        int pageSize = 0;
        RelationshipListResponse response = new RelationshipListResponse();
        if (findRequestParameters != null) {
            relationshipTypeGUID = findRequestParameters.getTypeGUID();
            fromRelationshipElement = findRequestParameters.getOffset();
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
            sequencingProperty = findRequestParameters.getSequencingProperty();
            sequencingOrder = findRequestParameters.getSequencingOrder();
            pageSize = findRequestParameters.getPageSize();
        }
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "getRelationshipsForEntity");
            List relationships = localMetadataCollection.getRelationshipsForEntity(userId, entityGUID, relationshipTypeGUID, fromRelationshipElement, limitResultsByStatus, null, sequencingProperty, sequencingOrder, pageSize);
            response.setRelationships(relationships);
            if (relationships != null) {
                response.setOffset(fromRelationshipElement);
                response.setPageSize(pageSize);
                if (response.getRelationships().size() == pageSize) {
                    String urlTemplate = "{0}/instances/entity/{1}/relationships";
                    TypeLimitedFindRequest nextFindRequestParameters = new TypeLimitedFindRequest(findRequestParameters);
                    nextFindRequestParameters.setOffset(fromRelationshipElement + pageSize);
                    response.setNextPageURL(this.formatNextPageURL(serverName, "{0}/instances/entity/{1}/relationships", nextFindRequestParameters, userId, entityGUID));
                }
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (PagingErrorException error) {
            this.capturePagingErrorException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: getRelationshipsForEntity with response: " + response.toString());
        return response;
    }

    public RelationshipListResponse getRelationshipsForEntityHistory(String serverName, String userId, String entityGUID, TypeLimitedHistoricalFindRequest findRequestParameters) {
        String methodName = "getRelationshipsForEntityHistory";
        log.debug("Calling method: getRelationshipsForEntityHistory");
        String relationshipTypeGUID = null;
        int fromRelationshipElement = 0;
        List limitResultsByStatus = null;
        Date asOfTime = null;
        String sequencingProperty = null;
        SequencingOrder sequencingOrder = null;
        int pageSize = 0;
        RelationshipListResponse response = new RelationshipListResponse();
        if (findRequestParameters != null) {
            relationshipTypeGUID = findRequestParameters.getTypeGUID();
            fromRelationshipElement = findRequestParameters.getOffset();
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
            asOfTime = findRequestParameters.getAsOfTime();
            sequencingProperty = findRequestParameters.getSequencingProperty();
            sequencingOrder = findRequestParameters.getSequencingOrder();
            pageSize = findRequestParameters.getPageSize();
        }
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "getRelationshipsForEntityHistory");
            List relationships = localMetadataCollection.getRelationshipsForEntity(userId, entityGUID, relationshipTypeGUID, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
            response.setRelationships(relationships);
            if (relationships != null) {
                response.setOffset(fromRelationshipElement);
                response.setPageSize(pageSize);
                if (response.getRelationships().size() == pageSize) {
                    String urlTemplate = "{0}/instances/entity/{1}/relationships/history";
                    TypeLimitedHistoricalFindRequest nextFindRequestParameters = new TypeLimitedHistoricalFindRequest(findRequestParameters);
                    nextFindRequestParameters.setOffset(fromRelationshipElement + pageSize);
                    response.setNextPageURL(this.formatNextPageURL(serverName, "{0}/instances/entity/{1}/relationships/history", nextFindRequestParameters, userId, entityGUID));
                }
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (PagingErrorException error) {
            this.capturePagingErrorException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: getRelationshipsForEntityHistory with response: " + response.toString());
        return response;
    }

    public EntityListResponse findEntitiesByProperty(String serverName, String userId, EntityPropertyFindRequest findRequestParameters) {
        String methodName = "findEntitiesByProperty";
        log.debug("Calling method: findEntitiesByProperty");
        String entityTypeGUID = null;
        InstanceProperties matchProperties = null;
        MatchCriteria matchCriteria = null;
        int fromEntityElement = 0;
        List limitResultsByStatus = null;
        List limitResultsByClassification = null;
        String sequencingProperty = null;
        SequencingOrder sequencingOrder = null;
        int pageSize = 0;
        EntityListResponse response = new EntityListResponse();
        if (findRequestParameters != null) {
            entityTypeGUID = findRequestParameters.getTypeGUID();
            matchProperties = findRequestParameters.getMatchProperties();
            matchCriteria = findRequestParameters.getMatchCriteria();
            fromEntityElement = findRequestParameters.getOffset();
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
            limitResultsByClassification = findRequestParameters.getLimitResultsByClassification();
            sequencingProperty = findRequestParameters.getSequencingProperty();
            sequencingOrder = findRequestParameters.getSequencingOrder();
            pageSize = findRequestParameters.getPageSize();
        }
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "findEntitiesByProperty");
            List entities = localMetadataCollection.findEntitiesByProperty(userId, entityTypeGUID, matchProperties, matchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, null, sequencingProperty, sequencingOrder, pageSize);
            response.setEntities(entities);
            if (entities != null) {
                response.setOffset(fromEntityElement);
                response.setPageSize(pageSize);
                if (entities.size() == pageSize) {
                    String urlTemplate = "{0}/instances/entities/by-property";
                    EntityPropertyFindRequest nextFindRequestParameters = new EntityPropertyFindRequest(findRequestParameters);
                    nextFindRequestParameters.setOffset(fromEntityElement + pageSize);
                    response.setNextPageURL(this.formatNextPageURL(serverName, "{0}/instances/entities/by-property", nextFindRequestParameters, userId));
                }
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (PagingErrorException error) {
            this.capturePagingErrorException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: findEntitiesByProperty with response: " + response.toString());
        return response;
    }

    public EntityListResponse findEntitiesByPropertyHistory(String serverName, String userId, EntityPropertyHistoricalFindRequest findRequestParameters) {
        String methodName = "findEntitiesByPropertyHistory";
        log.debug("Calling method: findEntitiesByPropertyHistory");
        String entityTypeGUID = null;
        InstanceProperties matchProperties = null;
        MatchCriteria matchCriteria = null;
        int fromEntityElement = 0;
        List limitResultsByStatus = null;
        List limitResultsByClassification = null;
        Date asOfTime = null;
        String sequencingProperty = null;
        SequencingOrder sequencingOrder = null;
        int pageSize = 0;
        EntityListResponse response = new EntityListResponse();
        if (findRequestParameters != null) {
            entityTypeGUID = findRequestParameters.getTypeGUID();
            matchProperties = findRequestParameters.getMatchProperties();
            matchCriteria = findRequestParameters.getMatchCriteria();
            fromEntityElement = findRequestParameters.getOffset();
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
            limitResultsByClassification = findRequestParameters.getLimitResultsByClassification();
            asOfTime = findRequestParameters.getAsOfTime();
            sequencingProperty = findRequestParameters.getSequencingProperty();
            sequencingOrder = findRequestParameters.getSequencingOrder();
            pageSize = findRequestParameters.getPageSize();
        }
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "findEntitiesByPropertyHistory");
            List entities = localMetadataCollection.findEntitiesByProperty(userId, entityTypeGUID, matchProperties, matchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
            response.setEntities(entities);
            if (entities != null) {
                response.setOffset(fromEntityElement);
                response.setPageSize(pageSize);
                if (entities.size() == pageSize) {
                    String urlTemplate = "{0}/instances/entities/by-property/history";
                    EntityPropertyFindRequest nextFindRequestParameters = new EntityPropertyFindRequest((EntityPropertyFindRequest)findRequestParameters);
                    nextFindRequestParameters.setOffset(fromEntityElement + pageSize);
                    response.setNextPageURL(this.formatNextPageURL(serverName, "{0}/instances/entities/by-property/history", nextFindRequestParameters, userId));
                }
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (PagingErrorException error) {
            this.capturePagingErrorException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: findEntitiesByPropertyHistory with response: " + response.toString());
        return response;
    }

    public EntityListResponse findEntitiesByClassification(String serverName, String userId, String classificationName, PropertyMatchFindRequest findRequestParameters) {
        String methodName = "findEntitiesByClassification";
        log.debug("Calling method: findEntitiesByClassification");
        String entityTypeGUID = null;
        InstanceProperties matchClassificationProperties = null;
        MatchCriteria matchCriteria = null;
        int fromEntityElement = 0;
        List limitResultsByStatus = null;
        String sequencingProperty = null;
        SequencingOrder sequencingOrder = null;
        int pageSize = 0;
        EntityListResponse response = new EntityListResponse();
        if (findRequestParameters != null) {
            entityTypeGUID = findRequestParameters.getTypeGUID();
            matchClassificationProperties = findRequestParameters.getMatchProperties();
            matchCriteria = findRequestParameters.getMatchCriteria();
            fromEntityElement = findRequestParameters.getOffset();
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
            sequencingProperty = findRequestParameters.getSequencingProperty();
            sequencingOrder = findRequestParameters.getSequencingOrder();
            pageSize = findRequestParameters.getPageSize();
        }
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "findEntitiesByClassification");
            List entities = localMetadataCollection.findEntitiesByClassification(userId, entityTypeGUID, classificationName, matchClassificationProperties, matchCriteria, fromEntityElement, limitResultsByStatus, null, sequencingProperty, sequencingOrder, pageSize);
            response.setEntities(entities);
            if (entities != null) {
                response.setOffset(fromEntityElement);
                response.setPageSize(pageSize);
                if (entities.size() == pageSize) {
                    String urlTemplate = "{0}/instances/entities/by-classification/{1}";
                    PropertyMatchFindRequest nextFindRequestParameters = new PropertyMatchFindRequest(findRequestParameters);
                    nextFindRequestParameters.setOffset(fromEntityElement + pageSize);
                    response.setNextPageURL(this.formatNextPageURL(serverName, "{0}/instances/entities/by-classification/{1}", nextFindRequestParameters, userId, classificationName));
                }
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (PagingErrorException error) {
            this.capturePagingErrorException((OMRSAPIResponse)response, error);
        }
        catch (ClassificationErrorException error) {
            this.captureClassificationErrorException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: findEntitiesByClassification with response: " + response.toString());
        return response;
    }

    public EntityListResponse findEntitiesByClassificationHistory(String serverName, String userId, String classificationName, PropertyMatchHistoricalFindRequest findRequestParameters) {
        String methodName = "findEntitiesByClassificationHistory";
        log.debug("Calling method: findEntitiesByClassificationHistory");
        String entityTypeGUID = null;
        InstanceProperties matchClassificationProperties = null;
        MatchCriteria matchCriteria = null;
        int fromEntityElement = 0;
        List limitResultsByStatus = null;
        Date asOfTime = null;
        String sequencingProperty = null;
        SequencingOrder sequencingOrder = null;
        int pageSize = 0;
        EntityListResponse response = new EntityListResponse();
        if (findRequestParameters != null) {
            entityTypeGUID = findRequestParameters.getTypeGUID();
            matchClassificationProperties = findRequestParameters.getMatchProperties();
            matchCriteria = findRequestParameters.getMatchCriteria();
            fromEntityElement = findRequestParameters.getOffset();
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
            sequencingProperty = findRequestParameters.getSequencingProperty();
            sequencingOrder = findRequestParameters.getSequencingOrder();
            pageSize = findRequestParameters.getPageSize();
            asOfTime = findRequestParameters.getAsOfTime();
        }
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "findEntitiesByClassificationHistory");
            List entities = localMetadataCollection.findEntitiesByClassification(userId, entityTypeGUID, classificationName, matchClassificationProperties, matchCriteria, fromEntityElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
            response.setEntities(entities);
            if (entities != null) {
                response.setOffset(fromEntityElement);
                response.setPageSize(pageSize);
                if (entities.size() == pageSize) {
                    String urlTemplate = "{0}/instances/entities/by-classification/{1}/history";
                    PropertyMatchHistoricalFindRequest nextFindRequestParameters = new PropertyMatchHistoricalFindRequest(findRequestParameters);
                    nextFindRequestParameters.setOffset(fromEntityElement + pageSize);
                    response.setNextPageURL(this.formatNextPageURL(serverName, "{0}/instances/entities/by-classification/{1}/history", nextFindRequestParameters, userId, classificationName));
                }
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (PagingErrorException error) {
            this.capturePagingErrorException((OMRSAPIResponse)response, error);
        }
        catch (ClassificationErrorException error) {
            this.captureClassificationErrorException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: findEntitiesByClassificationHistory with response: " + response.toString());
        return response;
    }

    public EntityListResponse findEntitiesByPropertyValue(String serverName, String userId, String searchCriteria, EntityPropertyFindRequest findRequestParameters) {
        String methodName = "findEntitiesByPropertyValue";
        log.debug("Calling method: findEntitiesByPropertyValue");
        String entityTypeGUID = null;
        int fromEntityElement = 0;
        List limitResultsByStatus = null;
        List limitResultsByClassification = null;
        String sequencingProperty = null;
        SequencingOrder sequencingOrder = null;
        int pageSize = 0;
        EntityListResponse response = new EntityListResponse();
        if (findRequestParameters != null) {
            entityTypeGUID = findRequestParameters.getTypeGUID();
            fromEntityElement = findRequestParameters.getOffset();
            limitResultsByClassification = findRequestParameters.getLimitResultsByClassification();
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
            sequencingProperty = findRequestParameters.getSequencingProperty();
            sequencingOrder = findRequestParameters.getSequencingOrder();
            pageSize = findRequestParameters.getPageSize();
        }
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "findEntitiesByPropertyValue");
            List entities = localMetadataCollection.findEntitiesByPropertyValue(userId, entityTypeGUID, searchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, null, sequencingProperty, sequencingOrder, pageSize);
            response.setEntities(entities);
            if (entities != null) {
                response.setOffset(fromEntityElement);
                response.setPageSize(pageSize);
                if (entities.size() == pageSize) {
                    String urlTemplate = "{0}/instances/entities/by-property-value?searchCriteria={1}";
                    EntityPropertyFindRequest nextFindRequestParameters = new EntityPropertyFindRequest(findRequestParameters);
                    nextFindRequestParameters.setOffset(fromEntityElement + pageSize);
                    response.setNextPageURL(this.formatNextPageURL(serverName, "{0}/instances/entities/by-property-value?searchCriteria={1}", nextFindRequestParameters, userId, searchCriteria));
                }
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (PagingErrorException error) {
            this.capturePagingErrorException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: findEntitiesByPropertyValue with response: " + response.toString());
        return response;
    }

    public EntityListResponse findEntitiesByPropertyValueHistory(String serverName, String userId, String searchCriteria, EntityPropertyHistoricalFindRequest findRequestParameters) {
        String methodName = "findEntitiesByPropertyValueHistory";
        log.debug("Calling method: findEntitiesByPropertyValueHistory");
        String entityTypeGUID = null;
        int fromEntityElement = 0;
        List limitResultsByStatus = null;
        List limitResultsByClassification = null;
        Date asOfTime = null;
        String sequencingProperty = null;
        SequencingOrder sequencingOrder = null;
        int pageSize = 0;
        EntityListResponse response = new EntityListResponse();
        if (findRequestParameters != null) {
            entityTypeGUID = findRequestParameters.getTypeGUID();
            fromEntityElement = findRequestParameters.getOffset();
            limitResultsByClassification = findRequestParameters.getLimitResultsByClassification();
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
            asOfTime = findRequestParameters.getAsOfTime();
            sequencingProperty = findRequestParameters.getSequencingProperty();
            sequencingOrder = findRequestParameters.getSequencingOrder();
            pageSize = findRequestParameters.getPageSize();
        }
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "findEntitiesByPropertyValueHistory");
            List entities = localMetadataCollection.findEntitiesByPropertyValue(userId, entityTypeGUID, searchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
            response.setEntities(entities);
            if (entities != null) {
                response.setOffset(fromEntityElement);
                response.setPageSize(pageSize);
                if (entities.size() == pageSize) {
                    String urlTemplate = "{0}/instances/entities/by-property-value/history?searchCriteria={1}";
                    EntityPropertyHistoricalFindRequest nextFindRequestParameters = new EntityPropertyHistoricalFindRequest(findRequestParameters);
                    nextFindRequestParameters.setOffset(fromEntityElement + pageSize);
                    response.setNextPageURL(this.formatNextPageURL(serverName, "{0}/instances/entities/by-property-value/history?searchCriteria={1}", nextFindRequestParameters, userId, searchCriteria));
                }
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (PagingErrorException error) {
            this.capturePagingErrorException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: findEntitiesByPropertyValueHistory with response: " + response.toString());
        return response;
    }

    public RelationshipResponse isRelationshipKnown(String serverName, String userId, String guid) {
        String methodName = "isRelationshipKnown";
        log.debug("Calling method: isRelationshipKnown");
        RelationshipResponse response = new RelationshipResponse();
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "isRelationshipKnown");
            response.setRelationship(localMetadataCollection.isRelationshipKnown(userId, guid));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: isRelationshipKnown with response: " + response.toString());
        return response;
    }

    public RelationshipResponse getRelationship(String serverName, String guid) {
        return this.getRelationship(serverName, null, guid);
    }

    public RelationshipResponse getRelationship(String serverName, String userId, String guid) {
        String methodName = "getRelationship";
        log.debug("Calling method: getRelationship");
        RelationshipResponse response = new RelationshipResponse();
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "getRelationship");
            response.setRelationship(localMetadataCollection.getRelationship(userId, guid));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (RelationshipNotKnownException error) {
            this.captureRelationshipNotKnownException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: getRelationship with response: " + response.toString());
        return response;
    }

    public RelationshipResponse getRelationship(String serverName, String userId, String guid, Date asOfTime) {
        String methodName = "getRelationship";
        log.debug("Calling method: getRelationship");
        RelationshipResponse response = new RelationshipResponse();
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "getRelationship");
            response.setRelationship(localMetadataCollection.getRelationship(userId, guid, asOfTime));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (RelationshipNotKnownException error) {
            this.captureRelationshipNotKnownException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: getRelationship with response: " + response.toString());
        return response;
    }

    public RelationshipListResponse findRelationshipsByProperty(String serverName, String userId, PropertyMatchFindRequest findRequestParameters) {
        String methodName = "findRelationshipsByProperty";
        log.debug("Calling method: findRelationshipsByProperty");
        String relationshipTypeGUID = null;
        InstanceProperties matchProperties = null;
        MatchCriteria matchCriteria = null;
        int fromRelationshipElement = 0;
        List limitResultsByStatus = null;
        String sequencingProperty = null;
        SequencingOrder sequencingOrder = null;
        int pageSize = 0;
        RelationshipListResponse response = new RelationshipListResponse();
        if (findRequestParameters != null) {
            relationshipTypeGUID = findRequestParameters.getTypeGUID();
            matchProperties = findRequestParameters.getMatchProperties();
            matchCriteria = findRequestParameters.getMatchCriteria();
            fromRelationshipElement = findRequestParameters.getOffset();
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
            sequencingProperty = findRequestParameters.getSequencingProperty();
            sequencingOrder = findRequestParameters.getSequencingOrder();
            pageSize = findRequestParameters.getPageSize();
        }
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "findRelationshipsByProperty");
            List relationships = localMetadataCollection.findRelationshipsByProperty(userId, relationshipTypeGUID, matchProperties, matchCriteria, fromRelationshipElement, limitResultsByStatus, null, sequencingProperty, sequencingOrder, pageSize);
            response.setRelationships(relationships);
            if (relationships != null) {
                response.setOffset(fromRelationshipElement);
                response.setPageSize(pageSize);
                if (response.getRelationships().size() == pageSize) {
                    String urlTemplate = "{0}/instances/relationships/by-property";
                    PropertyMatchFindRequest nextFindRequestParameters = new PropertyMatchFindRequest(findRequestParameters);
                    nextFindRequestParameters.setOffset(fromRelationshipElement + pageSize);
                    response.setNextPageURL(this.formatNextPageURL(serverName, "{0}/instances/relationships/by-property", nextFindRequestParameters, userId));
                }
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (PagingErrorException error) {
            this.capturePagingErrorException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: findRelationshipsByProperty with response: " + response.toString());
        return response;
    }

    public RelationshipListResponse findRelationshipsByPropertyHistory(String serverName, String userId, PropertyMatchHistoricalFindRequest findRequestParameters) {
        String methodName = "findRelationshipsByPropertyHistory";
        log.debug("Calling method: findRelationshipsByPropertyHistory");
        String relationshipTypeGUID = null;
        InstanceProperties matchProperties = null;
        MatchCriteria matchCriteria = null;
        int fromRelationshipElement = 0;
        List limitResultsByStatus = null;
        Date asOfTime = null;
        String sequencingProperty = null;
        SequencingOrder sequencingOrder = null;
        int pageSize = 0;
        RelationshipListResponse response = new RelationshipListResponse();
        if (findRequestParameters != null) {
            relationshipTypeGUID = findRequestParameters.getTypeGUID();
            matchProperties = findRequestParameters.getMatchProperties();
            matchCriteria = findRequestParameters.getMatchCriteria();
            fromRelationshipElement = findRequestParameters.getOffset();
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
            asOfTime = findRequestParameters.getAsOfTime();
            sequencingProperty = findRequestParameters.getSequencingProperty();
            sequencingOrder = findRequestParameters.getSequencingOrder();
            pageSize = findRequestParameters.getPageSize();
        }
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "findRelationshipsByPropertyHistory");
            List relationships = localMetadataCollection.findRelationshipsByProperty(userId, relationshipTypeGUID, matchProperties, matchCriteria, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
            response.setRelationships(relationships);
            if (relationships != null) {
                response.setOffset(fromRelationshipElement);
                response.setPageSize(pageSize);
                if (response.getRelationships().size() == pageSize) {
                    String urlTemplate = "{0}/instances/relationships/by-property/history";
                    PropertyMatchHistoricalFindRequest nextFindRequestParameters = new PropertyMatchHistoricalFindRequest(findRequestParameters);
                    nextFindRequestParameters.setOffset(fromRelationshipElement + pageSize);
                    response.setNextPageURL(this.formatNextPageURL(serverName, "{0}/instances/relationships/by-property/history", nextFindRequestParameters, userId));
                }
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (PagingErrorException error) {
            this.capturePagingErrorException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: findRelationshipsByPropertyHistory with response: " + response.toString());
        return response;
    }

    public RelationshipListResponse findRelationshipsByPropertyValue(String serverName, String userId, String searchCriteria, TypeLimitedFindRequest findRequestParameters) {
        String methodName = "findRelationshipsByPropertyValue";
        log.debug("Calling method: findRelationshipsByPropertyValue");
        String relationshipTypeGUID = null;
        int fromRelationshipElement = 0;
        List limitResultsByStatus = null;
        String sequencingProperty = null;
        SequencingOrder sequencingOrder = null;
        int pageSize = 0;
        RelationshipListResponse response = new RelationshipListResponse();
        if (findRequestParameters != null) {
            relationshipTypeGUID = findRequestParameters.getTypeGUID();
            fromRelationshipElement = findRequestParameters.getOffset();
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
            sequencingProperty = findRequestParameters.getSequencingProperty();
            sequencingOrder = findRequestParameters.getSequencingOrder();
            pageSize = findRequestParameters.getPageSize();
        }
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "findRelationshipsByPropertyValue");
            List relationships = localMetadataCollection.findRelationshipsByPropertyValue(userId, relationshipTypeGUID, searchCriteria, fromRelationshipElement, limitResultsByStatus, null, sequencingProperty, sequencingOrder, pageSize);
            response.setRelationships(relationships);
            if (relationships != null) {
                response.setOffset(fromRelationshipElement);
                response.setPageSize(pageSize);
                if (response.getRelationships().size() == pageSize) {
                    String urlTemplate = "{0}/instances/relationships/by-property-value?searchCriteria={1}";
                    TypeLimitedFindRequest nextFindRequestParameters = new TypeLimitedFindRequest(findRequestParameters);
                    nextFindRequestParameters.setOffset(fromRelationshipElement + pageSize);
                    response.setNextPageURL(this.formatNextPageURL(serverName, "{0}/instances/relationships/by-property-value?searchCriteria={1}", nextFindRequestParameters, userId, searchCriteria));
                }
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (PagingErrorException error) {
            this.capturePagingErrorException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: findRelationshipsByPropertyValue with response: " + response.toString());
        return response;
    }

    public RelationshipListResponse findRelationshipsByPropertyValueHistory(String serverName, String userId, String searchCriteria, TypeLimitedHistoricalFindRequest findRequestParameters) {
        String methodName = "findRelationshipsByPropertyValueHistory";
        log.debug("Calling method: findRelationshipsByPropertyValueHistory");
        String relationshipTypeGUID = null;
        int fromRelationshipElement = 0;
        List limitResultsByStatus = null;
        Date asOfTime = null;
        String sequencingProperty = null;
        SequencingOrder sequencingOrder = null;
        int pageSize = 0;
        RelationshipListResponse response = new RelationshipListResponse();
        if (findRequestParameters != null) {
            relationshipTypeGUID = findRequestParameters.getTypeGUID();
            fromRelationshipElement = findRequestParameters.getOffset();
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
            asOfTime = findRequestParameters.getAsOfTime();
            sequencingProperty = findRequestParameters.getSequencingProperty();
            sequencingOrder = findRequestParameters.getSequencingOrder();
            pageSize = findRequestParameters.getPageSize();
        }
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "findRelationshipsByPropertyValueHistory");
            List relationships = localMetadataCollection.findRelationshipsByPropertyValue(userId, relationshipTypeGUID, searchCriteria, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
            response.setRelationships(relationships);
            if (relationships != null) {
                response.setOffset(fromRelationshipElement);
                response.setPageSize(pageSize);
                if (response.getRelationships().size() == pageSize) {
                    String urlTemplate = "{0}/instances/relationships/by-property-value/history?searchCriteria={1}";
                    TypeLimitedHistoricalFindRequest nextFindRequestParameters = new TypeLimitedHistoricalFindRequest(findRequestParameters);
                    nextFindRequestParameters.setOffset(fromRelationshipElement + pageSize);
                    response.setNextPageURL(this.formatNextPageURL(serverName, "{0}/instances/relationships/by-property-value/history?searchCriteria={1}", nextFindRequestParameters, userId, searchCriteria));
                }
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (PagingErrorException error) {
            this.capturePagingErrorException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: findRelationshipsByPropertyValueHistory with response: " + response.toString());
        return response;
    }

    public InstanceGraphResponse getLinkingEntities(String serverName, String userId, String startEntityGUID, String endEntityGUID, OMRSAPIFindRequest findRequestParameters) {
        String methodName = "getLinkingEntities";
        log.debug("Calling method: getLinkingEntities");
        List limitResultsByStatus = null;
        InstanceGraphResponse response = new InstanceGraphResponse();
        if (findRequestParameters != null) {
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
        }
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "getLinkingEntities");
            InstanceGraph instanceGraph = localMetadataCollection.getLinkingEntities(userId, startEntityGUID, endEntityGUID, limitResultsByStatus, null);
            if (instanceGraph != null) {
                response.setEntityElementList(instanceGraph.getEntities());
                response.setRelationshipElementList(instanceGraph.getRelationships());
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: getLinkingEntities with response: " + response.toString());
        return response;
    }

    public InstanceGraphResponse getLinkingEntitiesHistory(String serverName, String userId, String startEntityGUID, String endEntityGUID, OMRSAPIHistoricalFindRequest findRequestParameters) {
        String methodName = "getLinkingEntitiesHistory";
        log.debug("Calling method: getLinkingEntitiesHistory");
        List limitResultsByStatus = null;
        Date asOfTime = null;
        InstanceGraphResponse response = new InstanceGraphResponse();
        if (findRequestParameters != null) {
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
            asOfTime = findRequestParameters.getAsOfTime();
        }
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "getLinkingEntitiesHistory");
            InstanceGraph instanceGraph = localMetadataCollection.getLinkingEntities(userId, startEntityGUID, endEntityGUID, limitResultsByStatus, asOfTime);
            if (instanceGraph != null) {
                response.setEntityElementList(instanceGraph.getEntities());
                response.setRelationshipElementList(instanceGraph.getRelationships());
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: getLinkingEntitiesHistory with response: " + response.toString());
        return response;
    }

    public InstanceGraphResponse getEntityNeighborhood(String serverName, String userId, String entityGUID, int level, EntityNeighborhoodFindRequest findRequestParameters) {
        String methodName = "getEntityNeighborhood";
        log.debug("Calling method: getEntityNeighborhood");
        List entityTypeGUIDs = null;
        List relationshipTypeGUIDs = null;
        List limitResultsByStatus = null;
        List limitResultsByClassification = null;
        InstanceGraphResponse response = new InstanceGraphResponse();
        if (findRequestParameters != null) {
            entityTypeGUIDs = findRequestParameters.getEntityTypeGUIDs();
            relationshipTypeGUIDs = findRequestParameters.getRelationshipTypeGUIDs();
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
            limitResultsByClassification = findRequestParameters.getLimitResultsByClassification();
        }
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "getEntityNeighborhood");
            InstanceGraph instanceGraph = localMetadataCollection.getEntityNeighborhood(userId, entityGUID, entityTypeGUIDs, relationshipTypeGUIDs, limitResultsByStatus, limitResultsByClassification, null, level);
            if (instanceGraph != null) {
                response.setEntityElementList(instanceGraph.getEntities());
                response.setRelationshipElementList(instanceGraph.getRelationships());
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: getEntityNeighborhood with response: " + response.toString());
        return response;
    }

    public InstanceGraphResponse getEntityNeighborhoodHistory(String serverName, String userId, String entityGUID, int level, EntityNeighborhoodHistoricalFindRequest findRequestParameters) {
        String methodName = "getEntityNeighborhoodHistory";
        log.debug("Calling method: getEntityNeighborhoodHistory");
        List entityTypeGUIDs = null;
        List relationshipTypeGUIDs = null;
        List limitResultsByStatus = null;
        List limitResultsByClassification = null;
        Date asOfTime = null;
        InstanceGraphResponse response = new InstanceGraphResponse();
        if (findRequestParameters != null) {
            entityTypeGUIDs = findRequestParameters.getEntityTypeGUIDs();
            relationshipTypeGUIDs = findRequestParameters.getRelationshipTypeGUIDs();
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
            asOfTime = findRequestParameters.getAsOfTime();
            limitResultsByClassification = findRequestParameters.getLimitResultsByClassification();
        }
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "getEntityNeighborhoodHistory");
            InstanceGraph instanceGraph = localMetadataCollection.getEntityNeighborhood(userId, entityGUID, entityTypeGUIDs, relationshipTypeGUIDs, limitResultsByStatus, limitResultsByClassification, asOfTime, level);
            if (instanceGraph != null) {
                response.setEntityElementList(instanceGraph.getEntities());
                response.setRelationshipElementList(instanceGraph.getRelationships());
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: getEntityNeighborhoodHistory with response: " + response.toString());
        return response;
    }

    public EntityListResponse getRelatedEntities(String serverName, String userId, String startEntityGUID, RelatedEntitiesFindRequest findRequestParameters) {
        String methodName = "getRelatedEntities";
        log.debug("Calling method: getRelatedEntities");
        List entityTypeGUIDs = null;
        int fromEntityElement = 0;
        List limitResultsByStatus = null;
        List limitResultsByClassification = null;
        String sequencingProperty = null;
        SequencingOrder sequencingOrder = null;
        int pageSize = 0;
        EntityListResponse response = new EntityListResponse();
        if (findRequestParameters != null) {
            entityTypeGUIDs = findRequestParameters.getEntityTypeGUIDs();
            fromEntityElement = findRequestParameters.getOffset();
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
            limitResultsByClassification = findRequestParameters.getLimitResultsByClassification();
            sequencingProperty = findRequestParameters.getSequencingProperty();
            sequencingOrder = findRequestParameters.getSequencingOrder();
            pageSize = findRequestParameters.getPageSize();
        }
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "getRelatedEntities");
            List entities = localMetadataCollection.getRelatedEntities(userId, startEntityGUID, entityTypeGUIDs, fromEntityElement, limitResultsByStatus, limitResultsByClassification, null, sequencingProperty, sequencingOrder, pageSize);
            response.setEntities(entities);
            if (entities != null) {
                response.setOffset(fromEntityElement);
                response.setPageSize(pageSize);
                if (entities.size() == pageSize) {
                    String urlTemplate = "{0}/instances/entities/from-entity/{1}/by-relationship";
                    RelatedEntitiesFindRequest nextFindRequestParameters = new RelatedEntitiesFindRequest(findRequestParameters);
                    nextFindRequestParameters.setOffset(fromEntityElement + pageSize);
                    response.setNextPageURL(this.formatNextPageURL(serverName, "{0}/instances/entities/from-entity/{1}/by-relationship", nextFindRequestParameters, userId, startEntityGUID));
                }
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (PagingErrorException error) {
            this.capturePagingErrorException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: getRelatedEntities with response: " + response.toString());
        return response;
    }

    public EntityListResponse getRelatedEntitiesHistory(String serverName, String userId, String startEntityGUID, RelatedEntitiesHistoricalFindRequest findRequestParameters) {
        String methodName = "getRelatedEntitiesHistory";
        log.debug("Calling method: getRelatedEntitiesHistory");
        List entityTypeGUIDs = null;
        int fromEntityElement = 0;
        List limitResultsByStatus = null;
        List limitResultsByClassification = null;
        Date asOfTime = null;
        String sequencingProperty = null;
        SequencingOrder sequencingOrder = null;
        int pageSize = 0;
        EntityListResponse response = new EntityListResponse();
        if (findRequestParameters != null) {
            entityTypeGUIDs = findRequestParameters.getEntityTypeGUIDs();
            fromEntityElement = findRequestParameters.getOffset();
            limitResultsByStatus = findRequestParameters.getLimitResultsByStatus();
            limitResultsByClassification = findRequestParameters.getLimitResultsByClassification();
            asOfTime = findRequestParameters.getAsOfTime();
            sequencingProperty = findRequestParameters.getSequencingProperty();
            sequencingOrder = findRequestParameters.getSequencingOrder();
            pageSize = findRequestParameters.getPageSize();
        }
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "getRelatedEntitiesHistory");
            List entities = localMetadataCollection.getRelatedEntities(userId, startEntityGUID, entityTypeGUIDs, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
            response.setEntities(entities);
            if (entities != null) {
                response.setOffset(fromEntityElement);
                response.setPageSize(pageSize);
                if (entities.size() == pageSize) {
                    String urlTemplate = "{0}/instances/entities/from-entity/{1}/by-relationship/history";
                    RelatedEntitiesHistoricalFindRequest nextFindRequestParameters = new RelatedEntitiesHistoricalFindRequest(findRequestParameters);
                    nextFindRequestParameters.setOffset(fromEntityElement + pageSize);
                    response.setNextPageURL(this.formatNextPageURL(serverName, "{0}/instances/entities/from-entity/{1}/by-relationship/history", nextFindRequestParameters, userId, startEntityGUID));
                }
            }
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (PagingErrorException error) {
            this.capturePagingErrorException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: getRelatedEntitiesHistory with response: " + response.toString());
        return response;
    }

    public EntityDetailResponse addEntity(String serverName, String userId, EntityCreateRequest requestBody) {
        String methodName = "addEntity";
        log.debug("Calling method: addEntity");
        String entityTypeGUID = null;
        InstanceProperties initialProperties = null;
        List initialClassifications = null;
        InstanceStatus initialStatus = null;
        EntityDetailResponse response = new EntityDetailResponse();
        if (requestBody != null) {
            entityTypeGUID = requestBody.getEntityTypeGUID();
            initialProperties = requestBody.getInitialProperties();
            initialClassifications = requestBody.getInitialClassifications();
            initialStatus = requestBody.getInitialStatus();
        }
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "addEntity");
            response.setEntity(localMetadataCollection.addEntity(userId, entityTypeGUID, initialProperties, initialClassifications, initialStatus));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (StatusNotSupportedException error) {
            this.captureStatusNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (ClassificationErrorException error) {
            this.captureClassificationErrorException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: addEntity with response: " + response.toString());
        return response;
    }

    public VoidResponse addEntityProxy(String serverName, String userId, EntityProxy entityProxy) {
        String methodName = "addEntityProxy";
        log.debug("Calling method: addEntityProxy");
        VoidResponse response = new VoidResponse();
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "addEntityProxy");
            localMetadataCollection.addEntityProxy(userId, entityProxy);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: addEntityProxy with response: " + response.toString());
        return response;
    }

    public EntityDetailResponse updateEntityStatus(String serverName, String userId, String entityGUID, InstanceStatus newStatus) {
        String methodName = "updateEntityStatus";
        log.debug("Calling method: updateEntityStatus");
        EntityDetailResponse response = new EntityDetailResponse();
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "updateEntityStatus");
            response.setEntity(localMetadataCollection.updateEntityStatus(userId, entityGUID, newStatus));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (StatusNotSupportedException error) {
            this.captureStatusNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: updateEntityStatus with response: " + response.toString());
        return response;
    }

    public EntityDetailResponse updateEntityProperties(String serverName, String userId, String entityGUID, InstancePropertiesRequest propertiesRequestBody) {
        String methodName = "updateEntityProperties";
        log.debug("Calling method: updateEntityProperties");
        EntityDetailResponse response = new EntityDetailResponse();
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "updateEntityProperties");
            response.setEntity(localMetadataCollection.updateEntityProperties(userId, entityGUID, propertiesRequestBody.getInstanceProperties()));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: updateEntityProperties with response: " + response.toString());
        return response;
    }

    public EntityDetailResponse undoEntityUpdate(String serverName, String userId, String entityGUID) {
        String methodName = "undoEntityUpdate";
        log.debug("Calling method: undoEntityUpdate");
        EntityDetailResponse response = new EntityDetailResponse();
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "undoEntityUpdate");
            response.setEntity(localMetadataCollection.undoEntityUpdate(userId, entityGUID));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: undoEntityUpdate with response: " + response.toString());
        return response;
    }

    public EntityDetailResponse deleteEntity(String serverName, String userId, String obsoleteEntityGUID, TypeDefValidationForRequest typeDefValidationForRequest) {
        String methodName = "deleteEntity";
        log.debug("Calling method: deleteEntity");
        String typeDefGUID = null;
        String typeDefName = null;
        EntityDetailResponse response = new EntityDetailResponse();
        if (typeDefValidationForRequest != null) {
            typeDefGUID = typeDefValidationForRequest.getTypeDefGUID();
            typeDefName = typeDefValidationForRequest.getTypeDefName();
        }
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "deleteEntity");
            response.setEntity(localMetadataCollection.deleteEntity(userId, typeDefGUID, typeDefName, obsoleteEntityGUID));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: deleteEntity with response: " + response.toString());
        return response;
    }

    public VoidResponse purgeEntity(String serverName, String userId, String deletedEntityGUID, TypeDefValidationForRequest typeDefValidationForRequest) {
        String methodName = "purgeEntity";
        log.debug("Calling method: purgeEntity");
        String typeDefGUID = null;
        String typeDefName = null;
        VoidResponse response = new VoidResponse();
        if (typeDefValidationForRequest != null) {
            typeDefGUID = typeDefValidationForRequest.getTypeDefGUID();
            typeDefName = typeDefValidationForRequest.getTypeDefName();
        }
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "purgeEntity");
            localMetadataCollection.purgeEntity(userId, typeDefGUID, typeDefName, deletedEntityGUID);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotDeletedException error) {
            this.captureEntityNotDeletedException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: purgeEntity with response: " + response.toString());
        return response;
    }

    public EntityDetailResponse restoreEntity(String serverName, String userId, String deletedEntityGUID) {
        String methodName = "restoreEntity";
        log.debug("Calling method: restoreEntity");
        EntityDetailResponse response = new EntityDetailResponse();
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "restoreEntity");
            response.setEntity(localMetadataCollection.restoreEntity(userId, deletedEntityGUID));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotDeletedException error) {
            this.captureEntityNotDeletedException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: restoreEntity with response: " + response.toString());
        return response;
    }

    public EntityDetailResponse classifyEntity(String serverName, String userId, String entityGUID, String classificationName, InstancePropertiesRequest propertiesRequestBody) {
        String methodName = "classifyEntity";
        log.debug("Calling method: classifyEntity");
        EntityDetailResponse response = new EntityDetailResponse();
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "classifyEntity");
            response.setEntity(localMetadataCollection.classifyEntity(userId, entityGUID, classificationName, propertiesRequestBody.getInstanceProperties()));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (ClassificationErrorException error) {
            this.captureClassificationErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: classifyEntity with response: " + response.toString());
        return response;
    }

    public EntityDetailResponse declassifyEntity(String serverName, String userId, String entityGUID, String classificationName) {
        String methodName = "declassifyEntity";
        log.debug("Calling method: declassifyEntity");
        EntityDetailResponse response = new EntityDetailResponse();
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "declassifyEntity");
            response.setEntity(localMetadataCollection.declassifyEntity(userId, entityGUID, classificationName));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (ClassificationErrorException error) {
            this.captureClassificationErrorException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: declassifyEntity with response: " + response.toString());
        return response;
    }

    public EntityDetailResponse updateEntityClassification(String serverName, String userId, String entityGUID, String classificationName, InstancePropertiesRequest propertiesRequestBody) {
        String methodName = "updateEntityClassification";
        log.debug("Calling method: updateEntityClassification");
        EntityDetailResponse response = new EntityDetailResponse();
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "updateEntityClassification");
            response.setEntity(localMetadataCollection.updateEntityClassification(userId, entityGUID, classificationName, propertiesRequestBody.getInstanceProperties()));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (ClassificationErrorException error) {
            this.captureClassificationErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: updateEntityClassification with response: " + response.toString());
        return response;
    }

    public RelationshipResponse addRelationship(String serverName, String userId, RelationshipCreateRequest createRequestParameters) {
        String methodName = "addRelationship";
        log.debug("Calling method: addRelationship");
        String relationshipTypeGUID = null;
        InstanceProperties initialProperties = null;
        String entityOneGUID = null;
        String entityTwoGUID = null;
        InstanceStatus initialStatus = null;
        RelationshipResponse response = new RelationshipResponse();
        if (createRequestParameters != null) {
            relationshipTypeGUID = createRequestParameters.getRelationshipTypeGUID();
            initialProperties = createRequestParameters.getInitialProperties();
            entityOneGUID = createRequestParameters.getEntityOneGUID();
            entityTwoGUID = createRequestParameters.getEntityTwoGUID();
            initialStatus = createRequestParameters.getInitialStatus();
        }
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "addRelationship");
            response.setRelationship(localMetadataCollection.addRelationship(userId, relationshipTypeGUID, initialProperties, entityOneGUID, entityTwoGUID, initialStatus));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (StatusNotSupportedException error) {
            this.captureStatusNotSupportedException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: addRelationship with response: " + response.toString());
        return response;
    }

    public RelationshipResponse updateRelationshipStatus(String serverName, String userId, String relationshipGUID, InstanceStatus newStatus) {
        String methodName = "updateRelationshipStatus";
        log.debug("Calling method: updateRelationshipStatus");
        RelationshipResponse response = new RelationshipResponse();
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "updateRelationshipStatus");
            response.setRelationship(localMetadataCollection.updateRelationshipStatus(userId, relationshipGUID, newStatus));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (RelationshipNotKnownException error) {
            this.captureRelationshipNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (StatusNotSupportedException error) {
            this.captureStatusNotSupportedException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: updateRelationshipStatus with response: " + response.toString());
        return response;
    }

    public RelationshipResponse updateRelationshipProperties(String serverName, String userId, String relationshipGUID, InstancePropertiesRequest propertiesRequestBody) {
        String methodName = "updateRelationshipProperties";
        log.debug("Calling method: updateRelationshipProperties");
        RelationshipResponse response = new RelationshipResponse();
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "updateRelationshipProperties");
            response.setRelationship(localMetadataCollection.updateRelationshipProperties(userId, relationshipGUID, propertiesRequestBody.getInstanceProperties()));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (RelationshipNotKnownException error) {
            this.captureRelationshipNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: updateRelationshipProperties with response: " + response.toString());
        return response;
    }

    public RelationshipResponse undoRelationshipUpdate(String serverName, String userId, String relationshipGUID) {
        String methodName = "undoRelationshipUpdate";
        log.debug("Calling method: undoRelationshipUpdate");
        RelationshipResponse response = new RelationshipResponse();
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "undoRelationshipUpdate");
            response.setRelationship(localMetadataCollection.undoRelationshipUpdate(userId, relationshipGUID));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (RelationshipNotKnownException error) {
            this.captureRelationshipNotKnownException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: undoRelationshipUpdate with response: " + response.toString());
        return response;
    }

    public RelationshipResponse deleteRelationship(String serverName, String userId, String obsoleteRelationshipGUID, TypeDefValidationForRequest typeDefValidationForRequest) {
        String methodName = "deleteRelationship";
        log.debug("Calling method: deleteRelationship");
        String typeDefGUID = null;
        String typeDefName = null;
        RelationshipResponse response = new RelationshipResponse();
        if (typeDefValidationForRequest != null) {
            typeDefGUID = typeDefValidationForRequest.getTypeDefGUID();
            typeDefName = typeDefValidationForRequest.getTypeDefName();
        }
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "deleteRelationship");
            response.setRelationship(localMetadataCollection.deleteRelationship(userId, typeDefGUID, typeDefName, obsoleteRelationshipGUID));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (RelationshipNotKnownException error) {
            this.captureRelationshipNotKnownException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: deleteRelationship with response: " + response.toString());
        return response;
    }

    public VoidResponse purgeRelationship(String serverName, String userId, String deletedRelationshipGUID, TypeDefValidationForRequest typeDefValidationForRequest) {
        String methodName = "purgeRelationship";
        log.debug("Calling method: purgeRelationship");
        String typeDefGUID = null;
        String typeDefName = null;
        VoidResponse response = new VoidResponse();
        if (typeDefValidationForRequest != null) {
            typeDefGUID = typeDefValidationForRequest.getTypeDefGUID();
            typeDefName = typeDefValidationForRequest.getTypeDefName();
        }
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "purgeRelationship");
            localMetadataCollection.purgeRelationship(userId, typeDefGUID, typeDefName, deletedRelationshipGUID);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (RelationshipNotDeletedException error) {
            this.captureRelationshipNotDeletedException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (RelationshipNotKnownException error) {
            this.captureRelationshipNotKnownException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: purgeRelationship with response: " + response.toString());
        return response;
    }

    public RelationshipResponse restoreRelationship(String serverName, String userId, String deletedRelationshipGUID) {
        String methodName = "restoreRelationship";
        log.debug("Calling method: restoreRelationship");
        RelationshipResponse response = new RelationshipResponse();
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "restoreRelationship");
            response.setRelationship(localMetadataCollection.restoreRelationship(userId, deletedRelationshipGUID));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (RelationshipNotKnownException error) {
            this.captureRelationshipNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (RelationshipNotDeletedException error) {
            this.captureRelationshipNotDeletedException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: restoreRelationship with response: " + response.toString());
        return response;
    }

    public EntityDetailResponse reIdentifyEntity(String serverName, String userId, String entityGUID, String newEntityGUID, TypeDefValidationForRequest typeDefValidationForRequest) {
        String methodName = "reIdentifyEntity";
        log.debug("Calling method: reIdentifyEntity");
        String typeDefGUID = null;
        String typeDefName = null;
        EntityDetailResponse response = new EntityDetailResponse();
        if (typeDefValidationForRequest != null) {
            typeDefGUID = typeDefValidationForRequest.getTypeDefGUID();
            typeDefName = typeDefValidationForRequest.getTypeDefName();
        }
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "reIdentifyEntity");
            response.setEntity(localMetadataCollection.reIdentifyEntity(userId, typeDefGUID, typeDefName, entityGUID, newEntityGUID));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: reIdentifyEntity with response: " + response.toString());
        return response;
    }

    public EntityDetailResponse reTypeEntity(String serverName, String userId, String entityGUID, TypeDefChangeRequest typeDefChangeRequest) {
        String methodName = "reTypeEntity";
        log.debug("Calling method: reTypeEntity");
        TypeDefSummary currentTypeDefSummary = null;
        TypeDefSummary newTypeDefSummary = null;
        EntityDetailResponse response = new EntityDetailResponse();
        if (typeDefChangeRequest != null) {
            currentTypeDefSummary = typeDefChangeRequest.getCurrentTypeDef();
            newTypeDefSummary = typeDefChangeRequest.getNewTypeDef();
        }
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "reTypeEntity");
            response.setEntity(localMetadataCollection.reTypeEntity(userId, entityGUID, currentTypeDefSummary, newTypeDefSummary));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (ClassificationErrorException error) {
            this.captureClassificationErrorException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: reTypeEntity with response: " + response.toString());
        return response;
    }

    public EntityDetailResponse reHomeEntity(String serverName, String userId, String entityGUID, String homeMetadataCollectionId, String newHomeMetadataCollectionId, String newHomeMetadataCollectionName, TypeDefValidationForRequest typeDefValidationForRequest) {
        String methodName = "reHomeEntity";
        log.debug("Calling method: reHomeEntity");
        String typeDefGUID = null;
        String typeDefName = null;
        EntityDetailResponse response = new EntityDetailResponse();
        if (typeDefValidationForRequest != null) {
            typeDefGUID = typeDefValidationForRequest.getTypeDefGUID();
            typeDefName = typeDefValidationForRequest.getTypeDefName();
        }
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "reHomeEntity");
            response.setEntity(localMetadataCollection.reHomeEntity(userId, entityGUID, typeDefGUID, typeDefName, homeMetadataCollectionId, newHomeMetadataCollectionId, newHomeMetadataCollectionName));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: reHomeEntity with response: " + response.toString());
        return response;
    }

    public RelationshipResponse reIdentifyRelationship(String serverName, String userId, String relationshipGUID, String newRelationshipGUID, TypeDefValidationForRequest typeDefValidationForRequest) {
        String methodName = "reIdentifyRelationship";
        log.debug("Calling method: reIdentifyRelationship");
        String typeDefGUID = null;
        String typeDefName = null;
        RelationshipResponse response = new RelationshipResponse();
        if (typeDefValidationForRequest != null) {
            typeDefGUID = typeDefValidationForRequest.getTypeDefGUID();
            typeDefName = typeDefValidationForRequest.getTypeDefName();
        }
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "reIdentifyRelationship");
            response.setRelationship(localMetadataCollection.reIdentifyRelationship(userId, typeDefGUID, typeDefName, relationshipGUID, newRelationshipGUID));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (RelationshipNotKnownException error) {
            this.captureRelationshipNotKnownException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: reIdentifyRelationship with response: " + response.toString());
        return response;
    }

    public RelationshipResponse reTypeRelationship(String serverName, String userId, String relationshipGUID, TypeDefChangeRequest typeDefChangeRequest) {
        String methodName = "reTypeRelationship";
        log.debug("Calling method: reTypeRelationship");
        TypeDefSummary currentTypeDefSummary = null;
        TypeDefSummary newTypeDefSummary = null;
        RelationshipResponse response = new RelationshipResponse();
        if (typeDefChangeRequest != null) {
            currentTypeDefSummary = typeDefChangeRequest.getCurrentTypeDef();
            newTypeDefSummary = typeDefChangeRequest.getNewTypeDef();
        }
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "reTypeRelationship");
            response.setRelationship(localMetadataCollection.reTypeRelationship(userId, relationshipGUID, currentTypeDefSummary, newTypeDefSummary));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeErrorException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (RelationshipNotKnownException error) {
            this.captureRelationshipNotKnownException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: reTypeRelationship with response: " + response.toString());
        return response;
    }

    public RelationshipResponse reHomeRelationship(String serverName, String userId, String relationshipGUID, String homeMetadataCollectionId, String newHomeMetadataCollectionId, String newHomeMetadataCollectionName, TypeDefValidationForRequest typeDefValidationForRequest) {
        String methodName = "reHomeRelationship";
        log.debug("Calling method: reHomeRelationship");
        String typeDefGUID = null;
        String typeDefName = null;
        RelationshipResponse response = new RelationshipResponse();
        if (typeDefValidationForRequest != null) {
            typeDefGUID = typeDefValidationForRequest.getTypeDefGUID();
            typeDefName = typeDefValidationForRequest.getTypeDefName();
        }
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "reHomeRelationship");
            response.setRelationship(localMetadataCollection.reHomeRelationship(userId, relationshipGUID, typeDefGUID, typeDefName, homeMetadataCollectionId, newHomeMetadataCollectionId, newHomeMetadataCollectionName));
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (RelationshipNotKnownException error) {
            this.captureRelationshipNotKnownException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: reHomeRelationship with response: " + response.toString());
        return response;
    }

    public VoidResponse saveEntityReferenceCopy(String serverName, String userId, EntityDetail entity) {
        String methodName = "saveEntityReferenceCopy";
        log.debug("Calling method: saveEntityReferenceCopy");
        VoidResponse response = new VoidResponse();
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "saveEntityReferenceCopy");
            localMetadataCollection.saveEntityReferenceCopy(userId, entity);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeDefErrorException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (HomeEntityException error) {
            this.captureHomeEntityException((OMRSAPIResponse)response, error);
        }
        catch (EntityConflictException error) {
            this.captureEntityConflictException((OMRSAPIResponse)response, error);
        }
        catch (InvalidEntityException error) {
            this.captureInvalidEntityException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: saveEntityReferenceCopy with response: " + response.toString());
        return response;
    }

    public VoidResponse purgeEntityReferenceCopy(String serverName, String userId, String entityGUID, String homeMetadataCollectionId, TypeDefValidationForRequest typeDefValidationForRequest) {
        String methodName = "purgeEntityReferenceCopy";
        log.debug("Calling method: purgeEntityReferenceCopy");
        String typeDefGUID = null;
        String typeDefName = null;
        VoidResponse response = new VoidResponse();
        if (typeDefValidationForRequest != null) {
            typeDefGUID = typeDefValidationForRequest.getTypeDefGUID();
            typeDefName = typeDefValidationForRequest.getTypeDefName();
        }
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "purgeEntityReferenceCopy");
            localMetadataCollection.purgeEntityReferenceCopy(userId, entityGUID, typeDefGUID, typeDefName, homeMetadataCollectionId);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (HomeEntityException error) {
            this.captureHomeEntityException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: purgeEntityReferenceCopy with response: " + response.toString());
        return response;
    }

    public VoidResponse refreshEntityReferenceCopy(String serverName, String userId, String entityGUID, String homeMetadataCollectionId, TypeDefValidationForRequest typeDefValidationForRequest) {
        String methodName = "refreshEntityReferenceCopy";
        log.debug("Calling method: refreshEntityReferenceCopy");
        String typeDefGUID = null;
        String typeDefName = null;
        VoidResponse response = new VoidResponse();
        if (typeDefValidationForRequest != null) {
            typeDefGUID = typeDefValidationForRequest.getTypeDefGUID();
            typeDefName = typeDefValidationForRequest.getTypeDefName();
        }
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "refreshEntityReferenceCopy");
            localMetadataCollection.refreshEntityReferenceCopy(userId, entityGUID, typeDefGUID, typeDefName, homeMetadataCollectionId);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (HomeEntityException error) {
            this.captureHomeEntityException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: refreshEntityReferenceCopy with response: " + response.toString());
        return response;
    }

    public VoidResponse saveRelationshipReferenceCopy(String serverName, String userId, Relationship relationship) {
        String methodName = "saveRelationshipReferenceCopy";
        log.debug("Calling method: saveRelationshipReferenceCopy");
        VoidResponse response = new VoidResponse();
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "saveRelationshipReferenceCopy");
            localMetadataCollection.saveRelationshipReferenceCopy(userId, relationship);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (InvalidRelationshipException error) {
            this.captureInvalidRelationshipException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (HomeRelationshipException error) {
            this.captureHomeRelationshipException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeDefErrorException((OMRSAPIResponse)response, error);
        }
        catch (RelationshipConflictException error) {
            this.captureRelationshipConflictException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: saveRelationshipReferenceCopy with response: " + response.toString());
        return response;
    }

    public VoidResponse purgeRelationshipReferenceCopy(String serverName, String userId, String relationshipGUID, String homeMetadataCollectionId, TypeDefValidationForRequest typeDefValidationForRequest) {
        String methodName = "purgeRelationshipReferenceCopy";
        log.debug("Calling method: purgeRelationshipReferenceCopy");
        String typeDefGUID = null;
        String typeDefName = null;
        VoidResponse response = new VoidResponse();
        if (typeDefValidationForRequest != null) {
            typeDefGUID = typeDefValidationForRequest.getTypeDefGUID();
            typeDefName = typeDefValidationForRequest.getTypeDefName();
        }
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "purgeRelationshipReferenceCopy");
            localMetadataCollection.purgeRelationshipReferenceCopy(userId, relationshipGUID, typeDefGUID, typeDefName, homeMetadataCollectionId);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (RelationshipNotKnownException error) {
            this.captureRelationshipNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (HomeRelationshipException error) {
            this.captureHomeRelationshipException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: purgeRelationshipReferenceCopy with response: " + response.toString());
        return response;
    }

    public VoidResponse refreshRelationshipReferenceCopy(String serverName, String userId, String relationshipGUID, String homeMetadataCollectionId, TypeDefValidationForRequest typeDefValidationForRequest) {
        String methodName = "refreshRelationshipReferenceCopy";
        log.debug("Calling method: refreshRelationshipReferenceCopy");
        String typeDefGUID = null;
        String typeDefName = null;
        VoidResponse response = new VoidResponse();
        if (typeDefValidationForRequest != null) {
            typeDefGUID = typeDefValidationForRequest.getTypeDefGUID();
            typeDefName = typeDefValidationForRequest.getTypeDefName();
        }
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "refreshRelationshipReferenceCopy");
            localMetadataCollection.refreshRelationshipReferenceCopy(userId, relationshipGUID, typeDefGUID, typeDefName, homeMetadataCollectionId);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (RelationshipNotKnownException error) {
            this.captureRelationshipNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (HomeRelationshipException error) {
            this.captureHomeRelationshipException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: refreshRelationshipReferenceCopy with response: " + response.toString());
        return response;
    }

    public VoidResponse saveInstanceReferenceCopies(String serverName, String userId, InstanceGraphRequest instances) {
        String methodName = "saveInstanceReferenceCopies";
        log.debug("Calling method: saveInstanceReferenceCopies");
        InstanceGraph instanceGraph = new InstanceGraph();
        VoidResponse response = new VoidResponse();
        if (instances != null) {
            instanceGraph.setEntities(instances.getEntityElementList());
            instanceGraph.setRelationships(instances.getRelationshipElementList());
        }
        try {
            OMRSMetadataCollection localMetadataCollection = this.validateLocalRepository(serverName, "saveInstanceReferenceCopies");
            localMetadataCollection.saveInstanceReferenceCopies(userId, instanceGraph);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (FunctionNotSupportedException error) {
            this.captureFunctionNotSupportedException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (InvalidEntityException error) {
            this.captureInvalidEntityException((OMRSAPIResponse)response, error);
        }
        catch (InvalidRelationshipException error) {
            this.captureInvalidRelationshipException((OMRSAPIResponse)response, error);
        }
        catch (EntityNotKnownException error) {
            this.captureEntityNotKnownException((OMRSAPIResponse)response, error);
        }
        catch (PropertyErrorException error) {
            this.capturePropertyErrorException((OMRSAPIResponse)response, error);
        }
        catch (TypeErrorException error) {
            this.captureTypeDefErrorException((OMRSAPIResponse)response, error);
        }
        catch (EntityConflictException error) {
            this.captureEntityConflictException((OMRSAPIResponse)response, error);
        }
        catch (RelationshipConflictException error) {
            this.captureRelationshipConflictException((OMRSAPIResponse)response, error);
        }
        log.debug("Returning from method: saveInstanceReferenceCopies with response: " + response.toString());
        return response;
    }

    private OMRSMetadataCollection validateLocalRepository(String localServerName, String methodName) throws RepositoryErrorException {
        OMRSRepositoryServicesInstance instance;
        OMRSMetadataCollection localMetadataCollection = null;
        if (localServerName != null && (instance = servicesInstanceMap.getInstance(localServerName)) != null) {
            localMetadataCollection = instance.getLocalMetadataCollection();
        }
        if (localMetadataCollection == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NO_LOCAL_REPOSITORY;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return localMetadataCollection;
    }

    private void captureUserNotAuthorizedException(OMRSAPIResponse response, UserNotAuthorizedException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureFunctionNotSupportedException(OMRSAPIResponse response, FunctionNotSupportedException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureRepositoryErrorException(OMRSAPIResponse response, RepositoryErrorException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureInvalidParameterException(OMRSAPIResponse response, InvalidParameterException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureInvalidTypeDefException(OMRSAPIResponse response, InvalidTypeDefException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureTypeDefConflictException(OMRSAPIResponse response, TypeDefConflictException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureTypeDefNotSupportedException(OMRSAPIResponse response, TypeDefNotSupportedException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureHomeRelationshipException(OMRSAPIResponse response, HomeRelationshipException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureRelationshipNotKnownException(OMRSAPIResponse response, RelationshipNotKnownException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureInvalidRelationshipException(OMRSAPIResponse response, InvalidRelationshipException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureRelationshipConflictException(OMRSAPIResponse response, RelationshipConflictException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureTypeDefErrorException(OMRSAPIResponse response, TypeErrorException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void capturePropertyErrorException(OMRSAPIResponse response, PropertyErrorException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureEntityNotKnownException(OMRSAPIResponse response, EntityNotKnownException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureHomeEntityException(OMRSAPIResponse response, HomeEntityException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureTypeDefNotKnownException(TypeDefResponse response, TypeDefNotKnownException error) {
        this.captureCheckedException((OMRSAPIResponse)response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureTypeDefNotKnown(OMRSAPIResponse response, TypeDefNotKnownException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureTypeDefKnownException(OMRSAPIResponse response, TypeDefKnownException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureTypeDefInUseException(OMRSAPIResponse response, TypeDefInUseException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureTypeDefNotKnownException(OMRSAPIResponse response, TypeDefNotKnownException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureEntityProxyOnlyException(OMRSAPIResponse response, EntityProxyOnlyException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureClassificationErrorException(OMRSAPIResponse response, ClassificationErrorException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void capturePagingErrorException(OMRSAPIResponse response, PagingErrorException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureTypeErrorException(OMRSAPIResponse response, TypeErrorException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureStatusNotSupportedException(OMRSAPIResponse response, StatusNotSupportedException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureEntityNotDeletedException(OMRSAPIResponse response, EntityNotDeletedException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureRelationshipNotDeletedException(OMRSAPIResponse response, RelationshipNotDeletedException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureInvalidEntityException(OMRSAPIResponse response, InvalidEntityException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureEntityConflictException(OMRSAPIResponse response, EntityConflictException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureCheckedException(OMRSAPIResponse response, OMRSCheckedExceptionBase error, String exceptionClassName) {
        response.setRelatedHTTPCode(error.getReportedHTTPCode());
        response.setExceptionClassName(exceptionClassName);
        response.setExceptionErrorMessage(error.getErrorMessage());
        response.setExceptionSystemAction(error.getReportedSystemAction());
        response.setExceptionUserAction(error.getReportedUserAction());
    }

    private String formatNextPageURL(String serverName, String requestURLTemplate, Object requestBody, Object ... parameters) {
        OMRSRepositoryServicesInstance instance;
        if (serverName != null && (instance = servicesInstanceMap.getInstance(serverName)) != null) {
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                String jsonString = objectMapper.writeValueAsString(requestBody);
                String serverURLRoot = instance.getLocalServerURL();
                MessageFormat mf = new MessageFormat(serverURLRoot + requestURLTemplate);
                return mf.format(parameters) + "{" + jsonString + "}";
            }
            catch (Throwable exc) {
                log.debug("Unable to format return URL; exception is: " + exc.getMessage());
            }
        }
        return null;
    }
}

