/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.admin;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.adminservices.configuration.properties.CohortConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.EnterpriseAccessConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.LocalRepositoryConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.RepositoryServicesConfig;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.archivemanager.OMRSArchiveManager;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditCode;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogDestination;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditingComponent;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.OpenMetadataArchiveStoreConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.auditlogstore.OMRSAuditLogStore;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryeventmapper.OMRSRepositoryEventMapperConnector;
import org.odpi.openmetadata.repositoryservices.enterprise.connectormanager.OMRSConnectionConsumer;
import org.odpi.openmetadata.repositoryservices.enterprise.connectormanager.OMRSEnterpriseConnectorManager;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.EnterpriseOMRSConnection;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.EnterpriseOMRSConnectorProvider;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.EnterpriseOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.eventmanagement.OMRSRepositoryEventExchangeRule;
import org.odpi.openmetadata.repositoryservices.eventmanagement.OMRSRepositoryEventManager;
import org.odpi.openmetadata.repositoryservices.eventmanagement.OMRSRepositoryEventPublisher;
import org.odpi.openmetadata.repositoryservices.events.OMRSInstanceEventProcessorInterface;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSConfigErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;
import org.odpi.openmetadata.repositoryservices.localrepository.repositoryconnector.LocalOMRSConnectorProvider;
import org.odpi.openmetadata.repositoryservices.localrepository.repositoryconnector.LocalOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.localrepository.repositorycontentmanager.OMRSRepositoryContentHelper;
import org.odpi.openmetadata.repositoryservices.localrepository.repositorycontentmanager.OMRSRepositoryContentManager;
import org.odpi.openmetadata.repositoryservices.localrepository.repositorycontentmanager.OMRSRepositoryContentValidator;
import org.odpi.openmetadata.repositoryservices.metadatahighway.OMRSMetadataHighwayManager;
import org.odpi.openmetadata.repositoryservices.rest.server.OMRSRepositoryRESTServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMRSOperationalServices {
    private static final Logger log = LoggerFactory.getLogger(OMRSOperationalServices.class);
    private String localServerName;
    private String localServerType;
    private String localMetadataCollectionName;
    private String localOrganizationName;
    private String localServerUserId;
    private String localServerPassword;
    private String localServerURL;
    private int maxPageSize;
    private String localMetadataCollectionId = null;
    private OMRSRepositoryContentManager localRepositoryContentManager = null;
    private OMRSRepositoryEventManager localRepositoryEventManager = null;
    private OMRSMetadataHighwayManager metadataHighwayManager = null;
    private OMRSEnterpriseConnectorManager enterpriseConnectorManager = null;
    private String enterpriseMetadataCollectionId = null;
    private String enterpriseMetadataCollectionName = null;
    private OMRSTopicConnector enterpriseOMRSTopicConnector = null;
    private LocalOMRSRepositoryConnector localRepositoryConnector = null;
    private OMRSArchiveManager archiveManager = null;
    private OMRSAuditLogDestination auditLogDestination = null;
    private OMRSAuditLog auditLog = null;

    public OMRSOperationalServices(String localServerName, String localServerType, String organizationName, String localServerUserId, String localServerPassword, String localServerURL, int maxPageSize) {
        this.localServerName = localServerName;
        this.localServerType = localServerType;
        this.localOrganizationName = organizationName;
        this.localServerUserId = localServerUserId;
        this.localServerPassword = localServerPassword;
        this.localServerURL = localServerURL;
        this.maxPageSize = maxPageSize;
    }

    public OMRSTopicConnector getEnterpriseOMRSTopicConnector() {
        return this.enterpriseOMRSTopicConnector;
    }

    public OMRSRepositoryConnector getEnterpriseOMRSRepositoryConnector(String callingServiceName) {
        String actionDescription = "getEnterpriseOMRSRepositoryConnector";
        if (this.enterpriseMetadataCollectionId != null) {
            EnterpriseOMRSConnectorProvider connectorProvider = new EnterpriseOMRSConnectorProvider(this.enterpriseConnectorManager, this.localRepositoryContentManager, this.localServerName, this.localServerType, this.localOrganizationName, new OMRSAuditLog(this.auditLogDestination, OMRSAuditingComponent.ENTERPRISE_REPOSITORY_CONNECTOR), this.enterpriseMetadataCollectionId, this.enterpriseMetadataCollectionName);
            try {
                Connector connector = connectorProvider.getConnector(new EnterpriseOMRSConnection());
                EnterpriseOMRSRepositoryConnector omrsRepositoryConnector = (EnterpriseOMRSRepositoryConnector)connector;
                omrsRepositoryConnector.setCallingServiceName(callingServiceName);
                omrsRepositoryConnector.setMaxPageSize(this.maxPageSize);
                OMRSAuditCode auditCode = OMRSAuditCode.NEW_ENTERPRISE_CONNECTOR;
                this.auditLog.logRecord("getEnterpriseOMRSRepositoryConnector", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{callingServiceName}), null, auditCode.getSystemAction(), auditCode.getUserAction());
                omrsRepositoryConnector.start();
                return omrsRepositoryConnector;
            }
            catch (Throwable error) {
                OMRSAuditCode auditCode = OMRSAuditCode.ENTERPRISE_CONNECTOR_FAILED;
                this.auditLog.logRecord("getEnterpriseOMRSRepositoryConnector", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{callingServiceName}), null, auditCode.getSystemAction(), auditCode.getUserAction());
            }
        }
        return null;
    }

    public OMRSEnterpriseConnectorManager getEnterpriseConnectorManager() {
        return this.enterpriseConnectorManager;
    }

    public OMRSAuditLog getAuditLog(int componentId, String componentName, String componentDescription, String componentWikiURL) {
        return new OMRSAuditLog(this.auditLogDestination, componentId, componentName, componentDescription, componentWikiURL);
    }

    public void initialize(RepositoryServicesConfig repositoryServicesConfig) {
        String actionDescription = "Initialize Open Metadata Repository Operational Services";
        String methodName = "initialize";
        if (repositoryServicesConfig == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_CONFIG;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[0]);
            throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "initialize", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        this.auditLogDestination = new OMRSAuditLogDestination(this.localServerName, this.localServerType, this.localOrganizationName, this.getAuditLogStores(repositoryServicesConfig.getAuditLogConnections()));
        this.auditLog = new OMRSAuditLog(this.auditLogDestination, OMRSAuditingComponent.OPERATIONAL_SERVICES);
        OMRSAuditCode auditCode = OMRSAuditCode.OMRS_INITIALIZING;
        this.auditLog.logRecord("Initialize Open Metadata Repository Operational Services", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
        EnterpriseAccessConfig enterpriseAccessConfig = repositoryServicesConfig.getEnterpriseAccessConfig();
        LocalRepositoryConfig localRepositoryConfig = repositoryServicesConfig.getLocalRepositoryConfig();
        List cohortConfigList = repositoryServicesConfig.getCohortConfigList();
        this.localRepositoryContentManager = new OMRSRepositoryContentManager(new OMRSAuditLog(this.auditLogDestination, OMRSAuditingComponent.REPOSITORY_CONTENT_MANAGER));
        this.enterpriseConnectorManager = this.initializeEnterpriseConnectorManager(enterpriseAccessConfig, this.maxPageSize, this.localRepositoryContentManager);
        this.enterpriseOMRSTopicConnector = this.initializeEnterpriseOMRSTopicConnector(enterpriseAccessConfig);
        this.archiveManager = this.initializeOpenMetadataArchives(repositoryServicesConfig.getOpenMetadataArchiveConnections());
        if (localRepositoryConfig != null) {
            this.localMetadataCollectionId = localRepositoryConfig.getMetadataCollectionId();
            this.localMetadataCollectionName = localRepositoryConfig.getMetadataCollectionName();
            if (this.localMetadataCollectionName == null) {
                this.localMetadataCollectionName = this.localServerName;
            }
            auditCode = OMRSAuditCode.LOCAL_REPOSITORY_INITIALIZING;
            this.auditLog.logRecord("Initialize Open Metadata Repository Operational Services", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{this.localMetadataCollectionName, this.localMetadataCollectionId}), null, auditCode.getSystemAction(), auditCode.getUserAction());
            this.localRepositoryEventManager = new OMRSRepositoryEventManager("local repository outbound", new OMRSRepositoryEventExchangeRule(localRepositoryConfig.getEventsToSendRule(), localRepositoryConfig.getSelectedTypesToSend()), new OMRSRepositoryContentValidator(this.localRepositoryContentManager), new OMRSAuditLog(this.auditLogDestination, OMRSAuditingComponent.REPOSITORY_EVENT_MANAGER));
            if (this.enterpriseOMRSTopicConnector != null) {
                OMRSRepositoryEventPublisher enterpriseEventPublisher = new OMRSRepositoryEventPublisher("Local Repository to Enterprise", this.enterpriseOMRSTopicConnector, this.auditLog.createNewAuditLog(OMRSAuditingComponent.EVENT_PUBLISHER));
                this.localRepositoryEventManager.registerRepositoryEventProcessor(enterpriseEventPublisher);
            }
            this.auditLogDestination.setLocalMetadataCollectionId(this.localMetadataCollectionId);
            this.localRepositoryConnector = this.initializeLocalRepository(localRepositoryConfig);
            try {
                this.localRepositoryConnector.start();
            }
            catch (Throwable error) {
                auditCode = OMRSAuditCode.LOCAL_REPOSITORY_FAILED_TO_START;
                this.auditLog.logRecord("Initialize Open Metadata Repository Operational Services", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{error.getMessage()}), null, auditCode.getSystemAction(), auditCode.getUserAction());
            }
        }
        if (this.localRepositoryConnector != null) {
            this.archiveManager.setLocalRepository(this.localRepositoryContentManager, (OMRSInstanceEventProcessorInterface)this.localRepositoryConnector.getIncomingInstanceEventProcessor());
        } else {
            this.archiveManager.setLocalRepository(this.localRepositoryContentManager, null);
        }
        if (this.localRepositoryConnector != null && this.enterpriseConnectorManager != null) {
            this.enterpriseConnectorManager.setLocalConnector(this.localRepositoryConnector.getMetadataCollectionId(), this.localRepositoryConnector);
        }
        if (cohortConfigList != null) {
            auditCode = OMRSAuditCode.METADATA_HIGHWAY_INITIALIZING;
            this.auditLog.logRecord("Initialize Open Metadata Repository Operational Services", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
            this.metadataHighwayManager = this.initializeCohorts(this.localServerName, this.localServerType, this.localOrganizationName, this.localRepositoryConnector, this.localRepositoryContentManager, this.enterpriseConnectorManager, this.enterpriseOMRSTopicConnector, cohortConfigList);
        }
        OMRSRepositoryRESTServices.setServerRepositories(this.localServerName, this.localRepositoryConnector, this.getEnterpriseOMRSRepositoryConnector(OMRSAuditingComponent.REST_SERVICES.getComponentName()), this.metadataHighwayManager, this.localServerURL, this.auditLog.createNewAuditLog(OMRSAuditingComponent.REST_SERVICES), this.maxPageSize);
        if (this.localRepositoryEventManager != null) {
            this.localRepositoryEventManager.start();
        }
        auditCode = OMRSAuditCode.OMRS_INITIALIZED;
        this.auditLog.logRecord("Initialize Open Metadata Repository Operational Services", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
    }

    private OMRSTopicConnector initializeEnterpriseOMRSTopicConnector(EnterpriseAccessConfig enterpriseAccessConfig) {
        Connection enterpriseOMRSTopicConnection;
        OMRSTopicConnector enterpriseOMRSTopicConnector = null;
        if (enterpriseAccessConfig != null && (enterpriseOMRSTopicConnection = enterpriseAccessConfig.getEnterpriseOMRSTopicConnection()) != null) {
            enterpriseOMRSTopicConnector = this.getTopicConnector("Enterprise Access", enterpriseOMRSTopicConnection);
        }
        return enterpriseOMRSTopicConnector;
    }

    private OMRSEnterpriseConnectorManager initializeEnterpriseConnectorManager(EnterpriseAccessConfig enterpriseAccessConfig, int maxPageSize, OMRSRepositoryContentManager repositoryContentManager) {
        OMRSEnterpriseConnectorManager enterpriseConnectorManager;
        if (enterpriseAccessConfig == null) {
            enterpriseConnectorManager = new OMRSEnterpriseConnectorManager(false, maxPageSize, repositoryContentManager, new OMRSAuditLog(this.auditLogDestination, OMRSAuditingComponent.ENTERPRISE_CONNECTOR_MANAGER), this.localServerUserId, this.localServerPassword);
        } else {
            String actionDescription = "Initialize Repository Operational Services";
            OMRSAuditCode auditCode = OMRSAuditCode.ENTERPRISE_ACCESS_INITIALIZING;
            this.auditLog.logRecord("Initialize Repository Operational Services", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
            enterpriseConnectorManager = new OMRSEnterpriseConnectorManager(true, maxPageSize, repositoryContentManager, new OMRSAuditLog(this.auditLogDestination, OMRSAuditingComponent.ENTERPRISE_CONNECTOR_MANAGER), this.localServerUserId, this.localServerPassword);
            this.enterpriseMetadataCollectionId = enterpriseAccessConfig.getEnterpriseMetadataCollectionId();
            this.enterpriseMetadataCollectionName = enterpriseAccessConfig.getEnterpriseMetadataCollectionName();
        }
        return enterpriseConnectorManager;
    }

    private LocalOMRSRepositoryConnector initializeLocalRepository(LocalRepositoryConfig localRepositoryConfig) {
        LocalOMRSRepositoryConnector localRepositoryConnector = null;
        if (localRepositoryConfig != null) {
            LocalOMRSConnectorProvider localConnectorProvider = new LocalOMRSConnectorProvider(this.localMetadataCollectionId, localRepositoryConfig.getLocalRepositoryRemoteConnection(), this.getLocalRepositoryEventMapper(localRepositoryConfig.getEventMapperConnection()), this.localRepositoryEventManager, this.localRepositoryContentManager, new OMRSRepositoryEventExchangeRule(localRepositoryConfig.getEventsToSaveRule(), localRepositoryConfig.getSelectedTypesToSave()));
            Connection localRepositoryConnection = localRepositoryConfig.getLocalRepositoryLocalConnection() != null ? localRepositoryConfig.getLocalRepositoryLocalConnection() : localRepositoryConfig.getLocalRepositoryRemoteConnection();
            localRepositoryConnector = this.getLocalOMRSConnector(localRepositoryConnection, localConnectorProvider);
        }
        return localRepositoryConnector;
    }

    private OMRSArchiveManager initializeOpenMetadataArchives(List<Connection> openMetadataArchiveConnections) {
        ArrayList<OpenMetadataArchiveStoreConnector> openMetadataArchives = null;
        if (openMetadataArchiveConnections != null) {
            openMetadataArchives = new ArrayList<OpenMetadataArchiveStoreConnector>();
            for (Connection archiveConnection : openMetadataArchiveConnections) {
                if (archiveConnection == null) continue;
                openMetadataArchives.add(this.getOpenMetadataArchiveStore(archiveConnection));
            }
        }
        return new OMRSArchiveManager(openMetadataArchives, new OMRSAuditLog(this.auditLogDestination, OMRSAuditingComponent.ARCHIVE_MANAGER));
    }

    private OMRSMetadataHighwayManager initializeCohorts(String localServerName, String localServerType, String localOrganizationName, LocalOMRSRepositoryConnector localRepositoryConnector, OMRSRepositoryContentManager localRepositoryContentManager, OMRSConnectionConsumer connectionConsumer, OMRSTopicConnector enterpriseTopicConnector, List<CohortConfig> cohortConfigList) {
        OMRSMetadataHighwayManager metadataHighwayManager = new OMRSMetadataHighwayManager(localServerName, localServerType, localOrganizationName, localRepositoryConnector, localRepositoryContentManager, connectionConsumer, enterpriseTopicConnector, new OMRSAuditLog(this.auditLogDestination, OMRSAuditingComponent.METADATA_HIGHWAY_MANAGER));
        metadataHighwayManager.initialize(cohortConfigList);
        return metadataHighwayManager;
    }

    public void setSecurityVerifier(OpenMetadataServerSecurityVerifier securityVerifier) {
        if (securityVerifier != null && this.localRepositoryConnector != null) {
            this.localRepositoryConnector.setSecurityVerifier(securityVerifier);
        }
    }

    public void addOpenMetadataArchive(Connection openMetadataArchiveConnection) {
        this.archiveManager.addOpenMetadataArchive(this.getOpenMetadataArchiveStore(openMetadataArchiveConnection));
    }

    public boolean disconnect(boolean permanent) {
        String actionDescription = "Disconnect Repository Operational Services";
        OMRSAuditCode auditCode = OMRSAuditCode.OMRS_DISCONNECTING;
        this.auditLog.logRecord("Disconnect Repository Operational Services", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
        OMRSRepositoryRESTServices.stopInboundRESTCalls(this.localServerName);
        if (this.metadataHighwayManager != null) {
            this.metadataHighwayManager.disconnect(permanent);
        }
        if (this.enterpriseOMRSTopicConnector != null) {
            try {
                this.enterpriseOMRSTopicConnector.disconnect();
            }
            catch (Throwable error) {
                auditCode = OMRSAuditCode.ENTERPRISE_TOPIC_DISCONNECT_ERROR;
                this.auditLog.logRecord("Disconnect Repository Operational Services", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{error.getMessage()}), null, auditCode.getSystemAction(), auditCode.getUserAction());
            }
        }
        if (this.enterpriseConnectorManager != null) {
            try {
                this.enterpriseConnectorManager.disconnect();
            }
            catch (Throwable error) {
                auditCode = OMRSAuditCode.ENTERPRISE_CONNECTOR_DISCONNECT_ERROR;
                this.auditLog.logRecord("Disconnect Repository Operational Services", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{error.getMessage()}), null, auditCode.getSystemAction(), auditCode.getUserAction());
            }
        }
        if (this.archiveManager != null) {
            this.archiveManager.close();
        }
        auditCode = OMRSAuditCode.OMRS_DISCONNECTED;
        this.auditLog.logRecord("Disconnect Repository Operational Services", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[0]), null, auditCode.getSystemAction(), auditCode.getUserAction());
        return true;
    }

    private List<OMRSAuditLogStore> getAuditLogStores(List<Connection> auditLogStoreConnections) {
        ArrayList<OMRSAuditLogStore> auditLogStores = new ArrayList<OMRSAuditLogStore>();
        for (Connection auditLogStoreConnection : auditLogStoreConnections) {
            auditLogStores.add(this.getAuditLogStore(auditLogStoreConnection));
        }
        if (auditLogStores.isEmpty()) {
            return null;
        }
        return auditLogStores;
    }

    private OMRSAuditLogStore getAuditLogStore(Connection auditLogStoreConnection) {
        try {
            ConnectorBroker connectorBroker = new ConnectorBroker();
            Connector connector = connectorBroker.getConnector(auditLogStoreConnection);
            return (OMRSAuditLogStore)connector;
        }
        catch (Throwable error) {
            String methodName = "getAuditLogStore";
            log.debug("Unable to create audit log store connector: " + error.toString());
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_AUDIT_LOG_STORE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{this.localServerName});
            OMRSAuditCode auditCode = OMRSAuditCode.BAD_AUDIT_LOG_DESTINATION;
            this.auditLog.logRecord(methodName, auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{error.getClass().getName(), error.getMessage()}), null, auditCode.getSystemAction(), auditCode.getUserAction());
            throw new OMRSConfigErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
        }
    }

    private OMRSTopicConnector getTopicConnector(String sourceName, Connection topicConnection) {
        try {
            ConnectorBroker connectorBroker = new ConnectorBroker();
            Connector connector = connectorBroker.getConnector(topicConnection);
            OMRSTopicConnector topicConnector = (OMRSTopicConnector)connector;
            topicConnector.setAuditLog(new OMRSAuditLog(this.auditLogDestination, OMRSAuditingComponent.OMRS_TOPIC_CONNECTOR));
            return topicConnector;
        }
        catch (Throwable error) {
            String methodName = "getTopicConnector";
            log.debug("Unable to create topic connector: " + error.toString());
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_TOPIC_CONNECTOR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{sourceName});
            OMRSAuditCode auditCode = OMRSAuditCode.BAD_TOPIC_CONNECTION;
            this.auditLog.logRecord(methodName, auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{sourceName, error.getClass().getName(), error.getMessage()}), null, auditCode.getSystemAction(), auditCode.getUserAction());
            throw new OMRSConfigErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
        }
    }

    private OpenMetadataArchiveStoreConnector getOpenMetadataArchiveStore(Connection openMetadataArchiveStoreConnection) {
        try {
            ConnectorBroker connectorBroker = new ConnectorBroker();
            Connector connector = connectorBroker.getConnector(openMetadataArchiveStoreConnection);
            OpenMetadataArchiveStoreConnector archiveStoreConnector = (OpenMetadataArchiveStoreConnector)connector;
            archiveStoreConnector.setAuditLog(new OMRSAuditLog(this.auditLogDestination, OMRSAuditingComponent.ARCHIVE_STORE_CONNECTOR));
            return archiveStoreConnector;
        }
        catch (Throwable error) {
            String methodName = "getOpenMetadataArchiveStore";
            if (log.isDebugEnabled()) {
                log.debug("Unable to create open metadata archive connector: " + error.toString());
            }
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_ARCHIVE_STORE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{this.localServerName});
            OMRSAuditCode auditCode = OMRSAuditCode.BAD_ARCHIVE_STORE;
            this.auditLog.logRecord(methodName, auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{error.getClass().getName(), error.getMessage()}), null, auditCode.getSystemAction(), auditCode.getUserAction());
            throw new OMRSConfigErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
        }
    }

    private OMRSRepositoryEventMapperConnector getLocalRepositoryEventMapper(Connection localRepositoryEventMapperConnection) {
        if (localRepositoryEventMapperConnection == null) {
            return null;
        }
        try {
            ConnectorBroker connectorBroker = new ConnectorBroker();
            Connector connector = connectorBroker.getConnector(localRepositoryEventMapperConnection);
            OMRSRepositoryEventMapperConnector eventMapperConnector = (OMRSRepositoryEventMapperConnector)connector;
            eventMapperConnector.setAuditLog(new OMRSAuditLog(this.auditLogDestination, OMRSAuditingComponent.LOCAL_REPOSITORY_EVENT_MAPPER));
            return eventMapperConnector;
        }
        catch (Throwable error) {
            String methodName = "getLocalRepositoryEventMapper";
            log.debug("Unable to create local repository event mapper connector: " + error.toString());
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_EVENT_MAPPER;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{this.localServerName});
            OMRSAuditCode auditCode = OMRSAuditCode.BAD_REAL_LOCAL_EVENT_MAPPER;
            this.auditLog.logRecord(methodName, auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{error.getClass().getName(), error.getMessage()}), null, auditCode.getSystemAction(), auditCode.getUserAction());
            throw new OMRSConfigErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
        }
    }

    private LocalOMRSRepositoryConnector getLocalOMRSConnector(Connection connection, LocalOMRSConnectorProvider connectorProvider) {
        String methodName = "getLocalOMRSConnector";
        try {
            LocalOMRSRepositoryConnector localRepositoryConnector = (LocalOMRSRepositoryConnector)connectorProvider.getConnector(connection);
            localRepositoryConnector.setAuditLog(new OMRSAuditLog(this.auditLogDestination, OMRSAuditingComponent.LOCAL_REPOSITORY_CONNECTOR));
            localRepositoryConnector.setMaxPageSize(this.maxPageSize);
            localRepositoryConnector.setServerName(this.localServerName);
            localRepositoryConnector.setServerType(this.localServerType);
            localRepositoryConnector.setServerUserId(this.localServerUserId);
            localRepositoryConnector.setOrganizationName(this.localOrganizationName);
            localRepositoryConnector.setRepositoryHelper(new OMRSRepositoryContentHelper(this.localRepositoryContentManager));
            localRepositoryConnector.setRepositoryValidator(new OMRSRepositoryContentValidator(this.localRepositoryContentManager));
            localRepositoryConnector.setMetadataCollectionId(this.localMetadataCollectionId);
            localRepositoryConnector.setMetadataCollectionName(this.localMetadataCollectionName);
            return localRepositoryConnector;
        }
        catch (Throwable error) {
            String connectionName = connection.getQualifiedName();
            OMRSErrorCode errorCode = OMRSErrorCode.INVALID_OMRS_CONNECTION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{connectionName});
            OMRSAuditCode auditCode = OMRSAuditCode.BAD_REAL_LOCAL_REPOSITORY_CONNECTOR;
            this.auditLog.logRecord(methodName, auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{error.getClass().getName(), error.getMessage()}), null, auditCode.getSystemAction(), auditCode.getUserAction());
            throw new OMRSConfigErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
        }
    }
}

