/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollectionBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceGraph;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefGallery;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.EnterpriseOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.control.ParallelFederationControl;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.control.SequentialFederationControl;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.AddEntityExecutor;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.AddRelationshipExecutor;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.FindEntitiesByClassificationExecutor;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.FindEntitiesByPropertyExecutor;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.FindEntitiesByPropertyValueExecutor;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.FindRelationshipsByPropertyExecutor;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.FindRelationshipsByPropertyValueExecutor;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.GetAllTypesExecutor;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.GetEntityExecutor;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.GetEntitySummaryExecutor;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.GetRelationshipExecutor;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.GetRelationshipsForEntityExecutor;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.PurgeEntityExecutor;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.PurgeRelationshipExecutor;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.RestoreEntityExecutor;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.RestoreRelationshipExecutor;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.VerifyAttributeTypeDefExecutor;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.VerifyTypeDefExecutor;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidTypeDefException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.StatusNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;

class EnterpriseOMRSMetadataCollection
extends OMRSMetadataCollectionBase {
    private EnterpriseOMRSRepositoryConnector enterpriseParentConnector;
    private String localMetadataCollectionId;
    private OMRSAuditLog auditLog;

    EnterpriseOMRSMetadataCollection(EnterpriseOMRSRepositoryConnector enterpriseParentConnector, String repositoryName, OMRSRepositoryHelper repositoryHelper, OMRSRepositoryValidator repositoryValidator, String metadataCollectionId, String localMetadataCollectionId, OMRSAuditLog auditLog) {
        super((OMRSRepositoryConnector)enterpriseParentConnector, repositoryName, repositoryHelper, repositoryValidator, metadataCollectionId);
        this.enterpriseParentConnector = enterpriseParentConnector;
        this.localMetadataCollectionId = localMetadataCollectionId;
        this.auditLog = auditLog;
    }

    public TypeDefGallery getAllTypes(String userId) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "getAllTypes";
        super.basicRequestValidation(userId, "getAllTypes");
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("getAllTypes");
        ParallelFederationControl federationControl = new ParallelFederationControl(userId, cohortConnectors, "getAllTypes");
        GetAllTypesExecutor executor = new GetAllTypesExecutor(userId, "getAllTypes", this.localMetadataCollectionId, this.auditLog, this.repositoryValidator);
        federationControl.executeCommand(executor);
        return executor.getResults();
    }

    public TypeDefGallery findTypesByName(String userId, String name) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "findTypesByName";
        String nameParameterName = "name";
        super.typeNameParameterValidation(userId, name, "name", "findTypesByName");
        TypeDefGallery allTypes = this.getAllTypes(userId);
        if (allTypes != null) {
            return super.filterTypesByWildCardName(this.repositoryHelper.getActiveTypeDefs(), this.repositoryHelper.getActiveAttributeTypeDefs(), name);
        }
        return null;
    }

    public List<TypeDef> findTypeDefsByCategory(String userId, TypeDefCategory category) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "findTypeDefsByCategory";
        String categoryParameterName = "category";
        super.typeDefCategoryParameterValidation(userId, category, "category", "findTypeDefsByCategory");
        TypeDefGallery allTypes = this.getAllTypes(userId);
        if (allTypes != null) {
            return super.filterTypeDefsByCategory((List)allTypes.getTypeDefs(), category);
        }
        return null;
    }

    public List<AttributeTypeDef> findAttributeTypeDefsByCategory(String userId, AttributeTypeDefCategory category) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "findAttributeTypeDefsByCategory";
        String categoryParameterName = "category";
        super.attributeTypeDefCategoryParameterValidation(userId, category, "category", "findAttributeTypeDefsByCategory");
        TypeDefGallery allTypes = this.getAllTypes(userId);
        if (allTypes != null) {
            return super.filterAttributeTypeDefsByCategory(allTypes.getAttributeTypeDefs(), category);
        }
        return null;
    }

    public List<TypeDef> findTypeDefsByProperty(String userId, TypeDefProperties matchCriteria) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "findTypeDefsByProperty";
        String matchCriteriaParameterName = "matchCriteria";
        super.typeDefPropertyParameterValidation(userId, matchCriteria, "matchCriteria", "findTypeDefsByProperty");
        TypeDefGallery allTypes = this.getAllTypes(userId);
        if (allTypes != null) {
            return this.filterTypeDefsByProperty(allTypes.getTypeDefs(), matchCriteria);
        }
        return null;
    }

    public List<TypeDef> findTypesByExternalID(String userId, String standard, String organization, String identifier) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "findTypesByExternalID";
        super.typeDefExternalIDParameterValidation(userId, standard, organization, identifier, "findTypesByExternalID");
        TypeDefGallery allTypes = this.getAllTypes(userId);
        if (allTypes != null) {
            return super.filterTypesByExternalID((List)allTypes.getTypeDefs(), standard, organization, identifier);
        }
        return null;
    }

    public List<TypeDef> searchForTypeDefs(String userId, String searchCriteria) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "searchForTypeDefs";
        String searchCriteriaParameterName = "searchCriteria";
        this.typeDefSearchParameterValidation(userId, searchCriteria, "searchCriteria", "searchForTypeDefs");
        TypeDefGallery allTypes = this.getAllTypes(userId);
        if (allTypes != null) {
            return super.filterTypeDefsBySearchCriteria((List)allTypes.getTypeDefs(), searchCriteria);
        }
        return null;
    }

    public TypeDef getTypeDefByGUID(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException {
        String methodName = "getTypeDefByGUID";
        String guidParameterName = "guid";
        super.typeGUIDParameterValidation(userId, guid, "guid", "getTypeDefByGUID");
        TypeDefGallery allTypes = this.getAllTypes(userId);
        if (allTypes != null) {
            TypeDef result = super.filterTypeDefsByGUID((List)allTypes.getTypeDefs(), guid);
            if (result == null) {
                super.reportUnknownTypeGUID(guid, "guid", "getTypeDefByGUID");
            }
            return result;
        }
        return null;
    }

    public AttributeTypeDef getAttributeTypeDefByGUID(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException {
        String methodName = "getAttributeTypeDefByGUID";
        String guidParameterName = "guid";
        super.typeGUIDParameterValidation(userId, guid, "guid", "getAttributeTypeDefByGUID");
        TypeDefGallery allTypes = this.getAllTypes(userId);
        if (allTypes != null) {
            AttributeTypeDef result = super.filterAttributeTypeDefsByGUID(allTypes.getAttributeTypeDefs(), guid);
            if (result == null) {
                super.reportUnknownTypeGUID(guid, "guid", "getAttributeTypeDefByGUID");
            }
            return result;
        }
        return null;
    }

    public TypeDef getTypeDefByName(String userId, String name) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException {
        String methodName = "getTypeDefByName";
        String nameParameterName = "name";
        this.typeNameParameterValidation(userId, name, "name", "getTypeDefByName");
        TypeDefGallery allTypes = this.getAllTypes(userId);
        if (allTypes != null) {
            TypeDef result = super.filterTypeDefsByName((List)allTypes.getTypeDefs(), name);
            if (result == null) {
                super.reportUnknownTypeName(name, "getTypeDefByName");
            }
            return result;
        }
        return null;
    }

    public AttributeTypeDef getAttributeTypeDefByName(String userId, String name) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException {
        String methodName = "getAttributeTypeDefByName";
        String nameParameterName = "name";
        this.typeNameParameterValidation(userId, name, "name", "getAttributeTypeDefByName");
        TypeDefGallery allTypes = this.getAllTypes(userId);
        if (allTypes != null) {
            AttributeTypeDef result = super.filterAttributeTypeDefsByName(this.repositoryHelper.getKnownAttributeTypeDefs(), name);
            if (result == null) {
                super.reportUnknownTypeName(name, "getAttributeTypeDefByName");
            }
            return result;
        }
        return null;
    }

    public void addTypeDefGallery(String userId, TypeDefGallery newTypes) throws FunctionNotSupportedException {
        String methodName = "addTypeDefGallery";
        this.throwNotEnterpriseFunction("addTypeDefGallery");
    }

    public void addTypeDef(String userId, TypeDef newTypeDef) throws FunctionNotSupportedException {
        String methodName = "addTypeDef";
        this.throwNotEnterpriseFunction("addTypeDef");
    }

    public void addAttributeTypeDef(String userId, AttributeTypeDef newAttributeTypeDef) throws FunctionNotSupportedException {
        String methodName = "addAttributeTypeDef";
        this.throwNotEnterpriseFunction("addAttributeTypeDef");
    }

    public boolean verifyTypeDef(String userId, TypeDef typeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefConflictException, InvalidTypeDefException, UserNotAuthorizedException {
        String methodName = "verifyTypeDef";
        String typeDefParameterName = "typeDef";
        super.typeDefParameterValidation(userId, typeDef, "typeDef", "verifyTypeDef");
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("verifyTypeDef");
        SequentialFederationControl federationControl = new SequentialFederationControl(userId, cohortConnectors, "verifyTypeDef");
        VerifyTypeDefExecutor executor = new VerifyTypeDefExecutor(userId, typeDef, "verifyTypeDef");
        federationControl.executeCommand(executor);
        return executor.getResult();
    }

    public boolean verifyAttributeTypeDef(String userId, AttributeTypeDef attributeTypeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefConflictException, InvalidTypeDefException, UserNotAuthorizedException {
        String methodName = "verifyAttributeTypeDef";
        String typeDefParameterName = "attributeTypeDef";
        super.attributeTypeDefParameterValidation(userId, attributeTypeDef, "attributeTypeDef", "verifyAttributeTypeDef");
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("verifyAttributeTypeDef");
        SequentialFederationControl federationControl = new SequentialFederationControl(userId, cohortConnectors, "verifyAttributeTypeDef");
        VerifyAttributeTypeDefExecutor executor = new VerifyAttributeTypeDefExecutor(userId, attributeTypeDef, "verifyAttributeTypeDef");
        federationControl.executeCommand(executor);
        return executor.getResult();
    }

    public TypeDef updateTypeDef(String userId, TypeDefPatch typeDefPatch) throws FunctionNotSupportedException {
        String methodName = "updateTypeDef";
        this.throwNotEnterpriseFunction("updateTypeDef");
        return null;
    }

    public void deleteTypeDef(String userId, String obsoleteTypeDefGUID, String obsoleteTypeDefName) throws FunctionNotSupportedException {
        String methodName = "deleteTypeDef";
        this.throwNotEnterpriseFunction("deleteTypeDef");
    }

    public void deleteAttributeTypeDef(String userId, String obsoleteTypeDefGUID, String obsoleteTypeDefName) throws FunctionNotSupportedException {
        String methodName = "deleteAttributeTypeDef";
        this.throwNotEnterpriseFunction("deleteAttributeTypeDef");
    }

    public TypeDef reIdentifyTypeDef(String userId, String originalTypeDefGUID, String originalTypeDefName, String newTypeDefGUID, String newTypeDefName) throws FunctionNotSupportedException {
        String methodName = "reIdentifyTypeDef";
        this.throwNotEnterpriseFunction("reIdentifyTypeDef");
        return null;
    }

    public AttributeTypeDef reIdentifyAttributeTypeDef(String userId, String originalAttributeTypeDefGUID, String originalAttributeTypeDefName, String newAttributeTypeDefGUID, String newAttributeTypeDefName) throws FunctionNotSupportedException {
        String methodName = "reIdentifyAttributeTypeDef";
        this.throwNotEnterpriseFunction("reIdentifyAttributeTypeDef");
        return null;
    }

    public EntityDetail isEntityKnown(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "isEntityKnown";
        super.getInstanceParameterValidation(userId, guid, "isEntityKnown");
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("isEntityKnown");
        SequentialFederationControl federationControl = new SequentialFederationControl(userId, cohortConnectors, "isEntityKnown");
        GetEntityExecutor executor = new GetEntityExecutor(userId, guid, false, "isEntityKnown");
        federationControl.executeCommand(executor);
        return executor.isEntityKnown();
    }

    public EntitySummary getEntitySummary(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, UserNotAuthorizedException {
        String methodName = "getEntitySummary";
        super.getInstanceParameterValidation(userId, guid, "getEntitySummary");
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("getEntitySummary");
        SequentialFederationControl federationControl = new SequentialFederationControl(userId, cohortConnectors, "getEntitySummary");
        GetEntitySummaryExecutor executor = new GetEntitySummaryExecutor(userId, guid, "getEntitySummary");
        federationControl.executeCommand(executor);
        return executor.getEntitySummary();
    }

    public EntityDetail getEntityDetail(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityProxyOnlyException, UserNotAuthorizedException {
        String methodName = "getEntityDetail";
        super.getInstanceParameterValidation(userId, guid, "getEntityDetail");
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("getEntityDetail");
        SequentialFederationControl federationControl = new SequentialFederationControl(userId, cohortConnectors, "getEntityDetail");
        GetEntityExecutor executor = new GetEntityExecutor(userId, guid, true, "getEntityDetail");
        federationControl.executeCommand(executor);
        return executor.getEntityDetail();
    }

    public EntityDetail getEntityDetail(String userId, String guid, Date asOfTime) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityProxyOnlyException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getEntityDetail";
        super.getInstanceParameterValidation(userId, guid, asOfTime, "getEntityDetail");
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("getEntityDetail");
        SequentialFederationControl federationControl = new SequentialFederationControl(userId, cohortConnectors, "getEntityDetail");
        GetEntityExecutor executor = new GetEntityExecutor(userId, guid, asOfTime, "getEntityDetail");
        federationControl.executeCommand(executor);
        return executor.getEntityDetailHistory();
    }

    public List<Relationship> getRelationshipsForEntity(String userId, String entityGUID, String relationshipTypeGUID, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getRelationshipsForEntity";
        super.getRelationshipsForEntityParameterValidation(userId, entityGUID, relationshipTypeGUID, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("getRelationshipsForEntity");
        ParallelFederationControl federationControl = new ParallelFederationControl(userId, cohortConnectors, "getRelationshipsForEntity");
        GetRelationshipsForEntityExecutor executor = new GetRelationshipsForEntityExecutor(userId, entityGUID, relationshipTypeGUID, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize, this.localMetadataCollectionId, this.auditLog, this.repositoryValidator, "getRelationshipsForEntity");
        federationControl.executeCommand(executor);
        return executor.getResults(this.enterpriseParentConnector);
    }

    public List<EntityDetail> findEntitiesByProperty(String userId, String entityTypeGUID, InstanceProperties matchProperties, MatchCriteria matchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "findEntitiesByProperty";
        super.findEntitiesByPropertyParameterValidation(userId, entityTypeGUID, matchProperties, matchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("findEntitiesByProperty");
        ParallelFederationControl federationControl = new ParallelFederationControl(userId, cohortConnectors, "findEntitiesByProperty");
        FindEntitiesByPropertyExecutor executor = new FindEntitiesByPropertyExecutor(userId, entityTypeGUID, matchProperties, matchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize, this.localMetadataCollectionId, this.auditLog, this.repositoryValidator, "findEntitiesByProperty");
        federationControl.executeCommand(executor);
        return executor.getResults(this.enterpriseParentConnector);
    }

    public List<EntityDetail> findEntitiesByClassification(String userId, String entityTypeGUID, String classificationName, InstanceProperties matchClassificationProperties, MatchCriteria matchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, ClassificationErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "findEntitiesByClassification";
        super.findEntitiesByClassificationParameterValidation(userId, entityTypeGUID, classificationName, matchClassificationProperties, matchCriteria, fromEntityElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("findEntitiesByClassification");
        ParallelFederationControl federationControl = new ParallelFederationControl(userId, cohortConnectors, "findEntitiesByClassification");
        FindEntitiesByClassificationExecutor executor = new FindEntitiesByClassificationExecutor(userId, entityTypeGUID, classificationName, matchClassificationProperties, matchCriteria, fromEntityElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize, this.localMetadataCollectionId, this.auditLog, this.repositoryValidator, "findEntitiesByClassification");
        federationControl.executeCommand(executor);
        return executor.getResults(this.enterpriseParentConnector);
    }

    public List<EntityDetail> findEntitiesByPropertyValue(String userId, String entityTypeGUID, String searchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "findEntitiesByPropertyValue";
        super.findEntitiesByPropertyValueParameterValidation(userId, entityTypeGUID, searchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("findEntitiesByPropertyValue");
        ParallelFederationControl federationControl = new ParallelFederationControl(userId, cohortConnectors, "findEntitiesByPropertyValue");
        FindEntitiesByPropertyValueExecutor executor = new FindEntitiesByPropertyValueExecutor(userId, entityTypeGUID, searchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize, this.localMetadataCollectionId, this.auditLog, this.repositoryValidator, "findEntitiesByPropertyValue");
        federationControl.executeCommand(executor);
        return executor.getResults(this.enterpriseParentConnector);
    }

    public Relationship isRelationshipKnown(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "isRelationshipKnown";
        super.getInstanceParameterValidation(userId, guid, "isRelationshipKnown");
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("isRelationshipKnown");
        SequentialFederationControl federationControl = new SequentialFederationControl(userId, cohortConnectors, "isRelationshipKnown");
        GetRelationshipExecutor executor = new GetRelationshipExecutor(userId, guid, false, "isRelationshipKnown");
        federationControl.executeCommand(executor);
        return executor.isRelationshipKnown();
    }

    public Relationship getRelationship(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, UserNotAuthorizedException {
        String methodName = "getRelationship";
        super.getInstanceParameterValidation(userId, guid, "getRelationship");
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("getRelationship");
        SequentialFederationControl federationControl = new SequentialFederationControl(userId, cohortConnectors, "getRelationship");
        GetRelationshipExecutor executor = new GetRelationshipExecutor(userId, guid, true, "getRelationship");
        federationControl.executeCommand(executor);
        return executor.getRelationship();
    }

    public Relationship getRelationship(String userId, String guid, Date asOfTime) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getRelationship";
        super.getInstanceParameterValidation(userId, guid, asOfTime, "getRelationship");
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("getRelationship");
        SequentialFederationControl federationControl = new SequentialFederationControl(userId, cohortConnectors, "getRelationship");
        GetRelationshipExecutor executor = new GetRelationshipExecutor(userId, guid, asOfTime, "getRelationship");
        federationControl.executeCommand(executor);
        return executor.getRelationshipHistory();
    }

    public List<Relationship> findRelationshipsByProperty(String userId, String relationshipTypeGUID, InstanceProperties matchProperties, MatchCriteria matchCriteria, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "findRelationshipsByProperty";
        super.findRelationshipsByPropertyParameterValidation(userId, relationshipTypeGUID, matchProperties, matchCriteria, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("findRelationshipsByProperty");
        ParallelFederationControl federationControl = new ParallelFederationControl(userId, cohortConnectors, "findRelationshipsByProperty");
        FindRelationshipsByPropertyExecutor executor = new FindRelationshipsByPropertyExecutor(userId, relationshipTypeGUID, matchProperties, matchCriteria, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize, this.localMetadataCollectionId, this.auditLog, this.repositoryValidator, "findRelationshipsByProperty");
        federationControl.executeCommand(executor);
        return executor.getResults(this.enterpriseParentConnector);
    }

    public List<Relationship> findRelationshipsByPropertyValue(String userId, String relationshipTypeGUID, String searchCriteria, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "findRelationshipsByPropertyValue";
        this.findRelationshipsByPropertyValueParameterValidation(userId, relationshipTypeGUID, searchCriteria, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("findRelationshipsByPropertyValue");
        ParallelFederationControl federationControl = new ParallelFederationControl(userId, cohortConnectors, "findRelationshipsByPropertyValue");
        FindRelationshipsByPropertyValueExecutor executor = new FindRelationshipsByPropertyValueExecutor(userId, relationshipTypeGUID, searchCriteria, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize, this.localMetadataCollectionId, this.auditLog, this.repositoryValidator, "findRelationshipsByPropertyValue");
        federationControl.executeCommand(executor);
        return executor.getResults(this.enterpriseParentConnector);
    }

    public InstanceGraph getLinkingEntities(String userId, String startEntityGUID, String endEntityGUID, List<InstanceStatus> limitResultsByStatus, Date asOfTime) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getLinkingEntities";
        super.getLinkingEntitiesParameterValidation(userId, startEntityGUID, endEntityGUID, limitResultsByStatus, asOfTime);
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("getLinkingEntities");
        Map<String, EntityDetail> combinedEntityResults = new HashMap<String, EntityDetail>();
        Map<String, Relationship> combinedRelationshipResults = new HashMap<String, Relationship>();
        EntityNotKnownException entityNotKnownException = null;
        FunctionNotSupportedException functionNotSupportedException = null;
        PropertyErrorException propertyErrorException = null;
        UserNotAuthorizedException userNotAuthorizedException = null;
        RepositoryErrorException repositoryErrorException = null;
        Throwable anotherException = null;
        for (OMRSRepositoryConnector cohortConnector : cohortConnectors) {
            if (cohortConnector == null) continue;
            OMRSMetadataCollection metadataCollection = cohortConnector.getMetadataCollection();
            this.validateMetadataCollection(metadataCollection, "getLinkingEntities");
            try {
                InstanceGraph results = metadataCollection.getLinkingEntities(userId, startEntityGUID, endEntityGUID, limitResultsByStatus, asOfTime);
                if (results == null) continue;
                combinedRelationshipResults = this.addUniqueRelationships(combinedRelationshipResults, results.getRelationships(), cohortConnector.getServerName(), cohortConnector.getMetadataCollectionId(), "getLinkingEntities");
                combinedEntityResults = this.addUniqueEntities(combinedEntityResults, results.getEntities(), cohortConnector.getServerName(), cohortConnector.getMetadataCollectionId(), "getLinkingEntities");
            }
            catch (RepositoryErrorException error) {
                repositoryErrorException = error;
            }
            catch (PropertyErrorException error) {
                propertyErrorException = error;
            }
            catch (EntityNotKnownException error) {
                entityNotKnownException = error;
            }
            catch (FunctionNotSupportedException error) {
                functionNotSupportedException = error;
            }
            catch (UserNotAuthorizedException error) {
                userNotAuthorizedException = error;
            }
            catch (Throwable error) {
                anotherException = error;
            }
        }
        return this.validatedInstanceGraphResults(this.repositoryName, combinedEntityResults, combinedRelationshipResults, userNotAuthorizedException, propertyErrorException, functionNotSupportedException, entityNotKnownException, repositoryErrorException, anotherException, "getLinkingEntities");
    }

    public InstanceGraph getEntityNeighborhood(String userId, String entityGUID, List<String> entityTypeGUIDs, List<String> relationshipTypeGUIDs, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, int level) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getEntityNeighborhood";
        super.getEntityNeighborhoodParameterValidation(userId, entityGUID, entityTypeGUIDs, relationshipTypeGUIDs, limitResultsByStatus, limitResultsByClassification, asOfTime, level);
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("getEntityNeighborhood");
        Map<String, EntityDetail> combinedEntityResults = new HashMap<String, EntityDetail>();
        Map<String, Relationship> combinedRelationshipResults = new HashMap<String, Relationship>();
        EntityNotKnownException entityNotKnownException = null;
        FunctionNotSupportedException functionNotSupportedException = null;
        PropertyErrorException propertyErrorException = null;
        UserNotAuthorizedException userNotAuthorizedException = null;
        RepositoryErrorException repositoryErrorException = null;
        Throwable anotherException = null;
        for (OMRSRepositoryConnector cohortConnector : cohortConnectors) {
            if (cohortConnector == null) continue;
            OMRSMetadataCollection metadataCollection = cohortConnector.getMetadataCollection();
            this.validateMetadataCollection(metadataCollection, "getEntityNeighborhood");
            try {
                InstanceGraph results = metadataCollection.getEntityNeighborhood(userId, entityGUID, entityTypeGUIDs, relationshipTypeGUIDs, limitResultsByStatus, limitResultsByClassification, asOfTime, level);
                if (results == null) continue;
                combinedRelationshipResults = this.addUniqueRelationships(combinedRelationshipResults, results.getRelationships(), cohortConnector.getServerName(), cohortConnector.getMetadataCollectionId(), "getEntityNeighborhood");
                combinedEntityResults = this.addUniqueEntities(combinedEntityResults, results.getEntities(), cohortConnector.getServerName(), cohortConnector.getMetadataCollectionId(), "getEntityNeighborhood");
            }
            catch (RepositoryErrorException error) {
                repositoryErrorException = error;
            }
            catch (PropertyErrorException error) {
                propertyErrorException = error;
            }
            catch (EntityNotKnownException error) {
                entityNotKnownException = error;
            }
            catch (FunctionNotSupportedException error) {
                functionNotSupportedException = error;
            }
            catch (UserNotAuthorizedException error) {
                userNotAuthorizedException = error;
            }
            catch (Throwable error) {
                anotherException = error;
            }
        }
        return this.validatedInstanceGraphResults(this.repositoryName, combinedEntityResults, combinedRelationshipResults, userNotAuthorizedException, propertyErrorException, functionNotSupportedException, entityNotKnownException, repositoryErrorException, anotherException, "getEntityNeighborhood");
    }

    public List<EntityDetail> getRelatedEntities(String userId, String startEntityGUID, List<String> entityTypeGUIDs, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getRelatedEntities";
        String entityGUIDParameterName = "startEntityGUID";
        String typeGUIDParameterName = "instanceTypes";
        String asOfTimeParameter = "asOfTime";
        String pageSizeParameter = "pageSize";
        this.validateRepositoryConnector("getRelatedEntities");
        this.parentConnector.validateRepositoryIsActive("getRelatedEntities");
        this.repositoryValidator.validateUserId(this.repositoryName, userId, "getRelatedEntities");
        this.repositoryValidator.validateGUID(this.repositoryName, "startEntityGUID", startEntityGUID, "getRelatedEntities");
        this.repositoryValidator.validateAsOfTime(this.repositoryName, "asOfTime", asOfTime, "getRelatedEntities");
        this.repositoryValidator.validatePageSize(this.repositoryName, "pageSize", pageSize, "getRelatedEntities");
        if (entityTypeGUIDs != null) {
            for (String guid : entityTypeGUIDs) {
                this.repositoryValidator.validateTypeGUID(this.repositoryName, "instanceTypes", guid, "getRelatedEntities");
            }
        }
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("getRelatedEntities");
        Map<String, EntityDetail> combinedResults = new HashMap<String, EntityDetail>();
        InvalidParameterException invalidParameterException = null;
        EntityNotKnownException entityNotKnownException = null;
        FunctionNotSupportedException functionNotSupportedException = null;
        TypeErrorException typeErrorException = null;
        PropertyErrorException propertyErrorException = null;
        UserNotAuthorizedException userNotAuthorizedException = null;
        RepositoryErrorException repositoryErrorException = null;
        Throwable anotherException = null;
        for (OMRSRepositoryConnector cohortConnector : cohortConnectors) {
            if (cohortConnector == null) continue;
            OMRSMetadataCollection metadataCollection = cohortConnector.getMetadataCollection();
            this.validateMetadataCollection(metadataCollection, "getRelatedEntities");
            try {
                List results = metadataCollection.getRelatedEntities(userId, startEntityGUID, entityTypeGUIDs, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
                combinedResults = this.addUniqueEntities(combinedResults, results, cohortConnector.getServerName(), cohortConnector.getMetadataCollectionId(), "getRelatedEntities");
            }
            catch (InvalidParameterException error) {
                invalidParameterException = error;
            }
            catch (EntityNotKnownException error) {
                entityNotKnownException = error;
            }
            catch (FunctionNotSupportedException error) {
                functionNotSupportedException = error;
            }
            catch (TypeErrorException error) {
                typeErrorException = error;
            }
            catch (PropertyErrorException error) {
                propertyErrorException = error;
            }
            catch (RepositoryErrorException error) {
                repositoryErrorException = error;
            }
            catch (UserNotAuthorizedException error) {
                userNotAuthorizedException = error;
            }
            catch (Throwable error) {
                anotherException = error;
            }
        }
        if (combinedResults.isEmpty()) {
            this.throwCapturedRepositoryErrorException(repositoryErrorException);
            this.throwCapturedUserNotAuthorizedException(userNotAuthorizedException);
            this.throwCapturedThrowableException(anotherException, "getRelatedEntities");
            this.throwCapturedTypeErrorException(typeErrorException);
            this.throwCapturedPropertyErrorException(propertyErrorException);
            this.throwCapturedInvalidParameterException(invalidParameterException);
            this.throwCapturedFunctionNotSupportedException(functionNotSupportedException);
            this.throwCapturedEntityNotKnownException(entityNotKnownException);
            return null;
        }
        return this.validatedEntityListResults(this.repositoryName, combinedResults, sequencingProperty, sequencingOrder, pageSize, "getRelatedEntities");
    }

    public EntityDetail addEntity(String userId, String entityTypeGUID, InstanceProperties initialProperties, List<Classification> initialClassifications, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, ClassificationErrorException, StatusNotSupportedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "addEntity";
        super.addEntityParameterValidation(userId, entityTypeGUID, initialProperties, initialClassifications, initialStatus, "addEntity");
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("addEntity");
        SequentialFederationControl federationControl = new SequentialFederationControl(userId, cohortConnectors, "addEntity");
        AddEntityExecutor executor = new AddEntityExecutor(userId, entityTypeGUID, initialProperties, initialClassifications, initialStatus, "addEntity");
        federationControl.executeCommand(executor);
        return executor.getNewEntity();
    }

    public EntityDetail addExternalEntity(String userId, String entityTypeGUID, String externalSourceGUID, String externalSourceName, InstanceProperties initialProperties, List<Classification> initialClassifications, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, ClassificationErrorException, StatusNotSupportedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "addExternalEntity";
        this.addExternalEntityParameterValidation(userId, entityTypeGUID, externalSourceGUID, initialProperties, initialClassifications, initialStatus, "addExternalEntity");
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("addExternalEntity");
        SequentialFederationControl federationControl = new SequentialFederationControl(userId, cohortConnectors, "addExternalEntity");
        AddEntityExecutor executor = new AddEntityExecutor(userId, entityTypeGUID, externalSourceGUID, externalSourceName, initialProperties, initialClassifications, initialStatus, "addExternalEntity");
        federationControl.executeCommand(executor);
        return executor.getNewEntity();
    }

    public void addEntityProxy(String userId, EntityProxy entityProxy) throws FunctionNotSupportedException {
        String methodName = "addEntityProxy";
        this.throwNotEnterpriseFunction("addEntityProxy");
    }

    public EntityDetail updateEntityStatus(String userId, String entityGUID, InstanceStatus newStatus) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, StatusNotSupportedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "updateEntityStatus";
        super.updateInstanceStatusParameterValidation(userId, entityGUID, newStatus, "updateEntityStatus");
        EntitySummary entity = this.getEntitySummary(userId, entityGUID);
        OMRSMetadataCollection metadataCollection = this.enterpriseParentConnector.getHomeMetadataCollection((InstanceHeader)entity, "updateEntityStatus");
        if (metadataCollection != null) {
            return metadataCollection.updateEntityStatus(userId, entityGUID, newStatus);
        }
        return null;
    }

    public EntityDetail updateEntityProperties(String userId, String entityGUID, InstanceProperties properties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "updateEntityProperties";
        this.updateInstancePropertiesPropertyValidation(userId, entityGUID, properties, "updateEntityProperties");
        EntitySummary entity = this.getEntitySummary(userId, entityGUID);
        OMRSMetadataCollection metadataCollection = this.enterpriseParentConnector.getHomeMetadataCollection((InstanceHeader)entity, "updateEntityProperties");
        if (metadataCollection != null) {
            return metadataCollection.updateEntityProperties(userId, entityGUID, properties);
        }
        return null;
    }

    public EntityDetail undoEntityUpdate(String userId, String entityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "undoEntityUpdate";
        String parameterName = "entityGUID";
        super.manageInstanceParameterValidation(userId, entityGUID, "entityGUID", "undoEntityUpdate");
        EntitySummary entity = this.getEntitySummary(userId, entityGUID);
        OMRSMetadataCollection metadataCollection = this.enterpriseParentConnector.getHomeMetadataCollection((InstanceHeader)entity, "undoEntityUpdate");
        if (metadataCollection != null) {
            return metadataCollection.undoEntityUpdate(userId, entityGUID);
        }
        return null;
    }

    public EntityDetail deleteEntity(String userId, String typeDefGUID, String typeDefName, String obsoleteEntityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "deleteEntity";
        String parameterName = "obsoleteEntityGUID";
        super.manageInstanceParameterValidation(userId, typeDefGUID, typeDefName, obsoleteEntityGUID, "obsoleteEntityGUID", "deleteEntity");
        EntitySummary entity = this.getEntitySummary(userId, obsoleteEntityGUID);
        OMRSMetadataCollection metadataCollection = this.enterpriseParentConnector.getHomeMetadataCollection((InstanceHeader)entity, "deleteEntity");
        if (metadataCollection != null) {
            return metadataCollection.deleteEntity(userId, typeDefGUID, typeDefName, obsoleteEntityGUID);
        }
        return null;
    }

    public void purgeEntity(String userId, String typeDefGUID, String typeDefName, String deletedEntityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityNotDeletedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "purgeEntity";
        String parameterName = "deletedEntityGUID";
        this.manageInstanceParameterValidation(userId, typeDefGUID, typeDefName, deletedEntityGUID, "deletedEntityGUID", "purgeEntity");
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("purgeEntity");
        SequentialFederationControl federationControl = new SequentialFederationControl(userId, cohortConnectors, "purgeEntity");
        PurgeEntityExecutor executor = new PurgeEntityExecutor(userId, typeDefGUID, typeDefName, deletedEntityGUID, "purgeEntity");
        federationControl.executeCommand(executor);
        executor.getResult();
    }

    public EntityDetail restoreEntity(String userId, String deletedEntityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityNotDeletedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "restoreEntity";
        String parameterName = "deletedEntityGUID";
        super.manageInstanceParameterValidation(userId, deletedEntityGUID, "deletedEntityGUID", "restoreEntity");
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("restoreEntity");
        SequentialFederationControl federationControl = new SequentialFederationControl(userId, cohortConnectors, "restoreEntity");
        RestoreEntityExecutor executor = new RestoreEntityExecutor(userId, deletedEntityGUID, "restoreEntity");
        federationControl.executeCommand(executor);
        return executor.getRestoredEntity();
    }

    public EntityDetail classifyEntity(String userId, String entityGUID, String classificationName, InstanceProperties classificationProperties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "classifyEntity";
        this.classifyEntityParameterValidation(userId, entityGUID, classificationName, classificationProperties, "classifyEntity");
        EntitySummary entity = this.getEntitySummary(userId, entityGUID);
        OMRSMetadataCollection metadataCollection = this.enterpriseParentConnector.getHomeMetadataCollection((InstanceHeader)entity, "classifyEntity");
        if (metadataCollection != null) {
            return metadataCollection.classifyEntity(userId, entityGUID, classificationName, classificationProperties);
        }
        return null;
    }

    public EntityDetail declassifyEntity(String userId, String entityGUID, String classificationName) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "declassifyEntity";
        super.declassifyEntityParameterValidation(userId, entityGUID, classificationName);
        EntitySummary entity = this.getEntitySummary(userId, entityGUID);
        OMRSMetadataCollection metadataCollection = this.enterpriseParentConnector.getHomeMetadataCollection((InstanceHeader)entity, "declassifyEntity");
        if (metadataCollection != null) {
            return metadataCollection.declassifyEntity(userId, entityGUID, classificationName);
        }
        return null;
    }

    public EntityDetail updateEntityClassification(String userId, String entityGUID, String classificationName, InstanceProperties properties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "updateEntityClassification";
        this.classifyEntityParameterValidation(userId, entityGUID, classificationName, properties, "updateEntityClassification");
        EntitySummary entity = this.getEntitySummary(userId, entityGUID);
        OMRSMetadataCollection metadataCollection = this.enterpriseParentConnector.getHomeMetadataCollection((InstanceHeader)entity, "updateEntityClassification");
        if (metadataCollection != null) {
            return metadataCollection.updateEntityClassification(userId, entityGUID, classificationName, properties);
        }
        return null;
    }

    public Relationship addRelationship(String userId, String relationshipTypeGUID, InstanceProperties initialProperties, String entityOneGUID, String entityTwoGUID, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, EntityNotKnownException, StatusNotSupportedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "addRelationship";
        super.addRelationshipParameterValidation(userId, relationshipTypeGUID, initialProperties, entityOneGUID, entityTwoGUID, initialStatus, "addRelationship");
        EntityProxy entityOneProxy = this.getEntityProxy(userId, entityOneGUID, "addRelationship");
        EntityProxy entityTwoProxy = this.getEntityProxy(userId, entityTwoGUID, "addRelationship");
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("addRelationship");
        SequentialFederationControl federationControl = new SequentialFederationControl(userId, cohortConnectors, "addRelationship");
        AddRelationshipExecutor executor = new AddRelationshipExecutor(userId, relationshipTypeGUID, initialProperties, entityOneProxy, entityTwoProxy, initialStatus, "addRelationship");
        federationControl.executeCommand(executor);
        return executor.getNewRelationship();
    }

    public Relationship addExternalRelationship(String userId, String relationshipTypeGUID, String externalSourceGUID, String externalSourceName, InstanceProperties initialProperties, String entityOneGUID, String entityTwoGUID, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, EntityNotKnownException, StatusNotSupportedException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "addExternalRelationship";
        this.addExternalRelationshipParameterValidation(userId, relationshipTypeGUID, externalSourceGUID, initialProperties, entityOneGUID, entityTwoGUID, initialStatus, "addExternalRelationship");
        EntityProxy entityOneProxy = this.getEntityProxy(userId, entityOneGUID, "addExternalRelationship");
        EntityProxy entityTwoProxy = this.getEntityProxy(userId, entityTwoGUID, "addExternalRelationship");
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("addExternalRelationship");
        SequentialFederationControl federationControl = new SequentialFederationControl(userId, cohortConnectors, "addExternalRelationship");
        AddRelationshipExecutor executor = new AddRelationshipExecutor(userId, relationshipTypeGUID, externalSourceGUID, externalSourceName, initialProperties, entityOneProxy, entityTwoProxy, initialStatus, "addExternalRelationship");
        federationControl.executeCommand(executor);
        return executor.getNewRelationship();
    }

    public Relationship updateRelationshipStatus(String userId, String relationshipGUID, InstanceStatus newStatus) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, StatusNotSupportedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "updateRelationshipStatus";
        super.updateInstanceStatusParameterValidation(userId, relationshipGUID, newStatus, "updateRelationshipStatus");
        Relationship relationship = this.getRelationship(userId, relationshipGUID);
        OMRSMetadataCollection metadataCollection = this.enterpriseParentConnector.getHomeMetadataCollection((InstanceHeader)relationship, "updateRelationshipStatus");
        if (metadataCollection != null) {
            return metadataCollection.updateRelationshipStatus(userId, relationshipGUID, newStatus);
        }
        return null;
    }

    public Relationship updateRelationshipProperties(String userId, String relationshipGUID, InstanceProperties properties) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "updateRelationshipProperties";
        super.updateInstancePropertiesPropertyValidation(userId, relationshipGUID, properties, "updateRelationshipProperties");
        Relationship relationship = this.getRelationship(userId, relationshipGUID);
        OMRSMetadataCollection metadataCollection = this.enterpriseParentConnector.getHomeMetadataCollection((InstanceHeader)relationship, "updateRelationshipProperties");
        if (metadataCollection != null) {
            return metadataCollection.updateRelationshipProperties(userId, relationshipGUID, properties);
        }
        return null;
    }

    public Relationship undoRelationshipUpdate(String userId, String relationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "undoRelationshipUpdate";
        String parameterName = "relationshipGUID";
        super.manageInstanceParameterValidation(userId, relationshipGUID, "relationshipGUID", "undoRelationshipUpdate");
        Relationship relationship = this.getRelationship(userId, relationshipGUID);
        OMRSMetadataCollection metadataCollection = this.enterpriseParentConnector.getHomeMetadataCollection((InstanceHeader)relationship, "undoRelationshipUpdate");
        if (metadataCollection != null) {
            return metadataCollection.undoRelationshipUpdate(userId, relationshipGUID);
        }
        return null;
    }

    public Relationship deleteRelationship(String userId, String typeDefGUID, String typeDefName, String obsoleteRelationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "deleteRelationship";
        String parameterName = "obsoleteRelationshipGUID";
        this.manageInstanceParameterValidation(userId, typeDefGUID, typeDefName, obsoleteRelationshipGUID, "obsoleteRelationshipGUID", "deleteRelationship");
        Relationship relationship = this.getRelationship(userId, obsoleteRelationshipGUID);
        OMRSMetadataCollection metadataCollection = this.enterpriseParentConnector.getHomeMetadataCollection((InstanceHeader)relationship, "deleteRelationship");
        if (metadataCollection != null) {
            return metadataCollection.deleteRelationship(userId, typeDefGUID, typeDefName, obsoleteRelationshipGUID);
        }
        return null;
    }

    public void purgeRelationship(String userId, String typeDefGUID, String typeDefName, String deletedRelationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, RelationshipNotDeletedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "purgeRelationship";
        String parameterName = "deletedRelationshipGUID";
        this.manageInstanceParameterValidation(userId, typeDefGUID, typeDefName, deletedRelationshipGUID, "deletedRelationshipGUID", "purgeRelationship");
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("purgeRelationship");
        SequentialFederationControl federationControl = new SequentialFederationControl(userId, cohortConnectors, "purgeRelationship");
        PurgeRelationshipExecutor executor = new PurgeRelationshipExecutor(userId, typeDefGUID, typeDefName, deletedRelationshipGUID, "purgeRelationship");
        federationControl.executeCommand(executor);
        executor.getResult();
    }

    public Relationship restoreRelationship(String userId, String deletedRelationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, RelationshipNotDeletedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "restoreRelationship";
        String parameterName = "deletedRelationshipGUID";
        this.manageInstanceParameterValidation(userId, deletedRelationshipGUID, "deletedRelationshipGUID", "restoreRelationship");
        List<OMRSRepositoryConnector> cohortConnectors = this.enterpriseParentConnector.getCohortConnectors("restoreRelationship");
        SequentialFederationControl federationControl = new SequentialFederationControl(userId, cohortConnectors, "restoreRelationship");
        RestoreRelationshipExecutor executor = new RestoreRelationshipExecutor(userId, deletedRelationshipGUID, "restoreRelationship");
        federationControl.executeCommand(executor);
        return executor.getRestoredRelationship();
    }

    public EntityDetail reIdentifyEntity(String userId, String typeDefGUID, String typeDefName, String entityGUID, String newEntityGUID) throws FunctionNotSupportedException {
        String methodName = "reIdentifyEntity";
        this.throwNotEnterpriseFunction("reIdentifyEntity");
        return null;
    }

    public EntityDetail reTypeEntity(String userId, String entityGUID, TypeDefSummary currentTypeDefSummary, TypeDefSummary newTypeDefSummary) throws FunctionNotSupportedException {
        String methodName = "reTypeEntity";
        this.throwNotEnterpriseFunction("reTypeEntity");
        return null;
    }

    public EntityDetail reHomeEntity(String userId, String entityGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId, String newHomeMetadataCollectionId, String newHomeMetadataCollectionName) throws FunctionNotSupportedException {
        String methodName = "reHomeEntity";
        this.throwNotEnterpriseFunction("reHomeEntity");
        return null;
    }

    public Relationship reIdentifyRelationship(String userId, String typeDefGUID, String typeDefName, String relationshipGUID, String newRelationshipGUID) throws FunctionNotSupportedException {
        String methodName = "reIdentifyRelationship";
        this.throwNotEnterpriseFunction("reIdentifyRelationship");
        return null;
    }

    public Relationship reTypeRelationship(String userId, String relationshipGUID, TypeDefSummary currentTypeDefSummary, TypeDefSummary newTypeDefSummary) throws FunctionNotSupportedException {
        String methodName = "reTypeRelationship";
        this.throwNotEnterpriseFunction("reTypeRelationship");
        return null;
    }

    public Relationship reHomeRelationship(String userId, String relationshipGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId, String newHomeMetadataCollectionId, String newHomeMetadataCollectionName) throws FunctionNotSupportedException {
        String methodName = "reHomeRelationship";
        this.throwNotEnterpriseFunction("reHomeRelationship");
        return null;
    }

    public void saveEntityReferenceCopy(String userId, EntityDetail entity) throws FunctionNotSupportedException {
        String methodName = "saveEntityReferenceCopy";
        this.throwNotEnterpriseFunction("saveEntityReferenceCopy");
    }

    public void deleteEntityReferenceCopy(String userId, EntityDetail entity) throws FunctionNotSupportedException {
        String methodName = "deleteEntityReferenceCopy";
        this.throwNotEnterpriseFunction("deleteEntityReferenceCopy");
    }

    public void purgeEntityReferenceCopy(String userId, EntityDetail entity) throws FunctionNotSupportedException {
        String methodName = "purgeEntityReferenceCopy";
        this.throwNotEnterpriseFunction("purgeEntityReferenceCopy");
    }

    public void purgeEntityReferenceCopy(String userId, String entityGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId) throws FunctionNotSupportedException {
        String methodName = "purgeEntityReferenceCopy";
        this.throwNotEnterpriseFunction("purgeEntityReferenceCopy");
    }

    public void refreshEntityReferenceCopy(String userId, String entityGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId) throws FunctionNotSupportedException {
        String methodName = "refreshEntityReferenceCopy";
        this.throwNotEnterpriseFunction("refreshEntityReferenceCopy");
    }

    public void saveRelationshipReferenceCopy(String userId, Relationship relationship) throws FunctionNotSupportedException {
        String methodName = "saveRelationshipReferenceCopy";
        this.throwNotEnterpriseFunction("saveRelationshipReferenceCopy");
    }

    public void deleteRelationshipReferenceCopy(String userId, Relationship relationship) throws FunctionNotSupportedException {
        String methodName = "deleteRelationshipReferenceCopy";
        this.throwNotEnterpriseFunction("deleteRelationshipReferenceCopy");
    }

    public void purgeRelationshipReferenceCopy(String userId, Relationship relationship) throws FunctionNotSupportedException {
        String methodName = "purgeRelationshipReferenceCopy";
        this.throwNotEnterpriseFunction("purgeRelationshipReferenceCopy");
    }

    public void purgeRelationshipReferenceCopy(String userId, String relationshipGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId) throws FunctionNotSupportedException {
        String methodName = "purgeRelationshipReferenceCopy";
        this.throwNotEnterpriseFunction("purgeRelationshipReferenceCopy");
    }

    public void refreshRelationshipReferenceCopy(String userId, String relationshipGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId) throws FunctionNotSupportedException {
        String methodName = "refreshRelationshipReferenceCopy";
        this.throwNotEnterpriseFunction("refreshRelationshipReferenceCopy");
    }

    private Map<String, EntityDetail> addUniqueEntities(Map<String, EntityDetail> accumulatedResults, List<EntityDetail> results, String serverName, String metadataCollectionId, String methodName) {
        Map<String, EntityDetail> combinedResults = new HashMap<String, EntityDetail>(accumulatedResults);
        if (results != null) {
            for (EntityDetail returnedEntity : results) {
                combinedResults = this.addUniqueEntity(combinedResults, returnedEntity, serverName, metadataCollectionId, methodName);
            }
        }
        return combinedResults;
    }

    private Map<String, EntityDetail> addUniqueEntity(Map<String, EntityDetail> accumulatedResults, EntityDetail entity, String serverName, String metadataCollectionId, String methodName) {
        HashMap<String, EntityDetail> combinedResults = new HashMap<String, EntityDetail>(accumulatedResults);
        if (entity != null) {
            EntityDetail entityDetail = combinedResults.put(entity.getGUID(), entity);
        }
        return combinedResults;
    }

    private Map<String, Relationship> addUniqueRelationships(Map<String, Relationship> accumulatedResults, List<Relationship> results, String serverName, String metadataCollectionId, String methodName) {
        Map<String, Relationship> combinedResults = new HashMap<String, Relationship>(accumulatedResults);
        if (results != null) {
            for (Relationship returnedRelationship : results) {
                combinedResults = this.addUniqueRelationship(combinedResults, returnedRelationship, serverName, metadataCollectionId, methodName);
            }
        }
        return combinedResults;
    }

    private Map<String, Relationship> addUniqueRelationship(Map<String, Relationship> accumulatedResults, Relationship relationship, String serverName, String metadataCollectionId, String methodName) {
        HashMap<String, Relationship> combinedResults = new HashMap<String, Relationship>(accumulatedResults);
        if (relationship != null) {
            Relationship relationship2 = combinedResults.put(relationship.getGUID(), relationship);
        }
        return combinedResults;
    }

    private void validateMetadataCollection(OMRSMetadataCollection cohortMetadataCollection, String methodName) throws RepositoryErrorException {
        if (cohortMetadataCollection == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_ENTERPRISE_METADATA_COLLECTION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[0]);
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    private void throwNotEnterpriseFunction(String methodName) throws FunctionNotSupportedException {
        OMRSErrorCode errorCode = OMRSErrorCode.ENTERPRISE_NOT_SUPPORTED;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
        throw new FunctionNotSupportedException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    private void throwCapturedInvalidParameterException(InvalidParameterException exception) throws InvalidParameterException {
        if (exception != null) {
            throw exception;
        }
    }

    private void throwCapturedTypeErrorException(TypeErrorException exception) throws TypeErrorException {
        if (exception != null) {
            throw exception;
        }
    }

    private void throwCapturedPropertyErrorException(PropertyErrorException exception) throws PropertyErrorException {
        if (exception != null) {
            throw exception;
        }
    }

    private void throwCapturedEntityNotKnownException(EntityNotKnownException exception) throws EntityNotKnownException {
        if (exception != null) {
            throw exception;
        }
    }

    private void throwCapturedFunctionNotSupportedException(FunctionNotSupportedException exception) throws FunctionNotSupportedException {
        if (exception != null) {
            throw exception;
        }
    }

    private void throwCapturedUserNotAuthorizedException(UserNotAuthorizedException exception) throws UserNotAuthorizedException {
        if (exception != null) {
            throw exception;
        }
    }

    private void throwCapturedRepositoryErrorException(RepositoryErrorException exception) throws RepositoryErrorException {
        if (exception != null) {
            throw exception;
        }
    }

    private void throwCapturedThrowableException(Throwable exception, String methodName) throws RepositoryErrorException {
        if (exception != null) {
            OMRSErrorCode errorCode = OMRSErrorCode.UNEXPECTED_EXCEPTION_FROM_COHORT;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName, exception.getMessage()});
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    private List<EntityDetail> validatedEntityListResults(String repositoryName, Map<String, EntityDetail> combinedResults, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize, String methodName) throws RepositoryErrorException {
        if (combinedResults.isEmpty()) {
            return null;
        }
        ArrayList<EntityDetail> actualResults = new ArrayList<EntityDetail>(combinedResults.values());
        return actualResults;
    }

    private InstanceGraph validatedInstanceGraphResults(String repositoryName, Map<String, EntityDetail> accumulatedEntityResults, Map<String, Relationship> accumulatedRelationshipResults, UserNotAuthorizedException userNotAuthorizedException, PropertyErrorException propertyErrorException, FunctionNotSupportedException functionNotSupportedException, EntityNotKnownException entityNotKnownException, RepositoryErrorException repositoryErrorException, Throwable anotherException, String methodName) throws UserNotAuthorizedException, PropertyErrorException, FunctionNotSupportedException, EntityNotKnownException, RepositoryErrorException {
        int resultCount = accumulatedEntityResults.size() + accumulatedRelationshipResults.size();
        if (resultCount > 0) {
            InstanceGraph instanceGraph = new InstanceGraph();
            ArrayList<EntityDetail> entityDetails = new ArrayList<EntityDetail>(accumulatedEntityResults.values());
            ArrayList<Relationship> relationships = new ArrayList<Relationship>(accumulatedRelationshipResults.values());
            instanceGraph.setEntities(entityDetails);
            instanceGraph.setRelationships(relationships);
            return instanceGraph;
        }
        this.throwCapturedUserNotAuthorizedException(userNotAuthorizedException);
        this.throwCapturedRepositoryErrorException(repositoryErrorException);
        this.throwCapturedPropertyErrorException(propertyErrorException);
        this.throwCapturedThrowableException(anotherException, methodName);
        this.throwCapturedFunctionNotSupportedException(functionNotSupportedException);
        this.throwCapturedEntityNotKnownException(entityNotKnownException);
        return null;
    }
}

