/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.control;

import java.util.List;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.control.FederationControl;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.RepositoryExecutor;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;

public abstract class FederationControlBase
implements FederationControl {
    protected String userId;
    protected List<OMRSRepositoryConnector> cohortConnectors;
    protected String methodName;

    public FederationControlBase(String userId, List<OMRSRepositoryConnector> cohortConnectors, String methodName) {
        this.userId = userId;
        this.cohortConnectors = cohortConnectors;
        this.methodName = methodName;
    }

    @Override
    public abstract void executeCommand(RepositoryExecutor var1) throws RepositoryErrorException;

    String validateMetadataCollection(OMRSMetadataCollection cohortMetadataCollection, String methodName) throws RepositoryErrorException {
        if (cohortMetadataCollection == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_ENTERPRISE_METADATA_COLLECTION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[0]);
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        try {
            return cohortMetadataCollection.getMetadataCollectionId(this.userId);
        }
        catch (RepositoryErrorException error) {
            return null;
        }
    }
}

