/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.EnterpriseOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.accumulators.RelationshipAccumulator;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.CloneableRepositoryExecutor;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.PageableRepositoryExecutorBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;

public class FindRelationshipsByPropertyExecutor
extends PageableRepositoryExecutorBase {
    private InstanceProperties matchProperties;
    private MatchCriteria matchCriteria;
    private RelationshipAccumulator accumulator;

    public FindRelationshipsByPropertyExecutor(String userId, String relationshipTypeGUID, InstanceProperties matchProperties, MatchCriteria matchCriteria, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize, String localMetadataCollectionId, OMRSAuditLog auditLog, OMRSRepositoryValidator repositoryValidator, String methodName) {
        this(userId, relationshipTypeGUID, matchProperties, matchCriteria, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize, new RelationshipAccumulator(localMetadataCollectionId, auditLog, repositoryValidator), methodName);
    }

    private FindRelationshipsByPropertyExecutor(String userId, String relationshipTypeGUID, InstanceProperties matchProperties, MatchCriteria matchCriteria, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize, RelationshipAccumulator accumulator, String methodName) {
        super(userId, relationshipTypeGUID, fromRelationshipElement, limitResultsByStatus, sequencingProperty, sequencingOrder, pageSize, asOfTime, accumulator, methodName);
        this.matchProperties = matchProperties;
        this.matchCriteria = matchCriteria;
        this.accumulator = accumulator;
    }

    @Override
    public CloneableRepositoryExecutor getClone() {
        return new FindRelationshipsByPropertyExecutor(this.userId, this.instanceTypeGUID, this.matchProperties, this.matchCriteria, this.startingElement, this.limitResultsByStatus, this.asOfTime, this.sequencingProperty, this.sequencingOrder, this.pageSize, this.accumulator, this.methodName);
    }

    @Override
    public boolean issueRequestToRepository(String metadataCollectionId, OMRSMetadataCollection metadataCollection) {
        try {
            List results = metadataCollection.findRelationshipsByProperty(this.userId, this.instanceTypeGUID, this.matchProperties, this.matchCriteria, this.startingElement, this.limitResultsByStatus, this.asOfTime, this.sequencingProperty, this.sequencingOrder, this.pageSize);
            this.accumulator.addRelationships(results, metadataCollectionId);
        }
        catch (InvalidParameterException error) {
            this.accumulator.captureException(metadataCollectionId, error);
        }
        catch (FunctionNotSupportedException error) {
            this.accumulator.captureException(metadataCollectionId, error);
        }
        catch (PropertyErrorException error) {
            this.accumulator.captureException(metadataCollectionId, error);
        }
        catch (RepositoryErrorException error) {
            this.accumulator.captureException(metadataCollectionId, error);
        }
        catch (UserNotAuthorizedException error) {
            this.accumulator.captureException(metadataCollectionId, error);
        }
        catch (TypeErrorException error) {
            this.accumulator.captureException(metadataCollectionId, error);
        }
        catch (PagingErrorException error) {
            this.accumulator.captureException(metadataCollectionId, error);
        }
        catch (Throwable error) {
            this.accumulator.captureGenericException(metadataCollectionId, error);
        }
        return true;
    }

    public List<Relationship> getResults(EnterpriseOMRSRepositoryConnector repositoryConnector) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        if (this.accumulator.resultsReturned()) {
            return this.accumulator.getResults(repositoryConnector);
        }
        this.handleCommonPagingRequestExceptions();
        return null;
    }
}

