/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors;

import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.accumulators.MaintenanceAccumulator;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.RepositoryExecutorBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;

public class PurgeRelationshipExecutor
extends RepositoryExecutorBase {
    private String relationshipGUID;
    private String typeDefGUID;
    private String typeDefName;
    private boolean relationshipDeleted = false;
    private MaintenanceAccumulator accumulator = new MaintenanceAccumulator();

    public PurgeRelationshipExecutor(String userId, String typeDefGUID, String typeDefName, String relationshipGUID, String methodName) {
        super(userId, methodName);
        this.relationshipGUID = relationshipGUID;
        this.typeDefGUID = typeDefGUID;
        this.typeDefName = typeDefName;
    }

    @Override
    public boolean issueRequestToRepository(String metadataCollectionId, OMRSMetadataCollection metadataCollection) {
        try {
            metadataCollection.purgeRelationship(this.userId, this.typeDefGUID, this.typeDefName, this.relationshipGUID);
            this.relationshipDeleted = true;
        }
        catch (InvalidParameterException error) {
            this.accumulator.captureException(error);
        }
        catch (RelationshipNotKnownException error) {
            this.accumulator.captureException(error);
        }
        catch (RelationshipNotDeletedException error) {
            this.accumulator.captureException(error);
        }
        catch (RepositoryErrorException error) {
            this.accumulator.captureException(error);
        }
        catch (FunctionNotSupportedException error) {
            this.accumulator.captureException(error);
        }
        catch (UserNotAuthorizedException error) {
            this.accumulator.captureException(error);
        }
        catch (Throwable error) {
            this.accumulator.captureGenericException(error);
        }
        return this.relationshipDeleted;
    }

    public void getResult() throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, RelationshipNotDeletedException, FunctionNotSupportedException, UserNotAuthorizedException {
        if (this.relationshipDeleted) {
            return;
        }
        this.accumulator.throwCapturedRelationshipNotDeletedException();
        this.accumulator.throwCapturedRepositoryErrorException();
        this.accumulator.throwCapturedUserNotAuthorizedException();
        this.accumulator.throwCapturedThrowableException(this.methodName);
        this.accumulator.throwCapturedRelationshipNotKnownException();
        this.accumulator.throwCapturedFunctionNotSupportedException();
        this.accumulator.throwCapturedInvalidParameterException();
    }
}

