/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors;

import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.accumulators.MaintenanceAccumulator;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.executors.RepositoryExecutorBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidTypeDefException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;

public class VerifyAttributeTypeDefExecutor
extends RepositoryExecutorBase {
    private AttributeTypeDef attributeTypeDef;
    private boolean result = false;
    private boolean resultSet = false;
    private MaintenanceAccumulator accumulator = new MaintenanceAccumulator();

    public VerifyAttributeTypeDefExecutor(String userId, AttributeTypeDef attributeTypeDef, String methodName) {
        super(userId, methodName);
        this.attributeTypeDef = attributeTypeDef;
    }

    @Override
    public boolean issueRequestToRepository(String metadataCollectionId, OMRSMetadataCollection metadataCollection) {
        try {
            this.result = metadataCollection.verifyAttributeTypeDef(this.userId, this.attributeTypeDef);
            this.resultSet = true;
        }
        catch (TypeDefNotSupportedException error) {
            this.accumulator.captureException(error);
        }
        catch (InvalidTypeDefException error) {
            this.accumulator.captureException(error);
        }
        catch (InvalidParameterException error) {
            this.accumulator.captureException(error);
        }
        catch (TypeDefConflictException error) {
            this.accumulator.captureException(error);
            this.resultSet = true;
        }
        catch (RepositoryErrorException error) {
            this.accumulator.captureException(error);
        }
        catch (UserNotAuthorizedException error) {
            this.accumulator.captureException(error);
        }
        catch (Throwable error) {
            this.accumulator.captureGenericException(error);
        }
        return this.resultSet;
    }

    public boolean getResult() throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefConflictException, InvalidTypeDefException, UserNotAuthorizedException {
        this.accumulator.throwCapturedTypeDefConflictException();
        if (this.resultSet) {
            return this.result;
        }
        this.accumulator.throwCapturedRepositoryErrorException();
        this.accumulator.throwCapturedUserNotAuthorizedException();
        this.accumulator.throwCapturedThrowableException(this.methodName);
        this.accumulator.throwCapturedTypeDefNotSupportedException();
        this.accumulator.throwCapturedInvalidTypeDefException();
        this.accumulator.throwCapturedInvalidParameterException();
        return false;
    }
}

