/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.localrepository.repositoryconnector;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollectionBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OpenMetadataRepositorySecurity;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceGraph;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefGallery;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryeventmapper.OMRSRepositoryEventProcessor;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.HomeEntityException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.HomeRelationshipException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidEntityException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidRelationshipException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidTypeDefException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PatchErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.StatusNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefInUseException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.localrepository.repositoryconnector.LocalOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.localrepository.repositorycontentmanager.OMRSTypeDefManager;

public class LocalOMRSMetadataCollection
extends OMRSMetadataCollectionBase {
    private OMRSMetadataCollection realMetadataCollection;
    private String localServerName;
    private String localServerType;
    private String localOrganizationName;
    private boolean produceEventsForRealConnector;
    private OMRSRepositoryEventProcessor outboundRepositoryEventProcessor;
    private OMRSTypeDefManager localTypeDefManager;

    LocalOMRSMetadataCollection(LocalOMRSRepositoryConnector parentConnector, String repositoryName, OMRSRepositoryHelper repositoryHelper, OMRSRepositoryValidator repositoryValidator, String metadataCollectionId, String localServerName, String localServerType, String localOrganizationName, OMRSMetadataCollection realMetadataCollection, OMRSRepositoryEventProcessor outboundRepositoryEventProcessor, boolean produceEventsForRealConnector, OMRSTypeDefManager typeDefManager) {
        super((OMRSRepositoryConnector)parentConnector, repositoryName, repositoryHelper, repositoryValidator, metadataCollectionId);
        if (realMetadataCollection == null) {
            String actionDescription = "Local OMRS Metadata Collection Constructor";
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_LOCAL_METADATA_COLLECTION;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[0]);
            throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "Local OMRS Metadata Collection Constructor", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        this.realMetadataCollection = realMetadataCollection;
        this.localServerName = localServerName;
        this.localServerType = localServerType;
        this.localOrganizationName = localOrganizationName;
        this.produceEventsForRealConnector = produceEventsForRealConnector;
        this.outboundRepositoryEventProcessor = outboundRepositoryEventProcessor;
        this.localTypeDefManager = typeDefManager;
    }

    public void setSecurityVerifier(OpenMetadataServerSecurityVerifier securityVerifier) {
        super.setSecurityVerifier((OpenMetadataRepositorySecurity)securityVerifier);
        if (securityVerifier != null && this.realMetadataCollection != null) {
            this.realMetadataCollection.setSecurityVerifier((OpenMetadataRepositorySecurity)securityVerifier);
        }
    }

    public TypeDefGallery getAllTypes(String userId) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "getAllTypes";
        super.basicRequestValidation(userId, "getAllTypes");
        return this.realMetadataCollection.getAllTypes(userId);
    }

    public TypeDefGallery findTypesByName(String userId, String name) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "findTypesByName";
        String nameParameterName = "name";
        super.typeNameParameterValidation(userId, name, "name", "findTypesByName");
        return this.realMetadataCollection.findTypesByName(userId, name);
    }

    public List<TypeDef> findTypeDefsByCategory(String userId, TypeDefCategory category) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "findTypeDefsByCategory";
        String categoryParameterName = "category";
        super.typeDefCategoryParameterValidation(userId, category, "category", "findTypeDefsByCategory");
        return this.realMetadataCollection.findTypeDefsByCategory(userId, category);
    }

    public List<AttributeTypeDef> findAttributeTypeDefsByCategory(String userId, AttributeTypeDefCategory category) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "findAttributeTypeDefsByCategory";
        String categoryParameterName = "category";
        super.attributeTypeDefCategoryParameterValidation(userId, category, "category", "findAttributeTypeDefsByCategory");
        return this.realMetadataCollection.findAttributeTypeDefsByCategory(userId, category);
    }

    public List<TypeDef> findTypeDefsByProperty(String userId, TypeDefProperties matchCriteria) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "findTypeDefsByProperty";
        String matchCriteriaParameterName = "matchCriteria";
        super.typeDefPropertyParameterValidation(userId, matchCriteria, "matchCriteria", "findTypeDefsByProperty");
        return this.realMetadataCollection.findTypeDefsByProperty(userId, matchCriteria);
    }

    public List<TypeDef> findTypesByExternalID(String userId, String standard, String organization, String identifier) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "findTypesByExternalID";
        super.typeDefExternalIDParameterValidation(userId, standard, organization, identifier, "findTypesByExternalID");
        return this.realMetadataCollection.findTypesByExternalID(userId, standard, organization, identifier);
    }

    public List<TypeDef> searchForTypeDefs(String userId, String searchCriteria) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "searchForTypeDefs";
        String searchCriteriaParameterName = "searchCriteria";
        super.typeDefSearchParameterValidation(userId, searchCriteria, "searchCriteria", "searchForTypeDefs");
        return this.realMetadataCollection.searchForTypeDefs(userId, searchCriteria);
    }

    public TypeDef getTypeDefByGUID(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException {
        String methodName = "getTypeDefByGUID";
        String guidParameterName = "guid";
        super.typeGUIDParameterValidation(userId, guid, "guid", "getTypeDefByGUID");
        return this.realMetadataCollection.getTypeDefByGUID(userId, guid);
    }

    public AttributeTypeDef getAttributeTypeDefByGUID(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException {
        String methodName = "getAttributeTypeDefByGUID";
        String guidParameterName = "guid";
        super.typeGUIDParameterValidation(userId, guid, "guid", "getAttributeTypeDefByGUID");
        return this.realMetadataCollection.getAttributeTypeDefByGUID(userId, guid);
    }

    public TypeDef getTypeDefByName(String userId, String name) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException {
        String methodName = "getTypeDefByName";
        String nameParameterName = "name";
        super.typeNameParameterValidation(userId, name, "name", "getTypeDefByName");
        return this.realMetadataCollection.getTypeDefByName(userId, name);
    }

    public AttributeTypeDef getAttributeTypeDefByName(String userId, String name) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException {
        String methodName = "getAttributeTypeDefByName";
        String nameParameterName = "name";
        super.typeNameParameterValidation(userId, name, "name", "getAttributeTypeDefByName");
        return this.realMetadataCollection.getAttributeTypeDefByName(userId, name);
    }

    public void addTypeDef(String userId, TypeDef newTypeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefKnownException, TypeDefConflictException, InvalidTypeDefException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "addTypeDef";
        String typeDefParameterName = "newTypeDef";
        super.newTypeDefParameterValidation(userId, newTypeDef, "newTypeDef", "addTypeDef");
        this.realMetadataCollection.addTypeDef(userId, newTypeDef);
        if (this.localTypeDefManager != null) {
            this.localTypeDefManager.addTypeDef(this.repositoryName, newTypeDef);
        }
        if (this.produceEventsForRealConnector) {
            this.outboundRepositoryEventProcessor.processNewTypeDefEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, newTypeDef);
        }
    }

    public void addAttributeTypeDef(String userId, AttributeTypeDef newAttributeTypeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefKnownException, TypeDefConflictException, InvalidTypeDefException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "addAttributeTypeDef";
        String typeDefParameterName = "newAttributeTypeDef";
        super.newAttributeTypeDefParameterValidation(userId, newAttributeTypeDef, "newAttributeTypeDef", "addAttributeTypeDef");
        this.realMetadataCollection.addAttributeTypeDef(userId, newAttributeTypeDef);
        if (this.localTypeDefManager != null) {
            this.localTypeDefManager.addAttributeTypeDef(this.repositoryName, newAttributeTypeDef);
        }
        if (this.produceEventsForRealConnector) {
            this.outboundRepositoryEventProcessor.processNewAttributeTypeDefEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, newAttributeTypeDef);
        }
    }

    public boolean verifyTypeDef(String userId, TypeDef typeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefConflictException, InvalidTypeDefException, UserNotAuthorizedException {
        String methodName = "verifyTypeDef";
        String typeDefParameterName = "typeDef";
        super.typeDefParameterValidation(userId, typeDef, "typeDef", "verifyTypeDef");
        return this.realMetadataCollection.verifyTypeDef(userId, typeDef);
    }

    public boolean verifyAttributeTypeDef(String userId, AttributeTypeDef attributeTypeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefConflictException, InvalidTypeDefException, UserNotAuthorizedException {
        String methodName = "verifyAttributeTypeDef";
        String typeDefParameterName = "attributeTypeDef";
        super.attributeTypeDefParameterValidation(userId, attributeTypeDef, "attributeTypeDef", "verifyAttributeTypeDef");
        return this.realMetadataCollection.verifyAttributeTypeDef(userId, attributeTypeDef);
    }

    public TypeDef updateTypeDef(String userId, TypeDefPatch typeDefPatch) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, PatchErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "updateTypeDef";
        super.updateTypeDefParameterValidation(userId, typeDefPatch, "updateTypeDef");
        TypeDef updatedTypeDef = this.realMetadataCollection.updateTypeDef(userId, typeDefPatch);
        if (this.localTypeDefManager != null) {
            this.localTypeDefManager.updateTypeDef(this.repositoryName, updatedTypeDef);
        }
        if (this.produceEventsForRealConnector) {
            this.outboundRepositoryEventProcessor.processUpdatedTypeDefEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, typeDefPatch);
        }
        return updatedTypeDef;
    }

    public void deleteTypeDef(String userId, String obsoleteTypeDefGUID, String obsoleteTypeDefName) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, TypeDefInUseException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "deleteTypeDef";
        String guidParameterName = "obsoleteTypeDefGUID";
        String nameParameterName = "obsoleteTypeDefName";
        super.manageTypeDefParameterValidation(userId, "obsoleteTypeDefGUID", "obsoleteTypeDefName", obsoleteTypeDefGUID, obsoleteTypeDefName, "deleteTypeDef");
        this.realMetadataCollection.deleteTypeDef(userId, obsoleteTypeDefGUID, obsoleteTypeDefName);
        if (this.localTypeDefManager != null) {
            this.localTypeDefManager.deleteTypeDef(this.repositoryName, obsoleteTypeDefGUID, obsoleteTypeDefName);
        }
        if (this.produceEventsForRealConnector) {
            this.outboundRepositoryEventProcessor.processDeletedTypeDefEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, obsoleteTypeDefGUID, obsoleteTypeDefName);
        }
    }

    public void deleteAttributeTypeDef(String userId, String obsoleteTypeDefGUID, String obsoleteTypeDefName) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, TypeDefInUseException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "deleteAttributeTypeDef";
        String guidParameterName = "obsoleteTypeDefGUID";
        String nameParameterName = "obsoleteTypeDefName";
        super.manageAttributeTypeDefParameterValidation(userId, "obsoleteTypeDefGUID", "obsoleteTypeDefName", obsoleteTypeDefGUID, obsoleteTypeDefName, "deleteAttributeTypeDef");
        this.realMetadataCollection.deleteAttributeTypeDef(userId, obsoleteTypeDefGUID, obsoleteTypeDefName);
        if (this.localTypeDefManager != null) {
            this.localTypeDefManager.deleteAttributeTypeDef(this.repositoryName, obsoleteTypeDefGUID, obsoleteTypeDefName);
        }
        if (this.produceEventsForRealConnector) {
            this.outboundRepositoryEventProcessor.processDeletedAttributeTypeDefEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, obsoleteTypeDefGUID, obsoleteTypeDefName);
        }
    }

    public TypeDef reIdentifyTypeDef(String userId, String originalTypeDefGUID, String originalTypeDefName, String newTypeDefGUID, String newTypeDefName) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "reIdentifyTypeDef";
        String originalGUIDParameterName = "originalTypeDefGUID";
        String originalNameParameterName = "originalTypeDefName";
        String newGUIDParameterName = "newTypeDefGUID";
        String newNameParameterName = "newTypeDefName";
        super.manageTypeDefParameterValidation(userId, "originalTypeDefGUID", "originalTypeDefName", originalTypeDefGUID, originalTypeDefName, "reIdentifyTypeDef");
        super.manageTypeDefParameterValidation(userId, "newTypeDefGUID", "newTypeDefName", newTypeDefGUID, newTypeDefName, "reIdentifyTypeDef");
        TypeDef originalTypeDef = this.realMetadataCollection.getTypeDefByGUID(userId, originalTypeDefGUID);
        TypeDef newTypeDef = this.realMetadataCollection.reIdentifyTypeDef(userId, originalTypeDefGUID, originalTypeDefName, newTypeDefGUID, newTypeDefName);
        if (this.localTypeDefManager != null) {
            this.localTypeDefManager.reIdentifyTypeDef(this.repositoryName, originalTypeDefGUID, originalTypeDefName, newTypeDef);
        }
        if (this.produceEventsForRealConnector) {
            this.outboundRepositoryEventProcessor.processReIdentifiedTypeDefEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, (TypeDefSummary)originalTypeDef, newTypeDef);
        }
        return newTypeDef;
    }

    public AttributeTypeDef reIdentifyAttributeTypeDef(String userId, String originalAttributeTypeDefGUID, String originalAttributeTypeDefName, String newAttributeTypeDefGUID, String newAttributeTypeDefName) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "reIdentifyAttributeTypeDef";
        String originalGUIDParameterName = "originalAttributeTypeDefGUID";
        String originalNameParameterName = "originalAttributeTypeDefName";
        String newGUIDParameterName = "newAttributeTypeDefGUID";
        String newNameParameterName = "newAttributeTypeDefName";
        super.manageAttributeTypeDefParameterValidation(userId, "originalAttributeTypeDefGUID", "originalAttributeTypeDefName", originalAttributeTypeDefGUID, originalAttributeTypeDefName, "reIdentifyAttributeTypeDef");
        super.manageAttributeTypeDefParameterValidation(userId, "newAttributeTypeDefGUID", "newAttributeTypeDefName", newAttributeTypeDefGUID, newAttributeTypeDefName, "reIdentifyAttributeTypeDef");
        AttributeTypeDef originalAttributeTypeDef = this.realMetadataCollection.getAttributeTypeDefByGUID(userId, originalAttributeTypeDefGUID);
        AttributeTypeDef newAttributeTypeDef = this.realMetadataCollection.reIdentifyAttributeTypeDef(userId, originalAttributeTypeDefGUID, originalAttributeTypeDefName, newAttributeTypeDefGUID, newAttributeTypeDefName);
        if (this.localTypeDefManager != null) {
            this.localTypeDefManager.reIdentifyAttributeTypeDef(this.repositoryName, originalAttributeTypeDefGUID, originalAttributeTypeDefName, newAttributeTypeDef);
        }
        if (this.produceEventsForRealConnector) {
            this.outboundRepositoryEventProcessor.processReIdentifiedAttributeTypeDefEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, originalAttributeTypeDef, newAttributeTypeDef);
        }
        return newAttributeTypeDef;
    }

    private void setLocalProvenance(InstanceAuditHeader instance) {
        if (instance != null) {
            if (instance.getMetadataCollectionId() == null) {
                instance.setMetadataCollectionId(this.metadataCollectionId);
                instance.setInstanceProvenanceType(InstanceProvenanceType.LOCAL_COHORT);
            }
            if (instance.getMetadataCollectionName() == null && this.metadataCollectionId.equals(instance.getMetadataCollectionId())) {
                instance.setMetadataCollectionName(this.metadataCollectionName);
            }
        }
    }

    private List<EntityDetail> setLocalProvenanceInEntityList(List<EntityDetail> instanceList) {
        if (instanceList == null || instanceList.isEmpty()) {
            return null;
        }
        ArrayList<EntityDetail> resultList = new ArrayList<EntityDetail>();
        for (EntityDetail entity : instanceList) {
            if (entity == null) continue;
            this.setLocalProvenance((InstanceAuditHeader)entity);
            resultList.add(entity);
        }
        return resultList;
    }

    private List<Relationship> setLocalProvenanceInRelationshipList(List<Relationship> instanceList) {
        if (instanceList == null || instanceList.isEmpty()) {
            return null;
        }
        ArrayList<Relationship> resultList = new ArrayList<Relationship>();
        for (Relationship entity : instanceList) {
            if (entity == null) continue;
            this.setLocalProvenance((InstanceAuditHeader)entity);
            resultList.add(entity);
        }
        return resultList;
    }

    private InstanceGraph setLocalProvenanceInGraph(InstanceGraph instanceGraph) {
        InstanceGraph resultGraph = new InstanceGraph();
        resultGraph.setEntities(this.setLocalProvenanceInEntityList(instanceGraph.getEntities()));
        resultGraph.setRelationships(this.setLocalProvenanceInRelationshipList(instanceGraph.getRelationships()));
        return resultGraph;
    }

    public EntityDetail isEntityKnown(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "isEntityKnown";
        super.getInstanceParameterValidation(userId, guid, "isEntityKnown");
        EntityDetail entity = this.realMetadataCollection.isEntityKnown(userId, guid);
        this.setLocalProvenance((InstanceAuditHeader)entity);
        return entity;
    }

    public EntitySummary getEntitySummary(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, UserNotAuthorizedException {
        String methodName = "getEntitySummary";
        super.getInstanceParameterValidation(userId, guid, "getEntitySummary");
        EntitySummary entity = this.realMetadataCollection.getEntitySummary(userId, guid);
        this.setLocalProvenance((InstanceAuditHeader)entity);
        return entity;
    }

    public EntityDetail getEntityDetail(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityProxyOnlyException, UserNotAuthorizedException {
        String methodName = "getEntityDetail";
        super.getInstanceParameterValidation(userId, guid, "getEntityDetail");
        EntityDetail entity = this.realMetadataCollection.getEntityDetail(userId, guid);
        this.setLocalProvenance((InstanceAuditHeader)entity);
        return entity;
    }

    public EntityDetail getEntityDetail(String userId, String guid, Date asOfTime) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityProxyOnlyException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getEntityDetail";
        super.getInstanceParameterValidation(userId, guid, asOfTime, "getEntityDetail");
        EntityDetail entity = this.realMetadataCollection.getEntityDetail(userId, guid, asOfTime);
        this.setLocalProvenance((InstanceAuditHeader)entity);
        return entity;
    }

    public List<Relationship> getRelationshipsForEntity(String userId, String entityGUID, String relationshipTypeGUID, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        super.getRelationshipsForEntityParameterValidation(userId, entityGUID, relationshipTypeGUID, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        List resultList = this.realMetadataCollection.getRelationshipsForEntity(userId, entityGUID, relationshipTypeGUID, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        return this.setLocalProvenanceInRelationshipList(resultList);
    }

    public List<EntityDetail> findEntitiesByProperty(String userId, String entityTypeGUID, InstanceProperties matchProperties, MatchCriteria matchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        super.findEntitiesByPropertyParameterValidation(userId, entityTypeGUID, matchProperties, matchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        List resultList = this.realMetadataCollection.findEntitiesByProperty(userId, entityTypeGUID, matchProperties, matchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        return this.setLocalProvenanceInEntityList(resultList);
    }

    public List<EntityDetail> findEntitiesByClassification(String userId, String entityTypeGUID, String classificationName, InstanceProperties matchClassificationProperties, MatchCriteria matchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, ClassificationErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        super.findEntitiesByClassificationParameterValidation(userId, entityTypeGUID, classificationName, matchClassificationProperties, matchCriteria, fromEntityElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        List resultList = this.realMetadataCollection.findEntitiesByClassification(userId, entityTypeGUID, classificationName, matchClassificationProperties, matchCriteria, fromEntityElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        return this.setLocalProvenanceInEntityList(resultList);
    }

    public List<EntityDetail> findEntitiesByPropertyValue(String userId, String entityTypeGUID, String searchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        super.findEntitiesByPropertyValueParameterValidation(userId, entityTypeGUID, searchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        List resultList = this.realMetadataCollection.findEntitiesByPropertyValue(userId, entityTypeGUID, searchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        return this.setLocalProvenanceInEntityList(resultList);
    }

    public Relationship isRelationshipKnown(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "isRelationshipKnown";
        super.getInstanceParameterValidation(userId, guid, "isRelationshipKnown");
        Relationship relationship = this.realMetadataCollection.isRelationshipKnown(userId, guid);
        this.setLocalProvenance((InstanceAuditHeader)relationship);
        return relationship;
    }

    public Relationship getRelationship(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, UserNotAuthorizedException {
        String methodName = "getRelationship";
        super.getInstanceParameterValidation(userId, guid, "getRelationship");
        Relationship relationship = this.realMetadataCollection.getRelationship(userId, guid);
        this.setLocalProvenance((InstanceAuditHeader)relationship);
        return relationship;
    }

    public Relationship getRelationship(String userId, String guid, Date asOfTime) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getRelationship";
        super.getInstanceParameterValidation(userId, guid, asOfTime, "getRelationship");
        Relationship relationship = this.realMetadataCollection.getRelationship(userId, guid, asOfTime);
        this.setLocalProvenance((InstanceAuditHeader)relationship);
        return relationship;
    }

    public List<Relationship> findRelationshipsByProperty(String userId, String relationshipTypeGUID, InstanceProperties matchProperties, MatchCriteria matchCriteria, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        super.findRelationshipsByPropertyParameterValidation(userId, relationshipTypeGUID, matchProperties, matchCriteria, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        List resultList = this.realMetadataCollection.findRelationshipsByProperty(userId, relationshipTypeGUID, matchProperties, matchCriteria, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        return this.setLocalProvenanceInRelationshipList(resultList);
    }

    public List<Relationship> findRelationshipsByPropertyValue(String userId, String relationshipTypeGUID, String searchCriteria, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        super.findRelationshipsByPropertyValueParameterValidation(userId, relationshipTypeGUID, searchCriteria, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        List resultList = this.realMetadataCollection.findRelationshipsByPropertyValue(userId, relationshipTypeGUID, searchCriteria, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        return this.setLocalProvenanceInRelationshipList(resultList);
    }

    public InstanceGraph getLinkingEntities(String userId, String startEntityGUID, String endEntityGUID, List<InstanceStatus> limitResultsByStatus, Date asOfTime) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        super.getLinkingEntitiesParameterValidation(userId, startEntityGUID, endEntityGUID, limitResultsByStatus, asOfTime);
        InstanceGraph resultGraph = this.realMetadataCollection.getLinkingEntities(userId, startEntityGUID, endEntityGUID, limitResultsByStatus, asOfTime);
        return this.setLocalProvenanceInGraph(resultGraph);
    }

    public InstanceGraph getEntityNeighborhood(String userId, String entityGUID, List<String> entityTypeGUIDs, List<String> relationshipTypeGUIDs, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, int level) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getEntityNeighborhood";
        super.getEntityNeighborhoodParameterValidation(userId, entityGUID, entityTypeGUIDs, relationshipTypeGUIDs, limitResultsByStatus, limitResultsByClassification, asOfTime, level);
        this.validateRepositoryConnector("getEntityNeighborhood");
        InstanceGraph resultGraph = this.realMetadataCollection.getEntityNeighborhood(userId, entityGUID, entityTypeGUIDs, relationshipTypeGUIDs, limitResultsByStatus, limitResultsByClassification, asOfTime, level);
        return this.setLocalProvenanceInGraph(resultGraph);
    }

    public List<EntityDetail> getRelatedEntities(String userId, String startEntityGUID, List<String> entityTypeGUIDs, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getRelatedEntities";
        super.getRelatedEntitiesParameterValidation(userId, startEntityGUID, entityTypeGUIDs, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        this.validateRepositoryConnector("getRelatedEntities");
        List resultList = this.realMetadataCollection.getRelatedEntities(userId, startEntityGUID, entityTypeGUIDs, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
        return this.setLocalProvenanceInEntityList(resultList);
    }

    public EntityDetail addEntity(String userId, String entityTypeGUID, InstanceProperties initialProperties, List<Classification> initialClassifications, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, ClassificationErrorException, StatusNotSupportedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "addEntity";
        super.addEntityParameterValidation(userId, entityTypeGUID, initialProperties, initialClassifications, initialStatus, "addEntity");
        EntityDetail entity = this.realMetadataCollection.addEntity(userId, entityTypeGUID, initialProperties, initialClassifications, initialStatus);
        if (entity != null) {
            this.setLocalProvenance((InstanceAuditHeader)entity);
            if (this.produceEventsForRealConnector) {
                this.outboundRepositoryEventProcessor.processNewEntityEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, entity);
            }
        }
        return entity;
    }

    public EntityDetail addExternalEntity(String userId, String entityTypeGUID, String externalSourceGUID, String externalSourceName, InstanceProperties initialProperties, List<Classification> initialClassifications, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, ClassificationErrorException, StatusNotSupportedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "addExternalEntity";
        super.addExternalEntityParameterValidation(userId, entityTypeGUID, externalSourceGUID, initialProperties, initialClassifications, initialStatus, "addExternalEntity");
        EntityDetail entity = this.realMetadataCollection.addExternalEntity(userId, entityTypeGUID, externalSourceGUID, externalSourceName, initialProperties, initialClassifications, initialStatus);
        if (entity != null) {
            this.setLocalProvenance((InstanceAuditHeader)entity);
            entity.setReplicatedBy(this.metadataCollectionId);
            if (this.produceEventsForRealConnector) {
                this.outboundRepositoryEventProcessor.processNewEntityEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, entity);
            }
        }
        return entity;
    }

    public void addEntityProxy(String userId, EntityProxy entityProxy) throws InvalidParameterException, RepositoryErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        super.addEntityProxyParameterValidation(userId, entityProxy);
        this.realMetadataCollection.addEntityProxy(userId, entityProxy);
    }

    private EntityDetail validateEntityNotProxy(String userId, String entityGUID, String methodName) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, UserNotAuthorizedException {
        try {
            return this.realMetadataCollection.getEntityDetail(userId, entityGUID);
        }
        catch (EntityProxyOnlyException error) {
            OMRSErrorCode errorCode = OMRSErrorCode.ENTITY_PROXY_IN_HOME;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{this.repositoryName, entityGUID, methodName});
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), (Throwable)error);
        }
    }

    private void notifyOfUpdatedEntity(EntityDetail oldEntity, EntityDetail newEntity) {
        if (newEntity != null && this.produceEventsForRealConnector) {
            this.outboundRepositoryEventProcessor.processUpdatedEntityEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, oldEntity, newEntity);
        }
    }

    public EntityDetail updateEntityStatus(String userId, String entityGUID, InstanceStatus newStatus) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, StatusNotSupportedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "updateEntityStatus";
        super.updateInstanceStatusParameterValidation(userId, entityGUID, newStatus, "updateEntityStatus");
        EntityDetail currentEntity = this.validateEntityNotProxy(userId, entityGUID, "updateEntityStatus");
        EntityDetail newEntity = this.realMetadataCollection.updateEntityStatus(userId, entityGUID, newStatus);
        this.setLocalProvenance((InstanceAuditHeader)newEntity);
        this.notifyOfUpdatedEntity(currentEntity, newEntity);
        return newEntity;
    }

    public EntityDetail updateEntityProperties(String userId, String entityGUID, InstanceProperties properties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "updateEntityProperties";
        super.updateInstancePropertiesPropertyValidation(userId, entityGUID, properties, "updateEntityProperties");
        EntityDetail currentEntity = this.validateEntityNotProxy(userId, entityGUID, "updateEntityProperties");
        EntityDetail newEntity = this.realMetadataCollection.updateEntityProperties(userId, entityGUID, properties);
        this.setLocalProvenance((InstanceAuditHeader)newEntity);
        this.notifyOfUpdatedEntity(currentEntity, newEntity);
        return newEntity;
    }

    public EntityDetail undoEntityUpdate(String userId, String entityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "undoEntityUpdate";
        String parameterName = "entityGUID";
        this.manageInstanceParameterValidation(userId, entityGUID, "entityGUID", "undoEntityUpdate");
        EntityDetail entity = this.realMetadataCollection.undoEntityUpdate(userId, entityGUID);
        if (entity != null) {
            this.setLocalProvenance((InstanceAuditHeader)entity);
            if (this.produceEventsForRealConnector) {
                this.outboundRepositoryEventProcessor.processUndoneEntityEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, entity);
            }
        }
        return entity;
    }

    public EntityDetail deleteEntity(String userId, String typeDefGUID, String typeDefName, String obsoleteEntityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "deleteEntity";
        String parameterName = "obsoleteEntityGUID";
        this.manageInstanceParameterValidation(userId, typeDefGUID, typeDefName, obsoleteEntityGUID, "obsoleteEntityGUID", "deleteEntity");
        EntityDetail entity = this.realMetadataCollection.deleteEntity(userId, typeDefGUID, typeDefName, obsoleteEntityGUID);
        if (this.produceEventsForRealConnector) {
            this.setLocalProvenance((InstanceAuditHeader)entity);
            this.outboundRepositoryEventProcessor.processDeletedEntityEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, entity);
        }
        return entity;
    }

    public void purgeEntity(String userId, String typeDefGUID, String typeDefName, String deletedEntityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityNotDeletedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "purgeEntity";
        String parameterName = "deletedEntityGUID";
        this.manageInstanceParameterValidation(userId, typeDefGUID, typeDefName, deletedEntityGUID, "deletedEntityGUID", "purgeEntity");
        EntityDetail entity = this.realMetadataCollection.isEntityKnown(userId, deletedEntityGUID);
        this.realMetadataCollection.purgeEntity(userId, typeDefGUID, typeDefName, deletedEntityGUID);
        if (this.produceEventsForRealConnector) {
            if (entity == null) {
                this.outboundRepositoryEventProcessor.processPurgedEntityEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, typeDefGUID, typeDefName, deletedEntityGUID);
            } else {
                this.outboundRepositoryEventProcessor.processPurgedEntityEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, entity);
            }
        }
    }

    public EntityDetail restoreEntity(String userId, String deletedEntityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityNotDeletedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "restoreEntity";
        String parameterName = "deletedEntityGUID";
        super.manageInstanceParameterValidation(userId, deletedEntityGUID, "deletedEntityGUID", "restoreEntity");
        EntityDetail entity = this.realMetadataCollection.restoreEntity(userId, deletedEntityGUID);
        if (entity != null) {
            this.setLocalProvenance((InstanceAuditHeader)entity);
            if (this.produceEventsForRealConnector) {
                this.outboundRepositoryEventProcessor.processRestoredEntityEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, entity);
            }
        }
        return entity;
    }

    public EntityDetail classifyEntity(String userId, String entityGUID, String classificationName, InstanceProperties classificationProperties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "classifyEntity";
        this.classifyEntityParameterValidation(userId, entityGUID, classificationName, classificationProperties, "classifyEntity");
        EntityDetail entity = this.realMetadataCollection.classifyEntity(userId, entityGUID, classificationName, classificationProperties);
        if (entity != null) {
            this.setLocalProvenance((InstanceAuditHeader)entity);
            if (this.produceEventsForRealConnector) {
                this.outboundRepositoryEventProcessor.processClassifiedEntityEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, entity);
            }
        }
        return entity;
    }

    public EntityDetail declassifyEntity(String userId, String entityGUID, String classificationName) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        this.declassifyEntityParameterValidation(userId, entityGUID, classificationName);
        EntityDetail entity = this.realMetadataCollection.declassifyEntity(userId, entityGUID, classificationName);
        if (entity != null) {
            this.setLocalProvenance((InstanceAuditHeader)entity);
            if (this.produceEventsForRealConnector) {
                this.outboundRepositoryEventProcessor.processDeclassifiedEntityEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, entity);
            }
        }
        return entity;
    }

    public EntityDetail updateEntityClassification(String userId, String entityGUID, String classificationName, InstanceProperties properties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "updateEntityClassification";
        this.classifyEntityParameterValidation(userId, entityGUID, classificationName, properties, "updateEntityClassification");
        EntityDetail entity = this.realMetadataCollection.updateEntityClassification(userId, entityGUID, classificationName, properties);
        if (entity != null) {
            this.setLocalProvenance((InstanceAuditHeader)entity);
            if (this.produceEventsForRealConnector) {
                this.outboundRepositoryEventProcessor.processReclassifiedEntityEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, entity);
            }
        }
        return entity;
    }

    public Relationship addRelationship(String userId, String relationshipTypeGUID, InstanceProperties initialProperties, String entityOneGUID, String entityTwoGUID, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, EntityNotKnownException, StatusNotSupportedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "addRelationship";
        super.addRelationshipParameterValidation(userId, relationshipTypeGUID, initialProperties, entityOneGUID, entityTwoGUID, initialStatus, "addRelationship");
        Relationship relationship = this.realMetadataCollection.addRelationship(userId, relationshipTypeGUID, initialProperties, entityOneGUID, entityTwoGUID, initialStatus);
        if (relationship != null) {
            this.setLocalProvenance((InstanceAuditHeader)relationship);
            EntityProxy endOneProxy = relationship.getEntityOneProxy();
            EntityProxy endTwoProxy = relationship.getEntityTwoProxy();
            if (endOneProxy != null) {
                if (endOneProxy.getMetadataCollectionId() == null) {
                    endOneProxy.setMetadataCollectionId(this.metadataCollectionId);
                }
                if (endOneProxy.getMetadataCollectionName() == null) {
                    endOneProxy.setMetadataCollectionName(this.repositoryName);
                }
                relationship.setEntityOneProxy(endOneProxy);
            }
            if (endTwoProxy != null) {
                if (endTwoProxy.getMetadataCollectionId() == null) {
                    endTwoProxy.setMetadataCollectionId(this.metadataCollectionId);
                }
                if (endTwoProxy.getMetadataCollectionName() == null) {
                    endTwoProxy.setMetadataCollectionName(this.repositoryName);
                }
                relationship.setEntityTwoProxy(endTwoProxy);
            }
            if (this.produceEventsForRealConnector) {
                this.outboundRepositoryEventProcessor.processNewRelationshipEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, relationship);
            }
        }
        return relationship;
    }

    public Relationship addExternalRelationship(String userId, String relationshipTypeGUID, String externalSourceGUID, String externalSourceName, InstanceProperties initialProperties, String entityOneGUID, String entityTwoGUID, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, EntityNotKnownException, StatusNotSupportedException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "addExternalRelationship";
        super.addExternalRelationshipParameterValidation(userId, relationshipTypeGUID, externalSourceGUID, initialProperties, entityOneGUID, entityTwoGUID, initialStatus, "addExternalRelationship");
        Relationship relationship = this.realMetadataCollection.addExternalRelationship(userId, relationshipTypeGUID, externalSourceGUID, externalSourceName, initialProperties, entityOneGUID, entityTwoGUID, initialStatus);
        if (relationship != null) {
            this.setLocalProvenance((InstanceAuditHeader)relationship);
            relationship.setReplicatedBy(this.metadataCollectionId);
            EntityProxy endOneProxy = relationship.getEntityOneProxy();
            EntityProxy endTwoProxy = relationship.getEntityTwoProxy();
            if (endOneProxy != null) {
                if (endOneProxy.getMetadataCollectionId() == null) {
                    endOneProxy.setMetadataCollectionId(this.metadataCollectionId);
                }
                if (endOneProxy.getMetadataCollectionName() == null) {
                    endOneProxy.setMetadataCollectionName(this.repositoryName);
                }
                relationship.setEntityOneProxy(endOneProxy);
            }
            if (endTwoProxy != null) {
                if (endTwoProxy.getMetadataCollectionId() == null) {
                    endTwoProxy.setMetadataCollectionId(this.metadataCollectionId);
                }
                if (endTwoProxy.getMetadataCollectionName() == null) {
                    endTwoProxy.setMetadataCollectionName(this.repositoryName);
                }
                relationship.setEntityTwoProxy(endTwoProxy);
            }
            if (this.produceEventsForRealConnector) {
                this.outboundRepositoryEventProcessor.processNewRelationshipEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, relationship);
            }
        }
        return relationship;
    }

    public Relationship updateRelationshipStatus(String userId, String relationshipGUID, InstanceStatus newStatus) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, StatusNotSupportedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "updateRelationshipStatus";
        this.updateInstanceStatusParameterValidation(userId, relationshipGUID, newStatus, "updateRelationshipStatus");
        Relationship currentRelationship = this.realMetadataCollection.getRelationship(userId, relationshipGUID);
        Relationship newRelationship = this.realMetadataCollection.updateRelationshipStatus(userId, relationshipGUID, newStatus);
        this.setLocalProvenance((InstanceAuditHeader)newRelationship);
        this.notifyOfUpdatedRelationship(currentRelationship, newRelationship);
        return newRelationship;
    }

    public Relationship updateRelationshipProperties(String userId, String relationshipGUID, InstanceProperties properties) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "updateRelationshipProperties";
        this.updateInstancePropertiesPropertyValidation(userId, relationshipGUID, properties, "updateRelationshipProperties");
        Relationship currentRelationship = this.realMetadataCollection.getRelationship(userId, relationshipGUID);
        Relationship newRelationship = this.realMetadataCollection.updateRelationshipProperties(userId, relationshipGUID, properties);
        this.setLocalProvenance((InstanceAuditHeader)newRelationship);
        this.notifyOfUpdatedRelationship(currentRelationship, newRelationship);
        return newRelationship;
    }

    private void notifyOfUpdatedRelationship(Relationship oldRelationship, Relationship newRelationship) {
        if (newRelationship != null && this.produceEventsForRealConnector) {
            this.outboundRepositoryEventProcessor.processUpdatedRelationshipEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, oldRelationship, newRelationship);
        }
    }

    public Relationship undoRelationshipUpdate(String userId, String relationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "undoRelationshipUpdate";
        String parameterName = "relationshipGUID";
        this.manageInstanceParameterValidation(userId, relationshipGUID, "relationshipGUID", "undoRelationshipUpdate");
        Relationship relationship = this.realMetadataCollection.undoRelationshipUpdate(userId, relationshipGUID);
        if (relationship != null) {
            this.setLocalProvenance((InstanceAuditHeader)relationship);
            if (this.produceEventsForRealConnector) {
                this.outboundRepositoryEventProcessor.processUndoneRelationshipEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, relationship);
            }
        }
        return relationship;
    }

    public Relationship deleteRelationship(String userId, String typeDefGUID, String typeDefName, String obsoleteRelationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "deleteRelationship";
        String parameterName = "obsoleteRelationshipGUID";
        this.manageInstanceParameterValidation(userId, typeDefGUID, typeDefName, obsoleteRelationshipGUID, "obsoleteRelationshipGUID", "deleteRelationship");
        Relationship relationship = this.realMetadataCollection.deleteRelationship(userId, typeDefGUID, typeDefName, obsoleteRelationshipGUID);
        if (this.produceEventsForRealConnector) {
            this.setLocalProvenance((InstanceAuditHeader)relationship);
            this.outboundRepositoryEventProcessor.processDeletedRelationshipEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, relationship);
        }
        return relationship;
    }

    public void purgeRelationship(String userId, String typeDefGUID, String typeDefName, String deletedRelationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, RelationshipNotDeletedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "purgeRelationship";
        String parameterName = "deletedRelationshipGUID";
        this.manageInstanceParameterValidation(userId, typeDefGUID, typeDefName, deletedRelationshipGUID, "deletedRelationshipGUID", "purgeRelationship");
        Relationship relationship = this.realMetadataCollection.isRelationshipKnown(userId, deletedRelationshipGUID);
        this.realMetadataCollection.purgeRelationship(userId, typeDefGUID, typeDefName, deletedRelationshipGUID);
        if (this.produceEventsForRealConnector) {
            if (relationship == null) {
                this.outboundRepositoryEventProcessor.processPurgedRelationshipEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, typeDefGUID, typeDefName, deletedRelationshipGUID);
            } else {
                this.outboundRepositoryEventProcessor.processPurgedRelationshipEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, relationship);
            }
        }
    }

    public Relationship restoreRelationship(String userId, String deletedRelationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, RelationshipNotDeletedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "restoreRelationship";
        String parameterName = "deletedRelationshipGUID";
        this.manageInstanceParameterValidation(userId, deletedRelationshipGUID, "deletedRelationshipGUID", "restoreRelationship");
        Relationship relationship = this.realMetadataCollection.restoreRelationship(userId, deletedRelationshipGUID);
        if (relationship != null) {
            this.setLocalProvenance((InstanceAuditHeader)relationship);
            if (this.produceEventsForRealConnector) {
                this.outboundRepositoryEventProcessor.processRestoredRelationshipEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, relationship);
            }
        }
        return relationship;
    }

    public EntityDetail reIdentifyEntity(String userId, String typeDefGUID, String typeDefName, String entityGUID, String newEntityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "reIdentifyEntity";
        String instanceParameterName = "entityGUID";
        String newInstanceParameterName = "newEntityGUID";
        super.reIdentifyInstanceParameterValidation(userId, typeDefGUID, typeDefName, entityGUID, "entityGUID", newEntityGUID, "newEntityGUID", "reIdentifyEntity");
        EntityDetail entity = this.realMetadataCollection.reIdentifyEntity(userId, typeDefGUID, typeDefName, entityGUID, newEntityGUID);
        if (entity != null) {
            this.setLocalProvenance((InstanceAuditHeader)entity);
            if (this.produceEventsForRealConnector) {
                this.outboundRepositoryEventProcessor.processReIdentifiedEntityEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, entityGUID, entity);
            }
        }
        return entity;
    }

    public EntityDetail reTypeEntity(String userId, String entityGUID, TypeDefSummary currentTypeDefSummary, TypeDefSummary newTypeDefSummary) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, ClassificationErrorException, EntityNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "reTypeEntity";
        String entityParameterName = "entityGUID";
        super.reTypeInstanceParameterValidation(userId, entityGUID, "entityGUID", TypeDefCategory.ENTITY_DEF, currentTypeDefSummary, newTypeDefSummary, "reTypeEntity");
        EntityDetail entity = this.realMetadataCollection.reTypeEntity(userId, entityGUID, currentTypeDefSummary, newTypeDefSummary);
        if (entity != null) {
            this.setLocalProvenance((InstanceAuditHeader)entity);
            if (this.produceEventsForRealConnector) {
                this.outboundRepositoryEventProcessor.processReTypedEntityEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, currentTypeDefSummary, entity);
            }
        }
        return entity;
    }

    public EntityDetail reHomeEntity(String userId, String entityGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId, String newHomeMetadataCollectionId, String newHomeMetadataCollectionName) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "reHomeEntity";
        String entityParameterName = "entityGUID";
        super.reHomeInstanceParameterValidation(userId, entityGUID, "entityGUID", typeDefGUID, typeDefName, homeMetadataCollectionId, newHomeMetadataCollectionId, "reHomeEntity");
        EntityDetail entity = this.realMetadataCollection.reHomeEntity(userId, entityGUID, typeDefGUID, typeDefName, homeMetadataCollectionId, newHomeMetadataCollectionId, newHomeMetadataCollectionName);
        if (entity != null) {
            if (entity.getMetadataCollectionId() == null) {
                entity.setMetadataCollectionId(newHomeMetadataCollectionId);
                entity.setInstanceProvenanceType(InstanceProvenanceType.LOCAL_COHORT);
            }
            if (entity.getMetadataCollectionName() == null) {
                entity.setMetadataCollectionName(newHomeMetadataCollectionName);
            }
            if (this.produceEventsForRealConnector) {
                this.outboundRepositoryEventProcessor.processReHomedEntityEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, this.metadataCollectionId, entity);
            }
        }
        return entity;
    }

    public Relationship reIdentifyRelationship(String userId, String typeDefGUID, String typeDefName, String relationshipGUID, String newRelationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "reIdentifyRelationship";
        String instanceParameterName = "relationshipGUID";
        String newInstanceParameterName = "newRelationshipGUID";
        super.reIdentifyInstanceParameterValidation(userId, typeDefGUID, typeDefName, relationshipGUID, "relationshipGUID", newRelationshipGUID, "newRelationshipGUID", "reIdentifyRelationship");
        Relationship relationship = this.realMetadataCollection.reIdentifyRelationship(userId, typeDefGUID, typeDefName, relationshipGUID, newRelationshipGUID);
        if (relationship != null) {
            this.setLocalProvenance((InstanceAuditHeader)relationship);
            if (this.produceEventsForRealConnector) {
                this.outboundRepositoryEventProcessor.processReIdentifiedRelationshipEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, relationshipGUID, relationship);
            }
        }
        return relationship;
    }

    public Relationship reTypeRelationship(String userId, String relationshipGUID, TypeDefSummary currentTypeDefSummary, TypeDefSummary newTypeDefSummary) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "reTypeRelationship";
        String relationshipParameterName = "relationshipGUID";
        super.reTypeInstanceParameterValidation(userId, relationshipGUID, "relationshipGUID", TypeDefCategory.RELATIONSHIP_DEF, currentTypeDefSummary, newTypeDefSummary, "reTypeRelationship");
        Relationship relationship = this.realMetadataCollection.reTypeRelationship(userId, relationshipGUID, currentTypeDefSummary, newTypeDefSummary);
        if (relationship != null) {
            this.setLocalProvenance((InstanceAuditHeader)relationship);
            if (this.produceEventsForRealConnector) {
                this.outboundRepositoryEventProcessor.processReTypedRelationshipEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, currentTypeDefSummary, relationship);
            }
        }
        return relationship;
    }

    public Relationship reHomeRelationship(String userId, String relationshipGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId, String newHomeMetadataCollectionId, String newHomeMetadataCollectionName) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "reHomeRelationship";
        String relationshipParameterName = "relationshipGUID";
        super.reHomeInstanceParameterValidation(userId, relationshipGUID, "relationshipGUID", typeDefGUID, typeDefName, homeMetadataCollectionId, newHomeMetadataCollectionId, "reHomeRelationship");
        Relationship relationship = this.realMetadataCollection.reHomeRelationship(userId, relationshipGUID, typeDefGUID, typeDefName, homeMetadataCollectionId, newHomeMetadataCollectionId, newHomeMetadataCollectionName);
        if (relationship != null) {
            this.setLocalProvenance((InstanceAuditHeader)relationship);
            if (this.produceEventsForRealConnector) {
                this.outboundRepositoryEventProcessor.processReHomedRelationshipEvent(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, homeMetadataCollectionId, relationship);
            }
        }
        return relationship;
    }

    public void saveEntityReferenceCopy(String userId, EntityDetail entity) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, HomeEntityException, EntityConflictException, InvalidEntityException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "saveEntityReferenceCopy";
        String instanceParameterName = "entity";
        super.referenceInstanceParameterValidation(userId, (InstanceHeader)entity, "entity", "saveEntityReferenceCopy");
        if (entity.getHeaderVersion() <= 1L) {
            this.realMetadataCollection.saveEntityReferenceCopy(userId, entity);
        }
    }

    public void deleteEntityReferenceCopy(String userId, EntityDetail entity) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, HomeEntityException, EntityConflictException, InvalidEntityException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "deleteEntityReferenceCopy";
        String instanceParameterName = "entity";
        super.referenceInstanceParameterValidation(userId, (InstanceHeader)entity, "entity", "deleteEntityReferenceCopy");
        this.realMetadataCollection.deleteEntityReferenceCopy(userId, entity);
    }

    public void purgeEntityReferenceCopy(String userId, EntityDetail entity) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, HomeEntityException, EntityConflictException, InvalidEntityException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "purgeEntityReferenceCopy";
        String instanceParameterName = "entity";
        this.referenceInstanceParameterValidation(userId, (InstanceHeader)entity, "entity", "purgeEntityReferenceCopy");
        this.realMetadataCollection.deleteEntityReferenceCopy(userId, entity);
    }

    public void purgeEntityReferenceCopy(String userId, String entityGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, HomeEntityException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "purgeEntityReferenceCopy";
        String entityParameterName = "entityGUID";
        String homeParameterName = "homeMetadataCollectionId";
        super.manageReferenceInstanceParameterValidation(userId, entityGUID, typeDefGUID, typeDefName, "entityGUID", homeMetadataCollectionId, "homeMetadataCollectionId", "purgeEntityReferenceCopy");
        this.realMetadataCollection.purgeEntityReferenceCopy(userId, entityGUID, typeDefGUID, typeDefName, homeMetadataCollectionId);
    }

    public void refreshEntityReferenceCopy(String userId, String entityGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId) throws InvalidParameterException, RepositoryErrorException, HomeEntityException, UserNotAuthorizedException {
        String methodName = "refreshEntityReferenceCopy";
        String entityParameterName = "entityGUID";
        String homeParameterName = "homeMetadataCollectionId";
        super.manageReferenceInstanceParameterValidation(userId, entityGUID, typeDefGUID, typeDefName, "entityGUID", homeMetadataCollectionId, "homeMetadataCollectionId", "refreshEntityReferenceCopy");
        EntityDetail entity = this.isEntityKnown(userId, entityGUID);
        if (entity != null && this.metadataCollectionId.equals(entity.getMetadataCollectionId())) {
            OMRSErrorCode errorCode = OMRSErrorCode.HOME_REFRESH;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"refreshEntityReferenceCopy", entityGUID, this.metadataCollectionId, this.repositoryName});
            throw new HomeEntityException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "refreshEntityReferenceCopy", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        this.outboundRepositoryEventProcessor.processRefreshEntityRequested(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, typeDefGUID, typeDefName, entityGUID, homeMetadataCollectionId);
    }

    public void saveRelationshipReferenceCopy(String userId, Relationship relationship) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, EntityNotKnownException, PropertyErrorException, HomeRelationshipException, RelationshipConflictException, InvalidRelationshipException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "saveRelationshipReferenceCopy";
        String instanceParameterName = "relationship";
        super.referenceInstanceParameterValidation(userId, (InstanceHeader)relationship, "relationship", "saveRelationshipReferenceCopy");
        if (relationship.getHeaderVersion() <= 1L) {
            this.realMetadataCollection.saveRelationshipReferenceCopy(userId, relationship);
        }
    }

    public void deleteRelationshipReferenceCopy(String userId, Relationship relationship) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, EntityNotKnownException, PropertyErrorException, HomeRelationshipException, RelationshipConflictException, InvalidRelationshipException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "deleteRelationshipReferenceCopy";
        String instanceParameterName = "relationship";
        super.referenceInstanceParameterValidation(userId, (InstanceHeader)relationship, "relationship", "deleteRelationshipReferenceCopy");
        this.realMetadataCollection.deleteRelationshipReferenceCopy(userId, relationship);
    }

    public void purgeRelationshipReferenceCopy(String userId, Relationship relationship) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, EntityNotKnownException, PropertyErrorException, HomeRelationshipException, RelationshipConflictException, InvalidRelationshipException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "purgeRelationshipReferenceCopy";
        String instanceParameterName = "relationship";
        this.referenceInstanceParameterValidation(userId, (InstanceHeader)relationship, "relationship", "purgeRelationshipReferenceCopy");
        this.realMetadataCollection.purgeRelationshipReferenceCopy(userId, relationship);
    }

    public void purgeRelationshipReferenceCopy(String userId, String relationshipGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, HomeRelationshipException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "purgeRelationshipReferenceCopy";
        String relationshipParameterName = "relationshipGUID";
        String homeParameterName = "homeMetadataCollectionId";
        super.manageReferenceInstanceParameterValidation(userId, relationshipGUID, typeDefGUID, typeDefName, "relationshipGUID", homeMetadataCollectionId, "homeMetadataCollectionId", "purgeRelationshipReferenceCopy");
        this.realMetadataCollection.purgeRelationshipReferenceCopy(userId, relationshipGUID, typeDefGUID, typeDefName, homeMetadataCollectionId);
    }

    public void refreshRelationshipReferenceCopy(String userId, String relationshipGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId) throws InvalidParameterException, RepositoryErrorException, HomeRelationshipException, UserNotAuthorizedException {
        String methodName = "refreshRelationshipReferenceCopy";
        String relationshipParameterName = "relationshipGUID";
        String homeParameterName = "homeMetadataCollectionId";
        super.manageReferenceInstanceParameterValidation(userId, relationshipGUID, typeDefGUID, typeDefName, "relationshipGUID", homeMetadataCollectionId, "homeMetadataCollectionId", "refreshRelationshipReferenceCopy");
        Relationship relationship = this.isRelationshipKnown(userId, relationshipGUID);
        if (relationship != null && this.metadataCollectionId.equals(relationship.getMetadataCollectionId())) {
            OMRSErrorCode errorCode = OMRSErrorCode.HOME_REFRESH;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{"refreshRelationshipReferenceCopy", relationshipGUID, this.metadataCollectionId, this.repositoryName});
            throw new HomeRelationshipException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "refreshRelationshipReferenceCopy", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        this.outboundRepositoryEventProcessor.processRefreshRelationshipRequest(this.repositoryName, this.metadataCollectionId, this.localServerName, this.localServerType, this.localOrganizationName, typeDefGUID, typeDefName, relationshipGUID, homeMetadataCollectionId);
    }
}

