/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.localrepository.repositorycontentmanager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditCode;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefGallery;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.eventmanagement.OMRSRepositoryEventManager;
import org.odpi.openmetadata.repositoryservices.events.OMRSEventOriginator;
import org.odpi.openmetadata.repositoryservices.events.OMRSTypeDefEvent;
import org.odpi.openmetadata.repositoryservices.events.OMRSTypeDefEventErrorCode;
import org.odpi.openmetadata.repositoryservices.events.OMRSTypeDefEventProcessor;
import org.odpi.openmetadata.repositoryservices.events.OMRSTypeDefEventType;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidTypeDefException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PatchErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.localrepository.repositoryconnector.LocalOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.localrepository.repositorycontentmanager.OMRSTypeDefManager;
import org.odpi.openmetadata.repositoryservices.rest.server.OMRSRepositoryRESTServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMRSRepositoryContentManager
extends OMRSTypeDefEventProcessor
implements OMRSTypeDefManager {
    private LocalOMRSRepositoryConnector localRepositoryConnector = null;
    private String localServerName = null;
    private OMRSRepositoryEventManager outboundRepositoryEventManager = null;
    private String openTypesOriginGUID = null;
    private Map<String, TypeDef> knownTypeDefGUIDs = new HashMap<String, TypeDef>();
    private Map<String, TypeDef> knownTypeDefNames = new HashMap<String, TypeDef>();
    private Map<String, AttributeTypeDef> knownAttributeTypeDefGUIDs = new HashMap<String, AttributeTypeDef>();
    private Map<String, AttributeTypeDef> knownAttributeTypeDefNames = new HashMap<String, AttributeTypeDef>();
    private Map<String, TypeDef> activeTypeDefGUIDs = new HashMap<String, TypeDef>();
    private Map<String, TypeDef> activeTypeDefNames = new HashMap<String, TypeDef>();
    private Map<String, AttributeTypeDef> activeAttributeTypeDefGUIDs = new HashMap<String, AttributeTypeDef>();
    private Map<String, AttributeTypeDef> activeAttributeTypeDefNames = new HashMap<String, AttributeTypeDef>();
    private Map<String, List<TypeDefLink>> typeDefSuperTypes = new HashMap<String, List<TypeDefLink>>();
    private Map<String, InstanceType> knownInstanceTypes = new HashMap<String, InstanceType>();
    private Map<String, String> metadataCollectionNames = new HashMap<String, String>();
    private OMRSAuditLog auditLog;
    private static final Logger log = LoggerFactory.getLogger(OMRSRepositoryContentManager.class);

    public OMRSRepositoryContentManager(OMRSAuditLog auditLog) {
        super("Local Repository Content (TypeDef) Manager");
        this.auditLog = auditLog;
    }

    public void setupEventProcessor(LocalOMRSRepositoryConnector localRepositoryConnector, OMRSRepositoryEventManager outboundRepositoryEventManager) {
        if (localRepositoryConnector != null) {
            this.localRepositoryConnector = localRepositoryConnector;
            this.localServerName = localRepositoryConnector.getLocalServerName();
        }
        this.outboundRepositoryEventManager = outboundRepositoryEventManager;
    }

    public void setOpenMetadataTypesOriginGUID(String openMetadataTypesGUID) {
        this.openTypesOriginGUID = openMetadataTypesGUID;
    }

    @Override
    public void addTypeDef(String sourceName, TypeDef newTypeDef) {
        this.cacheTypeDef(sourceName, newTypeDef, true);
    }

    private void cacheTypeDef(String sourceName, TypeDef newTypeDef, boolean isLocallySupported) {
        if (this.validTypeDef(sourceName, newTypeDef)) {
            this.knownTypeDefGUIDs.put(newTypeDef.getGUID(), newTypeDef);
            this.knownTypeDefNames.put(newTypeDef.getName(), newTypeDef);
            if (isLocallySupported) {
                this.activeTypeDefGUIDs.put(newTypeDef.getGUID(), newTypeDef);
                this.activeTypeDefNames.put(newTypeDef.getName(), newTypeDef);
                log.debug("New Active Type " + newTypeDef.getName() + " from " + sourceName + ". Full TypeDef: " + newTypeDef);
            } else {
                log.debug("New Known Type " + newTypeDef.getName() + " from " + sourceName + ". Full TypeDef: " + newTypeDef);
            }
        }
    }

    @Override
    public void addAttributeTypeDef(String sourceName, AttributeTypeDef newAttributeTypeDef) {
        this.cacheAttributeTypeDef(sourceName, newAttributeTypeDef, true);
    }

    private void cacheAttributeTypeDef(String sourceName, AttributeTypeDef newAttributeTypeDef, boolean isLocallySupported) {
        if (this.validAttributeTypeDef(sourceName, newAttributeTypeDef)) {
            this.knownAttributeTypeDefGUIDs.put(newAttributeTypeDef.getGUID(), newAttributeTypeDef);
            this.knownAttributeTypeDefNames.put(newAttributeTypeDef.getName(), newAttributeTypeDef);
            if (isLocallySupported) {
                this.activeAttributeTypeDefGUIDs.put(newAttributeTypeDef.getGUID(), newAttributeTypeDef);
                this.activeAttributeTypeDefNames.put(newAttributeTypeDef.getName(), newAttributeTypeDef);
                if (log.isDebugEnabled()) {
                    log.debug("New Active Attribute Type " + newAttributeTypeDef.getName() + " from " + sourceName + ". Full AttributeTypeDef: " + newAttributeTypeDef);
                } else {
                    log.debug("New Known Attribute Type " + newAttributeTypeDef.getName() + " from " + sourceName + ". Full AttributeTypeDef: " + newAttributeTypeDef);
                }
            }
        }
    }

    @Override
    public void updateTypeDef(String sourceName, TypeDef typeDef) {
        if (this.validTypeDef(sourceName, typeDef)) {
            this.knownTypeDefGUIDs.put(typeDef.getGUID(), typeDef);
            this.knownTypeDefNames.put(typeDef.getName(), typeDef);
            if (this.localRepositoryConnector != null) {
                this.activeTypeDefGUIDs.put(typeDef.getGUID(), typeDef);
                this.activeTypeDefNames.put(typeDef.getName(), typeDef);
                log.debug("Updated Active Type " + typeDef.getName() + " from " + sourceName + ". Full TypeDef: " + typeDef);
            }
        }
    }

    @Override
    public void deleteTypeDef(String sourceName, String obsoleteTypeDefGUID, String obsoleteTypeDefName) {
        if (this.validTypeId(sourceName, obsoleteTypeDefGUID, obsoleteTypeDefName)) {
            this.knownTypeDefGUIDs.remove(obsoleteTypeDefGUID);
            this.knownTypeDefNames.remove(obsoleteTypeDefName);
            if (this.localRepositoryConnector != null) {
                this.activeTypeDefGUIDs.remove(obsoleteTypeDefGUID);
                this.activeTypeDefNames.remove(obsoleteTypeDefName);
                log.debug("Deleted Active TypeDef " + obsoleteTypeDefName + " from " + sourceName);
            }
        }
    }

    @Override
    public void deleteAttributeTypeDef(String sourceName, String obsoleteAttributeTypeDefGUID, String obsoleteAttributeTypeDefName) {
        if (this.validTypeId(sourceName, obsoleteAttributeTypeDefGUID, obsoleteAttributeTypeDefName)) {
            this.knownAttributeTypeDefGUIDs.remove(obsoleteAttributeTypeDefGUID);
            this.knownAttributeTypeDefNames.remove(obsoleteAttributeTypeDefName);
            if (this.localRepositoryConnector != null) {
                this.activeAttributeTypeDefGUIDs.remove(obsoleteAttributeTypeDefGUID);
                this.activeAttributeTypeDefNames.remove(obsoleteAttributeTypeDefName);
                if (log.isDebugEnabled()) {
                    log.debug("Deleted Active AttributeTypeDef " + obsoleteAttributeTypeDefName + " from " + sourceName);
                }
            }
        }
    }

    @Override
    public void reIdentifyTypeDef(String sourceName, String originalTypeDefGUID, String originalTypeDefName, TypeDef newTypeDef) {
        this.deleteTypeDef(sourceName, originalTypeDefGUID, originalTypeDefName);
        this.addTypeDef(sourceName, newTypeDef);
    }

    @Override
    public void reIdentifyAttributeTypeDef(String sourceName, String originalAttributeTypeDefGUID, String originalAttributeTypeDefName, AttributeTypeDef newAttributeTypeDef) {
        this.deleteAttributeTypeDef(sourceName, originalAttributeTypeDefGUID, originalAttributeTypeDefName);
        this.addAttributeTypeDef(sourceName, newAttributeTypeDef);
    }

    private List<String> getPropertyNames(String sourceName, TypeDef typeDef) throws TypeErrorException {
        String methodName = "getPropertyNames";
        ArrayList<String> propertyNames = null;
        if (this.validTypeDef(sourceName, typeDef)) {
            List propertiesDefinition = typeDef.getPropertiesDefinition();
            if (propertiesDefinition != null && propertiesDefinition.size() > 0) {
                propertyNames = new ArrayList<String>();
                for (TypeDefAttribute propertyDefinition : propertiesDefinition) {
                    if (propertyDefinition != null) {
                        String propertyName = propertyDefinition.getAttributeName();
                        if (propertyName != null) {
                            log.debug(typeDef.getName() + " from " + sourceName + " has property " + propertyName);
                            propertyNames.add(propertyName);
                            continue;
                        }
                        OMRSErrorCode errorCode = OMRSErrorCode.BAD_TYPEDEF_ATTRIBUTE_NAME;
                        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{sourceName});
                        throw new TypeErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getPropertyNames", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                    }
                    OMRSErrorCode errorCode = OMRSErrorCode.NULL_TYPEDEF_ATTRIBUTE;
                    String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{sourceName});
                    throw new TypeErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getPropertyNames", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
                }
                if (propertyNames.size() == 0) {
                    propertyNames = null;
                }
            }
        } else {
            OMRSErrorCode errorCode = OMRSErrorCode.BAD_TYPEDEF;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{sourceName});
            throw new TypeErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), "getPropertyNames", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return propertyNames;
    }

    private List<TypeDefLink> getSuperTypes(String sourceName, String typeName, String methodName) {
        String thisMethodName = "getSuperTypes";
        List<TypeDefLink> typeHierarchy = this.typeDefSuperTypes.get(typeName);
        if (typeHierarchy == null) {
            typeHierarchy = new ArrayList<TypeDefLink>();
            TypeDef typeDef = this.knownTypeDefNames.get(typeName);
            if (typeDef != null) {
                TypeDefLink superTypeLink = typeDef.getSuperType();
                while (superTypeLink != null) {
                    String superTypeName = superTypeLink.getName();
                    if (superTypeName != null) {
                        log.debug(typeName + " has super type " + superTypeName);
                        typeHierarchy.add(superTypeLink);
                        TypeDef superTypeDef = this.knownTypeDefNames.get(superTypeName);
                        if (superTypeDef != null) {
                            superTypeLink = superTypeDef.getSuperType();
                            continue;
                        }
                        log.error(superTypeName + " supertype is not known in TypeDef cache");
                        this.throwContentManagerLogicError(sourceName, methodName, "getSuperTypes");
                        continue;
                    }
                    log.error("Corrupted TypeDef cache, no name for " + superTypeLink.toString());
                    this.throwContentManagerLogicError(sourceName, methodName, "getSuperTypes");
                }
                this.typeDefSuperTypes.put(typeName, typeHierarchy);
            } else {
                log.error(typeName + " type is not known in TypeDef cache");
                this.throwContentManagerLogicError(sourceName, methodName, "getSuperTypes");
            }
        }
        if (typeHierarchy.isEmpty()) {
            return null;
        }
        return typeHierarchy;
    }

    public boolean isTypeOf(String sourceName, String actualTypeName, String expectedTypeName) {
        String methodName = "isTypeOf";
        log.debug("IsTypeOf: sourceName = " + sourceName + "; actualTypeName = " + actualTypeName + "; expectedTypeName = " + expectedTypeName);
        if (expectedTypeName != null && actualTypeName != null) {
            if (actualTypeName.equals(expectedTypeName)) {
                log.debug("Simple match success");
                return true;
            }
            List<TypeDefLink> typeHierarchy = this.getSuperTypes(sourceName, actualTypeName, "isTypeOf");
            if (typeHierarchy != null) {
                for (TypeDefLink superType : typeHierarchy) {
                    if (superType == null) continue;
                    if (expectedTypeName.equals(superType.getName())) {
                        log.debug("SuperType match success");
                        return true;
                    }
                    log.debug("No match with " + superType.getName());
                }
            }
        }
        return false;
    }

    boolean isTypeOfByGUID(String sourceName, String actualTypeGUID, String actualTypeName, String expectedTypeGUID) {
        String methodName = "isTypeOfByGUID";
        log.debug("IsTypeOfByGUID: sourceName = " + sourceName + "; actualTypeName = " + actualTypeName + "; expectedTypeGUID = " + expectedTypeGUID);
        if (expectedTypeGUID != null && actualTypeGUID != null) {
            if (actualTypeGUID.equals(expectedTypeGUID)) {
                log.debug("Simple match success");
                return true;
            }
            List<TypeDefLink> typeHierarchy = this.getSuperTypes(sourceName, actualTypeName, "isTypeOfByGUID");
            if (typeHierarchy != null) {
                for (TypeDefLink superType : typeHierarchy) {
                    if (superType == null) continue;
                    if (expectedTypeGUID.equals(superType.getGUID())) {
                        log.debug("SuperType match success");
                        return true;
                    }
                    log.debug("No match with " + superType.getGUID());
                }
            }
        }
        return false;
    }

    @Override
    public InstanceType getInstanceType(String sourceName, TypeDefCategory category, String typeName, String methodName) throws TypeErrorException {
        String thisMethodName = "getInstanceType";
        if (this.isValidTypeCategory(sourceName, category, typeName, methodName)) {
            InstanceType instanceType = this.knownInstanceTypes.get(typeName);
            if (instanceType != null) {
                return instanceType;
            }
            TypeDef typeDef = this.knownTypeDefNames.get(typeName);
            if (typeDef != null) {
                instanceType = new InstanceType();
                instanceType.setTypeDefCategory(category);
                instanceType.setTypeDefGUID(typeDef.getGUID());
                instanceType.setTypeDefName(typeDef.getName());
                instanceType.setTypeDefVersion(typeDef.getVersion());
                instanceType.setTypeDefDescription(typeDef.getDescription());
                instanceType.setTypeDefDescriptionGUID(typeDef.getDescriptionGUID());
                instanceType.setTypeDefSuperTypes(this.getSuperTypes(sourceName, typeName, methodName));
                List<String> propertyNames = this.getPropertyNames(sourceName, typeDef);
                if (propertyNames == null) {
                    propertyNames = new ArrayList<String>();
                }
                TypeDefLink superTypeLink = typeDef.getSuperType();
                while (superTypeLink != null) {
                    String superTypeName = superTypeLink.getName();
                    if (superTypeName != null) {
                        log.debug(typeName + " from " + sourceName + " has super type " + superTypeName);
                        TypeDef superTypeDef = this.knownTypeDefNames.get(superTypeName);
                        if (superTypeDef != null) {
                            List<String> superTypePropertyNames = this.getPropertyNames(sourceName, superTypeDef);
                            if (superTypePropertyNames != null) {
                                propertyNames.addAll(0, superTypePropertyNames);
                            }
                            superTypeLink = superTypeDef.getSuperType();
                            continue;
                        }
                        log.error(superTypeName + " is not known");
                        this.throwContentManagerLogicError(sourceName, methodName, "getInstanceType");
                        continue;
                    }
                    log.error("Corrupted TypeDef cache");
                    this.throwContentManagerLogicError(sourceName, methodName, "getInstanceType");
                }
                if (propertyNames.size() > 0) {
                    instanceType.setValidInstanceProperties(propertyNames);
                }
                this.knownInstanceTypes.put(typeName, instanceType);
                return instanceType;
            }
        } else {
            OMRSErrorCode errorCode = OMRSErrorCode.BAD_CATEGORY_FOR_TYPEDEF_ATTRIBUTE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{sourceName, typeName, category.getName()});
            throw new TypeErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        log.error("TypeDef " + typeName + " should already have been validated");
        this.throwContentManagerLogicError(sourceName, methodName, "getInstanceType");
        return null;
    }

    @Override
    public boolean isValidTypeCategory(String sourceName, TypeDefCategory category, String typeName, String methodName) throws TypeErrorException {
        String thisMethodName = "isValidTypeCategory";
        if (category == null) {
            this.throwContentManagerLogicError(sourceName, methodName, "isValidTypeCategory");
            return false;
        }
        if (typeName == null) {
            this.throwContentManagerLogicError(sourceName, methodName, "isValidTypeCategory");
            return false;
        }
        TypeDef typeDef = this.knownTypeDefNames.get(typeName);
        if (typeDef != null) {
            TypeDefCategory retrievedTypeDefCategory = typeDef.getCategory();
            if (retrievedTypeDefCategory != null) {
                return category.getOrdinal() == retrievedTypeDefCategory.getOrdinal();
            }
        } else {
            OMRSErrorCode errorCode = OMRSErrorCode.TYPEDEF_NOT_KNOWN_FOR_INSTANCE;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{typeName, category.getName(), methodName, sourceName});
            throw new TypeErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        this.throwContentManagerLogicError(sourceName, methodName, "isValidTypeCategory");
        return false;
    }

    @Override
    public boolean isValidClassificationForEntity(String sourceName, String classificationTypeName, String entityTypeName, String methodName) {
        String thisMethodName = "isValidClassificationForEntity";
        try {
            if (this.isValidTypeCategory(sourceName, TypeDefCategory.CLASSIFICATION_DEF, classificationTypeName, methodName) && this.isValidTypeCategory(sourceName, TypeDefCategory.ENTITY_DEF, entityTypeName, methodName)) {
                ClassificationDef classificationTypeDef = (ClassificationDef)this.knownTypeDefNames.get(classificationTypeName);
                if (classificationTypeDef != null) {
                    List entityDefs = classificationTypeDef.getValidEntityDefs();
                    if (entityDefs == null || entityDefs.isEmpty()) {
                        return true;
                    }
                    HashSet<String> entityTypes = new HashSet<String>();
                    TypeDef typeDef = this.getTypeDefByName("isValidClassificationForEntity", entityTypeName);
                    entityTypes.add(entityTypeName);
                    while (typeDef.getSuperType() != null) {
                        TypeDefLink superTypeLink = typeDef.getSuperType();
                        String parentName = superTypeLink.getName();
                        entityTypes.add(parentName);
                        typeDef = this.knownTypeDefGUIDs.get(superTypeLink.getGUID());
                    }
                    for (TypeDefLink allowedEntityDefLink : entityDefs) {
                        String allowedTypeName;
                        if (allowedEntityDefLink == null || !entityTypes.contains(allowedTypeName = allowedEntityDefLink.getName())) continue;
                        return true;
                    }
                    return false;
                }
                this.throwContentManagerLogicError(sourceName, methodName, "isValidClassificationForEntity");
                return false;
            }
            return false;
        }
        catch (ClassCastException | TypeErrorException typeError) {
            this.throwContentManagerLogicError(sourceName, methodName, "isValidClassificationForEntity");
            return false;
        }
    }

    private TypeDef getTypeDefFromCache(String sourceName, String typeName, String thisMethodName, String originalMethodName) throws TypeErrorException {
        TypeDef typeDef;
        if (typeName == null) {
            this.throwContentManagerLogicError(sourceName, thisMethodName, originalMethodName);
        }
        if ((typeDef = this.knownTypeDefNames.get(typeName)) == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.TYPEDEF_NAME_NOT_KNOWN;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{typeName, originalMethodName, sourceName});
            throw new TypeErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), originalMethodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return typeDef;
    }

    public List<InstanceStatus> getValidStatusList(String sourceName, String typeName, String methodName) throws TypeErrorException {
        String thisMethodName = "validStatusList";
        TypeDef typeDef = this.getTypeDefFromCache(sourceName, typeName, "validStatusList", methodName);
        return typeDef.getValidInstanceStatusList();
    }

    @Override
    public InstanceStatus getInitialStatus(String sourceName, String typeName, String methodName) throws TypeErrorException {
        String thisMethodName = "getInitialStatus";
        TypeDef typeDef = this.getTypeDefFromCache(sourceName, typeName, "getInitialStatus", methodName);
        return typeDef.getInitialStatus();
    }

    @Override
    public String getEntityURL(String sourceName, String guid) {
        return OMRSRepositoryRESTServices.getEntityURL(this.localServerName, guid);
    }

    @Override
    public String getRelationshipURL(String sourceName, String guid) {
        return OMRSRepositoryRESTServices.getRelationshipURL(this.localServerName, guid);
    }

    public TypeDefGallery getActiveTypeDefGallery() {
        TypeDefGallery typeDefGallery = new TypeDefGallery();
        if (!this.activeAttributeTypeDefNames.isEmpty()) {
            typeDefGallery.setAttributeTypeDefs(new ArrayList<AttributeTypeDef>(this.activeAttributeTypeDefNames.values()));
        }
        if (!this.activeTypeDefNames.isEmpty()) {
            typeDefGallery.setTypeDefs(new ArrayList<TypeDef>(this.activeTypeDefNames.values()));
        }
        return typeDefGallery;
    }

    List<TypeDef> getActiveTypeDefs() {
        ArrayList<TypeDef> results = null;
        if (!this.activeTypeDefGUIDs.isEmpty()) {
            results = new ArrayList<TypeDef>(this.activeTypeDefGUIDs.values());
        }
        return results;
    }

    List<AttributeTypeDef> getActiveAttributeTypeDefs() {
        ArrayList<AttributeTypeDef> results = null;
        if (!this.activeAttributeTypeDefGUIDs.isEmpty()) {
            results = new ArrayList<AttributeTypeDef>(this.activeAttributeTypeDefGUIDs.values());
        }
        return results;
    }

    public TypeDefGallery getKnownTypeDefGallery() {
        TypeDefGallery typeDefGallery = new TypeDefGallery();
        if (!this.knownAttributeTypeDefNames.isEmpty()) {
            typeDefGallery.setAttributeTypeDefs(new ArrayList<AttributeTypeDef>(this.knownAttributeTypeDefNames.values()));
        }
        if (!this.knownTypeDefNames.isEmpty()) {
            typeDefGallery.setTypeDefs(new ArrayList<TypeDef>(this.knownTypeDefNames.values()));
        }
        return typeDefGallery;
    }

    List<TypeDef> getKnownTypeDefs() {
        ArrayList<TypeDef> results = null;
        if (!this.activeTypeDefGUIDs.isEmpty()) {
            results = new ArrayList<TypeDef>(this.activeTypeDefGUIDs.values());
        }
        return results;
    }

    List<AttributeTypeDef> getKnownAttributeTypeDefs() {
        ArrayList<AttributeTypeDef> results = null;
        if (!this.activeAttributeTypeDefGUIDs.isEmpty()) {
            results = new ArrayList<AttributeTypeDef>(this.activeAttributeTypeDefGUIDs.values());
        }
        return results;
    }

    public TypeDef getTypeDefByName(String sourceName, String typeDefName) {
        return this.knownTypeDefNames.get(typeDefName);
    }

    public AttributeTypeDef getAttributeTypeDefByName(String sourceName, String attributeTypeDefName) {
        return this.knownAttributeTypeDefNames.get(attributeTypeDefName);
    }

    public TypeDef getTypeDef(String sourceName, String guidParameterName, String typeDefGUID, String methodName) throws TypeErrorException {
        String thisMethodName = "getTypeDef";
        if (typeDefGUID != null) {
            TypeDef typeDef = this.knownTypeDefGUIDs.get(typeDefGUID);
            if (typeDef == null) {
                OMRSErrorCode errorCode = OMRSErrorCode.TYPEDEF_ID_NOT_KNOWN;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{typeDefGUID, guidParameterName, methodName, sourceName});
                throw new TypeErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            return typeDef;
        }
        this.throwContentManagerLogicError(sourceName, methodName, "getTypeDef");
        return null;
    }

    public AttributeTypeDef getAttributeTypeDef(String sourceName, String attributeTypeDefGUID, String methodName) throws TypeErrorException {
        String thisMethodName = "getAttributeTypeDef";
        if (attributeTypeDefGUID != null) {
            AttributeTypeDef attributeTypeDef = this.knownAttributeTypeDefGUIDs.get(attributeTypeDefGUID);
            if (attributeTypeDef == null) {
                OMRSErrorCode errorCode = OMRSErrorCode.BAD_TYPEDEF;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{sourceName});
                throw new TypeErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            return attributeTypeDef;
        }
        this.throwContentManagerLogicError(sourceName, methodName, "getAttributeTypeDef");
        return null;
    }

    public TypeDef getTypeDef(String sourceName, String guidParameterName, String nameParameterName, String typeDefGUID, String typeDefName, String methodName) throws TypeErrorException {
        if (this.validTypeId(sourceName, typeDefGUID, typeDefName)) {
            return this.knownTypeDefNames.get(typeDefName);
        }
        OMRSErrorCode errorCode = OMRSErrorCode.BAD_TYPEDEF;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{sourceName});
        throw new TypeErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public AttributeTypeDef getAttributeTypeDef(String sourceName, String attributeTypeDefGUID, String attributeTypeDefName, String methodName) throws TypeErrorException {
        if (this.validTypeId(sourceName, attributeTypeDefGUID, attributeTypeDefName)) {
            return this.knownAttributeTypeDefNames.get(attributeTypeDefName);
        }
        OMRSErrorCode errorCode = OMRSErrorCode.BAD_TYPEDEF;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{sourceName});
        throw new TypeErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public List<TypeDefAttribute> getAllPropertiesForTypeDef(String sourceName, TypeDef typeDef, String methodName) {
        ArrayList<TypeDefAttribute> propertiesDefinition;
        String thisMethodName = "getAllPropertiesForTypeDef";
        if (typeDef == null) {
            this.throwContentManagerLogicError(sourceName, methodName, "getAllPropertiesForTypeDef");
        }
        if ((propertiesDefinition = typeDef.getPropertiesDefinition()) == null) {
            propertiesDefinition = new ArrayList<TypeDefAttribute>();
        }
        TypeDefLink superTypeLink = typeDef.getSuperType();
        while (superTypeLink != null) {
            TypeDef superTypeDef = this.knownTypeDefGUIDs.get(superTypeLink.getGUID());
            List superTypePropertiesDefinition = superTypeDef.getPropertiesDefinition();
            if (superTypePropertiesDefinition != null) {
                propertiesDefinition.addAll(superTypePropertiesDefinition);
            }
            superTypeLink = superTypeDef.getSuperType();
        }
        return propertiesDefinition;
    }

    public void validateEnterpriseTypeDefs(String sourceName, List<TypeDef> typeDefs, String methodName) throws RepositoryErrorException {
        for (TypeDef typeDef : typeDefs) {
            if (this.validTypeId(sourceName, typeDef.getGUID(), typeDef.getName())) {
                if (this.isKnownType(sourceName, typeDef.getGUID(), typeDef.getName())) continue;
                this.knownTypeDefNames.put(typeDef.getName(), typeDef);
                continue;
            }
            OMRSErrorCode errorCode = OMRSErrorCode.CONFLICTING_ENTERPRISE_TYPEDEFS;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[0]);
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public void validateEnterpriseAttributeTypeDefs(String sourceName, List<AttributeTypeDef> attributeTypeDefs, String methodName) throws RepositoryErrorException {
        for (AttributeTypeDef attributeTypeDef : attributeTypeDefs) {
            if (this.validTypeId(sourceName, attributeTypeDef.getGUID(), attributeTypeDef.getName())) {
                if (this.isKnownType(sourceName, attributeTypeDef.getGUID(), attributeTypeDef.getName())) continue;
                this.knownAttributeTypeDefNames.put(attributeTypeDef.getName(), attributeTypeDef);
                continue;
            }
            OMRSErrorCode errorCode = OMRSErrorCode.CONFLICTING_ENTERPRISE_TYPEDEFS;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[0]);
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public boolean isOpenType(String sourceName, String typeGUID, String typeName) {
        if (this.validTypeId(sourceName, typeGUID, typeName)) {
            TypeDef typeDef = this.knownTypeDefNames.get(typeName);
            if (typeDef == null) {
                return false;
            }
            if (this.openTypesOriginGUID != null) {
                if (this.openTypesOriginGUID.equals(typeDef.getOrigin())) {
                    log.debug("TypeDef " + typeName + " (GUID = " + typeGUID + ") from " + sourceName + " is an open type");
                    return true;
                }
                log.debug("TypeDef " + typeName + " (GUID = " + typeGUID + ") from " + sourceName + " is NOT an open type");
            }
        }
        return false;
    }

    public boolean isOpenTypeId(String sourceName, String typeGUID) {
        String originGUID;
        TypeDef typeDef;
        return typeGUID != null && (typeDef = this.knownTypeDefGUIDs.get(typeGUID)) != null && (originGUID = typeDef.getOrigin()) != null && originGUID.equals(this.openTypesOriginGUID);
    }

    public boolean isKnownType(String sourceName, String typeGUID, String typeName) {
        if (this.validTypeId(sourceName, typeGUID, typeName)) {
            TypeDef typeDef = this.knownTypeDefNames.get(typeName);
            if (typeDef == null) {
                AttributeTypeDef attributeTypeDef = this.knownAttributeTypeDefNames.get(typeName);
                if (attributeTypeDef == null) {
                    log.debug("Unknown (Attribute)TypeDef " + typeName + " (GUID = " + typeGUID + ") from " + sourceName);
                    return false;
                }
                log.debug("Known AttributeTypeDef " + typeName + " (GUID = " + typeGUID + ") from " + sourceName);
                return true;
            }
            log.debug("Known TypeDef " + typeName + " (GUID = " + typeGUID + ") from " + sourceName);
            return true;
        }
        log.error("Invalid TypeDef  from " + sourceName + " so can not validate known type");
        return false;
    }

    public boolean isKnownTypeId(String sourceName, String typeGUID) {
        if (typeGUID != null) {
            if (this.knownTypeDefGUIDs.get(typeGUID) != null) {
                return true;
            }
            if (this.knownAttributeTypeDefGUIDs.get(typeGUID) != null) {
                return true;
            }
        }
        return false;
    }

    public boolean isActiveType(String sourceName, String typeGUID, String typeName) {
        if (this.validTypeId(sourceName, typeGUID, typeName)) {
            TypeDef typeDef = this.activeTypeDefNames.get(typeName);
            if (typeDef == null) {
                AttributeTypeDef attributeTypeDef = this.activeAttributeTypeDefNames.get(typeName);
                if (attributeTypeDef == null) {
                    log.debug("Inactive (Attribute)TypeDef " + typeName + " (GUID = " + typeGUID + ") from " + sourceName);
                    return false;
                }
                log.debug("Active AttributeTypeDef " + typeName + " (GUID = " + typeGUID + ") from " + sourceName);
                return true;
            }
            log.debug("Active TypeDef " + typeName + " (GUID = " + typeGUID + ") from " + sourceName);
            return true;
        }
        log.error("Invalid TypeDef  from " + sourceName + " so can not validate active type");
        return false;
    }

    public boolean isActiveTypeId(String sourceName, String typeGUID) {
        if (typeGUID != null) {
            if (this.activeTypeDefGUIDs.get(typeGUID) != null) {
                return true;
            }
            if (this.activeAttributeTypeDefGUIDs.get(typeGUID) != null) {
                return true;
            }
        }
        return false;
    }

    public boolean validTypeId(String sourceName, String typeGUID, String typeName) {
        if (typeName == null) {
            log.error("Null TypeDef Name from " + sourceName);
            return false;
        }
        if (typeGUID == null) {
            log.error("Null TypeDef GUID from " + sourceName);
            return false;
        }
        TypeDef typeDef = this.knownTypeDefNames.get(typeName);
        if (typeDef == null) {
            AttributeTypeDef attributeTypeDef = this.knownAttributeTypeDefNames.get(typeName);
            if (attributeTypeDef != null) {
                if (!typeGUID.equals(attributeTypeDef.getGUID())) {
                    log.error("GUID Mismatch in AttributeTypeDef " + typeName + " from " + sourceName + " received GUID is " + typeGUID + "; stored GUID is " + attributeTypeDef.getGUID());
                    return false;
                }
                log.debug("Valid AttributeTypeDef from " + sourceName);
                return true;
            }
            log.debug("Unknown (Attribute)TypeDef from " + sourceName);
            log.debug("Valid AttributeTypeDef from " + sourceName);
            return true;
        }
        if (!typeGUID.equals(typeDef.getGUID())) {
            log.error("GUID Mismatch in TypeDef " + typeName + " from " + sourceName + " received GUID is " + typeGUID + "; stored GUID is " + typeDef.getGUID());
            return false;
        }
        return true;
    }

    public boolean validTypeDefId(String sourceName, String typeDefGUID, String typeDefName, TypeDefCategory category) {
        if (!this.validTypeId(sourceName, typeDefGUID, typeDefName)) {
            return false;
        }
        TypeDef typeDef = this.knownTypeDefNames.get(typeDefName);
        if (typeDef != null) {
            TypeDefCategory knownTypeDefCategory = typeDef.getCategory();
            if (knownTypeDefCategory == null) {
                log.error("Unknown TypeDef Category for " + typeDefName + " (GUID = " + typeDefGUID + ") from " + sourceName);
                return false;
            }
            if (category.getOrdinal() != knownTypeDefCategory.getOrdinal()) {
                log.error("TypeDef category mismatch for TypeDef " + typeDefName + " (GUID = " + typeDefGUID + ") from " + sourceName + " received version number is " + category.getDescription() + " and stored category is " + knownTypeDefCategory.getDescription());
                return false;
            }
        }
        return true;
    }

    public boolean validAttributeTypeDefId(String sourceName, String attributeTypeDefGUID, String attributeTypeDefName, AttributeTypeDefCategory category) {
        if (!this.validTypeId(sourceName, attributeTypeDefGUID, attributeTypeDefName)) {
            return false;
        }
        AttributeTypeDef attributeTypeDef = this.knownAttributeTypeDefNames.get(attributeTypeDefName);
        if (attributeTypeDef != null) {
            AttributeTypeDefCategory knownAttributeTypeDefCategory = attributeTypeDef.getCategory();
            if (knownAttributeTypeDefCategory == null) {
                log.error("Unknown AttributeTypeDef Category for " + attributeTypeDefName + " (GUID = " + attributeTypeDefGUID + ") from " + sourceName);
                return false;
            }
            if (category.getOrdinal() != knownAttributeTypeDefCategory.getOrdinal()) {
                log.error("TypeDef category mismatch for TypeDef " + attributeTypeDefName + " (GUID = " + attributeTypeDefGUID + ") from " + sourceName + " received version number is " + category.getDescription() + " and stored category is " + knownAttributeTypeDefCategory.getDescription());
                return false;
            }
        }
        return true;
    }

    public boolean validTypeDefId(String sourceName, String typeDefGUID, String typeDefName, long typeDefVersion, TypeDefCategory typeDefCategory) {
        if (!this.validTypeDefId(sourceName, typeDefGUID, typeDefName, typeDefCategory)) {
            return false;
        }
        TypeDef typeDef = this.knownTypeDefNames.get(typeDefName);
        if (typeDef == null) {
            log.debug("Unknown TypeDef " + typeDefName + " (GUID = " + typeDefGUID + ") from " + sourceName);
            return true;
        }
        if (typeDef.getVersion() != typeDefVersion) {
            log.error("Version mismatch for TypeDef " + typeDefName + " (GUID = " + typeDefGUID + ") from " + sourceName + " received version number is " + Long.toString(typeDefVersion) + " and stored version is " + Long.toString(typeDef.getVersion()));
            return false;
        }
        return true;
    }

    public boolean validAttributeTypeDefId(String sourceName, String attributeTypeDefGUID, String attributeTypeDefName, long attributeTypeDefVersion, AttributeTypeDefCategory category) {
        if (!this.validAttributeTypeDefId(sourceName, attributeTypeDefGUID, attributeTypeDefName, category)) {
            return false;
        }
        TypeDef typeDef = this.knownTypeDefNames.get(attributeTypeDefName);
        if (typeDef == null) {
            log.debug("Unknown TypeDef " + attributeTypeDefName + " (GUID = " + attributeTypeDefGUID + ") from " + sourceName);
            return true;
        }
        if (typeDef.getVersion() != attributeTypeDefVersion) {
            log.error("Version mismatch for TypeDef " + attributeTypeDefName + " (GUID = " + attributeTypeDefGUID + ") from " + sourceName + " received version number is " + Long.toString(attributeTypeDefVersion) + " and stored version is " + Long.toString(typeDef.getVersion()));
            return false;
        }
        return true;
    }

    public boolean validTypeDef(String sourceName, TypeDef typeDef) {
        if (typeDef == null) {
            log.error("Null typeDef from " + sourceName);
            return false;
        }
        if (this.validTypeDefId(sourceName, typeDef.getGUID(), typeDef.getName(), typeDef.getVersion(), typeDef.getCategory())) {
            log.debug("Good typeDef from " + sourceName);
            return true;
        }
        log.error("Bad typeDef from " + sourceName);
        return false;
    }

    public boolean validAttributeTypeDef(String sourceName, AttributeTypeDef attributeTypeDef) {
        if (attributeTypeDef == null) {
            log.error("Null attributeTypeDef from " + sourceName);
            return false;
        }
        if (this.validAttributeTypeDefId(sourceName, attributeTypeDef.getGUID(), attributeTypeDef.getName(), attributeTypeDef.getCategory())) {
            log.debug("Good attributeTypeDef from " + sourceName);
            return true;
        }
        log.error("Bad attributeTypeDef from " + sourceName);
        return false;
    }

    public boolean validTypeDefSummary(String sourceName, TypeDefSummary typeDefSummary) {
        if (typeDefSummary != null) {
            if (this.validTypeDefId(sourceName, typeDefSummary.getGUID(), typeDefSummary.getName(), typeDefSummary.getVersion(), typeDefSummary.getCategory())) {
                return true;
            }
            log.error("Bad typeDefSummary from " + sourceName);
        }
        log.error("Null typeDefSummary from " + sourceName);
        return false;
    }

    public void sendTypeDefEvent(String cohortName, OMRSTypeDefEvent typeDefEvent) {
        OMRSTypeDefEventType typeDefEventType = typeDefEvent.getTypeDefEventType();
        OMRSEventOriginator typeDefEventOriginator = typeDefEvent.getEventOriginator();
        if (typeDefEventType != null && typeDefEventOriginator != null) {
            block0 : switch (typeDefEventType) {
                case NEW_TYPEDEF_EVENT: {
                    this.processNewTypeDefEvent(cohortName, typeDefEventOriginator.getMetadataCollectionId(), typeDefEventOriginator.getServerName(), typeDefEventOriginator.getServerType(), typeDefEventOriginator.getOrganizationName(), typeDefEvent.getTypeDef());
                    break;
                }
                case NEW_ATTRIBUTE_TYPEDEF_EVENT: {
                    this.processNewAttributeTypeDefEvent(cohortName, typeDefEventOriginator.getMetadataCollectionId(), typeDefEventOriginator.getServerName(), typeDefEventOriginator.getServerType(), typeDefEventOriginator.getOrganizationName(), typeDefEvent.getAttributeTypeDef());
                    break;
                }
                case UPDATED_TYPEDEF_EVENT: {
                    this.processUpdatedTypeDefEvent(cohortName, typeDefEventOriginator.getMetadataCollectionId(), typeDefEventOriginator.getServerName(), typeDefEventOriginator.getServerType(), typeDefEventOriginator.getOrganizationName(), typeDefEvent.getTypeDefPatch());
                    break;
                }
                case DELETED_TYPEDEF_EVENT: {
                    this.processDeletedTypeDefEvent(cohortName, typeDefEventOriginator.getMetadataCollectionId(), typeDefEventOriginator.getServerName(), typeDefEventOriginator.getServerType(), typeDefEventOriginator.getOrganizationName(), typeDefEvent.getTypeDefGUID(), typeDefEvent.getTypeDefName());
                    break;
                }
                case DELETED_ATTRIBUTE_TYPEDEF_EVENT: {
                    this.processDeletedAttributeTypeDefEvent(cohortName, typeDefEventOriginator.getMetadataCollectionId(), typeDefEventOriginator.getServerName(), typeDefEventOriginator.getServerType(), typeDefEventOriginator.getOrganizationName(), typeDefEvent.getTypeDefGUID(), typeDefEvent.getTypeDefName());
                    break;
                }
                case RE_IDENTIFIED_TYPEDEF_EVENT: {
                    this.processReIdentifiedTypeDefEvent(cohortName, typeDefEventOriginator.getMetadataCollectionId(), typeDefEventOriginator.getServerName(), typeDefEventOriginator.getServerType(), typeDefEventOriginator.getOrganizationName(), typeDefEvent.getOriginalTypeDefSummary(), typeDefEvent.getTypeDef());
                    break;
                }
                case RE_IDENTIFIED_ATTRIBUTE_TYPEDEF_EVENT: {
                    this.processReIdentifiedAttributeTypeDefEvent(cohortName, typeDefEventOriginator.getMetadataCollectionId(), typeDefEventOriginator.getServerName(), typeDefEventOriginator.getServerType(), typeDefEventOriginator.getOrganizationName(), typeDefEvent.getOriginalAttributeTypeDef(), typeDefEvent.getAttributeTypeDef());
                }
                case TYPEDEF_ERROR_EVENT: {
                    OMRSTypeDefEventErrorCode errorCode = typeDefEvent.getErrorCode();
                    if (errorCode != null) {
                        switch (errorCode) {
                            case CONFLICTING_TYPEDEFS: {
                                this.processTypeDefConflictEvent(cohortName, typeDefEventOriginator.getMetadataCollectionId(), typeDefEventOriginator.getServerName(), typeDefEventOriginator.getServerType(), typeDefEventOriginator.getOrganizationName(), typeDefEvent.getOriginalTypeDefSummary(), typeDefEvent.getOtherMetadataCollectionId(), typeDefEvent.getOtherTypeDefSummary(), typeDefEvent.getErrorMessage());
                                break block0;
                            }
                            case CONFLICTING_ATTRIBUTE_TYPEDEFS: {
                                this.processAttributeTypeDefConflictEvent(cohortName, typeDefEventOriginator.getMetadataCollectionId(), typeDefEventOriginator.getServerName(), typeDefEventOriginator.getServerType(), typeDefEventOriginator.getOrganizationName(), typeDefEvent.getOriginalAttributeTypeDef(), typeDefEvent.getOtherMetadataCollectionId(), typeDefEvent.getOtherAttributeTypeDef(), typeDefEvent.getErrorMessage());
                            }
                            case TYPEDEF_PATCH_MISMATCH: {
                                this.processTypeDefPatchMismatchEvent(cohortName, typeDefEventOriginator.getMetadataCollectionId(), typeDefEventOriginator.getServerName(), typeDefEventOriginator.getServerType(), typeDefEventOriginator.getOrganizationName(), typeDefEvent.getTargetMetadataCollectionId(), typeDefEvent.getTargetTypeDefSummary(), typeDefEvent.getOtherTypeDef(), typeDefEvent.getErrorMessage());
                                break block0;
                            }
                        }
                        log.debug("Unknown TypeDef event error code; ignoring event");
                        break;
                    }
                    log.debug("Ignored TypeDef event; null error code");
                    break;
                }
                default: {
                    log.debug("Ignored TypeDef event; unknown type");
                }
            }
        }
    }

    public void processNewTypeDefEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDef typeDef) {
        String actionDescription = "Process New TypeDef Event";
        OMRSMetadataCollection metadataCollection = null;
        try {
            if (this.localRepositoryConnector != null) {
                metadataCollection = this.localRepositoryConnector.getMetadataCollection();
            }
            if (metadataCollection != null) {
                if (!metadataCollection.verifyTypeDef(sourceName, typeDef)) {
                    metadataCollection.addTypeDef(sourceName, typeDef);
                    OMRSAuditCode auditCode = OMRSAuditCode.NEW_TYPE_ADDED;
                    this.auditLog.logRecord("Process New TypeDef Event", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{typeDef.getName(), typeDef.getGUID(), Long.toString(typeDef.getVersion()), sourceName}), null, auditCode.getSystemAction(), auditCode.getUserAction());
                }
                this.cacheTypeDef(sourceName, typeDef, true);
            } else {
                this.cacheTypeDef(sourceName, typeDef, false);
            }
        }
        catch (TypeDefNotSupportedException fixedTypeSystemResponse) {
            this.cacheTypeDef(sourceName, typeDef, false);
            OMRSAuditCode auditCode = OMRSAuditCode.NEW_TYPE_NOT_SUPPORTED;
            this.auditLog.logRecord("Process New TypeDef Event", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{typeDef.getName(), typeDef.getGUID(), Long.toString(typeDef.getVersion())}), null, auditCode.getSystemAction(), auditCode.getUserAction());
            log.debug("TypeDef not added because repository does not support dynamic type definitions: " + typeDef);
            log.debug("TypeDefNotSupportedException:", (Throwable)fixedTypeSystemResponse);
        }
        catch (RepositoryErrorException error) {
            this.cacheTypeDef(sourceName, typeDef, false);
            log.error("TypeDef " + typeDef.getName() + " not added because repository is not available: " + typeDef);
            log.error("RepositoryErrorException:", (Throwable)error);
        }
        catch (TypeDefConflictException error) {
            log.error("TypeDef not added because it conflicts with another TypeDef already in the repository: " + typeDef);
            log.error("TypeDefConflictException:", (Throwable)error);
            this.outboundRepositoryEventManager.processTypeDefConflictEvent(sourceName, this.localRepositoryConnector.getMetadataCollectionId(), this.localRepositoryConnector.getLocalServerName(), this.localRepositoryConnector.getLocalServerType(), this.localRepositoryConnector.getOrganizationName(), (TypeDefSummary)typeDef, originatorMetadataCollectionId, (TypeDefSummary)this.knownTypeDefNames.get(typeDef.getName()), null);
        }
        catch (InvalidTypeDefException error) {
            log.error("TypeDef not added because repository thinks it is invalid: " + typeDef);
            log.error("InvalidTypeDefException: ", (Throwable)error);
        }
        catch (TypeDefKnownException error) {
            log.error("TypeDef not added because repository has a logic error: " + typeDef);
            log.error("TypeDefKnownException: ", (Throwable)error);
        }
        catch (Throwable error) {
            log.error("TypeDef not added because repository has an unexpected error: " + typeDef);
            log.error("Throwable: ", error);
        }
    }

    public void processNewAttributeTypeDefEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, AttributeTypeDef attributeTypeDef) {
        String actionDescription = "Process New TypeDef Event";
        OMRSMetadataCollection metadataCollection = null;
        try {
            if (this.localRepositoryConnector != null) {
                metadataCollection = this.localRepositoryConnector.getMetadataCollection();
            }
            if (metadataCollection != null) {
                if (!metadataCollection.verifyAttributeTypeDef(sourceName, attributeTypeDef)) {
                    metadataCollection.addAttributeTypeDef(sourceName, attributeTypeDef);
                    this.activeAttributeTypeDefNames.put(attributeTypeDef.getName(), attributeTypeDef);
                    OMRSAuditCode auditCode = OMRSAuditCode.NEW_TYPE_ADDED;
                    this.auditLog.logRecord("Process New TypeDef Event", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{attributeTypeDef.getName(), attributeTypeDef.getGUID(), Long.toString(attributeTypeDef.getVersion()), sourceName}), null, auditCode.getSystemAction(), auditCode.getUserAction());
                }
                this.cacheAttributeTypeDef(sourceName, attributeTypeDef, true);
            } else {
                this.cacheAttributeTypeDef(sourceName, attributeTypeDef, false);
            }
        }
        catch (TypeDefNotSupportedException fixedTypeSystemResponse) {
            this.cacheAttributeTypeDef(sourceName, attributeTypeDef, false);
            OMRSAuditCode auditCode = OMRSAuditCode.NEW_TYPE_NOT_SUPPORTED;
            this.auditLog.logRecord("Process New TypeDef Event", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{attributeTypeDef.getName(), attributeTypeDef.getGUID(), Long.toString(attributeTypeDef.getVersion())}), null, auditCode.getSystemAction(), auditCode.getUserAction());
            log.debug("TypeDef not added because repository does not support dynamic type definitions: " + attributeTypeDef);
            log.debug("TypeDefNotSupportedException:", (Throwable)fixedTypeSystemResponse);
        }
        catch (RepositoryErrorException error) {
            this.cacheAttributeTypeDef(sourceName, attributeTypeDef, false);
            log.error("TypeDef " + attributeTypeDef.getName() + " not added because repository is not available: " + attributeTypeDef);
            log.error("RepositoryErrorException:", (Throwable)error);
        }
        catch (TypeDefConflictException error) {
            log.error("TypeDef not added because it conflicts with another TypeDef already in the repository: " + attributeTypeDef);
            log.error("TypeDefConflictException:", (Throwable)error);
            this.outboundRepositoryEventManager.processAttributeTypeDefConflictEvent(sourceName, this.localRepositoryConnector.getMetadataCollectionId(), this.localRepositoryConnector.getLocalServerName(), this.localRepositoryConnector.getLocalServerType(), this.localRepositoryConnector.getOrganizationName(), attributeTypeDef, originatorMetadataCollectionId, this.knownAttributeTypeDefNames.get(attributeTypeDef.getName()), null);
        }
        catch (InvalidTypeDefException error) {
            log.error("TypeDef not added because repository thinks it is invalid: " + attributeTypeDef);
            log.error("InvalidTypeDefException: ", (Throwable)error);
        }
        catch (TypeDefKnownException error) {
            log.error("TypeDef not added because repository has a logic error: " + attributeTypeDef);
            log.error("TypeDefKnownException: ", (Throwable)error);
        }
        catch (Throwable error) {
            log.error("TypeDef not added because repository has an unexpected error: " + attributeTypeDef);
            log.error("Throwable: ", error);
        }
    }

    public void processUpdatedTypeDefEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDefPatch typeDefPatch) {
        block9: {
            try {
                OMRSMetadataCollection metadataCollection = this.localRepositoryConnector.getMetadataCollection();
                if (metadataCollection != null) {
                    TypeDef updatedTypeDef = metadataCollection.updateTypeDef(null, typeDefPatch);
                    log.debug("Patch successfully applied:" + updatedTypeDef);
                }
            }
            catch (RepositoryErrorException error) {
                if (log.isDebugEnabled()) {
                    log.debug("Patch not applied because repository is not available: " + typeDefPatch);
                }
            }
            catch (TypeDefNotKnownException error) {
                if (log.isDebugEnabled()) {
                    log.debug("Patch not applied because TypeDef does not exist: " + typeDefPatch);
                    log.debug("TypeDefNotKnownException: ", (Throwable)error);
                }
            }
            catch (PatchErrorException error) {
                if (log.isDebugEnabled()) {
                    log.debug("Patch not applied because it is invalid: " + typeDefPatch);
                    log.debug("PatchErrorException: ", (Throwable)error);
                }
            }
            catch (Throwable error) {
                if (!log.isDebugEnabled()) break block9;
                log.debug("Patch not applied because of an error " + typeDefPatch);
                log.debug("Throwable: ", error);
            }
        }
    }

    public void processDeletedTypeDefEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String typeDefGUID, String typeDefName) {
    }

    public void processDeletedAttributeTypeDefEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String attributeTypeDefGUID, String attributeTypeDefName) {
    }

    public void processReIdentifiedTypeDefEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDefSummary originalTypeDefSummary, TypeDef typeDef) {
    }

    public void processReIdentifiedAttributeTypeDefEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, AttributeTypeDef originalAttributeTypeDef, AttributeTypeDef attributeTypeDef) {
    }

    public void processTypeDefConflictEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, TypeDefSummary originatorTypeDefSummary, String otherMetadataCollectionId, TypeDefSummary conflictingTypeDefSummary, String errorMessage) {
    }

    public void processAttributeTypeDefConflictEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, AttributeTypeDef originatorAttributeTypeDef, String otherMetadataCollectionId, AttributeTypeDef conflictingAttributeTypeDef, String errorMessage) {
    }

    public void processTypeDefPatchMismatchEvent(String sourceName, String originatorMetadataCollectionId, String originatorServerName, String originatorServerType, String originatorOrganizationName, String targetMetadataCollectionId, TypeDefSummary targetTypeDefSummary, TypeDef otherTypeDef, String errorMessage) {
    }

    synchronized void registerMetadataCollection(String metadataCollectionId, String metadataCollectionName) {
        if (metadataCollectionId != null) {
            this.metadataCollectionNames.put(metadataCollectionId, metadataCollectionName);
        }
    }

    public synchronized String getMetadataCollectionName(String metadataCollectionId) {
        if (metadataCollectionId != null) {
            return this.metadataCollectionNames.get(metadataCollectionId);
        }
        return null;
    }

    private void throwContentManagerLogicError(String sourceName, String originatingMethodName, String localMethodName) {
        OMRSErrorCode errorCode = OMRSErrorCode.CONTENT_MANAGER_LOGIC_ERROR;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{sourceName, localMethodName, originatingMethodName});
        throw new OMRSLogicErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), localMethodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }
}

