/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.accumulators;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.EnterpriseOMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.enterprise.repositoryconnector.accumulators.QueryInstanceAccumulatorBase;

public class EntityAccumulator
extends QueryInstanceAccumulatorBase {
    private volatile Map<String, EntityDetail> accumulatedEntities = new HashMap<String, EntityDetail>();

    public EntityAccumulator(String localMetadataCollectionId, OMRSAuditLog auditLog, OMRSRepositoryValidator repositoryValidator) {
        super(localMetadataCollectionId, auditLog, repositoryValidator);
    }

    private void addEntity(EntityDetail incomingEntity, String metadataCollectionId) {
        if (incomingEntity != null && incomingEntity.getGUID() != null && metadataCollectionId != null) {
            String entityGUID = incomingEntity.getGUID();
            EntityDetail currentSavedEntity = this.accumulatedEntities.get(entityGUID);
            if (super.currentInstanceIsBest((InstanceHeader)currentSavedEntity, (InstanceHeader)incomingEntity)) {
                return;
            }
            this.accumulatedEntities.put(entityGUID, incomingEntity);
            if (metadataCollectionId.equals(this.localMetadataCollectionId)) {
                super.captureLocalInstance(entityGUID);
            }
        }
    }

    public synchronized void addEntities(List<EntityDetail> entities, String metadataCollectionId) {
        if (entities != null) {
            for (EntityDetail entity : entities) {
                this.addEntity(entity, metadataCollectionId);
            }
            super.setResultsReturned(metadataCollectionId, entities.size());
        } else {
            super.setResultsReturned(metadataCollectionId, 0);
        }
    }

    public synchronized List<EntityDetail> getResults(EnterpriseOMRSRepositoryConnector repositoryConnector) {
        if (this.accumulatedEntities.isEmpty()) {
            return null;
        }
        this.makeRefreshRecommendations(repositoryConnector);
        return new ArrayList<EntityDetail>(this.accumulatedEntities.values());
    }

    private void makeRefreshRecommendations(EnterpriseOMRSRepositoryConnector repositoryConnector) {
        if (this.localMetadataCollectionId == null || this.accumulatedEntities.isEmpty()) {
            return;
        }
        for (EntityDetail accumulatedEntity : this.accumulatedEntities.values()) {
            String entityGUID;
            if (accumulatedEntity == null || (entityGUID = accumulatedEntity.getGUID()) == null || !super.notLocal(entityGUID)) continue;
            repositoryConnector.requestRefreshOfEntity(accumulatedEntity);
        }
    }
}

