/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.rest.server;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import org.odpi.openmetadata.adminservices.configuration.registration.CommonServicesDescription;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditCode;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSCheckedExceptionBase;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.metadatahighway.OMRSMetadataHighwayManager;
import org.odpi.openmetadata.repositoryservices.rest.properties.CohortListResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.CohortMembershipListResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.CohortMembershipResponse;
import org.odpi.openmetadata.repositoryservices.rest.properties.OMRSAPIResponse;
import org.odpi.openmetadata.repositoryservices.rest.services.OMRSRepositoryServicesInstance;
import org.odpi.openmetadata.repositoryservices.rest.services.OMRSRepositoryServicesInstanceHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMRSMetadataHighwayRESTServices {
    private static final String serviceName = CommonServicesDescription.REPOSITORY_SERVICES.getServiceName();
    private static OMRSRepositoryServicesInstanceHandler instanceHandler = new OMRSRepositoryServicesInstanceHandler(serviceName);
    private static final Logger log = LoggerFactory.getLogger(OMRSMetadataHighwayRESTServices.class);

    public CohortListResponse getCohortList(String serverName, String userId) {
        String methodName = "getCohortList";
        log.debug("Calling method: getCohortList");
        CohortListResponse response = new CohortListResponse();
        try {
            OMRSMetadataHighwayManager metadataHighwayManager = this.getMetadataHighway(userId, serverName, "getCohortList");
            response.setCohorts(metadataHighwayManager.getCohortDescriptions());
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "getCohortList", instanceHandler.getAuditLog(userId, serverName, "getCohortList"));
        }
        log.debug("Returning from method: getCohortList with response: " + response.toString());
        return response;
    }

    public CohortMembershipResponse getLocalRegistration(String serverName, String userId) {
        String methodName = "getLocalRegistration";
        log.debug("Calling method: getLocalRegistration");
        CohortMembershipResponse response = new CohortMembershipResponse();
        try {
            OMRSMetadataHighwayManager metadataHighwayManager = this.getMetadataHighway(userId, serverName, "getLocalRegistration");
            response.setCohortMember(metadataHighwayManager.getLocalRegistration());
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "getLocalRegistration", instanceHandler.getAuditLog(userId, serverName, "getLocalRegistration"));
        }
        log.debug("Returning from method: getLocalRegistration with response: " + response.toString());
        return response;
    }

    public CohortMembershipResponse getLocalRegistration(String serverName, String userId, String cohortName) {
        String methodName = "getLocalRegistration (cohort version)";
        log.debug("Calling method: getLocalRegistration (cohort version)");
        CohortMembershipResponse response = new CohortMembershipResponse();
        try {
            OMRSMetadataHighwayManager metadataHighwayManager = this.getMetadataHighway(userId, serverName, "getLocalRegistration (cohort version)");
            response.setCohortMember(metadataHighwayManager.getLocalRegistration(cohortName));
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "getLocalRegistration (cohort version)", instanceHandler.getAuditLog(userId, serverName, "getLocalRegistration (cohort version)"));
        }
        log.debug("Returning from method: getLocalRegistration (cohort version) with response: " + response.toString());
        return response;
    }

    public CohortMembershipListResponse getRemoteRegistrations(String serverName, String userId, String cohortName) {
        String methodName = "getRemoteRegistrations";
        log.debug("Calling method: getRemoteRegistrations");
        CohortMembershipListResponse response = new CohortMembershipListResponse();
        try {
            OMRSMetadataHighwayManager metadataHighwayManager = this.getMetadataHighway(userId, serverName, "getRemoteRegistrations");
            response.setCohortMembers(metadataHighwayManager.getRemoteMembers(cohortName));
        }
        catch (InvalidParameterException error) {
            this.captureInvalidParameterException((OMRSAPIResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.captureUserNotAuthorizedException((OMRSAPIResponse)response, error);
        }
        catch (RepositoryErrorException error) {
            this.captureRepositoryErrorException((OMRSAPIResponse)response, error);
        }
        catch (Throwable error) {
            this.captureThrowable((OMRSAPIResponse)response, error, "getRemoteRegistrations", instanceHandler.getAuditLog(userId, serverName, "getRemoteRegistrations"));
        }
        log.debug("Returning from method: getRemoteRegistrations with response: " + response.toString());
        return response;
    }

    private OMRSMetadataHighwayManager getMetadataHighway(String userId, String serverName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, RepositoryErrorException {
        OMRSRepositoryServicesInstance instance;
        OMRSMetadataHighwayManager metadataHighwayManager = null;
        if (serverName != null && (instance = instanceHandler.getInstance(userId, serverName, methodName)) != null) {
            metadataHighwayManager = instance.getMetadataHighwayManager();
        }
        if (metadataHighwayManager == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NO_METADATA_HIGHWAY;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{methodName});
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), this.getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        return metadataHighwayManager;
    }

    private void captureUserNotAuthorizedException(OMRSAPIResponse response, UserNotAuthorizedException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureRepositoryErrorException(OMRSAPIResponse response, RepositoryErrorException error) {
        this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
    }

    private void captureInvalidParameterException(OMRSAPIResponse response, InvalidParameterException error) {
        String propertyName = "parameterName";
        if (error.getParameterName() == null) {
            this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName());
        } else {
            HashMap<String, Object> exceptionProperties = new HashMap<String, Object>();
            exceptionProperties.put("parameterName", error.getParameterName());
            this.captureCheckedException(response, (OMRSCheckedExceptionBase)error, ((Object)((Object)error)).getClass().getName(), exceptionProperties);
        }
    }

    private void captureThrowable(OMRSAPIResponse response, Throwable error, String methodName, OMRSAuditLog auditLog) {
        OMRSErrorCode errorCode = OMRSErrorCode.UNEXPECTED_EXCEPTION;
        String message = error.getMessage();
        if (message == null) {
            message = "null";
        }
        response.setRelatedHTTPCode(errorCode.getHTTPErrorCode());
        response.setExceptionClassName(error.getClass().getName());
        response.setExceptionErrorMessage(errorCode.getFormattedErrorMessage(new String[]{error.getClass().getName(), methodName, message}));
        response.setExceptionSystemAction(errorCode.getSystemAction());
        response.setExceptionUserAction(errorCode.getUserAction());
        response.setExceptionProperties(null);
        if (auditLog != null) {
            StringWriter stackTrace = new StringWriter();
            error.printStackTrace(new PrintWriter(stackTrace));
            OMRSAuditCode auditCode = OMRSAuditCode.UNEXPECTED_EXCEPTION;
            auditLog.logRecord(methodName, auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{error.getClass().getName(), methodName, message, stackTrace.toString()}), null, auditCode.getSystemAction(), auditCode.getUserAction());
        }
    }

    private void captureCheckedException(OMRSAPIResponse response, OMRSCheckedExceptionBase error, String exceptionClassName) {
        this.captureCheckedException(response, error, exceptionClassName, null);
    }

    private void captureCheckedException(OMRSAPIResponse response, OMRSCheckedExceptionBase error, String exceptionClassName, Map<String, Object> exceptionProperties) {
        response.setRelatedHTTPCode(error.getReportedHTTPCode());
        response.setExceptionClassName(exceptionClassName);
        response.setExceptionErrorMessage(error.getErrorMessage());
        response.setExceptionSystemAction(error.getReportedSystemAction());
        response.setExceptionUserAction(error.getReportedUserAction());
        response.setExceptionProperties(exceptionProperties);
    }
}

